package com.shr.controller;

import com.kingdee.shr.sso.client.ltpa.LtpaTokenManager;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;

/**
 * @author Lnori
 */
@RestController
@RequestMapping("/api")
public class EasController {

    @GetMapping(value = "/eas/ssoLogin")
    public void easSsoLogin(HttpServletResponse response) throws IOException {
        //从EAS服务器上下载     server\profiles\server(1...n)\config\portalConfig\LtpaToken.properties
        File file2 = new File("src/main/resources/LtpaToken.properties");
        String configPath = file2.getAbsolutePath();

        //要跳转的url '//'代表首页
        String redirectTo = "//";
        //调用LtpaTokenManager,根据密钥生成用户令牌
        String username = "administrator";
        String password = LtpaTokenManager.generate(username, LtpaTokenManager.getDefaultLtpaConfig()).toString();
        System.out.println("password: " + password);

        //生成EAS单点登录地址
        String url = "http://192.168.2.219:6888/portal/index2sso.jsp?username=" + username + "&password=" + password + "&redirectTo=" + redirectTo + "&isNotCheckRelogin=true";
        //验证Token
        LtpaTokenManager.isValid(password);
        System.out.println(url);

        response.sendRedirect(url);
    }

    @GetMapping(value = "/shr/ssoLogin")
    public void shrSsoLogin(HttpServletResponse response) throws IOException {
        //s-HR地址
        String shrLocal = "http://127.0.0.1:6888/shr/home.do";
        String redirectTo = URLEncoder.encode(shrLocal);

        //登陆用户名
        String username = "user";
        //根据密钥生成的密码串
        String password = LtpaTokenManager.generate(username, LtpaTokenManager.getDefaultLtpaConfig(), "OTP").toString();
        System.out.println("password: " + password);

        //生成SHR单点登录地址
        String url = "http://192.168.2.219:6888/shr/OTP2sso.jsp?username=" + username + "&password=" + password + "&redirectTo=" + redirectTo + "&userAuthPattern=OTP&isNotCheckRelogin=true";
        //验证Token
        LtpaTokenManager.isValid(password);
        System.out.println(url);

        response.sendRedirect(url);
    }


}
