package com.shr.serivce.impl;

import com.kingdee.shr.api.Response;
import com.shr.api.CallShrOsfApi;
import com.shr.common.response.RestResponse;
import com.shr.serivce.IPositionService;
import com.shr.transfer.position.*;
import com.shr.utils.JsonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Inori
 */
@Service
public class PositionServiceImpl implements IPositionService {

    @Autowired
    private CallShrOsfApi callShrOsfApi;


    @Override
    public PositionListOutVo positionList(PositionListInVo inVo) {
        Response response = callShrOsfApi.callShrOsf("inteOAGetPositionDataService", null);

        PositionListOutVo outVo = new PositionListOutVo();
        outVo.setRecords(JsonUtil.toList(JsonUtil.toString(response.getData()), Object.class));
        return outVo;
    }

    @Override
    public PositionJobListOutVo positionJobList(PositionJobListInVo inVo) {
        Response response = callShrOsfApi.callShrOsf("inteOAGetJobRelatedDataService", null);

        PositionJobListOutVo outVo = new PositionJobListOutVo();
        outVo.setRecords(JsonUtil.toList(JsonUtil.toString(response.getData()), Object.class));
        return outVo;
    }

    @Override
    public RestResponse positionAddOrUpdate(PositionInVo inVo) {
        Map<String, Object> map = new HashMap<>(6);
        map.put("positon_name", inVo.getPositonName());
        map.put("positon_number", inVo.getPositonNumber());
        map.put("orgNumber", inVo.getOrgNumber());
        map.put("parentPosNumber", inVo.getParentPosNumber());
        map.put("isRespPosition", inVo.getIsRespPosition());
        map.put("positon_domain", inVo.getPositonDomain());

        callShrOsfApi.callShrOsf("synPositionToSHRService", map);
        return RestResponse.success();
    }


}
