/*
 * Decompiled with CFR 0.152.
 */
package org.eetrust.security.client.core;

import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eetrust.security.client.util.CommonUtils;
import org.eetrust.security.client.util.StringUtils;

public abstract class AbstractConfigurationFilter
implements Filter {
    protected final Log log = LogFactory.getLog(this.getClass());
    private boolean ignoreInitConfiguration = false;
    protected static final String DEFAULT_PATH_SEPARATOR = ";";
    protected String pathSeparator = ";";
    public String[] excludeInterceptURL;

    protected final String getPropertyFromInitParams(FilterConfig filterConfig, String propertyName, String defaultValue) {
        String value = filterConfig.getInitParameter(propertyName);
        if (CommonUtils.isNotBlank(value)) {
            this.log.info((Object)("Property [" + propertyName + "] loaded from FilterConfig.getInitParameter with value [" + value + "]"));
            return value;
        }
        value = filterConfig.getServletContext().getInitParameter(propertyName);
        if (CommonUtils.isNotBlank(value)) {
            this.log.info((Object)("Property [" + propertyName + "] loaded from ServletContext.getInitParameter with value [" + value + "]"));
            return value;
        }
        this.log.info((Object)("Property [" + propertyName + "] not found. Using default value [" + defaultValue + "]"));
        return defaultValue;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String excludeInterceptURL = this.getPropertyFromInitParams(filterConfig, "excludeInterceptURL", "");
        if (!StringUtils.isEmpty(excludeInterceptURL)) {
            this.log.info((Object)("Loading excludeInterceptURL parameter name property: " + excludeInterceptURL));
            this.setExcludeInterceptURL(StringUtils.tokenizeToStringArray(excludeInterceptURL, this.pathSeparator));
        }
    }

    protected final boolean parseBoolean(String value) {
        return value != null && value.equalsIgnoreCase("true");
    }

    protected final int parseInteger(String value) {
        return !CommonUtils.isEmpty(value) ? Integer.parseInt(value) : 0;
    }

    public final void setIgnoreInitConfiguration(boolean ignoreInitConfiguration) {
        this.ignoreInitConfiguration = ignoreInitConfiguration;
    }

    protected final boolean isIgnoreInitConfiguration() {
        return this.ignoreInitConfiguration;
    }

    public String[] getExcludeInterceptURL() {
        return this.excludeInterceptURL;
    }

    public void setExcludeInterceptURL(String[] excludeInterceptURL) {
        this.excludeInterceptURL = excludeInterceptURL;
    }
}

