package com.shr.controller;

import com.shr.annotion.AccessLog;
import com.shr.common.response.RestResponse;
import com.shr.serivce.IPositionService;
import com.shr.transfer.position.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@RestController
@RequestMapping("/api")
public class PositionController {

    @Autowired
    private IPositionService positionService;

    @AccessLog("岗位列表")
    @GetMapping("/position/list")
    public RestResponse positionList(@RequestBody(required = true) @Validated PositionListInVo inVo) {
        PositionListOutVo outVo = positionService.positionList(inVo);
        return RestResponse.success(outVo);
    }

    @AccessLog("职位列表")
    @GetMapping("/position/job/list")
    public RestResponse positionJobList(@RequestBody(required = true) @Validated PositionJobListInVo inVo) {
        PositionJobListOutVo outVo = positionService.positionJobList(inVo);
        return RestResponse.success(outVo);
    }

    @AccessLog("岗位录入")
    @PostMapping("/position/add")
    public RestResponse positionAdd(@RequestBody(required = true) @Validated PositionInVo inVo) {
        return positionService.positionAddOrUpdate(inVo);
    }

    @AccessLog("岗位编辑")
    @PostMapping("/position/update")
    public RestResponse positionUpdate(@RequestBody(required = true) @Validated PositionInVo inVo) {
        return positionService.positionAddOrUpdate(inVo);
    }


}
