/*
 * Decompiled with CFR 0.152.
 */
package org.eetrust.security.client.session;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eetrust.security.client.session.HashMapBackedSessionMappingStorage;
import org.eetrust.security.client.session.SessionMappingStorage;
import org.eetrust.security.client.util.CommonUtils;
import org.eetrust.security.client.util.XmlUtils;

public class SingleSignOutHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private SessionMappingStorage sessionMappingStorage = new HashMapBackedSessionMappingStorage();
    private String ticketParameterName = "ticket";
    private String logoutParameterName = "logoutRequest";

    public void setSessionMappingStorage(SessionMappingStorage storage) {
        this.sessionMappingStorage = storage;
    }

    public SessionMappingStorage getSessionMappingStorage() {
        return this.sessionMappingStorage;
    }

    public String getTicketParameterName() {
        return this.ticketParameterName;
    }

    public void setTicketParameterName(String name) {
        this.ticketParameterName = name;
    }

    public String getLogoutParameterName() {
        return this.logoutParameterName;
    }

    public void setLogoutParameterName(String name) {
        this.logoutParameterName = name;
    }

    public void init() {
        CommonUtils.assertNotNull(this.ticketParameterName, "ticketParameterName cannot be null.");
        CommonUtils.assertNotNull(this.logoutParameterName, "logoutParameterName cannot be null.");
        CommonUtils.assertNotNull(this.sessionMappingStorage, "sessionMappingStorage cannote be null.");
    }

    public boolean isTokenRequest(HttpServletRequest request) {
        return CommonUtils.isNotBlank(CommonUtils.safeGetParameter(request, this.ticketParameterName));
    }

    public boolean isLogoutRequest(HttpServletRequest request) {
        return "POST".equals(request.getMethod()) && CommonUtils.isNotBlank(CommonUtils.safeGetParameter(request, this.logoutParameterName));
    }

    public void recordSession(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        String token = CommonUtils.safeGetParameter(request, this.ticketParameterName);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Recording session for token " + token));
        }
        try {
            this.sessionMappingStorage.removeBySessionById(session.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sessionMappingStorage.addSessionById(CommonUtils.safeGetParameter(request, this.ticketParameterName), session);
    }

    public void destroySession(HttpServletRequest request) {
        HttpSession session;
        String token;
        String logoutMessage = CommonUtils.safeGetParameter(request, this.logoutParameterName);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Logout request:\n" + logoutMessage));
        }
        if (CommonUtils.isNotBlank(token = XmlUtils.getTextForElement(logoutMessage, "SessionIndex")) && (session = this.sessionMappingStorage.removeSessionByMappingId(token)) != null) {
            String sessionID = session.getId();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Invalidating session [" + sessionID + "] for token [" + token + "]"));
            }
            try {
                session.invalidate();
            }
            catch (IllegalStateException e) {
                this.log.debug((Object)"Error invalidating session.", (Throwable)e);
            }
        }
    }
}

