/*
 * Decompiled with CFR 0.152.
 */
package org.eetrust.security.client.validation;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eetrust.security.client.core.AbstractKernelFilter;
import org.eetrust.security.client.util.CommonUtils;
import org.eetrust.security.client.util.PathMatcher;
import org.eetrust.security.client.util.URLPathMatcher;
import org.eetrust.security.client.validation.Assertion;
import org.eetrust.security.client.validation.TicketValidationException;
import org.eetrust.security.client.validation.TicketValidator;

public class AbstractTicketValidationFilter
extends AbstractKernelFilter {
    private TicketValidator ticketValidator;
    private boolean redirectAfterValidation = false;
    private boolean exceptionOnValidationFailure = true;
    private boolean useSession = true;
    private static final PathMatcher pathMatcher = new URLPathMatcher();

    protected TicketValidator getTicketValidator(FilterConfig filterConfig) {
        return this.ticketValidator;
    }

    @Override
    protected void initInternal(FilterConfig filterConfig) throws ServletException {
        this.setTicketValidator(this.getTicketValidator(filterConfig));
        this.setExceptionOnValidationFailure(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "exceptionOnValidationFailure", "true")));
        this.log.info((Object)("Setting exceptionOnValidationFailure parameter: " + this.exceptionOnValidationFailure));
        this.setRedirectAfterValidation(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "redirectAfterValidation", "false")));
        this.log.info((Object)("Setting redirectAfterValidation parameter: " + this.redirectAfterValidation));
        this.setUseSession(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "useSession", "true")));
        this.log.info((Object)("Setting useSession parameter: " + this.useSession));
        super.initInternal(filterConfig);
    }

    @Override
    public void init() {
        super.init();
        CommonUtils.assertNotNull(this.ticketValidator, "ticketValidator cannot be null.");
    }

    protected boolean preFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        return true;
    }

    protected void onSuccessfulValidation(HttpServletRequest request, HttpServletResponse response, Assertion assertion) {
    }

    protected void onFailedValidation(HttpServletRequest request, HttpServletResponse response) {
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String ticket;
        String[] excludeInterceptURL;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String url = request.getRequestURI();
        int firstQuestionMarkIndex = url.indexOf("?");
        if (firstQuestionMarkIndex != -1) {
            url = url.substring(0, firstQuestionMarkIndex);
        }
        if ((excludeInterceptURL = this.getExcludeInterceptURL()) != null && excludeInterceptURL.length > 0) {
            int i = 0;
            while (i < excludeInterceptURL.length) {
                boolean matched = pathMatcher.match(excludeInterceptURL[i], url);
                if (matched) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                ++i;
            }
        }
        if (CommonUtils.isNotBlank(ticket = CommonUtils.safeGetParameter(request, this.getTicketParameterName()))) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Attempting to validate ticket: " + ticket));
            }
            try {
                Assertion assertion = this.ticketValidator.validate(ticket);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Successfully authenticated user: " + assertion.getPrincipal().getName()));
                }
                request.setAttribute("_const_uap_assertion_", (Object)assertion);
                if (this.useSession) {
                    request.getSession().setAttribute("_const_uap_assertion_", (Object)assertion);
                }
                this.onSuccessfulValidation(request, response, assertion);
                if (this.redirectAfterValidation) {
                    String redirectUrl;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Redirecting after successful ticket validation.");
                    }
                    if (CommonUtils.isNotBlank(redirectUrl = request.getParameter(this.getServiceParameterName()))) {
                        response.sendRedirect(redirectUrl);
                        return;
                    }
                }
            }
            catch (TicketValidationException e) {
                response.setStatus(403);
                this.log.warn((Object)e, (Throwable)e);
                this.onFailedValidation(request, response);
                if (this.exceptionOnValidationFailure) {
                    throw new ServletException((Throwable)e);
                }
                return;
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public final void setTicketValidator(TicketValidator ticketValidator) {
        this.ticketValidator = ticketValidator;
    }

    public final void setRedirectAfterValidation(boolean redirectAfterValidation) {
        this.redirectAfterValidation = redirectAfterValidation;
    }

    public final void setExceptionOnValidationFailure(boolean exceptionOnValidationFailure) {
        this.exceptionOnValidationFailure = exceptionOnValidationFailure;
    }

    public final void setUseSession(boolean useSession) {
        this.useSession = useSession;
    }
}

