/*
 * Decompiled with CFR 0.152.
 */
package org.eetrust.security.client.authentication;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eetrust.security.client.core.AbstractKernelFilter;
import org.eetrust.security.client.util.CommonUtils;
import org.eetrust.security.client.util.PathMatcher;
import org.eetrust.security.client.util.URLPathMatcher;
import org.eetrust.security.client.validation.Assertion;

public class AuthenticationFilter
extends AbstractKernelFilter {
    private String serverLoginUrl;
    private String serverName;
    private String service;
    private boolean encodeServiceUrl = true;
    private static final PathMatcher pathMatcher = new URLPathMatcher();

    @Override
    protected void initInternal(FilterConfig filterConfig) throws ServletException {
        if (!this.isIgnoreInitConfiguration()) {
            this.setServerLoginUrl(this.getPropertyFromInitParams(filterConfig, "serverLoginUrl", null));
            this.log.info((Object)("Loaded serverLoginUrl parameter: " + this.serverLoginUrl));
            this.setServerName(this.getPropertyFromInitParams(filterConfig, "serverName", null));
            this.log.info((Object)("Loading serverName property: " + this.serverName));
            this.setService(this.getPropertyFromInitParams(filterConfig, "service", null));
            this.log.info((Object)("Loading service property: " + this.service));
            this.setEncodeServiceUrl(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "encodeServiceUrl", "true")));
            this.log.info((Object)("Loading encodeServiceUrl property: " + this.encodeServiceUrl));
            super.initInternal(filterConfig);
        }
    }

    @Override
    public void init() {
        super.init();
        CommonUtils.assertNotNull(this.serverLoginUrl, "serverLoginUrl cannot be null.");
        CommonUtils.assertTrue(CommonUtils.isNotEmpty(this.serverName) || CommonUtils.isNotEmpty(this.service), "serverName or service must be set.");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpSession session;
        Assertion assertion;
        String[] excludeInterceptURL;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String url = request.getRequestURI();
        int firstQuestionMarkIndex = url.indexOf("?");
        if (firstQuestionMarkIndex != -1) {
            url = url.substring(0, firstQuestionMarkIndex);
        }
        if ((excludeInterceptURL = this.getExcludeInterceptURL()) != null && excludeInterceptURL.length > 0) {
            int i = 0;
            while (i < excludeInterceptURL.length) {
                boolean matched = pathMatcher.match(excludeInterceptURL[i], url);
                if (matched) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                ++i;
            }
        }
        Assertion assertion2 = assertion = (session = request.getSession(false)) != null ? (Assertion)session.getAttribute("_const_uap_assertion_") : null;
        if (assertion != null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String ticket = CommonUtils.safeGetParameter(request, this.getTicketParameterName());
        if (CommonUtils.isNotBlank(ticket)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String serviceUrl = CommonUtils.constructServiceUrl(request, response, this.service, this.serverName, this.getTicketParameterName(), this.encodeServiceUrl);
        String redirectURL = CommonUtils.constructRedirectUrl(this.serverLoginUrl, this.getServiceParameterName(), serviceUrl, this.getResourceCode());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Redirecting to \"" + redirectURL + "\""));
        }
        response.sendRedirect(redirectURL);
    }

    public final void setServerLoginUrl(String serverLoginUrl) {
        this.serverLoginUrl = serverLoginUrl;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setEncodeServiceUrl(boolean encodeServiceUrl) {
        this.encodeServiceUrl = encodeServiceUrl;
    }
}

