/*
 * Decompiled with CFR 0.152.
 */
package com.eetrust.security.plugin;

import com.eetrust.security.crypto.EncoderException;
import com.eetrust.security.crypto.Secure3DES;
import com.eetrust.security.plugin.HttpUtils;
import com.eetrust.security.plugin.RequestException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MessageRequest {
    private final String ENCRYPT_SECRET_KEY = "JIeP74SA0cLl1nTtB8i8GlNS";
    private final String ENCRYPT_IV = "PkWBK2iS";
    private String serverIp;
    private int serverPort;
    private String serverName;
    private String communicationProtocol;
    private String charset;
    private int timeout = 60000;
    public static final String COMMUNICATION_PROTOCOL_SOCKET = "socket";
    public static final String COMMUNICATION_PROTOCOL_HTTP = "http";
    public static final String COMMUNICATION_PROTOCOL_HTTPS = "https";
    public static final String COMMUNICATION_CHARSET_UTF8 = "UTF-8";
    public static final String COMMUNICATION_CHARSET_GBK = "GBK";

    public MessageRequest(String serverIp, int serverPort, String serverName, String communicationProtocol, String charset) {
        this.serverIp = serverIp;
        this.serverPort = serverPort;
        this.serverName = serverName;
        this.communicationProtocol = communicationProtocol;
        this.charset = charset;
    }

    public String sendMessage(String message) throws EncoderException, RequestException {
        if (message == null || message.trim().length() <= 0) {
            return "";
        }
        message = this.encryptMessage(message);
        return this.serverResponse(message);
    }

    private String serverResponse(String message) throws RequestException {
        String responseMsg;
        block27: {
            HashMap<String, String> params;
            responseMsg = null;
            if (this.communicationProtocol.equals(COMMUNICATION_PROTOCOL_SOCKET)) {
                Socket client = null;
                PrintWriter out = null;
                InputStreamReader in = null;
                BufferedReader reader = null;
                try {
                    try {
                        client = new Socket(this.serverIp, this.serverPort);
                        client.setSoTimeout(this.timeout);
                        out = new PrintWriter(client.getOutputStream(), true);
                        out.println(message);
                        out.flush();
                        in = new InputStreamReader(client.getInputStream(), this.charset);
                        reader = new BufferedReader(in);
                        responseMsg = reader.readLine();
                        break block27;
                    }
                    catch (UnknownHostException e) {
                        e.printStackTrace();
                        throw new RequestException();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new RequestException();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RequestException();
                    }
                }
                finally {
                    try {
                        if (out != null) {
                            out.close();
                        }
                        if (in != null) {
                            in.close();
                        }
                        if (reader != null) {
                            reader.close();
                        }
                        if (client != null) {
                            client.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            if (this.communicationProtocol.equals(COMMUNICATION_PROTOCOL_HTTP)) {
                params = new HashMap<String, String>();
                params.put("reqMessage", message);
                try {
                    String url = "http://" + this.serverIp + ":" + this.serverPort + "/communication/secureMessage";
                    if (this.serverName != null && this.serverName.trim().length() > 0) {
                        url = "http://" + this.serverIp + ":" + this.serverPort + "/" + this.serverName + "/communication/secureMessage";
                    }
                    responseMsg = HttpUtils.URLPost(url, params, this.charset);
                }
                catch (RequestException e) {
                    throw new RequestException();
                }
            }
            if (this.communicationProtocol.equals(COMMUNICATION_PROTOCOL_HTTPS)) {
                params = new HashMap();
                params.put("reqMessage", message);
                try {
                    String url = "https://" + this.serverIp + ":" + this.serverPort + "/communication/secureMessage";
                    if (this.serverName != null && this.serverName.trim().length() > 0) {
                        url = "https://" + this.serverIp + ":" + this.serverPort + "/" + this.serverName + "/communication/secureMessage";
                    }
                    responseMsg = HttpUtils.URLPost(url, params, this.charset, true, this.serverPort);
                }
                catch (RequestException e) {
                    throw new RequestException();
                }
            }
        }
        if (responseMsg == null || responseMsg.trim().length() <= 0) {
            throw new RequestException();
        }
        try {
            responseMsg = this.checkMessage(responseMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RequestException();
        }
        return responseMsg;
    }

    public String checkMessage(String respMessage) throws EncoderException {
        Pattern p = Pattern.compile("\\s*|\t|\r|\n");
        Matcher m = p.matcher(respMessage);
        respMessage = m.replaceAll("");
        Secure3DES secure3DES = new Secure3DES();
        secure3DES.decrypt(respMessage, "JIeP74SA0cLl1nTtB8i8GlNS", "PkWBK2iS");
        respMessage = secure3DES.getPlainText();
        return respMessage;
    }

    public String encryptMessage(String reqMessage) throws EncoderException {
        Secure3DES secure3DES = new Secure3DES();
        secure3DES.encrypt(reqMessage, "JIeP74SA0cLl1nTtB8i8GlNS", "PkWBK2iS");
        reqMessage = secure3DES.getCipherText();
        return reqMessage;
    }
}

