/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.sso.client.util;

import com.kingdee.shr.sso.client.ltpa.LtpaTokenManager;
import com.kingdee.shr.sso.client.user.IUserNameBuilder;
import com.kingdee.shr.sso.client.util.UrlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class SSOUtil {
    private static final String EMPTY = "";
    private static final String SSO_CONFIG = "/WEB-INF/shr-ssoClient.properties";
    private static Properties properties = null;

    public static String generateUrl(HttpServletRequest request) {
        return SSOUtil.generateUrl(request, null);
    }

    public static String generateUrl(HttpServletRequest request, String serverUrl) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        SSOUtil.assembleLoginParameters(request, parameters);
        System.out.println("----username--" + parameters.get("username"));
        if (parameters.get("username") == null || "null".equals((String)parameters.get("username")) || EMPTY.equals((String)parameters.get("username"))) {
            return "userNameIsNull";
        }
        String loginUrl = SSOUtil.getLoginUrl(request, serverUrl);
        return UrlUtil.assembleUrl(loginUrl, parameters);
    }

    public static Map assembleLoginParameters(HttpServletRequest request, Map parameters) {
        String callback;
        String redirectTo;
        Properties properties;
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        if ((properties = SSOUtil.getConfig(request)) != null) {
            String userName = (String)parameters.get("username");
            if (userName == null) {
                userName = SSOUtil.getUserName(request, properties);
            }
            parameters.put("username", userName);
            if (userName != null) {
                String authPattern = properties.getProperty("auth.pattern");
                String password = LtpaTokenManager.generate(userName, LtpaTokenManager.getDefaultLtpaConfig(), authPattern).toString();
                parameters.put("password", password);
            } else {
                System.out.println("\u7528\u6237\u540d\u4e3a\u7a7a");
            }
        }
        if ((redirectTo = request.getParameter("redirectTo")) != null && redirectTo.trim() != null) {
            parameters.put("redirectTo", redirectTo);
        }
        if ((callback = request.getParameter("callback")) != null && callback.trim() != null) {
            parameters.put("callback", callback);
        }
        return parameters;
    }

    public static Properties getConfig(HttpServletRequest request) {
        if (properties != null) {
            return properties;
        }
        ServletContext servletContext = request.getSession().getServletContext();
        InputStream inputStream = servletContext.getResourceAsStream(SSO_CONFIG);
        properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return properties;
    }

    private static String getUserName(HttpServletRequest request, Properties properties) {
        String userNameBuilder = properties.getProperty("userNameBuilder");
        if (userNameBuilder == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(userNameBuilder);
            Object obj = clazz.newInstance();
            if (obj instanceof IUserNameBuilder) {
                return ((IUserNameBuilder)obj).getUserName(request);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getLoginUrl(HttpServletRequest request, String serverUrl) {
        Properties properties = SSOUtil.getConfig(request);
        if (properties == null) {
            return serverUrl;
        }
        if (serverUrl == null) {
            serverUrl = properties.getProperty("server.url");
        }
        String serverPath = properties.getProperty("server.path");
        return String.valueOf(serverUrl) + serverPath;
    }

    public static String getServerUrl(HttpServletRequest request) {
        Properties properties = SSOUtil.getConfig(request);
        String serverUrl = null;
        if (properties != null) {
            serverUrl = properties.getProperty("server.url");
        }
        return serverUrl;
    }
}

