package com.shr.controller;

import com.kingdee.shr.sso.client.ltpa.LtpaTokenManager;
import com.shr.config.ThreadLocalConfig;
import com.shr.utils.StringUtil;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;

/**
 * @author Lnori
 */
@RestController
@RequestMapping("/api")
public class EasController {

    @GetMapping(value = "/eas/ssoLogin")
    public String easSsoLogin(String ssoUsername, String assignmentId) throws IOException {

        System.out.println("assignmentId:" + assignmentId);
        String shrLocal = "http://10.10.12.21:8080/easweb/webviews/workflow/approvenew.jsp?assignmentId=" + assignmentId + "&type=approve";
        if(StringUtil.isBlank(assignmentId))
        {
        	shrLocal = "http://10.10.12.21:8080/shr/home.do";
        }
        String redirectTo = URLEncoder.encode(shrLocal);
        System.out.println("redirectTo:" + redirectTo);

        if (StringUtil.isBlank(ssoUsername)) {
            return "";
        }
        
        String password = LtpaTokenManager.generate(ssoUsername, LtpaTokenManager.getDefaultLtpaConfig()).toString();
        System.out.println("password: " + password);

        //生成EAS单点登录地址
        String url = "http://10.10.12.21:8080/portal/index2sso.jsp?username=" + ssoUsername + "&password=" + password + "&redirectTo=" + redirectTo;
        //验证Token
        //LtpaTokenManager.isValid(password);
        System.out.println(url);
        return url;
    }

    @GetMapping(value = "/shr/ssoLogin")
    public ModelAndView shrSsoLogin(String ssoUsername, String assignmentId) throws IOException {
        //s-HR地址
        System.out.println("assignmentId:" + assignmentId);
        String shrLocal = "http://10.10.12.21:8080/easweb/webviews/workflow/approvenew.jsp?assignmentId=" + assignmentId + "&type=approve";
        if(StringUtil.isBlank(assignmentId))
        {
        	shrLocal = "http://10.10.12.21:8080/shr/home.do";
        }
        String redirectTo = URLEncoder.encode(shrLocal);
        System.out.println("redirectTo:" + redirectTo);

        if (StringUtil.isBlank(ssoUsername)) {
            return new ModelAndView("");
        }
        //String ssoUsername = "administrator";
        //根据密钥生成的密码串
        String password = LtpaTokenManager.generate(ssoUsername, LtpaTokenManager.getDefaultLtpaConfig(), "OTP").toString();
        System.out.println("password: " + password);

        //生成SHR单点登录地址
        String url = "redirect:http://10.10.12.21:8080/shr/OTP2sso.jsp?username=" + ssoUsername + "&password=" + password + "&redirectTo=" + redirectTo + "&userAuthPattern=OTP&timeInMillis=" + System.currentTimeMillis();//&isNotCheckRelogin=false  

        System.out.println(url);

        return new ModelAndView(url);
    }


}
