package com.shr.controller;

import com.shr.annotion.AccessLog;
import com.shr.common.response.RestResponse;
import com.shr.serivce.ILogService;
import com.shr.transfer.log.LogListInVo;
import com.shr.transfer.log.LogListOutVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Inori
 */
@RestController
@RequestMapping("/api")
public class LogController {

    @Autowired
    private ILogService logService;


    @AccessLog("日志列表")
    @PostMapping("/log/list")
    public RestResponse logList(@RequestBody(required = true) @Validated LogListInVo inVo) {
        LogListOutVo outVo = logService.logList(inVo);
        return RestResponse.success(outVo);
    }


}
