package com.shr.controller;

import com.shr.annotion.AccessLog;
import com.shr.common.response.RestResponse;
import com.shr.serivce.IAdminOrgService;
import com.shr.serivce.IToDoTaskService;

import java.sql.ResultSet;
import java.sql.SQLException;

import javax.servlet.jsp.jstl.sql.Result;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.shr.utils.*;

/**
 * @author Inori
 */
@RestController
@RequestMapping("/api")
public class ToDoTaskController {

	@Autowired
	DataSourceProperties dataSource;
    @Autowired
    private IToDoTaskService toDoTaskService;

	
    @AccessLog("待办任务列表总数")
    @GetMapping("/assign")
    public RestResponse toDoTaskList() {
    	DBHelper dbHelper = new DBHelper(dataSource);
    	Result result = dbHelper.executeQuery("select T0.FASSIGNID, T0.FSUBJECT_L1 || ' ' || T0.FPRIORPERFORMERNAME_L1 || '的' || T0.FPROCDEFNAME_L1 FSUBJECT_L1,  TO_CHAR(T0.FCreatedTime, 'YYYY-MM-DD hh24:mi:ss') FCreatedTime, T1.FNUMBER FUserNumber, T2.FNUMBER FUserNumber2 from t_wfr_assign_view T0 inner join t_pm_user T1 on T0.FPERSONUSERID = T1.FID inner join t_pm_user T2 on T0.FPRIORPERFORMER = T2.FID");
    	toDoTaskService.toDoTaskList(result);
    	
        return RestResponse.success("同步成功");
    }

    @AccessLog("待办任务明细列表")
    @GetMapping("/assigndetial")
    public RestResponse toDoTaskDetailList() {
    	DBHelper dbHelper = new DBHelper(dataSource);
    	Result result = dbHelper.executeQuery("select ID from t_wfr_assignSendInfo");
    	toDoTaskService.toDoTaskDetailList(result);
        return RestResponse.success("同步成功");
    }
}
