package com.shr.transfer.task;

import java.sql.ResultSet;

import javax.servlet.jsp.jstl.sql.Result;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;

import com.shr.annotion.AccessLog;
import com.shr.common.response.RestResponse;
import com.shr.serivce.IToDoTaskService;
import com.shr.utils.DBHelper;

import cn.hutool.core.lang.Console;

@EnableScheduling
@Component
public class ToDoTaskJob {

	@Autowired
	DataSourceProperties dataSource;
    @Autowired
    private IToDoTaskService toDoTaskService;


    @Scheduled(fixedDelay = 1000 * 10)
    public RestResponse toDoTaskList() {
    	Console.log("定时器开始 toDoTaskList！");
    	DBHelper dbHelper = new DBHelper(dataSource);
    	dbHelper.executeUpdate("insert into t_wfr_assignSendInfo(ID, ISSEND, ISUPDATE) select FASSIGNID, '0', '0' from t_wfr_assign_view where FASSIGNID not in (select ID from t_wfr_assignSendInfo)", null);
    	
    	dbHelper = new DBHelper(dataSource);
    	Result result = dbHelper.executeQuery("select T0.FASSIGNID,  T0.FSUBJECT_L1 || ' ' || T0.FPRIORPERFORMERNAME_L1 || '的' || T0.FPROCDEFNAME_L1 FSUBJECT_L1,  TO_CHAR(T0.FCreatedTime, 'YYYY-MM-DD hh24:mi:ss') FCreatedTime, T1.FNUMBER FUserNumber, T2.FNUMBER FUserNumber2 from t_wfr_assign_view T0 inner join t_pm_user T1 on T0.FPERSONUSERID = T1.FID inner join t_pm_user T2 on T0.FPRIORPERFORMER = T2.FID where FASSIGNID in (select ID from t_wfr_assignSendInfo where ISSEND = '0')");
		
    	toDoTaskService.toDoTaskList(result);
    	dbHelper = new DBHelper(dataSource);
    	dbHelper.executeUpdate("update t_wfr_assignSendInfo set ISSEND = '1' where ISSEND = '0'", null);
    	
    	dbHelper = new DBHelper(dataSource);
    	result = dbHelper.executeQuery("select ID from t_wfr_assignSendInfo where ISSEND = '1' and ISUPDATE = '0' and ID not in (select FASSIGNID from t_wfr_assign_view)", null);
		
    	toDoTaskService.toDoTaskDetailList(result);
    	dbHelper = new DBHelper(dataSource);
    	dbHelper.executeUpdate("delete t_wfr_assignSendInfo where ID not in (select FASSIGNID from t_wfr_assign_view)", null);

    	Console.log("定时器结束 toDoTaskList！");
        return RestResponse.success("同步成功");
    }
}
