package com.shr.utils;

import java.io.*;
import java.sql.*;
import java.util.*;
import javax.servlet.jsp.jstl.sql.*;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;

import cn.hutool.core.lang.Console;

public class DBHelper {

private Connection con;  //连接对象
	public void setCon(Connection con) {
	this.con = con;
}

	public DBHelper(DataSourceProperties dataSource){
		this.con=getConnection(dataSource);  //给Connection的对象赋初值
	}
	
	/**
	 * 获取数据库连接
	 * @return
	 */
    private  Connection getConnection(DataSourceProperties dataSource){ 
 
    	String driver_class=null;
    	String driver_url=null;
    	String database_user=null;
    	String database_password=null;
    	try {    		
    		driver_class=dataSource.getDriverClassName();      //获取数据库配置文件
    		driver_url=dataSource.getUrl();
    		database_user=dataSource.getUsername();
    		database_password=dataSource.getPassword();
    
			Class.forName(driver_class);
			con=DriverManager.getConnection(driver_url,database_user,database_password);
			
			
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return con;
    }
    
  
    

    /**
     * 关闭数据库
     * @param con
     * @param pst
     * @param rst
     */
    private  void closeAll(Connection con,PreparedStatement pst,ResultSet rst){
    	if(rst!=null){
    		try {
				rst.close();
			} catch (SQLException e) {
		    	Console.log("ResultSet关闭！");
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
    	}
    	
    	if(pst!=null){
    		try {
				pst.close();
			} catch (SQLException e) {
		    	Console.log("PreparedStatement关闭！");
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
    	}
    	
    	if(con!=null){
    		try {
				con.close();
			} catch (SQLException e) {
		    	Console.log("Connection关闭！");
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
    	}
    	
    	
    }
    
    public  Result executeQuery(String sql)
    {
    	return this.executeQuery(sql, null);
    }
    
    /**
     * 查找
     * @param sql
     * @param sqlValues
     * @return
     */
    public  Result executeQuery(String sql,  List sqlValues){
    	Result result=null;
    	ResultSet rst=null;
    	PreparedStatement pst=null;
    	try {
    	
			pst=con.prepareStatement(sql);
			if(sqlValues!=null&&sqlValues.size()>0){  //当sql语句中存在占位符时
				setSqlValues(pst,sqlValues);
			}
		    rst=pst.executeQuery();
		    result=ResultSupport.toResult(rst);  //一定要在关闭数据库之前完成转换			
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}finally{
			this.closeAll(con, pst, rst);
		}
		
    	return result;
    }
    
    public int executeUpdate(String sql)
    {
    	
    	return this.executeUpdate(sql, null);
    }
    
    /**
     * 增删改
     * @return
     */
    public int executeUpdate(String sql,  List sqlValues){
    	int result=-1;
    	PreparedStatement pst=null;
        try {
			pst=con.prepareStatement(sql);
			if(sqlValues!=null&&sqlValues.size()>0){  //当sql语句中存在占位符时
				setSqlValues(pst,sqlValues);
			}
			result=pst.executeUpdate();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}finally{
			this.closeAll(con, pst, null);
		}
    
    	
    	return result;
    }
    
    
    
    /**
     * 给sql语句中的占位符赋值
     * @param pst
     * @param sqlValues
     */
    private void setSqlValues(PreparedStatement pst,List sqlValues){
    	for(int i=0;i<sqlValues.size();i++){
    		try {
				pst.setObject(i+1,sqlValues.get(i));
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
    	}
    }
}