package org.jeecg.modules.iost.ims.controller;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.iost.ims.entity.ImsSalesreturn;
import org.jeecg.modules.iost.ims.service.IImsSalesreturnService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

 /**
 * @Description: 销售退货 --出货冲销收料类型
 * @Author: jeecg-boot
 * @Date:   2021-10-08
 * @Version: V1.0
 */
@Api(tags="销售退货 --出货冲销收料类型")
@RestController
@RequestMapping("/imsSalesreturn")
@Slf4j
public class ImsSalesreturnController extends JeecgController<ImsSalesreturn, IImsSalesreturnService> {
	@Autowired
	private IImsSalesreturnService imsSalesreturnService;
	
	/**
	 * 分页列表查询
	 *
	 * @param imsSalesreturn
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@AutoLog(value = "销售退货 --出货冲销收料类型-分页列表查询")
	@ApiOperation(value="销售退货 --出货冲销收料类型-分页列表查询", notes="销售退货 --出货冲销收料类型-分页列表查询")
	@GetMapping(value = "/list")
	public Result<?> queryPageList(ImsSalesreturn imsSalesreturn,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req,String date) {
		QueryWrapper<ImsSalesreturn> queryWrapper = QueryGenerator.initQueryWrapper(imsSalesreturn, req.getParameterMap()).orderByDesc("create_time");
		Page<ImsSalesreturn> page = new Page<ImsSalesreturn>(pageNo, pageSize);
		if(!"null".equals(date)){
			SimpleDateFormat sdf1 =new SimpleDateFormat("yyyy-MM-dd" );
			Date parse = null;
			try {
				parse = sdf1.parse(date);
			} catch (ParseException e) {
				e.printStackTrace();
			}
			//根据查询日期拿到明天
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(parse);
			calendar.add(Calendar.DATE,1);
			String parse1=sdf1.format(calendar.getTime());
			queryWrapper.gt("create_time",parse);
			queryWrapper.lt("create_time",parse1);
		}
		IPage<ImsSalesreturn> pageList = imsSalesreturnService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param imsSalesreturn
	 * @return
	 */
	@AutoLog(value = "销售退货 --出货冲销收料类型-添加")
	@ApiOperation(value="销售退货 --出货冲销收料类型-添加", notes="销售退货 --出货冲销收料类型-添加")
	@PostMapping(value = "/add")
	public Result<?> add(@RequestBody ImsSalesreturn imsSalesreturn) {
		imsSalesreturnService.save(imsSalesreturn);
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param imsSalesreturn
	 * @return
	 */
	@AutoLog(value = "销售退货 --出货冲销收料类型-编辑")
	@ApiOperation(value="销售退货 --出货冲销收料类型-编辑", notes="销售退货 --出货冲销收料类型-编辑")
	@PutMapping(value = "/edit")
	public Result<?> edit(@RequestBody ImsSalesreturn imsSalesreturn) {
		imsSalesreturnService.updateById(imsSalesreturn);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "销售退货 --出货冲销收料类型-通过id删除")
	@ApiOperation(value="销售退货 --出货冲销收料类型-通过id删除", notes="销售退货 --出货冲销收料类型-通过id删除")
	@DeleteMapping(value = "/delete")
	public Result<?> delete(@RequestParam(name="id",required=true) String id) {
		imsSalesreturnService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "销售退货 --出货冲销收料类型-批量删除")
	@ApiOperation(value="销售退货 --出货冲销收料类型-批量删除", notes="销售退货 --出货冲销收料类型-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.imsSalesreturnService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "销售退货 --出货冲销收料类型-通过id查询")
	@ApiOperation(value="销售退货 --出货冲销收料类型-通过id查询", notes="销售退货 --出货冲销收料类型-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<?> queryById(@RequestParam(name="id",required=true) String id) {
		ImsSalesreturn imsSalesreturn = imsSalesreturnService.getById(id);
		if(imsSalesreturn==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(imsSalesreturn);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param imsSalesreturn
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, ImsSalesreturn imsSalesreturn) {
        return super.exportXls(request, imsSalesreturn, ImsSalesreturn.class, "销售退货 --出货冲销收料类型");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, ImsSalesreturn.class);
    }

}
