package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.*;
/**
 * 查询金蝶云物料清单信息
 */
@Component
public class    BomKingdeeApi implements web_api {
    /**操作的单据体名称*/
    private String sFormId = "ENG_BOM";//物料清单
    @Autowired
    private CategoryDao categoryDao;
    private Map<String,String> key = new LinkedHashMap<>();
    public BomKingdeeApi(){
        /*查询字段*/
        key.put("FID","FID");//单据头实体主键
        key.put("FMATERIALID.Fnumber","FMATERIALID.Fnumber");//父项物料编码
        key.put("FMATERIALIDCHILD.Fnumber","FMATERIALIDCHILD.Fnumber");//子项物料编码
        key.put("FPOSITIONNO","FPOSITIONNO");//位置号
        key.put("FParentRowId","FParentRowId");//父级行主键
        key.put("FIskeyItem","FIskeyItem");//替代主料
        key.put("FNUMERATOR","FNUMERATOR");//子项明细-用量分子
        key.put("FDENOMINATOR","FDENOMINATOR");//子项明细-用量分母
    }
    @Override
    public String add(Map<String, Object> maps) {
        return null;
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        return null;
    }
    /**
     * 分页查询
     * @param map
     * @param where
     * @return
     * @throws ParseException
     */

    public List<Map<String, String>> queryList(Map<String, String> map, String where,String name,Integer pageNo,Integer pageSize) throws ParseException {
        List<List<Object>> list = categoryDao.queryList(sFormId, key,map,name,pageNo,pageSize);
        return Bom(list);
    }

    /**
     * 获取金蝶云数据
     * @param map
     * @param where
     * @return
     * @throws ParseException
     */
    public List<Map<String, String>> selectAndLog(Map<String, String> map, String where,String name) {
        List<List<Object>> list = categoryDao.selectAndLog(sFormId, key,map,name);
        return Bom(list);
    }
    /**
     * 将查询到的数据封装成本地字段
     * @return
     */
    private List<Map<String,String>> Bom(List<List<Object>> list){
        List<Map<String,String>> salesorderlist = new ArrayList<>();
        if (!list.isEmpty()) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                for (List<Object> list1 : list) {
                    Map<String, String> salesordermap = new HashMap<>();
                    salesordermap.put("fid", list1.get(0).toString());
                    salesordermap.put("PROD_ID", list1.get(1).toString());
                    salesordermap.put("MTRL_ID", list1.get(2).toString());
                    salesordermap.put("POINT_STR", list1.get(3).toString());
                    if ("false".equals(list1.get(5).toString())) {
                        salesordermap.put("MAIN_ID", list1.get(2).toString());
                    } else {
                        salesordermap.put("MAIN_ID", list1.get(1).toString());
                    }
                    if("false".equals(list1.get(5).toString())){
                        salesordermap.put("IS_MAIN","N");
                    }else {
                        salesordermap.put("IS_MAIN","Y");
                    }
                    Double a = Double.valueOf(list1.get(6).toString());
                    Double b = Double.valueOf(list1.get(7).toString());
                    double v = a / b;
                    salesordermap.put("DOSAGE", Double.toString(v));
                    salesorderlist.add(salesordermap);
                }
            } else {
                //如果有错误信息则返回
                Map<String,Object> o = (Map<String, Object>) list.get(0).get(0);
                Object errors = o.get("Errors");
                List parse3 = (List) JSON.parse(errors.toString());
                Map parse4 = (Map) JSON.parse(parse3.get(0).toString());
                Object message = parse4.get("Message");
                Map<String, String> salesordermap = new HashMap<>();
                salesordermap.put("false", message.toString());
                salesorderlist.add(salesordermap);
            }
        }
        return salesorderlist;
    }

    @Override
    public String update(Object object) {
        return null;
    }
}
