package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.TimeUtil;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 查询金蝶云发货通知单基本信息
 */
@Component
public class DnKingdeeApi implements web_api {
    /**操作的单据体名称*/
    private String sFormId = "SAL_DELIVERYNOTICE";//发货通知单
    @Autowired
    private CategoryDao categoryDao;
    private Map<String,String> key = new LinkedHashMap<>();
    public DnKingdeeApi(){
        /*查询字段*/
        key.put("FID","FID");//单据头实体主键
        key.put("FBillNo","FBillNo");//单号
        key.put("FCustomerID.Fnumber","FCustomerID.Fnumber");//客户
        key.put("FMaterialID.Fnumber","FMaterialID.Fnumber");//明细信息-物料编码
        key.put("FStockID.Fnumber","FStockID.Fnumber");//出货仓库
        key.put("FQty","FQty");//销售数量
        key.put("FNote","FNote");//基本信息-备注
        key.put("FOrderNo","FOrderNo");//订单单号
        key.put("FOrderSeq","FOrderSeq");//订单行号
        key.put("FIsFree","FIsFree");//是否赠品
        key.put("FPlanDeliveryDate","FPlanDeliveryDate");//计划发货日期
        key.put("FEntity_FSeq","FEntity_FSeq");//明细序号
    }


    @Override
    public String add(Map json) {
        return null;
    }

    /**
     * 查询根据ID查询
     * @param map
     * @param where
     * @return
     * @throws ParseException
     */
    public List<Map<String, String>> selectAndLog(Map<String, String> map, String where,String name) throws ParseException {
        List<List<Object>> list = categoryDao.selectAndLog(sFormId, key,map,name);
        return Dept(list);
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        return null;
    }

    @Override
    public String update(Object object) {
        return null;
    }

    /**
     * 将查询到的数据封装成本地字段
     * @return
     */
    private List<Map<String,String>> Dept(List<List<Object>> list){
        List<Map<String,String>> salesorderlist = new ArrayList<>();
        if(!list.isEmpty()) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                for (List<Object> list1 : list) {
                    Map<String, String> salesordermap = new HashMap<>();
                    salesordermap.put("fid", list1.get(0).toString());
                    salesordermap.put("AUDIT_ID", list1.get(1).toString());
                    salesordermap.put("CUST_ID", list1.get(2).toString());
                    //查询出物料编码
                    salesordermap.put("MTRL_ID", list1.get(3).toString());
                    if(list1.get(4) == null||"".equals(list1.get(4))) {
                        salesordermap.put("STORE_ID","");
                    }else {
                        salesordermap.put("STORE_ID", list1.get(4).toString());
                    }
                    salesordermap.put("QUANTITY", list1.get(5).toString());
                    salesordermap.put("REMARK", list1.get(6).toString());
                    salesordermap.put("SO_ID", list1.get(7).toString());
                    salesordermap.put("SO_SEQ", list1.get(8).toString());
                    salesordermap.put("IS_PRE", list1.get(9).toString());
                    Date parse = null;
                    try {
                        parse = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS").parse(TimeUtil.timeSSS(list1.get(10).toString()));
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                    String hdate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(parse);
                    salesordermap.put("H_DATE", hdate);
                    salesordermap.put("MTRL_SEQ", list1.get(11).toString());
                    salesorderlist.add(salesordermap);
                }
            }else {
                //如果有错误信息则返回
                Map<String,Object> o = (Map<String, Object>) list.get(0).get(0);
                Object errors = o.get("Errors");
                List parse3 = (List) JSON.parse(errors.toString());
                Map parse4 = (Map) JSON.parse(parse3.get(0).toString());
                Object message = parse4.get("Message");
                Map<String, String> salesordermap = new HashMap<>();
                salesordermap.put("false", message.toString());
                salesorderlist.add(salesordermap);
            }
        }
        return salesorderlist;
    }
}
