package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.entity.ImsGain;
import org.jeecg.modules.iost.ims.entity.ImsOtherGodownentry;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.util.*;

/**
 * 其他收料单
 */
@Component
public class OtherKingdeeApi implements web_api {
    @Autowired
    private CategoryDao categoryDao;

    private String sFormId;
    private String Father_FEnrtyID;
    private String KingdeeLogPushName;
    private String KingdeeLogName;
    private String Father_sFormId;
    private String push_Rule;
    private String Son_FEnrtyID;
    private String SeqName;
    public OtherKingdeeApi() {
        sFormId = "STK_MISCELLANEOUS";  //子单据Formid
        KingdeeLogName = "其他收料";    //金蝶云修改操作日志-nam
    }

    @Override
    public String add(Map<String, Object> maps) {
        List<Map<String,Object>> lists=new ArrayList<>();
        lists.add(maps);
        Map<String, Object> stringStringMap = ImsToKingdee(lists);
        String result = categoryDao.add(KingdeeLogName, sFormId, JsonUtil.Mapjson(stringStringMap));
        return result;
    }

    public List<Map<String, String>> addTwo(List<Map<String, Object>> lists) {
        String result = new String( );
        Map<String, Object> stringStringMap = ImsToKingdee(lists);
        JSONObject responseStatus = categoryDao.addReturn(KingdeeLogName, sFormId, JsonUtil.Mapjson(stringStringMap));
        List<JSONObject> successEntitys = (List<JSONObject>) responseStatus.get("SuccessEntitys");
        Boolean isSuccess = (Boolean) responseStatus.get("IsSuccess");
        String successEntitysString = JSON.toJSONString(successEntitys);
        if (isSuccess == false) {
            String message = new String();
            List<JSONObject> Errors = (List<JSONObject>) responseStatus.get("Errors");
            for (JSONObject error : Errors) {
                JSONObject messags = Errors.get(0);
                message = message + " " + String.valueOf(messags.get("Message"));
            }
            result = String.valueOf(message);
        }
        List<Map<String, String>> list = new ArrayList<>();
        if (!ObjectUtils.isEmpty(successEntitys)) {
            for (JSONObject successEntity : successEntitys) {
                String FID = successEntity.get("Id").toString();
                String FBillNo = successEntity.get("Number").toString();
                Map<String, String> map = new HashMap<>();
                map.put("FID", FID);
                map.put("FBILL_NO", FBillNo);
                map.put("result", result);
                list.add(map);
            }
        } else {
            Map<String, String> map = new HashMap<>();
            map.put("result", result);
            list.add(map);
        }
        return list;
    }
    /*ims字段转换成金蝶云待添加(其实都是下推后修改)字段*/
    public Map<String, Object> ImsToKingdee(List<Map<String,Object>> lists) {
        List<Map<String, Object>> list = new ArrayList<>();
        Map<String, Object> ModelMap = new HashMap<>();
        for (Map<String, Object> maps : lists) {
            Object SHIPPER_TYPE=new Object();
            //转化货主类型字段
            if(maps.get("SHIPPER_TYPE").toString().equals("1"))
            {
                SHIPPER_TYPE="BD_OwnerOrg";
            }
            else if(maps.get("SHIPPER_TYPE").toString().equals("2"))
            {
                SHIPPER_TYPE="BD_Supplier";
            }
            else if(maps.get("SHIPPER_TYPE").toString().equals("3"))
            {
                SHIPPER_TYPE="BD_Customer";
            }
            Map<String, Object> FEntityMap = new LinkedHashMap<>();
            //字段转化
            FEntityMap.put("FMATERIALID", new HashMap<String, Object>() {{
                put("FNumber", maps.get("MTRL_ID"));
            }}); //物料编码
            FEntityMap.put("FSTOCKID", new HashMap<String, Object>() {{
                put("FNumber", maps.get("STORE_ID"));
            }}); //仓库编码
            FEntityMap.put("FBASEQTY", maps.get("QUANTITY")); //实收数量
            FEntityMap.put("FQty", maps.get("QUANTITY")); //实收数量
            FEntityMap.put("FEntryNote", maps.get("REMARK")); //备注
            FEntityMap.put("FOwnerId", new HashMap<String, Object>() {{
                put("FNumber", maps.get("SHIPPER_ID"));
            }});  //货主
            list.add(FEntityMap);
            ModelMap.put("FBillTypeID", new HashMap<String, Object>() {{
                put("FNUMBER", maps.get("CODE_TYPE"));
            }}); //单据类型
            ModelMap.put("FStockOrgId", new HashMap<String, Object>() {{
                put("FNumber", maps.get("ORG_ID"));
            }}); //库存组织
            ModelMap.put("FDEPTID", new HashMap<String, Object>() {{
                put("FNumber", maps.get("DEPT_ID"));
            }}); //部门
            ModelMap.put("FOwnerTypeIdHead", SHIPPER_TYPE);  //货主类型

            ModelMap.put("FDate", maps.get("TRX_DATE"));  //交易时间
        }
        ModelMap.put("FEntity", list);
        return ModelMap;
    }


    public List<List<Object>> select(Map<String, String> map,Map<String, String> where)  {
        List<List<Object>> list = categoryDao.selectAndLog(sFormId,map,where,"其他收料");
        return list;
    }

    //删除修改失败的单据
    public String delete(String id) {
        String delete = categoryDao.delete(KingdeeLogName, sFormId, id);
        return delete;
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        return null;
    }


    @Override
    public String update(
            Object object) {
        return null;
    }



}
