package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.util.*;

/**
 * 查询金蝶云ERP委外工单物料需求基本信息
 */
@Component
public class WplanMnOutsKingdeeApi implements web_api {
    /**操作的单据体名称*/
    private String sFormId = "SUB_PPBOM";//ERP工单-委外用料订单
    @Autowired
    private CategoryDao categoryDao;
    private Map<String,String> key = new LinkedHashMap<>();
    public WplanMnOutsKingdeeApi(){
        /*查询字段*/
        key.put("FID","FID");//单据头实体主键
        key.put("FSubReqBillNO","FSubReqBillNO");//委外订单编号
        key.put("FMaterialID.FNumber","FMaterialID.FNumber");//产品编码
        key.put("FQty","FQty");//数量
        key.put("FMaterialType","FMaterialType");//替代主料
        key.put("FParentRowId","FParentRowId");//父级行主键
        key.put("FStdQty","FStdQty");//标准用量
        key.put("FMustQty","FMustQty");//应发数量
        key.put("FNeedQty2","FNeedQty2");//需求数量
        key.put("FPositionNO","FPositionNO");//位置号
        key.put("FEntity_FSeq","FEntity_FSeq");//明细序号
        key.put("FEntity_FEntryID","FEntity_FEntryID");//行内码
        key.put("FSubReqEntrySeq","FSubReqEntrySeq");//委外订单行号
        key.put("FMaterialID2.FNumber","FMaterialID2.FNumber");//子项物料编码
//        key.put("FPARENTROWID","FPARENTROWID");//父级单据
        key.put("FNumerator","FNumerator");//分子
        key.put("FDenominator ","FDenominator ");//分母
    }

    @Override
    public String add(Map<String, Object> maps) {
        return null;
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        return null;
    }

    /**
     * 获取金蝶云数据
     * @param map
     * @param where
     * @return
     * @throws ParseException
     */
    public List<Map<String, String>> selectAndLog(Map<String, String> map, String where,String name) throws ParseException {
        List<List<Object>> list = categoryDao.selectAndLog(sFormId, key,map,name);
        return WplanMnOuts(list);
    }
    /**
     * 查询父级的子项物料编码
     * @param id
     * @return
     */
    public List<List<Object>> getMaterid(String id) {
        List<List<Object>> lists = categoryDao.selectByIds("SUB_PPBOM", new HashMap<String, String>() {{
            //根据单据编码查询子项物料编码
            put("FMaterialID2.FNumber", "FMaterialID2.FNumber");
            put("FROWID","FROWID");
        }}, new HashMap<String, String>() {{
            put("FROWID", id);
        }});
        if(CollectionUtils.isEmpty(lists)) {
            return null;
        }
        if( null==lists.get(0).get(0)||"".equals(lists.get(0).get(0))){
            return null;
        }else if (lists.get(0).get(0).toString().contains("Errors")){
            return null;
        }
        return lists;
    }

    /**
     * 将查询到的数据封装成本地字段
     * @return
     */
    private List<Map<String,String>> WplanMnOuts(List<List<Object>> list){
        List<Map<String,String>> salesorderlist = new ArrayList<>();
        if (!list.isEmpty()) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                //添加主键与外键映射关系
                Map<String, List<String>> Matermap = new HashMap<>();
                String mater = "";
                for (List<Object> list1 : list) {
                    Map<String, String> salesordermap = new HashMap<>();
                    salesordermap.put("fid", list1.get(0).toString());
                    salesordermap.put("ERP_MO", list1.get(1).toString());
                    salesordermap.put("PROD_ID", list1.get(2).toString());
                    salesordermap.put("P_QTY", list1.get(3).toString());
                    if(null==list1.get(4)||"3".equals(list1.get(4).toString())){
                        salesordermap.put("IS_MAIN", "N");
                    }else {
                        salesordermap.put("IS_MAIN","Y");
                    }
                    if (null==list1.get(4)||"1".equals(list1.get(4).toString())) {
                        if(null==list1.get(13)||"".equals(list1.get(13).toString())){
                            salesordermap.put("MTRL_ID","");
                            salesordermap.put("MAIN_ID","");
                        }else {
                            salesordermap.put("MTRL_ID", list1.get(13).toString());
                            salesordermap.put("MAIN_ID",list1.get(13).toString());
                        }
                    } else {
                        if(!"".equals(list1.get(5).toString())&&list1.get(5).toString()!=null) {
                            //将行内码和编码存入集合
                            List<String> idList = new ArrayList<>();
                            //编码
                            idList.add(list1.get(5).toString());
                            //行内码
                            Matermap.put(list1.get(11).toString(), idList);
                            //拼接id做批量查询
                            mater = "'"+list1.get(5).toString() + "'," + mater;
                            salesordermap.put("MTRL_ID", list1.get(13).toString());
                            salesordermap.put("FParentRowId",list1.get(5).toString());
//                            Object materid = getMaterid(list1.get(5).toString());
//                            salesordermap.put("MAIN_ID", materid.toString());
                        }else {
                            salesordermap.put("MAIN_ID","");
                            salesordermap.put("MTRL_ID", list1.get(13).toString());
                        }
                    }
                    if(null==list1.get(14)||"".equals(list1.get(14))||null==list1.get(15)||"".equals(list1.get(15))||"0.0".equals(list1.get(14).toString())||"0.0".equals(list1.get(15).toString())){
                        salesordermap.put("DOSAGE","");
                    }else {
                        Double FNumerator  = Double.valueOf(list1.get(14).toString());
                        Double FDenominator  = Double.valueOf(list1.get(15).toString());
                        double v = FNumerator / FDenominator;
                        salesordermap.put("DOSAGE", Double.toString(v));
                    }
                    salesordermap.put("NN_QTY", list1.get(7).toString());
                    salesordermap.put("TN_QTY", list1.get(8).toString());
                    if(null==list1.get(9)||"".equals(list1.get(9))) {
                        salesordermap.put("POINT_STR","");
                    }else {
                        salesordermap.put("POINT_STR", list1.get(9).toString());
                    }
                    salesordermap.put("SEQ", list1.get(10).toString());
                    salesordermap.put("SEQ_ENTRY_CODE", list1.get(11).toString());
                    if(null==list1.get(12)||"".equals(list1.get(12))){
                        salesordermap.put("ERP_MO_SEQ","");
                    }else {
                        salesordermap.put("ERP_MO_SEQ", list1.get(12).toString());
                    }
                    salesorderlist.add(salesordermap);
                }
                if(!"".equals(mater)){
                    //批量查出所有生产用料清单的数据
                    mater=mater.substring(0,mater.length()-1);
                    List<List<Object>> materid = getMaterid(mater);
                    if (null == materid || "".equals(materid.toString())) {
                        for (Map<String, String> salesordermap : salesorderlist) {
                            salesordermap.put("MAIN_ID", "");
                        }
                    }else {
                        //将集合赋值
                        for (String fid : Matermap.keySet()) {
                            for(List custList: materid){
                                //如果对应的行内码相同
                                if (Matermap.get(fid).get(0).equals(custList.get(0).toString())) {
                                    //将信息添加到集合
                                    Matermap.get(fid).add(custList.get(1).toString());
                                }
                            }
                        }
                        //将对应的信息写入到大集合
                        for (Map<String, String> salesordermap : salesorderlist) {
                            for (String fid : Matermap.keySet()) {
                                //如果行内码与父级ID都相同
                                if (fid.equals(salesordermap.get("SEQ_ENTRY_CODE"))&&Matermap.get(fid).get(0).equals(salesordermap.get("FParentRowId"))) {
                                    //如果对应的编码不为空
                                    if (null != Matermap.get(fid).get(1)) {
                                        salesordermap.put("MAIN_ID", Matermap.get(fid).get(1));
                                    } else {
                                        salesordermap.put("MAIN_ID", "");
                                    }
                                }
                            }
                        }
                    }
                }
            }else {
                //如果有错误信息则返回
                Map<String,Object> o = (Map<String, Object>) list.get(0).get(0);
                Object errors = o.get("Errors");
                List parse3 = (List) JSON.parse(errors.toString());
                Map parse4 = (Map) JSON.parse(parse3.get(0).toString());
                Object message = parse4.get("Message");
                Map<String, String> salesordermap = new HashMap<>();
                salesordermap.put("false", message.toString());
                salesorderlist.add(salesordermap);
            }
        }
        return salesorderlist;
    }
    @Override
    public String update(Object object) {
        return null;
    }
}
