package org.jeecg.modules.iost.ims.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.XmlUtil;
import org.jeecg.modules.iost.ims.entity.Imslog;
import org.jeecg.modules.iost.ims.mapper.ImslogMapper;
import org.jeecg.modules.iost.ims.service.IImslogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.text.ParseException;
import java.util.Date;
import java.util.Map;

/**
 * @Description: ims响应日志
 * @Author: jeecg-boot
 * @Date:   2021-09-03
 * @Version: V1.0
 */
@Service
public class ImslogServiceImpl extends ServiceImpl<ImslogMapper, Imslog> implements IImslogService {

    @Autowired
    ImslogMapper imslogMapper;
    @Autowired
    IMSApi imsApi;

    @Override
    public Boolean synchronization(String id,LoginUser sysUser) throws ParseException {
        //根据ID拿到对应的实体类
        Imslog imslog=imslogMapper.selectById(id);
        String result = imsApi.add(imslog.getRequest());

        Boolean flag=false;
        //将返回结果转成JSON
        String s = XmlUtil.xmltoJson(result);
        //逐步拆分出对应的信息
        Map maps = (Map) JSON.parse(s);
        Object o = maps.get("SOAP-ENV:Body");
        Map map1 = (Map)JSON.parse(o.toString());
        Object o1 = map1.get("NS1:updateIMSDataResponse");
        Map map2 = (Map)JSON.parse(o1.toString());
        Object msg = map2.get("ResultMsg");
        Map map3 = (Map)JSON.parse(msg.toString());
        Object aReturn = map2.get("return");
        Map map4 = (Map)JSON.parse(aReturn.toString());
        Object message = map3.get("#text");
        Object success = map4.get("#text");
        imslog.setMessage(message.toString());
        imslog.setResponse(s);
        imslog.setUpdateTime(new Date());
        imslog.setUpdateBy(sysUser.getUsername());
        if (success.toString().equals("true")){
            flag=true;
            imslog.setSuccess("true");
        }else {
            imslog.setSuccess("false");
        }
        imslogMapper.updateById(imslog);
        return  flag;
    }
}
