package org.jeecg.modules.iost.ims.Dao;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.modules.base.service.BaseCommonService;
import org.jeecg.common.exception.ConnectConstant.KingDeeConstant;
import org.jeecg.common.exception.KingdeeChangeException;
import org.jeecg.common.exception.KingdeeConnectException;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.KingdeeLogUtil;
import org.jeecg.modules.iost.ims.Util.KingdeeResultParseUtil;
import org.jeecg.modules.iost.ims.client.KingdeeK3CloudApiClient;
import org.jeecg.modules.iost.ims.entity.ImsInitConnectParm;
import org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result;
import org.jeecg.modules.iost.ims.service.IImsInitConnectParmService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import javax.annotation.PostConstruct;
import java.util.*;
import java.util.concurrent.ScheduledFuture;

/**
 * WEB-API
 */
@Slf4j
@Component
@Data
public class CategoryDao {
    @Autowired
    BaseCommonService baseCommonService;
    @Autowired
    ThreadPoolTaskScheduler threadPoolTaskSched;
    //static String K3CloudURL = "http://1ar8696937.iok.la/k3cloud/";//指定地
/*     String k3CloudURL = "http://192.168.2.243/k3cloud/";//指定地址
         String dbId = "6136b7c51f0e4f";
     String uid = "Administrator";
     String pwd = "888888";
     int lang = 2052;
     //是否自动提交审核(修改提交审核放在一个事务里面)
    Boolean IsAutoSubmit = true;
    KingdeeK3CloudApiClient client=new KingdeeK3CloudApiClient("http://192.168.2.243/k3cloud/");*/
    private ScheduledFuture<?> future1;
    ImsInitConnectParm imsInitConnectParm;
    String K3CloudURL;//指定地址
    String dbId;
    String uid;
    String pwd;
    int lang;
    Boolean IsAutoSubmit;
    KingdeeK3CloudApiClient client;
    KingdeeK3CloudApiClient client2;
    KingdeeK3CloudApiClient client3;
    Boolean result=false;
    private Boolean IsCloseKingDee=false;
    String loginResult;
    @Autowired
    IImsInitConnectParmService iImsInitConnectParmService;
    @PostConstruct
    public void init() {
        imsInitConnectParm = iImsInitConnectParmService.getBaseMapper().selectById("1");
        K3CloudURL= imsInitConnectParm.getK3CloudUrl();//指定地址
        dbId= imsInitConnectParm.getDbid();
        uid= imsInitConnectParm.getUid();
        pwd= imsInitConnectParm.getPwd();
        lang= imsInitConnectParm.getLang();
        IsAutoSubmit= imsInitConnectParm.getIsAutoSubmit().toString().equals("1")?true:false;
        client=new KingdeeK3CloudApiClient(K3CloudURL);
        client2=new KingdeeK3CloudApiClient(K3CloudURL);
        client3=new KingdeeK3CloudApiClient(K3CloudURL);
    }


    private String Stringwhere(Map<String,String> map){
        String where = null;
        for (String key : map.keySet()) {
            String value = String.valueOf(map.get(key));
            if(value!=null && value.length() !=0) {
                if (where!=null){
                    where = where + " AND " + key + "='" + value+"'";
                }else {
                    where = key + "='" + value+"'";
                }
            }
        }
        if (where!=null){
            return ",\"FilterString\":\""+where+"\"";
        }
        return "";
    }
    //添加批量查询
    private String whereByIds(Map<String,String> map){
        String where = null;
        for (String key : map.keySet()) {
            String value = String.valueOf(map.get(key));
            if(value!=null && value.length() !=0) {
                if (where!=null){
                    where = where + " AND " + key + "='" + value+"'";
                }else {
                    where = key + " IN (" + value+")";
                }
            }
        }
        if (where!=null){
            return ",\"FilterString\":\""+where+"\"";
        }
        return "";
    }
    /**
     * 查询日期
     * @param map
     * @return
     */
    private String Stringwheredate(Map<String, String> map,String date) {
        String where = null;
        for (String key : map.keySet()) {
            //拿到日期
            String value = String.valueOf(map.get(key));
            if (value!= null && value.length() !=0) {
                if ("FCreateDate".equals(key)) {
                    where = key + ">='"+ date + "'"+ "AND" + " "+key + "<='" + value +"'";
                } else if(where != null){
                    where = where + " AND " + key + "=" + value;
                }else {
                    where = key + "='" + value+"'";
                }
            }
        }
        if (where != null) {
            return ",\"FilterString\":\"" + where + "\"";
        }
        return "";
    }
    /**
     * 查询大于起始日期
     * @param map
     * @return
     */
    private String Stringwheredate1(Map<String, String> map) {
        String where = null;
        for (String key : map.keySet()) {
            //拿到日期
            String value = String.valueOf(map.get(key));
            if (value!= null && value.length() !=0) {
                if ("FCreateDate".equals(key)) {
                    where = key + ">='" + value +"'";
                } else if(where != null){
                    where = where + " AND " + key + "=" + value;
                }else {
                    where = key + "='" + value+"'";
                }
            }
        }
        if (where != null) {
            return ",\"FilterString\":\"" + where + "\"";
        }
        return "";
    }


    private String Stringkey(Map<String,String> map){
        String Keys = null;
        for (String key : map.keySet()) {
            String value = String.valueOf(map.get(key));
            if(value!=null && value!="") {
                if (Keys!=null){
                    Keys = Keys + " , " + key ;
                }else {
                    Keys = key;
                }
            }
        }
        if (Keys!=null){
            return "\"FieldKeys\":\""+Keys+"\"";
        }
        return "";
    }

    /**
     * 查询单据体
     * @return
     * @throws Exception
     */

    public List<List<Object>> select(String sFormId, Map<String,String> key,Map<String,String> where){
        List<List<Object>> list = null;
        System.out.println(pwd+"99999999999999999999999999999999999999999999999999999999");
        try {

            if(result){
                String content;
                if(where!=null){
                    content= "{\"FormId\":\""+sFormId+"\","+Stringkey(key)+Stringwhere(where)+"}";
                }else{
                    content = "{\"FormId\":\""+sFormId+"\","+Stringkey(key)+"}";
                }
                System.out.println("================content=============="+content+"=================content===================");
                list = client.executeBillQuery(content);
            }
            else {
                throw new KingdeeConnectException(loginResult);
            }
        }catch (KingdeeConnectException e) {
            throw new KingdeeConnectException(loginResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KingdeeConnectException(KingDeeConstant.URL,baseCommonService);
        }
        return list;
    }
    /**
     * 批量查询
     * @return
     * @throws Exception
     */

    public List<List<Object>> selectByIds(String sFormId, Map<String,String> key,Map<String,String> where){
        List<List<Object>> list = null;
        try {

            if(result){
                String content;
                if(where!=null){
                    content= "{\"FormId\":\""+sFormId+"\","+Stringkey(key)+whereByIds(where)+"}";
                }else{
                    content = "{\"FormId\":\""+sFormId+"\","+Stringkey(key)+"}";
                }
                System.out.println("================content=============="+content+"=================content===================");
                list = client.executeBillQuery(content);
            }
            else {
                throw new KingdeeConnectException(loginResult);
            }
        }catch (KingdeeConnectException e) {
            throw new KingdeeConnectException(loginResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KingdeeConnectException(KingDeeConstant.URL,baseCommonService);
        }
        return list;
    }
    /**
     * 查询单据体(带日志)
     * @return
     * @throws Exception
     */

    public List<List<Object>> select(String sFormId, Map<String,String> key,Map<String,String> where,String KingdeeLogName){
        List<List<Object>> list = null;
        System.out.println(pwd+"99999999999999999999999999999999999999999999999999999999");
        try {

            if(result){
                String content;
                if(where!=null){
                    content= "{\"FormId\":\""+sFormId+"\","+Stringkey(key)+Stringwhere(where)+"}";
                }else{
                    content = "{\"FormId\":\""+sFormId+"\","+Stringkey(key)+"}";
                }
                System.out.println("================content=============="+content+"=================content===================");
                list = client.executeBillQuery(content);
                //记录单据查询金蝶云数据的请求和响应信息
                KingdeeLogUtil kingdeeLogUtil = new KingdeeLogUtil();
                kingdeeLogUtil.KingdeeLog(list,KingdeeLogName,content);
            }
            else {
                throw new KingdeeConnectException(loginResult);
            }
        }catch (KingdeeConnectException e) {
            throw new KingdeeConnectException(loginResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KingdeeConnectException(KingDeeConstant.URL,baseCommonService);
        }
        return list;
    }
    /**
     * 查询单据体并添加日志
     * @return
     * @throws Exception
     */
    public List<List<Object>> selectAndLog(String sFormId, Map<String,String> key,Map<String,String> where,String name){
        List<List<Object>> list = null;
        String content = null;
        try {

            if(result){
                if(where!=null){
                    content= "{\"FormId\":\""+sFormId+"\","+Stringkey(key)+Stringwhere(where)+"}";
                }else{
                    content = "{\"FormId\":\""+sFormId+"\","+Stringkey(key)+"}";
                }
//                System.out.println("-----------------------------------------"+content+"---------------------------------");
                list = client.executeBillQuery(content);
                KingdeeLogUtil kingdeeLogUtil=new KingdeeLogUtil();
                //记录金蝶云的响应信息
                kingdeeLogUtil.KingdeeLog(list,name,content);
            }
            else {
                throw new KingdeeConnectException(loginResult);
            }
        }catch (KingdeeConnectException e) {
            throw new KingdeeConnectException(loginResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KingdeeConnectException(KingDeeConstant.URL,baseCommonService);
        }
        return list;
    }

    public Map<String,List<List<Object>>> selectMap(String sFormId, Map<String,String> key,Map<String,String> where){
        List<List<Object>> list = null;
        Map<String, List<List<Object>>> stringListHashMap = new HashMap<String, List<List<Object>>>();
        try {

            if(result){
                String content;
                if(where!=null){
                    content= "{\"FormId\":\""+sFormId+"\","+Stringkey(key)+Stringwhere(where)+"}";
                }else{
                    content = "{\"FormId\":\""+sFormId+"\","+Stringkey(key)+"}";
                }
                list = client.executeBillQuery(content);
                stringListHashMap.put(content,list);
            }
            else {
                throw new KingdeeConnectException(loginResult);
            }
        }catch (KingdeeConnectException e) {
            throw new KingdeeConnectException(loginResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KingdeeConnectException(KingDeeConstant.URL,baseCommonService);
        }
        return stringListHashMap;
    }
    public Map<String,List<List<Object>>> selectMapWhere(String sFormId, Map<String,String> key,String where){
        List<List<Object>> list = null;
        Map<String, List<List<Object>>> stringListHashMap = new HashMap<String, List<List<Object>>>();
        try {
            if(result){
                String content;
                if(where!=null){
                    content= "{\"FormId\":\""+sFormId+"\","+Stringkey(key)+ ",\"FilterString\":\""+where+"\"" +"}";
                }else{
                    content = "{\"FormId\":\""+sFormId+"\","+Stringkey(key)+"}";
                }
                list = client.executeBillQuery(content);
                stringListHashMap.put(content,list);
            }
            else {
                throw new KingdeeConnectException(loginResult);
            }
        }catch (KingdeeConnectException e) {
            throw new KingdeeConnectException(loginResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KingdeeConnectException(KingDeeConstant.URL,baseCommonService);
        }
        return stringListHashMap;
    }
    /**
     * 查询日期
     * @param sFormId
     * @param key
     * @param where
     * @return
     */

    public List<List<Object>> selectdate(String sFormId, Map<String, String> key, Map<String, String> where,String date,String name) {
        List<List<Object>> list = null;
        Map<String, List<List<Object>>> stringListHashMap = new HashMap<String, List<List<Object>>>();
        try {
            if (result) {
                String content;
                if (where != null) {
                    content = "{\"FormId\":\"" + sFormId + "\"," + Stringkey(key) + Stringwheredate(where,date) + "}";
                } else {
                    content = "{\"FormId\":\"" + sFormId + "\"," + Stringkey(key) + "}";
                }
                list = client.executeBillQuery(content);
                KingdeeLogUtil kingdeeLogUtil=new KingdeeLogUtil();
                //记录金蝶云的响应信息
                kingdeeLogUtil.KingdeeLog(list,name,content);
            }
            else {
                throw new KingdeeConnectException(loginResult);
            }
        }catch (KingdeeConnectException e) {
            throw new KingdeeConnectException(loginResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KingdeeConnectException(KingDeeConstant.URL,baseCommonService);
        }

        return list;
    }
    /**
     * 查询起始日期
     * @param sFormId
     * @param key
     * @param where
     * @return
     */

    public List<List<Object>> selectdate1(String sFormId, Map<String, String> key, Map<String, String> where,String name) {
        List<List<Object>> list = null;
        Map<String, List<List<Object>>> stringListHashMap = new HashMap<String, List<List<Object>>>();
        try {
            if (result) {
                String content;
                if (where != null) {
                    content = "{\"FormId\":\"" + sFormId + "\"," + Stringkey(key) + Stringwheredate1(where) + "}";
                } else {
                    content = "{\"FormId\":\"" + sFormId + "\"," + Stringkey(key) + "}";
                }
                list = client.executeBillQuery(content);
                KingdeeLogUtil kingdeeLogUtil=new KingdeeLogUtil();
                //记录金蝶云的响应信息
                kingdeeLogUtil.KingdeeLog(list,name,content);
            }
            else {
                throw new KingdeeConnectException(loginResult);
            }
        }catch (KingdeeConnectException e) {
            throw new KingdeeConnectException(loginResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KingdeeConnectException(KingDeeConstant.URL,baseCommonService);
        }

        return list;
    }
    /**
     * 分页查询
     * @return
     * @throws Exception
     */
    public List<List<Object>> queryList(String sFormId, Map<String,String> key,Map<String,String> where,String name,Integer pageNo,Integer pageSize){
        List<List<Object>> list = null;
        String content = null;
        try {

            if(result){
                if(where!=null){
                    content= "{\"FormId\":\""+sFormId+"\","+Stringkey(key)+Stringwhere(where)+",\"StartRow\":"+pageNo+",\"Limit\": "+pageSize+"}";
                }else{
                    content = "{\"FormId\":\""+sFormId+"\","+Stringkey(key)+",\"StartRow\":"+pageNo+",\"Limit\": "+pageSize+"}";
                }
                log.info("查询语句:"+content);
                list = client.executeBillQuery(content);
                KingdeeLogUtil kingdeeLogUtil=new KingdeeLogUtil();
                //记录金蝶云的响应信息
                kingdeeLogUtil.KingdeeLog(list,name,content);
            }
            else {
                throw new KingdeeConnectException(loginResult);
            }
        }catch (KingdeeConnectException e) {
            throw new KingdeeConnectException(loginResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KingdeeConnectException(KingDeeConstant.URL,baseCommonService);
        }
        return list;
    }

    public String add(String KingdeeLogName,String sFormId,String json) {
        String result2 = null;
        Boolean isSuccess = null;
        JSONObject responseStatus=null;
        try {
            if(result) {
                /*Map<String,String> MAP=new HashMap<>();
                MAP.put("FEntity","FFinishQty");*/
                List<String> list=new ArrayList<>();
                list.add("FEntity.FFinishQty");
                String listjson = JsonUtil.Listjson(list);
//\"NeedUpDateFields\":"+listjson+",\"NeedReturnFields\":[\"FFinishQty\"],
                String content = "{\"IsDeleteEntry\":false,\"IsAutoSubmitAndAudit\":true,\"Model\":"+json+"}";
                result2 = client.save(sFormId,content);
                //记录下推金蝶云数据的请求和响应信息
                KingdeeLogUtil kingdeeLogUtil = new KingdeeLogUtil();
                kingdeeLogUtil.KingdeeLog2(content,result2, KingdeeLogName);
                //返回错误消息到前端
                //获取result的返回信息的成功状态
                JSONObject jsonObject = JSON.parseObject(result2);
                JSONObject result1 = (JSONObject)jsonObject.get("Result");
                 responseStatus = (JSONObject)result1.get("ResponseStatus");
                List<JSONObject> successEntitys = (List<JSONObject>) responseStatus.get("SuccessEntitys");
                isSuccess = (Boolean)responseStatus.get("IsSuccess");
            }
            else {
                throw new KingdeeConnectException(loginResult);
            }
        }catch (KingdeeConnectException e) {
            throw new KingdeeConnectException(loginResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KingdeeConnectException(KingDeeConstant.URL,baseCommonService);
        }
        if(isSuccess==false)
        {

            String message=new String();
            List<JSONObject> Errors = (List<JSONObject>) responseStatus.get("Errors");
            int i=0;
            for (JSONObject error : Errors) {
                JSONObject messags = Errors.get(i);
                message=message+"---"+String.valueOf(messags.get("Message"));
                i++;
            }
            throw new KingdeeChangeException("修改失败!",message);
            /*  return String.valueOf(message);*/
        }
        return null;
    }
    public Result addAndWithFid(String KingdeeLogName,String sFormId,String json,String Fid) {
        String result2 = null;
        JSONObject responseStatus=null;
        String deleteResult=null;
        Result KingdeeAddResult = new Result();
        try {
            if(result) {
                List<String> list=new ArrayList<>();
                list.add("FEntity.FFinishQty");
                String listjson = JsonUtil.Listjson(list);
                String content = "{\"IsDeleteEntry\":false,\"IsAutoSubmitAndAudit\":"+IsAutoSubmit+",\"Model\":"+json+"}";
                result2 = client.save(sFormId,content);
                log.error("测试输出:"+result2);
                KingdeeAddResult=KingdeeResultParseUtil.parseAddResult(result2);
                //记录下推金蝶云数据的请求和响应信息
                KingdeeLogUtil kingdeeLogUtil = new KingdeeLogUtil();
                kingdeeLogUtil.KingdeeLog2(content,result2, KingdeeLogName);
            }
            else {
                throw new KingdeeConnectException(loginResult);
            }
        }catch (KingdeeConnectException e) {
            throw new KingdeeConnectException(loginResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KingdeeConnectException(KingDeeConstant.URL,baseCommonService);
        }
        if(KingdeeAddResult.getResponseStatus().getIsSuccess()==false)
        {
            Result rrr = KingdeeResultParseUtil.parseAddResult(result2);
            String content = "{\"Ids\":"+Fid+"}";
            try {
                 deleteResult = client.delete(sFormId, content);
            } catch (Exception e) {
                e.printStackTrace();
            }
            //记录删除金蝶云数据的请求和响应信息
            KingdeeLogUtil kingdeeLogUtil = new KingdeeLogUtil();
            kingdeeLogUtil.KingdeeLog2(content,deleteResult, KingdeeLogName+"删除");
        }
        //根据手动设置的方式决定提交审核是否和修改分开进行
        else if(IsAutoSubmit==false &&KingdeeAddResult.getResponseStatus().getIsSuccess()==true)
        {
            String AutoSubmitResult = AutoSubmit(sFormId, Fid,KingdeeLogName);
            KingdeeAddResult= KingdeeResultParseUtil.parseAddResult(AutoSubmitResult);
        }
        return KingdeeAddResult;
    }

    public JSONObject addReturn(String KingdeeLogName,String sFormId,String json) {
        String result2 = null;
        JSONObject responseStatus=null;
        try {
            if(result) {
                /*Map<String,String> MAP=new HashMap<>();
                MAP.put("FEntity","FFinishQty");*/
                List<String> list=new ArrayList<>();
                list.add("FEntity.FFinishQty");
                String listjson = JsonUtil.Listjson(list);
//\"NeedUpDateFields\":"+listjson+",\"NeedReturnFields\":[\"FFinishQty\"],
                String content = "{\"IsDeleteEntry\":false,\"IsAutoSubmitAndAudit\":"+IsAutoSubmit+",\"Model\":"+json+"}";
                result2 = client.save(sFormId,content);
                Result saveResult = KingdeeResultParseUtil.parseAddResult(result2);
                String Fid = saveResult.getId();
                //记录修改金蝶云数据的请求和响应信息
                KingdeeLogUtil kingdeeLogUtil = new KingdeeLogUtil();
                kingdeeLogUtil.KingdeeLog2(content,result2, KingdeeLogName);
                //根据手动设置的方式决定提交审核是否和修改分开进行
                if(IsAutoSubmit==false &&saveResult.getResponseStatus().getIsSuccess()==true)
                {
                    String AutoSubmitResult = AutoSubmit(sFormId, Fid,KingdeeLogName);
                    result2=AutoSubmitResult;
                }
                //返回错误消息到前端
                //获取result的返回信息的成功状态
                JSONObject jsonObject = JSON.parseObject(result2);
                JSONObject result1 = (JSONObject)jsonObject.get("Result");
                responseStatus = (JSONObject)result1.get("ResponseStatus");
            }
            else {
                throw new KingdeeConnectException(loginResult);
            }
        }catch (KingdeeConnectException e) {
            throw new KingdeeConnectException(loginResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KingdeeConnectException(KingDeeConstant.URL,baseCommonService);
        }
        return responseStatus;
    }

    public String addReturnResult(String KingdeeLogName,String sFormId,String json) {
        String result2 = null;
        JSONObject responseStatus=null;
        try {
            if(result) {
                /*Map<String,String> MAP=new HashMap<>();
                MAP.put("FEntity","FFinishQty");*/
                List<String> list=new ArrayList<>();
                list.add("FEntity.FFinishQty");
                String listjson = JsonUtil.Listjson(list);
//\"NeedUpDateFields\":"+listjson+",\"NeedReturnFields\":[\"FFinishQty\"],
                String content = "{\"IsDeleteEntry\":false,\"IsAutoSubmitAndAudit\":"+IsAutoSubmit+",\"Model\":"+json+"}";
                result2 = client.save(sFormId,content);
                Result saveResult = KingdeeResultParseUtil.parseAddResult(result2);
                String Fid = saveResult.getId();
                //记录修改金蝶云数据的请求和响应信息
                KingdeeLogUtil kingdeeLogUtil = new KingdeeLogUtil();
                kingdeeLogUtil.KingdeeLog2(content,result2, KingdeeLogName);
                //根据手动设置的方式决定提交审核是否和修改分开进行
                if(IsAutoSubmit==false &&saveResult.getResponseStatus().getIsSuccess()==true)
                {
                    String AutoSubmitResult = AutoSubmit(sFormId, Fid,KingdeeLogName);
                    result2=AutoSubmitResult;
                }
            }
            else {
                throw new KingdeeConnectException(loginResult);
            }
        }catch (KingdeeConnectException e) {
            throw new KingdeeConnectException(loginResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KingdeeConnectException(KingDeeConstant.URL,baseCommonService);
        }
        return result2;
    }
    //提交并且审核
    public String AutoSubmit(String sFormId,String Fid,String KingdeeLogName)
    {
        String content = "{\"Ids\":"+Fid+"}";
        String submitResult=new String();
        try {
             submitResult = client.submit(sFormId, content);
        } catch (Exception e) {
            e.printStackTrace();
        }
        //记录提交金蝶云数据的请求和响应信息
        KingdeeLogUtil kingdeeLogUtil = new KingdeeLogUtil();
        kingdeeLogUtil.KingdeeLog2(content,submitResult, KingdeeLogName+"提交");
        String auditResult = new String();
        try {
            auditResult = client.audit(sFormId, content);
        } catch (Exception e) {
            e.printStackTrace();
        }
        //记录审核金蝶云数据的请求和响应信息
        kingdeeLogUtil.KingdeeLog2(content,auditResult, KingdeeLogName+"审核");
        Result result = KingdeeResultParseUtil.parseAddResult(auditResult);
        //审核失败反审核
        String unAudit=new String();
        if(result.getResponseStatus().getIsSuccess()==false)
        {
            try {
                unAudit = client.unAudit(sFormId,content);
            } catch (Exception e) {
                e.printStackTrace();
            }
            //记录删除金蝶云数据的请求和响应信息
            kingdeeLogUtil.KingdeeLog2(content,unAudit,KingdeeLogName+"反审核");
        }
        //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!审核成功FID没数据但是successEnitty有FID数据 要赋值！
        //审核失败就删除
        String delete=new String();
        if(result.getResponseStatus().getIsSuccess()==false)
        {
            try {
                 delete = client.delete(sFormId, content);
            } catch (Exception e) {
                e.printStackTrace();
            }
            //记录删除金蝶云数据的请求和响应信息
            kingdeeLogUtil.KingdeeLog2(content,delete,KingdeeLogName+"删除");
        }
        return auditResult;
    }

    public String batchAdd(String sFormId,String Listjson) {
        String result2 = null;
        try {
            if(result) {
                String content = "{\"Model\":"+Listjson+"}";
                result2 = client.batchSave(sFormId,content);
            }
            else {
                throw new KingdeeConnectException(loginResult);
            }
        }catch (KingdeeConnectException e) {
            throw new KingdeeConnectException(loginResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KingdeeConnectException(KingDeeConstant.URL,baseCommonService);
        }
        return result2;
    }

    public String add(String sFormId,String json) {
        String result2 = null;
        try {
            if(result) {
                /*Map<String,String> MAP=new HashMap<>();
                MAP.put("FEntity","FFinishQty");*/
                List<String> list=new ArrayList<>();
                list.add("FEntity.FFinishQty");
                String listjson = JsonUtil.Listjson(list);
//\"NeedUpDateFields\":"+listjson+",\"NeedReturnFields\":[\"FFinishQty\"],
                String content = "{\"Model\":"+json+"}";
                result2 = client.save(sFormId,content);
            }
            else {
                throw new KingdeeConnectException(loginResult);
            }
        }catch (KingdeeConnectException e) {
            throw new KingdeeConnectException(loginResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KingdeeConnectException(KingDeeConstant.URL,baseCommonService);
        }
        return result2;
    }
    public String delete(String KingdeeLogName,String sFormId,String Fid) {
        String deleteResult=null;
        String content = "{\"Ids\":"+Fid+"}";
        try {
            deleteResult = client.delete(sFormId, content);
        } catch (Exception e) {
            e.printStackTrace();
        }
        //记录删除金蝶云数据的请求和响应信息
        KingdeeLogUtil kingdeeLogUtil = new KingdeeLogUtil();
        kingdeeLogUtil.KingdeeLog2(content,deleteResult, KingdeeLogName+"删除");

        return deleteResult;
    }

    private String StringkeyByList(List<String> list) {
        String Keys = null;

        for (String key : list) {
            String value = String.valueOf(key);
            if (value != null && value != "") {
                if (Keys != null) {
                    Keys = Keys + " , " + key;
                } else {
                    Keys = key;
                }
            }
        }
        if (Keys != null) {
            return "\"FieldKeys\":\"" + Keys + "\"";
        }
        return "";
    }
    public Map<String,List<List<Object>>> selectInList(String sFormId, List<String> lists, Map<String, String> where) {
        Map<String,List<List<Object>>> log=new HashMap<>();//返回k请求v相应
        String content = null;//请求
        List<List<Object>> list = null;//响应
        try {
            if (result) {
                if (where != null) {
                    content = "{\"FormId\":\"" + sFormId + "\"," + StringkeyByList(lists) + StringWhereCompare(where) + "}";
                } else {
                    content = "{\"FormId\":\"" + sFormId + "\"," + StringkeyByList(lists) + "}";
                }

                list = client.executeBillQuery(content);

            }
            else {
                throw new KingdeeConnectException(loginResult);
            }
        }catch (KingdeeConnectException e) {
            throw new KingdeeConnectException(loginResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KingdeeConnectException(KingDeeConstant.URL,baseCommonService);
        }finally {
            log.put(content,list);//请求数据做key,返回做value
        }
        return log;
    }
    public Map<String,List<List<Object>>> selectWhere(String sFormId, List<String> lists, String where) {
        Map<String,List<List<Object>>> log=new HashMap<>();//返回k请求v相应
        String content = null;//请求
        List<List<Object>> list = null;//响应
        try {
            if (result) {
                if (where != null) {
                    content = "{\"FormId\":\"" + sFormId + "\"," + StringkeyByList(lists) + ",\"FilterString\":\""+where+"\"" + "}";
                } else {
                    content = "{\"FormId\":\"" + sFormId + "\"," + StringkeyByList(lists) + "}";
                }

                list = client.executeBillQuery(content);

            }
            else {
                throw new KingdeeConnectException(loginResult);
            }
        }catch (KingdeeConnectException e) {
            throw new KingdeeConnectException(loginResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KingdeeConnectException(KingDeeConstant.URL,baseCommonService);
        }finally {
            log.put(content,list);//请求数据做key,返回做value
        }
        return log;
    }

    public static String StringWhereCompare(Map<String,String> map) {
        String where = null;
        for (String key : map.keySet()) {
            String value = String.valueOf(map.get(key));
            if(value!=null && value!="") {
                if (where!=null){
                    where = where + " AND " + key  + value;
                }else {
                    where = key + "'" + value+"'";
                }
            }
        }
        if (where!=null){
            return ",\"FilterString\":\""+where+"\"";
        }
        return "";
    }

    public List<List<Object>> select(String content) {
        //请求
        List<List<Object>> list = null;//响应
        try {
            if (result) {
                list = client.executeBillQuery(content);
            }
            else {
                throw new KingdeeConnectException(loginResult);
            }
        }catch (KingdeeConnectException e) {
            throw new KingdeeConnectException(loginResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KingdeeConnectException(KingDeeConstant.URL,baseCommonService);
        }
        return list;
    }

    public String push(String KingdeeLogName,String FormId,String FEntryId,String RuleId,String TargetFormId) {
        String result2 = null;
        try {
            if(result) {
                Map<String,String> map=new LinkedHashMap<>();
                map.put("EntryIds",FEntryId);
                map.put("RuleId",RuleId);
                map.put("TargetFormId",TargetFormId);
                map.put("IsDraftWhenSaveFail","true");
                String mapjson = JsonUtil.Mapjson(map);
               /* String content = "{\"EntryIds\":"+FEntryId+",\"RuleId\":"+RuleId+",\"TargetFormId\":"+TargetFormId+"}";*/
                result2 = client.execute("Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.Push", new Object[]{FormId, mapjson}, String.class);
                //记录下推金蝶云数据的请求和响应信息
                KingdeeLogUtil kingdeeLogUtil = new KingdeeLogUtil();
                kingdeeLogUtil.KingdeeLog2(mapjson,result2, KingdeeLogName);
            }
            else {
                throw new KingdeeConnectException(loginResult);
            }
        }catch (KingdeeConnectException e) {
            throw new KingdeeConnectException(loginResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KingdeeConnectException(KingDeeConstant.URL,baseCommonService);
        }
        return result2;
    }

    public String pushMore(String KingdeeLogName,String FormId, List<String> FEntryIDs,String RuleId,String TargetFormId) {
        String result2 = null;
        String EntryIds=new String();
        for (String fEntryID : FEntryIDs) {
            EntryIds=EntryIds+","+fEntryID;
        }
        try {
            if(result) {
                Map<String,Object> map=new LinkedHashMap<>();
                map.put("EntryIds",EntryIds);
                map.put("RuleId",RuleId);
                map.put("TargetFormId",TargetFormId);
                map.put("IsDraftWhenSaveFail","true");
                String mapjson = JsonUtil.Mapjson(map);
                /* String content = "{\"EntryIds\":"+FEntryId+",\"RuleId\":"+RuleId+",\"TargetFormId\":"+TargetFormId+"}";*/
                result2 = client.execute("Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.Push", new Object[]{FormId, mapjson}, String.class);
                //记录下推金蝶云数据的请求和响应信息
                KingdeeLogUtil kingdeeLogUtil = new KingdeeLogUtil();
                kingdeeLogUtil.KingdeeLog2(mapjson,result2, KingdeeLogName);
            }
            else {
                throw new KingdeeConnectException(loginResult);
            }
        }catch (KingdeeConnectException e) {
            throw new KingdeeConnectException(loginResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KingdeeConnectException(KingDeeConstant.URL,baseCommonService);
        }
        return result2;
    }

    public String pushByNumber(String KingdeeLogName,String FormId, List<String> number,String RuleId,String TargetFormId) {
        String result2 = null;
        String EntryIds=new String();
        try {
            if(result) {
                Map<String,Object> map=new LinkedHashMap<>();
                map.put("Numbers",number);
                map.put("RuleId",RuleId);
                map.put("TargetFormId",TargetFormId);
                map.put("IsDraftWhenSaveFail","true");
                String mapjson = JsonUtil.Mapjson(map);
                /* String content = "{\"EntryIds\":"+FEntryId+",\"RuleId\":"+RuleId+",\"TargetFormId\":"+TargetFormId+"}";*/
                result2 = client.execute("Kingdee.BOS.WebApi.ServicesStub.DynamicFormService.Push", new Object[]{FormId, mapjson}, String.class);
                //记录下推金蝶云数据的请求和响应信息
                KingdeeLogUtil kingdeeLogUtil = new KingdeeLogUtil();
                kingdeeLogUtil.KingdeeLog2(mapjson,result2, KingdeeLogName);
            }
            else {
                throw new KingdeeConnectException(loginResult);
            }
        }catch (KingdeeConnectException e) {
            throw new KingdeeConnectException(loginResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KingdeeConnectException(KingDeeConstant.URL,baseCommonService);
        }
        return result2;
    }
    /**
     * 查询父单据FEntryId
     * @return
     * @throws Exception
     */
    public String Father_FindFentryId(String Father_FEnrtyID,Integer seq,Map<String, Object> maps,String Father_sFormId){
        //根据父单据编码(FBillNo)和行号(ERP工单行号seq)在金蝶云查出父单据的FEntryID
        //将要在父单据查询的字段
        Map<String, String> key = new LinkedHashMap<>();
        key.put(Father_FEnrtyID, Father_FEnrtyID);
        //过滤条件
        Map<String, String> filter = new LinkedHashMap<>();
        if(!ObjectUtils.isEmpty(maps.get("ERP_MO")))
        {
            filter.put("FBillNo", maps.get("ERP_MO").toString());
        }else
        {
            if(!ObjectUtils.isEmpty(maps.get("AUDIT_ID")))
            {
                filter.put("FBillNo", maps.get("AUDIT_ID").toString());
            }
            else
            {
                filter.put("FBillNo", maps.get("PO_ID").toString());
            }
        }
        String FEntryID="0";
        List<List<Object>> FEntryIDlist = this.select(Father_sFormId, key, filter);
        //过滤掉查询不到FEntryID的数据返回"0"
        if(!ObjectUtils.isEmpty(FEntryIDlist)) {
            if (FEntryIDlist.size()>=seq) {
                FEntryID = FEntryIDlist.get(seq - 1).get(0).toString();
            }
        }
        return FEntryID;

    }

    /**
     * 查询父单据FEntryId
     * @return
     * @throws Exception
     */
    public List<List<Object>> select_Father_FentryId(String Father_FEnrtyID,Map<String, Object> maps,String Father_sFormId,String KingdeeLogName){
        //根据父单据编码(FBillNo)和行号(ERP工单行号seq)在金蝶云查出父单据的FEntryID
        //将要在父单据查询的字段
        Map<String, String> key = new LinkedHashMap<>();
        key.put(Father_FEnrtyID, Father_FEnrtyID);
        //过滤条件
        Map<String, String> filter = new LinkedHashMap<>();
        if(!ObjectUtils.isEmpty(maps.get("ERP_MO")))
        {
            filter.put("FBillNo", maps.get("ERP_MO").toString());
        }else
        {
            if(!ObjectUtils.isEmpty(maps.get("AUDIT_ID")))
            {
                filter.put("FBillNo", maps.get("AUDIT_ID").toString());
            }
            else
            {
                filter.put("FBillNo", maps.get("PO_ID").toString());
            }
        }
        List<List<Object>> FEntryIDlist = this.select(Father_sFormId, key, filter,KingdeeLogName);
        return FEntryIDlist;
    }

    /**
     * 查询子单据FEntryId
     * @return
     * @throws Exception
     */
    public String select_Son_FentryId(String SeqName,String Son_FEnrtyID,Integer seq,String FID,String sFormId,String KingdeeLogName,String wipOrde,String wipOrderName){
        Map<String, String> key = new HashMap<>();
        key.put(Son_FEnrtyID, Son_FEnrtyID);
        Map<String, String> where = new HashMap<>();
        where.put("FID", FID);
        where.put(SeqName,String.valueOf(seq));
        where.put(wipOrderName,wipOrde);
        List<List<Object>> select = this.select(sFormId, key, where,KingdeeLogName);
        if (ObjectUtils.isEmpty(select)) {
            return "0";
        } else {
            //返回行号为第一个的明细的FEntryID
            return select.get(0).get(0).toString();
        }
    }
    /**
     * 查询子单据FEntryId
     * @return
     * @throws Exception
     */
    public String Son_FindFentryId(String SeqName,String Son_FEnrtyID,Integer seq,String FID,String sFormId){
        Map<String, String> key = new HashMap<>();
        key.put(Son_FEnrtyID, Son_FEnrtyID);
        Map<String, String> where = new HashMap<>();
        where.put("FID", FID);
        where.put(SeqName,String.valueOf(seq));
        List<List<Object>> select = this.select(sFormId, key, where);
        if (ObjectUtils.isEmpty(select)) {
            return "0";
        } else {
            //返回行号为第一个的明细的FEntryID
            return select.get(0).get(0).toString();
        }
    }
    /**
     * 查询子单据FEntryId
     * @return
     * @throws Exception
     */
    public String Son_FindFentryIdSpecial(String F,String SeqName,String Son_FEnrtyID,Integer seq,String FID,String sFormId){
        //根据父单据编码(FBillNo)和行号(ERP工单行号seq)在金蝶云查出父单据的FEntryID
        //将要在父单据查询的字段
        Map<String, String> key = new HashMap<>();
        key.put(Son_FEnrtyID, Son_FEnrtyID);
        Map<String, String> where = new HashMap<>();
        where.put("FID", FID);
        where.put(SeqName,F);
        List<List<Object>> select = this.select(sFormId, key, where);
        if (ObjectUtils.isEmpty(select)) {
            return "0";
        } else {
            //返回行号为第一个的明细的FEntryID
            return select.get(0).get(0).toString();
        }
    }

    /**
     * 查询子单据FEntryId
     * @return
     * @throws Exception
     */
    public String select_Son_FentryIdSpecial(String F,String SeqName,String Son_FEnrtyID,Integer seq,String FID,String sFormId,String KingdeeLogName){
        //根据父单据编码(FBillNo)和行号(ERP工单行号seq)在金蝶云查出父单据的FEntryID
        //将要在父单据查询的字段
        Map<String, String> key = new HashMap<>();
        key.put(Son_FEnrtyID, Son_FEnrtyID);
        Map<String, String> where = new HashMap<>();
        where.put("FID", FID);
        where.put(SeqName,F);
        List<List<Object>> select = this.select(sFormId, key, where,KingdeeLogName);
        if (ObjectUtils.isEmpty(select)) {
            return "0";
        } else {
            //返回行号为第一个的明细的FEntryID
            return select.get(0).get(0).toString();
        }
    }
}

