//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package org.jeecg.modules.iost.ims.client;

import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import kingdee.bos.json.JSONObject;
import kingdee.bos.webapi.client.ApiHttpClient;
import kingdee.bos.webapi.client.ApiRequest;
import kingdee.bos.webapi.client.ApiServiceRequest;
import kingdee.bos.webapi.client.IAsyncActionCallBack;
import org.apache.http.client.CookieStore;
import org.jeecg.common.util.ThreadLocalConfig;

import java.util.HashMap;
import java.util.Map;

public class KingdeeApiClient {
    private String _serverUrl;
    private CookieStore _cookieStore;

    public KingdeeApiClient(String serverUrl) {
        this._serverUrl = serverUrl;
    }

    public <T> ApiRequest<T> createRequest(String servicename, Object[] parameters, Class<T> returnType) {
        return new ApiServiceRequest(this._serverUrl, this._cookieStore, servicename, parameters, returnType);
    }

    public <T> T execute(String servicename, Object[] parameters, Class<T> returnType) throws Exception {
        Map map2 = ThreadLocalConfig.get();
        if(ObjectUtils.isEmpty(map2))
        {
             map2 = new HashMap();
             map2.put("test","test");
        }
        ApiRequest<T> request = this.createRequest(servicename, parameters, returnType);
        ApiHttpClient<T> httpClient = new ApiHttpClient();
        request.setListener(httpClient);
        long beginTime=System.currentTimeMillis();
        T send = httpClient.Send(request, returnType);
        long Costime=System.currentTimeMillis()-beginTime;
        if(!ObjectUtils.isEmpty(map2)) {
            map2.put("Costime", Costime);
            ThreadLocalConfig.set(map2);
        }
        return send;
    }

    public <T> ApiRequest<T> executeAsync(String servicename, Object[] parameters, Class<T> returnType, IAsyncActionCallBack<T> callback) throws Exception {
        ApiRequest<T> request = this.createRequest(servicename, parameters, returnType);
        ApiHttpClient<T> httpClient = new ApiHttpClient(callback);
        request.setListener(httpClient);
        httpClient.syncSend(request);
        return request;
    }

    public Boolean login(String dbId, String userName, String password, int lcid) throws Exception {
        try {
            Object[] loginInfo = new Object[]{dbId, userName, password, lcid};
            ApiRequest<String> request = this.createRequest("Kingdee.BOS.WebApi.ServicesStub.AuthService.ValidateUser", loginInfo, String.class);
            ApiHttpClient<String> httpClient = new ApiHttpClient();
            request.setListener(httpClient);
            String ret = (String) httpClient.Send(request, String.class);
            System.out.println(ret);
            int result = (new JSONObject(ret)).getInt("LoginResultType");
            if (result == 1) {
                this._cookieStore = request.getCookieStore();
                return true;
            } else {
                return false;
            }
        } catch (Exception var10) {
            var10.printStackTrace();
            return false;
        }
    }
}
