package org.jeecg.modules.iost.ims.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: ims其他入库单
 * @Author: jeecg-boot
 * @Date:   2021-10-08
 * @Version: V1.0
 */
@Data
@TableName("ims_other_godownentry")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="ims_other_godownentry对象", description="ims其他入库单")
public class ImsOtherGodownentry implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private java.lang.String id;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private java.lang.String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private java.util.Date createTime;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private java.lang.String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;
	/**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private java.lang.String sysOrgCode;
	/**唯一序号*/
	@Excel(name = "唯一序号", width = 15)
    @ApiModelProperty(value = "唯一序号")
    private java.lang.String queueId;
	/**交易时间*/
	@Excel(name = "交易时间", width = 15)
    @ApiModelProperty(value = "交易时间")
    private java.lang.String trxDate;
	/**仓库编码*/
	@Excel(name = "仓库编码", width = 15)
    @ApiModelProperty(value = "仓库编码")
    private java.lang.String storeId;
	/**物料编码*/
	@Excel(name = "物料编码", width = 15)
    @ApiModelProperty(value = "物料编码")
    private java.lang.String mtrlId;
	/**数量*/
	@Excel(name = "数量", width = 15)
    @ApiModelProperty(value = "数量")
    private java.lang.String quantity;
	/**备注*/
	@Excel(name = "备注", width = 15)
    @ApiModelProperty(value = "备注")
    private java.lang.String remark;
	/**库存组织*/
	@Excel(name = "库存组织", width = 15)
    @ApiModelProperty(value = "库存组织")
    private java.lang.String orgId;
	/**部门编码*/
	@Excel(name = "部门编码", width = 15)
    @ApiModelProperty(value = "部门编码")
    private java.lang.String deptId;
	/**货主类型 （1 业务组织 2供应商 3客户）*/
	@Excel(name = "货主类型 （1 业务组织 2供应商 3客户）", width = 15)
    @ApiModelProperty(value = "货主类型 （1 业务组织 2供应商 3客户）")
    private java.lang.String shipperType;
	/**货主编码 -- （按货主类型选择 供应商或客户）*/
	@Excel(name = "货主编码 -- （按货主类型选择 供应商或客户）", width = 15)
    @ApiModelProperty(value = "货主编码 -- （按货主类型选择 供应商或客户）")
    private java.lang.String shipperId;
	/**单据头实体主键*/
	@Excel(name = "单据头实体主键", width = 15)
    @ApiModelProperty(value = "单据头实体主键")
    private java.lang.String fid;
	/**明细信息行号*/
	@Excel(name = "明细信息行号", width = 15)
    @ApiModelProperty(value = "明细信息行号")
    private java.lang.String fseq;
	/**单据编码*/
	@Excel(name = "单据编码", width = 15)
    @ApiModelProperty(value = "单据编码")
    private java.lang.String fbillno;
	/**明细信息实体主键*/
	@Excel(name = "明细信息实体主键", width = 15)
    @ApiModelProperty(value = "明细信息实体主键")
    private java.lang.String fentryId;
    /**明细信息实体主键*/
    @Excel(name = "单据类型", width = 15)
    @ApiModelProperty(value = "单据类型")
    private java.lang.String codeType;
}
