package org.jeecg.modules.iost.ims.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: ims仓库基本信息
 * @Author: jeecg-boot
 * @Date:   2021-09-10
 * @Version: V1.0
 */
@Data
@TableName("ims_store")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="ims_store对象", description="ims仓库基本信息")
public class ImsStore implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private java.lang.String id;
    /**实体主键*/
    @Excel(name = "实体主键", width = 15)
    @ApiModelProperty(value = "实体主键")
    private java.lang.String fid;
	/**仓库编码*/
	@Excel(name = "仓库编码", width = 15)
    @ApiModelProperty(value = "仓库编码")
    private java.lang.String storeId;
	/**ERP仓库编码*/
	@Excel(name = "ERP仓库编码", width = 15)
    @ApiModelProperty(value = "ERP仓库编码")
    private java.lang.String erpStoreId;
	/**仓库名称*/
	@Excel(name = "仓库名称", width = 15)
    @ApiModelProperty(value = "仓库名称")
    private java.lang.String storeName;
	/**仓库类型（1良品仓2不良品仓3报废仓4待检仓）*/
	@Excel(name = "仓库类型（1良品仓2不良品仓3报废仓4待检仓）", width = 15)
    @ApiModelProperty(value = "仓库类型（1良品仓2不良品仓3报废仓4待检仓）")
    private java.lang.String storeType;
	/**仓库类别（1大仓库2小仓库3产线暂存仓4虚拟仓）默认 1*/
	@Excel(name = "仓库类别（1大仓库2小仓库3产线暂存仓4虚拟仓）默认 1", width = 15)
    @ApiModelProperty(value = "仓库类别（1大仓库2小仓库3产线暂存仓4虚拟仓）默认 1")
    private java.lang.String storeMd;
	/**属性类别（1物料类）*/
	@Excel(name = "属性类别（1物料类）", width = 15)
    @ApiModelProperty(value = "属性类别（1物料类）")
    private java.lang.String pptType;
	/**禁用 Y- N*/
	@Excel(name = "禁用 Y- N", width = 15)
    @ApiModelProperty(value = "禁用 Y- N")
    private java.lang.String disable;
	/**使用组织编码*/
	@Excel(name = "使用组织编码", width = 15)
    @ApiModelProperty(value = "使用组织编码")
    private java.lang.String orgId;
    /**创建人*/
    @ApiModelProperty(value = "创建人")
    private java.lang.String createBy;
    /**创建日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private java.util.Date createTime;
    /**更新人*/
    @ApiModelProperty(value = "更新人")
    private java.lang.String updateBy;
    /**更新日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;
    /**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private java.lang.String sysOrgCode;
}
