package org.jeecg.modules.iost.ims.kingdeeapi;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.KingdeeLogUtil;
import org.jeecg.modules.iost.ims.Util.KingdeeResultParseUtil;
import org.jeecg.modules.iost.ims.entity.ImsLoss;
import org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

@Component
public class ImsLossApi implements web_api{
    @Autowired
    private CategoryDao categoryDao;

    private String sFormId;
    private String Father_FEnrtyID;
    private String KingdeeLogPushName;
    private String KingdeeLogName;
    private String Father_sFormId;
    private String push_Rule;
    private String Son_FEnrtyID;
    private String SeqName;
    public ImsLossApi() {
        sFormId = "STK_StockCountLoss";  //子单据Formid
        KingdeeLogName = "盘点盘亏";    //金蝶云修改操作日志-nam
    }

    @Override
    public String add(Map<String, Object> maps) {
        return null;
    }

    public List<Map<String, String>> addTwo(List<Map<String, Object>> lists) {
        String result = new String( );
        Map<String, Object> stringStringMap = ImsToKingdee(lists);
        JSONObject responseStatus = categoryDao.addReturn(KingdeeLogName, sFormId, JsonUtil.Mapjson(stringStringMap));
        List<JSONObject> successEntitys = (List<JSONObject>) responseStatus.get("SuccessEntitys");
        Boolean isSuccess = (Boolean) responseStatus.get("IsSuccess");
        String successEntitysString = JSON.toJSONString(successEntitys);
        if (isSuccess == false) {
            String message = new String();
            List<JSONObject> Errors = (List<JSONObject>) responseStatus.get("Errors");
            for (JSONObject error : Errors) {
                JSONObject messags = Errors.get(0);
                message = message + " " + String.valueOf(messags.get("Message"));
            }
            result = String.valueOf(message);
        }
        List<Map<String, String>> list = new ArrayList<>();
        if (!ObjectUtils.isEmpty(successEntitys)) {
            for (JSONObject successEntity : successEntitys) {
                String FID = successEntity.get("Id").toString();
                String FBillNo = successEntity.get("Number").toString();
                Map<String, String> map = new HashMap<>();
                map.put("FID", FID);
                map.put("FBILL_NO", FBillNo);
                map.put("result", result);
                list.add(map);
            }
        } else {
            Map<String, String> map = new HashMap<>();
            map.put("result", result);
            list.add(map);
        }
        return list;
    }
    public Result addReturnResult(List<Map<String, Object>> lists) {
        Map<String, Object> stringStringMap = ImsToKingdee(lists);
        String result = categoryDao.addReturnResult(KingdeeLogName, sFormId, JsonUtil.Mapjson(stringStringMap));
        Result result1 = KingdeeResultParseUtil.parseAddResult(result);
        return result1;
    }
    /*ims字段转换成金蝶云待添加(其实都是下推后修改)字段*/
    public Map<String, Object> ImsToKingdee(List<Map<String,Object>> lists) {
        List<Map<String, Object>> list = new ArrayList<>();
        Map<String, Object> ModelMap = new HashMap<>();
        for (Map<String, Object> maps : lists) {
            Map<String, Object> FEntityMap = new HashMap<>();
            //字段转化
            FEntityMap.put("FStockId", new HashMap<String, Object>() {{
                put("FNumber", maps.get("STORE_ID"));
            }}); //仓库编码
            FEntityMap.put("FMaterialId", new HashMap<String, Object>() {{
                put("FNumber", maps.get("MTRL_ID"));
            }}); //物料编码
            FEntityMap.put("F_INVRNTTORY", maps.get("QUANTITY")); //传入的数量盘盈亏数量
            FEntityMap.put("Fnote", maps.get("REMARK")); //备注
            list.add(FEntityMap);
            ModelMap.put("FStockOrgId", new HashMap<String, Object>() {{
                put("FNumber", maps.get("ORG_ID"));
            }}); //库存组织
            ModelMap.put("FDate", maps.get("TRX_DATE"));  //交易时间
        }
        ModelMap.put("FBillEntry", list);
        return ModelMap;
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        return null;
    }

    /*根据FID查询FEntity_FEntryId*/
    public String select(String seq, String FID) {
        if (ObjectUtils.isEmpty(FID)) {
            FID = new String();
        }
        String FEntity_FEntryId = categoryDao.Son_FindFentryId(SeqName, Son_FEnrtyID, Integer.valueOf(seq), FID, sFormId);
        return FEntity_FEntryId;
    }

    @Override
    public String update(
            Object object) {
        return null;
    }

    /*父单据下推到子单据*/
    public Map<String, String> push(Map<String, Object> maps) {
        String FEntryID; //父单据FEntryID
        ImsLoss ImsLoss = JSON.parseObject(JSON.toJSONString(maps), ImsLoss.class);//map转为实体类对象
        //查询是否有FEntryID传入，没有就其他方法查询出
        if (ObjectUtils.isEmpty(maps.get("SEQ_ENTRY_CODE"))) {
            //根据父单据编码和行号(ERP工单行号)在数据库同步表查出父单据的FEntryID
            FEntryID = categoryDao.Father_FindFentryId(Father_FEnrtyID, Integer.valueOf(ImsLoss.getFbillNo()), maps, Father_sFormId);
        } else {
            FEntryID = maps.get("SEQ_ENTRY_CODE").toString();
        }
        //目标单据为子单据Formid
        String TargetFormId = sFormId;
        //下推父单据的Fromid-EntryID-单据转换规则(写死，客户端查询)-目标单据FormId-
        String pushResult = categoryDao.push(KingdeeLogPushName, Father_sFormId, FEntryID, push_Rule, TargetFormId);
        //解析信息，得到返回的本单据的单据编码FID和FBillNo
        JSONObject jsonObject = JSON.parseObject(pushResult);
        JSONObject result1 = (JSONObject) jsonObject.get("Result");
        JSONObject responseStatus = (JSONObject) result1.get("ResponseStatus");
        List<JSONObject> successEntitys = (List<JSONObject>) responseStatus.get("SuccessEntitys");
        //如果为空说明下推失败没得到成功结果
        if (ObjectUtils.isEmpty(successEntitys)) {
            Map<String, String> map = new HashMap<>();
            return map;
        } else {
            JSONObject SuccessEntitysList = successEntitys.get(0);
            String FID = SuccessEntitysList.get("Id").toString();
            String FBillNo = SuccessEntitysList.get("Number").toString();
            Map<String, String> map = new HashMap<>();
            map.put("FID", FID);
            map.put("FBILL_NO", FBillNo);
            return map;
        }
    }

    /*父单据下推到子单据*/
    public List<Map<String, String>> pushMore(List<Map<String, Object>> lists) {
        List<String> FEntryIDs = new ArrayList<>(); //父单据FEntryID
        for (Map<String, Object> maps : lists) {
            ImsLoss ImsLoss = JSON.parseObject(JSON.toJSONString(maps), ImsLoss.class);//map转为实体类对象
            //查询是否有FEntryID传入，没有就其他方法查询出
            if (ObjectUtils.isEmpty(maps.get("SEQ_ENTRY_CODE"))) {
                //根据父单据编码和行号(ERP工单行号)在数据库同步表查出父单据的FEntryID
                String FEntryID = categoryDao.Father_FindFentryId(Father_FEnrtyID, Integer.valueOf(ImsLoss.getCreateBy()), maps, Father_sFormId);
                FEntryIDs.add(FEntryID);
            } else {
                String FEntryID = maps.get("SEQ_ENTRY_CODE").toString();
                FEntryIDs.add(FEntryID);
            }
        }
        //目标单据为子单据Formid
        String TargetFormId = sFormId;
        //下推父单据的Fromid-EntryID-单据转换规则(写死，客户端查询)-目标单据FormId-
        String pushResult = categoryDao.pushMore(KingdeeLogPushName, Father_sFormId, FEntryIDs, push_Rule, TargetFormId);
        //解析信息，得到返回的本单据的单据编码FID和FBillNo
        JSONObject jsonObject = JSON.parseObject(pushResult);
        JSONObject result1 = (JSONObject) jsonObject.get("Result");
        JSONObject responseStatus = (JSONObject) result1.get("ResponseStatus");
        List<JSONObject> successEntitys = (List<JSONObject>) responseStatus.get("SuccessEntitys");
        //如果为空说明下推失败没得到成功结果

        if (ObjectUtils.isEmpty(successEntitys)) {
            List<Map<String, String>> list = new ArrayList<>();
            return list;
        } else {
            List<Map<String, String>> list = new ArrayList<>();
            for (JSONObject successEntity : successEntitys) {
                String FID = successEntity.get("Id").toString();
                String FBillNo = successEntity.get("Number").toString();
                Map<String, String> map = new HashMap<>();
                map.put("FID", FID);
                map.put("FBILL_NO", FBillNo);
                list.add(map);
            }
            return list;
        }
    }
}

