package org.jeecg.modules.iost.ims.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.ImsUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.KingdeeLogUtil;
import org.jeecg.modules.iost.ims.entity.ImsDept;
import org.jeecg.modules.iost.ims.entity.ImsDn;
import org.jeecg.modules.iost.ims.kingdeeapi.DnKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsDnMapper;
import org.jeecg.modules.iost.ims.service.IImsDnService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description: ims发货通知单
 * @Author: jeecg-boot
 * @Date:   2021-09-22
 * @Version: V1.0
 */
@Service
public class ImsDnServiceImpl extends ServiceImpl<ImsDnMapper, ImsDn> implements IImsDnService {
    @Autowired
    DnKingdeeApi dnKingdeeApi;
    @Autowired
    IMSApi imsApi;
    @Override
    public Boolean synchronization(Object object, LoginUser sysUser) throws ParseException {
        KingdeeLogUtil kingdeeLogUtil =new KingdeeLogUtil();
        ImsLogUtil imsLogUtil=new ImsLogUtil();
        List<ImsDn> pojolist=new ArrayList<>();
        List<Map<String, String>> list=new ArrayList<>();
        Boolean success = false;
        Map<String,String> idmap=new HashMap<>();

        //设置需要同步的主键
        idmap.put("FID",object.toString());
        //将对应信息请求金蝶云
        list=dnKingdeeApi.selectAndLog(idmap,null,"发货通知单");
        //遍历集合拿到所有的MAP
        for (Map<String, String> data : list) {
            //判断是否有错误
            if(data.containsKey("false")){
                return success;
            }
            //将实体信息记录下来
            ImsDn pojo = new ImsDn();
            pojo.setFid(data.get("fid"));
            pojo.setAuditId(data.get("AUDIT_ID"));
            pojo.setCustId(data.get("CUST_ID"));
            pojo.setMtrlId(data.get("MTRL_ID"));
            pojo.setStoreId(data.get("STORE_ID"));
            pojo.setQuantity(data.get("QUANTITY"));
            pojo.setRemark(data.get("REMARK"));
            pojo.setMtrlSeq(data.get("MTRL_SEQ"));
            pojo.setSoId(data.get("SO_ID"));
            pojo.setSoSeq(data.get("SO_SEQ"));
            pojo.setIsPre(data.get("IS_PRE"));
            pojo.setHdate(data.get("H_DATE"));
            pojo.setCreateTime(new Date());
            if(sysUser!=null){
                pojo.setCreateBy(sysUser.getUsername());
                pojo.setSysOrgCode(sysUser.getOrgCode());
            }
            pojolist.add(pojo);
        }
        //将数据包装成IMS格式
        Map<String,Object> map=new HashMap<>();
        map.put("success","true");
        map.put("message","操作成功");
        map.put("result", list);
        String mapjson = JsonUtil.Mapjson(map);
        String request=JsonUtil.Listjson(list);
        String body = ImsUtil.getIms("TB_PP_DN",mapjson);
        //IMS同步
        String result = imsApi.add(body);
        //记录IMS日志
        Boolean flag = imsLogUtil.ImsLog(body,result, "发货通知单","TB_PP_DN");
        //将数据信息 存放到数据库
        this.saveBatch(pojolist);
        //设置同步成功状态
                success=flag;
//        success=true;
        return success;
    }
}
