package org.jeecg.modules.iost.ims.service.impl;

import com.alibaba.fastjson.JSON;
import org.jeecg.modules.iost.ims.Util.*;
import org.jeecg.modules.iost.ims.entity.ImsMtrl;
import org.jeecg.modules.iost.ims.entity.ImsPo;
import org.jeecg.modules.iost.ims.kingdeeapi.PoKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsPoMapper;
import org.jeecg.modules.iost.ims.service.IImsPoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description: ims采购订单表
 * @Author: jeecg-boot
 * @Date:   2021-09-24
 * @Version: V1.0
 */
@Service
public class ImsPoServiceImpl extends ServiceImpl<ImsPoMapper, ImsPo> implements IImsPoService {
    @Autowired
    PoKingdeeApi poKingdeeApi;
    @Override
    public Map<String,Object> getData(List<Map<String,Object>> xml) throws ParseException {
        List<Map<String, String>> list=new ArrayList<>();
        List<Map<String, String>> list1=new ArrayList<>();
        Map<String, Object> map=new HashMap<>();
        ImsLogUtil imsLogUtil=new ImsLogUtil();
        List<ImsPo> pojolist=new ArrayList<>();
        KingdeeLogUtil kingdeeLogUtil =new KingdeeLogUtil();
        imsLogUtil.ImsRequestLog(JsonUtil.Listjson(xml), "采购订单信息","PO");
        for(Map<String,Object> maps:xml){
            //将数据取出来
            //获取采购订单编码以及时间
            String poId="";
            Map<String,String> idmap=new HashMap<>();
            if(maps.get("PO_ID")!=null && !"".equals(maps.get("PO_ID"))){
                 poId=maps.get("PO_ID").toString();
                //将对应的参数设置成金蝶云的查询条件
                idmap.put("FBillNo",poId);

            }
            //判断是否有物料编码
            String mtrlId="";
            if(maps.get("MTRL_ID")!=null && !"".equals(maps.get("MTRL_ID"))){
                mtrlId=maps.get("MTRL_ID").toString();
                //将对应的参数设置成金蝶云的查询条件
                idmap.put("FMaterialId.Fnumber",mtrlId);

            }
            //判断是否有传进来日期
            String bDate="";
            String eDate="";
            if(maps.get("B_DATE")!=null && !"".equals(maps.get("B_DATE"))){
                bDate=maps.get("B_DATE").toString();
                idmap.put("FCreateDate",bDate);
            }
            if(maps.get("E_DATE")!=null && !"".equals(maps.get("E_DATE"))){
                eDate=maps.get("E_DATE").toString();
                idmap.put("FCreateDate",eDate);
            }
            idmap.put("FMRPTerminateStatus","A");
            idmap.put("FDocumentStatus","C");
            //从金蝶云获取对应数据
            //如果结束时间为空则查询开始时间到今天的
            if(eDate.isEmpty()&& bDate.isEmpty()){
                list1 = poKingdeeApi.selectAndLog(idmap, null,"采购订单");
            }else if(eDate.isEmpty()&&!bDate.isEmpty()){
                list1 = poKingdeeApi.selectdate1(idmap, null,"采购订单");
            }else {
                list1 = poKingdeeApi.selectdate(idmap, null, bDate,"采购订单");
            }
            //将每次获取的数据添加到集合一起返回
            list.addAll(list1);
            for (Map<String, String> data : list1) {
                //判断是否有错误
                if(data.containsKey("false")){
                        map.put("false",data.get("false"));
                    return map;
                }
                //将实体信息记录下来
                ImsPo pojo = new ImsPo();
                pojo.setFid(data.get("fid"));
                pojo.setPoId(data.get("PO_ID"));
                pojo.setMtrlId(data.get("MTRL_ID"));
                pojo.setMqty(data.get("M_QTY"));
                pojo.setRmQty(data.get("RM_QTY"));
                pojo.setSmQty(data.get("SM_QTY"));
                pojo.setSupId(data.get("SUP_ID"));
                pojo.setIsOuts(data.get("IS_OUTS"));
                pojo.setPdhDate(data.get("PDH_DATE"));
                pojo.setPoOrgId(data.get("PO_ORG_ID"));
                pojo.setCreateTime(new Date());
                pojo.setOrgId(data.get("ORG_ID"));
                pojo.setPoLine(data.get("PO_LINE"));
                pojo.setSettleSup(data.get("SETTLE_SUP"));
                pojolist.add(pojo);
            }
        }

        //将数据信息 存放到数据库
        this.saveBatch(pojolist);
//        //将查询结果封装成JSON
//        String listjson = JsonUtil.Listjson(list);
        //将结果返回
        map.put("true",list);
        return map;
    }
}
