package org.jeecg.modules.iost.ims.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.ImsUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.KingdeeLogUtil;
import org.jeecg.modules.iost.ims.entity.ImsWplan;
import org.jeecg.modules.iost.ims.kingdeeapi.WplanKingdeeApi;
import org.jeecg.modules.iost.ims.kingdeeapi.WplanOutsKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsWplanMapper;
import org.jeecg.modules.iost.ims.service.IImsWplanService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
/**
 * @Description: 生产订单基础信息
 * @Author: jeecg-boot
 * @Date:   2021-09-13
 * @Version: V1.0
 */
@Service
public class ImsWplanServiceImpl extends ServiceImpl<ImsWplanMapper, ImsWplan> implements IImsWplanService {
    @Autowired
    WplanKingdeeApi wplanKingdeeApi;
    @Autowired
    IMSApi imsApi;

    /**
     * 同步金蝶云数据
     * @param object
     * @return
     * @throws ParseException
     */
    @Override
    public Boolean synchronization(Object object, LoginUser sysUser) throws ParseException {
        KingdeeLogUtil kingdeeLogUtil =new KingdeeLogUtil();
        List<ImsWplan> pojolist=new ArrayList<>();
        ImsLogUtil imsLogUtil=new ImsLogUtil();
        List<Map<String, String>> list=new ArrayList<>();
        Boolean success = false;
        Map<String,String> idmap=new HashMap<>();

        //设置需要同步的主键
        idmap.put("FID",object.toString());
        //将对应信息请求金蝶云
        list=wplanKingdeeApi.selectAndLog(idmap,null,"ERP工单信息");
        //遍历集合拿到所有的MAP
        for (Map<String, String> data : list) {
            //判断是否有错误
            if(data.containsKey("false")){
                return success;
            }
            //将实体信息记录下来
            ImsWplan pojo = new ImsWplan();
            pojo.setFid(data.get("fid"));
            pojo.setErpMo(data.get("ERP_MO"));
            pojo.setProdId(data.get("PROD_ID"));
            pojo.setPqty(data.get("P_QTY"));
            pojo.setPbDate(data.get("PB_DATE"));
            pojo.setPeDate(data.get("PE_DATE"));
            pojo.setSoId(data.get("SO_ID"));
            pojo.setSoSeq(data.get("SO_SEQ"));
            pojo.setCustId(data.get("CUST_ID"));
            pojo.setOrgId(data.get("ORG_ID"));
            pojo.setIsOuts("N");
            pojo.setErpMoSeq(data.get("ERP_MO_SEQ"));
            pojo.setPtId(data.get("PT_ID"));
            pojo.setRemark(data.get("REMARK"));
            pojo.setCreateTime(new Date());
            if(sysUser!=null){
                pojo.setCreateBy(sysUser.getUsername());
                pojo.setSysOrgCode(sysUser.getOrgCode());
            }
            pojolist.add(pojo);
        }
        //将数据信息 存放到数据库
        this.saveBatch(pojolist);
        //将数据包装成IMS格式
        Map<String,Object> map=new HashMap<>();
        map.put("success","true");
        map.put("message","操作成功");
        map.put("result", list);
        String mapjson = JsonUtil.Mapjson(map);
        String request=JsonUtil.Listjson(list);
        String body = ImsUtil.getIms("TB_PP_WPLAN",mapjson);
        //IMS同步
        String result = imsApi.add(body);
        //记录IMS日志
        Boolean flag = imsLogUtil.ImsLog(body,result, "ERP工单信息","TB_PP_WPLAN");
        //设置同步成功状态
                success=flag;
//            success=true;
        return success;
    }

    /**
     * 手动获取金蝶云数据
     * @param mapjson
     * @return
     */
    @Override
    public Map<String,Object> getData(List<Map<String,Object>> mapjson) throws ParseException {
        List<Map<String, String>> list=new ArrayList<>();
        List<Map<String, String>> list1=new ArrayList<>();
        Map<String,Object> map=new HashMap<>();
        ImsLogUtil imsLogUtil=new ImsLogUtil();
        List<ImsWplan> pojolist=new ArrayList<>();
        KingdeeLogUtil kingdeeLogUtil =new KingdeeLogUtil();
        //记录IMS日志
        imsLogUtil.ImsRequestLog(JsonUtil.Listjson(mapjson), "ERP工单信息", "WPLAN");
        for(Map<String,Object> maps:mapjson) {
            //获取采购订单编码以及时间
            String poId = maps.get("ERP_MO").toString();
            Map<String, String> idmap = new HashMap<>();
            //将对应的参数设置成金蝶云的查询条件
            idmap.put("FBillNo", poId);
            //从金蝶云获取对应数据
            list1 = wplanKingdeeApi.selectAndLog(idmap, null, "ERP工单信息");
            //将每次获取的数据添加到集合一起返回
            list.addAll(list1);
            for (Map<String, String> data : list1) {
                //将实体信息记录下来
                //判断是否有错误
                if(data.containsKey("false")){
                    map.put("false",data.get("false"));
                    return map;
                }
                ImsWplan pojo = new ImsWplan();
                pojo.setFid(data.get("fid"));
                pojo.setErpMo(data.get("ERP_MO"));
                pojo.setProdId(data.get("PROD_ID"));
                pojo.setPqty(data.get("P_QTY"));
                pojo.setPbDate(data.get("PB_DATE"));
                pojo.setPeDate(data.get("PE_DATE"));
                pojo.setSoId(data.get("SO_ID"));
                pojo.setSoSeq(data.get("SO_SEQ"));
                pojo.setCustId(data.get("CUST_ID"));
                pojo.setOrgId(data.get("ORG_ID"));
                pojo.setPtId(data.get("PT_ID"));
                pojo.setIsOuts("N");
                pojo.setErpMoSeq(data.get("ERP_MO_SEQ"));
                pojo.setRemark(data.get("REMARK"));
                pojo.setCreateTime(new Date());
                pojolist.add(pojo);
            }
        }
        //将数据信息 存放到数据库
        this.saveBatch(pojolist);
        //将查询结果封装成JSON
        String listjson = JsonUtil.Listjson(list);
        //将结果返回
        map.put("true",list);
        return map;
    }


}
