package org.jeecg.modules.iost.ims.controller;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.iost.ims.entity.ImsWplanMnOuts;
import org.jeecg.modules.iost.ims.service.IImsWplanMnOutsService;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

 /**
 * @Description: ims委外工单物料需求信息
 * @Author: jeecg-boot
 * @Date:   2021-09-29
 * @Version: V1.0
 */
@Api(tags="委外工单物料需求信息")
@RestController
@RequestMapping("/imsWplanMnOuts")
@Slf4j
public class ImsWplanMnOutsController extends JeecgController<ImsWplanMnOuts, IImsWplanMnOutsService> {
	@Autowired
	private IImsWplanMnOutsService imsWplanMnOutsService;
	
	/**
	 * 分页列表查询
	 *
	 * @param imsWplanMnOuts
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@AutoLog(value = "ims委外工单物料需求信息-分页列表查询")
	@ApiOperation(value="ims委外工单物料需求信息-分页列表查询", notes="ims委外工单物料需求信息-分页列表查询")
	@GetMapping(value = "/list")
	public Result<?> queryPageList(ImsWplanMnOuts imsWplanMnOuts,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req,String date) {
		QueryWrapper<ImsWplanMnOuts> queryWrapper = QueryGenerator.initQueryWrapper(imsWplanMnOuts, req.getParameterMap()).orderByDesc("create_time");
		Page<ImsWplanMnOuts> page = new Page<ImsWplanMnOuts>(pageNo, pageSize);
		if(!"null".equals(date)){
			SimpleDateFormat sdf1 =new SimpleDateFormat("yyyy-MM-dd" );
			Date parse = null;
			try {
				parse = sdf1.parse(date);
			} catch (ParseException e) {
				e.printStackTrace();
			}
			//根据查询日期拿到明天
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(parse);
			calendar.add(Calendar.DATE,1);
			String parse1=sdf1.format(calendar.getTime());
			queryWrapper.gt("create_time",parse);
			queryWrapper.lt("create_time",parse1);
		}
		IPage<ImsWplanMnOuts> pageList = imsWplanMnOutsService.page(page, queryWrapper);
		return Result.OK(pageList);
	}

	 /**
	  * ERP委外用料清单信息
	  *
	  * @return
	  * @throws ParseException
	  */
	 @AutoLog(value = "ERP委外用料清单信息获取")
	 @ApiOperation(value = "ERP委外用料清单信息获取", notes = "ERP委外用料清单信息获取")
	 @PostMapping(value = "/getData")
	 public Result<?> getData(List<Map<String,Object>> id) throws ParseException {
		 Map<String,Object> data = imsWplanMnOutsService.getData(id);
		 if (data.get("false").toString().isEmpty()){
			 return Result.error("ERP委外用料清单",data.get("false").toString());
		 }else {
			 return Result.OK(data.get("true"),"ERP委外用料清单");
		 }
	 }

}
