package org.jeecg.modules.iost.ims.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;

import java.io.Serializable;

@Data
@TableName("ims_syn")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="syn对象", description="ims同步信息")
public class Syn implements Serializable {
    private static final long serialVersionUID = 1L;

    /**主键*/
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
    /**实体主键*/
    @Excel(name = "实体主键", width = 15)
    @ApiModelProperty(value = "实体主键")
    private String fid;
    @Excel(name = "数据实体主键", width = 15)
    @ApiModelProperty(value = "数据实体主键")
    private String dataid;
    /**供应商编码*/
    @Excel(name = "表单id", width = 15)
    @ApiModelProperty(value = "表单id")
    private String formid;
    /**供应商名称*/
    @Excel(name = "是否同步", width = 15)
    @ApiModelProperty(value = "是否同步")
    private String synchronization;
    @Excel(name = "创建时间", width = 15)
    @ApiModelProperty(value = "创建时间")
    private java.lang.String createtime;
}
