package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.TimeUtil;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 查询金蝶云采购订单信息
 */
@Component
public class PoKingdeeApi implements web_api {
    /**操作的单据体名称*/
    private String sFormId = "PUR_PurchaseOrder";//采购订单
    @Autowired
    private CategoryDao categoryDao;
    private Map<String,String> key = new LinkedHashMap<>();
    public PoKingdeeApi(){
        /*查询字段*/
        key.put("FID","FID");//单据头实体主键
        key.put("FBillNo","FBillNo");//编码
        key.put("FMaterialId.Fnumber","FMaterialId.Fnumber");//物料编码
        key.put("FQty","FQty");//采购数量
        key.put("FReceiveQty","FReceiveQty");//累计收料数量
        key.put("FStockInQty","FStockInQty");//累计入库数量
        key.put("FSupplierId.Fnumber","FSupplierId.Fnumber");//供应商
        key.put("FBusinessType","FBusinessType");//业务类型
        key.put("FDeliveryDate","FDeliveryDate");//交货日期
        key.put("FPurchaseOrgId.Fnumber","FPurchaseOrgId.Fnumber");//采购组织
        key.put("FReceiveOrgId.Fnumber","FReceiveOrgId.Fnumber");//收料组织
        key.put("FPOOrderEntry_FSeq","FPOOrderEntry_FSeq");//明细序号
        key.put("FSettleId.FNumber","FSettleId.FNumber");//结算方编码
        key.put("FSTOCKRETQTY","FSTOCKRETQTY");//库存可退数量
    }
    @Override
    public String add(Map json) {
        return null;
    }
    /**
     * 查询根据ID查询
     * @param map
     * @param where
     * @return
     * @throws ParseException
     */
    public List<Map<String, String>> selectAndLog(Map<String, String> map, String where,String name) throws ParseException {
        List<List<Object>> list = categoryDao.selectAndLog(sFormId, key,map,name);
        return Po(list);
    }

    /**
     * 查询对应日期内的采购订单
     * @param map
     * @param where
     * @param date
     * @return
     * @throws ParseException
     */
    public List<Map<String, String>> selectdate(Map<String, String> map, String where,String date,String name) throws ParseException {
        List<List<Object>> list = categoryDao.selectdate(sFormId, key,map,date,name);
        return Po(list);
    }
    /**
     * 查询对应日期内的采购订单
     * @param map
     * @param where
     * @param
     * @return
     * @throws ParseException
     */
    public List<Map<String, String>> selectdate1(Map<String, String> map, String where,String name) throws ParseException {
        List<List<Object>> list = categoryDao.selectdate1(sFormId, key,map,name);
        return Po(list);
    }
    /**
     * 将查询到的数据封装成本地字段
     * @return
     */
    private List<Map<String,String>> Po(List<List<Object>> list){
        List<Map<String,String>> salesorderlist = new ArrayList<>();
        //如果返回信息没报错
        if(!list.isEmpty()) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                for (List<Object> list1 : list) {
                    Map<String, String> salesordermap = new HashMap<>();
                    salesordermap.put("fid", list1.get(0).toString());
                    salesordermap.put("PO_ID", list1.get(1).toString());
                    salesordermap.put("MTRL_ID", list1.get(2).toString());
                    salesordermap.put("M_QTY", list1.get(3).toString());
                    salesordermap.put("RM_QTY", list1.get(4).toString());
                    salesordermap.put("SM_QTY", list1.get(5).toString());
                    salesordermap.put("SUP_ID", list1.get(6).toString());
                    if ("WW".equals(list1.get(7).toString())) {
                        salesordermap.put("IS_OUTS", "Y");
                    } else {
                        salesordermap.put("IS_OUTS", "N");
                    }
                    Date parse = null;
                    try {
                        parse = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS").parse(TimeUtil.timeSSS(list1.get(8).toString()));
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                    String pdhDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(parse);
                    salesordermap.put("PDH_DATE", pdhDate);
                    salesordermap.put("PO_ORG_ID", list1.get(9).toString());
                    salesordermap.put("ORG_ID", list1.get(10).toString());
                    salesordermap.put("PO_LINE", list1.get(11).toString());
                    salesordermap.put("STORE_ID","");
                    salesordermap.put("SETTLE_SUP",list1.get(12).toString());
                    salesordermap.put("RETURN_QTY",list1.get(13).toString());
                    salesorderlist.add(salesordermap);
                }
            } else {
                //如果有错误信息则返回
                Map<String,Object> o = (Map<String, Object>) list.get(0).get(0);
                Object errors = o.get("Errors");
                List parse3 = (List) JSON.parse(errors.toString());
                Map parse4 = (Map) JSON.parse(parse3.get(0).toString());
                Object message = parse4.get("Message");
                Map<String, String> salesordermap = new HashMap<>();
                salesordermap.put("false", message.toString());
                salesorderlist.add(salesordermap);
            }
        }
        return salesorderlist;
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        return null;
    }

    @Override
    public String update(Object object) {
        return null;
    }
}
