package org.jeecg.modules.iost.ims.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import net.sf.json.JSONObject;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.ImsUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.KingdeeLogUtil;
import org.jeecg.modules.iost.ims.entity.ImsCustomer;
import org.jeecg.modules.iost.ims.entity.ImsSupplier;
import org.jeecg.modules.iost.ims.entity.Imslog;
import org.jeecg.modules.iost.ims.kingdeeapi.CustomerKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsCustomerMapper;
import org.jeecg.modules.iost.ims.service.IImsCustomerService;
import org.jeecg.modules.iost.ims.service.IKingdeelogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description: ims客户信息
 * @Author: jeecg-boot
 * @Date:   2021-09-06
 * @Version: V1.0
 */
@Service
public class ImsCustomerServiceImpl extends ServiceImpl<ImsCustomerMapper, ImsCustomer> implements IImsCustomerService {

    @Autowired
    ImsCustomerMapper customerMapper;
    @Autowired
    CustomerKingdeeApi customerKingdeeApi;
    @Autowired
    IMSApi imsApi;

    @Override
    public JSONObject add(Map<String, String> map) {
        return null;
    }

    @Override
    public JSONObject select(Map<String, String> map) {
        return null;
    }

    /**
     * 从金蝶云同步客户信息
     * @param object
     * @return
     * @throws ParseException
     */
    @Override
    public Boolean synchronization(Object object, LoginUser sysUser) throws ParseException {
        KingdeeLogUtil kingdeeLogUtil =new KingdeeLogUtil();
        ImsLogUtil imsLogUtil=new ImsLogUtil();
        List<ImsCustomer> pojolist=new ArrayList<>();
        List<Map<String, String>> list=new ArrayList<>();
        Boolean success = false;
        Map<String,String> idmap=new HashMap<>();

        //设置需要同步的主键
        idmap.put("FCUSTID",object.toString());
        //将对应信息请求金蝶云
            list=customerKingdeeApi.selectAndLog(idmap,null,"客户信息");
            //遍历集合拿到所有的MAP
            for (Map<String, String> data : list) {
                //判断是否有错误
                if(data.containsKey("false")){
                    return success;
                }
                //将实体信息记录下来
                ImsCustomer pojo = new ImsCustomer();
                pojo.setFid(data.get("fid"));
                pojo.setDisable(data.get("DISABLE"));
                pojo.setCustId(data.get("CUST_ID"));
                pojo.setOrgId(data.get("ORG_ID"));
                pojo.setErpCustId(data.get("CUST_ID"));
                pojo.setCustName(data.get("CUST_NAME"));
                pojo.setCreateTime(new Date());
                if(sysUser!=null){
                    pojo.setCreateBy(sysUser.getUsername());
                    pojo.setSysOrgCode(sysUser.getOrgCode());
                }
                pojolist.add(pojo);
            }
            //将数据包装成IMS格式
            Map<String,Object> map=new HashMap<>();
            map.put("success","true");
            map.put("message","操作成功");
            map.put("result",list);
            String mapjson = JsonUtil.Mapjson(map);
            String body = ImsUtil.getIms("TB_BS_CUST",mapjson);
            //IMS同步
            String result = imsApi.add(body);
            //记录IMS日志
            Boolean flag = imsLogUtil.ImsLog(body,result, "客户信息","TB_BS_CUST");
            //将数据信息 存放到数据库
            this.saveBatch(pojolist);
                //设置同步成功状态
                success=flag;
//            success=true;
        return success;
    }

    @Override
    public Boolean grid(Map<String, String> stringStringMap) throws ParseException {
        return null;
    }

    @Override
    public List<Map<String, String>> queryList(Integer pageNo, Integer pageSize) throws ParseException {
        List<Map<String, String>> list = customerKingdeeApi.queryList(null, null, "客户信息分页查询", pageNo, pageSize);
        return list;
    }
}
