package org.jeecg.modules.iost.ims.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;

import org.jeecg.common.exception.DataRepeatException;
import org.jeecg.common.exception.KingdeeSelectException;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.MapUtils;
import org.jeecg.modules.iost.ims.entity.ImsPurchase;
import org.jeecg.modules.iost.ims.kingdeeapi.PurchaseKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsPurchaseMapper;
import org.jeecg.modules.iost.ims.service.IImsPurchaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * @Description: 采购订单收料入库
 * @Author: jeecg-boot
 * @Date: 2021-10-06
 * @Version: V1.0
 */
@Service
public class ImsPurchaseServiceImpl extends ServiceImpl<ImsPurchaseMapper, ImsPurchase> implements IImsPurchaseService {

    @Autowired
    PurchaseKingdeeApi purchaseKingdeeApi;
    private String imsLogName;
    private String DocType;
    private String SEQ;

    public ImsPurchaseServiceImpl() {
        this.imsLogName = "采购入库";  //ims日志-name
        this.DocType = "R170C";  //调用者传入的标识
        this.SEQ = "PO_SEQ";  //父单据行号，一般默认是这个字符串(有些单据是AUDIT_SEQ)
    }

    /**
     * 添加数据到金蝶云
     *
     * @param list
     * @return
     */
    @Override
    public String setData(List<Map<String, Object>> list, String code) {
        String FBillNo="";
        String message ="";
        String s1="";
        List<String> ids=new ArrayList<>();
        List<String> Numbers = new ArrayList<>(); //父单据单据编码
        List<ImsPurchase> pojoList=new ArrayList<>();
        String selectmessage = "";
        //添加IMS请求日志
        ImsLogUtil imsLogUtil = new ImsLogUtil();
        imsLogUtil.ImsRequestLog(JsonUtil.Listjson(list), imsLogName, DocType);
        String errors = null;
        //遍历传入的集合信息
        for (Map<String, Object> maps : list) {
            ids.add(maps.get("QUEUE_ID").toString());
        }
        QueryWrapper<ImsPurchase> qw=new QueryWrapper();
        qw.in("queue_id",ids);
        StringBuilder builder=new StringBuilder();
        int length=ids.size();
        for (int i=0;i<length;i++) {
            if(i==0) {
                builder.append(ids.get(i));
            }
            else {
                builder.append(",").append(ids.get(i));
            }
        }
        qw.orderByAsc("FIELD(queue_id,"+builder.toString()+")");
        List<ImsPurchase> repeatLists = this.getBaseMapper().selectList(qw);
        //筛选出重复的单据
        if (!repeatLists.isEmpty()) {
            for (String s : ids) {
                s1=s+",";
            }
            s1=s1.substring(0,s1.length() -1);
            message= message+"唯一序号为 ：" + s1 + "的数据已经提交过!    ";
            System.out.println(message+"----------------------------------------");
            throw new DataRepeatException("操作失败", message, code);
        }
        //筛选出有父单据行内码的数据
        if (!list.isEmpty()) {
            for(Map<String, Object> maps : list){
                //根据父单据编码在金蝶云中查出父单据的行内码
                Object select = purchaseKingdeeApi.select(maps);
                if (select == null) {
                    selectmessage =selectmessage+maps.get("ERP_TRX_CODE")+",";
                } else if (select.toString().contains("Errors")) {
                    //如果有错误信息则返回
                    Map<String, Object> o = (Map<String, Object>) select;
                    String mapjson = JsonUtil.Mapjson(o);
                    Map parse = (Map) JSON.parse(mapjson);
                    Object result = parse.get("Result");
                    Map parse1 = (Map) JSON.parse(result.toString());
                    Object responseStatus = parse1.get("ResponseStatus");
                    Map parse2 = (Map) JSON.parse(responseStatus.toString());
                    Object error = parse2.get("Errors");
                    List parse3 = (List) JSON.parse(error.toString());
                    Map parse4 = (Map) JSON.parse(parse3.get(0).toString());
                    Object messages = parse4.get("Message");
                    selectmessage = messages.toString();
                }else {
                    //添加所有单据编码
                    Numbers.add(maps.get("ERP_TRX_CODE").toString());
                }
            }
            //判断是否有父单据错误
            if(selectmessage!=""){
                selectmessage=selectmessage.substring(0,selectmessage.length()-1);
                message="注意:单据"+selectmessage+ "不存在!   ";
                System.out.println(message+"----------------------------------------");
                throw new KingdeeSelectException("操作失败",message,code);
            }

            //添加单据的部分字段必须先下推才能修改
            //首先下推父单据到子单据，然后获取返回结果里面子单据的FID
            String pushmessage = null;
            List<Map<String, String>> pushResult = purchaseKingdeeApi.pushMore(Numbers);
            //判断是否有message这个键值对，没有说明下推成功，存在说明下推失败
            if (!StringUtils.isEmpty(pushResult.get(0).get("messgae"))) {
                pushmessage = pushResult.get(0).get("messgae");
                message="下推失败！失败原因有:" + pushmessage;
                throw new KingdeeSelectException("操作失败",message,code);
            }
                for (Map<String, Object> needmaps : list) {
                    //返回 pushmessage为空表示下推成功，如果下推失败就不向金蝶云修改信息，也不记录金蝶云日志
                    for (Map<String, String> stringStringMap : pushResult) {
                        //根据父单据的行内码作为子单据的源单分录内码和主键来查询明细主键
                        List<Object> list1 = purchaseKingdeeApi.select(needmaps.get("ERP_TRX_CODE").toString(), stringStringMap.get("FID"));
                        //修改单据带入的过滤条件
                        needmaps.put("FID", stringStringMap.get("FID"));
                        needmaps.put("FBILLNO", stringStringMap.get("FBILLNO"));
                        needmaps.put("FEntry_ID", list1.get(1));  //取名有讲究，下面转换成实体字段时候要按照取名标准来FEntry_ID转换成实体类fentryId
                        needmaps.put("FSEQ", list1.get(0));
                    }
                }
            //向金蝶云修改下推后增加的数据
            JSONObject jsonObject = purchaseKingdeeApi.addTwo(list);
            List<JSONObject> successEntitys = (List<JSONObject>) jsonObject.get("SuccessEntitys");
            Boolean isSuccess = (Boolean) jsonObject.get("IsSuccess");
            //根据判断
            if (isSuccess == false) {
                List<JSONObject> Errors = (List<JSONObject>) jsonObject.get("Errors");
                int i = 0;
                //拼接错误信息
                for (JSONObject error : Errors) {
                    JSONObject messags = Errors.get(i);
                    errors = errors + "---" + String.valueOf(messags.get("Message"));
                    i++;
                }
                //如果有错误删除整个单据
                purchaseKingdeeApi.delete(list.get(0).get("FID").toString());
            } else {
                for (JSONObject successEntity : successEntitys) {
                    FBillNo = successEntity.get("Number").toString();
                }
                //修改后再次保存 (覆盖)fbillno的实体
                for (Map<String, Object> needmaps : list) {
                    needmaps.put("FBILLNO",FBillNo);
                    //Map传入参数大写字段转化为实体类字段
                    Map<String, Object> map = MapUtils.mapsChange(needmaps);
                    ImsPurchase purchase = JSON.parseObject(JSON.toJSONString(map),ImsPurchase.class);//map转为实体类对象
                    pojoList.add(purchase);
                }
                this.saveBatch(pojoList);
            }
        }
            if(errors==null){
                return FBillNo;
            }else {
                message="修改失败,错误原因是:" + errors;
                System.out.println(message+"----------------------------------------");
                throw new KingdeeSelectException("操作失败",message,code);
            }
    }
}
