-- 创建mysql库
DROP DATABASE IF EXISTS `wmsSystem`;
create database `wmsSystem` default character set utf8mb4 collate utf8mb4_general_ci;

-- MySQL dump 10.13  Distrib 8.0.22, for Linux (x86_64)
--
-- Host: localhost    Database: wmssystem
-- ------------------------------------------------------
-- Server version	8.0.22

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;
USE `wmsSystem`;
--
-- Table structure for table `ces_field_kongj`
--

DROP TABLE IF EXISTS `ces_field_kongj`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ces_field_kongj` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '用户名',
  `sex` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '下拉框',
  `radio` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'radio',
  `checkbox` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'checkbox',
  `sel_mut` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '下拉多选',
  `sel_search` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '下拉搜索',
  `birthday` datetime DEFAULT NULL COMMENT '时间',
  `pic` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '图片',
  `files` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '文件',
  `remakr` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT 'markdown',
  `fuwenb` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT '富文本',
  `user_sel` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '选择用户',
  `dep_sel` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '选择部门',
  `ddd` double(10,0) DEFAULT NULL COMMENT 'DD类型',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ces_field_kongj`
--

LOCK TABLES `ces_field_kongj` WRITE;
/*!40000 ALTER TABLE `ces_field_kongj` DISABLE KEYS */;
INSERT INTO `ces_field_kongj` VALUES ('1260185893546840066','admin','2020-05-12 20:31:44','admin','2020-09-11 17:02:30','A01','A011','2','2','1,2','','',NULL,'','','','','zhagnxiao','A01',NULL),('1260185911146139650','admin','2020-05-12 20:31:49','admin','2020-07-20 17:10:05','A01','A011',NULL,'1','1,2',NULL,'admin',NULL,'d52a2834349b033b6d20d5cc16ce36d3d539bd7f_1594438138364.jpg','','',NULL,'admin','A01',NULL),('1285112866127577089','admin','2020-07-20 15:22:38','admin','2020-09-11 14:07:22','A01','张三2','','2','','','',NULL,'','','','','','',NULL);
/*!40000 ALTER TABLE `ces_field_kongj` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ces_order_customer`
--

DROP TABLE IF EXISTS `ces_order_customer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ces_order_customer` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '客户名字',
  `sex` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '客户性别',
  `birthday` datetime DEFAULT NULL COMMENT '客户生日',
  `age` int DEFAULT NULL COMMENT '年龄',
  `address` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '常用地址',
  `order_main_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '订单ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ces_order_customer`
--

LOCK TABLES `ces_order_customer` WRITE;
/*!40000 ALTER TABLE `ces_order_customer` DISABLE KEYS */;
INSERT INTO `ces_order_customer` VALUES ('1281792646935842818','admin','2020-07-11 11:29:16',NULL,NULL,'A01',NULL,NULL,NULL,NULL,NULL,'1260135645520654338'),('1281794386984779777','admin','2020-07-11 11:36:11',NULL,NULL,'A01','管理员','1','2018-12-05 00:00:00',NULL,NULL,'1281794386716344321'),('15889531549290863128','admin','2020-05-08 23:54:00',NULL,NULL,'A01','小王','1','2020-05-08 00:00:00',1,'','1258787241599250433'),('15889531551231672264','admin','2020-05-08 23:54:00',NULL,NULL,'A01','校长','2','2020-05-23 00:00:00',2,'','1258787241599250433'),('15889531554322486243','admin','2020-05-08 23:54:00',NULL,NULL,'A01','小明','2','2020-05-03 00:00:00',3,'','1258787241599250433'),('15892741044590530487','admin','2020-05-12 17:02:32',NULL,NULL,'A01A05','111','1','2020-05-12 00:00:00',NULL,'','1260133243631562754'),('15892741436981375151','admin','2020-05-12 17:02:32',NULL,NULL,'A01A05','11','1','2020-05-14 00:00:00',NULL,'','1260133243631562754');
/*!40000 ALTER TABLE `ces_order_customer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ces_order_goods`
--

DROP TABLE IF EXISTS `ces_order_goods`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ces_order_goods` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `good_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '商品名字',
  `price` double DEFAULT NULL COMMENT '价格',
  `num` int DEFAULT NULL COMMENT '数量',
  `zong_price` double DEFAULT NULL COMMENT '单品总价',
  `order_main_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '订单ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ces_order_goods`
--

LOCK TABLES `ces_order_goods` WRITE;
/*!40000 ALTER TABLE `ces_order_goods` DISABLE KEYS */;
INSERT INTO `ces_order_goods` VALUES ('15889531536650244013','admin','2020-05-08 23:54:00',NULL,NULL,'A01','显示器',11,1,11,'1258787241599250433'),('15889531538491119218','admin','2020-05-08 23:54:00',NULL,NULL,'A01','鼠标',22,2,44,'1258787241599250433'),('15889532051192650399','admin','2020-05-08 23:54:00',NULL,NULL,'A01','键盘',33,3,99,'1258787241599250433'),('15892741033410312304','admin','2020-05-12 17:02:32',NULL,NULL,'A01A05','雷蛇键盘',200,2,NULL,'1260133243631562754'),('15892741162151118866','admin','2020-05-12 17:02:32',NULL,NULL,'A01A05','樱桃键盘',200,4,NULL,'1260133243631562754'),('15892747180850346324','admin','2020-07-11 11:29:16',NULL,NULL,'A01','11',11,NULL,NULL,'1260135645520654338'),('15892934593221167669','admin','2020-07-11 11:29:16',NULL,NULL,'A01','',NULL,NULL,NULL,'1260135645520654338'),('15892934594762635052','admin','2020-07-11 11:29:16',NULL,NULL,'A01','',NULL,NULL,NULL,'1260135645520654338'),('15944385645060861881','admin','2020-07-11 11:36:11',NULL,NULL,'A01','11',NULL,NULL,NULL,'1281794386716344321'),('15944385663981814101','admin','2020-07-11 11:36:11',NULL,NULL,'A01','22',NULL,NULL,NULL,'1281794386716344321');
/*!40000 ALTER TABLE `ces_order_goods` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ces_order_main`
--

DROP TABLE IF EXISTS `ces_order_main`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ces_order_main` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `order_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '订单编码',
  `xd_date` datetime DEFAULT NULL COMMENT '下单时间',
  `money` double DEFAULT NULL COMMENT '订单总额',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ces_order_main`
--

LOCK TABLES `ces_order_main` WRITE;
/*!40000 ALTER TABLE `ces_order_main` DISABLE KEYS */;
INSERT INTO `ces_order_main` VALUES ('1258787241599250433','admin','2020-05-08 23:54:00',NULL,NULL,'A01','20200508-0001','2020-05-08 23:52:32',50000,NULL),('1260133243631562754','admin','2020-05-12 17:02:32',NULL,NULL,'A01A05','202005120001','2020-05-12 17:01:39',NULL,NULL),('1260135645520654338','admin','2020-05-12 17:12:04','admin','2020-07-11 11:29:16','A01','JDFX2020051217115656','2020-07-11 11:29:12',NULL,NULL),('1281794386716344321','admin','2020-07-11 11:36:11',NULL,NULL,'A01','CN2020071111360067','2020-07-11 11:36:00',NULL,NULL);
/*!40000 ALTER TABLE `ces_order_main` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ces_shop_goods`
--

DROP TABLE IF EXISTS `ces_shop_goods`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ces_shop_goods` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '商品名字',
  `price` decimal(10,5) DEFAULT NULL COMMENT '价格',
  `chuc_date` datetime DEFAULT NULL COMMENT '出厂时间',
  `contents` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT '商品简介',
  `good_type_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '商品分类',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ces_shop_goods`
--

LOCK TABLES `ces_shop_goods` WRITE;
/*!40000 ALTER TABLE `ces_shop_goods` DISABLE KEYS */;
INSERT INTO `ces_shop_goods` VALUES ('1258408897326149634','admin','2020-05-07 22:50:35','admin','2020-05-07 22:52:17','A01','华为手机note',5000.00000,'2020-05-07 00:00:00','<div class=\"page1-content\" style=\"margin: 0px 0px 20px; padding: 0px; display: flex; justify-content: space-around; color: #2c3e50; font-family: Avenir, Helvetica, Arial, sans-serif; text-align: center; background-color: #eeeeee;\">\n<div class=\"page1-item\" style=\"margin: auto; padding: 0px; width: 180px;\">\n<div class=\"page1-item-img\" style=\"margin: 0px; padding: 0px; width: 180px; height: 180px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; border-radius: 100%; background: #ffffff; position: relative; z-index: 1; transition: box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s; box-shadow: rgba(166, 55, 112, 0.1) 0px 16px 32px;\"><img style=\"margin: 0px; padding: 0px; width: 100px;\" src=\"http://www.jeecg.com/images/soo.png\" alt=\"img\" /></div>\n<div class=\"page1-item-title\" style=\"margin: 56px 0px 0px; padding: 0px; font-size: 20px; color: #0d1a26;\"><span style=\"margin: 0px; padding: 0px;\">快速开发</span></div>\n</div>\n<div class=\"page1-item\" style=\"margin: auto; padding: 0px; width: 180px;\">\n<div class=\"page1-item-img\" style=\"margin: 0px; padding: 0px; width: 180px; height: 180px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; border-radius: 100%; background: #ffffff; position: relative; z-index: 1; transition: box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s; box-shadow: rgba(191, 188, 21, 0.1) 0px 16px 32px;\"><img style=\"margin: 0px; padding: 0px; width: 100px;\" src=\"http://www.jeecg.com/images/rule.png\" alt=\"img\" /></div>\n<div class=\"page1-item-title\" style=\"margin: 56px 0px 0px; padding: 0px; font-size: 20px; color: #0d1a26;\"><span style=\"margin: 0px; padding: 0px;\">数据权限</span></div>\n</div>\n<div class=\"page1-item\" style=\"margin: auto; padding: 0px; width: 180px;\">\n<div class=\"page1-item-img\" style=\"margin: 0px; padding: 0px; width: 180px; height: 180px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; border-radius: 100%; background: #ffffff; position: relative; z-index: 1; transition: box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s; box-shadow: rgba(73, 101, 166, 0.1) 0px 16px 32px;\"><img style=\"margin: 0px; padding: 0px; width: 100px;\" src=\"http://www.jeecg.com/images/bpm2.png\" alt=\"img\" /></div>\n<div class=\"page1-item-title\" style=\"margin: 56px 0px 0px; padding: 0px; font-size: 20px; color: #0d1a26;\"><span style=\"margin: 0px; padding: 0px;\">工作流</span></div>\n</div>\n<div class=\"page1-item\" style=\"margin: auto; padding: 0px; width: 180px;\">\n<div class=\"page1-item-img\" style=\"margin: 0px; padding: 0px; width: 180px; height: 180px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; border-radius: 100%; background: #ffffff; position: relative; z-index: 1; transition: box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s; box-shadow: rgba(135, 85, 255, 0.1) 0px 16px 32px;\"><img style=\"margin: 0px; padding: 0px; width: 100px;\" src=\"http://www.jeecg.com/images/report1.png\" alt=\"img\" /></div>\n<div class=\"page1-item-title\" style=\"margin: 56px 0px 0px; padding: 0px; font-size: 20px; color: #0d1a26;\"><span style=\"margin: 0px; padding: 0px;\">丰富组件库</span></div>\n</div>\n</div>\n<div class=\"page1-content\" style=\"margin: 0px; padding: 0px; display: flex; justify-content: space-around; color: #2c3e50; font-family: Avenir, Helvetica, Arial, sans-serif; text-align: center; background-color: #eeeeee;\">\n<div class=\"page1-item\" style=\"margin: auto; padding: 0px; width: 180px;\">\n<div class=\"page1-item-img\" style=\"margin: 0px; padding: 0px; width: 180px; height: 180px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; border-radius: 100%; background: #ffffff; position: relative; z-index: 1; transition: box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s; box-shadow: rgba(166, 55, 112, 0.1) 0px 16px 32px;\"><img style=\"margin: 0px; padding: 0px; width: 100px;\" src=\"http://www.jeecg.com/images/icon1.png\" alt=\"img\" /></div>\n<div class=\"page1-item-title\" style=\"margin: 56px 0px 0px; padding: 0px; font-size: 20px; color: #0d1a26;\"><span style=\"margin: 0px; padding: 0px;\">代码生成器</span></div>\n</div>\n<div class=\"page1-item\" style=\"margin: auto; padding: 0px; width: 180px;\">\n<div class=\"page1-item-img\" style=\"margin: 0px; padding: 0px; width: 180px; height: 180px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; border-radius: 100%; background: #ffffff; position: relative; z-index: 1; transition: box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s; box-shadow: rgba(191, 188, 21, 0.1) 0px 16px 32px;\"><img style=\"margin: 0px; padding: 0px; width: 100px;\" src=\"http://www.jeecg.com/images/Automation.png\" alt=\"img\" /></div>\n<div class=\"page1-item-title\" style=\"margin: 56px 0px 0px; padding: 0px; font-size: 20px; color: #0d1a26;\"><span style=\"margin: 0px; padding: 0px;\">Online在线开发</span></div>\n</div>\n<div class=\"page1-item\" style=\"margin: auto; padding: 0px; width: 180px;\">\n<div class=\"page1-item-img\" style=\"margin: 0px; padding: 0px; width: 180px; height: 180px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; border-radius: 100%; background: #ffffff; position: relative; z-index: 1; transition: box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s; box-shadow: rgba(73, 101, 166, 0.1) 0px 16px 32px;\"><img style=\"margin: 0px; padding: 0px; width: 100px;\" src=\"http://www.jeecg.com/images/form2.png\" alt=\"img\" /></div>\n<div class=\"page1-item-title\" style=\"margin: 56px 0px 0px; padding: 0px; font-size: 20px; color: #0d1a26;\"><span style=\"margin: 0px; padding: 0px;\">表单设计器</span></div>\n</div>\n<div class=\"page1-item\" style=\"margin: auto; padding: 0px; width: 180px;\">\n<div class=\"page1-item-img\" style=\"margin: 0px; padding: 0px; width: 180px; height: 180px; display: flex; -webkit-box-align: center; align-items: center; -webkit-box-pack: center; justify-content: center; border-radius: 100%; background: #ffffff; position: relative; z-index: 1; transition: box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-box-shadow 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s, -webkit-transform 0.3s cubic-bezier(0.215, 0.61, 0.355, 1) 0s; box-shadow: rgba(135, 85, 255, 0.1) 0px 16px 32px;\"><img style=\"margin: 0px; padding: 0px; width: 100px;\" src=\"http://www.jeecg.com/images/bpm3.png\" alt=\"img\" /></div>\n<div class=\"page1-item-title\" style=\"margin: 56px 0px 0px; padding: 0px; font-size: 20px; color: #0d1a26;\"><span style=\"margin: 0px; padding: 0px;\">流程设计器</span></div>\n</div>\n</div>','1258408044439597058'),('1258783909887422466','admin','2020-05-08 23:40:45','admin','2020-05-08 23:43:03','A01','雷蛇鼠标',500.00000,'2020-05-08 00:00:00','','1258408003595464706'),('1285114089585082370','admin','2020-07-20 15:27:29',NULL,NULL,'A01',NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `ces_shop_goods` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ces_shop_type`
--

DROP TABLE IF EXISTS `ces_shop_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ces_shop_type` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '分类名字',
  `content` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '描述',
  `pics` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '图片',
  `pid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '父级节点',
  `has_child` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '是否有子节点',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ces_shop_type`
--

LOCK TABLES `ces_shop_type` WRITE;
/*!40000 ALTER TABLE `ces_shop_type` DISABLE KEYS */;
INSERT INTO `ces_shop_type` VALUES ('1258408003595464706','admin','2020-05-07 22:47:02',NULL,NULL,'A01','衣服',NULL,'e1fe9925bc315c60addea1b98eb1cb1349547719_1588862821565.jpg','0','0'),('1258408044439597058','admin','2020-05-07 22:47:12',NULL,NULL,'A01','鞋子',NULL,'jeewxshop测试号_1588862831749.jpg','0','1'),('1258408076693794818','admin','2020-05-07 22:47:20','admin','2020-07-10 16:51:10','A01','耐克',NULL,'d52a2834349b033b6d20d5cc16ce36d3d539bd7f_1594371069797.jpg','1258408044439597058','0'),('1258408105487691777','admin','2020-05-07 22:47:27','admin','2020-05-12 22:24:35','A01','阿迪',NULL,'temp/20180607175028Fn1Lq7zw_1589293474710.png','1258408044439597058','0');
/*!40000 ALTER TABLE `ces_shop_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `demo`
--

DROP TABLE IF EXISTS `demo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `demo` (
  `id` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键ID',
  `name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '姓名',
  `key_word` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '关键词',
  `punch_time` datetime DEFAULT NULL COMMENT '打卡时间',
  `salary_money` decimal(10,3) DEFAULT NULL COMMENT '工资',
  `bonus_money` double(10,2) DEFAULT NULL COMMENT '奖金',
  `sex` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '性别 {男:1,女:2}',
  `age` int DEFAULT NULL COMMENT '年龄',
  `birthday` date DEFAULT NULL COMMENT '生日',
  `email` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '邮箱',
  `content` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '个人简介',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `sys_org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '所属部门编码',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `demo`
--

LOCK TABLES `demo` WRITE;
/*!40000 ALTER TABLE `demo` DISABLE KEYS */;
INSERT INTO `demo` VALUES ('1260935385049055234','111','111',NULL,NULL,NULL,NULL,20,NULL,NULL,NULL,'jeecg','2020-05-14 22:09:57','admin','2020-09-10 17:19:44','A02A01'),('1260935402346364930','22','222',NULL,NULL,NULL,NULL,19,NULL,NULL,NULL,'jeecg','2020-05-14 22:10:02','admin','2020-09-10 17:19:39','A02A01'),('1c2ba51b29a42d9de02bbd708ea8121a','777777','777','2018-12-07 19:43:17',NULL,NULL,NULL,7,'2018-12-07',NULL,NULL,NULL,NULL,'admin','2019-02-21 18:26:04',NULL),('1dc29e80be14d1400f165b5c6b30c707','zhang daihao',NULL,NULL,NULL,NULL,'2',NULL,NULL,'zhangdaiscott@163.com',NULL,NULL,NULL,NULL,NULL,NULL),('304e651dc769d5c9b6e08fb30457a602','小白兔',NULL,NULL,NULL,NULL,'2',28,NULL,NULL,NULL,'scott','2019-01-19 13:12:53','qinfeng','2019-01-19 13:13:12',NULL),('4','Sandy','开源，很好','2018-12-15 00:00:00',NULL,NULL,'2',21,'2018-12-15','test4@baomidou.com','聪明00',NULL,NULL,'admin','2019-02-25 16:29:27',NULL),('4436302a0de50bb83025286bc414d6a9','zhang daihao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'zhangdaiscott@163.com',NULL,'admin','2019-01-19 15:39:04',NULL,NULL,NULL),('4981637bf71b0c1ed1365241dfcfa0ea','小虎',NULL,NULL,NULL,NULL,'2',28,NULL,NULL,NULL,'scott5','2019-01-19 13:12:53','qinfeng','2019-01-19 13:13:12','A02'),('7','zhangdaiscott',NULL,NULL,NULL,NULL,'1',NULL,'2019-01-03',NULL,NULL,NULL,NULL,NULL,NULL,'A02A01A01'),('73bc58611012617ca446d8999379e4ac','郭靖','777','2018-12-07 00:00:00',NULL,NULL,'1',NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-28 18:16:39','admin','2020-05-02 18:14:14','A02A01A02'),('917e240eaa0b1b2d198ae869b64a81c3','zhang daihao',NULL,NULL,NULL,NULL,'2',0,'2018-11-29','zhangdaiscott@163.com',NULL,NULL,NULL,NULL,NULL,'A02'),('94420c5d8fc4420dde1e7196154b3a24','秦风',NULL,NULL,NULL,NULL,'2',NULL,NULL,NULL,NULL,'scott','2019-01-19 12:54:58','admin','2020-05-02 18:14:33',NULL),('b86897900c770503771c7bb88e5d1e9b','scott1','开源、很好、hello',NULL,NULL,NULL,'1',NULL,NULL,'zhangdaiscott@163.com',NULL,'scott','2019-01-19 12:22:34',NULL,NULL,NULL),('c28fa8391ef81d6fabd8bd894a7615aa','小麦',NULL,NULL,NULL,NULL,'2',NULL,NULL,'zhangdaiscott@163.com',NULL,'jeecg-boot','2019-04-04 17:18:09',NULL,NULL,NULL),('c2c0d49e3c01913067cf8d1fb3c971d2','zhang daihao',NULL,NULL,NULL,NULL,'2',NULL,NULL,'zhangdaiscott@163.com',NULL,'admin','2019-01-19 23:37:18','admin','2019-01-21 16:49:06',NULL),('c96279c666b4b82e3ef1e4e2978701ce','报名时间',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-28 18:00:52',NULL,NULL,NULL),('d24668721446e8478eeeafe4db66dcff','zhang daihao999',NULL,NULL,NULL,NULL,'1',NULL,NULL,'zhangdaiscott@163.com',NULL,NULL,NULL,NULL,NULL,NULL),('eaa6c1116b41dc10a94eae34cf990133','zhang daihao',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'zhangdaiscott@163.com',NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `demo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `demo_field_def_val_main`
--

DROP TABLE IF EXISTS `demo_field_def_val_main`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `demo_field_def_val_main` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '编码',
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '姓名',
  `sex` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '性别',
  `address` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '地址',
  `address_param` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '地址（传参）',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `demo_field_def_val_main`
--

LOCK TABLES `demo_field_def_val_main` WRITE;
/*!40000 ALTER TABLE `demo_field_def_val_main` DISABLE KEYS */;
INSERT INTO `demo_field_def_val_main` VALUES ('1256548579457114114','q','q','1','q','q','admin','2020-05-02 19:38:21','admin','2020-05-03 01:02:51','A01');
/*!40000 ALTER TABLE `demo_field_def_val_main` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `demo_field_def_val_sub`
--

DROP TABLE IF EXISTS `demo_field_def_val_sub`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `demo_field_def_val_sub` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '编码',
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '名称',
  `date` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '日期',
  `main_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '主表ID',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `demo_field_def_val_sub`
--

LOCK TABLES `demo_field_def_val_sub` WRITE;
/*!40000 ALTER TABLE `demo_field_def_val_sub` DISABLE KEYS */;
INSERT INTO `demo_field_def_val_sub` VALUES ('15884194974080425602','133','管理员','2020-05-02','1256548579457114114','admin','2020-05-03 01:02:51',NULL,NULL,'A01'),('15884194979201535108','1144','管理员','2020-05-02','1256548579457114114','admin','2020-05-03 01:02:51',NULL,NULL,'A01');
/*!40000 ALTER TABLE `demo_field_def_val_sub` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_customer`
--

DROP TABLE IF EXISTS `iost_customer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_customer` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `name_chs` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '客户中文名称',
  `name_eng` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '客户英文名称',
  `company` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '公司名称',
  `code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '客户编码',
  `address` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '公司地址',
  `telephone` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '联系电话',
  `email` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '邮箱',
  `vat` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'VAT号',
  `imex_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '进出口号',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_customer`
--

LOCK TABLES `iost_customer` WRITE;
/*!40000 ALTER TABLE `iost_customer` DISABLE KEYS */;
INSERT INTO `iost_customer` VALUES ('1325688738967875586','admin','2020-11-09 14:36:40','admin','2020-12-30 14:18:00','A01','sfdsf','sdfsd','深圳玲玲科技有限公司','sdfsdf','深圳市南山区科技园','0898778291','23423@qq.com','',''),('1325694847640301569','admin','2020-11-09 15:00:56','admin','2020-11-10 14:22:55','A01','werw','werew','werwer','werwer','adfafaf','wer','234','24234','234234'),('1326047858893262850','admin','2020-11-10 14:23:41','admin','2020-11-10 14:27:31','A01','wrewer','werwe',NULL,'wrwer',NULL,'wrwr',NULL,NULL,NULL),('1331799673798660098','yuchengxi','2020-11-26 11:19:21','admin','2020-12-30 14:03:17','A02A02','庄玉松','ZHUANG YUSONG','shenzhen lingling company','KH6019','深圳市龙岗区布吉丹竹头','0723541179',NULL,NULL,NULL),('1331799982323273729','yuchengxi','2020-11-26 11:20:34','admin','2020-12-24 08:47:36','A02A02','志芳','SHIRLEY',NULL,'KH6001',NULL,'0785032978',NULL,NULL,NULL),('1344473996636196866','yuchengxi','2020-12-31 10:42:35','yuchengxi','2020-12-31 11:07:24','A02A02','APPLE 邓','apple',NULL,'KH6006',NULL,'0712345678',NULL,NULL,NULL);
/*!40000 ALTER TABLE `iost_customer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_customerlist`
--

DROP TABLE IF EXISTS `iost_customerlist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_customerlist` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `address` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '送货地址',
  `address_default` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '是否默认地址',
  `customer_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '客户id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_customerlist`
--

LOCK TABLES `iost_customerlist` WRITE;
/*!40000 ALTER TABLE `iost_customerlist` DISABLE KEYS */;
INSERT INTO `iost_customerlist` VALUES ('16049052476790977295','admin','2020-11-10 14:22:55',NULL,NULL,'A01','werwrwerwer','Y','1325694847640301569'),('16049134439381966900','admin','2020-11-10 14:22:55',NULL,NULL,'A01','dfsdfsdfds','false','1325694847640301569'),('16049135807052187655','admin','2020-11-10 14:22:55',NULL,NULL,'A01','hfff','false','1325694847640301569'),('16049894103520754968','admin','2020-11-10 14:27:31',NULL,NULL,'A01','wrwer','false','1326047858893262850'),('16063607359160199608','admin','2020-12-30 14:03:17',NULL,NULL,'A01','B12 CHINA CASH CARRY, CROWN MINE, JHB','Y','1331799673798660098'),('16063608132060834197','admin','2020-12-24 08:47:36',NULL,NULL,'A01','1404 BEDFORD CENTRE, JHB','Y','1331799982323273729'),('16063608460451857660','admin','2020-12-24 08:47:36',NULL,NULL,'A01','12 SMITH ROAD,BEDFORDVIEW, JHB','N','1331799982323273729'),('16092989203320462891','admin','2020-12-30 14:18:00',NULL,NULL,'A01','深圳市南山区科技园','Y','1325688738967875586'),('16093081070591836132','admin','2020-12-30 14:03:17',NULL,NULL,'A01','B13 CHINA CASH CARRY, CROWN MINE, JHB','Y','1331799673798660098'),('16093825021840291731','yuchengxi','2020-12-31 11:07:24',NULL,NULL,'A02A02','123 bedford ','Y','1344473996636196866');
/*!40000 ALTER TABLE `iost_customerlist` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_deliverstatus`
--

DROP TABLE IF EXISTS `iost_deliverstatus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_deliverstatus` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `bulk_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '散货柜编号',
  `container_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '货柜号',
  `loading_date` datetime DEFAULT NULL COMMENT '装柜日期',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_deliverstatus`
--

LOCK TABLES `iost_deliverstatus` WRITE;
/*!40000 ALTER TABLE `iost_deliverstatus` DISABLE KEYS */;
INSERT INTO `iost_deliverstatus` VALUES ('1326817385850236929','admin','2020-11-12 17:21:30','admin','2020-11-12 17:22:48','A01','werwer','werewr','2020-11-12 00:00:00'),('1344910108550762497','admin','2021-01-01 15:35:32','admin','2021-01-02 09:56:51','A01','PX2021','234234','2021-01-01 00:00:00'),('1345009823355244546','admin','2021-01-01 22:11:46','admin','2021-01-01 23:27:53','A01','PX20211','234234','2021-01-01 00:00:00');
/*!40000 ALTER TABLE `iost_deliverstatus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_deliverstatus_list`
--

DROP TABLE IF EXISTS `iost_deliverstatus_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_deliverstatus_list` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `location` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '地点',
  `date` datetime DEFAULT NULL COMMENT '日期',
  `deliverstatus_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'deliverstatus_id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_deliverstatus_list`
--

LOCK TABLES `iost_deliverstatus_list` WRITE;
/*!40000 ALTER TABLE `iost_deliverstatus_list` DISABLE KEYS */;
INSERT INTO `iost_deliverstatus_list` VALUES ('16051728753700417605','admin','2020-11-12 17:22:48',NULL,NULL,'A01','sfdsf','2020-11-12 00:00:00',NULL),('16051729497871353532','admin','2020-11-12 17:22:48',NULL,NULL,'A01','sdfdsfdsfsdfsdf','2020-11-13 00:00:00',NULL),('16095106571720117711','admin','2021-01-01 22:17:50',NULL,NULL,'A01','dfdf','2021-01-01 00:00:00',NULL),('16095106658911761119','admin','2021-01-01 22:17:50',NULL,NULL,'A01','dfdf','2021-01-28 00:00:00',NULL),('16095114497550981160','admin','2021-01-01 23:27:53',NULL,NULL,'A01','dfdf33','2021-01-01 00:00:00','1345009823355244546'),('16095114579641323832','admin','2021-01-01 23:27:53',NULL,NULL,'A01','sdfsdf','2021-01-28 00:00:00','1345009823355244546'),('16095138711222745143','admin','2021-01-01 23:27:53',NULL,NULL,'A01','efffff','2021-01-29 00:00:00','1345009823355244546'),('16095524925450151630','admin','2021-01-02 09:56:51',NULL,NULL,'A01','南昌1','2021-01-02 00:00:00','1344910108550762497'),('16095525017241165264','admin','2021-01-02 09:56:51',NULL,NULL,'A01','九江1','2021-01-03 00:00:00','1344910108550762497');
/*!40000 ALTER TABLE `iost_deliverstatus_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_delivery_management`
--

DROP TABLE IF EXISTS `iost_delivery_management`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_delivery_management` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `bulk_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '散货柜编号',
  `container_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '货柜号',
  `volume_total` double(10,3) DEFAULT NULL COMMENT '总体积',
  `packages_total` int DEFAULT NULL COMMENT '总装箱数',
  `weight_total` double(10,2) DEFAULT NULL COMMENT '总重量',
  `money_total` double(10,2) DEFAULT NULL COMMENT '总金额',
  `loading_date` datetime DEFAULT NULL COMMENT '装柜日期',
  `warehouse_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '仓库名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_delivery_management`
--

LOCK TABLES `iost_delivery_management` WRITE;
/*!40000 ALTER TABLE `iost_delivery_management` DISABLE KEYS */;
INSERT INTO `iost_delivery_management` VALUES ('1328192229574971394','admin','2020-11-16 12:24:39','admin','2020-12-21 14:13:46','A01','aa','aa',33.000,33,33.00,33.00,'2020-11-12 00:00:00','wew');
/*!40000 ALTER TABLE `iost_delivery_management` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_delivery_note`
--

DROP TABLE IF EXISTS `iost_delivery_note`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_delivery_note` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT 'Date',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `contact_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Contact Name',
  `phone_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Phone No.',
  `reference` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Reference',
  `company` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Company',
  `address` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Address',
  `delivery_record_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '出库单Id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_delivery_note`
--

LOCK TABLES `iost_delivery_note` WRITE;
/*!40000 ALTER TABLE `iost_delivery_note` DISABLE KEYS */;
INSERT INTO `iost_delivery_note` VALUES ('1344938573299855361','admin','2021-01-01 17:28:38',NULL,NULL,'A01','apple','0712345678','PX20201',NULL,'123 bedford ','1344476487209717761'),('1344938574054830082','admin','2021-01-01 17:28:38',NULL,NULL,'A01','SHIRLEY','0785032978','PX20202',NULL,'1404 BEDFORD CENTRE, JHB','1344476487209717761'),('1344938596905398274','admin','2021-01-01 17:28:44',NULL,NULL,'A01','ZHUANG YUSONG','0723541179','SH20201230011','shenzhen lingling company','B12 CHINA CASH CARRY, CROWN MINE, JHB','1344161672054444034'),('1345010537263534082','admin','2021-01-01 22:14:36',NULL,NULL,'A01','ZHUANG YUSONG','0723541179','PX202111','shenzhen lingling company','B12 CHINA CASH CARRY, CROWN MINE, JHB','1345009823355244546'),('1345265217486983170','yuchengxi','2021-01-02 15:06:36',NULL,NULL,'A02A02','sdfsd','0898778291','PX20211','深圳玲玲科技有限公司','深圳市南山区科技园','1344910108550762497'),('1345265217583452162','yuchengxi','2021-01-02 15:06:36',NULL,NULL,'A02A02','ZHUANG YUSONG','0723541179','PX20212','shenzhen lingling company','B12 CHINA CASH CARRY, CROWN MINE, JHB','1344910108550762497'),('1345278113084346369','yuchengxi','2021-01-02 15:57:51',NULL,NULL,'A02A02','apple','0712345678','PX21011',NULL,'123 bedford ','1345273647039778818'),('1345278113130483713','yuchengxi','2021-01-02 15:57:51',NULL,NULL,'A02A02','SHIRLEY','0785032978','PX21012',NULL,'1404 BEDFORD CENTRE, JHB','1345273647039778818'),('1345278113172426754','yuchengxi','2021-01-02 15:57:51',NULL,NULL,'A02A02','SHIRLEY','0785032978','PX21013',NULL,'1404 BEDFORD CENTRE, JHB','1345273647039778818'),('1345278113205981185','yuchengxi','2021-01-02 15:57:51',NULL,NULL,'A02A02','ZHUANG YUSONG','0723541179','PX21014','shenzhen lingling company','B12 CHINA CASH CARRY, CROWN MINE, JHB','1345273647039778818'),('1345278113231147009','yuchengxi','2021-01-02 15:57:51',NULL,NULL,'A02A02','ZHUANG YUSONG','0723541179','PX21015','shenzhen lingling company','B12 CHINA CASH CARRY, CROWN MINE, JHB','1345273647039778818');
/*!40000 ALTER TABLE `iost_delivery_note` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_delivery_note_list`
--

DROP TABLE IF EXISTS `iost_delivery_note_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_delivery_note_list` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `description` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Description',
  `ctns` int DEFAULT NULL COMMENT 'CTNS',
  `dimensions` double(10,3) DEFAULT NULL COMMENT 'Dimensions',
  `cbm` double(10,3) DEFAULT NULL COMMENT 'CBM',
  `weight` double(10,2) DEFAULT NULL COMMENT 'Weight(kg)',
  `mark` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'MARK',
  `delivery_note_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'id',
  `length` int DEFAULT NULL COMMENT 'Length',
  `width` int DEFAULT NULL COMMENT 'Width',
  `height` int DEFAULT NULL COMMENT 'Height',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_delivery_note_list`
--

LOCK TABLES `iost_delivery_note_list` WRITE;
/*!40000 ALTER TABLE `iost_delivery_note_list` DISABLE KEYS */;
INSERT INTO `iost_delivery_note_list` VALUES ('1344938573429878785','admin','2021-01-01 17:28:38',NULL,NULL,'A01','？？？',111,NULL,71.817,3030.30,'201231001','1344938573299855361',180,37,97),('1344938573551513602','admin','2021-01-01 17:28:38',NULL,NULL,'A01','PAPER CUP',137,NULL,62.609,3657.90,'201231001','1344938573299855361',77,77,77),('1344938573652176897','admin','2021-01-01 17:28:38',NULL,NULL,'A01','PVC PLATE',67,NULL,19.296,737.00,'201231001','1344938573299855361',66,66,66),('1344938573757034498','admin','2021-01-01 17:28:38',NULL,NULL,'A01','BALLON',37,NULL,1.887,392.20,'201231001','1344938573299855361',37,37,37),('1344938574243573762','admin','2021-01-01 17:28:39',NULL,NULL,'A01','PARTY TUTU SKIRT',100,NULL,65.000,3030.00,'201231002','1344938574054830082',77,87,97),('1344938574386180097','admin','2021-01-01 17:28:39',NULL,NULL,'A01','bing xiang',100,NULL,145.900,3200.00,'201231002','1344938574054830082',90,90,180),('1344938597022838785','admin','2021-01-01 17:28:44',NULL,NULL,'A01','？？？',10,NULL,9.010,200.00,'2020122001','1344938596905398274',176,33,155),('1344938597161250818','admin','2021-01-01 17:28:44',NULL,NULL,'A01','PARTY TUTU SKIRT',10,NULL,2.090,300.00,'2020122001','1344938596905398274',46,63,72),('1345010537280311298','admin','2021-01-01 22:14:36',NULL,NULL,'A01','？？？',10,NULL,9.010,200.00,'2020122001','1345010537263534082',176,33,155),('1345265217541509122','yuchengxi','2021-01-02 15:06:36',NULL,NULL,'A02A02','？？？',1,NULL,366.690,21.00,'20201216001','1345265217486983170',12324,342,87),('1345265217596035074','yuchengxi','2021-01-02 15:06:36',NULL,NULL,'A02A02','？？？',NULL,NULL,59.466,1320.00,'2020122001','1345265217583452162',176,33,155),('1345278113101123586','yuchengxi','2021-01-02 15:57:51',NULL,NULL,'A02A02','BALLON',111,NULL,10.656,2354.31,'210101','1345278113084346369',66,44,33),('1345278113109512193','yuchengxi','2021-01-02 15:57:51',NULL,NULL,'A02A02','PARTY TUTU SKIRT',222,NULL,91.020,14097.00,'210101','1345278113084346369',77,121,44),('1345278113138872322','yuchengxi','2021-01-02 15:57:51',NULL,NULL,'A02A02','PVC PLATE',33,NULL,3.102,693.00,'210102','1345278113130483713',63,45,33),('1345278113180815361','yuchengxi','2021-01-02 15:57:51',NULL,NULL,'A02A02','？？？',444,NULL,302.364,7548.00,'210103','1345278113172426754',130,68,77),('1345278113214369793','yuchengxi','2021-01-02 15:57:51',NULL,NULL,'A02A02','PAPER CUP',555,NULL,248.640,11988.00,'210104','1345278113205981185',66,77,88),('1345278113239535618','yuchengxi','2021-01-02 15:57:51',NULL,NULL,'A02A02','BALLON',666,NULL,298.368,13986.00,'210105','1345278113231147009',66,77,88),('1345278113247924226','yuchengxi','2021-01-02 15:57:51',NULL,NULL,'A02A02','BALLON',770,NULL,123.200,24640.00,'210105','1345278113231147009',44,55,66),('1345278113256312833','yuchengxi','2021-01-02 15:57:51',NULL,NULL,'A02A02','BALLON',5,NULL,0.800,160.00,'210105','1345278113231147009',44,55,66);
/*!40000 ALTER TABLE `iost_delivery_note_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_delivery_record`
--

DROP TABLE IF EXISTS `iost_delivery_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_delivery_record` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `bulk_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '散货柜编号',
  `warehouse_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '仓库名称',
  `container_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '货柜号',
  `loading_date` datetime DEFAULT NULL COMMENT '装柜日期',
  `packages_totals` int DEFAULT NULL COMMENT '总箱数',
  `volume_totals` double(10,3) DEFAULT NULL COMMENT '总体积',
  `weight_totals` double(10,2) DEFAULT NULL COMMENT '总重量',
  `money_total` double(10,2) DEFAULT NULL COMMENT '总金额',
  `delivery_record_pics` blob COMMENT '送货单图片',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_delivery_record`
--

LOCK TABLES `iost_delivery_record` WRITE;
/*!40000 ALTER TABLE `iost_delivery_record` DISABLE KEYS */;
INSERT INTO `iost_delivery_record` VALUES ('1344910108550762497','admin','2021-01-01 15:35:32','yuchengxi','2021-01-02 15:08:31','A01','PX2021','1335500357173776386','234234','2021-01-01 00:00:00',142,1558.662,2124.00,7013979.00,NULL),('1345009823355244546','admin','2021-01-01 22:11:46','admin','2021-01-01 22:14:00','A01','PX20211','1335500357173776386','234234','2021-01-01 00:00:00',30,27.030,600.00,130645.00,NULL),('1345273647039778818','yuchengxi','2021-01-02 15:40:06','yuchengxi','2021-01-02 15:49:56','A02A02','PX2101','1335500196762619905','MRKU1234567','2021-01-02 00:00:00',2437056,4311.320,301609.24,12758879.20,NULL);
/*!40000 ALTER TABLE `iost_delivery_record` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_delivery_record_list`
--

DROP TABLE IF EXISTS `iost_delivery_record_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_delivery_record_list` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `receiving_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '入仓号',
  `customer_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '客户中文名称',
  `kind` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '商品类别',
  `name_chs` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '商品中文名称',
  `name_eng` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '商品英文名称',
  `picture` blob COMMENT '图片',
  `unit` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '单位',
  `cases` int DEFAULT NULL COMMENT '件数',
  `packages` int DEFAULT NULL COMMENT '单件装箱数',
  `packages_total` int DEFAULT NULL COMMENT '总装箱数',
  `cases_actual` int DEFAULT NULL COMMENT '实际件数',
  `length` int DEFAULT NULL COMMENT '长',
  `width` int DEFAULT NULL COMMENT '宽',
  `height` int DEFAULT NULL COMMENT '高',
  `volume` double(10,3) DEFAULT NULL COMMENT '单件体积',
  `volume_total` double(10,3) DEFAULT NULL COMMENT '总体积',
  `weight` double(10,2) DEFAULT NULL COMMENT '箱重',
  `weight_total` double(10,2) DEFAULT NULL COMMENT '总重量',
  `material` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '材质',
  `price` double(10,2) DEFAULT NULL COMMENT '单价',
  `money` double(10,2) DEFAULT NULL COMMENT '金额',
  `delivery_record_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '出库id',
  `source_entry_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '源单据体Id',
  `source_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '源Id',
  `note` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_delivery_record_list`
--

LOCK TABLES `iost_delivery_record_list` WRITE;
/*!40000 ALTER TABLE `iost_delivery_record_list` DISABLE KEYS */;
INSERT INTO `iost_delivery_record_list` VALUES ('16094864300600874394','yuchengxi','2021-01-02 15:08:31',NULL,NULL,'A02A02','20201216001','sfdsf','001','电视','？？？',NULL,'太台',4,10,10,1,12324,342,87,366.690,366.690,21.00,21.00,'塑料',4500.00,1650105.00,'1344910108550762497','16081009544290558131','1339097998554042370','液晶电视 打木箱'),('16094945914461544048','yuchengxi','2021-01-02 15:08:31',NULL,NULL,'A02A02','2020122001','庄玉松','001','电视','？？？',NULL,'台',36,1,36,36,176,33,155,0.901,32.436,20.00,720.00,'',4500.00,145962.00,'1344910108550762497','16084477606900519048','1340555145326366722','型号111'),('16095102107340952466','admin','2021-01-01 22:14:00',NULL,NULL,'A01','2020122001','庄玉松','001','电视','？？？',NULL,'台',66,1,10,10,176,33,155,0.901,9.010,20.00,200.00,'',5000.00,45050.00,'1345009823355244546','16084477606900519048','1340555145326366722','型号111'),('16095730014330934330','yuchengxi','2021-01-02 15:49:56',NULL,NULL,'A02A02','210101','APPLE 邓','3','乳胶气球','BALLON',NULL,'包',111,120,13320,111,66,44,33,0.096,10.656,21.21,2354.31,'',2300.00,24508.80,'1345273647039778818','16095716594960802062','1345268447696654337','20个/包'),('16095730369241614827','yuchengxi','2021-01-02 15:49:56',NULL,NULL,'A02A02','210101','APPLE 邓','3','纱裙','PARTY TUTU SKIRT',NULL,'条',222,600,133200,222,77,121,44,0.410,91.020,63.50,14097.00,'',2800.00,254856.00,'1345273647039778818','16095717234391782094','1345268447696654337',''),('16095730369262362984','yuchengxi','2021-01-02 15:49:56',NULL,NULL,'A02A02','210102','志芳','3','一次性塑料盘','PVC PLATE',NULL,'包',33,120,3960,33,63,45,33,0.094,3.102,21.00,693.00,'',2300.00,7134.60,'1345273647039778818','16095720363380777766','1345269188108750850','12个/包'),('16095730369273242425','yuchengxi','2021-01-02 15:49:56',NULL,NULL,'A02A02','210103','志芳','001','电视','？？？',NULL,'台',444,1,444,444,130,68,77,0.681,302.364,17.00,7548.00,'',4500.00,1360638.00,'1345273647039778818','16095721869080618897','1345269536089182209',''),('16095730369284754528','yuchengxi','2021-01-02 15:49:56',NULL,NULL,'A02A02','210104','庄玉松','3','一次性纸杯','PAPER CUP',NULL,'包',555,120,66600,555,66,77,88,0.448,248.640,21.60,11988.00,'',2300.00,571872.00,'1345273647039778818','16095722988230304956','1345270018660634625','12个/包'),('16095730369295524289','yuchengxi','2021-01-02 15:49:56',NULL,NULL,'A02A02','210105','庄玉松','3','乳胶气球','BALLON',NULL,'包',666,240,159840,666,66,77,88,0.448,298.368,21.00,13986.00,'',2300.00,686246.40,'1345273647039778818','16095723786440692912','1345270416683307009',''),('16095730369306306954','yuchengxi','2021-01-02 15:49:56',NULL,NULL,'A02A02','210105','庄玉松','3','铝膜气球','BALLON',NULL,'个',777,300,231000,770,44,55,66,0.160,123.200,32.00,24640.00,'',2300.00,283360.00,'1345273647039778818','16095723817471105714','1345270416683307009',''),('16095732344787170155','yuchengxi','2021-01-02 15:49:56',NULL,NULL,'A02A02','210105','庄玉松','3','铝膜气球','BALLON',NULL,'个',7,300,1500,5,44,55,66,0.160,0.800,32.00,160.00,'',2300.00,1840.00,'1345273647039778818','16095723817471105714','1345270416683307009','');
/*!40000 ALTER TABLE `iost_delivery_record_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_delivery_record_pic`
--

DROP TABLE IF EXISTS `iost_delivery_record_pic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_delivery_record_pic` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `pic` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT '图片',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_delivery_record_pic`
--

LOCK TABLES `iost_delivery_record_pic` WRITE;
/*!40000 ALTER TABLE `iost_delivery_record_pic` DISABLE KEYS */;
INSERT INTO `iost_delivery_record_pic` VALUES ('1344910108550762497','admin','2021-01-08 14:06:45','admin','2021-01-08 14:06:45','A01','temp/Balloon_by_Matt_Benson_1610086001821.jpg,temp/Beach_by_Samuel_Scrimshaw_1610086001821.jpg,temp/desktop_1610086001822.jpg'),('1345273647039778818','admin','2021-01-08 13:28:18','admin','2021-01-08 14:04:05','A01','temp/Autumn_in_Kanas_by_Wang_Jinyu_1610083692142.jpg,temp/Beach_by_Samuel_Scrimshaw_1610083694808.jpg'),('1347410804567310337','admin','2021-01-08 13:12:24',NULL,NULL,'A01','temp/Balloon_by_Matt_Benson_1610082742808.jpg');
/*!40000 ALTER TABLE `iost_delivery_record_pic` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_insurance_policy`
--

DROP TABLE IF EXISTS `iost_insurance_policy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_insurance_policy` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `insurance_policy_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '保险单号',
  `date` datetime DEFAULT NULL COMMENT '保险日期',
  `customer_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '客户编码',
  `customer_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '客户姓名',
  `telephone` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '手机',
  `email` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '邮箱',
  `address` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '公司地址',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_insurance_policy`
--

LOCK TABLES `iost_insurance_policy` WRITE;
/*!40000 ALTER TABLE `iost_insurance_policy` DISABLE KEYS */;
INSERT INTO `iost_insurance_policy` VALUES ('1344254271511851010','admin','2020-12-30 20:09:28',NULL,NULL,'A01','ａｄｓｆ',NULL,'asdf',NULL,'adsf',NULL,'adsf');
/*!40000 ALTER TABLE `iost_insurance_policy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_insurance_policy_list`
--

DROP TABLE IF EXISTS `iost_insurance_policy_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_insurance_policy_list` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '商品名称',
  `volume` int DEFAULT NULL COMMENT '体积',
  `weight` double(10,2) DEFAULT NULL COMMENT '重量',
  `packages` int DEFAULT NULL COMMENT '箱数',
  `price` double(10,2) DEFAULT NULL COMMENT '价格',
  `money` double(10,2) DEFAULT NULL COMMENT ' 金额',
  `receiving_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '入仓号',
  `insurance_policy_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '保险id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_insurance_policy_list`
--

LOCK TABLES `iost_insurance_policy_list` WRITE;
/*!40000 ALTER TABLE `iost_insurance_policy_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `iost_insurance_policy_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_inventory_record`
--

DROP TABLE IF EXISTS `iost_inventory_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_inventory_record` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `warehouse_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '仓库名称',
  `cases_total` int DEFAULT NULL COMMENT '总件数',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_inventory_record`
--

LOCK TABLES `iost_inventory_record` WRITE;
/*!40000 ALTER TABLE `iost_inventory_record` DISABLE KEYS */;
INSERT INTO `iost_inventory_record` VALUES ('1343027490288832514','admin','2020-12-27 10:54:41','admin','2020-12-27 10:55:34','A01','1335500196762619905',100);
/*!40000 ALTER TABLE `iost_inventory_record` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_inventory_record_list`
--

DROP TABLE IF EXISTS `iost_inventory_record_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_inventory_record_list` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `name_chs` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '商品中文名称',
  `name_eng` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '商品英文名称',
  `picture` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '图片',
  `unit` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '单位',
  `cases` int DEFAULT NULL COMMENT '件数',
  `packages` int DEFAULT NULL COMMENT '单件装箱数',
  `packages_total` int DEFAULT NULL COMMENT '总装箱数',
  `length` int DEFAULT NULL COMMENT '长',
  `width` int DEFAULT NULL COMMENT '宽',
  `height` int DEFAULT NULL COMMENT '高',
  `volume` double(10,3) DEFAULT NULL COMMENT '单件体积',
  `volume_total` double(10,3) DEFAULT NULL COMMENT '总体积',
  `weight` double(10,2) DEFAULT NULL COMMENT '单件箱重',
  `weight_total` double(10,2) DEFAULT NULL COMMENT '总重量',
  `material` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '材质',
  `receiving_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '入仓号',
  `customer_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '客户中文姓名',
  `record_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '记录id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_inventory_record_list`
--

LOCK TABLES `iost_inventory_record_list` WRITE;
/*!40000 ALTER TABLE `iost_inventory_record_list` DISABLE KEYS */;
INSERT INTO `iost_inventory_record_list` VALUES ('16090375281900241018','admin','2020-12-27 10:55:34',NULL,NULL,'A01','ddd','',NULL,'',100,10,1000,100,200,300,6.000,600.000,20.00,2000.00,'dsd','20201227001','江文文','1343027490288832514');
/*!40000 ALTER TABLE `iost_inventory_record_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_kind`
--

DROP TABLE IF EXISTS `iost_kind`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_kind` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '编码',
  `name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '商品类别',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_kind`
--

LOCK TABLES `iost_kind` WRITE;
/*!40000 ALTER TABLE `iost_kind` DISABLE KEYS */;
INSERT INTO `iost_kind` VALUES ('1325695844362121218','admin','2020-11-09 15:04:54',NULL,NULL,'A01','001','家电类'),('1325729539405385730','admin','2020-11-09 17:18:48',NULL,NULL,'A01','002','装修类'),('1331798300449312769','yuchengxi','2020-11-26 11:13:53',NULL,NULL,'A02A02','3','派对用品');
/*!40000 ALTER TABLE `iost_kind` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_message`
--

DROP TABLE IF EXISTS `iost_message`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_message` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `title` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '标题',
  `content` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '内容',
  `receiver` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '接收人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_message`
--

LOCK TABLES `iost_message` WRITE;
/*!40000 ALTER TABLE `iost_message` DISABLE KEYS */;
INSERT INTO `iost_message` VALUES ('1331878689602506753','admin','2020-11-26 16:33:19','admin','2020-11-26 20:06:21','A01','werew','werewr','admin');
/*!40000 ALTER TABLE `iost_message` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_price`
--

DROP TABLE IF EXISTS `iost_price`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_price` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `kind` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '商品类别',
  `name_chs` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '商品中文名称',
  `name_eng` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '商品英文名称',
  `price` double(10,3) DEFAULT NULL COMMENT '价格',
  `description` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '描述',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_price`
--

LOCK TABLES `iost_price` WRITE;
/*!40000 ALTER TABLE `iost_price` DISABLE KEYS */;
INSERT INTO `iost_price` VALUES ('1325699386779004930','admin','2020-11-09 15:18:58',NULL,NULL,'A01','001','45645','456456',56.677,NULL),('1325730176381751298','admin','2020-11-09 17:21:20','admin','2020-11-09 17:21:31','A01','002','装修','sjfksa',34.988,'asdfafdadfaf'),('1330354267951435778','admin','2020-11-22 11:35:49',NULL,NULL,'A01','001','冰箱','bing xiang',100.000,'冰箱'),('1331798569782349825','yuchengxi','2020-11-26 11:14:57',NULL,NULL,'A02A02','3','乳胶气球','BALLON',2300.000,'乳胶气球'),('1331798655077715970','yuchengxi','2020-11-26 11:15:18',NULL,NULL,'A02A02','3','铝膜气球','BALLON',2300.000,'铝膜气球'),('1331798830760333313','yuchengxi','2020-11-26 11:16:00',NULL,NULL,'A02A02','3','纱裙','PARTY TUTU SKIRT',2800.000,NULL),('1331799060796936193','yuchengxi','2020-11-26 11:16:54',NULL,NULL,'A02A02','3','PARTY 纸帽','PARTY CAP',2300.000,'纸做的配对儿童帽'),('1331799215981989890','yuchengxi','2020-11-26 11:17:31',NULL,NULL,'A02A02','3','一次性塑料盘','PVC PLATE',2300.000,NULL),('1331799300493021185','yuchengxi','2020-11-26 11:17:52',NULL,NULL,'A02A02','3','一次性纸杯','PAPER CUP',2300.000,NULL),('1339096567327494145','yuchengxi','2020-12-16 14:34:36',NULL,NULL,'A02A02','001','电视','？？？',0.000,'液晶电视机');
/*!40000 ALTER TABLE `iost_price` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_receiving`
--

DROP TABLE IF EXISTS `iost_receiving`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_receiving` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `receiving_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '入仓号',
  `delivery_factory` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '送货厂家',
  `warehouse_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '仓库名称',
  `customer_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '客户姓名',
  `delivery_man` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '送货人',
  `customer_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '客户编码',
  `telephone` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '联系电话',
  `date` datetime DEFAULT NULL COMMENT '入库日期',
  `cases_total` int DEFAULT NULL COMMENT '总件数',
  `weights_total` double(10,2) DEFAULT NULL COMMENT '总重量',
  `volumes_total` double(10,3) DEFAULT NULL COMMENT '总体积',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_receiving`
--

LOCK TABLES `iost_receiving` WRITE;
/*!40000 ALTER TABLE `iost_receiving` DISABLE KEYS */;
INSERT INTO `iost_receiving` VALUES ('1339097998554042370','yuchengxi','2020-12-16 14:40:17','admin','2020-12-17 17:42:20','A02A02','20201216001','方鼎','1335500196762619905','sfdsf','陈燕','sdfsdf','11111111111','2020-12-16 00:00:00',16,336.00,5867.010),('1340555145326366722','yuchengxi','2020-12-20 15:10:28','yuchengxi','2020-12-20 15:15:35','A02A02','2020122001','飞洋','1335500196762619905','庄玉松','飞','KH6019','12345678900','2020-12-20 00:00:00',463,18535.04,289.300),('1344475261529231362','yuchengxi','2020-12-31 10:47:36',NULL,NULL,'A02A02','201231001','晨泰','1335500196762619905','APPLE 邓','陈','KH6006','1234567890','2020-12-31 00:00:00',352,7817.40,155.609),('1344475810823671810','yuchengxi','2020-12-31 10:49:47','admin','2021-01-02 15:17:10','A02A02','201231002','刘','1335500196762619905','志芳','刘','KH6001','111111111111','2020-12-31 00:00:00',200,18690.00,632.700),('1345268447696654337','yuchengxi','2021-01-02 15:19:26','yuchengxi','2021-01-02 15:24:04','A02A02','210101','天翼','1335500196762619905','APPLE 邓','刘','KH6006','1111111111111','2021-01-02 00:00:00',333,32902.62,203.352),('1345269188108750850','yuchengxi','2021-01-02 15:22:23',NULL,NULL,'A02A02','210102','大风','1335500196762619905','志芳','刚刚','KH6001','222222222','2021-01-02 00:00:00',33,693.00,3.102),('1345269536089182209','yuchengxi','2021-01-02 15:23:46',NULL,NULL,'A02A02','210103','方鼎','1335500196762619905','志芳','费','KH6001','777777777777','2021-01-02 00:00:00',444,7548.00,302.364),('1345270018660634625','yuchengxi','2021-01-02 15:25:41',NULL,NULL,'A02A02','210104','个签','1335500196762619905','庄玉松','放大','KH6019','99999999999','2021-01-02 00:00:00',555,11988.00,248.640),('1345270416683307009','yuchengxi','2021-01-02 15:27:16',NULL,NULL,'A02A02','210105','慢慢','1335500196762619905','庄玉松','卢','KH6019','999999999','2021-01-02 00:00:00',1443,38850.00,422.688);
/*!40000 ALTER TABLE `iost_receiving` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_receiving_copy`
--

DROP TABLE IF EXISTS `iost_receiving_copy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_receiving_copy` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `receiving_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '入仓号',
  `delivery_factory` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '送货厂家',
  `warehouse_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '仓库名称',
  `customer_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '客户姓名',
  `delivery_man` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '送货人',
  `cases_total` int DEFAULT NULL COMMENT '总件数',
  `customer_code` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '客户编码',
  `telephone` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '联系电话',
  `date` datetime DEFAULT NULL COMMENT '入库日期',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_receiving_copy`
--

LOCK TABLES `iost_receiving_copy` WRITE;
/*!40000 ALTER TABLE `iost_receiving_copy` DISABLE KEYS */;
/*!40000 ALTER TABLE `iost_receiving_copy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_receiving_note`
--

DROP TABLE IF EXISTS `iost_receiving_note`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_receiving_note` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `invoice_number` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '发票号',
  `customer_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '客户姓名',
  `telephone` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '联系电话',
  `delivery_address` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '送货地址',
  `receiving_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '入仓号',
  `delivery_record_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '出库单Id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_receiving_note`
--

LOCK TABLES `iost_receiving_note` WRITE;
/*!40000 ALTER TABLE `iost_receiving_note` DISABLE KEYS */;
INSERT INTO `iost_receiving_note` VALUES ('1344938604782301186','admin','2021-01-01 17:28:46',NULL,NULL,'A01','SH20201230011','庄玉松','0723541179','B12 CHINA CASH CARRY, CROWN MINE, JHB','2020122001','1344161672054444034'),('1345008933181329409','admin','2021-01-01 22:08:13',NULL,NULL,'A01','PX20201','APPLE 邓','0712345678','123 bedford ','201231001','1344476487209717761'),('1345008933332324353','admin','2021-01-01 22:08:13',NULL,NULL,'A01','PX20202','志芳','0785032978','1404 BEDFORD CENTRE, JHB','201231002','1344476487209717761'),('1345010528484855809','admin','2021-01-01 22:14:34',NULL,NULL,'A01','PX202111','庄玉松','0723541179','B12 CHINA CASH CARRY, CROWN MINE, JHB','2020122001','1345009823355244546'),('1345265210708987906','yuchengxi','2021-01-02 15:06:35',NULL,NULL,'A02A02','PX20211','sfdsf','0898778291','深圳市南山区科技园','20201216001','1344910108550762497'),('1345265210784485378','yuchengxi','2021-01-02 15:06:35',NULL,NULL,'A02A02','PX20212','庄玉松','0723541179','B12 CHINA CASH CARRY, CROWN MINE, JHB','2020122001','1344910108550762497'),('1345278077910913026','yuchengxi','2021-01-02 15:57:42',NULL,NULL,'A02A02','PX21011','APPLE 邓','0712345678','123 bedford ','210101','1345273647039778818'),('1345278077940273153','yuchengxi','2021-01-02 15:57:42',NULL,NULL,'A02A02','PX21012','志芳','0785032978','1404 BEDFORD CENTRE, JHB','210102','1345273647039778818'),('1345278077986410497','yuchengxi','2021-01-02 15:57:43',NULL,NULL,'A02A02','PX21013','志芳','0785032978','1404 BEDFORD CENTRE, JHB','210103','1345273647039778818'),('1345278078007382018','yuchengxi','2021-01-02 15:57:43',NULL,NULL,'A02A02','PX21014','庄玉松','0723541179','B12 CHINA CASH CARRY, CROWN MINE, JHB','210104','1345273647039778818'),('1345278078032547841','yuchengxi','2021-01-02 15:57:43',NULL,NULL,'A02A02','PX21015','庄玉松','0723541179','B12 CHINA CASH CARRY, CROWN MINE, JHB','210105','1345273647039778818');
/*!40000 ALTER TABLE `iost_receiving_note` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_receiving_note_list`
--

DROP TABLE IF EXISTS `iost_receiving_note_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_receiving_note_list` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `name_eng` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '商品英文名称',
  `volume` double(10,3) DEFAULT NULL COMMENT '体积',
  `weight` double(10,2) DEFAULT NULL COMMENT '重量',
  `packages` int DEFAULT NULL COMMENT '箱数',
  `price` double(10,2) DEFAULT NULL COMMENT '价格',
  `money` double(10,2) DEFAULT NULL COMMENT '金额',
  `receiving_note_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '收费单id',
  `name_chs` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '商品中文名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_receiving_note_list`
--

LOCK TABLES `iost_receiving_note_list` WRITE;
/*!40000 ALTER TABLE `iost_receiving_note_list` DISABLE KEYS */;
INSERT INTO `iost_receiving_note_list` VALUES ('1344938604924907522','admin','2021-01-01 17:28:46',NULL,NULL,'A01','？？？',9.010,200.00,10,4500.00,40545.00,'1344938604782301186','电视'),('1344938605033959425','admin','2021-01-01 17:28:46',NULL,NULL,'A01','PARTY TUTU SKIRT',2.090,300.00,10,2800.00,5852.00,'1344938604782301186','纱裙'),('1345008933248438274','admin','2021-01-01 22:08:13',NULL,NULL,'A01','？？？',71.817,3030.30,111,4500.00,323176.50,'1345008933181329409','电视'),('1345008933290381314','admin','2021-01-01 22:08:13',NULL,NULL,'A01','PAPER CUP',62.609,3657.90,137,2300.00,144000.70,'1345008933181329409','一次性纸杯'),('1345008933302964225','admin','2021-01-01 22:08:13',NULL,NULL,'A01','PVC PLATE',19.296,737.00,67,2300.00,44380.80,'1345008933181329409','一次性塑料盘'),('1345008933307158530','admin','2021-01-01 22:08:13',NULL,NULL,'A01','BALLON',1.887,392.20,37,2300.00,4340.10,'1345008933181329409','铝膜气球'),('1345008933336518658','admin','2021-01-01 22:08:13',NULL,NULL,'A01','PARTY TUTU SKIRT',65.000,3030.00,100,2800.00,182000.00,'1345008933332324353','纱裙'),('1345008933349101570','admin','2021-01-01 22:08:13',NULL,NULL,'A01','bing xiang',145.900,3200.00,100,100.00,14590.00,'1345008933332324353','冰箱'),('1345010528497438722','admin','2021-01-01 22:14:34',NULL,NULL,'A01','？？？',9.010,200.00,10,5000.00,45050.00,'1345010528484855809','电视'),('1345265210746736641','yuchengxi','2021-01-02 15:06:35',NULL,NULL,'A02A02','？？？',366.690,21.00,1,4500.00,1650105.00,'1345265210708987906','电视'),('1345265210797068289','yuchengxi','2021-01-02 15:06:35',NULL,NULL,'A02A02','？？？',59.466,1320.00,NULL,4500.00,267597.00,'1345265210784485378','电视'),('1345278077919301634','yuchengxi','2021-01-02 15:57:42',NULL,NULL,'A02A02','BALLON',10.656,2354.31,111,2300.00,24508.80,'1345278077910913026','乳胶气球'),('1345278077927690242','yuchengxi','2021-01-02 15:57:42',NULL,NULL,'A02A02','PARTY TUTU SKIRT',91.020,14097.00,222,2800.00,254856.00,'1345278077910913026','纱裙'),('1345278077948661761','yuchengxi','2021-01-02 15:57:42',NULL,NULL,'A02A02','PVC PLATE',3.102,693.00,33,2300.00,7134.60,'1345278077940273153','一次性塑料盘'),('1345278077994799106','yuchengxi','2021-01-02 15:57:43',NULL,NULL,'A02A02','？？？',302.364,7548.00,444,4500.00,1360638.00,'1345278077986410497','电视'),('1345278078015770625','yuchengxi','2021-01-02 15:57:43',NULL,NULL,'A02A02','PAPER CUP',248.640,11988.00,555,2300.00,571872.00,'1345278078007382018','一次性纸杯'),('1345278078036742145','yuchengxi','2021-01-02 15:57:43',NULL,NULL,'A02A02','BALLON',298.368,13986.00,666,2300.00,686246.40,'1345278078032547841','乳胶气球'),('1345278078045130753','yuchengxi','2021-01-02 15:57:43',NULL,NULL,'A02A02','BALLON',123.200,24640.00,770,2300.00,283360.00,'1345278078032547841','铝膜气球'),('1345278078049325058','yuchengxi','2021-01-02 15:57:43',NULL,NULL,'A02A02','BALLON',0.800,160.00,5,2300.00,1840.00,'1345278078032547841','铝膜气球');
/*!40000 ALTER TABLE `iost_receiving_note_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_receivinglist`
--

DROP TABLE IF EXISTS `iost_receivinglist`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_receivinglist` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `kind` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '商品类别',
  `name_chs` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '商品中文名称',
  `name_eng` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '商品英文名称',
  `picture` blob COMMENT '图片',
  `unit` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '单位',
  `cases` int DEFAULT NULL COMMENT '件数',
  `packages` int DEFAULT NULL COMMENT '单件装箱数',
  `packages_total` int DEFAULT NULL COMMENT '总装箱数',
  `length` int DEFAULT NULL COMMENT '长',
  `width` int DEFAULT NULL COMMENT '宽',
  `height` int DEFAULT NULL COMMENT '高',
  `volume` double(10,3) DEFAULT NULL,
  `volume_total` double(10,3) DEFAULT NULL,
  `weight` double(10,2) DEFAULT NULL COMMENT '单件箱重',
  `weight_total` double(10,2) DEFAULT NULL COMMENT '总重量',
  `material` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '材质',
  `price` double(10,2) DEFAULT NULL COMMENT '单价',
  `money` double(10,2) DEFAULT NULL COMMENT '金额',
  `receiving_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '入仓id',
  `ref_cases` int DEFAULT NULL COMMENT '关联件数',
  `note` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_receivinglist`
--

LOCK TABLES `iost_receivinglist` WRITE;
/*!40000 ALTER TABLE `iost_receivinglist` DISABLE KEYS */;
INSERT INTO `iost_receivinglist` VALUES ('16081009544290558131','admin','2020-12-17 17:42:20',NULL,NULL,'A01','001','电视','？？？',NULL,'太台',16,10,160,12324,342,87,366.690,5867.010,21.00,336.00,'塑料',4500.00,26401536.00,'1339097998554042370',1,'液晶电视 打木箱'),('16084477606900519048','yuchengxi','2020-12-20 15:15:35',NULL,NULL,'A02A02','001','电视','？？？',NULL,'台',66,1,66,176,33,155,0.901,59.466,20.00,1320.00,'',4500.00,267597.00,'1340555145326366722',46,'型号111'),('16084477623071527967','yuchengxi','2020-12-20 15:15:35',NULL,NULL,'A02A02','3','纱裙','PARTY TUTU SKIRT',NULL,'条',101,120,12120,46,63,72,0.209,21.109,30.00,3030.00,'',2800.00,59105.20,'1340555145326366722',0,'涤纶'),('16084479295692994329','yuchengxi','2020-12-20 15:15:35',NULL,NULL,'A02A02','3','铝膜气球','BALLON',NULL,'包',67,120,8040,57,61,55,0.192,12.864,27.00,1809.00,'',2300.00,29587.20,'1340555145326366722',0,'1包=12个'),('16084479305323911559','yuchengxi','2020-12-20 15:15:35',NULL,NULL,'A02A02','3','一次性塑料盘','PVC PLATE',NULL,'包',100,100,10000,47,49,63,0.146,14.600,13.50,1350.00,'',2300.00,33580.00,'1340555145326366722',0,'1包=12个'),('16084479308854233821','yuchengxi','2020-12-20 15:15:35',NULL,NULL,'A02A02','3','乳胶气球','BALLON',NULL,'包',22,60,1320,36,33,41,0.049,1.078,11.20,246.40,'',2300.00,2479.40,'1340555145326366722',0,'1包=24个'),('16084479310315124588','yuchengxi','2020-12-20 15:15:35',NULL,NULL,'A02A02','3','PARTY 纸帽','PARTY CAP',NULL,'个',41,120,4920,63,41,76,0.197,8.077,10.32,423.12,'',2300.00,18577.10,'1340555145326366722',0,''),('16084479311626593567','yuchengxi','2020-12-20 15:15:35',NULL,NULL,'A02A02','3','一次性纸杯','PAPER CUP',NULL,'包',66,48,3168,77,71,76,0.416,27.456,16.50,1089.00,'',2300.00,63148.80,'1340555145326366722',0,'1包=12个'),('16093826156980179951','yuchengxi','2020-12-31 10:47:36',NULL,NULL,'A02A02','001','电视','？？？',NULL,'台',111,1,111,180,37,97,0.647,71.817,27.30,3030.30,'',4500.00,323176.50,'1344475261529231362',0,''),('16093826175081555450','yuchengxi','2020-12-31 10:47:36',NULL,NULL,'A02A02','3','一次性纸杯','PAPER CUP',NULL,'包',137,180,24660,77,77,77,0.457,62.609,26.70,3657.90,'',2300.00,144000.70,'1344475261529231362',0,'12个/包'),('16093826176672698652','yuchengxi','2020-12-31 10:47:36',NULL,NULL,'A02A02','3','一次性塑料盘','PVC PLATE',NULL,'包',67,180,12060,66,66,66,0.288,19.296,11.00,737.00,'',2300.00,44380.80,'1344475261529231362',0,'12个/包'),('16093826178123725161','yuchengxi','2020-12-31 10:47:36',NULL,NULL,'A02A02','3','铝膜气球','BALLON',NULL,'包',37,100,3700,37,37,37,0.051,1.887,10.60,392.20,'',2300.00,4340.10,'1344475261529231362',0,'18个/包'),('16093828973080956205','admin','2021-01-02 15:17:10',NULL,NULL,'A01','3','纱裙','PARTY TUTU SKIRT',NULL,'条',100,120,12000,77,87,97,0.650,65.000,30.30,3030.00,'',2800.00,182000.00,'1344475810823671810',0,''),('16093829466061305422','admin','2021-01-02 15:17:10',NULL,NULL,'A01','001','冰箱','bing xiang',NULL,'台',100,2,200,90,90,180,1.459,145.900,32.00,3200.00,'',100.00,14590.00,'1344475810823671810',0,''),('16095716594960802062','yuchengxi','2021-01-02 15:24:04',NULL,NULL,'A02A02','3','乳胶气球','BALLON',NULL,'包',111,120,13320,66,44,33,0.096,10.656,21.21,2354.31,'',2300.00,24508.80,'1345268447696654337',111,'20个/包'),('16095717234391782094','yuchengxi','2021-01-02 15:24:04',NULL,NULL,'A02A02','3','纱裙','PARTY TUTU SKIRT',NULL,'条',222,600,133200,77,121,44,0.410,91.020,63.50,14097.00,'',2800.00,254856.00,'1345268447696654337',222,''),('16095720363380777766','yuchengxi','2021-01-02 15:22:23',NULL,NULL,'A02A02','3','一次性塑料盘','PVC PLATE',NULL,'包',33,120,3960,63,45,33,0.094,3.102,21.00,693.00,'',2300.00,7134.60,'1345269188108750850',33,'12个/包'),('16095721869080618897','yuchengxi','2021-01-02 15:23:46',NULL,NULL,'A02A02','001','电视','？？？',NULL,'台',444,1,444,130,68,77,0.681,302.364,17.00,7548.00,'',4500.00,1360638.00,'1345269536089182209',444,''),('16095722988230304956','yuchengxi','2021-01-02 15:25:41',NULL,NULL,'A02A02','3','一次性纸杯','PAPER CUP',NULL,'包',555,120,66600,66,77,88,0.448,248.640,21.60,11988.00,'',2300.00,571872.00,'1345270018660634625',555,'12个/包'),('16095723786440692912','yuchengxi','2021-01-02 15:27:16',NULL,NULL,'A02A02','3','乳胶气球','BALLON',NULL,'包',666,240,159840,66,77,88,0.448,298.368,21.00,13986.00,'',2300.00,686246.40,'1345270416683307009',666,''),('16095723817471105714','yuchengxi','2021-01-02 15:27:16',NULL,NULL,'A02A02','3','铝膜气球','BALLON',NULL,'个',777,300,233100,44,55,66,0.160,124.320,32.00,24864.00,'',2300.00,285936.00,'1345270416683307009',775,'');
/*!40000 ALTER TABLE `iost_receivinglist` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_receivinglist_copy`
--

DROP TABLE IF EXISTS `iost_receivinglist_copy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_receivinglist_copy` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `name_chs` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '商品中文名称',
  `name_eng` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '商品英文名称',
  `unit` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '单位',
  `cases` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '件数',
  `length` int DEFAULT NULL COMMENT '长（厘米）',
  `volume_total` double(10,3) DEFAULT NULL COMMENT '总体积',
  `weight_total` double(10,2) DEFAULT NULL COMMENT '总重量',
  `packages` int DEFAULT NULL COMMENT '单件装箱数',
  `material` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '材质',
  `money` double(10,2) DEFAULT NULL COMMENT '金额',
  `price` double(10,2) DEFAULT NULL COMMENT '单价',
  `packages_total` int DEFAULT NULL COMMENT '总装箱数',
  `width` int DEFAULT NULL COMMENT '宽（厘米）',
  `height` int DEFAULT NULL COMMENT '高（厘米）',
  `receiving_copy_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '入仓id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_receivinglist_copy`
--

LOCK TABLES `iost_receivinglist_copy` WRITE;
/*!40000 ALTER TABLE `iost_receivinglist_copy` DISABLE KEYS */;
/*!40000 ALTER TABLE `iost_receivinglist_copy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_storage`
--

DROP TABLE IF EXISTS `iost_storage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_storage` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '仓库名称',
  `address` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '仓库地址',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_storage`
--

LOCK TABLES `iost_storage` WRITE;
/*!40000 ALTER TABLE `iost_storage` DISABLE KEYS */;
INSERT INTO `iost_storage` VALUES ('1335477828635856897','admin','2020-12-06 14:55:01',NULL,NULL,'A01','AAA','AAA'),('1335500196762619905','admin','2020-12-06 16:23:54','admin','2020-12-06 16:24:20','A01','义乌仓库','浙江义乌'),('1335500357173776386','admin','2020-12-06 16:24:32','admin','2020-12-30 21:04:37','A01','深圳仓库','深圳仓库');
/*!40000 ALTER TABLE `iost_storage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_summary_sheet`
--

DROP TABLE IF EXISTS `iost_summary_sheet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_summary_sheet` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `bulk_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '散货柜编号',
  `container_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '货柜号',
  `loading_date` datetime DEFAULT NULL COMMENT '装柜日期',
  `warehouse_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '仓库名称',
  `delivery_record_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '出库单Id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_summary_sheet`
--

LOCK TABLES `iost_summary_sheet` WRITE;
/*!40000 ALTER TABLE `iost_summary_sheet` DISABLE KEYS */;
INSERT INTO `iost_summary_sheet` VALUES ('1345265138445324290','yuchengxi','2021-01-02 15:06:17',NULL,NULL,'A02A02','PX2021','234234','2021-01-01 00:00:00','1335500357173776386','1344910108550762497'),('1345276672726798338','yuchengxi','2021-01-02 15:52:07',NULL,NULL,'A02A02','PX2101','MRKU1234567','2021-01-02 00:00:00','1335500196762619905','1345273647039778818');
/*!40000 ALTER TABLE `iost_summary_sheet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `iost_summary_sheet_list`
--

DROP TABLE IF EXISTS `iost_summary_sheet_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `iost_summary_sheet_list` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  `receiving_no` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '入仓号',
  `weight` double(10,2) DEFAULT NULL COMMENT '重量',
  `serial_number` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '序列号',
  `packages` int DEFAULT NULL COMMENT '箱数',
  `volume` double(10,3) DEFAULT NULL COMMENT '体积',
  `money` double(10,2) DEFAULT NULL COMMENT '金额',
  `customer_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '客户名称',
  `deliver_status` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '送货状态',
  `summary_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '汇总单id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `iost_summary_sheet_list`
--

LOCK TABLES `iost_summary_sheet_list` WRITE;
/*!40000 ALTER TABLE `iost_summary_sheet_list` DISABLE KEYS */;
INSERT INTO `iost_summary_sheet_list` VALUES ('1345265138495655937','yuchengxi','2021-01-02 15:06:17','admin','2021-01-08 14:06:45','A02A02','20201216001',21.00,NULL,1,366.690,1650105.00,'sfdsf','2','1345265138445324290'),('1345265138545987586','yuchengxi','2021-01-02 15:06:18','admin','2021-01-08 14:06:45','A02A02','2020122001',1320.00,NULL,NULL,59.466,267597.00,'庄玉松','2','1345265138445324290'),('1345276672735186946','yuchengxi','2021-01-02 15:52:07',NULL,NULL,'A02A02','210101',16451.31,NULL,333,101.676,279364.80,'APPLE 邓','1','1345276672726798338'),('1345276672760352770','yuchengxi','2021-01-02 15:52:07',NULL,NULL,'A02A02','210102',693.00,NULL,33,3.102,7134.60,'志芳','1','1345276672726798338'),('1345276672768741378','yuchengxi','2021-01-02 15:52:07',NULL,NULL,'A02A02','210103',7548.00,NULL,444,302.364,1360638.00,'志芳','1','1345276672726798338'),('1345276672777129986','yuchengxi','2021-01-02 15:52:07',NULL,NULL,'A02A02','210104',11988.00,NULL,555,248.640,571872.00,'庄玉松','1','1345276672726798338'),('1345276672785518593','yuchengxi','2021-01-02 15:52:07',NULL,NULL,'A02A02','210105',38786.00,NULL,1441,422.368,971446.40,'庄玉松','1','1345276672726798338');
/*!40000 ALTER TABLE `iost_summary_sheet_list` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jeecg_monthly_growth_analysis`
--

DROP TABLE IF EXISTS `jeecg_monthly_growth_analysis`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jeecg_monthly_growth_analysis` (
  `id` int NOT NULL AUTO_INCREMENT,
  `year` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `month` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '月份',
  `main_income` decimal(18,2) DEFAULT '0.00' COMMENT '佣金/主营收入',
  `other_income` decimal(18,2) DEFAULT '0.00' COMMENT '其他收入',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jeecg_monthly_growth_analysis`
--

LOCK TABLES `jeecg_monthly_growth_analysis` WRITE;
/*!40000 ALTER TABLE `jeecg_monthly_growth_analysis` DISABLE KEYS */;
INSERT INTO `jeecg_monthly_growth_analysis` VALUES (1,'2018','1月',114758.90,4426054.19),(2,'2018','2月',8970734.12,1230188.67),(3,'2018','3月',26755421.23,2048836.84),(4,'2018','4月',2404990.63,374171.44),(5,'2018','5月',5450793.02,502306.10),(6,'2018','6月',17186212.11,1375154.97),(7,'2018','7月',579975.67,461483.99),(8,'2018','8月',1393590.06,330403.76),(9,'2018','9月',735761.21,1647474.92),(10,'2018','10月',1670442.44,3423368.33),(11,'2018','11月',2993130.34,3552024.00),(12,'2018','12月',4206227.26,3645614.92),(13,'2019','1月',483834.66,418046.77),(14,'2019','2月',11666578.65,731352.20),(15,'2019','3月',27080982.08,1878538.81),(16,'2019','4月',0.00,0.00),(17,'2019','5月',0.00,0.00),(18,'2019','6月',0.00,0.00),(19,'2019','7月',0.00,0.00),(20,'2019','8月',0.00,0.00),(21,'2019','9月',0.00,0.00),(22,'2019','10月',0.00,0.00),(23,'2019','11月',0.00,0.00),(24,'2019','12月',0.00,0.00);
/*!40000 ALTER TABLE `jeecg_monthly_growth_analysis` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jeecg_order_customer`
--

DROP TABLE IF EXISTS `jeecg_order_customer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jeecg_order_customer` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键',
  `name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '客户名',
  `sex` varchar(4) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '性别',
  `idcard` varchar(18) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '身份证号码',
  `idcard_pic` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '身份证扫描件',
  `telphone` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '电话1',
  `order_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '外键',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jeecg_order_customer`
--

LOCK TABLES `jeecg_order_customer` WRITE;
/*!40000 ALTER TABLE `jeecg_order_customer` DISABLE KEYS */;
INSERT INTO `jeecg_order_customer` VALUES ('1256527640480821249','scott','2',NULL,NULL,NULL,'b190737bd04cca8360e6f87c9ef9ec4e','admin','2020-05-02 18:15:09',NULL,NULL),('1256527640531152898','x秦风','1',NULL,NULL,NULL,'b190737bd04cca8360e6f87c9ef9ec4e','admin','2020-05-02 18:15:09',NULL,NULL),('1256527874216800257','小王1','1','',NULL,'','9a57c850e4f68cf94ef7d8585dbaf7e6','admin','2020-05-02 18:17:37',NULL,NULL),('15538561502720','3333','1','',NULL,'','0d4a2e67b538ee1bc881e5ed34f670f0','jeecg-boot','2019-03-29 18:42:55',NULL,NULL),('15538561512681','3332333','2','',NULL,'','0d4a2e67b538ee1bc881e5ed34f670f0','jeecg-boot','2019-03-29 18:42:55','admin','2019-03-29 18:43:12'),('15538561550142','4442','2','',NULL,'','0d4a2e67b538ee1bc881e5ed34f670f0','jeecg-boot','2019-03-29 18:42:55',NULL,NULL),('15541168497342','444','','','','','f71f7f8930b5b6b1703d9948d189982b','admin','2019-04-01 19:08:45',NULL,NULL),('15541168499553','5555','','','','','f71f7f8930b5b6b1703d9948d189982b','admin','2019-04-01 19:08:45',NULL,NULL),('18dc5eb1068ccdfe90e358951ca1a3d6','dr2','','','','','8ab1186410a65118c4d746eb085d3bed','admin','2019-04-04 17:25:33',NULL,NULL),('195d280490fe88ca1475512ddcaf2af9','12',NULL,NULL,NULL,NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('217a2bf83709775d2cd85bf598392327','2',NULL,NULL,NULL,NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('22bc052ae53ed09913b946abba93fa89','1',NULL,NULL,NULL,NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('23bafeae88126c3bf3322a29a04f0d5e','x秦风',NULL,NULL,NULL,NULL,'163e2efcbc6d7d54eb3f8a137da8a75a','jeecg-boot','2019-03-29 18:43:59',NULL,NULL),('25c4a552c6843f36fad6303bfa99a382','1',NULL,NULL,NULL,NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('2d32144e2bee63264f3f16215c258381','33333','2',NULL,NULL,NULL,'d908bfee3377e946e59220c4a4eb414a','admin','2019-04-01 16:27:03',NULL,NULL),('2d43170d6327f941bd1a017999495e25','1',NULL,NULL,NULL,NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('2e5f62a8b6e0a0ce19b52a6feae23d48','3',NULL,NULL,NULL,NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('34a1c5cf6cee360ed610ed0bed70e0f9','导入秦风',NULL,NULL,NULL,NULL,'a2cce75872cc8fcc47f78de9ffd378c2','jeecg-boot','2019-03-29 18:43:59',NULL,NULL),('3c87400f8109b4cf43c5598f0d40e34d','2',NULL,NULL,NULL,NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('40964bcbbecb38e5ac15e6d08cf3cd43','233',NULL,NULL,NULL,NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('41e3dee0b0b6e6530eccb7fbb22fd7a3','4555','1','370285198602058823',NULL,'18611788674','54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('4808ae8344c7679a4a2f461db5dc3a70','44','1','370285198602058823',NULL,'18611788674','54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('4b6cef12f195fad94d57279b2241770d','dr12','','','','','8ab1186410a65118c4d746eb085d3bed','admin','2019-04-04 17:25:33',NULL,NULL),('524e695283f8e8c256cc24f39d6d8542','小王','2','370285198604033222',NULL,'18611788674','eb13ab35d2946a2b0cfe3452bca1e73f','admin','2019-02-25 16:29:41',NULL,NULL),('57c2a8367db34016114cbc9fa368dba0','2',NULL,NULL,NULL,NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('5df36a1608b8c7ac99ad9bc408fe54bf','4',NULL,NULL,NULL,NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('6c6fd2716c2dcd044ed03c2c95d261f8','李四','2','370285198602058833','','18611788676','f71f7f8930b5b6b1703d9948d189982b','admin','2019-04-01 19:08:45',NULL,NULL),('742d008214dee0afff2145555692973e','秦风','1','370285198602058822',NULL,'18611788676','54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('7469c3e5d371767ff90a739d297689b5','导入秦风','2',NULL,NULL,NULL,'3a867ebf2cebce9bae3f79676d8d86f3','jeecg-boot','2019-03-29 18:43:59','admin','2019-04-08 17:35:02'),('7a96e2c7b24847d4a29940dbc0eda6e5','drscott',NULL,NULL,NULL,NULL,'e73434dad84ebdce2d4e0c2a2f06d8ea','jeecg-boot','2019-03-29 18:43:59',NULL,NULL),('7f5a40818e225ee18bda6da7932ac5f9','2',NULL,NULL,NULL,NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('8011575abfd7c8085e71ff66df1124b9','1',NULL,NULL,NULL,NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('8404f31d7196221a573c9bd6c8f15003','小张','1','370285198602058211',NULL,'18611788676','eb13ab35d2946a2b0cfe3452bca1e73f','admin','2019-02-25 16:29:41',NULL,NULL),('859020e10a2f721f201cdbff78cf7b9f','scott',NULL,NULL,NULL,NULL,'163e2efcbc6d7d54eb3f8a137da8a75a','jeecg-boot','2019-03-29 18:43:59',NULL,NULL),('8cc3c4d26e3060975df3a2adb781eeb4','dr33',NULL,NULL,NULL,NULL,'b2feb454e43c46b2038768899061e464','jeecg-boot','2019-04-04 17:23:09',NULL,NULL),('8d1725c23a6a50685ff0dedfd437030d','4',NULL,NULL,NULL,NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('933cae3a79f60a93922d59aace5346ce','小王',NULL,'370285198604033222',NULL,'18611788674','6a719071a29927a14f19482f8693d69a','jeecg-boot','2019-03-29 18:43:59',NULL,NULL),('9bdb5400b709ba4eaf3444de475880d7','dr22',NULL,NULL,NULL,NULL,'22c17790dcd04b296c4a2a089f71895f','jeecg-boot','2019-04-04 17:23:09',NULL,NULL),('9f87677f70e5f864679314389443a3eb','33','2','370285198602058823',NULL,'18611788674','54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('a2c2b7101f75c02deb328ba777137897','44','2','370285198602058823',NULL,'18611788674','54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('ab4d002dc552c326147e318c87d3bed4','小红1','1','370285198604033222',NULL,'18611755848','9a57c850e4f68cf94ef7d8585dbaf7e6','admin','2020-05-02 18:17:37',NULL,NULL),('ad116f722a438e5f23095a0b5fcc8e89','dr秦风',NULL,NULL,NULL,NULL,'e73434dad84ebdce2d4e0c2a2f06d8ea','jeecg-boot','2019-03-29 18:43:59',NULL,NULL),('b1ba147b75f5eaa48212586097fc3fd1','2',NULL,NULL,NULL,NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('b43bf432c251f0e6b206e403b8ec29bc','lisi',NULL,NULL,NULL,NULL,'f8889aaef6d1bccffd98d2889c0aafb5','jeecg-boot','2019-03-29 18:43:59',NULL,NULL),('bcdd300a7d44c45a66bdaac14903c801','33',NULL,NULL,NULL,NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('beb983293e47e2dc1a9b3d649aa3eb34','ddd3',NULL,NULL,NULL,NULL,'d908bfee3377e946e59220c4a4eb414a','admin','2019-04-01 16:27:03',NULL,NULL),('c219808196406f1b8c7f1062589de4b5','44','1','370285198602058823',NULL,'18611788674','54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('c8ed061d4b27c0c7a64e100f2b1c8ab5','张经理','2','370285198602058823',NULL,'18611788674','54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('cc5de4af7f06cd6d250965ebe92a0395','1',NULL,NULL,NULL,NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('cf8817bd703bf7c7c77a2118edc26cc7','1',NULL,NULL,NULL,NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('d72b26fae42e71270fce2097a88da58a','导入scott',NULL,'www',NULL,NULL,'3a867ebf2cebce9bae3f79676d8d86f3','jeecg-boot','2019-03-29 18:43:59','admin','2019-04-08 17:35:05'),('dbdc60a6ac1a8c43f24afee384039b68','xiaowang',NULL,NULL,NULL,NULL,'f8889aaef6d1bccffd98d2889c0aafb5','jeecg-boot','2019-03-29 18:43:59',NULL,NULL),('dc5883b50466de94d900919ed96d97af','33','1','370285198602058823',NULL,'18611788674','54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('deeb73e553ad8dc0a0b3cfd5a338de8e','3333',NULL,NULL,NULL,NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('e2570278bf189ac05df3673231326f47','1',NULL,NULL,NULL,NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('e39cb23bb950b2bdedfc284686c6128a','1',NULL,NULL,NULL,NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('e46fe9111a9100844af582a18a2aa402','1',NULL,NULL,NULL,NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('ee7af0acb9beb9bf8d8b3819a8a7fdc3','2',NULL,NULL,NULL,NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('f5d2605e844192d9e548f9bd240ac908','小张',NULL,'370285198602058211',NULL,'18611788676','6a719071a29927a14f19482f8693d69a','jeecg-boot','2019-03-29 18:43:59',NULL,NULL),('f6db6547382126613a3e46e7cd58a5f2','导入scott',NULL,NULL,NULL,NULL,'a2cce75872cc8fcc47f78de9ffd378c2','jeecg-boot','2019-03-29 18:43:59',NULL,NULL);
/*!40000 ALTER TABLE `jeecg_order_customer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jeecg_order_main`
--

DROP TABLE IF EXISTS `jeecg_order_main`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jeecg_order_main` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键',
  `order_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '订单号',
  `ctype` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '订单类型',
  `order_date` datetime DEFAULT NULL COMMENT '订单日期',
  `order_money` double(10,3) DEFAULT NULL COMMENT '订单金额',
  `content` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '订单备注',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jeecg_order_main`
--

LOCK TABLES `jeecg_order_main` WRITE;
/*!40000 ALTER TABLE `jeecg_order_main` DISABLE KEYS */;
INSERT INTO `jeecg_order_main` VALUES ('163e2efcbc6d7d54eb3f8a137da8a75a','B100',NULL,NULL,3000.000,NULL,'jeecg-boot','2019-03-29 18:43:59',NULL,NULL),('3a867ebf2cebce9bae3f79676d8d86f3','导入B100','2222',NULL,3000.000,NULL,'jeecg-boot','2019-03-29 18:43:59','admin','2019-04-08 17:35:13'),('4cba137333127e8e31df7ad168cc3732','青岛订单A0001','2','2019-04-03 10:56:07',NULL,NULL,'admin','2019-04-03 10:56:11',NULL,NULL),('54e739bef5b67569c963c38da52581ec','NC911','1','2019-02-18 09:58:51',40.000,NULL,'admin','2019-02-18 09:58:47','admin','2019-02-18 09:58:59'),('6a719071a29927a14f19482f8693d69a','c100',NULL,NULL,5000.000,NULL,'jeecg-boot','2019-03-29 18:43:59',NULL,NULL),('8ab1186410a65118c4d746eb085d3bed','导入400','1','2019-02-18 09:58:51',40.000,NULL,'admin','2019-02-18 09:58:47','admin','2019-02-18 09:58:59'),('9a57c850e4f68cf94ef7d8585dbaf7e6','halou001','1','2019-04-04 17:30:32',500.000,NULL,'admin','2019-04-04 17:30:41','admin','2020-05-02 18:17:36'),('a2cce75872cc8fcc47f78de9ffd378c2','导入B100',NULL,NULL,3000.000,NULL,'jeecg-boot','2019-03-29 18:43:59',NULL,NULL),('b190737bd04cca8360e6f87c9ef9ec4e','B0018888','1',NULL,NULL,NULL,'admin','2019-02-15 18:39:29','admin','2020-05-02 18:15:09'),('d908bfee3377e946e59220c4a4eb414a','SSSS001',NULL,NULL,599.000,NULL,'admin','2019-04-01 15:43:03','admin','2019-04-01 16:26:52'),('e73434dad84ebdce2d4e0c2a2f06d8ea','导入200',NULL,NULL,3000.000,NULL,'jeecg-boot','2019-03-29 18:43:59',NULL,NULL),('eb13ab35d2946a2b0cfe3452bca1e73f','BJ9980','1',NULL,90.000,NULL,'admin','2019-02-16 17:36:42','admin','2019-02-16 17:46:16'),('f71f7f8930b5b6b1703d9948d189982b','BY911',NULL,'2019-04-06 19:08:39',NULL,NULL,'admin','2019-04-01 16:36:02','admin','2019-04-01 16:36:08'),('f8889aaef6d1bccffd98d2889c0aafb5','A100',NULL,'2018-10-10 00:00:00',6000.000,NULL,'jeecg-boot','2019-03-29 18:43:59',NULL,NULL);
/*!40000 ALTER TABLE `jeecg_order_main` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jeecg_order_ticket`
--

DROP TABLE IF EXISTS `jeecg_order_ticket`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jeecg_order_ticket` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键',
  `ticket_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '航班号',
  `tickect_date` datetime DEFAULT NULL COMMENT '航班时间',
  `order_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '外键',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jeecg_order_ticket`
--

LOCK TABLES `jeecg_order_ticket` WRITE;
/*!40000 ALTER TABLE `jeecg_order_ticket` DISABLE KEYS */;
INSERT INTO `jeecg_order_ticket` VALUES ('0f0e3a40a215958f807eea08a6e1ac0a','88',NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('0fa3bd0bbcf53650c0bb3c0cac6d8cb7','ffff','2019-02-21 00:00:00','eb13ab35d2946a2b0cfe3452bca1e73f','admin','2019-02-25 16:29:41',NULL,NULL),('1256527640543735810','222','2019-02-23 00:00:00','b190737bd04cca8360e6f87c9ef9ec4e','admin','2020-05-02 18:15:09',NULL,NULL),('1256527640560513025','111','2019-02-01 00:00:00','b190737bd04cca8360e6f87c9ef9ec4e','admin','2020-05-02 18:15:09',NULL,NULL),('14221afb4f5f749c1deef26ac56fdac3','33','2019-03-09 00:00:00','54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('15538561502730','222',NULL,'0d4a2e67b538ee1bc881e5ed34f670f0','jeecg-boot','2019-03-29 18:42:55',NULL,NULL),('15538561526461','2244','2019-03-29 00:00:00','0d4a2e67b538ee1bc881e5ed34f670f0','jeecg-boot','2019-03-29 18:42:55','admin','2019-03-29 18:43:26'),('15541168478913','hhhhh',NULL,'f71f7f8930b5b6b1703d9948d189982b','admin','2019-04-01 19:08:45',NULL,NULL),('18905bc89ee3851805aab38ed3b505ec','44',NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('1f809cbd26f4e574697e1c10de575d72','A100',NULL,'e73434dad84ebdce2d4e0c2a2f06d8ea','jeecg-boot','2019-03-29 18:43:59',NULL,NULL),('21051adb51529bdaa8798b5a3dd7f7f7','C10029','2019-02-20 00:00:00','54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('269576e766b917f8b6509a2bb0c4d4bd','A100',NULL,'163e2efcbc6d7d54eb3f8a137da8a75a','jeecg-boot','2019-03-29 18:43:59',NULL,NULL),('2d473ffc79e5b38a17919e15f8b7078e','66','2019-03-29 00:00:00','54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('3655b66fca5fef9c6aac6d70182ffda2','AA123','2019-04-01 00:00:00','d908bfee3377e946e59220c4a4eb414a','admin','2019-04-01 16:27:03',NULL,NULL),('365d5919155473ade45840fd626c51a9','dddd','2019-04-04 17:25:29','8ab1186410a65118c4d746eb085d3bed','admin','2019-04-04 17:25:33',NULL,NULL),('4889a782e78706ab4306a925cfb163a5','C34','2019-04-01 00:00:00','d908bfee3377e946e59220c4a4eb414a','admin','2019-04-01 16:35:00','admin','2019-04-01 16:35:07'),('48d385796382cf87fa4bdf13b42d9a28','导入A100',NULL,'3a867ebf2cebce9bae3f79676d8d86f3','jeecg-boot','2019-03-29 18:43:59',NULL,NULL),('541faed56efbeb4be9df581bd8264d3a','88',NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('57a27a7dfd6a48e7d981f300c181b355','6','2019-03-30 00:00:00','54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('5ce4dc439c874266e42e6c0ff8dc8b5c','导入A100',NULL,'a2cce75872cc8fcc47f78de9ffd378c2','jeecg-boot','2019-03-29 18:43:59',NULL,NULL),('645a06152998a576c051474157625c41','88','2019-04-04 17:25:31','8ab1186410a65118c4d746eb085d3bed','admin','2019-04-04 17:25:33',NULL,NULL),('6e3562f2571ea9e96b2d24497b5f5eec','55','2019-03-23 00:00:00','54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('8fd2b389151568738b1cc4d8e27a6110','导入A100',NULL,'a2cce75872cc8fcc47f78de9ffd378c2','jeecg-boot','2019-03-29 18:43:59',NULL,NULL),('93f1a84053e546f59137432ff5564cac','55',NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('969ddc5d2e198d50903686917f996470','A10029','2019-04-01 00:00:00','f71f7f8930b5b6b1703d9948d189982b','admin','2019-04-01 19:08:45',NULL,NULL),('96e7303a8d22a5c384e08d7bcf7ac2bf','A100',NULL,'e73434dad84ebdce2d4e0c2a2f06d8ea','jeecg-boot','2019-03-29 18:43:59',NULL,NULL),('9e8a3336f6c63f558f2b68ce2e1e666e','深圳1001','2020-05-02 00:00:00','9a57c850e4f68cf94ef7d8585dbaf7e6','admin','2020-05-02 18:17:37',NULL,NULL),('a28db02c810c65660015095cb81ed434','A100',NULL,'f8889aaef6d1bccffd98d2889c0aafb5','jeecg-boot','2019-03-29 18:43:59',NULL,NULL),('b217bb0e4ec6a45b6cbf6db880060c0f','A100',NULL,'6a719071a29927a14f19482f8693d69a','jeecg-boot','2019-03-29 18:43:59',NULL,NULL),('ba708df70bb2652ed1051a394cfa0bb3','333',NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('beabbfcb195d39bedeeafe8318794562','A1345','2019-04-01 00:00:00','d908bfee3377e946e59220c4a4eb414a','admin','2019-04-01 16:27:04',NULL,NULL),('bf450223cb505f89078a311ef7b6ed16','777','2019-03-30 00:00:00','54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('c06165b6603e3e1335db187b3c841eef','北京2001','2020-05-23 00:00:00','9a57c850e4f68cf94ef7d8585dbaf7e6','admin','2020-05-02 18:17:37',NULL,NULL),('c113136abc26ace3a6da4e41d7dc1c7e','44','2019-03-15 00:00:00','54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('c1abdc2e30aeb25de13ad6ee3488ac24','77','2019-03-22 00:00:00','54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('c23751a7deb44f553ce50a94948c042a','33','2019-03-09 00:00:00','8ab1186410a65118c4d746eb085d3bed','admin','2019-04-04 17:25:33',NULL,NULL),('c64547666b634b3d6a0feedcf05f25ce','C10019','2019-04-01 00:00:00','f71f7f8930b5b6b1703d9948d189982b','admin','2019-04-01 19:08:45',NULL,NULL),('c8b8d3217f37da78dddf711a1f7da485','A100',NULL,'163e2efcbc6d7d54eb3f8a137da8a75a','jeecg-boot','2019-03-29 18:43:59',NULL,NULL),('cab691c1c1ff7a6dfd7248421917fd3c','A100',NULL,'f8889aaef6d1bccffd98d2889c0aafb5','jeecg-boot','2019-03-29 18:43:59',NULL,NULL),('cca10a9a850b456d9b72be87da7b0883','77',NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('d2fbba11f4814d9b1d3cb1a3f342234a','C10019','2019-02-18 00:00:00','54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('dbdb07a16826808e4276e84b2aa4731a','导入A100',NULL,'3a867ebf2cebce9bae3f79676d8d86f3','jeecg-boot','2019-03-29 18:43:59',NULL,NULL),('e7075639c37513afc0bbc4bf7b5d98b9','88',NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('fa759dc104d0371f8aa28665b323dab6','888',NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL),('ff197da84a9a3af53878eddc91afbb2e','33',NULL,'54e739bef5b67569c963c38da52581ec','admin','2019-03-15 16:50:15',NULL,NULL);
/*!40000 ALTER TABLE `jeecg_order_ticket` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jeecg_project_nature_income`
--

DROP TABLE IF EXISTS `jeecg_project_nature_income`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jeecg_project_nature_income` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nature` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '项目性质',
  `insurance_fee` decimal(18,2) DEFAULT '0.00' COMMENT '保险经纪佣金费',
  `risk_consulting_fee` decimal(18,2) DEFAULT '0.00' COMMENT '风险咨询费',
  `evaluation_fee` decimal(18,2) DEFAULT '0.00' COMMENT '承保公估评估费',
  `insurance_evaluation_fee` decimal(18,2) DEFAULT '0.00' COMMENT '保险公估费',
  `bidding_consulting_fee` decimal(18,2) DEFAULT '0.00' COMMENT '投标咨询费',
  `interol_consulting_fee` decimal(18,2) DEFAULT '0.00' COMMENT '内控咨询费',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jeecg_project_nature_income`
--

LOCK TABLES `jeecg_project_nature_income` WRITE;
/*!40000 ALTER TABLE `jeecg_project_nature_income` DISABLE KEYS */;
INSERT INTO `jeecg_project_nature_income` VALUES (1,'市场化-电商业务',4865.41,0.00,0.00,0.00,0.00,0.00),(2,'统筹型',35767081.88,0.00,0.00,0.00,0.00,0.00),(3,'市场化-非股东',1487045.35,0.00,0.00,0.00,0.00,0.00),(4,'市场化-参控股',382690.56,0.00,0.00,0.00,0.00,0.00),(5,'市场化-员工福利',256684.91,0.00,0.00,0.00,0.00,0.00),(6,'市场化-再保险',563451.03,0.00,0.00,0.00,0.00,0.00),(7,'市场化-海外业务',760576.25,770458.75,0.00,0.00,0.00,0.00),(8,'市场化-风险咨询',910183.93,0.00,0.00,0.00,0.00,226415.09);
/*!40000 ALTER TABLE `jeecg_project_nature_income` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `joa_demo`
--

DROP TABLE IF EXISTS `joa_demo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `joa_demo` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'ID',
  `name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '请假人',
  `days` int DEFAULT NULL COMMENT '请假天数',
  `begin_date` datetime DEFAULT NULL COMMENT '开始时间',
  `end_date` datetime DEFAULT NULL COMMENT '请假结束时间',
  `reason` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '请假原因',
  `bpm_status` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '1' COMMENT '流程状态',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人id',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改人id'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='流程测试';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `joa_demo`
--

LOCK TABLES `joa_demo` WRITE;
/*!40000 ALTER TABLE `joa_demo` DISABLE KEYS */;
/*!40000 ALTER TABLE `joa_demo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `onl_auth_data`
--

DROP TABLE IF EXISTS `onl_auth_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `onl_auth_data` (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `cgform_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'online表ID',
  `rule_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '规则名',
  `rule_column` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '规则列',
  `rule_operator` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '规则条件 大于小于like',
  `rule_value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '规则值',
  `status` int DEFAULT NULL COMMENT '1有效 0无效',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `create_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `onl_auth_data`
--

LOCK TABLES `onl_auth_data` WRITE;
/*!40000 ALTER TABLE `onl_auth_data` DISABLE KEYS */;
INSERT INTO `onl_auth_data` VALUES ('1331533301494288385','dd396a66386745c4993dc5c941c07a2e','义乌仓库','warehouse_name','=','义乌仓库',1,'2020-11-25 17:40:52','admin',NULL,NULL);
/*!40000 ALTER TABLE `onl_auth_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `onl_auth_page`
--

DROP TABLE IF EXISTS `onl_auth_page`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `onl_auth_page` (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT ' 主键',
  `cgform_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'online表id',
  `code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '字段名/按钮编码',
  `type` int DEFAULT NULL COMMENT '1字段 2按钮',
  `control` int DEFAULT NULL COMMENT '3可编辑 5可见(仅支持两种状态值3,5)',
  `page` int DEFAULT NULL COMMENT '3列表 5表单(仅支持两种状态值3,5)',
  `status` int DEFAULT NULL COMMENT '1有效 0无效',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `onl_auth_page`
--

LOCK TABLES `onl_auth_page` WRITE;
/*!40000 ALTER TABLE `onl_auth_page` DISABLE KEYS */;
/*!40000 ALTER TABLE `onl_auth_page` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `onl_auth_relation`
--

DROP TABLE IF EXISTS `onl_auth_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `onl_auth_relation` (
  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `role_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '角色id',
  `auth_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '权限id',
  `type` int DEFAULT NULL COMMENT '1字段 2按钮 3数据权限',
  `cgform_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'online表单ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `onl_auth_relation`
--

LOCK TABLES `onl_auth_relation` WRITE;
/*!40000 ALTER TABLE `onl_auth_relation` DISABLE KEYS */;
/*!40000 ALTER TABLE `onl_auth_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `onl_cgform_button`
--

DROP TABLE IF EXISTS `onl_cgform_button`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `onl_cgform_button` (
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键ID',
  `BUTTON_CODE` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '按钮编码',
  `BUTTON_ICON` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '按钮图标',
  `BUTTON_NAME` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '按钮名称',
  `BUTTON_STATUS` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '按钮状态',
  `BUTTON_STYLE` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '按钮样式',
  `EXP` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '表达式',
  `CGFORM_HEAD_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '表单ID',
  `OPT_TYPE` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '按钮类型',
  `ORDER_NUM` int DEFAULT NULL COMMENT '排序',
  `OPT_POSITION` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '按钮位置1侧面 2底部',
  PRIMARY KEY (`ID`) USING BTREE,
  KEY `index_formid` (`CGFORM_HEAD_ID`) USING BTREE,
  KEY `index_button_code` (`BUTTON_CODE`) USING BTREE,
  KEY `index_button_status` (`BUTTON_STATUS`) USING BTREE,
  KEY `index_button_order` (`ORDER_NUM`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='Online表单自定义按钮';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `onl_cgform_button`
--

LOCK TABLES `onl_cgform_button` WRITE;
/*!40000 ALTER TABLE `onl_cgform_button` DISABLE KEYS */;
INSERT INTO `onl_cgform_button` VALUES ('108a564643763de3f4c81bc2deb463df','bt1',NULL,'激活','1','button',NULL,'05a3a30dada7411c9109306aa4117068','js',NULL,'2'),('6c62a2d51a0846eeb4299429bbc37e45','btn_one','form','生成保险单','1','button',NULL,'e96d84a719654f6e9cc1d73c315b0ccc','action',1,'2'),('7c140322fb6b1da7a5daed8b6edc0fb7','tjbpm',NULL,'提交流程','1','link',NULL,'05a3a30dada7411c9109306aa4117068','js',NULL,'2'),('a45bc1c6fba96be6b0c91ffcdd6b54aa','genereate_person_config','icon-edit','生成配置','1','link',NULL,'e2faf977fdaf4b25a524f58c2441a51c','js',NULL,'2'),('cc1d12de57a1a41d3986ed6d13e3ac11','链接按钮测试','icon-edit','自定义link','1','link',NULL,'d35109c3632c4952a19ecc094943dd71','js',NULL,'2'),('e2a339b9fdb4091bee98408c233ab36d','zuofei',NULL,'作废','1','form',NULL,'05a3a30dada7411c9109306aa4117068','js',NULL,'2'),('ebcc48ef0bde4433a6faf940a5e170c1','button按钮测试','icon-edit','自定义button','1','button',NULL,'d35109c3632c4952a19ecc094943dd71','js',NULL,'2');
/*!40000 ALTER TABLE `onl_cgform_button` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `onl_cgform_enhance_java`
--

DROP TABLE IF EXISTS `onl_cgform_enhance_java`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `onl_cgform_enhance_java` (
  `ID` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `BUTTON_CODE` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '按钮编码',
  `CG_JAVA_TYPE` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '类型',
  `CG_JAVA_VALUE` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '数值',
  `CGFORM_HEAD_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '表单ID',
  `ACTIVE_STATUS` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '1' COMMENT '生效状态',
  `EVENT` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'end' COMMENT '事件状态(end:结束，start:开始)',
  PRIMARY KEY (`ID`) USING BTREE,
  KEY `index_fmid` (`CGFORM_HEAD_ID`) USING BTREE,
  KEY `index_buttoncode` (`BUTTON_CODE`) USING BTREE,
  KEY `index_status` (`ACTIVE_STATUS`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `onl_cgform_enhance_java`
--

LOCK TABLES `onl_cgform_enhance_java` WRITE;
/*!40000 ALTER TABLE `onl_cgform_enhance_java` DISABLE KEYS */;
/*!40000 ALTER TABLE `onl_cgform_enhance_java` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `onl_cgform_enhance_js`
--

DROP TABLE IF EXISTS `onl_cgform_enhance_js`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `onl_cgform_enhance_js` (
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键ID',
  `CG_JS` longtext CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT 'JS增强内容',
  `CG_JS_TYPE` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '类型',
  `CONTENT` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '备注',
  `CGFORM_HEAD_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '表单ID',
  PRIMARY KEY (`ID`) USING BTREE,
  KEY `index_fmid` (`CGFORM_HEAD_ID`) USING BTREE,
  KEY `index_jstype` (`CG_JS_TYPE`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `onl_cgform_enhance_js`
--

LOCK TABLES `onl_cgform_enhance_js` WRITE;
/*!40000 ALTER TABLE `onl_cgform_enhance_js` DISABLE KEYS */;
INSERT INTO `onl_cgform_enhance_js` VALUES ('0b326acbbc8e52c9c9ecdb19342fc3cf','','form',NULL,'05a3a30dada7411c9109306aa4117068'),('274b5d741a0262d3411958f0c465c5f0','genereate_person_config(row){\nconsole.log(\'选择\',row)\nalert(row.name + \'，个人积分配置生成成功！\');\n}','list',NULL,'e2faf977fdaf4b25a524f58c2441a51c'),('2cbaf25f1edb620bea2d8de07f8233a1','air_china_post_materiel_item_onlChange(){\n    return {\n        wl_name(){\n           \n            let id = event.row.id\n            let cnum = event.row.num\n            let value = event.value\n            let targrt = event.target\n            let columnKey = event.column.key\n           let nval = 200*cnum\n           console.log(\'row\',event.row);\n           console.log(\'cnum\',cnum);\n           let otherValues = {\'jifen\': nval}\n              \n                that.triggleChangeValues(targrt,id,otherValues)\n\n        }\n    }\n}','form',NULL,'e67d26b610dd414c884c4dbb24e71ce3'),('32e7b7373abe0fb9c4dd608b4517f814','','form',NULL,'53a3e82b54b946c2b904f605875a275c'),('35d4ef464e5e8c87c9aa82ea89215fc1','','list',NULL,'e67d26b610dd414c884c4dbb24e71ce3'),('44cad4eec436328ed3cc134855f8d1d5',' onlChange(){\n   return {\n    name(that, event) {\n      that.executeMainFillRule()\n    }\n  }\n }','form',NULL,'4adec929a6594108bef5b35ee9966e9f'),('4569bc0e6126d2b8a0e0c69b9a47e8db','','list',NULL,'56efb74326e74064b60933f6f8af30ea'),('6dd82d8eac166627302230a809233481','ces_order_goods_onlChange(){\n    return {\n        num(){\n           \n            let id = event.row.id\n            let num = event.row.num\n            let price = event.row.price\n\n            let targrt = event.target\n            \n            let nval = price*num\n            console.log(\'row\',event.row);\n            console.log(\'num\',num);\n            console.log(\'that\',that);\n            let otherValues = {\'zong_price\': nval}\n              \n            that.triggleChangeValues(otherValues,id,targrt)\n   \n\n        }\n    }\n}','form',NULL,'56efb74326e74064b60933f6f8af30ea'),('85e7acd772c8ec322b97a1fd548007e0','','form',NULL,'09fd28e4b7184c1a9668496a5c496450'),('8b76f282ddc81ce99a129e90fdd977ce','','form',NULL,'86bf17839a904636b7ed96201b2fa6ea'),('90394fbc3d48978cc0937bc56f2d5370','','list',NULL,'deea5a8ec619460c9245ba85dbc59e80'),('ae9cf52fbe13cc718de2de6e1b3d6792','','list',NULL,'18f064d1ef424c93ba7a16148851664f'),('beec235f0b2d633ff3a6c395affdf59d','','list',NULL,'4adec929a6594108bef5b35ee9966e9f'),('c5ac9a2b2fd92ef68274f630b8aec78a','tjbpm(row){\n  alert(\'提交流程\')\n  console.log(\'row\',row)\n}\n\nbt1(){\n   console.log(\'that.table.selectionRows\',that.table.selectionRows)\n   console.log(\'that.table.selectedRowKeys\',that.table.selectedRowKeys)\n   console.log(\'that.table.dataSource\',that.table.dataSource)\n   alert(\'激活全部数据\')\n}','list',NULL,'05a3a30dada7411c9109306aa4117068'),('d7ddb7aa407f6deed75aac11f0a25f0e','222','list',NULL,'09fd28e4b7184c1a9668496a5c496450'),('f6f8f230566d09d4b66338955ffb5691','','form',NULL,'18f064d1ef424c93ba7a16148851664f'),('fd711738f58d5481ca0ce9bc3a415223','','list',NULL,'86bf17839a904636b7ed96201b2fa6ea');
/*!40000 ALTER TABLE `onl_cgform_enhance_js` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `onl_cgform_enhance_sql`
--

DROP TABLE IF EXISTS `onl_cgform_enhance_sql`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `onl_cgform_enhance_sql` (
  `ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键ID',
  `BUTTON_CODE` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '按钮编码',
  `CGB_SQL` longtext CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT 'SQL内容',
  `CGB_SQL_NAME` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'Sql名称',
  `CONTENT` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '备注',
  `CGFORM_HEAD_ID` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '表单ID',
  PRIMARY KEY (`ID`) USING BTREE,
  KEY `index_formid` (`CGFORM_HEAD_ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `onl_cgform_enhance_sql`
--

LOCK TABLES `onl_cgform_enhance_sql` WRITE;
/*!40000 ALTER TABLE `onl_cgform_enhance_sql` DISABLE KEYS */;
INSERT INTO `onl_cgform_enhance_sql` VALUES ('0ebf418bd02f486342123eaf84cd39ad','add','',NULL,'','18f064d1ef424c93ba7a16148851664f'),('5ab418a13fd0bbf30ee9dd04203f3c28','add','',NULL,'','4adec929a6594108bef5b35ee9966e9f'),('8750b93ba5332460c76c492359d7a06b','edit','',NULL,'','18f064d1ef424c93ba7a16148851664f'),('c1ba45b6ee70e4662b5ec95f8fdcb31f','add','',NULL,'','05a3a30dada7411c9109306aa4117068'),('edfab059050b19328ac81e6833b5ebc2','delete','',NULL,'','18f064d1ef424c93ba7a16148851664f');
/*!40000 ALTER TABLE `onl_cgform_enhance_sql` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `onl_cgform_field`
--

DROP TABLE IF EXISTS `onl_cgform_field`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `onl_cgform_field` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键ID',
  `cgform_head_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '表ID',
  `db_field_name` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '字段名字',
  `db_field_txt` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '字段备注',
  `db_field_name_old` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '原字段名',
  `db_is_key` tinyint(1) DEFAULT NULL COMMENT '是否主键 0否 1是',
  `db_is_null` tinyint(1) DEFAULT NULL COMMENT '是否允许为空0否 1是',
  `db_type` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '数据库字段类型',
  `db_length` int NOT NULL COMMENT '数据库字段长度',
  `db_point_length` int DEFAULT NULL COMMENT '小数点',
  `db_default_val` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '表字段默认值',
  `dict_field` varchar(255) DEFAULT NULL,
  `dict_table` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '字典表',
  `dict_text` varchar(255) DEFAULT NULL,
  `field_show_type` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '表单控件类型',
  `field_href` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '跳转URL',
  `field_length` int DEFAULT NULL COMMENT '表单控件长度',
  `field_valid_type` varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '表单字段校验规则',
  `field_must_input` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '字段是否必填',
  `field_extend_json` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '扩展参数JSON',
  `field_default_value` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '控件默认值，不同的表达式展示不同的结果。\r\n1. 纯字符串直接赋给默认值；\r\n2. #{普通变量}；\r\n3. {{ 动态JS表达式 }}；\r\n4. ${填值规则编码}；\r\n填值规则表达式只允许存在一个，且不能和其他规则混用。',
  `is_query` tinyint(1) DEFAULT NULL COMMENT '是否查询条件0否 1是',
  `is_show_form` tinyint(1) DEFAULT NULL COMMENT '表单是否显示0否 1是',
  `is_show_list` tinyint(1) DEFAULT NULL COMMENT '列表是否显示0否 1是',
  `is_read_only` tinyint(1) DEFAULT '0' COMMENT '是否是只读（1是 0否）',
  `query_mode` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '查询模式',
  `main_table` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '外键主表名',
  `main_field` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '外键主键字段',
  `order_num` int DEFAULT NULL COMMENT '排序',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `create_by` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `converter` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '自定义值转换器',
  `query_def_val` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '查询默认值',
  `query_dict_text` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '查询配置字典text',
  `query_dict_field` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '查询配置字典code',
  `query_dict_table` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '查询配置字典table',
  `query_show_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '查询显示控件',
  `query_config_flag` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '是否启用查询配置1是0否',
  `query_valid_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '查询字段校验类型',
  `query_must_input` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '查询字段是否必填1是0否',
  `sort_flag` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '是否支持排序1是0否',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `inex_table_id` (`cgform_head_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `onl_cgform_field`
--

LOCK TABLES `onl_cgform_field` WRITE;
/*!40000 ALTER TABLE `onl_cgform_field` DISABLE KEYS */;
INSERT INTO `onl_cgform_field` VALUES ('0021c969dc23a9150d6f70a13b52e73e','402860816aa5921f016aa5921f480000','begin_date','开始时间','begin_date',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',4,'admin','2019-05-11 15:31:54','2019-05-11 14:26:19','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('0029de01d59389a1231dd430040dd902','a3c6f1140f7e447eb5bdb26898181fba','title','标题',NULL,0,0,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2020-11-26 16:35:41','2020-11-26 16:17:55','admin','','','','','','text','0',NULL,NULL,'0'),('01788b3dc561f1008ef89adaf42a035c','d7b42c2262774ded8de4ab7dea6463a9','invoice_number','发票号',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',6,'admin','2020-12-26 00:27:15','2020-11-16 10:35:13','admin','','','','','','text','0',NULL,NULL,'0'),('020c1622c3df0aef30185f57874f6959','79091e8277c744158530321513119c68','bpm_status','流程状态',NULL,0,1,'String',32,0,'1','bpm_status','','','text','',120,NULL,'0','','',0,0,1,0,'single','','',8,'admin','2019-05-11 15:29:47','2019-05-11 15:29:26','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('02605b41eb994fdcaad86224b179429d','f3071ca217274b6892238c4b60e1f177','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-12-21 14:49:28','2020-11-16 10:39:30','admin','','','','','',NULL,'0',NULL,NULL,'0'),('02b20e692456403e2fed1a89a06833b4','402860816bff91c0016bff91d2810005','phone','联系方式','phone',0,1,'string',20,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',8,'admin','2019-07-19 18:05:55','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('02df88fb594883d21c59105c4f5e8b5d','11c83901545e454192a300d427e7ad2c','cases','件数',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'1','','',0,1,1,0,'single','','',13,'admin','2020-12-18 15:39:16','2020-11-10 09:15:18','admin','','','','','','text','0',NULL,NULL,'0'),('030bcfbe69bdde589a76ff3de7768ae7','caa8de52a4dd4c2e909582709619fa7d','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-12-14 15:02:32','2020-11-09 15:04:12','admin','','','','','',NULL,'0',NULL,NULL,'0'),('030f23b3e4a59c9970eb35f0c5db3cdd','e96d84a719654f6e9cc1d73c315b0ccc','cases','件数',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,1,'single','','',15,'admin','2020-12-16 19:19:09','2020-11-10 09:18:44','admin','','','','','','text','0',NULL,NULL,'0'),('03668009f0ad92b20abb1a377197ee47','deea5a8ec619460c9245ba85dbc59e80','order_fk_id','订单外键ID',NULL,0,0,'String',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','test_order_main','id',10,'admin','2020-05-03 01:01:18','2019-04-20 11:42:53','admin','','','','','',NULL,'0',NULL,NULL,'0'),('03709092184fdf4a66b0cdb4dd10a159','402860816bff91c0016bffa220a9000b','bpm_status','流程状态',NULL,0,1,'String',32,0,'1','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',46,'admin','2019-07-22 16:15:32','2019-07-19 15:34:44','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('03770f813384ba6fd950ddfc54a80104','e033c8909649408ea5bb53e74f7fec7b','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-12-14 17:44:02','2020-11-10 08:36:39','admin','','','','','',NULL,'0',NULL,NULL,'0'),('03988419d751a330c2b0f0519a531880','997ee931515a4620bc30a9c1246429a9','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-05-03 00:57:44','2020-05-03 00:56:56','admin','','','','','',NULL,'0',NULL,NULL,'0'),('03c105d2706c8286416833684de67406','79091e8277c744158530321513119c68','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2019-05-11 15:29:47','2019-05-11 15:27:17','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('03fd5ab69f331ff760c3f7d86b4a93f8','4028318169e81b970169e81b97650000','log_content','日志内容','log_content',0,1,'string',1000,0,NULL,NULL,NULL,NULL,'text',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,3,NULL,NULL,'2019-04-04 19:28:36','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('045eb432c418b2b103b1e1b8e8a8a75d','fb7125a344a649b990c12949945cb6c1','age','年龄',NULL,0,1,'int',32,0,'','','','','text','',120,'','0','','',0,1,1,0,'single','','',NULL,NULL,NULL,'2019-03-26 19:24:11','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('04e4185a503e6aaaa31c243829ff4ac7','d35109c3632c4952a19ecc094943dd71','birthday','生日',NULL,0,1,'Date',32,0,'','','','','date','',120,'','0','','',0,1,1,0,'single','','',10,'admin','2020-07-17 15:22:04','2019-03-15 14:24:35','admin','','','','','',NULL,'0',NULL,NULL,'0'),('04ff134cb4aae845059e10b3b85f1451','7ea60a25fa27470e9080d6a921aabbd1','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,NULL,NULL,'2019-04-17 00:22:21','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('051dd70c504c97a028daab2af261ea35','1acb6f81a1d9439da6cc4e868617b565','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2019-06-10 14:47:14','2019-04-23 22:58:19','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('052dcc6f34976b66754fd99415bd22ce','79091e8277c744158530321513119c68','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2019-05-11 15:29:47','2019-05-11 15:27:17','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('054db05394e83b318f097a60bc044134','402860816bff91c0016bffa220a9000b','residence_address','户籍地址','residence_address',0,1,'string',200,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',28,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('057b105b7d4b9c5e252b2aefe80e0848','f70eb6fe0df74c5eb04552f5c1a4b7b3','weight_total','总重量',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',17,'admin','2020-12-16 20:11:33','2020-12-16 20:08:14','admin','','','','','','text','0',NULL,NULL,'0'),('05d10f41eee8e6fc8f9bfec735761def','e96d84a719654f6e9cc1d73c315b0ccc','length','长',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,1,'single','','',19,'admin','2020-12-16 19:19:09','2020-11-10 09:28:24','admin','','','','','','text','0',NULL,NULL,'0'),('05dbdd8d9f0f84c8504faa6f24c7d4ac','402880eb71d61d3d0171d61d3de30000','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',9,'admin','2020-05-03 00:54:16','2020-05-02 23:59:33','admin','','','','','','text','0',NULL,NULL,'0'),('05ed6a78a2e9d0c82bfa2c55898570b8','997ee931515a4620bc30a9c1246429a9','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-05-03 00:57:44','2020-05-03 00:56:56','admin','','','','','',NULL,'0',NULL,NULL,'0'),('0604945c206e867644e9a44b4c9b20c6','fb19fb067cd841f9ae93d4eb3b883dc0','2','4',NULL,0,1,'string',32,0,'','','','','text','',120,'','0','','',0,1,1,0,'single','','',5,NULL,NULL,'2019-03-23 11:39:48','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('060deee190f9265e4254ccad6989b200','47a79ec9f7f64c21aa55634bf619406d','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,NULL,NULL,'2020-11-16 15:21:22','admin','','','','','',NULL,'0',NULL,NULL,'0'),('0617de6d735b37a3f80f2f35ad5d1511','4028839a6de2ebd3016de2ebd3870000','size_type','尺码类型','size_type',0,1,'string',2,0,NULL,NULL,NULL,NULL,'text',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,13,NULL,NULL,'2019-10-19 15:29:30','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('0619dfc3fbf9e193534bb3460a1a9d92','cb2d8534a2f544bc9c618dd49da66336','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-02-24 17:22:42','2020-02-24 15:15:13','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('06a1badae6119abf4ec48858a3e94e1c','402860816bff91c0016bffa220a9000b','sys_org_code','组织机构编码','sys_org_code',0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',43,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('06b52d79136b9d13767209ded9f97681','f79dbb25b30c4357a334db84a0e24a55','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2021-01-08 11:48:00','2021-01-08 11:15:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('06f1cfff58395ff62526b894f6182641','e67d26b610dd414c884c4dbb24e71ce3','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2019-04-24 11:03:32','2019-04-24 11:02:57','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('0751686f567551d7b7705709101ed24f','506c10297a174bf39f4658da3462213b','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2021-01-01 22:30:01','2020-11-12 17:16:04','admin','','','','','',NULL,'0',NULL,NULL,'0'),('07a307972076a392ffc61b11437f89dd','402860816bff91c0016bff91c0cb0000','create_time','创建时间','create_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',13,'admin','2019-07-19 18:09:01','2019-07-17 18:54:32','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('07f4776fd641389a8c98a85713990dce','402860816bff91c0016bff91c0cb0000','update_by','更新人','update_by',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',14,'admin','2019-07-19 18:09:01','2019-07-17 18:54:32','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('080b2d3aa84505eaa7b9dc9d439fd9af','f3071ca217274b6892238c4b60e1f177','money','金额',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',13,'admin','2020-12-21 14:49:28','2020-11-16 10:39:30','admin','','','','','','text','0',NULL,NULL,'0'),('08f002095da7c1886c86648fcec38ca9','56efb74326e74064b60933f6f8af30ea','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-07-10 16:53:27','2020-05-08 23:45:32','admin','','','','','',NULL,'0',NULL,NULL,'0'),('09450359eb90b40d224ec43588a62f9e','402860816bff91c0016bff91c0cb0000','user_id','用户ID','user_id',0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',3,'admin','2019-07-19 18:09:01','2019-07-17 18:54:32','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('0966481f8fca7fa5ea84a71bf4b1accc','47a79ec9f7f64c21aa55634bf619406d','telephone','手机',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',11,NULL,NULL,'2020-11-16 15:21:22','admin','','','','','','text','0',NULL,NULL,'0'),('0a453a63e33654aa1b9ee2affa854a6d','4fb8e12a697f4d5bbe9b9fb1e9009486','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-04-10 19:51:27','2020-04-10 19:47:01','admin','','','','','',NULL,'0',NULL,NULL,'0'),('0a4cdcb7e54f614ab952024f6c72bb6d','beee191324fd40c1afec4fda18bd9d47','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2019-04-13 13:41:13','2019-04-13 13:40:56','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('0acfc27e493c204f72d42b6dc00a2ded','53a3e82b54b946c2b904f605875a275c','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-05-08 23:42:51','2020-05-07 22:49:47','admin','','','','','',NULL,'0',NULL,NULL,'0'),('0adc06d9b497684bcbb5a781e044517c','1acb6f81a1d9439da6cc4e868617b565','supplier','供应商',NULL,0,1,'String',32,0,'','air_china_ supplier','','','list','',120,NULL,'0','','',0,1,1,0,'single','','',15,'admin','2019-06-10 14:47:14','2019-04-24 16:52:00','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('0ae4bc5d4921aa240d814e018ddb7779','56efb74326e74064b60933f6f8af30ea','money','订单总额',NULL,0,1,'double',10,3,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2020-07-10 16:53:27','2020-05-08 23:45:32','admin','','','','','','text','0',NULL,NULL,'0'),('0b0f95327694e09d0bda51b90931c0c6','e96d84a719654f6e9cc1d73c315b0ccc','packages_total','总装箱数',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,1,'single','','',17,'admin','2020-12-16 19:19:09','2020-11-10 09:28:24','admin','','','','','','text','0',NULL,NULL,'0'),('0b3e833ac4aae3a13ec2f8ae460708f8','4028839a6de2ebd3016de2ebd3870000','no','预算表序号','no',0,1,'string',50,0,NULL,NULL,NULL,NULL,'text',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,8,NULL,NULL,'2019-10-19 15:29:30','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('0b60ae26bd7faa925b090b9ee8b0dd1b','38b8d95658a74899b7dc02e63e199af6','name','仓库名称',NULL,0,0,'string',32,0,'','','','','text','',120,NULL,'1','','',1,1,1,0,'single','','',7,'admin','2020-12-14 14:53:53','2020-11-09 14:23:45','admin','','','','','','text','1',NULL,NULL,'0'),('0b63bd30b8646901310d8d0374df5587','18f064d1ef424c93ba7a16148851664f','fuwenb','富文本',NULL,0,1,'Text',0,0,'','','','','umeditor','',120,NULL,'0','','',0,1,1,0,'single','','',17,'admin','2020-09-11 14:35:44','2020-05-12 20:26:01','admin','','','','','','text','0',NULL,NULL,'0'),('0b67b21180739b43a260608c624147d5','5c58150ab99a4487bc5b4666f762962a','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-12-21 14:14:25','2020-11-13 15:35:09','admin','','','','','',NULL,'0',NULL,NULL,'0'),('0ba1bf74e2a6a94a7a63010ec7230706','402860816bff91c0016bffa220a9000b','update_time','更新时间','update_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',42,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('0bd10d416252bdc6b169056d2a1a4a68','402880e5721355dd01721355dd390000','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single',NULL,NULL,3,NULL,NULL,'2020-05-14 21:18:14','admin','','','','','',NULL,'0',NULL,NULL,'0'),('0bf9c178173bd86eec4144b819cfac0b','18f064d1ef424c93ba7a16148851664f','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-09-11 14:35:44','2020-05-12 20:26:01','admin','','','','','',NULL,'0',NULL,NULL,'0'),('0c34ebfe2e2a619d42db13f93d2a2d40','b81de38db24047b497d476516f8a0865','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,NULL,NULL,'2020-02-24 14:56:08','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('0caf6be4168ea85d794baf9a5412b4c2','11c83901545e454192a300d427e7ad2c','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-12-18 15:39:16','2020-11-09 15:52:10','admin','','','','','',NULL,'0',NULL,NULL,'0'),('0cba94f0497d4d3d829fc573f58eff9f','402860816bff91c0016bffa220a9000b','graduation_time','毕业时间','graduation_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',16,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('0d00c51a4ddad2598a587fadc968a8b2','402860816bff91c0016bff91cfea0004','sys_org_code','组织机构编码','sys_org_code',0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',13,'admin','2019-07-19 18:05:13','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('0ddd0c0afc967a9ab6050401ca62a4be','e67d26b610dd414c884c4dbb24e71ce3','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2019-04-24 11:03:32','2019-04-24 11:02:57','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('0e5fb96c3f5a37c758eb7f5d1322694f','402880e5721355dd01721355dd390000','good_name','商品名字',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single',NULL,NULL,7,NULL,NULL,'2020-05-14 21:18:14','admin','','','','','','text','0',NULL,NULL,'0'),('0e6952db23d5a578ab74344a299c2322','18f064d1ef424c93ba7a16148851664f','birthday','时间',NULL,0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'single','','',13,'admin','2020-09-11 14:35:44','2020-05-12 20:26:01','admin','','','','','','text','0',NULL,NULL,'0'),('0f4c07621dcd465f7954b4297962db9b','18f064d1ef424c93ba7a16148851664f','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-09-11 14:35:44','2020-05-12 20:26:01','admin','','','','','',NULL,'0',NULL,NULL,'0'),('0f8175a4267a50eaad453d77def3b3c2','dd396a66386745c4993dc5c941c07a2e','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-12-30 15:42:31','2020-11-09 15:35:06','admin','','','','','',NULL,'0',NULL,NULL,'0'),('0f988c94a6d9e5542cd59bd315c93dd2','618957ffac7940ffa8db258799585671','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2021-01-07 20:02:08','2020-11-16 15:43:36','admin','','','','','',NULL,'0',NULL,NULL,'0'),('0fb6fa76c5c78a1e957dbb411e110738','402860816bff91c0016bff91d8830007','politically_status','政治面貌','politically_status',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',7,'admin','2019-07-19 18:04:41','2019-07-17 18:54:37','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('101a73df0aa5199ac05c4ce92a4f0e3e','4adec929a6594108bef5b35ee9966e9f','name','姓名',NULL,0,1,'String',200,0,'','','','','text','',120,NULL,'0','','#{sysUserCode}',0,1,1,0,'single','','',3,'admin','2020-04-10 19:43:38','2020-04-10 19:35:58','admin','','','','','',NULL,'0',NULL,NULL,'0'),('105be0f7d827a0324216cf8af268fb9e','09fd28e4b7184c1a9668496a5c496450','birthday','客户生日',NULL,0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2020-05-14 21:19:21','2020-05-08 23:51:49','admin','','','','','','text','0',NULL,NULL,'0'),('105c8e44ad13026b641f0363601f30f3','e5464aa8fa7b47c580e91593cf9b46dc','num','循环数量',NULL,0,1,'int',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2019-04-24 17:09:49','2019-04-24 11:05:10','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('105e112bddec9cc23e853b9c68af1b05','18f064d1ef424c93ba7a16148851664f','radio','radio',NULL,0,1,'string',32,0,'','sex','','','radio','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2020-09-11 14:35:44','2020-05-12 20:26:01','admin','','','','','','text','0',NULL,NULL,'0'),('109b26d3ca0d8df7bffbd0a3238bc720','6bf0dccd4a2d4dd4b2e0be9ea32a3630','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2021-01-01 22:29:32','2020-11-12 17:18:41','admin','','','','','',NULL,'0',NULL,NULL,'0'),('10b78ee7954f230117689a226c44c0db','402880e570a5d7000170a5d700f50000','descc','描述',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single',NULL,NULL,11,NULL,NULL,'2020-03-04 21:58:16','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('1115e7414a017fc320b28652b353dc44','618957ffac7940ffa8db258799585671','phone_no','Phone No.',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2021-01-07 20:02:08','2020-11-16 15:43:36','admin','','','','','','text','0',NULL,NULL,'0'),('112b8602b955a6e6ed0243d6dd2f5a40','d31c1fde7b9e41e7bec8a108381b5874','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-12-30 14:52:11','2020-11-13 16:06:56','admin','','','','','',NULL,'0',NULL,NULL,'0'),('1130f1e252533529bb1167b896dffe32','deea5a8ec619460c9245ba85dbc59e80','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-05-03 01:01:18','2019-04-20 11:41:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('117af88445945d09ca9965fd64d8d5f2','6a56622058424a0e8bcc8b402ffc949d','company','公司名称',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2020-12-14 14:58:40','2020-11-09 14:35:45','admin','','','','','','text','0',NULL,NULL,'0'),('117fc4ba649d6690a3ac482ad5e4ad38','56870166aba54ebfacb20ba6c770bd73','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-07-20 17:50:49','2019-04-20 11:38:39','admin','','','','','',NULL,'0',NULL,NULL,'0'),('12aa08f8e948e2b60b40a7b6429c866b','56efb74326e74064b60933f6f8af30ea','order_code','订单编码',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','${shop_order_num}',0,1,1,1,'single','','',7,'admin','2020-07-10 16:53:27','2020-05-08 23:45:32','admin','','','','','','text','0',NULL,NULL,'0'),('12c34a64920d909c94055d27793f0938','a3e23181b97e42a0a576df37ef7c68fc','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,NULL,NULL,'2020-12-16 19:31:34','admin','','','','','',NULL,'0',NULL,NULL,'0'),('1312caef0d7ff1e3aa41d44c13c5f970','d31c1fde7b9e41e7bec8a108381b5874','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-12-30 14:52:11','2020-11-13 16:06:56','admin','','','','','',NULL,'0',NULL,NULL,'0'),('13246645b7650491b70205d99703ca06','402860816aa5921f016aa5dedcb90009','bpm_status','流程状态','bpm_status',0,1,'string',32,0,'1','bpm_status','','','text','',120,NULL,'0','','',0,0,1,0,'group','','',8,'admin','2019-05-11 15:56:47','2019-05-11 15:50:08','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('135dd0ee50712722db65b8762bd487ea','8994f2817b5a45d9890aa04497a317c5','update_time','更新日期',NULL,0,1,'date',20,0,'','','','','text','',120,'','0','','',0,1,1,0,'single','','',4,NULL,NULL,'2019-03-23 11:39:16','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('13d9c22ba0a4f09111d115022a148d23','09fd28e4b7184c1a9668496a5c496450','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-05-14 21:19:21','2020-05-08 23:51:49','admin','','','','','',NULL,'0',NULL,NULL,'0'),('14b7e6161d1f908e13026439af302a66','3b5e18da618247539481816995b6bf9f','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-07-11 11:27:29','2020-07-11 11:27:17','admin','','','','','',NULL,'0',NULL,NULL,'0'),('14ec4c83c29966ab42b6b718c5a3e774','7ea60a25fa27470e9080d6a921aabbd1','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,NULL,NULL,'2019-04-17 00:22:21','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('15021687f2a07c56fcb446093bb996f2','11c83901545e454192a300d427e7ad2c','packages','单件装箱数',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',14,'admin','2020-12-18 15:39:16','2020-11-09 15:52:10','admin','','','','','','text','0',NULL,NULL,'0'),('153a3169a0e53100545719cff0b9b456','506c10297a174bf39f4658da3462213b','container_no','货柜号',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2021-01-01 22:30:01','2020-11-12 17:16:04','admin','','','','','','text','0',NULL,NULL,'0'),('154ba4ca5328866010e042086ffc2b81','56efb74326e74064b60933f6f8af30ea','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-07-10 16:53:27','2020-05-08 23:45:32','admin','','','','','',NULL,'0',NULL,NULL,'0'),('15979ab57dc551e8864fc007d1bb3467','dac35da086cb46c29161ea8bb5e07109','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-11-09 15:00:30','2020-11-09 14:59:29','admin','','','','','',NULL,'0',NULL,NULL,'0'),('16363d0bc125125e395772278d0cf22e','4b556f0168f64976a3d20bfb932bc798','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,NULL,NULL,'2019-04-12 23:38:28','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('167ec40ce3e123c8f2072a8827fc0b9a','6bf0dccd4a2d4dd4b2e0be9ea32a3630','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2021-01-01 22:29:32','2020-11-12 17:18:41','admin','','','','','',NULL,'0',NULL,NULL,'0'),('168426cf1016cf0b99705ae1c4c8591e','402880e5721355dd01721355dd390000','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single',NULL,NULL,1,NULL,NULL,'2020-05-14 21:18:14','admin','','','','','',NULL,'0',NULL,NULL,'0'),('16918ac159cb6313fec1dea7ac4bd0a0','402880eb71d52dc30171d52dc3a10000','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single',NULL,NULL,10,NULL,NULL,'2020-05-02 19:37:58','admin','','','','','','text','0',NULL,NULL,'0'),('169318fa19cf5acf77c58a98c2d5a6bf','18f064d1ef424c93ba7a16148851664f','remakr','markdown',NULL,0,1,'Text',0,0,'','','','','markdown','',120,NULL,'0','','',0,1,1,0,'single','','',16,'admin','2020-09-11 14:35:44','2020-05-12 20:26:01','admin','','','','','','text','0',NULL,NULL,'0'),('179c290e383009810fb738f07bd5af8d','402860816bff91c0016bff91d2810005','id','id','id',1,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'group','','',1,'admin','2019-07-19 18:05:55','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('17cbda69da9dd3632625a0647c259070','73162c3b8161413e8ecdca7eb288d0c9','wl_name','物料名字',NULL,0,1,'String',200,0,'','','','','text','',120,NULL,'1','','',0,1,1,0,'single','','',7,'admin','2019-07-01 14:23:32','2019-06-10 15:18:34','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('182d038554a6ee7ddfd07763aaa10686','53a3e82b54b946c2b904f605875a275c','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-05-08 23:42:51','2020-05-07 22:49:47','admin','','','','','',NULL,'0',NULL,NULL,'0'),('1844b016295cece080973f8623d92380','506c10297a174bf39f4658da3462213b','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2021-01-01 22:30:01','2020-11-12 17:16:04','admin','','','','','',NULL,'0',NULL,NULL,'0'),('1860fc6eb31a6c2d1ae92012077bc62f','9d0da12274fb494f922b6135b998721f','name_chs','商品中文名称',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'1','','',1,1,1,0,'single','','',8,'admin','2020-12-14 15:11:36','2020-11-09 15:17:57','admin','','','','','','text','1',NULL,NULL,'1'),('1892b3dd70ee20d96f1e0b3f42358fbb','133b01634f4a411593a94007dca75300','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-12-21 19:00:00','2020-11-13 16:09:31','admin','','','','','',NULL,'0',NULL,NULL,'0'),('18ecdaaebad4bcdba7dc08b46ef6332d','6bf0dccd4a2d4dd4b2e0be9ea32a3630','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2021-01-01 22:29:32','2020-11-12 17:18:41','admin','','','','','',NULL,'0',NULL,NULL,'0'),('18fefb2257901f05508f8ec13ada78a3','e5464aa8fa7b47c580e91593cf9b46dc','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',1,'admin','2019-04-24 17:09:48','2019-04-24 11:05:10','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('1973ef1d3728fbff2db6a352e001f5f7','fb7125a344a649b990c12949945cb6c1','name','用户名',NULL,0,1,'string',32,0,'','','','','text','',120,'','0','','',0,1,1,0,'single','','',5,'admin','2019-03-26 19:24:11','2019-03-26 19:01:52','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('1a432c2fc5f4b56a81e6c022665354ab','e96d84a719654f6e9cc1d73c315b0ccc','weight_total','总重量',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'0','','',0,1,1,1,'single','','',25,'admin','2020-12-16 19:19:09','2020-11-10 09:30:14','admin','','','','','','text','0',NULL,NULL,'0'),('1a4b56bbcc257994fbc76e75ed687a39','e033c8909649408ea5bb53e74f7fec7b','name_chs','商品中文名称',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2020-12-14 17:44:02','2020-11-10 08:36:39','admin','','','','','','text','0',NULL,NULL,'0'),('1a914eae1fda628cc3ee4ad2ca92a7bc','133b01634f4a411593a94007dca75300','money','金额',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',12,'admin','2020-12-21 19:00:00','2020-11-13 16:13:56','admin','','','','','','text','0',NULL,NULL,'0'),('1ab5be1f937f393b3e5cc214ef1b855c','7ea60a25fa27470e9080d6a921aabbd1','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,NULL,NULL,'2019-04-17 00:22:21','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('1b071c02de2830f9fe82a542b31cce7f','3b5e18da618247539481816995b6bf9f','age','年龄',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2020-07-11 11:27:29','2020-07-11 11:27:17','admin','','','','','','text','0',NULL,NULL,'0'),('1b136bcc51869e87d3ff1aa949e6c866','5c58150ab99a4487bc5b4666f762962a','warehouse_name','仓库名称',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2020-12-21 14:14:25','2020-12-21 14:13:31','admin','','','','','','text','0',NULL,NULL,'0'),('1b4b4037f0b1cc3ed4f52eaeddca003b','e96d84a719654f6e9cc1d73c315b0ccc','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-12-16 19:19:09','2020-11-10 09:18:44','admin','','','','','',NULL,'0',NULL,NULL,'0'),('1b6c7b95028bed9ff656d65557dd2bdf','402860816bff91c0016bffa220a9000b','user_id','用户id','user_id',0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',3,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('1b7a604940f59bc0b41e359067d723fe','1952937614c54c54a3653d97c4765cf3','delivery_note_id','id',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','iost_delivery_note','id',16,'admin','2020-12-24 17:26:34','2020-11-16 15:55:37','admin','','','','','','text','0',NULL,NULL,'0'),('1c2f307e315bac77a6d3f02e88387a43','deea5a8ec619460c9245ba85dbc59e80','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',1,'admin','2020-05-03 01:01:18','2019-04-20 11:41:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('1c3b2ad0a52ecb47fa7fd53f25875beb','deea5a8ec619460c9245ba85dbc59e80','price','价格',NULL,0,1,'double',32,0,'','','','','text','',120,'n','0','','',0,1,1,0,'single','','',7,'admin','2020-05-03 01:01:18','2019-04-20 11:41:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('1c4d25a12388c80d397bb4f4664fe4e6','4b556f0168f64976a3d20bfb932bc798','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,NULL,NULL,'2019-04-12 23:38:28','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('1c52232746bf7162bd00dd1cf70353f7','133b01634f4a411593a94007dca75300','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-12-21 19:00:00','2020-11-13 16:09:31','admin','','','','','',NULL,'0',NULL,NULL,'0'),('1c9ac3042f5aaaec6b9b9eee211bbabb','f79dbb25b30c4357a334db84a0e24a55','pic','图片',NULL,0,1,'Text',0,0,'','','','','image','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2021-01-08 11:48:00','2021-01-08 11:15:19','admin','','','','','','text','0',NULL,NULL,'0'),('1c9f04fc7c50161628e79da6b5fc2435','a3c6f1140f7e447eb5bdb26898181fba','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-11-26 16:35:41','2020-11-26 16:17:55','admin','','','','','',NULL,'0',NULL,NULL,'0'),('1cfe967bb457cbaa6e041e45d019b583','402860816bff91c0016bff91c7010001','update_time','更新时间','update_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',10,'admin','2019-07-19 18:07:47','2019-07-17 18:54:32','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('1d0037eba10efd76be45150479399a7e','8d66ea41c7cc4ef9ab3aab9055657fc9','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,NULL,NULL,'2020-05-07 22:46:32','admin','','','','','',NULL,'0',NULL,NULL,'0'),('1d712db19506ee40b2c1ef5a611baf88','53a3e82b54b946c2b904f605875a275c','name','商品名字',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2020-05-08 23:42:51','2020-05-07 22:49:47','admin','','','','','','text','0',NULL,NULL,'0'),('1d78613c77bf7df1cbaf8d9ab3031e85','e033c8909649408ea5bb53e74f7fec7b','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-12-14 17:44:02','2020-11-10 08:36:39','admin','','','','','',NULL,'0',NULL,NULL,'0'),('1d95bdf1120c5a1776df022d0a571f21','4fb8e12a697f4d5bbe9b9fb1e9009486','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',7,'admin','2020-04-10 19:51:27','2020-04-10 19:47:01','admin','','','','','','text','0',NULL,NULL,'0'),('1e37ae77c0d406d4ff3c5442ec63cd1f','8d66ea41c7cc4ef9ab3aab9055657fc9','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,NULL,NULL,'2020-05-07 22:46:32','admin','','','','','',NULL,'0',NULL,NULL,'0'),('1e3d8cfbf12155559666a23ee2c6c5ca','e5464aa8fa7b47c580e91593cf9b46dc','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2019-04-24 17:09:49','2019-04-24 11:05:10','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('1ed46fdeb289bd7805c9b83332ccd3b4','402860816bff91c0016bff91d2810005','relation','关系','relation',0,1,'string',20,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',4,'admin','2019-07-19 18:05:55','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('1eda61dece35abd76b8d8d49e1b139b8','8d66ea41c7cc4ef9ab3aab9055657fc9','content','描述',NULL,0,1,'string',200,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',8,NULL,NULL,'2020-05-07 22:46:32','admin','','','','','','text','0',NULL,NULL,'0'),('1f0c6d33b79713fe79fb30373c81f6f7','758334cb1e7445e2822b60e807aec4a3','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,NULL,NULL,'2019-10-18 18:02:09','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('1fa5f07b3e70d4925b69b2bf51309421','56870166aba54ebfacb20ba6c770bd73','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-07-20 17:50:49','2019-04-20 11:38:39','admin','','','','','',NULL,'0',NULL,NULL,'0'),('209ddb923d8dab9f454d56d82c0cc725','3d447fa919b64f6883a834036c14aa67','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-02-21 17:58:46','2020-02-20 16:19:00','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('20cb86eb515e539f18a1c1fe5d18228a','1952937614c54c54a3653d97c4765cf3','height','Height',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',11,'admin','2020-12-24 17:26:34','2020-12-24 17:24:37','admin','','','','','','text','0',NULL,NULL,'0'),('20ef1e21d9804107452414393671a63f','133b01634f4a411593a94007dca75300','serial_number','序列号',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2020-12-21 19:00:00','2020-11-13 16:13:56','admin','','','','','','text','0',NULL,NULL,'0'),('20ff34fb0466089cb633d73d5a6f08d6','d35109c3632c4952a19ecc094943dd71','update_time','更新日期',NULL,0,1,'date',20,0,'','','','','text','',120,'','0','','',0,0,0,0,'single','','',5,'admin','2020-07-17 15:22:04','2019-03-15 14:24:35','admin','','','','','',NULL,'0',NULL,NULL,'0'),('2113a4ec7b88b4820dcbbdf96e46bbb7','fbc35f067da94a70adb622ddba259352','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,NULL,NULL,'2019-07-03 19:44:23','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('2150e48b2cb6072d2d8ecd79a7daf7cc','402860816bff91c0016bff91ca7e0002','create_time','创建时间','create_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',10,'admin','2019-07-19 18:07:13','2019-07-17 18:54:33','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('2174610939222cb2a42fb864b1764fef','11c83901545e454192a300d427e7ad2c','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-12-18 15:39:16','2020-11-09 15:52:10','admin','','','','','',NULL,'0',NULL,NULL,'0'),('2213b84d562d57a6bda5a1d2c375547b','6a56622058424a0e8bcc8b402ffc949d','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-12-14 14:58:40','2020-11-09 14:35:45','admin','','','','','',NULL,'0',NULL,NULL,'0'),('2323239efb5a40b73034411868dfc41d','fb19fb067cd841f9ae93d4eb3b883dc0','update_by','更新人登录名称',NULL,0,1,'string',50,0,'','','','','text','',120,'','0','','',0,1,1,0,'single','','',3,NULL,NULL,'2019-03-23 11:39:48','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('23f42061ed218bdbc1262913c071e1cd','e5464aa8fa7b47c580e91593cf9b46dc','iz_valid','启动状态',NULL,0,1,'int',2,0,'','air_china_valid','','','list','',120,NULL,'0','','',0,1,1,0,'single','','',12,'admin','2019-04-24 17:09:49','2019-04-24 14:09:06','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('2405bf5fc03684db31928be20cfa37cd','f3071ca217274b6892238c4b60e1f177','volume','体积',NULL,0,1,'double',10,3,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2020-12-21 14:49:28','2020-11-16 10:39:30','admin','','','','','','text','0',NULL,NULL,'0'),('242cc59b23965a92161eca69ffdbf018','d35109c3632c4952a19ecc094943dd71','age','年龄',NULL,0,1,'int',32,0,'','','','','text','http://www.baidu.com',120,'','0','','',0,1,1,0,'single','','',8,'admin','2020-07-17 15:22:04','2019-03-15 14:24:35','admin','','','','','',NULL,'0',NULL,NULL,'0'),('24588340313096179b9ec0b49f40bed3','18f064d1ef424c93ba7a16148851664f','sel_mut','下拉多选',NULL,0,1,'string',32,0,'','sex','','','list_multi','',120,NULL,'0','','',0,1,1,0,'single','','',11,'admin','2020-09-11 14:35:44','2020-05-12 20:26:01','admin','','','','','','text','0',NULL,NULL,'0'),('2640235b9638547f1776b930bd8c12b4','997ee931515a4620bc30a9c1246429a9','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-05-03 00:57:44','2020-05-03 00:56:56','admin','','','','','',NULL,'0',NULL,NULL,'0'),('26510c1c0f0858cfa2b7edde858d3650','133b01634f4a411593a94007dca75300','deliver_status','送货状态',NULL,0,1,'string',32,0,'','delivery_status','','','list','',120,NULL,'0','','',0,1,1,0,'single','','',14,'admin','2020-12-21 19:00:00','2020-11-13 16:26:57','admin','','','','','','text','0',NULL,NULL,'0'),('265702edb8872e322fe72d3640e34ac5','402860816bff91c0016bff91cfea0004','from_time','开始日期','from_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',3,'admin','2019-07-19 18:05:13','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('26645f6f6eb2646033bad11e0402d7e4','18f064d1ef424c93ba7a16148851664f','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-09-11 14:35:44','2020-05-12 20:26:01','admin','','','','','',NULL,'0',NULL,NULL,'0'),('272489de2e73454324d5096efe92bab3','6bf0dccd4a2d4dd4b2e0be9ea32a3630','date','日期',NULL,0,1,'Date',0,0,'','','','','date','',300,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2021-01-01 22:29:32','2020-11-12 17:18:41','admin','','','','','','text','0',NULL,NULL,'0'),('2739ab1ece4d6053ba931bb6572f4ed8','4028839a6de2ebd3016de2ebd3870000','iz_valid','启用状态','iz_valid',0,1,'string',2,0,NULL,NULL,NULL,NULL,'text',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,9,NULL,NULL,'2019-10-19 15:29:30','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('273b0fd37640a9ef1614e987e2bc44a0','8d66ea41c7cc4ef9ab3aab9055657fc9','pics','图片',NULL,0,1,'string',500,0,'','','','','image','',120,NULL,'0','','',0,1,1,0,'single','','',9,NULL,NULL,'2020-05-07 22:46:32','admin','','','','','','text','0',NULL,NULL,'0'),('281ce0b5343cd42b28825d7df16422f1','b81de38db24047b497d476516f8a0865','vv','vv',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',8,NULL,NULL,'2020-02-24 14:56:08','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('283f42283b9d0bf3b95ba3384ab2d255','758334cb1e7445e2822b60e807aec4a3','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,NULL,NULL,'2019-10-18 18:02:09','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('284864d99fddfdcb00e188e3a512cb28','1acb6f81a1d9439da6cc4e868617b565','no','预算表序号',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',10,'admin','2019-06-10 14:47:14','2019-04-23 22:58:19','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('2889d3cef706f91e092d76a56b8055be','402860816bff91c0016bff91cda80003','order_no','序号','order_no',0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',8,'admin','2019-07-19 18:06:36','2019-07-17 18:54:34','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('297ef5ad4645f9b6d080f3bdb7ec266b','f70eb6fe0df74c5eb04552f5c1a4b7b3','cases','件数',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',10,'admin','2020-12-16 20:11:33','2020-12-16 19:34:19','admin','','','','','','text','0',NULL,NULL,'0'),('29b1918b829cb1784068c86d0264271b','5c58150ab99a4487bc5b4666f762962a','packages_total','总装箱数',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',11,'admin','2020-12-21 14:14:25','2020-11-13 15:35:09','admin','','','','','','text','0',NULL,NULL,'0'),('29e4abea55d9fa7dbbd0c8dbbb2b3756','402860816bff91c0016bff91cda80003','update_time','更新时间','update_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',12,'admin','2019-07-19 18:06:36','2019-07-17 18:54:34','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('2a66e93fb27341adaabd4b97cad59fdc','d7b42c2262774ded8de4ab7dea6463a9','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-12-26 00:27:15','2020-11-16 10:35:13','admin','','','','','',NULL,'0',NULL,NULL,'0'),('2a76c3a0183d34d48dc0c3fb571f35ae','ca4136acdc61484c94913ba54c2ecaa8','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-11-16 15:27:24','2020-11-16 15:24:54','admin','','','','','',NULL,'0',NULL,NULL,'0'),('2aef31179964d0a5a945df7bddff00ae','53a3e82b54b946c2b904f605875a275c','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-05-08 23:42:51','2020-05-07 22:49:47','admin','','','','','',NULL,'0',NULL,NULL,'0'),('2b27207c7fb85edba519fb56846f9ee9','2f03eb34ce95467e8a7f1388d49c18c8','container_no','货柜号',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'1','','',1,1,1,0,'single','','',9,'admin','2021-01-07 21:29:54','2020-11-10 09:00:36','admin','','','','','','text','1',NULL,NULL,'0'),('2bff9eef5c0a0519dd04caf0c4a32ab2','133b01634f4a411593a94007dca75300','packages','箱数',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',11,'admin','2020-12-21 19:00:00','2020-11-13 16:13:56','admin','','','','','','text','0',NULL,NULL,'0'),('2c005d9bdaef54a02d3d9a0b7a3fa294','f70eb6fe0df74c5eb04552f5c1a4b7b3','receiving_copy_id','入仓id',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','iost_receiving_copy','id',21,'admin','2020-12-16 20:11:33','2020-12-16 20:09:34','admin','','','','','','text','0',NULL,NULL,'0'),('2c1fff3f7655e66290e88a9ce36cbb59','a3e23181b97e42a0a576df37ef7c68fc','receiving_no','入仓号',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,NULL,NULL,'2020-12-16 19:31:34','admin','','','','','','text','0',NULL,NULL,'0'),('2c70edc7d5a9861239c6537ae0eb39c7','18f064d1ef424c93ba7a16148851664f','dep_sel','选择部门',NULL,0,1,'string',200,0,'','','','','sel_depart','',120,NULL,'0','','#{sysOrgCode}',0,1,1,0,'single','','',19,'admin','2020-09-11 14:35:44','2020-05-12 20:26:01','admin','','','','','','text','0',NULL,NULL,'0'),('2c9be627e7cab7f5a2ae9c7ca7ce94a2','cb2d8534a2f544bc9c618dd49da66336','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-02-24 17:22:42','2020-02-24 15:15:14','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('2d53a66f0b72d820b86ff445e2181d76','beee191324fd40c1afec4fda18bd9d47','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',1,'admin','2019-04-13 13:41:13','2019-04-13 13:40:56','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('2db5cafa588368283d9069f203aa0a0f','f70eb6fe0df74c5eb04552f5c1a4b7b3','length','长（厘米）',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',13,'admin','2020-12-16 20:11:33','2020-12-16 20:08:14','admin','','','','','','text','0',NULL,NULL,'0'),('2dfc4c81926f678c5f8d5ffd27858201','e2faf977fdaf4b25a524f58c2441a51c','account','用户编码',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2019-06-10 17:27:00','2019-04-24 17:12:11','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('2e0374878fb3d5be3b0b3f868a97fb59','09fd28e4b7184c1a9668496a5c496450','sex','客户性别',NULL,0,1,'string',1,0,'','sex','','','list','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2020-05-14 21:19:21','2020-05-08 23:51:49','admin','','','','','','text','0',NULL,NULL,'0'),('2e5275b6407e1b4265af8519077fa4a5','d3ae1c692b9640e0a091f8c46e17bb01','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,NULL,NULL,'2019-07-24 14:47:30','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('2e66b9db37648389e0846e2204111732','73162c3b8161413e8ecdca7eb288d0c9','has_child','是否有子节点',NULL,0,1,'string',3,0,'','valid_status','','','list','',120,NULL,'0','','',0,0,0,0,'single','','',10,'admin','2019-07-01 14:23:32','2019-06-10 15:18:34','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('2e6740e79d51ac935d673b7d207611d2','18f064d1ef424c93ba7a16148851664f','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-09-11 14:35:44','2020-05-12 20:26:01','admin','','','','','',NULL,'0',NULL,NULL,'0'),('2e6f741fa96a49a0adccc7b4682c1cef','4fb8e12a697f4d5bbe9b9fb1e9009486','name','名称',NULL,0,1,'String',200,0,'','','','','text','',120,NULL,'0','','#{sysUserName}',0,1,1,0,'single','','',3,'admin','2020-04-10 19:51:27','2020-04-10 19:47:01','admin','','','','','',NULL,'0',NULL,NULL,'0'),('2e728ad16a880bc75506a29a207fe4f4','11c83901545e454192a300d427e7ad2c','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-12-18 15:39:16','2020-11-09 15:52:10','admin','','','','','',NULL,'0',NULL,NULL,'0'),('2ea889f9dde22aba10d8dbd0274402f9','ca4136acdc61484c94913ba54c2ecaa8','name','商品名称',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2020-11-16 15:27:24','2020-11-16 15:24:54','admin','','','','','','text','0',NULL,NULL,'0'),('2ee58d8e4844dfe1fa6b1b841ae0b312','402860816bff91c0016bff91d2810005','politically_status','政治面貌','politically_status',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',7,'admin','2019-07-19 18:05:55','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('2ef33b5b8f198518e98884f2fdd2a787','dac35da086cb46c29161ea8bb5e07109','customer_id','客户id',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','iost_customer','id',9,'admin','2020-11-09 15:00:30','2020-11-09 14:59:29','admin','','','','','','text','0',NULL,NULL,'0'),('2f111722eb3a994450e67e3211fd69a8','402860816bff91c0016bff91ca7e0002','id','id','id',1,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'group','','',1,'admin','2019-07-19 18:07:13','2019-07-17 18:54:33','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('2fb0eaa84bf4afa69ffe89caff0950c1','618957ffac7940ffa8db258799585671','address','Address',NULL,0,1,'string',300,0,'','','','','textarea','',120,NULL,'0','','',0,1,1,0,'single','','',11,'admin','2021-01-07 20:02:09','2020-11-16 15:43:36','admin','','','','','','text','0',NULL,NULL,'0'),('30143cc3de69c413828f9fba20662026','402860816bff91c0016bffa220a9000b','healthy','健康状况','healthy',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',12,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('3087aa8f38c787e066a886d950a9edfa','05a3a30dada7411c9109306aa4117068','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-05-12 22:39:41','2020-05-06 11:34:31','admin','','','','','',NULL,'0',NULL,NULL,'0'),('3093932e0c7f15faf099e82ab92cedde','d7b42c2262774ded8de4ab7dea6463a9','telephone','联系电话',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2020-12-26 00:27:15','2020-11-16 10:35:13','admin','','','','','','text','0',NULL,NULL,'0'),('30e7a288a00bc58f64ea9cc487b91452','e96d84a719654f6e9cc1d73c315b0ccc','height','高',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,1,'single','','',21,'admin','2020-12-16 19:19:09','2020-11-10 09:28:24','admin','','','','','','text','0',NULL,NULL,'0'),('31193dc8ceacf979e4042e784ea8278a','402880e570a5d7000170a5d700f50000','order_fk_id','订单外键ID',NULL,0,0,'String',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single',NULL,NULL,10,NULL,NULL,'2020-03-04 21:58:16','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('315eab14c7d9de37434b3cb7fa7b054d','18f064d1ef424c93ba7a16148851664f','files','文件',NULL,0,1,'string',1000,0,'','','','','file','',120,NULL,'0','','',0,1,1,0,'single','','',15,'admin','2020-09-11 14:35:44','2020-05-12 20:26:01','admin','','','','','','text','0',NULL,NULL,'0'),('31fd90306c3942f09cb79deabbf2f541','402860816bff91c0016bff91d2810005','employee_id','员工ID','employee_id',0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','oa_employee_info','id',2,'admin','2019-07-19 18:05:55','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('3227591d271d72d5483db2d29cad9d99','9d0da12274fb494f922b6135b998721f','price','价格',NULL,0,1,'double',10,3,'','','','','text','',120,NULL,'1','','',0,1,1,0,'single','','',10,'admin','2020-12-14 15:11:36','2020-11-09 15:17:57','admin','','','','','','text','0',NULL,NULL,'1'),('32e9ab94f5d78a43dcca7a0cb4d9e173','e96d84a719654f6e9cc1d73c315b0ccc','width','宽',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,1,'single','','',20,'admin','2020-12-16 19:19:09','2020-11-10 09:28:24','admin','','','','','','text','0',NULL,NULL,'0'),('336495117e3a31351fed6963b950dddb','402860816bff91c0016bffa220a9000b','inside_transfer','内部工作调动情况','inside_transfer',0,1,'string',255,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',37,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('33c61dd802153408d3b13b729665df5f','f79dbb25b30c4357a334db84a0e24a55','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2021-01-08 11:48:00','2021-01-08 11:15:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('33d6a18aa9085c7b755657dc792d539d','1952937614c54c54a3653d97c4765cf3','cbm','CBM',NULL,0,1,'double',10,3,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',13,'admin','2020-12-24 17:26:34','2020-11-16 15:53:19','admin','','','','','','text','0',NULL,NULL,'0'),('34138092d743d4232341a920efd2699e','402880eb71d52dc30171d52dc3a10000','name','名称',NULL,0,1,'String',200,0,'','','','','text','',120,NULL,'0','','#{sysUserName}',0,1,1,0,'single',NULL,NULL,3,NULL,NULL,'2020-05-02 19:37:58','admin','','','','','',NULL,'0',NULL,NULL,'0'),('3425045bf81c47590e83689f60865f7e','f79dbb25b30c4357a334db84a0e24a55','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2021-01-08 11:48:00','2021-01-08 11:15:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('345c8b48e1e128e77c4c6e2b36512804','402860816aa5921f016aa5dedcb90009','create_by','创建人','create_by',0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'group','','',2,'admin','2019-05-11 15:56:47','2019-05-11 15:50:08','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('34625a911b39e0596690c1a15f784448','402880e570a5d7000170a5d700f50000','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single',NULL,NULL,5,NULL,NULL,'2020-03-04 21:58:16','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('3489a6451bbbcabc0f39ca04b0dd62f2','8d66ea41c7cc4ef9ab3aab9055657fc9','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,NULL,NULL,'2020-05-07 22:46:32','admin','','','','','',NULL,'0',NULL,NULL,'0'),('350dd81042ccea6b9f49da2b1b49f763','11c83901545e454192a300d427e7ad2c','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-12-18 15:39:16','2020-11-09 15:52:10','admin','','','','','',NULL,'0',NULL,NULL,'0'),('351faaeb2dd8105e9c66f678211c9d4f','dbf4675875e14676a3f9a8b2b8941140','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,NULL,NULL,'2019-05-27 18:02:07','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('35417ba3993afe3405e1e0b9abbd7e1b','402880e5721355dd01721355dd390000','num','数量',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single',NULL,NULL,9,NULL,NULL,'2020-05-14 21:18:14','admin','','','','','','text','0',NULL,NULL,'0'),('354b2ce39c5e8ec3f0bbb01bf8ff0fb7','32f75e4043ef4070919dbd4337186a3d','content','描述',NULL,0,1,'String',300,0,'','','','','textarea','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2019-04-11 10:15:31','2019-03-28 15:24:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('35b98bddf5965b5564976b44f9631bf2','e96d84a719654f6e9cc1d73c315b0ccc','money','金额',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'0','','',0,1,1,1,'single','','',28,'admin','2020-12-16 19:19:09','2020-11-10 09:30:14','admin','','','','','','text','0',NULL,NULL,'0'),('35ca1c8aa1501bc8a79c880928841f18','402860816aa5921f016aa5921f480000','update_by','修改人id','update_by',0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'group','','',11,'admin','2019-05-11 15:31:55','2019-05-11 14:26:19','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('360ca6d0aec40027a2be0f1c6c3dd739','f70eb6fe0df74c5eb04552f5c1a4b7b3','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-12-16 20:11:33','2020-12-16 19:34:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('3635793767371c6db9f76b4b79f9d321','402860816bff91c0016bff91d8830007','create_time','创建时间','create_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',11,'admin','2019-07-19 18:04:41','2019-07-17 18:54:37','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('368479637baf5e980d944bbec0c873f5','11c83901545e454192a300d427e7ad2c','receiving_id','入仓id',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','iost_receiving','id',26,'admin','2020-12-18 15:39:16','2020-11-09 15:53:26','admin','','','','','','text','0',NULL,NULL,'0'),('370a6eebc2d732eaf121fe0830d853a6','e5464aa8fa7b47c580e91593cf9b46dc','wl_code','物料编码',NULL,0,1,'String',100,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',7,'admin','2019-04-24 17:09:49','2019-04-24 11:05:10','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('37462a4d78968d0e432d746423603b81','3d447fa919b64f6883a834036c14aa67','province','省份',NULL,0,1,'String',100,0,'','','{table:\'sys_category\',txt:\'name\',key:\'id\',linkField:\'city,area\',idField:\'id\',pidField:\'pid\', condition:\" pid = \'1230769196661510146\' \"         }','','link_down','',120,NULL,'0','','',0,1,1,0,'single','','',2,'admin','2020-02-21 17:58:46','2020-02-20 16:19:00','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('37e2548874f09ef7d08642a30bc918fa','fbc35f067da94a70adb622ddba259352','group_name','小组名',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,NULL,NULL,'2019-07-03 19:44:23','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('381d0ab577ee85813ff6e85734921bd2','d31c1fde7b9e41e7bec8a108381b5874','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-12-30 14:52:11','2020-11-13 16:06:56','admin','','','','','',NULL,'0',NULL,NULL,'0'),('38394ed19159b6608d89ba819a4a8b85','f70eb6fe0df74c5eb04552f5c1a4b7b3','volume_total','总体积',NULL,0,1,'double',10,3,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',16,'admin','2020-12-16 20:11:33','2020-12-16 20:08:14','admin','','','','','','text','0',NULL,NULL,'0'),('38b23f554c7f7016659e62e75065fffe','e033c8909649408ea5bb53e74f7fec7b','customer_name','客户中文姓名',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',23,'admin','2020-12-14 17:44:02','2020-11-10 08:40:30','admin','','','','','','text','0',NULL,NULL,'0'),('38e94f5977ffaa5bf31c7c1ffa2e2210','e96d84a719654f6e9cc1d73c315b0ccc','customer_name','客户中文名称',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,1,'single','','',8,'admin','2020-12-16 19:19:09','2020-11-10 09:18:44','admin','','','','','','text','0',NULL,NULL,'0'),('391e7cbd9f29743b11bb555c50547b1f','32f75e4043ef4070919dbd4337186a3d','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2019-04-11 10:15:32','2019-03-27 15:54:49','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('396c36fa5320975851d06772d10ea7b1','cb2d8534a2f544bc9c618dd49da66336','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-02-24 17:22:42','2020-02-24 15:15:14','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('398cf2234bfaed379e143f0c24d9eb76','dac35da086cb46c29161ea8bb5e07109','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-11-09 15:00:30','2020-11-09 14:59:29','admin','','','','','',NULL,'0',NULL,NULL,'0'),('39b936dcfdb82702a263f7cc8b8ff8c1','d31c1fde7b9e41e7bec8a108381b5874','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-12-30 14:52:11','2020-11-13 16:06:56','admin','','','','','',NULL,'0',NULL,NULL,'0'),('39fa3aa193e42849352466f6dbef5caa','2f03eb34ce95467e8a7f1388d49c18c8','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2021-01-07 21:29:54','2020-11-10 09:00:36','admin','','','','','',NULL,'0',NULL,NULL,'0'),('3a201035cf0f03aac0133ed1535f5c67','f70eb6fe0df74c5eb04552f5c1a4b7b3','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-12-16 20:11:33','2020-12-16 19:34:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('3ab30959fd9ac25aec6d1bacd9ec6f80','6a56622058424a0e8bcc8b402ffc949d','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-12-14 14:58:40','2020-11-09 14:35:45','admin','','','','','',NULL,'0',NULL,NULL,'0'),('3b439859f98e30e34d25e983eb22e408','402860816bff91c0016bff91c7010001','award_time','获奖时间','award_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',3,'admin','2019-07-19 18:07:47','2019-07-17 18:54:32','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('3b491fe584497057884fa684d6f333ae','1952937614c54c54a3653d97c4765cf3','dimensions','Dimensions',NULL,0,1,'double',10,3,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',12,'admin','2020-12-24 17:26:34','2020-11-16 15:53:19','admin','','','','','','text','0',NULL,NULL,'0'),('3bf44e68de518f3ddf72b87671d0ff90','8994f2817b5a45d9890aa04497a317c5','update_by','更新人登录名称',NULL,0,1,'string',50,0,'','','','','text','',120,'','0','','',0,1,1,0,'single','','',3,NULL,NULL,'2019-03-23 11:39:16','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('3c281a45b8eed64b91016e4ae6dc3341','a3e23181b97e42a0a576df37ef7c68fc','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,NULL,NULL,'2020-12-16 19:31:34','admin','','','','','',NULL,'0',NULL,NULL,'0'),('3c3dac57c1d56eff77d986dcc1b1973b','f3071ca217274b6892238c4b60e1f177','price','价格',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',12,'admin','2020-12-21 14:49:28','2020-11-16 10:39:30','admin','','','','','','text','0',NULL,NULL,'0'),('3cd2061ea15ce9eeb4b7cf2e544ccb6b','d35109c3632c4952a19ecc094943dd71','file_kk','附件',NULL,0,1,'String',500,0,'','','','','file','',120,NULL,'0','','',0,1,1,0,'single','','',13,'admin','2020-07-17 15:22:04','2019-06-10 20:06:57','admin','','','','','',NULL,'0',NULL,NULL,'0'),('3cde127f2bfaa1d83fe8c702a2fb8c00','f70eb6fe0df74c5eb04552f5c1a4b7b3','money','金额',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',20,'admin','2020-12-16 20:11:33','2020-12-16 20:08:14','admin','','','','','','text','0',NULL,NULL,'0'),('3cfd4d60c7d8409ae716a579bcb0910d','402860816bff91c0016bff91c0cb0000','sys_org_code','组织机构编码','sys_org_code',0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',16,'admin','2019-07-19 18:09:01','2019-07-17 18:54:32','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('3d360f823534ba2399034aae6f756fe7','61328d3127024a9b99298eded991106c','cases_total','总件数',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2020-12-26 18:13:52','2020-11-10 08:19:09','admin','','','','','','text','0',NULL,NULL,'0'),('3e0354b439b8167ce61bd87eb621b146','d31c1fde7b9e41e7bec8a108381b5874','loading_date','装柜日期',NULL,0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'single','','',10,'admin','2020-12-30 14:52:11','2020-11-13 16:06:56','admin','','','','','','text','0',NULL,NULL,'0'),('3e32f6c30c9028872388f70743c5d6a5','402860816bff91c0016bff91c0cb0000','reason','申请理由','reason',0,1,'string',200,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',9,'admin','2019-07-19 18:09:01','2019-07-17 18:54:32','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('3e70d1c516c3533c6698300665c669e1','402860816bff91c0016bff91c0cb0000','id','id','id',1,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'group','','',1,'admin','2019-07-19 18:09:01','2019-07-17 18:54:31','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('3ef0a9ed04605267f7fa304a8c353576','05a3a30dada7411c9109306aa4117068','name','用户名',NULL,0,1,'string',32,0,'','username','tj_user_report','name','popup','',120,NULL,'0','','',1,1,1,0,'single','','',7,'admin','2020-05-12 22:39:41','2020-05-06 11:34:31','admin','','','','','','text','0',NULL,NULL,'1'),('3eff1d21b946e23d7f83de977962d9cf','402880eb71d61d3d0171d61d3de30000','main_id','主表ID',NULL,0,1,'String',200,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-05-03 00:54:16','2020-05-02 23:59:33','admin','','','','','',NULL,'0',NULL,NULL,'0'),('3f2ace8f968a0e5b91d1340ee2957cda','402860816bff91c0016bff91d8830007','real_name','姓名','real_name',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',3,'admin','2019-07-19 18:04:41','2019-07-17 18:54:37','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('3f7f7720ee65648cb2850fccedf7be9d','53a3e82b54b946c2b904f605875a275c','contents','商品简介',NULL,0,1,'Text',0,0,'','','','','umeditor','',120,NULL,'0','','',0,1,1,0,'single','','',10,'admin','2020-05-08 23:42:51','2020-05-07 22:49:47','admin','','','','','','text','0',NULL,NULL,'0'),('3f9deca6c193f0b2609113713956ad19','86bf17839a904636b7ed96201b2fa6ea','order_main_id','订单ID',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','ces_order_main','id',11,'admin','2020-05-14 21:18:49','2020-05-08 23:48:31','admin','','','','','','text','0',NULL,NULL,'0'),('3fce79a9ef997507796c0f687d687567','f79dbb25b30c4357a334db84a0e24a55','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2021-01-08 11:48:00','2021-01-08 11:15:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('40471eb4560bf0bbd2ffef17d48a269d','dbf4675875e14676a3f9a8b2b8941140','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,NULL,NULL,'2019-05-27 18:02:07','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('404b516d4f2229f292783db595b02ba1','402860816bff91c0016bff91d8830007','update_time','更新时间','update_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',13,'admin','2019-07-19 18:04:41','2019-07-17 18:54:37','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('405de5ea82e54138a0613dd41b006dfb','56870166aba54ebfacb20ba6c770bd73','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-07-20 17:50:49','2019-04-20 11:38:39','admin','','','','','',NULL,'0',NULL,NULL,'0'),('40600e93f70c6ce45f2dc702a1b0f8ce','a3c6f1140f7e447eb5bdb26898181fba','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-11-26 16:35:41','2020-11-26 16:17:55','admin','','','','','',NULL,'0',NULL,NULL,'0'),('40675bb9f053aabf8823ddf4b5389141','b81de38db24047b497d476516f8a0865','aa','aa',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,NULL,NULL,'2020-02-24 14:56:08','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('40b62b2fbdfa579d78f0301c154f3376','1952937614c54c54a3653d97c4765cf3','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-12-24 17:26:34','2020-11-16 15:53:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('4164314d6a51d100169a29872b7504d8','402860816bff91c0016bff91ca7e0002','cert_time','发证时间','cert_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',3,'admin','2019-07-19 18:07:13','2019-07-17 18:54:33','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('41a35d40e584f95885ac2ffb518b9607','e96d84a719654f6e9cc1d73c315b0ccc','kind','商品类别',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,1,'single','','',9,'admin','2020-12-16 19:19:09','2020-11-10 09:18:44','admin','','','','','','text','0',NULL,NULL,'0'),('41a6bc0f8c812a55f279d807f93b88f9','ca4136acdc61484c94913ba54c2ecaa8','receiving_no','入仓号',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',13,'admin','2020-11-16 15:27:24','2020-11-16 15:24:54','admin','','','','','','text','0',NULL,NULL,'0'),('41d4215c01b0d26871f2cb83d3e532ae','402860816bff91c0016bff91c0cb0000','bpm_status','流程状态',NULL,0,1,'String',32,0,'1','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',17,'admin','2019-07-19 18:09:01','2019-07-19 15:35:23','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('422a44a15fa39fd57c3c23eb601f7c03','56870166aba54ebfacb20ba6c770bd73','descc','描述',NULL,0,1,'String',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2020-07-20 17:50:49','2019-04-20 11:38:39','admin','','','','','',NULL,'0',NULL,NULL,'0'),('42945fcaa661f8eab63da41e7ed26fe7','11c83901545e454192a300d427e7ad2c','kind','商品类别',NULL,0,1,'string',32,0,'','code','iost_kind','name','sel_search','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2020-12-18 15:39:16','2020-11-09 15:52:10','admin','','','','','','text','0',NULL,NULL,'0'),('42cccfa014c9e131a0a1b23f563d3688','402860816bff91c0016bffa220a9000b','sex','性别','sex',0,1,'string',20,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',6,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('4312f618c83e07db82e468b81a1eaa45','402860816bff91c0016bffa220a9000b','photo','照片','photo',0,1,'string',255,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',20,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('432ca79c60a68bfb008138da17ff3b98','dd396a66386745c4993dc5c941c07a2e','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-12-30 15:42:30','2020-11-09 15:35:06','admin','','','','','',NULL,'0',NULL,NULL,'0'),('435b57180fc995e3c4ec42516963bca3','4028839a6de2ebd3016de2ebd3870000','wl_code','物料编码','wl_code',0,1,'string',60,0,NULL,NULL,NULL,NULL,'text',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,6,NULL,NULL,'2019-10-19 15:29:30','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('44bdc595f1e565fc053e01134b92bb47','d3ae1c692b9640e0a091f8c46e17bb01','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,NULL,NULL,'2019-07-24 14:47:30','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('44e81e24d2384b0f187e8f69eda55390','402860816bff91c0016bff91cda80003','create_time','创建时间','create_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',10,'admin','2019-07-19 18:06:36','2019-07-17 18:54:34','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('4538acb32a5048f4de01161d89c4dec6','d31c1fde7b9e41e7bec8a108381b5874','container_no','货柜号',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2020-12-30 14:52:11','2020-11-13 16:06:56','admin','','','','','','text','0',NULL,NULL,'0'),('45981d39534d4bff743eb7f8b28775b4','11c83901545e454192a300d427e7ad2c','ref_cases','关联件数',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',27,'admin','2020-12-18 15:39:16','2020-12-07 20:33:56','admin','','','','','','text','0',NULL,NULL,'0'),('45c0a1a89a1e2a72533b9af894be1011','27fc5f91274344afa7673a732b279939','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2019-07-01 16:28:20','2019-07-01 16:26:42','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('45d59eb647257fcbcb9d143ff1ba2080','deea5a8ec619460c9245ba85dbc59e80','pro_type','产品类型',NULL,0,1,'String',32,0,'','sex','','','radio','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2020-05-03 01:01:18','2019-04-23 20:54:08','admin','','','','','',NULL,'0',NULL,NULL,'0'),('465d15157beed89d8875ddb6ad6bc72e','f3071ca217274b6892238c4b60e1f177','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-12-21 14:49:28','2020-11-16 10:39:30','admin','','','','','',NULL,'0',NULL,NULL,'0'),('46653145ef46582fd37c6737d592fd74','506c10297a174bf39f4658da3462213b','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2021-01-01 22:30:01','2020-11-12 17:16:04','admin','','','','','',NULL,'0',NULL,NULL,'0'),('468932a7c5486be4176e344b1df2fc88','d7b42c2262774ded8de4ab7dea6463a9','delivery_address','送货地址',NULL,0,1,'string',300,0,'','','','','textarea','',120,NULL,'0','','',0,1,1,0,'single','','',10,'admin','2020-12-26 00:27:15','2020-11-16 10:35:13','admin','','','','','','text','0',NULL,NULL,'0'),('469b250595f15dfebe69991d72e4bfb2','e9faf717024b4aae95cff224ae9b6d97','name','员工姓名',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',6,'admin','2019-07-03 18:23:49','2019-07-03 18:22:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('46be01bef342519e268902d0d36a7473','deea5a8ec619460c9245ba85dbc59e80','descc','描述',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',11,'admin','2020-05-03 01:01:18','2019-04-20 11:41:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('46e4a49a224a39c46eca0c763af13b44','dd396a66386745c4993dc5c941c07a2e','delivery_man','送货人',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'1','','',0,1,1,0,'single','','',11,'admin','2020-12-30 15:42:31','2020-11-09 15:35:06','admin','','','','','','text','0',NULL,NULL,'0'),('46f1a875f86a4f48d0540ad0d5e667d7','56870166aba54ebfacb20ba6c770bd73','order_date','下单时间',NULL,0,1,'Date',32,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2020-07-20 17:50:49','2019-04-20 11:38:39','admin','','','','','',NULL,'0',NULL,NULL,'0'),('47c21a6b45e59a6b70bb9c0cc4510a68','1acb6f81a1d9439da6cc4e868617b565','integral_val','积分值',NULL,0,1,'int',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',13,'admin','2019-06-10 14:47:14','2019-04-23 22:58:19','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('47d14cfffb238147fad978a870724ea0','9d0da12274fb494f922b6135b998721f','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-12-14 15:11:36','2020-11-09 15:17:57','admin','','','','','',NULL,'0',NULL,NULL,'0'),('47fa05530f3537a1be8f9e7a9e98be82','d35109c3632c4952a19ecc094943dd71','sex','性别',NULL,0,1,'string',32,0,'','sex','','','list','',120,'','0','','',0,1,1,0,'single','','',7,'admin','2020-07-17 15:22:04','2019-03-15 14:24:35','admin','','','','','',NULL,'0',NULL,NULL,'1'),('481336cde67bb47dee410895e66694e8','d7b42c2262774ded8de4ab7dea6463a9','receiving_no','入仓号',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2020-12-26 00:27:15','2020-12-21 14:45:43','admin','','','','','','text','0',NULL,NULL,'0'),('4851697fdf63709d2bc7451b7415f4af','32f75e4043ef4070919dbd4337186a3d','sex','性别',NULL,0,1,'String',32,0,'1','sex','','','list','',120,NULL,'0','','',1,1,1,0,'single','','',6,'admin','2019-04-11 10:15:32','2019-03-27 15:54:49','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('485a8ddce2c033f88af674ec98b68e32','402860816bff91c0016bffa220a9000b','create_time','创建时间','create_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',40,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('48d91c094d5d18f91d3f76750053cafc','11c83901545e454192a300d427e7ad2c','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-12-18 15:39:16','2020-11-09 15:52:10','admin','','','','','',NULL,'0',NULL,NULL,'0'),('492a462b212fc34b0ee70e872684ed7e','7ea60a25fa27470e9080d6a921aabbd1','name','用户名',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',6,NULL,NULL,'2019-04-17 00:22:21','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('496a026ff63538276b849d78fb2b2631','e96d84a719654f6e9cc1d73c315b0ccc','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-12-16 19:19:09','2020-11-10 09:18:44','admin','','','','','',NULL,'0',NULL,NULL,'0'),('499a5dac033a01ce58009e4c5b786697','e9faf717024b4aae95cff224ae9b6d97','age','员工年龄',NULL,0,1,'int',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2019-07-03 18:23:49','2019-07-03 18:22:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('49cd3dbd4f7f7cf0d19b1ee1045cfa69','e67d26b610dd414c884c4dbb24e71ce3','post_code','岗位编码',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',6,'admin','2019-04-24 11:03:32','2019-04-24 11:02:57','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('4a00576bbd6a9873b3bdf15c7ad91c86','d31c1fde7b9e41e7bec8a108381b5874','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-12-30 14:52:11','2020-11-13 16:06:56','admin','','','','','',NULL,'0',NULL,NULL,'0'),('4a3563cf5d5282fe14d834dcd8a89d42','9d0da12274fb494f922b6135b998721f','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-12-14 15:11:36','2020-11-09 15:17:57','admin','','','','','',NULL,'0',NULL,NULL,'0'),('4ad94222c025b56fb0833a88a1514aeb','86bf17839a904636b7ed96201b2fa6ea','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-05-14 21:18:49','2020-05-08 23:48:31','admin','','','','','',NULL,'0',NULL,NULL,'0'),('4b136f953675fffcc1b6d7d6d414d57e','402880eb71d61d3d0171d61d3de30000','date','日期',NULL,0,1,'string',200,0,'','','','','text','',120,NULL,'0','','#{date}',0,1,1,0,'single','','',4,'admin','2020-05-03 00:54:16','2020-05-02 23:59:33','admin','','','','','',NULL,'0',NULL,NULL,'0'),('4ba7c553ca4babcec75273c531cd65e1','402860816bff91c0016bff91cfea0004','workplace','工作单位','workplace',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',5,'admin','2019-07-19 18:05:13','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('4c15463271879fb836666ac2a950f748','dd396a66386745c4993dc5c941c07a2e','delivery_factory','送货厂家',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'1','','',0,1,1,0,'single','','',8,'admin','2020-12-30 15:42:31','2020-11-09 15:35:06','admin','','','','','','text','0',NULL,NULL,'0'),('4c2cba9fc950333421c4193576b8384d','32f75e4043ef4070919dbd4337186a3d','salary','工资',NULL,0,1,'double',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',10,'admin','2019-04-11 10:15:32','2019-03-28 15:24:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('4c4f4067fa31737f3ff9e088130ef793','4adec929a6594108bef5b35ee9966e9f','sex','性别',NULL,0,1,'String',200,0,'','sex','','','list','',120,NULL,'0','','{{ 2 }}',0,1,1,0,'single','','',4,'admin','2020-04-10 19:43:38','2020-04-10 19:35:58','admin','','','','','',NULL,'0',NULL,NULL,'0'),('4c570c5cf05590348e12621ca62773cf','402860816aa5921f016aa5921f480000','name','请假人','name',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',2,'admin','2019-05-11 15:31:54','2019-05-11 14:26:19','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('4c8eb1e900055c8047a4ee1e0fd083f5','dd396a66386745c4993dc5c941c07a2e','receiving_no','入仓号',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'1','','',1,1,1,0,'single','','',7,'admin','2020-12-30 15:42:31','2020-11-09 15:35:06','admin','','','','','','text','1',NULL,NULL,'0'),('4cacfa054e96791ab938b5c8f8e02cd1','27fc5f91274344afa7673a732b279939','bpm_status','流程状态',NULL,0,1,'String',2,0,'','bpm_status','','','list','',120,NULL,'0','','',0,1,1,0,'single','','',9,NULL,NULL,'2019-07-01 16:28:20','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('4d02199f73335bfc76e6d3e52ad17fc4','6a56622058424a0e8bcc8b402ffc949d','imex_no','进出口号',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',15,'admin','2020-12-14 14:58:40','2020-11-09 14:35:45','admin','','','','','','text','0',NULL,NULL,'0'),('4dbd20975c2a2f17d824d63d65dcb600','dd396a66386745c4993dc5c941c07a2e','cases_total','总件数',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',12,'admin','2020-12-30 15:42:31','2020-11-09 15:35:06','admin','','','','','','text','0',NULL,NULL,'0'),('4dc3f7e772564de45773a8379adc4335','3b5e18da618247539481816995b6bf9f','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-07-11 11:27:29','2020-07-11 11:27:17','admin','','','','','',NULL,'0',NULL,NULL,'0'),('4dfd6abc3d0b96ba89454e6527b2522b','e96d84a719654f6e9cc1d73c315b0ccc','delivery_record_id','出库id',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','iost_delivery_record','id',29,'admin','2020-12-16 19:19:09','2020-11-10 09:34:36','admin','','','','','','text','0',NULL,NULL,'0'),('4e1f5fb886e323e5ae7b73a1e12b8f31','a3e23181b97e42a0a576df37ef7c68fc','customer_code','客户编码',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',13,NULL,NULL,'2020-12-16 19:31:34','admin','','','','','','text','0',NULL,NULL,'0'),('4e3760f9068aee4318123d85fbf2ebf9','53a3e82b54b946c2b904f605875a275c','good_type_id','商品分类',NULL,0,1,'string',32,0,'','0','ces_shop_type','id,pid,name,has_child','sel_tree','',120,NULL,'0','','',0,1,1,0,'single','','',11,'admin','2020-05-08 23:42:51','2020-05-07 22:51:42','admin','','','','','','text','0',NULL,NULL,'0'),('4e794d31082c78d1bbf4187bc239d6c2','f3071ca217274b6892238c4b60e1f177','name_eng','商品英文名称',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2020-12-21 14:49:28','2020-11-16 10:39:30','admin','','','','','','text','0',NULL,NULL,'0'),('4ebb4a8d675a655b50b4b8b581ec6768','e033c8909649408ea5bb53e74f7fec7b','volume_total','总体积',NULL,0,1,'double',10,3,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',18,'admin','2020-12-14 17:44:02','2020-11-10 08:40:30','admin','','','','','','text','0',NULL,NULL,'0'),('4f718d95ad9de33eac18fd0663e4c1f1','32f75e4043ef4070919dbd4337186a3d','birthday','生日',NULL,0,1,'Date',32,0,'','','','','date','',120,NULL,'0','','',1,1,1,0,'single','','',8,'admin','2019-04-11 10:15:32','2019-03-27 15:54:49','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('4f7cba71de7afe6efbd024f5f9935521','402860816bff91c0016bff91cda80003','to_time','截止时间','to_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',4,'admin','2019-07-19 18:06:36','2019-07-17 18:54:34','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('4f8395ce892c8ec61792fbd557f7d702','1952937614c54c54a3653d97c4765cf3','length','Length',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2020-12-24 17:26:34','2020-12-24 17:24:37','admin','','','','','','text','0',NULL,NULL,'0'),('4fa29e880104e0ed0cb9143d801b209f','18f064d1ef424c93ba7a16148851664f','checkbox','checkbox',NULL,0,1,'string',32,0,'','sex','','','checkbox','',120,NULL,'0','','',0,1,1,0,'single','','',10,'admin','2020-09-11 14:35:44','2020-05-12 20:26:01','admin','','','','','','text','0',NULL,NULL,'0'),('4faa7848b92f05bcb3cf03de34af9ff2','cb2d8534a2f544bc9c618dd49da66336','ddd','dd',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2020-02-24 17:22:42','2020-02-24 15:15:14','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('4fe8e414d6980b8235955552170b2181','e033c8909649408ea5bb53e74f7fec7b','receiving_no','入仓号',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',22,'admin','2020-12-14 17:44:02','2020-11-10 08:40:30','admin','','','','','','text','0',NULL,NULL,'0'),('506c9b0b2331a24e5c284274d28fe569','27fc5f91274344afa7673a732b279939','kkk','描述',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2019-07-01 16:28:20','2019-07-01 16:26:42','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('508eb28e1409a2a9501cdf6fd7eb24c7','dbf4675875e14676a3f9a8b2b8941140','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,NULL,NULL,'2019-05-27 18:02:07','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('509a4f63f02e784bc04499a6a9be8528','d35109c3632c4952a19ecc094943dd71','update_by','更新人登录名称',NULL,0,1,'string',50,0,'','','','','text','',120,'','0','','',0,0,0,0,'single','','',4,'admin','2020-07-17 15:22:04','2019-03-15 14:24:35','admin','','','','','',NULL,'0',NULL,NULL,'0'),('519f68557b953fc2d38400182b187366','402860816bff91c0016bffa220a9000b','residence_type','户籍类别','residence_type',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',13,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('51a91b97a5921f487e22f586c173a696','618957ffac7940ffa8db258799585671','create_time','Date',NULL,0,1,'Date',20,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2021-01-07 20:02:08','2020-11-16 15:43:36','admin','','','','','','text','0',NULL,NULL,'0'),('521e41eeffa61ea390e3f24ebd2b698a','618957ffac7940ffa8db258799585671','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2021-01-07 20:02:08','2020-11-16 15:43:36','admin','','','','','',NULL,'0',NULL,NULL,'0'),('523fafa054e8adf63b57453b6245bff0','47a79ec9f7f64c21aa55634bf619406d','customer_name','客户姓名',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',10,NULL,NULL,'2020-11-16 15:21:22','admin','','','','','','text','0',NULL,NULL,'0'),('52ee861bc1b62cd8e4f10632b3d9d1b2','79091e8277c744158530321513119c68','name','顺序会签标题',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',6,'admin','2019-05-11 15:29:47','2019-05-11 15:27:17','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('545b97fb9235ec401426c98f1aaa9550','5c58150ab99a4487bc5b4666f762962a','volume_total','总体积',NULL,0,1,'double',10,3,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',10,'admin','2020-12-21 14:14:25','2020-11-13 15:35:09','admin','','','','','','text','0',NULL,NULL,'0'),('545ddbfe33d4706119cc3c7043b30dbb','47a79ec9f7f64c21aa55634bf619406d','date','保险日期',NULL,0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'single','','',8,NULL,NULL,'2020-11-16 15:21:22','admin','','','','','','text','0',NULL,NULL,'0'),('5531fb261c77e9d12f7cca1af528f70a','05a3a30dada7411c9109306aa4117068','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-05-12 22:39:41','2020-05-06 11:34:31','admin','','','','','',NULL,'0',NULL,NULL,'0'),('553a250fb89de39e4ba9f8450fd72ade','05a3a30dada7411c9109306aa4117068','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-05-12 22:39:41','2020-05-06 11:34:31','admin','','','','','',NULL,'0',NULL,NULL,'0'),('5562a7242e4978f02e6d3a08d5828bbf','53a3e82b54b946c2b904f605875a275c','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-05-08 23:42:51','2020-05-07 22:49:47','admin','','','','','',NULL,'0',NULL,NULL,'0'),('5562ad3165b1399f97a48f5f06d7fa06','3b5e18da618247539481816995b6bf9f','ccc','cc',NULL,0,1,'string',1000,0,'','','','','umeditor','',120,NULL,'0','','',0,1,1,0,'single','','',10,'admin','2020-07-11 11:27:29','2020-07-11 11:27:17','admin','','','','','','text','0',NULL,NULL,'0'),('559ab350f199afd6a3b2b450e8b19976','11c83901545e454192a300d427e7ad2c','width','宽',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',17,'admin','2020-12-18 15:39:16','2020-11-09 15:52:10','admin','','','','','','text','0',NULL,NULL,'0'),('565b4359091d0bbe1379f99749491c49','6a56622058424a0e8bcc8b402ffc949d','name_chs','客户中文名称',NULL,0,0,'string',32,0,'','','','','text','',120,NULL,'1','','',1,1,1,0,'single','','',7,'admin','2020-12-14 14:58:40','2020-11-09 14:35:45','admin','','','','','','text','1',NULL,NULL,'0'),('566b94d7d7eca09e878ecad6829f161e','2f03eb34ce95467e8a7f1388d49c18c8','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2021-01-07 21:29:54','2020-11-10 09:00:36','admin','','','','','',NULL,'0',NULL,NULL,'0'),('56a7800e4e476812c74217c2aad781aa','32feeb502544416c9bf41329c10a88f4','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2019-08-23 20:03:40','2019-07-02 18:23:23','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('56cd0a76f922bf76d982b24a509e4782','4028839a6de2ebd3016de2ebd3870000','create_time','创建日期','create_time',0,1,'Date',0,0,NULL,NULL,NULL,NULL,'date',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,3,NULL,NULL,'2019-10-19 15:29:30','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('56e247f12d62b49cd9bd537e3efecf16','402860816bff91c0016bff91c0cb0000','create_by','创建人','create_by',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',12,'admin','2019-07-19 18:09:01','2019-07-17 18:54:32','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('57552a4f0b7b5c096ab8985ced57cc7d','cb2d8534a2f544bc9c618dd49da66336','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-02-24 17:22:42','2020-02-24 15:15:14','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('57881a6db0b38ca71af71448beb55c46','e96d84a719654f6e9cc1d73c315b0ccc','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-12-16 19:19:09','2020-11-10 09:18:44','admin','','','','','',NULL,'0',NULL,NULL,'0'),('57e43df9e6887c897f5198b762c675dc','d31c1fde7b9e41e7bec8a108381b5874','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-12-30 14:52:10','2020-11-13 16:06:56','admin','','','','','',NULL,'0',NULL,NULL,'0'),('57e6805487971b1595f9b56b38328ce2','e96d84a719654f6e9cc1d73c315b0ccc','cases_actual','实际件数',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',18,'admin','2020-12-16 19:19:09','2020-11-10 09:28:24','admin','','','','','','text','0',NULL,NULL,'0'),('581d8e8ce270b762458121b1dea0be9a','8d66ea41c7cc4ef9ab3aab9055657fc9','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,NULL,NULL,'2020-05-07 22:46:32','admin','','','','','',NULL,'0',NULL,NULL,'0'),('588400f6ebcdd0bc9bb560dd36636af9','e2faf977fdaf4b25a524f58c2441a51c','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2019-06-10 17:27:00','2019-04-24 17:12:11','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('58a96f945912d33b64ebf5dee98156dc','402860816bff91c0016bffa220a9000b','mobile','手机号','mobile',0,1,'string',20,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',19,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('58cbe3d105ba77cf574b4069310f4aaa','ca4136acdc61484c94913ba54c2ecaa8','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-11-16 15:27:24','2020-11-16 15:24:54','admin','','','','','',NULL,'0',NULL,NULL,'0'),('58eea85add4788b83c893092434bc413','fb19fb067cd841f9ae93d4eb3b883dc0','update_time','更新日期',NULL,0,1,'date',20,0,'','','','','text','',120,'','0','','',0,1,1,0,'single','','',4,NULL,NULL,'2019-03-23 11:39:48','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('591a18a26c21d0ae6e10cdf49e1d7dc9','38b8d95658a74899b7dc02e63e199af6','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-12-14 14:53:53','2020-11-09 14:23:45','admin','','','','','',NULL,'0',NULL,NULL,'0'),('594127647982572d6d8a4036f0dd0b01','47a79ec9f7f64c21aa55634bf619406d','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,NULL,NULL,'2020-11-16 15:21:22','admin','','','','','',NULL,'0',NULL,NULL,'0'),('59ae1e853668c676e85329aa029c68a6','402860816bff91c0016bff91c0cb0000','status','状态（1：申请中 2：通过）','status',0,1,'string',2,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',11,'admin','2019-07-19 18:09:01','2019-07-17 18:54:32','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('5a043c7ae042e48f50d1fb0bb3d760a8','402880eb71d61d3d0171d61d3de30000','code','编码',NULL,0,1,'String',200,0,'','','','','text','',120,NULL,'0','','${order_num_rule_param}',0,1,1,0,'single','','',2,'admin','2020-05-03 00:54:16','2020-05-02 23:59:33','admin','','','','','',NULL,'0',NULL,NULL,'0'),('5a1ab458d88bb766f92c3d791495cdcd','402860816bff91c0016bff91d2810005','age','年龄','age',0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',5,'admin','2019-07-19 18:05:55','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('5a4ef083dd572114aeb581b6828de545','402860816bff91c0016bff91c7010001','award_name','获奖名称','award_name',0,1,'string',255,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',5,'admin','2019-07-19 18:07:47','2019-07-17 18:54:32','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('5a621f27aa443fe9eccc73717e4fa172','4028318169e81b970169e81b97650000','method','请求java方法','method',0,1,'string',500,0,NULL,NULL,NULL,NULL,'text',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,8,NULL,NULL,'2019-04-04 19:28:36','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('5a655b208d6318ed02f236f15a319b5f','fbc35f067da94a70adb622ddba259352','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,NULL,NULL,'2019-07-03 19:44:23','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('5a6f88710c49bbe8e2e0ca58e149abad','402860816bff91c0016bff91cda80003','create_by','创建人','create_by',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',9,'admin','2019-07-19 18:06:36','2019-07-17 18:54:34','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('5ab702dbc37d6fd8d3a1093fda7223bf','53a3e82b54b946c2b904f605875a275c','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-05-08 23:42:51','2020-05-07 22:49:47','admin','','','','','',NULL,'0',NULL,NULL,'0'),('5b17ba693745c258f6b66380ac851e5f','d35109c3632c4952a19ecc094943dd71','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,'','0','','',0,1,1,0,'single','','',1,'admin','2020-07-17 15:22:04','2019-03-15 14:24:35','admin','','','','','',NULL,'0',NULL,NULL,'0'),('5ba6f244f70349f8713a21c5d3cad3e5','133b01634f4a411593a94007dca75300','weight','重量',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',10,'admin','2020-12-21 19:00:00','2020-11-13 16:13:56','admin','','','','','','text','0',NULL,NULL,'0'),('5c276f9e0523a4765c73e3fb0089e960','f3071ca217274b6892238c4b60e1f177','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-12-21 14:49:28','2020-11-16 10:39:30','admin','','','','','',NULL,'0',NULL,NULL,'0'),('5c76f5ecc774d7339eb0c2199c0052bc','402860816bff91c0016bff91c0cb0000','biz_no','编号','biz_no',0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',2,'admin','2019-07-19 18:09:01','2019-07-17 18:54:32','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('5c8c8d573e01e4f40b5a7c451515e1d2','32feeb502544416c9bf41329c10a88f4','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2019-08-23 20:03:40','2019-07-02 18:23:23','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('5c995a4a2733a9a8ae2e6800f2845f9b','dd396a66386745c4993dc5c941c07a2e','volumes_total','总体积',NULL,0,1,'double',10,3,'','','','','text','',120,NULL,'0','','',0,0,1,0,'single','','',16,'admin','2020-12-30 15:42:31','2020-12-16 19:22:42','admin','','','','','','text','0',NULL,NULL,'0'),('5dfbea516ee2390d712eace5405c5219','402860816bff91c0016bff91ca7e0002','create_by','创建人','create_by',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',9,'admin','2019-07-19 18:07:13','2019-07-17 18:54:33','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('5e16a861f86348094c5865097d756439','ca4136acdc61484c94913ba54c2ecaa8','insurance_policy_id','保险id',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','iost_insurance_policy','id',14,'admin','2020-11-16 15:27:24','2020-11-16 15:25:55','admin','','','','','','text','0',NULL,NULL,'0'),('5e4484b7348dc3e59a0c58bdc3828cc0','27fc5f91274344afa7673a732b279939','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2019-07-01 16:28:20','2019-07-01 16:26:42','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('5e4ac29ac2007ceabf93368330290a42','402860816bff91c0016bff91d8830007','order_no','序号','order_no',0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',9,'admin','2019-07-19 18:04:41','2019-07-17 18:54:37','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('5e729f9823b5cc96c50b0b7c0f07eb05','402880e5721355dd01721355dd390000','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single',NULL,NULL,2,NULL,NULL,'2020-05-14 21:18:14','admin','','','','','',NULL,'0',NULL,NULL,'0'),('5ed1a13a6a1c009d3373d62cc421d6bb','dd396a66386745c4993dc5c941c07a2e','weights_total','总重量',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'0','','',0,0,1,0,'single','','',17,'admin','2020-12-30 15:42:31','2020-12-16 19:22:42','admin','','','','','','text','0',NULL,NULL,'0'),('5f13f7087caa0bbf47e5eba01d0d0443','05a3a30dada7411c9109306aa4117068','contents','请假原因',NULL,0,1,'string',500,0,'','','','','markdown','',120,NULL,'0','','',0,1,1,0,'single','','',11,'admin','2020-05-12 22:39:41','2020-05-06 11:34:31','admin','','','','','','text','0',NULL,NULL,'0'),('5f5ac4d37fd1a3a09e2b19f0d4d99c0f','4adec929a6594108bef5b35ee9966e9f','code','编码',NULL,0,1,'String',200,0,'','','','','text','',120,NULL,'0','','${order_num_rule_param}',0,1,1,0,'single','','',2,'admin','2020-04-10 19:43:38','2020-04-10 19:35:58','admin','','','','','',NULL,'0',NULL,NULL,'0'),('5f718d8968d908cd2e4de6ee4c74d644','402880eb71d61d3d0171d61d3de30000','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',7,'admin','2020-05-03 00:54:16','2020-05-02 23:59:33','admin','','','','','','text','0',NULL,NULL,'0'),('600a95fdfd68fbcd3899b76277fc1335','6bf0dccd4a2d4dd4b2e0be9ea32a3630','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2021-01-01 22:29:32','2020-11-12 17:18:41','admin','','','','','',NULL,'0',NULL,NULL,'0'),('6130dbb6d36bab8ee9154e7ab58af34c','402880e570a5d7000170a5d700f50000','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single',NULL,NULL,1,NULL,NULL,'2020-03-04 21:58:16','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('617349b18dab429009ccd304fd7d459c','4028839a6de2ebd3016de2ebd3870000','update_by','更新人','update_by',0,1,'string',50,0,NULL,NULL,NULL,NULL,'text',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,4,NULL,NULL,'2019-10-19 15:29:30','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('6192474c85aa9fc07237fd3075564c46','38b8d95658a74899b7dc02e63e199af6','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-12-14 14:53:53','2020-11-09 14:23:45','admin','','','','','',NULL,'0',NULL,NULL,'0'),('61c7a0058c264dd746eb35e6f50fc15b','402860816aa5921f016aa5dedcb90009','update_time','更新日期','update_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,0,0,0,'group','','',5,'admin','2019-05-11 15:56:47','2019-05-11 15:50:08','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('6232ade7e2a0c1e97e2c0945b32e61b6','402860816bff91c0016bffa220a9000b','paying_social_insurance','是否上社保','paying_social_insurance',0,1,'string',20,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',32,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('6352d477b6b2751780c5852e92d0daa6','402880eb71d61d3d0171d61d3de30000','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-05-03 00:54:16','2020-05-02 23:59:33','admin','','','','','',NULL,'0',NULL,NULL,'0'),('635e09afc01aad757faacf1321465c23','b81de38db24047b497d476516f8a0865','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,NULL,NULL,'2020-02-24 14:56:08','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('63bedeea3441e4b1ebfd92cabd504e23','5c58150ab99a4487bc5b4666f762962a','weight_total','总重量',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',12,'admin','2020-12-21 14:14:25','2020-11-13 15:35:09','admin','','','','','','text','0',NULL,NULL,'0'),('6490a98dccb6df218feaeb4ce11bc03b','402860816aa5921f016aa5921f480000','update_time','修改时间','update_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,0,0,0,'group','','',10,'admin','2019-05-11 15:31:54','2019-05-11 14:26:19','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('64cff77ff40843212ece7e51ee381563','38b8d95658a74899b7dc02e63e199af6','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-12-14 14:53:53','2020-11-09 14:23:45','admin','','','','','',NULL,'0',NULL,NULL,'0'),('654362725195829005036b3db47ec826','402860816bff91c0016bffa220a9000b','post','职务','post',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',4,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('65d699e4ce5e98d55e333627a16520dc','618957ffac7940ffa8db258799585671','company','Company',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',10,'admin','2021-01-07 20:02:09','2020-11-16 15:43:36','admin','','','','','','text','0',NULL,NULL,'0'),('6603058186832c4ff9e8c6e43baa5c3d','86bf17839a904636b7ed96201b2fa6ea','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-05-14 21:18:49','2020-05-08 23:48:31','admin','','','','','',NULL,'0',NULL,NULL,'0'),('66a7ef842bc34e105a90186e48167ef2','dbf4675875e14676a3f9a8b2b8941140','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,NULL,NULL,'2019-05-27 18:02:07','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('670bf1efd161a62ce83106960ed93cc7','d31c1fde7b9e41e7bec8a108381b5874','bulk_no','散货柜编号',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2020-12-30 14:52:11','2020-11-13 16:06:56','admin','','','','','','text','0',NULL,NULL,'0'),('671e62c685bc86bde3cef0e023418fb4','05a3a30dada7411c9109306aa4117068','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-05-12 22:39:41','2020-05-06 11:34:31','admin','','','','','',NULL,'0',NULL,NULL,'0'),('672c02bc6e392f125503c440dca10e28','47a79ec9f7f64c21aa55634bf619406d','insurance_policy_id','保险单号',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,NULL,NULL,'2020-11-16 15:21:22','admin','','','','','','text','0',NULL,NULL,'0'),('675c1aa2afe4ce3aadeb8bfe1620c264','e033c8909649408ea5bb53e74f7fec7b','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-12-14 17:44:02','2020-11-10 08:36:39','admin','','','','','',NULL,'0',NULL,NULL,'0'),('686dea2621feadcd9b4c611df046adb4','86bf17839a904636b7ed96201b2fa6ea','price','价格',NULL,0,1,'double',10,3,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2020-05-14 21:18:49','2020-05-08 23:48:31','admin','','','','','','text','0',NULL,NULL,'0'),('68769fa7e4696e3a28f4cecf63076b7b','402860816bff91c0016bff91ca7e0002','order_no','序号','order_no',0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',8,'admin','2019-07-19 18:07:13','2019-07-17 18:54:33','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('690a1bf5680fb65f750084bf3ea62e83','133b01634f4a411593a94007dca75300','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-12-21 19:00:00','2020-11-13 16:09:31','admin','','','','','',NULL,'0',NULL,NULL,'0'),('69666f21896136af16a6303aff440156','402860816bff91c0016bffa220a9000b','nation','民族','nation',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',11,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('69b6b84b4049c996ee45e7ba0cdc4047','dd396a66386745c4993dc5c941c07a2e','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-12-30 15:42:30','2020-11-09 15:35:06','admin','','','','','',NULL,'0',NULL,NULL,'0'),('69d11490788fecfc9fb7d74bf449ba86','32f75e4043ef4070919dbd4337186a3d','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2019-04-11 10:15:32','2019-03-27 15:54:49','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('69e568501d10281d061311d3db15e6af','18f064d1ef424c93ba7a16148851664f','user_sel','选择用户',NULL,0,1,'string',200,0,'','','','','sel_user','',120,NULL,'0','','#{sysUserCode}',0,1,1,0,'single','','',18,'admin','2020-09-11 14:35:44','2020-05-12 20:26:01','admin','','','','','','text','0',NULL,NULL,'0'),('6a0082c8ffbae092e99689520f1c83f7','4fb8e12a697f4d5bbe9b9fb1e9009486','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',9,'admin','2020-04-10 19:51:27','2020-04-10 19:47:01','admin','','','','','','text','0',NULL,NULL,'0'),('6a204f079e82dd1b3e270432bd6b4591','f70eb6fe0df74c5eb04552f5c1a4b7b3','name_eng','商品英文名称',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2020-12-16 20:11:33','2020-12-16 19:34:19','admin','','','','','','text','0',NULL,NULL,'0'),('6a30c2e6f01ddd24349da55a37025cc0','d35109c3632c4952a19ecc094943dd71','top_pic','头像',NULL,0,1,'String',500,0,'','','','','image','',120,NULL,'0','','',0,1,1,0,'single','','',12,'admin','2020-07-17 15:22:04','2019-06-10 20:06:56','admin','','','','','',NULL,'0',NULL,NULL,'0'),('6a7c5373a14f27e7eee2244d66dbcaca','618957ffac7940ffa8db258799585671','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2021-01-07 20:02:08','2020-11-16 15:43:36','admin','','','','','',NULL,'0',NULL,NULL,'0'),('6a9c5810331cc5858b944e5bd0ce6cf5','47a79ec9f7f64c21aa55634bf619406d','customer_code','客户编码',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',9,NULL,NULL,'2020-11-16 15:21:22','admin','','','','','','text','0',NULL,NULL,'0'),('6ab2e3d9b944701b405fb1a5ed167012','86bf17839a904636b7ed96201b2fa6ea','zong_price','单品总价',NULL,0,1,'double',10,3,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',10,'admin','2020-05-14 21:18:49','2020-05-08 23:48:31','admin','','','','','','text','0',NULL,NULL,'0'),('6b21f5239671023ca769b6717a51130e','402880eb71d61d3d0171d61d3de30000','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',8,'admin','2020-05-03 00:54:16','2020-05-02 23:59:33','admin','','','','','','text','0',NULL,NULL,'0'),('6b6f3aa00b8e73fb785154e795189739','402860816aa5921f016aa5dedcb90009','start_time','会签发起时间','start_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',7,'admin','2019-05-11 15:56:47','2019-05-11 15:50:08','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('6beb40bdd28af22e06b26640bc0c3f4d','3b5e18da618247539481816995b6bf9f','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-07-11 11:27:29','2020-07-11 11:27:17','admin','','','','','',NULL,'0',NULL,NULL,'0'),('6c35eb97737e9f86279939d264454a94','86bf17839a904636b7ed96201b2fa6ea','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-05-14 21:18:49','2020-05-08 23:48:31','admin','','','','','',NULL,'0',NULL,NULL,'0'),('6cfb5acbbb69782bf0c7043b53f595b2','402860816bff91c0016bff91cda80003','update_by','更新人','update_by',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',11,'admin','2019-07-19 18:06:36','2019-07-17 18:54:34','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('6d03a7774a50c6e6f76dbc7a8269beba','3b5e18da618247539481816995b6bf9f','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-07-11 11:27:29','2020-07-11 11:27:17','admin','','','','','',NULL,'0',NULL,NULL,'0'),('6d4a4414b55ad5b6f31c8fb327dad834','09fd28e4b7184c1a9668496a5c496450','address','常用地址',NULL,0,1,'string',300,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',11,'admin','2020-05-14 21:19:21','2020-05-08 23:51:49','admin','','','','','','text','0',NULL,NULL,'0'),('6d570b2866e0e411d36b16c2c4c7830e','6a56622058424a0e8bcc8b402ffc949d','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-12-14 14:58:40','2020-11-09 14:35:45','admin','','','','','',NULL,'0',NULL,NULL,'0'),('6d759b1e477c0571ebd15929416003b9','f70eb6fe0df74c5eb04552f5c1a4b7b3','name_chs','商品中文名称',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2020-12-16 20:11:33','2020-12-16 19:34:19','admin','','','','','','text','0',NULL,NULL,'0'),('6e5c9d8e8b7eb6980ec246cb813b180b','4fb8e12a697f4d5bbe9b9fb1e9009486','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',10,'admin','2020-04-10 19:51:27','2020-04-10 19:47:01','admin','','','','','','text','0',NULL,NULL,'0'),('6ed8d9acef3cccd1b8fd659b3b538023','53a3e82b54b946c2b904f605875a275c','price','价格',NULL,0,1,'BigDecimal',10,5,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2020-05-08 23:42:51','2020-05-07 22:49:47','admin','','','','','','text','0',NULL,NULL,'0'),('6f38a07ea2b1065315a6b89a02af5bb4','3b5e18da618247539481816995b6bf9f','name','用户名',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2020-07-11 11:27:29','2020-07-11 11:27:17','admin','','','','','','text','0',NULL,NULL,'0'),('6f73e96a659c200c083006b6fce1f043','402860816bff91c0016bff91ca7e0002','cert_name','证书名称','cert_name',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',4,'admin','2019-07-19 18:07:13','2019-07-17 18:54:33','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('7073d45fe3d0b13432d724bccf528baa','11c83901545e454192a300d427e7ad2c','name_chs','商品中文名称',NULL,0,1,'string',32,0,'','name_chs,kind,name_eng,price','price_list','name_chs,kind,name_eng,price','popup','',120,NULL,'1','','',0,1,1,0,'single','','',7,'admin','2020-12-18 15:39:16','2020-11-09 15:52:10','admin','','','','','','text','0',NULL,NULL,'0'),('70740dcbe099c6782a5f0ae2427ec034','5c58150ab99a4487bc5b4666f762962a','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-12-21 14:14:25','2020-11-13 15:35:09','admin','','','','','',NULL,'0',NULL,NULL,'0'),('70e6de4df739fe465dad2f98dda38c95','e033c8909649408ea5bb53e74f7fec7b','packages','单件装箱数',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',12,'admin','2020-12-14 17:44:02','2020-11-10 08:36:39','admin','','','','','','text','0',NULL,NULL,'0'),('7154c75d754a5f88bef2b68829baf576','4028318169e81b970169e81b97650000','operate_type','操作类型','operate_type',0,1,'string',10,0,NULL,NULL,NULL,NULL,'text',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,4,NULL,NULL,'2019-04-04 19:28:36','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('71afb00a1971125ecfa13b4dfa49665e','402860816bff91c0016bff91cfea0004','order_no','序号','order_no',0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',8,'admin','2019-07-19 18:05:13','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('71d5b0675df5aba71688c9d7d75cccee','4028318169e81b970169e81b97650000','log_type','日志类型（1登录日志，2操作日志）','log_type',0,1,'string',10,0,NULL,NULL,NULL,NULL,'text',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,2,NULL,NULL,'2019-04-04 19:28:36','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('71e9ab74dae687837365e50eed090591','1acb6f81a1d9439da6cc4e868617b565','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',1,'admin','2019-06-10 14:47:14','2019-04-23 22:58:19','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('7246f03bb80af4949530227da585b72f','11c83901545e454192a300d427e7ad2c','picture','图片',NULL,0,1,'Blob',0,0,'','','','','image','',120,NULL,'0','','',0,1,1,0,'single','','',10,'admin','2020-12-18 15:39:16','2020-11-09 15:52:10','admin','','','','','','text','0',NULL,NULL,'0'),('7280c56a210e6a47794fda855d0c6abb','fbc35f067da94a70adb622ddba259352','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,NULL,NULL,'2019-07-03 19:44:23','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('72e784af5c47bbbc0534b29bf656bd61','4028839a6de2ebd3016de2ebd3870000','id','主键','id',1,0,'string',36,0,NULL,NULL,NULL,NULL,'text',NULL,120,NULL,'0',NULL,NULL,0,0,0,0,'group',NULL,NULL,1,NULL,NULL,'2019-10-19 15:29:30','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('7365f05f551092716223d5d449efd8c7','beee191324fd40c1afec4fda18bd9d47','name','ss',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',6,'admin','2019-04-13 13:41:13','2019-04-13 13:40:56','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('737c271e090e77ecab907959ef66f372','a3c6f1140f7e447eb5bdb26898181fba','content','内容',NULL,0,0,'string',300,0,'','','','','textarea','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2020-11-26 16:35:41','2020-11-26 16:17:55','admin','','','','','','text','0',NULL,NULL,'0'),('73d3b57df0c6cf15c21970f4dd979319','402880e5721355dd01721355dd390000','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single',NULL,NULL,5,NULL,NULL,'2020-05-14 21:18:14','admin','','','','','',NULL,'0',NULL,NULL,'0'),('73dc6089556f3446e39d42df3dedb2db','402880e570a5d7000170a5d700f50000','num','数量',NULL,0,1,'int',32,0,'','','','','text','',120,'n','0','','',0,1,1,0,'single',NULL,NULL,8,NULL,NULL,'2020-03-04 21:58:16','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('742329ccdb185cf5d3e0b5b0c05dcffa','402860816bff91c0016bffa220a9000b','interest','兴趣爱好','interest',0,1,'string',255,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',34,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('744444a7ada3bbb05c6b114b5ba0d477','402860816aa5921f016aa5dedcb90009','id','id','id',1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'group','','',1,'admin','2019-05-11 15:56:47','2019-05-11 15:50:08','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('7468214b4c3d59496a487140de4039ee','38b8d95658a74899b7dc02e63e199af6','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-12-14 14:53:53','2020-11-09 14:23:45','admin','','','','','',NULL,'0',NULL,NULL,'0'),('74af99545de724a4abd2022581a36026','fb7125a344a649b990c12949945cb6c1','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','text','',120,'','0','','',0,0,0,0,'single','','',2,'admin','2019-03-26 19:24:11','2019-03-26 19:01:52','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('756b07656386dbd91245f7ffda32ae61','402860816bff91c0016bff91d8830007','id','id','id',1,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'group','','',1,'admin','2019-07-19 18:04:41','2019-07-17 18:54:37','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('757370591c6331113f4f1dbcc4f94678','11c83901545e454192a300d427e7ad2c','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-12-18 15:39:16','2020-11-09 15:52:10','admin','','','','','',NULL,'0',NULL,NULL,'0'),('75841fa7c75ebdc94655bd5e44fbc9f6','402860816bff91c0016bffa220a9000b','native_place','籍贯','native_place',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',10,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('75ba781c67711bed71bba1c3e3c68e11','8994f2817b5a45d9890aa04497a317c5','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,'','0','','',0,1,1,0,'single','','',0,NULL,NULL,'2019-03-23 11:39:16','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('75c66562b8d58f4ae7d51b006dc658be','caa8de52a4dd4c2e909582709619fa7d','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-12-14 15:02:32','2020-11-09 15:04:12','admin','','','','','',NULL,'0',NULL,NULL,'0'),('75e4304f0c7be90a06787a04ec4c617a','6bf0dccd4a2d4dd4b2e0be9ea32a3630','location','地点',NULL,0,1,'string',32,0,'','','','','text','',300,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2021-01-01 22:29:32','2020-11-12 17:18:41','admin','','','','','','text','0',NULL,NULL,'0'),('75e82f151e8cc12455f7f0d25bf4dac0','4028839a6de2ebd3016de2ebd3870000','wl_name','物料名称','wl_name',0,1,'string',100,0,NULL,NULL,NULL,NULL,'text',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,7,NULL,NULL,'2019-10-19 15:29:30','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('7639c1bc4327f1f674ffeab2ca261134','32f75e4043ef4070919dbd4337186a3d','update_by','更新人登录名称',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2019-04-11 10:15:32','2019-03-27 15:54:49','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('766ca866b72d118f5d8883de46a8c043','4028839a6de2ebd3016de2ebd3870000','supplier','供应商','supplier',0,1,'string',32,0,NULL,NULL,NULL,NULL,'text',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,15,NULL,NULL,'2019-10-19 15:29:30','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('7697d88456fe13789027c534fa7948d9','d7b42c2262774ded8de4ab7dea6463a9','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-12-26 00:27:15','2020-11-16 10:35:13','admin','','','','','',NULL,'0',NULL,NULL,'0'),('78a40344207c791b8d7ac7de721ce1c4','79091e8277c744158530321513119c68','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2019-05-11 15:29:47','2019-05-11 15:27:17','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('78eb7e3b77cd49f9acb9b024cfe834e1','402860816aa5921f016aa5dedcb90009','create_time','创建日期','create_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,0,0,0,'group','','',3,'admin','2019-05-11 15:56:47','2019-05-11 15:50:08','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('78fd804d93dc716fd8c2ccc45f788565','fb7125a344a649b990c12949945cb6c1','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,'','0','','',0,0,0,0,'single','','',1,'admin','2019-03-26 19:24:11','2019-03-26 19:01:52','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('790c9f3dba773ed9a6ea3ad627393f57','402860816bff91c0016bffa220a9000b','archives_location','档案所在地','archives_location',0,1,'string',255,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',36,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('799497086413180d2f39605d1972b1fd','133b01634f4a411593a94007dca75300','summary_id','汇总单id',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','iost_summary_sheet','id',15,'admin','2020-12-21 19:00:00','2020-11-16 10:24:33','admin','','','','','','text','0',NULL,NULL,'0'),('7a1bb86a0c3bcebe47211ecc78955afc','2f03eb34ce95467e8a7f1388d49c18c8','weight_totals','总重量',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'0','','',0,0,1,0,'single','','',12,'admin','2021-01-07 21:29:54','2020-12-21 14:56:48','admin','','','','','','text','0',NULL,NULL,'0'),('7a657d119db036fb1b33b49ace35a1e0','9d0da12274fb494f922b6135b998721f','name_eng','商品英文名称',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'1','','',1,1,1,0,'single','','',9,'admin','2020-12-14 15:11:36','2020-11-09 15:17:57','admin','','','','','','text','1',NULL,NULL,'1'),('7a665ed90ef64b4d65632c941e5795b2','4b556f0168f64976a3d20bfb932bc798','sex','性别',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,NULL,NULL,'2019-04-12 23:38:29','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('7a697e4053445f07ad1a56a246f593e7','86bf17839a904636b7ed96201b2fa6ea','good_name','商品名字',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2020-05-14 21:18:49','2020-05-08 23:48:31','admin','','','','','','text','0',NULL,NULL,'0'),('7ae576fc056e38017cc52bc004d46f14','61328d3127024a9b99298eded991106c','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-12-26 18:13:52','2020-11-10 08:19:09','admin','','','','','',NULL,'0',NULL,NULL,'0'),('7ae6f8fbc09cc2f754794d7449855e1f','506c10297a174bf39f4658da3462213b','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2021-01-01 22:30:01','2020-11-12 17:16:04','admin','','','','','',NULL,'0',NULL,NULL,'0'),('7b4c181e4ebd76022f75535ed6fd9de3','4adec929a6594108bef5b35ee9966e9f','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',10,'admin','2020-04-10 19:43:38','2020-04-10 19:35:58','admin','','','','','','text','0',NULL,NULL,'0'),('7b642d983ac06bfef91edde2c932dbe7','1acb6f81a1d9439da6cc4e868617b565','xg_shangxian','选购上限',NULL,0,1,'int',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',14,'admin','2019-06-10 14:47:14','2019-04-23 22:58:19','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('7b849e57debfb889caea5e0fef09062b','beee191324fd40c1afec4fda18bd9d47','sex2','dd',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2019-04-13 13:41:13','2019-04-13 13:40:56','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('7beb639aa9ffda07edb5ce1e49c2287f','402860816bff91c0016bff91d2810005','update_time','更新时间','update_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',13,'admin','2019-07-19 18:05:55','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('7bf091da401b74d55b107fe9f930ea54','4028839a6de2ebd3016de2ebd3870000','create_by','创建人','create_by',0,1,'string',50,0,NULL,NULL,NULL,NULL,'text',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,2,NULL,NULL,'2019-10-19 15:29:30','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('7c6aecc377816c69147f1193b17dfcc5','e9faf717024b4aae95cff224ae9b6d97','sex','员工性别',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2019-07-03 18:23:49','2019-07-03 18:22:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('7cadf4e0be0b173bb5b8d39613e25190','402860816bff91c0016bffa220a9000b','residence_postcode','户籍邮编','residence_postcode',0,1,'string',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',29,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('7cdbe0d563e15f3fb1fb32d996fe4ba7','3d447fa919b64f6883a834036c14aa67','area','区',NULL,0,1,'String',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',4,'admin','2020-02-21 17:58:46','2020-02-20 16:19:00','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('7d107728408c21ece332406a21f2d692','402860816bff91c0016bff91cfea0004','update_by','更新人','update_by',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',11,'admin','2019-07-19 18:05:13','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('7d1e6e77c33b5d59989af49a8625b79f','f70eb6fe0df74c5eb04552f5c1a4b7b3','width','宽（厘米）',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',14,'admin','2020-12-16 20:11:33','2020-12-16 20:08:14','admin','','','','','','text','0',NULL,NULL,'0'),('7d7936759ba62f1a5c06dec322e855fe','e033c8909649408ea5bb53e74f7fec7b','unit','单位',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',10,'admin','2020-12-14 17:44:02','2020-11-10 08:36:39','admin','','','','','','text','0',NULL,NULL,'0'),('7dc6702df9088fc00fa0eaa2186ec70b','8a75e88b8e554ee6942b114ccea6d5d9','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,NULL,NULL,'2020-11-26 17:31:49','admin','','','','','',NULL,'0',NULL,NULL,'0'),('7dfcc0c24acf82e0b53830cfc2a1fc22','506c10297a174bf39f4658da3462213b','loading_date','装柜日期',NULL,0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2021-01-01 22:30:01','2020-11-12 17:16:04','admin','','','','','','text','0',NULL,NULL,'0'),('7e066f60680158d47b328ef519d80e49','beee191324fd40c1afec4fda18bd9d47','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2019-04-13 13:41:13','2019-04-13 13:40:56','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('7e5ca5dc205a3783df2940ec1a64a989','8a75e88b8e554ee6942b114ccea6d5d9','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,NULL,NULL,'2020-11-26 17:31:49','admin','','','','','',NULL,'0',NULL,NULL,'0'),('7ea722a5cb5db5f542403cd629a1194c','133b01634f4a411593a94007dca75300','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-12-21 19:00:00','2020-11-13 16:09:31','admin','','','','','',NULL,'0',NULL,NULL,'0'),('7f10901c6ade3aa9d9ff46ed7039c70f','1acb6f81a1d9439da6cc4e868617b565','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2019-06-10 14:47:14','2019-04-23 22:58:19','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('8074f7b58058d3a1ce0ea54e0169ed4a','f70eb6fe0df74c5eb04552f5c1a4b7b3','packages','单件装箱数',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',11,'admin','2020-12-16 20:11:33','2020-12-16 20:08:14','admin','','','','','','text','0',NULL,NULL,'0'),('809a9fafe0b79c9997de32cb6e831c6f','05a3a30dada7411c9109306aa4117068','birthday','生日',NULL,0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'single','','',10,'admin','2020-05-12 22:39:41','2020-05-06 11:34:31','admin','','','','','','text','0',NULL,NULL,'0'),('80cd0368a93b338c768357791ec5dc44','e033c8909649408ea5bb53e74f7fec7b','record_id','记录id',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','iost_inventory_record','id',24,'admin','2020-12-14 17:44:02','2020-11-10 08:42:09','admin','','','','','','text','0',NULL,NULL,'0'),('810d52125f40cf69979c120c082e5b56','a3c6f1140f7e447eb5bdb26898181fba','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-11-26 16:35:41','2020-11-26 16:17:55','admin','','','','','',NULL,'0',NULL,NULL,'0'),('8119d3de514092232935b038531828c5','05a3a30dada7411c9109306aa4117068','sex','性别',NULL,0,1,'string',32,0,'','sex','','','list','',120,NULL,'0','','',1,1,1,0,'single','','',9,'admin','2020-05-12 22:39:41','2020-05-06 11:34:31','admin','','','','','','text','0',NULL,NULL,'0'),('813a5ebf7335309c7edb3803f7e4b204','402880e570a5d7000170a5d700f50000','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single',NULL,NULL,2,NULL,NULL,'2020-03-04 21:58:16','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('813b04984a817a3f33e7c4b05dc592d4','1952937614c54c54a3653d97c4765cf3','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-12-24 17:26:34','2020-11-16 15:53:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('817cc5e277e88164dffd4caee1169276','56efb74326e74064b60933f6f8af30ea','remark','备注',NULL,0,1,'string',500,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',10,'admin','2020-07-10 16:53:27','2020-05-08 23:45:32','admin','','','','','','text','0',NULL,NULL,'0'),('81ed9556c9fda1bbb46d94a53a6c90c7','402860816bff91c0016bff91c0cb0000','depart_name','部门名称','depart',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',7,'admin','2019-07-19 18:09:01','2019-07-17 18:54:32','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('82b7cb44c2097c89cfe9f0dcfa05a93b','133b01634f4a411593a94007dca75300','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-12-21 19:00:00','2020-11-13 16:09:31','admin','','','','','',NULL,'0',NULL,NULL,'0'),('8376eff8b825110b8af8e652c9ea853d','dac35da086cb46c29161ea8bb5e07109','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-11-09 15:00:30','2020-11-09 14:59:29','admin','','','','','',NULL,'0',NULL,NULL,'0'),('83d0a1a9950d49cf3f18703696dfcf77','9d0da12274fb494f922b6135b998721f','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-12-14 15:11:36','2020-11-09 15:17:57','admin','','','','','',NULL,'0',NULL,NULL,'0'),('840343a59a8e705821d393506c2bc1fe','402880e570a5d7000170a5d700f50000','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single',NULL,NULL,3,NULL,NULL,'2020-03-04 21:58:16','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('8422485e1cbf4455f9ded7d0af59379c','402860816bff91c0016bff91cfea0004','to_time','截止时间','to_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',4,'admin','2019-07-19 18:05:13','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('843244c1f4406933f1048a13f6eb6d82','5c58150ab99a4487bc5b4666f762962a','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-12-21 14:14:25','2020-11-13 15:35:09','admin','','','','','',NULL,'0',NULL,NULL,'0'),('845c70568d44a074f067d6d277950525','402860816bff91c0016bffa220a9000b','entrytime','入职时间','entrytime',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',23,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('8529ddaed8d5f3d9084e873203d55cac','402860816bff91c0016bffa220a9000b','marital_status','婚姻状况','marital_status',0,1,'string',20,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',24,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('857a0daa9cd8a058f2f15fc7c5fb3571','402860816bff91c0016bffa220a9000b','email','邮箱','email',0,1,'string',255,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',17,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('85e43fa87074845f86cf52606a23a57c','b81de38db24047b497d476516f8a0865','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,NULL,NULL,'2020-02-24 14:56:08','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('8652ca69a947fd4c961a3ac7c0fa252a','fb19fb067cd841f9ae93d4eb3b883dc0','create_by','创建人登录名称',NULL,0,1,'string',50,0,'','','','','text','',120,'','0','','',0,1,1,0,'single','','',1,NULL,NULL,'2019-03-23 11:39:48','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('86bbafef5683674a736cf7241c458d44','27fc5f91274344afa7673a732b279939','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2019-07-01 16:28:20','2019-07-01 16:26:42','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('86e0f3a8f31c60698157f139ed993954','402860816bff91c0016bffa220a9000b','having_reserve_funds','是否有公积金','having_reserve_funds',0,1,'string',20,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',33,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('86f29e9919766e0d1128263608c016a0','997ee931515a4620bc30a9c1246429a9','type_name','商品分类',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2020-05-03 00:57:44','2020-05-03 00:56:56','admin','','','','','','text','0',NULL,NULL,'0'),('8713070f8b42c1d8aa6fbb9f0cf62746','caa8de52a4dd4c2e909582709619fa7d','code','编码',NULL,0,1,'string',32,0,'','','','','text','',120,'only','1','','',0,1,1,0,'single','','',7,'admin','2020-12-14 15:02:32','2020-11-09 15:04:12','admin','','','','','','text','0',NULL,NULL,'0'),('873e2bb041b17bff77d3aca72900ea1b','56870166aba54ebfacb20ba6c770bd73','order_code','订单编码',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',6,'admin','2020-07-20 17:50:49','2019-04-20 11:38:39','admin','','','','','',NULL,'0',NULL,NULL,'0'),('8756fbb5c23a0258e029e0cb3c0a045c','402880e5721355dd01721355dd390000','price','价格',NULL,0,1,'double',10,3,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single',NULL,NULL,8,NULL,NULL,'2020-05-14 21:18:14','admin','','','','','','text','0',NULL,NULL,'0'),('8769f0ebe12e8583241971a06aef6d39','e033c8909649408ea5bb53e74f7fec7b','width','宽',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',15,'admin','2020-12-14 17:44:02','2020-11-10 08:40:30','admin','','','','','','text','0',NULL,NULL,'0'),('877391ae770a4ce2c95181ef410982ce','4028318169e81b970169e81b97650000','request_param','请求参数','request_param',0,1,'string',255,0,NULL,NULL,NULL,NULL,'text',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,10,NULL,NULL,'2019-04-04 19:28:36','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('878208bdfd88c1978ea8585495d3b7f4','2f03eb34ce95467e8a7f1388d49c18c8','loading_date','装柜日期',NULL,0,1,'Date',0,0,'','','','','date','',120,NULL,'1','','',1,1,1,0,'single','','',14,'admin','2021-01-07 21:29:54','2020-11-10 09:00:36','admin','','','','','','text','0',NULL,NULL,'0'),('87e82e3c723a6abb020122babdac6bd1','8994f2817b5a45d9890aa04497a317c5','create_by','创建人登录名称',NULL,0,1,'string',50,0,'','','','','text','',120,'','0','','',0,1,1,0,'single','','',1,NULL,NULL,'2019-03-23 11:39:16','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('87f7a2703c5850f0b063dd866d0e2917','402860816bff91c0016bffa220a9000b','birthday','出生日期','birthday',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',7,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('87fafe1a4a8a626e3875697574c19f15','402860816bff91c0016bff91d2810005','sys_org_code','组织机构编码','sys_org_code',0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',14,'admin','2019-07-19 18:05:55','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('8827ada0eb2812c03a3a1dea30d20775','6a56622058424a0e8bcc8b402ffc949d','address','公司地址',NULL,0,1,'string',32,0,'','','','','textarea','',120,NULL,'0','','',0,1,1,0,'single','','',11,'admin','2020-12-14 14:58:40','2020-11-09 14:35:45','admin','','','','','','text','0',NULL,NULL,'0'),('883265736ad6db0c98a7517d1f4a2488','402880eb71d52dc30171d52dc3a10000','main_id','主表ID',NULL,0,1,'String',200,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single',NULL,NULL,5,NULL,NULL,'2020-05-02 19:37:59','admin','','','','','',NULL,'0',NULL,NULL,'0'),('885b95e88a0ca814eee210695e2a6461','9d0da12274fb494f922b6135b998721f','kind','商品类别',NULL,0,1,'string',32,0,'','code','iost_kind','name','sel_search','',120,NULL,'0','','',1,1,1,0,'single','','',7,'admin','2020-12-14 15:11:36','2020-11-09 15:17:57','admin','','','name','code','iost_kind','sel_search','1',NULL,NULL,'0'),('88a12570e14c9f6f442e731ae5ad0eb1','beee191324fd40c1afec4fda18bd9d47','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2019-04-13 13:41:13','2019-04-13 13:40:56','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('88eebda6c6ff432038028f5cc2c72886','dd396a66386745c4993dc5c941c07a2e','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-12-30 15:42:30','2020-11-09 15:35:06','admin','','','','','',NULL,'0',NULL,NULL,'0'),('89370ae67e241fa5d1e47d22adeaca7b','402880eb71d52dc30171d52dc3a10000','date','日期',NULL,0,1,'string',200,0,'','','','','text','',120,NULL,'0','','#{date}',0,1,1,0,'single',NULL,NULL,4,NULL,NULL,'2020-05-02 19:37:58','admin','','','','','',NULL,'0',NULL,NULL,'0'),('89ab9eedbac6141e7a0df6d37a3655d0','e67d26b610dd414c884c4dbb24e71ce3','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2019-04-24 11:03:32','2019-04-24 11:02:57','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('8a24fb45e2af120c253c8b61c0085f7a','402860816bff91c0016bff91cda80003','sys_org_code','组织机构编码','sys_org_code',0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',13,'admin','2019-07-19 18:06:36','2019-07-17 18:54:34','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('8a2f97fde739720e86fbcd3ce311c037','09fd28e4b7184c1a9668496a5c496450','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-05-14 21:19:21','2020-05-08 23:51:49','admin','','','','','',NULL,'0',NULL,NULL,'0'),('8a6440c447ca97b1ceac40fa8576044e','3b5e18da618247539481816995b6bf9f','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-07-11 11:27:29','2020-07-11 11:27:17','admin','','','','','',NULL,'0',NULL,NULL,'0'),('8ac8a0c0087469a4e7579229ff17f273','e5464aa8fa7b47c580e91593cf9b46dc','jifen','合计积分',NULL,0,1,'int',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',10,'admin','2019-04-24 17:09:49','2019-04-24 11:05:10','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('8b82980cd7998a62fc12eddfbb10a470','506c10297a174bf39f4658da3462213b','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2021-01-01 22:30:01','2020-11-12 17:16:04','admin','','','','','',NULL,'0',NULL,NULL,'0'),('8b8413b40c091f225922e11e499225d6','e96d84a719654f6e9cc1d73c315b0ccc','picture','图片',NULL,0,1,'Blob',0,0,'','','','','image','',120,NULL,'0','','',0,1,1,1,'single','','',12,'admin','2020-12-16 19:19:09','2020-11-10 09:18:44','admin','','','','','','text','0',NULL,NULL,'0'),('8bc1e24cd6d83b43a296efabe9b49d4f','a3e23181b97e42a0a576df37ef7c68fc','telephone','联系电话',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',14,NULL,NULL,'2020-12-16 19:31:34','admin','','','','','','text','0',NULL,NULL,'0'),('8bd4deadc9e96c1a6d7abd77033105f6','e67d26b610dd414c884c4dbb24e71ce3','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2019-04-24 11:03:32','2019-04-24 11:02:57','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('8be043fdc79d2e4eb9615669d57baa81','caa8de52a4dd4c2e909582709619fa7d','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-12-14 15:02:32','2020-11-09 15:04:12','admin','','','','','',NULL,'0',NULL,NULL,'0'),('8c4d9fb845489ce195ea0beb593b8892','2f03eb34ce95467e8a7f1388d49c18c8','warehouse_name','仓库名称',NULL,0,1,'string',32,0,'','id','iost_storage','name','sel_search','',120,NULL,'1','','',0,1,1,0,'single','','',8,'admin','2021-01-07 21:29:54','2020-11-10 09:00:36','admin','','','','','','text','0',NULL,NULL,'0'),('8c50d404e286321a06956477105e841f','6a56622058424a0e8bcc8b402ffc949d','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-12-14 14:58:40','2020-11-09 14:35:45','admin','','','','','',NULL,'0',NULL,NULL,'0'),('8c6196e84165b90f11d081b6ce83c2be','e96d84a719654f6e9cc1d73c315b0ccc','source_entry_id','源单据体Id',NULL,0,1,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',31,'admin','2020-12-16 19:19:10','2020-12-07 14:47:43','admin','','','','','','text','0',NULL,NULL,'0'),('8c6518fec11fc4769ba4eb770c9e00f7','4028839a6de2ebd3016de2ebd3870000','integral_val','积分值','integral_val',0,1,'int',10,0,NULL,NULL,NULL,NULL,'text',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,11,NULL,NULL,'2019-10-19 15:29:30','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('8c960ed82ba23e19580307c0e9434de0','18f064d1ef424c93ba7a16148851664f','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-09-11 14:35:44','2020-05-12 20:26:01','admin','','','','','',NULL,'0',NULL,NULL,'0'),('8ca56210938fbe649f840e505eb9fd41','56870166aba54ebfacb20ba6c770bd73','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-07-20 17:50:49','2019-04-20 11:38:39','admin','','','','','',NULL,'0',NULL,NULL,'0'),('8ce610538131a5b95c1bbf0f10d73523','6bf0dccd4a2d4dd4b2e0be9ea32a3630','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2021-01-01 22:29:32','2020-11-12 17:18:41','admin','','','','','',NULL,'0',NULL,NULL,'0'),('8dc2a6b93e7770a7ba64b00856f25374','ca4136acdc61484c94913ba54c2ecaa8','volume','体积',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2020-11-16 15:27:24','2020-11-16 15:24:54','admin','','','','','','text','0',NULL,NULL,'0'),('8e080f4ded1e3b2a1daa5b11eca4a0ff','4adec929a6594108bef5b35ee9966e9f','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',7,'admin','2020-04-10 19:43:38','2020-04-10 19:35:58','admin','','','','','','text','0',NULL,NULL,'0'),('8e0960de938d02e9024eef9c5a812db2','8a75e88b8e554ee6942b114ccea6d5d9','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,NULL,NULL,'2020-11-26 17:31:49','admin','','','','','',NULL,'0',NULL,NULL,'0'),('8e1212df6a94ed8f5102a327564e5af6','8d66ea41c7cc4ef9ab3aab9055657fc9','name','分类名字',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,NULL,NULL,'2020-05-07 22:46:32','admin','','','','','','text','0',NULL,NULL,'0'),('8e131d4a438c907b3272474780be7603','402880eb71d52dc30171d52dc3a10000','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single',NULL,NULL,8,NULL,NULL,'2020-05-02 19:37:58','admin','','','','','','text','0',NULL,NULL,'0'),('8e1852d82a70cb2bb322fb6d680feb26','a3e23181b97e42a0a576df37ef7c68fc','customer_name','客户姓名',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',10,NULL,NULL,'2020-12-16 19:31:34','admin','','','','','','text','0',NULL,NULL,'0'),('8e1e4cb5c41ba685c48ebabf0aacc469','402880eb71d61d3d0171d61d3de30000','name','名称',NULL,0,1,'String',200,0,'','','','','text','',120,NULL,'0','','#{sysUserName}',0,1,0,0,'single','','',3,'admin','2020-05-03 00:54:16','2020-05-02 23:59:33','admin','','','','','',NULL,'0',NULL,NULL,'0'),('8e9ff8c411ea52131b024d404778516f','a3e23181b97e42a0a576df37ef7c68fc','date','入库日期',NULL,0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'single','','',15,NULL,NULL,'2020-12-16 19:31:34','admin','','','','','','text','0',NULL,NULL,'0'),('8ea43fd1e4ce82becee61b2f1e2e843f','32feeb502544416c9bf41329c10a88f4','sex','性别',NULL,0,1,'String',32,0,'','sex','','','list','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2019-08-23 20:03:40','2019-07-02 18:23:23','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('8ef00b1a3a5affb82091ffa206ac87af','506c10297a174bf39f4658da3462213b','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2021-01-01 22:30:01','2020-11-12 17:16:04','admin','','','','','',NULL,'0',NULL,NULL,'0'),('8ef3abac1a9ecc9efb8d43146bee547a','e033c8909649408ea5bb53e74f7fec7b','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-12-14 17:44:02','2020-11-10 08:36:39','admin','','','','','',NULL,'0',NULL,NULL,'0'),('8f1d302868640b72cef52171a023a203','e9faf717024b4aae95cff224ae9b6d97','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2019-07-03 18:23:49','2019-07-03 18:22:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('8f3e6fb68179c690f748f3c541fb50f1','7ea60a25fa27470e9080d6a921aabbd1','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,NULL,NULL,'2019-04-17 00:22:21','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('8fc0be84bed1216635c69af918e097ff','402860816aa5921f016aa5dedcb90009','name','并行会签标题','name',0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',6,'admin','2019-05-11 15:56:47','2019-05-11 15:50:08','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('909b3de0c8a48a21ef8cf98eb4831689','56efb74326e74064b60933f6f8af30ea','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-07-10 16:53:27','2020-05-08 23:45:32','admin','','','','','',NULL,'0',NULL,NULL,'0'),('90a822b8a63bbbc1e9575c9f4e21e021','d35109c3632c4952a19ecc094943dd71','descc','描述',NULL,0,1,'string',500,0,'','','','','textarea','',120,'','0','','',0,1,1,0,'single','','',9,'admin','2020-07-17 15:22:04','2019-03-15 14:24:35','admin','','','','','',NULL,'0',NULL,NULL,'0'),('90f39a6e29dae2e1fbb59d7d605f7c09','1acb6f81a1d9439da6cc4e868617b565','iz_valid','启用状态',NULL,0,1,'String',2,0,'','air_china_valid','','','list','',120,NULL,'0','','',0,1,1,0,'single','','',11,'admin','2019-06-10 14:47:14','2019-04-23 22:58:19','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('91191345ac0dbcc76cbc97df861c953d','6bf0dccd4a2d4dd4b2e0be9ea32a3630','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2021-01-01 22:29:32','2020-11-12 17:18:41','admin','','','','','',NULL,'0',NULL,NULL,'0'),('91be98b96dea1528abc943f9f131fd16','402880e570a5d7000170a5d700f50000','price','价格',NULL,0,1,'double',32,0,'','','','','text','',120,'n','0','','',0,1,1,0,'single',NULL,NULL,7,NULL,NULL,'2020-03-04 21:58:16','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('91f7cd9b59c0da033363f8a09b02ec96','3d447fa919b64f6883a834036c14aa67','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-02-21 17:58:46','2020-02-20 16:19:00','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('92065c827681e937a22398b5a6297904','133b01634f4a411593a94007dca75300','receiving_no','入仓号',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',13,'admin','2020-12-21 19:00:00','2020-11-13 16:13:56','admin','','','','','','text','0',NULL,NULL,'0'),('921cc5a92a79e1e21e9e631a1b7f3fbd','8d66ea41c7cc4ef9ab3aab9055657fc9','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,NULL,NULL,'2020-05-07 22:46:31','admin','','','','','',NULL,'0',NULL,NULL,'0'),('92731baef58757e2f55bff860bdf8c9e','47a79ec9f7f64c21aa55634bf619406d','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,NULL,NULL,'2020-11-16 15:21:22','admin','','','','','',NULL,'0',NULL,NULL,'0'),('930f3da133d3c1ee6ae1657026d15b83','a3e23181b97e42a0a576df37ef7c68fc','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,NULL,NULL,'2020-12-16 19:31:34','admin','','','','','',NULL,'0',NULL,NULL,'0'),('9341a3b2a734d8c73455c136e1cac8ad','4fb8e12a697f4d5bbe9b9fb1e9009486','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',8,'admin','2020-04-10 19:51:27','2020-04-10 19:47:01','admin','','','','','','text','0',NULL,NULL,'0'),('9370c9304af30b8d29defe0a5ada6e5b','62e29cdb81ac44d1a2d8ff89851b853d','DC_DDSA','DD',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',6,NULL,NULL,'2019-05-11 14:01:14','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('9371f61d39c5d57ddb0a2db96b2e2412','402860816bff91c0016bffa220a9000b','speciality','专业','speciality',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',15,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('9441f00d5f13decc92f90f043c1b2a6a','6a56622058424a0e8bcc8b402ffc949d','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-12-14 14:58:40','2020-11-09 14:35:45','admin','','','','','',NULL,'0',NULL,NULL,'0'),('947174892512ea97fafde899d427ea7e','402860816bff91c0016bff91c0cb0000','real_name','姓名','real_name',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',4,'admin','2019-07-19 18:09:01','2019-07-17 18:54:32','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('94799cef4c34890fbf36874d27820c61','2f03eb34ce95467e8a7f1388d49c18c8','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2021-01-07 21:29:54','2020-11-10 09:00:36','admin','','','','','',NULL,'0',NULL,NULL,'0'),('94b8bf435175cc545366e11992280757','32f75e4043ef4070919dbd4337186a3d','age','年龄',NULL,0,1,'int',32,0,'','','','','text','',120,NULL,'0','','',1,1,1,0,'group','','',7,'admin','2019-04-11 10:15:32','2019-03-27 15:54:49','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('94e682cb802777fe4205536888f69353','402860816bff91c0016bff91d2810005','create_by','创建人','create_by',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',10,'admin','2019-07-19 18:05:55','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('951c51699d728072d88196d30f7aad10','4adec929a6594108bef5b35ee9966e9f','address','地址',NULL,0,1,'String',200,0,'','','','','text','',120,NULL,'0','','{{ demoFieldDefVal_getAddress() }}',0,1,1,0,'single','','',5,'admin','2020-04-10 19:43:38','2020-04-10 19:35:58','admin','','','','','',NULL,'0',NULL,NULL,'0'),('952e06e40b0b64a80f3ac09ddd88c9aa','2f03eb34ce95467e8a7f1388d49c18c8','money_total','总金额',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'0','','',0,0,1,0,'single','','',13,'admin','2021-01-07 21:29:54','2020-12-22 14:41:29','admin','','','','','','text','0',NULL,NULL,'0'),('957386b500be42a200d6a56d54345392','deea5a8ec619460c9245ba85dbc59e80','num','数量',NULL,0,1,'int',32,0,'','','','','text','',120,'n','0','','',0,1,1,0,'single','','',8,'admin','2020-05-03 01:01:18','2019-04-20 11:41:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('959ca0a3f4f70bf306712c6dc5c6be9b','a3e23181b97e42a0a576df37ef7c68fc','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,NULL,NULL,'2020-12-16 19:31:34','admin','','','','','',NULL,'0',NULL,NULL,'0'),('95affb308bc9fbfc3c669cac7d5bc587','e033c8909649408ea5bb53e74f7fec7b','volume','单件体积',NULL,0,1,'double',10,3,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',17,'admin','2020-12-14 17:44:02','2020-11-10 08:40:30','admin','','','','','','text','0',NULL,NULL,'0'),('95d7a641f48a1ab03b83a7175d320c9f','a3e23181b97e42a0a576df37ef7c68fc','warehouse_name','仓库名称',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',9,NULL,NULL,'2020-12-16 19:31:34','admin','','','','','','text','0',NULL,NULL,'0'),('960d2847922b61dadeb3518ef55fb0c1','1acb6f81a1d9439da6cc4e868617b565','wl_name','物料名称',NULL,0,1,'String',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2019-06-10 14:47:14','2019-04-23 22:58:19','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('9665f02764774fdd77c19923d3ff3c3e','4028318169e81b970169e81b97650000','cost_time','耗时','cost_time',0,1,'string',19,0,NULL,NULL,NULL,NULL,'text',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,12,NULL,NULL,'2019-04-04 19:28:36','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('966a4988298d5cb0be47848735ce8cb7','4028839a6de2ebd3016de2ebd3870000','xg_shangxian','选购上限','xg_shangxian',0,1,'int',10,0,NULL,NULL,NULL,NULL,'text',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,12,NULL,NULL,'2019-10-19 15:29:30','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('9692a061797951dcebad06cb014f50d1','2f03eb34ce95467e8a7f1388d49c18c8','volume_totals','总体积',NULL,0,1,'double',10,3,'','','','','text','',120,NULL,'0','','',0,0,1,0,'single','','',10,'admin','2021-01-07 21:29:54','2020-12-21 14:56:48','admin','','','','','','date','1',NULL,NULL,'0'),('9698964a9e06edf12fc88df976080984','09fd28e4b7184c1a9668496a5c496450','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-05-14 21:19:21','2020-05-08 23:51:49','admin','','','','','',NULL,'0',NULL,NULL,'0'),('96a0017e7d10b9294a27079e4d21823a','6a56622058424a0e8bcc8b402ffc949d','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-12-14 14:58:40','2020-11-09 14:35:45','admin','','','','','',NULL,'0',NULL,NULL,'0'),('96c585a4f71e5c38ed25b9741366365b','402860816bff91c0016bff91c7010001','sys_org_code','组织机构编码','sys_org_code',0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',11,'admin','2019-07-19 18:07:47','2019-07-17 18:54:32','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('97209c7fee29211389eb1cd0af378fd5','d7b42c2262774ded8de4ab7dea6463a9','delivery_record_id','出库单Id',NULL,0,1,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',12,NULL,NULL,'2020-12-26 00:27:15','admin','','','','','','text','0',NULL,NULL,'0'),('975c910c83170a065b2433fe1b1f337f','9d0da12274fb494f922b6135b998721f','description','描述',NULL,0,1,'string',300,0,'','','','','textarea','',120,NULL,'0','','',1,1,1,0,'single','','',11,'admin','2020-12-14 15:11:36','2020-11-09 15:17:57','admin','','','','','','text','1',NULL,NULL,'0'),('9765efa2cafde6d0ede2215848c9e80b','32f75e4043ef4070919dbd4337186a3d','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',0,'admin','2019-04-11 10:15:32','2019-03-27 15:54:49','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('9835119b50170f82f2877e736637d40c','47a79ec9f7f64c21aa55634bf619406d','email','邮箱',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',12,NULL,NULL,'2020-11-16 15:21:22','admin','','','','','','text','0',NULL,NULL,'0'),('98e82cb1595609a3b42fa75c60ac1229','402860816bff91c0016bff91d2810005','update_by','更新人','update_by',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',12,'admin','2019-07-19 18:05:55','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('98f5702ea4c3a75a8a82bad890e99fc9','8a75e88b8e554ee6942b114ccea6d5d9','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,NULL,NULL,'2020-11-26 17:31:49','admin','','','','','',NULL,'0',NULL,NULL,'0'),('9914a0c84805e72c4b6075e36edb13f9','402860816aa5921f016aa5921f480000','create_time','创建时间','create_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,0,0,0,'group','','',9,'admin','2019-05-11 15:31:54','2019-05-11 14:26:19','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('9920ecec9c9109fc6b93e86f8fdfa03b','402860816bff91c0016bffa220a9000b','depart_name','所在部门','depart_name',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',1,1,1,0,'group','','',2,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('99560a5dbc21f8e075798c8fa428fd6e','f70eb6fe0df74c5eb04552f5c1a4b7b3','unit','单位',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2020-12-16 20:11:33','2020-12-16 19:34:19','admin','','','','','','text','0',NULL,NULL,'0'),('99b21ff5f1ca0a6d051d2fcf5c9ed133','e96d84a719654f6e9cc1d73c315b0ccc','note','备注',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',13,'admin','2020-12-16 19:19:09','2020-12-16 18:53:14','admin','','','','','','text','0',NULL,NULL,'0'),('99b43bbb23237815ebb74b12b4d7ea2f','62e29cdb81ac44d1a2d8ff89851b853d','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',1,NULL,NULL,'2019-05-11 14:01:14','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('99f44973148b736a1d17bd7188209f38','11c83901545e454192a300d427e7ad2c','height','高',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',18,'admin','2020-12-18 15:39:16','2020-11-09 15:52:10','admin','','','','','','text','0',NULL,NULL,'0'),('9a001eca1045a9c7b760940d09f36d44','a3e23181b97e42a0a576df37ef7c68fc','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,NULL,NULL,'2020-12-16 19:31:34','admin','','','','','',NULL,'0',NULL,NULL,'0'),('9a462d83210cad30f0e12b98e8a172a7','3b5e18da618247539481816995b6bf9f','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-07-11 11:27:29','2020-07-11 11:27:17','admin','','','','','',NULL,'0',NULL,NULL,'0'),('9a4dc8718000c30953a3923eb7db5096','402880eb71d52dc30171d52dc3a10000','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single',NULL,NULL,1,NULL,NULL,'2020-05-02 19:37:59','admin','','','','','',NULL,'0',NULL,NULL,'0'),('9a579c506f75f75baf88352a5eb2c249','1acb6f81a1d9439da6cc4e868617b565','bpm_status','流程状态',NULL,0,1,'String',2,0,'1','bpm_status','','','list','',120,NULL,'0','','',0,0,1,0,'single','','',16,'admin','2019-06-10 14:47:14','2019-05-07 16:54:43','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('9a706cceb38b83d7761979b82ee7c650','6a56622058424a0e8bcc8b402ffc949d','name_eng','客户英文名称',NULL,0,0,'string',32,0,'','','','','text','',120,NULL,'1','','',1,1,1,0,'single','','',8,'admin','2020-12-14 14:58:40','2020-11-09 14:35:45','admin','','','','','','text','1',NULL,NULL,'0'),('9a9516645cbc8147b23333fea76aa2bb','b81de38db24047b497d476516f8a0865','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,NULL,NULL,'2020-02-24 14:56:08','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('9aa10f28bf1a52d33b2e3a5cc40cc672','dd396a66386745c4993dc5c941c07a2e','customer_code','客户编码',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'1','','',1,1,1,0,'single','','',13,'admin','2020-12-30 15:42:31','2020-11-09 15:35:06','admin','','','','','','text','1',NULL,NULL,'0'),('9aa6738443d3d8a67cf50506199d15ad','cb2d8534a2f544bc9c618dd49da66336','aaae','aae',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',8,NULL,NULL,'2020-02-24 17:22:43','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('9b20d4b86a76cf44030d9f7ad6c873db','e033c8909649408ea5bb53e74f7fec7b','length','长',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',14,'admin','2020-12-14 17:44:02','2020-11-10 08:36:39','admin','','','','','','text','0',NULL,NULL,'0'),('9b2b68934ae5d32c82d835ff6d5be24b','61328d3127024a9b99298eded991106c','warehouse_name','仓库名称',NULL,0,1,'string',32,0,'','id','iost_storage','name','sel_search','',120,NULL,'0','','',1,1,1,0,'single','','',7,'admin','2020-12-26 18:13:52','2020-11-10 08:19:09','admin','','','name','id','iost_storage','sel_search','1',NULL,NULL,'0'),('9bd056786694d67666f6924cc225b1a0','3d447fa919b64f6883a834036c14aa67','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',1,'admin','2020-02-21 17:58:46','2020-02-20 16:19:00','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('9c40fb4db8afed3c682c6b8a732fd69d','e2faf977fdaf4b25a524f58c2441a51c','post','用户岗位',NULL,0,1,'String',32,0,'','post_code','air_china_post_materiel_main','post_name','sel_search','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2019-06-10 17:27:00','2019-04-24 17:12:11','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('9c80599f8ac6b38c50e0a87998da12b6','caa8de52a4dd4c2e909582709619fa7d','name','商品类别',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'1','','',0,1,1,0,'single','','',8,'admin','2020-12-14 15:02:32','2020-11-09 15:04:12','admin','','','','','','text','0',NULL,NULL,'0'),('9ca79cf315c3d2fae53c6f7f4a068567','47a79ec9f7f64c21aa55634bf619406d','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,NULL,NULL,'2020-11-16 15:21:22','admin','','','','','',NULL,'0',NULL,NULL,'0'),('9cbf0e959d9eeb1e792a26092351f17f','47a79ec9f7f64c21aa55634bf619406d','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,NULL,NULL,'2020-11-16 15:21:22','admin','','','','','',NULL,'0',NULL,NULL,'0'),('9cc60be30026301b9eafb8c310387f54','402880e570a5d7000170a5d700f50000','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single',NULL,NULL,4,NULL,NULL,'2020-03-04 21:58:16','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('9ce96d812c432e69ee0085c629f14823','a3e23181b97e42a0a576df37ef7c68fc','delivery_factory','送货厂家',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',8,NULL,NULL,'2020-12-16 19:31:34','admin','','','','','','text','0',NULL,NULL,'0'),('9ceff249ef81ca6fa145456667c89051','4adec929a6594108bef5b35ee9966e9f','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',8,'admin','2020-04-10 19:43:38','2020-04-10 19:35:58','admin','','','','','','text','0',NULL,NULL,'0'),('9d85bafa399f28a40e1de1eeef747223','4028318169e81b970169e81b97650000','ip','IP','ip',0,1,'string',100,0,NULL,NULL,NULL,NULL,'text',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,7,NULL,NULL,'2019-04-04 19:28:36','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('9d89ff1a019f41d80307652041490944','32feeb502544416c9bf41329c10a88f4','name','请假人',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2019-08-23 20:03:40','2019-07-02 18:23:23','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('9e50680eb4e79b3af352a5933d239dff','dbf4675875e14676a3f9a8b2b8941140','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',1,NULL,NULL,'2019-05-27 18:02:07','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('9e8490bc355bf727a3bff55942ae4e8e','61328d3127024a9b99298eded991106c','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-12-26 18:13:52','2020-11-10 08:19:09','admin','','','','','',NULL,'0',NULL,NULL,'0'),('9ea97c8bf625a20145d908263bdd1abe','2f03eb34ce95467e8a7f1388d49c18c8','delivery_record_pics','送货单图片',NULL,0,1,'Blob',0,0,'','','','','image','',120,NULL,'0','','',0,0,0,0,'single','','',15,'admin','2021-01-07 21:29:54','2021-01-07 20:03:26','admin','','','','','','text','0',NULL,NULL,'0'),('9ec6c73432e57354d7d55dbea0916776','18f064d1ef424c93ba7a16148851664f','name','用户名',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','#{sysUserCode}',0,1,1,0,'single','','',7,'admin','2020-09-11 14:35:44','2020-05-12 20:26:01','admin','','','','','','text','0',NULL,NULL,'1'),('9f1da51fc585262b59567c0da5280674','f79dbb25b30c4357a334db84a0e24a55','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2021-01-08 11:48:00','2021-01-08 11:15:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('9fca4efd504f605040e5b983671fc554','f70eb6fe0df74c5eb04552f5c1a4b7b3','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-12-16 20:11:33','2020-12-16 19:34:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('a01a7fe5660206e6f407ed98b6c732d6','402860816bff91c0016bff91cfea0004','phone','联系方式','phone',0,1,'string',20,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',7,'admin','2019-07-19 18:05:13','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('a0e8241f4787d6f6cceb1c98ed71b229','1952937614c54c54a3653d97c4765cf3','weight','Weight(kg)',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',14,'admin','2020-12-24 17:26:34','2020-11-16 15:53:19','admin','','','','','','text','0',NULL,NULL,'0'),('a1a2d49b35c185df9f9e149b290aa277','56efb74326e74064b60933f6f8af30ea','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-07-10 16:53:27','2020-05-08 23:45:32','admin','','','','','',NULL,'0',NULL,NULL,'0'),('a1f5daba36f536e7acf6a939826183b0','fb19fb067cd841f9ae93d4eb3b883dc0','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,'','0','','',0,1,1,0,'single','','',0,NULL,NULL,'2019-03-23 11:39:48','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('a20036647136ded5d8d6c8e053dfd499','f3071ca217274b6892238c4b60e1f177','packages','箱数',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',11,'admin','2020-12-21 14:49:28','2020-11-16 10:39:30','admin','','','','','','text','0',NULL,NULL,'0'),('a232d608434d15fcecd8a3f31a9044b2','86bf17839a904636b7ed96201b2fa6ea','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-05-14 21:18:49','2020-05-08 23:48:31','admin','','','','','',NULL,'0',NULL,NULL,'0'),('a2439e3733cc5176e37aa3921944e7da','11c83901545e454192a300d427e7ad2c','length','长',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',16,'admin','2020-12-18 15:39:16','2020-11-09 15:52:10','admin','','','','','','text','0',NULL,NULL,'0'),('a29056b85ac2aaed8c7da163b10b12ec','e033c8909649408ea5bb53e74f7fec7b','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-12-14 17:44:02','2020-11-10 08:36:39','admin','','','','','',NULL,'0',NULL,NULL,'0'),('a29a72227325ee185adad245398d6490','e033c8909649408ea5bb53e74f7fec7b','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-12-14 17:44:02','2020-11-10 08:36:39','admin','','','','','',NULL,'0',NULL,NULL,'0'),('a3311686859df0537e2f1ccd2d51521c','f3071ca217274b6892238c4b60e1f177','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-12-21 14:49:28','2020-11-16 10:39:30','admin','','','','','',NULL,'0',NULL,NULL,'0'),('a3a56493e363ba5547eca615eb663c68','11c83901545e454192a300d427e7ad2c','material','材质',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',23,'admin','2020-12-18 15:39:16','2020-11-09 15:52:10','admin','','','','','','text','0',NULL,NULL,'0'),('a3dea64c8009780e213d16c69704c030','53a3e82b54b946c2b904f605875a275c','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-05-08 23:42:51','2020-05-07 22:49:47','admin','','','','','',NULL,'0',NULL,NULL,'0'),('a45eba33810c485b9d8e6f70818a1dfa','402860816aa5921f016aa5921f480000','bpm_status','流程状态','bpm_status',0,1,'string',50,0,'1','bpm_status','','','text','',120,NULL,'0','','',0,0,1,0,'group','','',7,'admin','2019-05-11 15:31:54','2019-05-11 14:26:19','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('a4af70ec4dbd986271ac9b1af350fac1','5c58150ab99a4487bc5b4666f762962a','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-12-21 14:14:25','2020-11-13 15:35:09','admin','','','','','',NULL,'0',NULL,NULL,'0'),('a526e1a285b13e345b0b6e96a377f7d2','dd396a66386745c4993dc5c941c07a2e','warehouse_name','仓库名称',NULL,0,1,'string',32,0,'','id','iost_storage','name','sel_search','',120,NULL,'1','','',1,1,1,0,'single','','',9,'admin','2020-12-30 15:42:31','2020-11-09 15:35:06','admin','','','name','id','iost_storage','sel_search','1',NULL,NULL,'0'),('a6471d4fb3dbffef01dab1f7d452bb30','27fc5f91274344afa7673a732b279939','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2019-07-01 16:28:20','2019-07-01 16:26:42','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('a6722b498602d7d7b5177b16789d8cc1','e5464aa8fa7b47c580e91593cf9b46dc','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2019-04-24 17:09:48','2019-04-24 11:05:10','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('a694efd57a64693dedfe5388666c2746','1952937614c54c54a3653d97c4765cf3','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-12-24 17:26:34','2020-11-16 15:53:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('a6e7f3653a0ca1f19a2eb3f14452fcbf','9d0da12274fb494f922b6135b998721f','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-12-14 15:11:36','2020-11-09 15:17:57','admin','','','','','',NULL,'0',NULL,NULL,'0'),('a76004dad4f1310f56051a6dfcf0cc10','e033c8909649408ea5bb53e74f7fec7b','packages_total','总装箱数',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',13,'admin','2020-12-14 17:44:02','2020-11-10 08:36:39','admin','','','','','','text','0',NULL,NULL,'0'),('a76f561057ac9e43a8ca09e478a1eab8','402860816bff91c0016bff91ca7e0002','update_time','更新时间','update_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',12,'admin','2019-07-19 18:07:13','2019-07-17 18:54:33','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('a7822f6e4cffb37fc0729cbd4cfd8655','32f75e4043ef4070919dbd4337186a3d','name','用户名',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',1,1,1,0,'single','','',5,'admin','2019-04-11 10:15:32','2019-03-27 15:54:49','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('a7b6ae09441ce36a14c7ce95f17a218e','86bf17839a904636b7ed96201b2fa6ea','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-05-14 21:18:49','2020-05-08 23:48:31','admin','','','','','',NULL,'0',NULL,NULL,'0'),('a82ca42a76e9d2b8dae6d57dbb5edb54','deea5a8ec619460c9245ba85dbc59e80','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-05-03 01:01:18','2019-04-20 11:41:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('a83c029e021023771f646a20b63c4d4b','18f064d1ef424c93ba7a16148851664f','sel_search','下拉搜索',NULL,0,1,'string',32,0,'','username','sys_user','username','sel_search','',120,NULL,'0','','',0,1,1,0,'single','','',12,'admin','2020-09-11 14:35:44','2020-05-12 20:26:01','admin','','','','','','text','0',NULL,NULL,'0'),('a8cf46a7b3ef7cfecaf74e82a2220724','f70eb6fe0df74c5eb04552f5c1a4b7b3','price','单价',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',19,'admin','2020-12-16 20:11:33','2020-12-16 20:08:14','admin','','','','','','text','0',NULL,NULL,'0'),('a8f8f6ae207c2dbf917677b69c8d41e5','e96d84a719654f6e9cc1d73c315b0ccc','material','材质',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,1,'single','','',26,'admin','2020-12-16 19:19:09','2020-11-10 09:30:14','admin','','','','','','text','0',NULL,NULL,'0'),('a940adc4585fa3b5bd2114ea9abe8491','402860816bff91c0016bff91ca7e0002','cert_level','证书级别','cert_level',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',5,'admin','2019-07-19 18:07:13','2019-07-17 18:54:33','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('a94f1d7da64f3aa35c32155ea00ccb2f','402860816bff91c0016bffa220a9000b','id','id','id',1,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'group','','',1,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('a9780eace237a15f26931dd6a9ec02e9','758334cb1e7445e2822b60e807aec4a3','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,NULL,NULL,'2019-10-18 18:02:09','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('a97f61a7dd2a816063c53ca9fc847b94','ca4136acdc61484c94913ba54c2ecaa8','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-11-16 15:27:24','2020-11-16 15:24:54','admin','','','','','',NULL,'0',NULL,NULL,'0'),('aa07931514727913413880b7a2b76dcb','d3ae1c692b9640e0a091f8c46e17bb01','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,NULL,NULL,'2019-07-24 14:47:30','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('aa324bddd61a17a3a27bc04e3b6a4675','dac35da086cb46c29161ea8bb5e07109','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-11-09 15:00:30','2020-11-09 14:59:29','admin','','','','','',NULL,'0',NULL,NULL,'0'),('aa4780601419c21dabb6c42fc511e71c','402860816bff91c0016bffa220a9000b','have_children','有无子女','have_children',0,1,'string',20,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',25,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('aaab40b19df8808cf87245720dcf67f5','1952937614c54c54a3653d97c4765cf3','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-12-24 17:26:34','2020-11-16 15:53:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('ab10e0aa029ded2f4420a33420de225d','1acb6f81a1d9439da6cc4e868617b565','wl_code','物料编码',NULL,0,1,'String',60,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',6,'admin','2019-06-10 14:47:14','2019-04-23 22:58:19','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('ab1f880ba593f3757dac70e003945aa2','402860816bff91c0016bff91c0cb0000','depart_id','部门ID',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',6,'admin','2019-07-19 18:09:01','2019-07-17 19:38:45','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('ab58f43f853fd1f65f83c22966883afb','beee191324fd40c1afec4fda18bd9d47','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2019-04-13 13:41:13','2019-04-13 13:40:56','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('ab8e6f1cca421c5ce395a2c1fdfd2100','32feeb502544416c9bf41329c10a88f4','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2019-08-23 20:03:40','2019-07-02 18:23:23','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('abcb2849ddd7cf5276dab0ade9f905c4','e96d84a719654f6e9cc1d73c315b0ccc','name_chs','商品中文名称',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,1,'single','','',10,'admin','2020-12-16 19:19:09','2020-11-10 09:18:44','admin','','','','','','text','0',NULL,NULL,'0'),('abe61a8ddf966a979457b763329a537b','e5464aa8fa7b47c580e91593cf9b46dc','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2019-04-24 17:09:49','2019-04-24 11:05:10','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('ac20ae61913b2ed084f8dd7aa08e1751','dd396a66386745c4993dc5c941c07a2e','customer_name','客户姓名',NULL,0,1,'string',32,0,'','name_chs,code','custome_list','customer_name,customer_code','popup','',120,NULL,'1','','',0,1,1,0,'single','','',10,'admin','2020-12-30 15:42:31','2020-11-09 15:35:06','admin','','','','','','text','0',NULL,NULL,'0'),('ac91565da5fb8fe43a4da3dec660b25f','402860816bff91c0016bff91c7010001','award_place','获奖地点','award_place',0,1,'string',255,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',4,'admin','2019-07-19 18:07:47','2019-07-17 18:54:32','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('acbbadf1e2ad1130fe33acf925c1b283','ca4136acdc61484c94913ba54c2ecaa8','packages','箱数',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',10,'admin','2020-11-16 15:27:24','2020-11-16 15:24:54','admin','','','','','','text','0',NULL,NULL,'0'),('acff5c8aef3b6288b87fd91215012206','e5464aa8fa7b47c580e91593cf9b46dc','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2019-04-24 17:09:49','2019-04-24 11:05:10','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('ad061417d5b53c67975eb83657505218','73162c3b8161413e8ecdca7eb288d0c9','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2019-07-01 14:23:32','2019-06-10 15:18:34','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('ad568f194a26a7d71c95d52f70d05138','2f03eb34ce95467e8a7f1388d49c18c8','packages_totals','总箱数',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,0,1,0,'single','','',11,'admin','2021-01-07 21:29:54','2020-12-21 14:56:48','admin','','','','','','text','0',NULL,NULL,'0'),('ad93762c6c4a1dd8331e5fa11215b568','e2faf977fdaf4b25a524f58c2441a51c','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',1,'admin','2019-06-10 17:27:00','2019-04-24 17:12:11','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('ae31da96f38fc2941cb93d1bb1ab9431','deea5a8ec619460c9245ba85dbc59e80','product_name','产品名字',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',6,'admin','2020-05-03 01:01:18','2019-04-20 11:41:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('ae77bb317366622698c8ab9bf2325833','deea5a8ec619460c9245ba85dbc59e80','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-05-03 01:01:18','2019-04-20 11:41:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('af0fe0df8b626129de62e22212732517','402860816bff91c0016bff91cda80003','speciality','专业','speciality',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',6,'admin','2019-07-19 18:06:36','2019-07-17 18:54:34','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('af6c582b902e2f2bf9930eba61ae7938','73162c3b8161413e8ecdca7eb288d0c9','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2019-07-01 14:23:32','2019-06-10 15:18:34','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('afb8e73e09c0abc1ad18ea5dc1934566','e96d84a719654f6e9cc1d73c315b0ccc','packages','单件装箱数',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,1,'single','','',16,'admin','2020-12-16 19:19:09','2020-11-10 09:26:23','admin','','','','','','text','0',NULL,NULL,'0'),('afd3ef1d494a9b69d2c7a3cdde937f6f','402860816bff91c0016bffa220a9000b','create_by','创建人','create_by',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',39,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('b01304904babd7479de2acfe8a77157f','402860816aa5921f016aa5921f480000','id','ID','id',1,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'group','','',1,'admin','2019-05-11 15:31:54','2019-05-11 14:26:19','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('b05b4cbb74f389a7376f51ed9fd97030','402860816bff91c0016bff91d8830007','create_by','创建人','create_by',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',10,'admin','2019-07-19 18:04:41','2019-07-17 18:54:37','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('b061f23c6886d6ebb0a3ae433845bb09','1952937614c54c54a3653d97c4765cf3','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-12-24 17:26:34','2020-11-16 15:53:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('b0a06bdbefd304d81a1838d8d94deda9','4b556f0168f64976a3d20bfb932bc798','name','用户名',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',6,NULL,NULL,'2019-04-12 23:38:28','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('b0b1cf271dd6b221a902da2d2f8f889a','e9faf717024b4aae95cff224ae9b6d97','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2019-07-03 18:23:49','2019-07-03 18:22:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('b0f46441c6309d357e2e640556d1282d','5c58150ab99a4487bc5b4666f762962a','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-12-21 14:14:25','2020-11-13 15:35:09','admin','','','','','',NULL,'0',NULL,NULL,'0'),('b133faac5236f49594da0624854185c8','618957ffac7940ffa8db258799585671','delivery_record_id','出库单Id',NULL,0,1,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',12,'admin','2021-01-07 20:02:09','2020-12-26 00:27:56','admin','','','','','','text','0',NULL,NULL,'0'),('b172cf8ea3be7a231141f317c6ca6a1d','11c83901545e454192a300d427e7ad2c','price','单价',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'1','','',0,1,1,0,'single','','',24,'admin','2020-12-18 15:39:16','2020-11-09 15:52:10','admin','','','','','','text','0',NULL,NULL,'0'),('b18f96f96d979daa7336e81086ea2bc1','cb2d8534a2f544bc9c618dd49da66336','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-02-24 17:22:42','2020-02-24 15:15:14','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('b19a8ab6848d8748cecce1c9e820bab5','6a56622058424a0e8bcc8b402ffc949d','code','客户编码',NULL,0,0,'string',32,0,'','','','','text','',120,NULL,'0','','',1,1,1,0,'single','','',10,'admin','2020-12-14 14:58:40','2020-11-09 14:35:45','admin','','','','','','text','1',NULL,NULL,'0'),('b19b96342be529ed23652566bd80f083','133b01634f4a411593a94007dca75300','volume','体积',NULL,0,1,'double',10,3,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2020-12-21 19:00:00','2020-11-13 16:13:56','admin','','','','','','text','0',NULL,NULL,'0'),('b1a985179470c2c8088e31769ef8dc81','5c58150ab99a4487bc5b4666f762962a','money_total','总金额',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',13,'admin','2020-12-21 14:14:25','2020-11-13 15:35:09','admin','','','','','','text','0',NULL,NULL,'0'),('b1fc6e2ca671b19e57b08a4f57fc2454','fb7125a344a649b990c12949945cb6c1','update_time','更新日期',NULL,0,1,'date',20,0,'','','','','text','',120,'','0','','',0,0,0,0,'single','','',4,'admin','2019-03-26 19:24:11','2019-03-26 19:01:52','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('b22694cf34ffb967b8717647816ad5df','e5464aa8fa7b47c580e91593cf9b46dc','fk_id','外键',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','air_china_post_materiel_main','id',15,'admin','2019-04-24 17:09:49','2019-04-24 11:05:10','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('b261e763ee344208d7900477e3edcb8b','133b01634f4a411593a94007dca75300','customer_name','客户名称',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2020-12-21 19:00:00','2020-11-13 16:13:56','admin','','','','','','text','0',NULL,NULL,'0'),('b276facab025f9750b0aff391693cc4b','402860816bff91c0016bff91c7010001','id','id','id',1,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'group','','',1,'admin','2019-07-19 18:07:47','2019-07-17 18:54:32','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('b28a92f827dfdc3cc1b6b074ebe854bc','38b8d95658a74899b7dc02e63e199af6','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-12-14 14:53:53','2020-11-09 14:23:45','admin','','','','','',NULL,'0',NULL,NULL,'0'),('b2b0cb30159639bb1190e150322b7541','4028839a6de2ebd3016de2ebd3870000','wl_unit','计量单位','wl_unit',0,1,'string',100,0,NULL,NULL,NULL,NULL,'text',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,14,NULL,NULL,'2019-10-19 15:29:30','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('b2bac56302653b40e029ed74a7f5ea1c','2f03eb34ce95467e8a7f1388d49c18c8','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2021-01-07 21:29:54','2020-11-10 09:00:36','admin','','','','','',NULL,'0',NULL,NULL,'0'),('b317c451d596bd53f5a6ca50962999f6','6a56622058424a0e8bcc8b402ffc949d','vat','VAT号',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',14,'admin','2020-12-14 14:58:40','2020-11-09 14:35:45','admin','','','','','','text','0',NULL,NULL,'0'),('b3542d3e7908ed885ecc4ba9e7300705','4b556f0168f64976a3d20bfb932bc798','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,NULL,NULL,'2019-04-12 23:38:28','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('b3b61f9386eb2262919e0835e3c82eb9','86bf17839a904636b7ed96201b2fa6ea','num','数量',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2020-05-14 21:18:49','2020-05-08 23:48:31','admin','','','','','','text','0',NULL,NULL,'0'),('b42877852d0c3ab1fe9f65f462c596e9','f70eb6fe0df74c5eb04552f5c1a4b7b3','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-12-16 20:11:33','2020-12-16 19:34:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('b47af4d937e55c6208939bac5378bfad','62e29cdb81ac44d1a2d8ff89851b853d','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,NULL,NULL,'2019-05-11 14:01:14','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('b53203fc52d067bb4730dbcb7e496bd3','56870166aba54ebfacb20ba6c770bd73','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',1,'admin','2020-07-20 17:50:49','2019-04-20 11:38:39','admin','','','','','',NULL,'0',NULL,NULL,'0'),('b573eb8827de032bbe712697f5560826','dd396a66386745c4993dc5c941c07a2e','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-12-30 15:42:31','2020-11-09 15:35:06','admin','','','','','',NULL,'0',NULL,NULL,'0'),('b58ab4d2b899e1183a6b587a1f7c689b','61328d3127024a9b99298eded991106c','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-12-26 18:13:52','2020-11-10 08:19:09','admin','','','','','',NULL,'0',NULL,NULL,'0'),('b5cfd3c9691a884430f3d9cd5ecb211f','e2faf977fdaf4b25a524f58c2441a51c','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2019-06-10 17:27:00','2019-04-24 17:12:11','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('b61760afb67edb43fad806c30d65f523','5c58150ab99a4487bc5b4666f762962a','bulk_no','散货柜编号',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2020-12-21 14:14:25','2020-11-13 15:35:09','admin','','','','','','text','0',NULL,NULL,'0'),('b6874a05734cad8bd96ffd2f31f1ebca','402860816bff91c0016bff91c7010001','create_by','创建人','create_by',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',7,'admin','2019-07-19 18:07:47','2019-07-17 18:54:32','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('b70ceb0ad94790d749201753ec55f159','9d0da12274fb494f922b6135b998721f','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-12-14 15:11:36','2020-11-09 15:17:57','admin','','','','','',NULL,'0',NULL,NULL,'0'),('b733fa73519603b22d401fabbf9e9781','402860816bff91c0016bff91c0cb0000','hiredate','入职时间','hiredate',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',5,'admin','2019-07-19 18:09:01','2019-07-17 18:54:32','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('b74201fd4eb951c4e3ede98909fbc3a3','11c83901545e454192a300d427e7ad2c','weight_total','总重量',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'1','','',0,1,1,0,'single','','',22,'admin','2020-12-18 15:39:16','2020-11-09 15:52:10','admin','','','','','','text','0',NULL,NULL,'0'),('b7938e4518f9062ce62702cf45986e06','e2faf977fdaf4b25a524f58c2441a51c','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2019-06-10 17:27:00','2019-04-24 17:12:11','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('b7a1243aaa712e2c152c0c7a46f88683','402860816bff91c0016bff91d8830007','age','年龄','age',0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',5,'admin','2019-07-19 18:04:41','2019-07-17 18:54:37','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('b7b311cf4483bd10a93a40891cc39a77','8d66ea41c7cc4ef9ab3aab9055657fc9','has_child','是否有子节点',NULL,0,1,'string',3,0,'','yn','','','list','',120,NULL,'0','','',0,0,0,0,'single','','',11,NULL,NULL,'2020-05-07 22:46:32','admin','','','','','','text','0',NULL,NULL,'0'),('b84395f31ba4d08215c7a85c5af95307','e033c8909649408ea5bb53e74f7fec7b','weight','单件箱重',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',19,'admin','2020-12-14 17:44:02','2020-11-10 08:40:30','admin','','','','','','text','0',NULL,NULL,'0'),('b8e1ac22d09c57f1c3066b53fd89736d','8a75e88b8e554ee6942b114ccea6d5d9','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,NULL,NULL,'2020-11-26 17:31:49','admin','','','','','',NULL,'0',NULL,NULL,'0'),('b9008cba98c8160e5da8cd231f1ea4d4','ca4136acdc61484c94913ba54c2ecaa8','price','价格',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',11,'admin','2020-11-16 15:27:24','2020-11-16 15:24:54','admin','','','','','','text','0',NULL,NULL,'0'),('b91258e3dc15b28c2e3f0d934e6e27e8','fb7125a344a649b990c12949945cb6c1','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,'','0','','',0,1,1,0,'single','','',0,NULL,NULL,'2019-03-26 19:01:52','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('b92572ae142f8dd5f2ac02fb45e6b2c1','e2faf977fdaf4b25a524f58c2441a51c','name','用户名',NULL,0,1,'String',32,0,'','realname,username','report_user','name,account','sel_search','',120,NULL,'0','','',0,1,1,0,'single','','',6,'admin','2019-06-10 17:27:00','2019-04-24 17:12:11','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('b988b3b4509325c9f88a3f5233682ba1','6bf0dccd4a2d4dd4b2e0be9ea32a3630','deliverstatus_id','deliverstatus_id',NULL,0,1,'string',36,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',9,NULL,NULL,'2021-01-01 22:29:32','admin','','','','','','text','0',NULL,NULL,'0'),('b9fbace24688c9c9a8c9be72c1d014e7','402860816bff91c0016bffa220a9000b','phone','电话','phone',0,1,'string',20,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',18,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('ba3821d265f14d12bb18a5ba235da93a','e96d84a719654f6e9cc1d73c315b0ccc','weight','箱重',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'0','','',0,1,1,1,'single','','',24,'admin','2020-12-16 19:19:09','2020-11-10 09:30:14','admin','','','','','','text','0',NULL,NULL,'0'),('ba5f4b2affa94f36eda7f6f133db7ae3','402860816bff91c0016bff91d2810005','workplace','工作单位','workplace',0,1,'string',255,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',6,'admin','2019-07-19 18:05:55','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('ba6158180cd4cc0f8a962dfd3e080837','2f03eb34ce95467e8a7f1388d49c18c8','bulk_no','散货柜编号',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'1','','',1,1,1,0,'single','','',7,'admin','2021-01-07 21:29:54','2020-11-10 09:00:36','admin','','','','','','text','1',NULL,NULL,'0'),('ba6f3e762d6e3ea1068a085ec2f7e501','56efb74326e74064b60933f6f8af30ea','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-07-10 16:53:27','2020-05-08 23:45:32','admin','','','','','',NULL,'0',NULL,NULL,'0'),('bad02e68ea37bf387337516af84a1ddb','73162c3b8161413e8ecdca7eb288d0c9','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',1,'admin','2019-07-01 14:23:32','2019-06-10 15:18:34','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('bb44475e1d1738a19745bf9f3ebf9e40','402860816bff91c0016bff91cfea0004','update_time','更新时间','update_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',12,'admin','2019-07-19 18:05:13','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('bbbb38347b1a5340a1d293e455c632ce','fb19fb067cd841f9ae93d4eb3b883dc0','3','4',NULL,0,1,'string',32,0,'','','','','text','',120,'','0','','',0,1,1,0,'single','','',6,NULL,NULL,'2019-03-23 11:39:48','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('bbf6386a0f419e17fa60cb950335fbea','d31c1fde7b9e41e7bec8a108381b5874','warehouse_name','仓库名称',NULL,0,1,'string',32,0,'','id','iost_storage','name','sel_search','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2020-12-30 14:52:11','2020-12-21 11:06:00','admin','','','','','','text','0',NULL,NULL,'0'),('bc648624ad14c826bbc6e9b23a2b9858','402860816bff91c0016bff91ca7e0002','employee_id','员工ID','employee_id',0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','oa_employee_info','id',2,'admin','2019-07-19 18:07:13','2019-07-17 18:54:33','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('bc793fdbef9f6474425456c4eb9d197a','402860816bff91c0016bff91cfea0004','witness','证明人','references',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',6,'admin','2019-07-19 18:05:13','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('bc7df6f3cf49f670c36a3de25e25e715','402860816bff91c0016bff91d2810005','order_no','序号','order_no',0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',9,'admin','2019-07-19 18:05:55','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('bc9552a1cba6024b5b52ac7f35686f87','d7b42c2262774ded8de4ab7dea6463a9','create_time','日期',NULL,0,1,'Date',20,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'single','','',11,'admin','2020-12-26 00:27:15','2020-11-16 10:35:13','admin','','','','','','text','0',NULL,NULL,'0'),('bcf2f5d1390227cf0d9ddfbd6121161f','402880eb71d61d3d0171d61d3de30000','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-05-03 00:54:16','2020-05-02 23:59:33','admin','','','','','',NULL,'0',NULL,NULL,'0'),('bd39cb237049ac60218b3f4dd844f30c','402860816bff91c0016bffa220a9000b','current_address','现居住地','current_address',0,1,'string',200,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',30,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('bd3ddba9aff84771d8ca55305ac92981','618957ffac7940ffa8db258799585671','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2021-01-07 20:02:08','2020-11-16 15:43:36','admin','','','','','',NULL,'0',NULL,NULL,'0'),('bd4ae7101db3e94760b200d00bbbd5bd','e96d84a719654f6e9cc1d73c315b0ccc','receiving_no','入仓号',NULL,0,1,'string',32,0,'','receiving_no,customer_name,name_chs,name_eng,kind,picture,note,unit,cases,packages,packages_total,length,width,height,volume,volume_total,weight,weight_total,material,price,money,source_id,source_entry_id','iost_delivery_record','receiving_no,customer_name,name_chs,name_eng,kind,picture,note,unit,cases,packages,packages_total,length,width,height,volume,volume_total,weight,weight_total,material,price,money,source_id,source_entry_id','popup','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2020-12-16 19:19:09','2020-11-10 09:18:44','admin','','','','','','text','0',NULL,NULL,'0'),('bd620c876ab074dc88cb038da2f732d7','e96d84a719654f6e9cc1d73c315b0ccc','volume','单件体积',NULL,0,1,'double',10,3,'','','','','text','',120,NULL,'0','','',0,1,1,1,'single','','',22,'admin','2020-12-16 19:19:09','2020-11-10 09:30:14','admin','','','','','','text','0',NULL,NULL,'0'),('bdcf897c03e54c97cf5c211512962514','dac35da086cb46c29161ea8bb5e07109','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-11-09 15:00:30','2020-11-09 14:59:29','admin','','','','','',NULL,'0',NULL,NULL,'0'),('bde81809057b1a4c974fa0f090501fdd','402860816aa5921f016aa5dedcb90009','update_by','更新人','update_by',0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'group','','',4,'admin','2019-05-11 15:56:47','2019-05-11 15:50:08','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('bdea5b776a15897265c43e6ee44af2e1','997ee931515a4620bc30a9c1246429a9','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-05-03 00:57:44','2020-05-03 00:56:56','admin','','','','','',NULL,'0',NULL,NULL,'0'),('bded91862477c393cc4713c52613b43c','d31c1fde7b9e41e7bec8a108381b5874','delivery_record_id','出库单Id',NULL,0,1,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',11,'admin','2020-12-30 14:52:11','2020-12-23 11:46:12','admin','','','','','','text','0',NULL,NULL,'0'),('be3f8c157d8a1b40e6f7b836552a8095','8994f2817b5a45d9890aa04497a317c5','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','text','',120,'','0','','',0,1,1,0,'single','','',2,NULL,NULL,'2019-03-23 11:39:16','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('be5eeda7d51dace73d3818bd8467b53b','402860816bff91c0016bff91c0cb0000','update_time','更新时间','update_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',15,'admin','2019-07-19 18:09:01','2019-07-17 18:54:32','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('be868eed386da3cfcf49ea9afcdadf11','d35109c3632c4952a19ecc094943dd71','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','text','',120,'','0','','',0,0,0,0,'single','','',3,'admin','2020-07-17 15:22:04','2019-03-15 14:24:35','admin','','','','','',NULL,'0',NULL,NULL,'0'),('bec3082fc5f0f194be5cd72cc2866ff4','e5464aa8fa7b47c580e91593cf9b46dc','wl_name','物料名字',NULL,0,1,'String',200,0,'','wl_code','air_china_materiel','wl_name','list','',120,NULL,'0','','',0,1,1,0,'single','','',6,'admin','2019-04-24 17:09:49','2019-04-24 11:05:10','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('bed0bc67f570613eaa6a1bd8bcaaddcc','4b556f0168f64976a3d20bfb932bc798','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,NULL,NULL,'2019-04-12 23:38:28','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('bed95ca6dd6bb4b4f7cfd787313a0a4b','402880e570a5d7000170a5d700f50000','product_name','产品名字',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single',NULL,NULL,6,NULL,NULL,'2020-03-04 21:58:16','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('bef85fd2846dd7ffc42d747095557d14','4fb8e12a697f4d5bbe9b9fb1e9009486','date','日期',NULL,0,1,'string',200,0,'','','','','text','',120,NULL,'0','','#{date}',0,1,1,0,'single','','',4,'admin','2020-04-10 19:51:27','2020-04-10 19:47:01','admin','','','','','',NULL,'0',NULL,NULL,'0'),('bf61aa04c5ca77ad54c764f8f8b2bdec','402860816bff91c0016bff91d8830007','update_by','更新人','update_by',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',12,'admin','2019-07-19 18:04:41','2019-07-17 18:54:37','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('bfc2f19fae367f885adb8bd82a344391','4028318169e81b970169e81b97650000','userid','操作用户账号','userid',0,1,'string',32,0,NULL,NULL,NULL,NULL,'text',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,5,NULL,NULL,'2019-04-04 19:28:36','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('c026dd16a8f4fc984ac1c39b13eac800','dac35da086cb46c29161ea8bb5e07109','address','送货地址',NULL,0,1,'string',300,0,'','','','','text','',300,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2020-11-09 15:00:30','2020-11-09 14:59:29','admin','','','','','','text','0',NULL,NULL,'0'),('c047ed2cead5bab0307967435f370936','53a3e82b54b946c2b904f605875a275c','chuc_date','出厂时间',NULL,0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2020-05-08 23:42:51','2020-05-07 22:49:47','admin','','','','','','text','0',NULL,NULL,'0'),('c0c80f370e1d400fe670d8702c3b84da','4adec929a6594108bef5b35ee9966e9f','address_param','地址（传参）',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','{{ demoFieldDefVal_getAddress(\"昌平区\") }}',0,1,1,0,'single','','',6,'admin','2020-04-10 19:43:38','2020-04-10 19:40:53','admin','','','','','',NULL,'0',NULL,NULL,'0'),('c0d66c95773774e7ac1f2a88df307e7a','402860816aa5921f016aa5921f480000','reason','请假原因','reason',0,1,'string',500,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',6,'admin','2019-05-11 15:31:54','2019-05-11 14:26:19','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('c0ee8c388628dcf587e6439ff7231978','f79dbb25b30c4357a334db84a0e24a55','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2021-01-08 11:48:00','2021-01-08 11:15:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('c29216d975fee50af175bca8c664a475','e67d26b610dd414c884c4dbb24e71ce3','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',1,'admin','2019-04-24 11:03:32','2019-04-24 11:02:56','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('c2b9eae184afe56d59ea7940d77cfced','4adec929a6594108bef5b35ee9966e9f','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-04-10 19:43:38','2020-04-10 19:35:57','admin','','','','','',NULL,'0',NULL,NULL,'0'),('c2dbb6846ab0945a430d095a29e0f53d','18f064d1ef424c93ba7a16148851664f','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-09-11 14:35:44','2020-05-12 20:26:01','admin','','','','','',NULL,'0',NULL,NULL,'0'),('c306d146a851c39bb880ac3b5ab93ddc','f70eb6fe0df74c5eb04552f5c1a4b7b3','packages_total','总装箱数',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',12,'admin','2020-12-16 20:11:33','2020-12-16 20:08:14','admin','','','','','','text','0',NULL,NULL,'0'),('c30aa7c8dd477f692547329a5b2b39b7','618957ffac7940ffa8db258799585671','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2021-01-07 20:02:08','2020-11-16 15:43:36','admin','','','','','',NULL,'0',NULL,NULL,'0'),('c36bcc4d33ea4fa44d7caa5d315b1729','dac35da086cb46c29161ea8bb5e07109','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-11-09 15:00:30','2020-11-09 14:59:29','admin','','','','','',NULL,'0',NULL,NULL,'0'),('c382877700a9987f4bcc2deea9ee9daf','4fb8e12a697f4d5bbe9b9fb1e9009486','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-04-10 19:51:27','2020-04-10 19:47:01','admin','','','','','',NULL,'0',NULL,NULL,'0'),('c43d87b6340c29c0c354aa9c579f387f','32feeb502544416c9bf41329c10a88f4','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2019-08-23 20:03:40','2019-07-02 18:23:23','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('c456753a9c83e55fa241c4ec72c00f86','402880eb71d52dc30171d52dc3a10000','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single',NULL,NULL,6,NULL,NULL,'2020-05-02 19:37:58','admin','','','','','',NULL,'0',NULL,NULL,'0'),('c4ba99c5a9b419519769543eb5405132','618957ffac7940ffa8db258799585671','contact_name','Contact Name',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',6,'admin','2021-01-07 20:02:08','2020-11-16 15:43:36','admin','','','','','','text','0',NULL,NULL,'0'),('c4d71528f3f45661b1a87841b7256204','402880e5721355dd01721355dd390000','order_main_id','订单ID',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single',NULL,NULL,11,NULL,NULL,'2020-05-14 21:18:14','admin','','','','','','text','0',NULL,NULL,'0'),('c5134a2eafd4106ac3d99f100d7e2db2','dd396a66386745c4993dc5c941c07a2e','telephone','联系电话',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'1','','',0,1,1,0,'single','','',14,'admin','2020-12-30 15:42:31','2020-11-09 15:35:06','admin','','','','','','text','0',NULL,NULL,'0'),('c52711856d2e81ad1074265833f44328','b81de38db24047b497d476516f8a0865','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,NULL,NULL,'2020-02-24 14:56:07','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('c5520a906730b7dc831591b1c43c1a50','e96d84a719654f6e9cc1d73c315b0ccc','name_eng','商品英文名称',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,1,'single','','',11,'admin','2020-12-16 19:19:09','2020-11-10 09:18:44','admin','','','','','','text','0',NULL,NULL,'0'),('c59f39e7b3bb877398f16796b2cd7962','997ee931515a4620bc30a9c1246429a9','pid','父级节点',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,0,0,'single','','',9,'admin','2020-05-03 00:57:44','2020-05-03 00:56:56','admin','','','','','','text','0',NULL,NULL,'0'),('c5a61724b3b1fdfd0eb39c361f22bafd','8d66ea41c7cc4ef9ab3aab9055657fc9','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,NULL,NULL,'2020-05-07 22:46:32','admin','','','','','',NULL,'0',NULL,NULL,'0'),('c5dd2fc34ae825ebfced2ec74948654c','402860816aa5921f016aa5921f480000','end_date','请假结束时间','end_date',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',5,'admin','2019-05-11 15:31:54','2019-05-11 14:26:19','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('c5f6ea01a6523a60df153cc61dc92f4d','fbc35f067da94a70adb622ddba259352','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,NULL,NULL,'2019-07-03 19:44:23','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('c6024742fbc62f2fc39992e6b59ac13d','05a3a30dada7411c9109306aa4117068','age','年龄',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',1,1,1,0,'group','','',8,'admin','2020-05-12 22:39:41','2020-05-06 11:34:31','admin','','','','','','text','0',NULL,NULL,'1'),('c61eaef737e40b8b14219f760ce0131a','11c83901545e454192a300d427e7ad2c','volume_total','总体积',NULL,0,1,'double',10,3,'','','','','text','',120,NULL,'1','','',0,1,1,0,'single','','',20,'admin','2020-12-18 15:39:16','2020-11-09 15:52:10','admin','','','','','','text','0',NULL,NULL,'0'),('c6730e00df5efd77fedf181df29102de','402860816bff91c0016bff91c7010001','update_by','更新人','update_by',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',9,'admin','2019-07-19 18:07:47','2019-07-17 18:54:32','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('c6b0f35ce3703ea01cdc62aec661b426','2f03eb34ce95467e8a7f1388d49c18c8','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2021-01-07 21:29:54','2020-11-10 09:00:36','admin','','','','','',NULL,'0',NULL,NULL,'0'),('c6cb7257d38365199dd568f46f58b950','61328d3127024a9b99298eded991106c','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-12-26 18:13:52','2020-11-10 08:19:09','admin','','','','','',NULL,'0',NULL,NULL,'0'),('c73e0b84da85f07f4cf2b2ead2f1e893','d7b42c2262774ded8de4ab7dea6463a9','customer_name','客户姓名',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2020-12-26 00:27:15','2020-11-16 10:35:13','admin','','','','','','text','0',NULL,NULL,'0'),('c75a7cb0a21958aa7ca5442f66019669','e9faf717024b4aae95cff224ae9b6d97','depart','所属部门',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2019-07-03 18:23:49','2019-07-03 18:22:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('c772ed9cbe2d1dc69e9ffa73d3487021','4b556f0168f64976a3d20bfb932bc798','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',1,NULL,NULL,'2019-04-12 23:38:28','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('c7a4a6a796cfe7d77089f7c897c9943f','a3c6f1140f7e447eb5bdb26898181fba','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-11-26 16:35:41','2020-11-26 16:17:55','admin','','','','','',NULL,'0',NULL,NULL,'0'),('c7ddcb90f45a6727beb8980fda46d827','f70eb6fe0df74c5eb04552f5c1a4b7b3','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-12-16 20:11:33','2020-12-16 19:34:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('c8027cf4f2483042445c89ba86c4e51f','402880e5721355dd01721355dd390000','zong_price','单品总价',NULL,0,1,'double',10,3,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single',NULL,NULL,10,NULL,NULL,'2020-05-14 21:18:14','admin','','','','','','text','0',NULL,NULL,'0'),('c87309d3a655e8d1da2fbc247f60f167','11c83901545e454192a300d427e7ad2c','name_eng','商品英文名称',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2020-12-18 15:39:16','2020-11-09 15:52:10','admin','','','','','','text','0',NULL,NULL,'0'),('c8cf8f2a8e8aebb5e40567ee0aa2be8c','e96d84a719654f6e9cc1d73c315b0ccc','unit','单位',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,1,'single','','',14,'admin','2020-12-16 19:19:09','2020-11-10 09:18:44','admin','','','','','','text','0',NULL,NULL,'0'),('c91b697b1bcd2be943fc746e2660bc9e','402860816bff91c0016bff91d2810005','real_name','姓名','real_name',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',3,'admin','2019-07-19 18:05:55','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('c988bd2b6125c01ceb3579a207dd8784','3d447fa919b64f6883a834036c14aa67','city','市',NULL,0,1,'String',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',3,'admin','2020-02-21 17:58:46','2020-02-20 16:19:00','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('c9b698d3f75aa780ee1eb67ef090b15b','73162c3b8161413e8ecdca7eb288d0c9','wl_code','物料编码',NULL,0,1,'String',200,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2019-07-01 14:23:32','2019-06-10 15:18:34','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('caf5a071f2299c0f9ff2f3038d6d0fc6','402860816bff91c0016bff91ca7e0002','update_by','更新人','update_by',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',11,'admin','2019-07-19 18:07:13','2019-07-17 18:54:33','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('cb0f4f06119e5f3bfa4c2440050a5358','d7b42c2262774ded8de4ab7dea6463a9','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-12-26 00:27:15','2020-11-16 10:35:13','admin','','','','','',NULL,'0',NULL,NULL,'0'),('cb33a708b95e19085f8c9001d2d5c64c','e9faf717024b4aae95cff224ae9b6d97','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2019-07-03 18:23:49','2019-07-03 18:22:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('cb50a5991ca29e617aa32e49e92c01e7','09fd28e4b7184c1a9668496a5c496450','age','年龄',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',10,'admin','2020-05-14 21:19:21','2020-05-08 23:51:49','admin','','','','','','text','0',NULL,NULL,'0'),('cb7da49a981a1b0acc5f7e8a0130bdcd','d35109c3632c4952a19ecc094943dd71','user_code','用户编码',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,0,0,'single','','',11,'admin','2020-07-17 15:22:04','2019-05-11 16:26:37','admin','','','','','',NULL,'0',NULL,NULL,'0'),('cb871284e845e26e88242a96fac9c576','402860816bff91c0016bff91c7010001','order_no','序号','order_no',0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',6,'admin','2019-07-19 18:07:47','2019-07-17 18:54:32','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('cbac2deebc0f64bdcba90b5995ac8f2f','506c10297a174bf39f4658da3462213b','bulk_no','散货柜编号',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2021-01-01 22:30:01','2020-11-12 17:16:04','admin','','','','','','text','0',NULL,NULL,'0'),('cc1ddc1304d3eb5d9a189da0a509ccd0','32f75e4043ef4070919dbd4337186a3d','create_by','创建人登录名称',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',1,'admin','2019-04-11 10:15:32','2019-03-27 15:54:49','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('cc373733a85ccf3a4aa2c8996bbd0da5','6a56622058424a0e8bcc8b402ffc949d','email','邮箱',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',13,'admin','2020-12-14 14:58:40','2020-11-09 14:35:45','admin','','','','','','text','0',NULL,NULL,'0'),('ccc849bce794d64b6ec15e437924939d','11c83901545e454192a300d427e7ad2c','unit','单位',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'1','','',0,1,1,0,'single','','',12,'admin','2020-12-18 15:39:16','2020-11-09 15:52:10','admin','','','','','','text','0',NULL,NULL,'0'),('ccda49a8cea079c34f0034361d058c08','09fd28e4b7184c1a9668496a5c496450','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-05-14 21:19:21','2020-05-08 23:51:49','admin','','','','','',NULL,'0',NULL,NULL,'0'),('ccf2f331af46ddc411b8039dd187621b','4028839a6de2ebd3016de2ebd3870000','price','单价','price',0,1,'double',10,2,NULL,NULL,NULL,NULL,'text',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,10,NULL,NULL,'2019-10-19 15:29:30','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('cd1dab1846db464d538491bfa22f0e49','61328d3127024a9b99298eded991106c','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-12-26 18:13:52','2020-11-10 08:19:09','admin','','','','','',NULL,'0',NULL,NULL,'0'),('cdde53e4f69b79ce322ac55139b6175b','e96d84a719654f6e9cc1d73c315b0ccc','source_id','源Id',NULL,0,1,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',30,'admin','2020-12-16 19:19:10','2020-12-07 14:47:43','admin','','','','','','text','0',NULL,NULL,'0'),('ce74d5f17e2ce14764eba8e5683d8917','133b01634f4a411593a94007dca75300','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-12-21 19:00:00','2020-11-13 16:09:31','admin','','','','','',NULL,'0',NULL,NULL,'0'),('cec943936781b1a336b936c53a7dfce4','a3c6f1140f7e447eb5bdb26898181fba','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-11-26 16:35:41','2020-11-26 16:17:55','admin','','','','','',NULL,'0',NULL,NULL,'0'),('cee3c1dbf67b4a7d9626b8032897a4c7','402860816bff91c0016bff91d8830007','employee_id','员工ID','employee_id',0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','oa_employee_info','id',2,'admin','2019-07-19 18:04:41','2019-07-17 18:54:37','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('cefb82e2168ab7e3aa57a7e9c3ca950e','09fd28e4b7184c1a9668496a5c496450','order_main_id','订单ID',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','ces_order_main','id',12,'admin','2020-05-14 21:19:21','2020-05-08 23:51:49','admin','','','','','','text','0',NULL,NULL,'0'),('cf0d439cde05029ae02e11205c2f1fd5','caa8de52a4dd4c2e909582709619fa7d','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-12-14 15:02:32','2020-11-09 15:04:12','admin','','','','','',NULL,'0',NULL,NULL,'0'),('cf12d08220a40ab4944cab9eb0b36e8a','61328d3127024a9b99298eded991106c','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-12-26 18:13:52','2020-11-10 08:19:09','admin','','','','','',NULL,'0',NULL,NULL,'0'),('cf4c5a4c06ae6bac701edfeedfcd16aa','d3ae1c692b9640e0a091f8c46e17bb01','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',1,NULL,NULL,'2019-07-24 14:47:30','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('cf5dfcb4ccedec473a513414dbd243ef','18f064d1ef424c93ba7a16148851664f','ddd','DD类型',NULL,0,1,'double',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',20,'admin','2020-09-11 14:35:44','2020-07-20 15:07:27','admin','','','','','','text','0',NULL,NULL,'0'),('cfeb6491427aec2b4db9694af867da23','e9faf717024b4aae95cff224ae9b6d97','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2019-07-03 18:23:49','2019-07-03 18:22:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('d03de96037dea16ca5beabc55666cfbf','11c83901545e454192a300d427e7ad2c','packages_total','总装箱数',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'1','','',0,1,1,0,'single','','',15,'admin','2020-12-18 15:39:16','2020-11-09 15:52:10','admin','','','','','','text','0',NULL,NULL,'0'),('d0559db07f05c870860f98313eb0f857','cb2d8534a2f544bc9c618dd49da66336','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-02-24 17:22:42','2020-02-24 15:15:14','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('d0d1be336726df9c41f2173f8886ba35','997ee931515a4620bc30a9c1246429a9','has_child','是否有子节点',NULL,0,1,'string',3,0,'','yn','','','list','',120,NULL,'0','','',0,0,0,0,'single','','',10,'admin','2020-05-03 00:57:44','2020-05-03 00:56:56','admin','','','','','','text','0',NULL,NULL,'0'),('d14e47befe47925b1440d584f4ca56fc','09fd28e4b7184c1a9668496a5c496450','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-05-14 21:19:21','2020-05-08 23:51:49','admin','','','','','',NULL,'0',NULL,NULL,'0'),('d207c1b42475e20cbc1d9010a47a51c2','f3071ca217274b6892238c4b60e1f177','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-12-21 14:49:28','2020-11-16 10:39:30','admin','','','','','',NULL,'0',NULL,NULL,'0'),('d2551b70dc96a45a73b304bf755a996f','402860816bff91c0016bff91d8830007','workplace','工作单位','workplace',0,1,'string',255,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',6,'admin','2019-07-19 18:04:41','2019-07-17 18:54:37','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('d26570452032e2a24eef7007b4be993d','11c83901545e454192a300d427e7ad2c','money','金额',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'1','','',0,1,1,0,'single','','',25,'admin','2020-12-18 15:39:16','2020-11-09 15:52:10','admin','','','','','','text','0',NULL,NULL,'0'),('d2991853f343af26716f6fc7c4ad3206','e033c8909649408ea5bb53e74f7fec7b','picture','图片',NULL,0,1,'string',32,0,'','','','','image','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2020-12-14 17:44:02','2020-11-10 08:36:39','admin','','','','','','text','0',NULL,NULL,'0'),('d29dcdba14ea61808391fff2d927efea','402860816bff91c0016bff91c0cb0000','work_summary','工作总结','work_summary',0,1,'Text',65535,0,'','','','','textarea','',120,NULL,'0','','',0,1,1,0,'group','','',10,'admin','2019-07-19 18:09:01','2019-07-17 18:54:32','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('d2ed43d612dceac54d22858b0e080c53','5c58150ab99a4487bc5b4666f762962a','container_no','货柜号',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2020-12-21 14:14:25','2020-11-13 15:35:09','admin','','','','','','text','0',NULL,NULL,'0'),('d3a701472d27ca8435d6a781a597038d','deea5a8ec619460c9245ba85dbc59e80','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-05-03 01:01:18','2019-04-20 11:41:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('d3ba5f990e14f9a1a0bbf6aa4cfa26dc','56efb74326e74064b60933f6f8af30ea','xd_date','下单时间',NULL,0,1,'Date',0,0,'','','','','datetime','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2020-07-10 16:53:27','2020-05-08 23:45:32','admin','','','','','','text','0',NULL,NULL,'0'),('d44b89cc5f1828f7ceb9be196d549665','4fb8e12a697f4d5bbe9b9fb1e9009486','code','编码',NULL,0,1,'String',200,0,'','','','','text','',120,NULL,'0','','${order_num_rule_param}',0,1,1,0,'single','','',2,'admin','2020-04-10 19:51:27','2020-04-10 19:47:01','admin','','','','','',NULL,'0',NULL,NULL,'0'),('d48bfd2a840f9b1d00bd3b5599dca0f0','402860816bff91c0016bff91cda80003','post','职务','post',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',7,'admin','2019-07-19 18:06:36','2019-07-17 18:54:34','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('d4d8cae3cd9ea93e378fc14303eee105','d35109c3632c4952a19ecc094943dd71','create_by','创建人登录名称',NULL,0,1,'string',50,0,'','','','','text','',120,'','0','','',0,0,0,0,'single','','',2,'admin','2020-07-17 15:22:04','2019-03-15 14:24:35','admin','','','','','',NULL,'0',NULL,NULL,'0'),('d4dea775487aef5a7aea41791d3a65db','e5464aa8fa7b47c580e91593cf9b46dc','cycle_time','发放周期(年)',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',11,'admin','2019-04-24 17:09:49','2019-04-24 14:09:06','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('d4f713050dd41d9d20a2fc392cf9b9b8','1952937614c54c54a3653d97c4765cf3','ctns','CTNS',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2020-12-24 17:26:34','2020-11-16 15:53:19','admin','','','','','','text','0',NULL,NULL,'0'),('d52c79620e21128fb69b4e8628cf25cc','dbf4675875e14676a3f9a8b2b8941140','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,NULL,NULL,'2019-05-27 18:02:07','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('d530ab1bc3c51e8249a506a25d1003c7','79091e8277c744158530321513119c68','start_time','会签发起时间',NULL,0,1,'Date',32,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2019-05-11 15:29:47','2019-05-11 15:27:17','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('d53e70411c206efecb8dcd00174e907c','62e29cdb81ac44d1a2d8ff89851b853d','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,NULL,NULL,'2019-05-11 14:01:14','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('d5dbf7955e61a8337ee4e323b771684a','e033c8909649408ea5bb53e74f7fec7b','name_eng','商品英文名称',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2020-12-14 17:44:02','2020-11-10 08:36:39','admin','','','','','','text','0',NULL,NULL,'0'),('d5df0a35352ee960053686e959e9084b','1acb6f81a1d9439da6cc4e868617b565','wl_unit','计量单位',NULL,0,1,'String',100,0,'','air_china_unit','','','list_multi','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2019-06-10 14:47:14','2019-04-23 22:58:19','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('d64ef4cd8b06d97b09cfbb3627605f0f','f3071ca217274b6892238c4b60e1f177','weight','重量',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',10,'admin','2020-12-21 14:49:28','2020-11-16 10:39:30','admin','','','','','','text','0',NULL,NULL,'0'),('d6fad89f4f26d733291863c2dfbc5945','27fc5f91274344afa7673a732b279939','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',1,'admin','2019-07-01 16:28:20','2019-07-01 16:26:42','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('d6fb7dcec9256d4044199641cb823e5e','18f064d1ef424c93ba7a16148851664f','sex','下拉框',NULL,0,1,'string',32,0,'','sex','','','list','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2020-09-11 14:35:44','2020-05-12 20:26:01','admin','','','','','','text','0',NULL,NULL,'1'),('d7082454dac60103fdda3e00b6557d39','402880eb71d52dc30171d52dc3a10000','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single',NULL,NULL,9,NULL,NULL,'2020-05-02 19:37:58','admin','','','','','','text','0',NULL,NULL,'0'),('d766ea5809e2ec9ff2cdbcb18f610ab3','7ea60a25fa27470e9080d6a921aabbd1','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',1,NULL,NULL,'2019-04-17 00:22:21','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('d7c3b107f004cbc99dfe1fe6c79894d8','402860816bff91c0016bffa220a9000b','social_insurance_type','参加社保类型','social_insurance_type',0,1,'string',255,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',35,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('d7d05f57a4bb44edf8b55c8e3f42b472','5c58150ab99a4487bc5b4666f762962a','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-12-21 14:14:25','2020-11-13 15:35:09','admin','','','','','',NULL,'0',NULL,NULL,'0'),('d8234b56acea1a752271a6c911dd91a0','7ea60a25fa27470e9080d6a921aabbd1','age','年龄',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,NULL,NULL,'2019-04-17 00:22:21','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('d86909d794b01ad7fbb5e61d28b6603b','73162c3b8161413e8ecdca7eb288d0c9','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2019-07-01 14:23:32','2019-06-10 15:18:34','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('d8a91b26189b84b02347876286e9dc61','d7b42c2262774ded8de4ab7dea6463a9','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-12-26 00:27:14','2020-11-16 10:35:13','admin','','','','','',NULL,'0',NULL,NULL,'0'),('d949d9157831c2fb7ba9f175081fe036','402860816bff91c0016bff91cda80003','school','学校','school',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',5,'admin','2019-07-19 18:06:36','2019-07-17 18:54:34','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('d9832ab61b90c8725bc42b1e685b53ea','6a56622058424a0e8bcc8b402ffc949d','telephone','联系电话',NULL,0,0,'string',32,0,'','','','','text','',120,NULL,'1','','',0,1,1,0,'single','','',12,'admin','2020-12-14 14:58:40','2020-11-09 14:35:45','admin','','','','','','text','0',NULL,NULL,'0'),('d9d308feb95968dbb322c9bff0c18452','32feeb502544416c9bf41329c10a88f4','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2019-08-23 20:03:40','2019-07-02 18:23:23','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('d9dde2f59bb148c6b7e95256acad8972','e67d26b610dd414c884c4dbb24e71ce3','post_name','岗位名字',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2019-04-24 11:03:32','2019-04-24 11:02:57','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('d9f9ae6986cb85019a3a4030f62f4d1a','402860816bff91c0016bff91cfea0004','employee_id','员工ID','employee_id',0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','oa_employee_info','id',2,'admin','2019-07-19 18:05:13','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('da493b7c7a61f5f9a403d92905d2c55c','f3071ca217274b6892238c4b60e1f177','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-12-21 14:49:28','2020-11-16 10:39:30','admin','','','','','',NULL,'0',NULL,NULL,'0'),('dab1637219f72d331ac63c51cfa62174','2f03eb34ce95467e8a7f1388d49c18c8','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2021-01-07 21:29:54','2020-11-10 09:00:36','admin','','','','','',NULL,'0',NULL,NULL,'0'),('db1fb3e12385cb967b63420cfe97cde6','402860816bff91c0016bff91cda80003','employee_id','员工ID','employee_id',0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','oa_employee_info','id',2,'admin','2019-07-19 18:06:36','2019-07-17 18:54:34','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('db7d393432318fbf7898045b7ed085fd','e033c8909649408ea5bb53e74f7fec7b','height','高',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',16,'admin','2020-12-14 17:44:02','2020-11-10 08:40:30','admin','','','','','','text','0',NULL,NULL,'0'),('dba3517234b9ad67bc3056ce519ed87c','f3071ca217274b6892238c4b60e1f177','receiving_note_id','收费单id',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','iost_receiving_note','id',14,'admin','2020-12-21 14:49:28','2020-11-16 10:40:26','admin','','','','','','text','0',NULL,NULL,'0'),('dc2bec862a4f0d600751c632d246f0ed','4028839a6de2ebd3016de2ebd3870000','update_time','更新日期','update_time',0,1,'Date',0,0,NULL,NULL,NULL,NULL,'date',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,5,NULL,NULL,'2019-10-19 15:29:30','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('dc4f27f71ab6944372a70296c15a5dee','ca4136acdc61484c94913ba54c2ecaa8','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-11-16 15:27:24','2020-11-16 15:24:54','admin','','','','','',NULL,'0',NULL,NULL,'0'),('dd3e1e13d7429807b83a00a090e060b7','402860816bff91c0016bffa220a9000b','join_party_info','入党（团）时间地点','join_party_info',0,1,'string',255,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',26,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('ddc302f84c75a5f056855c664b82202a','402860816aa5921f016aa5921f480000','days','请假天数','days',0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',3,'admin','2019-05-11 15:31:54','2019-05-11 14:26:19','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('ddcc14a2105588982b4ae657f2893d81','32feeb502544416c9bf41329c10a88f4','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',1,'admin','2019-08-23 20:03:40','2019-07-02 18:23:23','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('de2de0610336dca6929ac85c1e8ec791','a3c6f1140f7e447eb5bdb26898181fba','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-11-26 16:35:41','2020-11-26 16:17:55','admin','','','','','',NULL,'0',NULL,NULL,'0'),('de34e46a66def956437635585db427b7','cb2d8534a2f544bc9c618dd49da66336','dde','ee',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',10,NULL,NULL,'2020-02-24 17:22:43','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('de4be91868f8148b916ea9409063cf90','e033c8909649408ea5bb53e74f7fec7b','weight_total','总重量',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',20,'admin','2020-12-14 17:44:02','2020-11-10 08:40:30','admin','','','','','','text','0',NULL,NULL,'0'),('de55ddb60cb55a109c7da592b86d49f0','1952937614c54c54a3653d97c4765cf3','width','Width',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',10,'admin','2020-12-24 17:26:34','2020-12-24 17:24:37','admin','','','','','','text','0',NULL,NULL,'0'),('de8c5721ae5ac15cc20e0ef893c05703','a3e23181b97e42a0a576df37ef7c68fc','cases_total','总件数',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',12,NULL,NULL,'2020-12-16 19:31:34','admin','','','','','','text','0',NULL,NULL,'0'),('de8f510d358f499dcd966e97708f82d4','997ee931515a4620bc30a9c1246429a9','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-05-03 00:57:44','2020-05-03 00:56:56','admin','','','','','',NULL,'0',NULL,NULL,'0'),('ded19a50a6f622f252a6440fab073063','8a75e88b8e554ee6942b114ccea6d5d9','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,NULL,NULL,'2020-11-26 17:31:49','admin','','','','','',NULL,'0',NULL,NULL,'0'),('dedb920a5e876e27eb144464209ebe1e','27fc5f91274344afa7673a732b279939','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2019-07-01 16:28:20','2019-07-01 16:26:42','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('df489194c6008f3bd21b2c1c11fde337','fb19fb067cd841f9ae93d4eb3b883dc0','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','text','',120,'','0','','',0,1,1,0,'single','','',2,NULL,NULL,'2019-03-23 11:39:48','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('df4c5e8411c102f02a6fe6727e858d55','997ee931515a4620bc30a9c1246429a9','pic','分类图片',NULL,0,1,'string',500,0,'','','','','image','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2020-05-03 00:57:44','2020-05-03 00:56:56','admin','','','','','','text','0',NULL,NULL,'0'),('df5641a0511dae5a4c893760210ac5a0','e96d84a719654f6e9cc1d73c315b0ccc','price','单价',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'0','','',0,1,1,1,'single','','',27,'admin','2020-12-16 19:19:09','2020-11-10 09:30:14','admin','','','','','','text','0',NULL,NULL,'0'),('df58a7b1c3ed8f58a1994c0c0855db16','4adec929a6594108bef5b35ee9966e9f','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',11,'admin','2020-04-10 19:43:38','2020-04-10 19:35:58','admin','','','','','','text','0',NULL,NULL,'0'),('dfafd16d8761f2eae5a40f8142ca2358','d7b42c2262774ded8de4ab7dea6463a9','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2020-12-26 00:27:15','2020-11-16 10:35:13','admin','','','','','',NULL,'0',NULL,NULL,'0'),('e01878738e05b1dae5ecefba8a89d9b9','1952937614c54c54a3653d97c4765cf3','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-12-24 17:26:34','2020-11-16 15:53:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('e0878f0c828726c95a3f44aa5e39f48a','e96d84a719654f6e9cc1d73c315b0ccc','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-12-16 19:19:09','2020-11-10 09:18:44','admin','','','','','',NULL,'0',NULL,NULL,'0'),('e09b191e3c37f9c89ae2192c75220b89','b81de38db24047b497d476516f8a0865','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,NULL,NULL,'2020-02-24 14:56:08','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('e0c5d6e483897d5c4e7894dc66dd1aff','32feeb502544416c9bf41329c10a88f4','bpm_status','流程状态',NULL,0,1,'String',2,0,'','bpm_status','','','list','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2019-08-23 20:03:40','2019-07-02 18:23:58','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('e11b9a781bbff54d121ac63cfaea90a4','5c58150ab99a4487bc5b4666f762962a','loading_date','装柜日期',NULL,0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'single','','',14,'admin','2020-12-21 14:14:25','2020-11-13 15:35:09','admin','','','','','','text','0',NULL,NULL,'0'),('e24de426223dc0271a55eccc1d5457d0','73162c3b8161413e8ecdca7eb288d0c9','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2019-07-01 14:23:32','2019-06-10 15:18:34','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('e2d73ccda7f10f5a1ccce3c48b1e699e','402860816bff91c0016bffa220a9000b','residence_street','户口所在街道','residence_street',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',27,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('e321e41dfbce6b5267ea6f6f32834253','38b8d95658a74899b7dc02e63e199af6','address','仓库地址',NULL,0,1,'string',300,0,'','','','','textarea','',120,NULL,'0','','',1,1,1,0,'single','','',8,'admin','2020-12-14 14:53:53','2020-11-09 14:23:45','admin','','','','','','text','1',NULL,NULL,'0'),('e350986acb670f247df30fe4a44e73df','09fd28e4b7184c1a9668496a5c496450','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-05-14 21:19:21','2020-05-08 23:51:49','admin','','','','','',NULL,'0',NULL,NULL,'0'),('e3debe30bec0d218454e748804c9892f','e96d84a719654f6e9cc1d73c315b0ccc','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-12-16 19:19:09','2020-11-10 09:18:44','admin','','','','','',NULL,'0',NULL,NULL,'0'),('e4914fdff68ac72486ada105e6e9fa36','e9faf717024b4aae95cff224ae9b6d97','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',1,'admin','2019-07-03 18:23:49','2019-07-03 18:22:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('e4a4c1d50b7b46678bc14fd5b90ee082','73162c3b8161413e8ecdca7eb288d0c9','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2019-07-01 14:23:32','2019-06-10 15:18:34','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('e4d7f95340e73a54e8ff3f66b0613513','56efb74326e74064b60933f6f8af30ea','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-07-10 16:53:27','2020-05-08 23:45:32','admin','','','','','',NULL,'0',NULL,NULL,'0'),('e50b4398731e06572c247993a0dcc38d','d35109c3632c4952a19ecc094943dd71','name','用户名',NULL,0,1,'string',200,0,'','','','','text','',120,'*','0','','',0,1,1,0,'single','','',6,'admin','2020-07-17 15:22:04','2019-03-15 14:24:35','admin','','','','','',NULL,'0',NULL,NULL,'1'),('e53f53766d1f7718b3ee5eabe105b969','402860816bff91c0016bffa220a9000b','social_insurance_time','五险一金日期','social_insurance_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',38,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('e5d3d5573606199eb83e502a547ff3ec','f70eb6fe0df74c5eb04552f5c1a4b7b3','height','高（厘米）',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',15,'admin','2020-12-16 20:11:33','2020-12-16 20:08:14','admin','','','','','','text','0',NULL,NULL,'0'),('e5f1d60a495e49bd904d657862cd0210','e033c8909649408ea5bb53e74f7fec7b','cases','件数',NULL,0,1,'int',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',11,'admin','2020-12-14 17:44:02','2020-11-10 09:16:36','admin','','','','','','text','0',NULL,NULL,'0'),('e60a8e496b0f7081dbfe4253b3218546','402880eb71d61d3d0171d61d3de30000','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',10,'admin','2020-05-03 00:54:16','2020-05-02 23:59:33','admin','','','','','','text','0',NULL,NULL,'0'),('e672d5974a06d5c37b3b4c94a6f29f96','4028318169e81b970169e81b97650000','request_url','请求路径','request_url',0,1,'string',255,0,NULL,NULL,NULL,NULL,'text',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,9,NULL,NULL,'2019-04-04 19:28:36','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('e68596cc7c7db0d474fdf5bbec604bc7','caa8de52a4dd4c2e909582709619fa7d','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-12-14 15:02:32','2020-11-09 15:04:12','admin','','','','','',NULL,'0',NULL,NULL,'0'),('e727d386e27db7cd43216d991bbed6af','f70eb6fe0df74c5eb04552f5c1a4b7b3','material','材质',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',18,'admin','2020-12-16 20:11:33','2020-12-16 20:08:14','admin','','','','','','text','0',NULL,NULL,'0'),('e7aade12ca722b59c1ec681d14247ff8','402860816bff91c0016bff91d8830007','sys_org_code','组织机构编码','sys_org_code',0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',14,'admin','2019-07-19 18:04:41','2019-07-17 18:54:37','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('e7c367221181aa9d1fc395e09796be8d','402880eb71d52dc30171d52dc3a10000','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single',NULL,NULL,7,NULL,NULL,'2020-05-02 19:37:58','admin','','','','','','text','0',NULL,NULL,'0'),('e7e622076bcbe7bf7ea9fd9acb6f19bc','18f064d1ef424c93ba7a16148851664f','pic','图片',NULL,0,1,'string',1000,0,'','','','','image','',120,NULL,'0','','',0,1,1,0,'single','','',14,'admin','2020-09-11 14:35:44','2020-05-12 20:26:01','admin','','','','','','text','0',NULL,NULL,'0'),('e826de94aa57ecba53d24f17481cd511','a3c6f1140f7e447eb5bdb26898181fba','receiver','接收人',NULL,0,0,'string',32,0,'','','','','sel_user','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2020-11-26 16:35:41','2020-11-26 16:17:55','admin','','','','','','text','0',NULL,NULL,'0'),('e845925368919482df6dac58e6ed708d','402860816bff91c0016bff91d8830007','phone','联系方式','phone',0,1,'string',20,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',8,'admin','2019-07-19 18:04:41','2019-07-17 18:54:37','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('e85295979d84bde27615a008d8bbadf1','3b5e18da618247539481816995b6bf9f','sex','性别',NULL,0,1,'string',32,0,'','sex','','','list','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2020-07-11 11:27:29','2020-07-11 11:27:17','admin','','','','','','text','0',NULL,NULL,'0'),('e878e70574d0d6180c2f6f0d281c9262','8d66ea41c7cc4ef9ab3aab9055657fc9','pid','父级节点',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,0,0,'single','','',10,NULL,NULL,'2020-05-07 22:46:32','admin','','','','','','text','0',NULL,NULL,'0'),('e88d328af34dd8a17f51437c52b68a2d','402860816bff91c0016bff91cfea0004','create_by','创建人','create_by',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',9,'admin','2019-07-19 18:05:13','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('e944476eb6caf41e34bf2adf3d873ed0','f70eb6fe0df74c5eb04552f5c1a4b7b3','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-12-16 20:11:33','2020-12-16 19:34:19','admin','','','','','',NULL,'0',NULL,NULL,'0'),('e99cc08f4d88dd8f788399db8d448ee8','62e29cdb81ac44d1a2d8ff89851b853d','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,NULL,NULL,'2019-05-11 14:01:14','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('e9fb150adabaaacdd804b1953e6bad24','05a3a30dada7411c9109306aa4117068','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-05-12 22:39:41','2020-05-06 11:34:31','admin','','','','','',NULL,'0',NULL,NULL,'0'),('ea309f9cd81ede7b9b36a1377a3a40d8','997ee931515a4620bc30a9c1246429a9','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-05-03 00:57:44','2020-05-03 00:56:56','admin','','','','','',NULL,'0',NULL,NULL,'0'),('ea644c4c208739640933ba6e568045c1','e2faf977fdaf4b25a524f58c2441a51c','ruz_date','入职时间',NULL,0,1,'Date',32,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2019-06-10 17:27:00','2019-04-24 17:12:11','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('ea96d1c33f0f0d7245045e70a5793257','402860816bff91c0016bffa220a9000b','current_postcode','现居住地邮编','current_postcode',0,1,'string',10,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',31,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('eac1a5584e8d9f26751c9721d5266f51','ca4136acdc61484c94913ba54c2ecaa8','money',' 金额',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',12,'admin','2020-11-16 15:27:24','2020-11-16 15:24:54','admin','','','','','','text','0',NULL,NULL,'0'),('ead1a6894ccafd1291bd03e9f665b0c1','ca4136acdc61484c94913ba54c2ecaa8','weight','重量',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2020-11-16 15:27:24','2020-11-16 15:24:54','admin','','','','','','text','0',NULL,NULL,'0'),('eb4f59d8d91da08de0f76cc0fd3b3c2e','1952937614c54c54a3653d97c4765cf3','mark','MARK',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',15,'admin','2020-12-24 17:26:34','2020-11-16 15:53:19','admin','','','','','','text','0',NULL,NULL,'0'),('eb8024a43532915643053fed6c04e0f7','caa8de52a4dd4c2e909582709619fa7d','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-12-14 15:02:32','2020-11-09 15:04:12','admin','','','','','',NULL,'0',NULL,NULL,'0'),('ebc41362681919cc680fcc58bf87fdcb','1acb6f81a1d9439da6cc4e868617b565','price','单价',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',12,'admin','2019-06-10 14:47:14','2019-04-23 22:58:19','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('ebc82a3f60d54dd35de6991bf0ca9311','618957ffac7940ffa8db258799585671','reference','Reference',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2021-01-07 20:02:09','2020-11-16 15:43:36','admin','','','','','','text','0',NULL,NULL,'0'),('ec04736f5515da919d23fa6bced202e8','11c83901545e454192a300d427e7ad2c','weight','单件箱重',NULL,0,1,'double',10,2,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',21,'admin','2020-12-18 15:39:16','2020-11-09 15:52:10','admin','','','','','','text','0',NULL,NULL,'0'),('ec20e66d5eb9b8b7f58de9edc0f7630b','1acb6f81a1d9439da6cc4e868617b565','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2019-06-10 14:47:14','2019-04-23 22:58:19','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('ec5b6ab06c0346c9e6a0d833f6339501','11c83901545e454192a300d427e7ad2c','volume','单件体积',NULL,0,1,'double',10,3,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',19,'admin','2020-12-18 15:39:16','2020-11-09 15:52:10','admin','','','','','','text','0',NULL,NULL,'0'),('ec5e9cb5809b2f8ce1446df4a27693f0','27fc5f91274344afa7673a732b279939','name','用户名',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2019-07-01 16:28:20','2019-07-01 16:26:42','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('ed16f23d08e7bcda11a1383fda68057e','402860816bff91c0016bff91c7010001','employee_id','员工ID','employee_id',0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','oa_employee_info','id',2,'admin','2019-07-19 18:07:47','2019-07-17 18:54:32','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('edd8f468349be53dd2363526748bcc89','11c83901545e454192a300d427e7ad2c','note','备注',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',11,'admin','2020-12-18 15:39:16','2020-12-12 17:57:11','admin','','','','','','text','0',NULL,NULL,'0'),('edda30c64e1dccee510d40b77a8ca094','fb7125a344a649b990c12949945cb6c1','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,'','0','','',0,0,0,0,'single','','',3,'admin','2019-03-26 19:24:11','2019-03-26 19:01:52','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('ee09e0e21fa350b9346b70292dcfca00','79091e8277c744158530321513119c68','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',1,'admin','2019-05-11 15:29:47','2019-05-11 15:27:17','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('ee4ffe04a25fcf556e78183f1f521546','402860816aa5921f016aa5921f480000','create_by','创建人id','create_by',0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'group','','',8,'admin','2019-05-11 15:31:54','2019-05-11 14:26:19','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('ee5803611f63643059b6375166d71567','402860816bff91c0016bff91c7010001','create_time','创建时间','create_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',8,'admin','2019-07-19 18:07:47','2019-07-17 18:54:32','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('ee6c2b32df04f2c2177c30dcead941a0','f3071ca217274b6892238c4b60e1f177','name_chs','商品中文名称',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2020-12-21 14:49:28','2020-12-21 11:25:51','admin','','','','','','text','0',NULL,NULL,'0'),('eec5bc01720642ccc635c7fc2e9b1eb8','86bf17839a904636b7ed96201b2fa6ea','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-05-14 21:18:49','2020-05-08 23:48:31','admin','','','','','',NULL,'0',NULL,NULL,'0'),('eef20ad19387722f187998d12bff9ee4','ca4136acdc61484c94913ba54c2ecaa8','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,'admin','2020-11-16 15:27:24','2020-11-16 15:24:54','admin','','','','','',NULL,'0',NULL,NULL,'0'),('ef451bcf1f354b9cdc59232aacdb32c4','e96d84a719654f6e9cc1d73c315b0ccc','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-12-16 19:19:09','2020-11-10 09:18:44','admin','','','','','',NULL,'0',NULL,NULL,'0'),('ef81373c5fd7130d7e23859d90c9eb3e','402860816bff91c0016bff91cda80003','from_time','开始日期','from_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',3,'admin','2019-07-19 18:06:36','2019-07-17 18:54:34','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('efd1b955a75b5046e9857e00fe94ae2c','fbc35f067da94a70adb622ddba259352','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',1,NULL,NULL,'2019-07-03 19:44:23','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('f015cc2ffdcc2c4be1e9b3622eb69b52','fbc35f067da94a70adb622ddba259352','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,NULL,NULL,'2019-07-03 19:44:23','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('f0662bc8b52efd04ee56f976d52411f1','9d0da12274fb494f922b6135b998721f','create_time','创建日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',3,'admin','2020-12-14 15:11:36','2020-11-09 15:17:57','admin','','','','','',NULL,'0',NULL,NULL,'0'),('f06b2bb01ea1fae487b7e3c3eb521d5b','d3ae1c692b9640e0a091f8c46e17bb01','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,NULL,NULL,'2019-07-24 14:47:30','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('f0967fd139b440f79f21248bf4e4a209','d3ae1c692b9640e0a091f8c46e17bb01','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,NULL,NULL,'2019-07-24 14:47:30','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('f0a453930aa16ca32f2e3be860bfe542','402860816bff91c0016bffa220a9000b','education','学历','education',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',14,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('f12753b4a3815697a72017a7436fe733','e2faf977fdaf4b25a524f58c2441a51c','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,'admin','2019-06-10 17:27:00','2019-04-24 17:12:11','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('f13368a174a55af354ddce23ae22fa46','e96d84a719654f6e9cc1d73c315b0ccc','volume_total','总体积',NULL,0,1,'double',10,3,'','','','','text','',120,NULL,'0','','',0,1,1,1,'single','','',23,'admin','2020-12-16 19:19:09','2020-11-10 09:30:14','admin','','','','','','text','0',NULL,NULL,'0'),('f1ab7d3b55ade57eeac6c55b32ce813a','1acb6f81a1d9439da6cc4e868617b565','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2019-06-10 14:47:14','2019-04-23 22:58:19','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('f1c7fde21f26c7ed64a0ef1095900c52','4028318169e81b970169e81b97650000','request_type','请求类型','request_type',0,1,'string',10,0,NULL,NULL,NULL,NULL,'text',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,11,NULL,NULL,'2019-04-04 19:28:36','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('f30344554cfe1dc096ed687431b0e52d','dd396a66386745c4993dc5c941c07a2e','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-12-30 15:42:31','2020-11-09 15:35:06','admin','','','','','',NULL,'0',NULL,NULL,'0'),('f3284a1ce6da9b887dce89091eaa0f6b','402880e570a5d7000170a5d700f50000','pro_type','产品类型',NULL,0,1,'String',32,0,'','sex','','','radio','',120,NULL,'0','','',0,1,1,0,'single',NULL,NULL,9,NULL,NULL,'2020-03-04 21:58:16','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('f38319e2add8da6a7223d77359144a22','402880e5721355dd01721355dd390000','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single',NULL,NULL,4,NULL,NULL,'2020-05-14 21:18:14','admin','','','','','',NULL,'0',NULL,NULL,'0'),('f42f0670ae411bd4d6cd3ac9d6d0d95e','ca4136acdc61484c94913ba54c2ecaa8','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2020-11-16 15:27:24','2020-11-16 15:24:54','admin','','','','','',NULL,'0',NULL,NULL,'0'),('f4647a91a4ac5d6d32bb0692b800bffe','402860816bff91c0016bff91c0cb0000','probation_post','试用期职位','probation_post',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',8,'admin','2019-07-19 18:09:01','2019-07-17 18:54:32','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('f46836b838ff2ed8ef217fc811a3ce48','dd396a66386745c4993dc5c941c07a2e','date','入库日期',NULL,0,1,'Date',0,0,'','','','','date','',120,NULL,'1','','',0,1,1,0,'single','','',15,'admin','2020-12-30 15:42:31','2020-11-09 15:35:06','admin','','','','','','text','0',NULL,NULL,'0'),('f4b0bc7f3d6562e28d7c5e2d56510ecd','e5464aa8fa7b47c580e91593cf9b46dc','first_num','首次数量',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2019-04-24 17:09:49','2019-04-24 14:31:31','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('f55340f33d00e576d67ea9558170243e','8a75e88b8e554ee6942b114ccea6d5d9','sex','性别',NULL,0,1,'string',32,0,'','sex','','','list','',120,NULL,'0','','',0,1,1,0,'single','','',7,NULL,NULL,'2020-11-26 17:31:49','admin','','','','','','text','0',NULL,NULL,'0'),('f558359b06aea79a992c102ce3563a4d','4028318169e81b970169e81b97650000','username','操作用户名称','username',0,1,'string',100,0,NULL,NULL,NULL,NULL,'text',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,6,NULL,NULL,'2019-04-04 19:28:36','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('f5d2475aec4b9016dfc0c8772e1704ea','402880eb71d52dc30171d52dc3a10000','code','编码',NULL,0,1,'String',200,0,'','','','','text','',120,NULL,'0','','${order_num_rule_param}',0,1,1,0,'single',NULL,NULL,2,NULL,NULL,'2020-05-02 19:37:59','admin','','','','','',NULL,'0',NULL,NULL,'0'),('f6afcb7d8ea81879593ff737b55ddcc0','402860816bff91c0016bff91cda80003','id','id','id',1,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'group','','',1,'admin','2019-07-19 18:06:36','2019-07-17 18:54:34','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('f6f8aed87ec73994f6a12abbc079dbb1','402860816bff91c0016bffa220a9000b','update_by','更新人','update_by',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',41,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('f7332af7586c83c87f7b9ea144a5292d','62e29cdb81ac44d1a2d8ff89851b853d','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,NULL,NULL,'2019-05-11 14:01:14','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('f76719783433487f4710232e2ae0e521','402860816bff91c0016bff91cfea0004','id','id','id',1,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'group','','',1,'admin','2019-07-19 18:05:13','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('f79eaa7e8617f66242d674fec796928e','a3e23181b97e42a0a576df37ef7c68fc','delivery_man','送货人',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',11,NULL,NULL,'2020-12-16 19:31:34','admin','','','','','','text','0',NULL,NULL,'0'),('f7e7eb84ddc34d7e09d10af213ac6667','402860816bff91c0016bff91d2810005','create_time','创建时间','create_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',11,'admin','2019-07-19 18:05:55','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('f81d7103c0c857e5c744cda2bc4c000a','402860816bff91c0016bff91ca7e0002','cert_organizations','发证机关','cert_organizations',0,1,'string',255,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',6,'admin','2019-07-19 18:07:13','2019-07-17 18:54:33','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('f82db8edef5babf741914b0fa221329b','4028839a6de2ebd3016de2ebd3870000','bpm_status','流程状态','bpm_status',0,1,'string',2,0,NULL,NULL,NULL,NULL,'text',NULL,120,NULL,'0',NULL,NULL,0,1,1,0,'group',NULL,NULL,16,NULL,NULL,'2019-10-19 15:29:30','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('f857d4fd2d63c1ad94ed4698f5b173f5','05a3a30dada7411c9109306aa4117068','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,1,'single','','',1,'admin','2020-05-12 22:39:41','2020-05-06 11:34:31','admin','','','','','',NULL,'0',NULL,NULL,'0'),('f8a0fd20a1173270afdfed1129d5c669','402860816bff91c0016bffa220a9000b','depart_id','所在部门id',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',44,'admin','2019-07-22 16:15:32','2019-07-19 15:33:44','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('f8c3e878eec7db7429938ae130ff5230','dac35da086cb46c29161ea8bb5e07109','address_default','是否默认地址',NULL,0,1,'string',32,0,'','','','','switch','',120,NULL,'0','','',0,1,1,0,'single','','',8,'admin','2020-11-09 15:00:30','2020-11-09 14:59:29','admin','','','','','','text','0',NULL,NULL,'0'),('f8cc6be747fec10802eb625ac529c16f','402860816bff91c0016bff91cfea0004','create_time','创建时间','create_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',10,'admin','2019-07-19 18:05:13','2019-07-17 18:54:35','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('f90bcb38fb89988bd40d1618aa75cea0','758334cb1e7445e2822b60e807aec4a3','id','主键',NULL,1,0,'string',36,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',1,NULL,NULL,'2019-10-18 18:02:09','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('f91cc2f834bf84643854124713ac0ca1','a3e23181b97e42a0a576df37ef7c68fc','update_time','更新日期',NULL,0,1,'Date',20,0,'','','','','datetime','',120,NULL,'0','','',0,0,0,0,'single','','',5,NULL,NULL,'2020-12-16 19:31:34','admin','','','','','',NULL,'0',NULL,NULL,'0'),('f92d8678d7158c055accd4fb645cb202','47a79ec9f7f64c21aa55634bf619406d','address','公司地址',NULL,0,1,'string',300,0,'','','','','textarea','',120,NULL,'0','','',0,1,1,0,'single','','',13,NULL,NULL,'2020-11-16 15:21:22','admin','','','','','','text','0',NULL,NULL,'0'),('f94db83e41c69f407d3c9a81c5892269','402860816bff91c0016bffa220a9000b','first_job_time','首次工作时间','first_job_time',0,1,'Date',0,0,'','','','','date','',120,NULL,'0','','',0,1,1,0,'group','','',22,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('f95d2cbefd25444909c83aaf8c4f72fb','402860816bff91c0016bff91ca7e0002','memo','备注','memo',0,1,'string',255,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',7,'admin','2019-07-19 18:07:13','2019-07-17 18:54:33','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('f9a90877d6336d894e2f37761e36070a','47a79ec9f7f64c21aa55634bf619406d','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,NULL,NULL,'2020-11-16 15:21:22','admin','','','','','',NULL,'0',NULL,NULL,'0'),('fa3a12d7abf72b23afe425f8dbd57f86','1acb6f81a1d9439da6cc4e868617b565','size_type','尺码类型',NULL,0,1,'String',2,0,'','air_china_size','','','list','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2019-06-10 14:47:14','2019-04-23 22:58:19','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('fa8f5a0ba673e0208934567462844eab','402860816bff91c0016bff91ca7e0002','sys_org_code','组织机构编码','sys_org_code',0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',13,'admin','2019-07-19 18:07:13','2019-07-17 18:54:33','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('faaaca21b7b2b16089c885f3224e4dc5','4fb8e12a697f4d5bbe9b9fb1e9009486','main_id','主表ID',NULL,0,1,'String',200,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','demo_field_def_val_main','id',5,'admin','2020-04-10 19:51:27','2020-04-10 19:47:55','admin','','','','','',NULL,'0',NULL,NULL,'0'),('fafb32cf7e63bca93bbd70b0a0ea11fc','758334cb1e7445e2822b60e807aec4a3','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',6,NULL,NULL,'2019-10-18 18:02:09','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('fb3fe4617741598ca0a4458b2a292b4b','1952937614c54c54a3653d97c4765cf3','description','Description',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2020-12-24 17:26:34','2020-11-16 15:53:19','admin','','','','','','text','0',NULL,NULL,'0'),('fb56aeb6b3a5a0a974ef62f34727eea6','402880e5721355dd01721355dd390000','sys_org_code','所属部门',NULL,0,1,'string',64,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single',NULL,NULL,6,NULL,NULL,'2020-05-14 21:18:14','admin','','','','','',NULL,'0',NULL,NULL,'0'),('fc55d467102c2c782286f546d7820c3d','73162c3b8161413e8ecdca7eb288d0c9','pid','父物料',NULL,0,1,'String',36,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',9,'admin','2019-07-01 14:23:32','2019-06-10 15:18:34','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('fc76a3832d232829852cae6c66e44f67','402860816bff91c0016bffa220a9000b','identity_no','身份证号','identity_no',0,1,'string',20,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',21,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('fcd519058d68fa4dab192335602b5d24','402860816bff91c0016bffa220a9000b','real_name','姓名','real_name',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',5,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('fd0586cae06685959415d9017b2bdf49','758334cb1e7445e2822b60e807aec4a3','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,NULL,NULL,'2019-10-18 18:02:09','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('fde00160a5d664effaa4b5552e814e74','fb7125a344a649b990c12949945cb6c1','sex','性别',NULL,0,1,'string',32,0,'','','','','text','',120,'','0','','',0,1,1,0,'single','','',6,'admin','2019-03-26 19:24:11','2019-03-26 19:01:52','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('fe6e9f7af27c9374ccf8447eed5b3075','e033c8909649408ea5bb53e74f7fec7b','material','材质',NULL,0,1,'string',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',21,'admin','2020-12-14 17:44:02','2020-11-10 08:40:30','admin','','','','','','text','0',NULL,NULL,'0'),('feb79d8d4978e529011656cb89de781d','38b8d95658a74899b7dc02e63e199af6','create_by','创建人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',2,'admin','2020-12-14 14:53:53','2020-11-09 14:23:45','admin','','','','','',NULL,'0',NULL,NULL,'0'),('fed133a00f57245d4cfb02dd3c3ce7c1','4adec929a6594108bef5b35ee9966e9f','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',9,'admin','2020-04-10 19:43:38','2020-04-10 19:35:58','admin','','','','','','text','0',NULL,NULL,'0'),('fef2add806c5e1ddd01c79c7e84f5a65','cb2d8534a2f544bc9c618dd49da66336','cc','cc',NULL,0,1,'String',32,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'single','','',7,NULL,NULL,'2020-02-24 17:22:42','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('ff2a099186b13d3ecb0764f7f22b1fbf','09fd28e4b7184c1a9668496a5c496450','name','客户名字',NULL,0,1,'string',32,0,'','realname,sex,birthday','tj_user_report','name,sex,birthday','popup','',120,NULL,'0','','',0,1,1,0,'single','','',7,'admin','2020-05-14 21:19:21','2020-05-08 23:51:49','admin','','','','','','text','0',NULL,NULL,'0'),('ff49b468e54e137032f7e4d976b83b5a','402860816bff91c0016bffa220a9000b','politically_status','政治面貌','politically_status',0,1,'string',20,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',8,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('ff601f75d0e7ced226748eb8fba2c896','402860816bff91c0016bff91d8830007','relation','关系','relation',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',4,'admin','2019-07-19 18:04:41','2019-07-17 18:54:37','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('ffacafee9fa46eb297ca3252f95acef9','402860816bff91c0016bffa220a9000b','school','毕业学校','school',0,1,'string',100,0,'','','','','text','',120,NULL,'0','','',0,1,1,0,'group','','',9,'admin','2019-07-22 16:15:32','2019-07-17 19:12:24','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),('ffcbf379fffabbd13aa2c22ce565ec12','79091e8277c744158530321513119c68','update_by','更新人',NULL,0,1,'string',50,0,'','','','','text','',120,NULL,'0','','',0,0,0,0,'single','','',4,'admin','2019-05-11 15:29:47','2019-05-11 15:27:17','admin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `onl_cgform_field` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `onl_cgform_head`
--

DROP TABLE IF EXISTS `onl_cgform_head`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `onl_cgform_head` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键ID',
  `table_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '表名',
  `table_type` int NOT NULL COMMENT '表类型: 0单表、1主表、2附表',
  `table_version` int DEFAULT '1' COMMENT '表版本',
  `table_txt` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '表说明',
  `is_checkbox` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '是否带checkbox',
  `is_db_synch` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'N' COMMENT '同步数据库状态',
  `is_page` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '是否分页',
  `is_tree` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '是否是树',
  `id_sequence` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '主键生成序列',
  `id_type` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '主键类型',
  `query_mode` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '查询模式',
  `relation_type` int DEFAULT NULL COMMENT '映射关系 0一对多  1一对一',
  `sub_table_str` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '子表',
  `tab_order_num` int DEFAULT NULL COMMENT '附表排序序号',
  `tree_parent_id_field` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '树形表单父id',
  `tree_id_field` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '树表主键字段',
  `tree_fieldname` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '树开表单列字段',
  `form_category` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'bdfl_ptbd' COMMENT '表单分类',
  `form_template` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'PC表单模板',
  `form_template_mobile` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '表单模板样式(移动端)',
  `scroll` int DEFAULT '0' COMMENT '是否有横向滚动条',
  `copy_version` int DEFAULT NULL COMMENT '复制版本号',
  `copy_type` int DEFAULT '0' COMMENT '复制表类型1为复制表 0为原始表',
  `physic_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '原始表ID',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `theme_template` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '主题模板',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `index_onlineform_table_name` (`table_name`) USING BTREE,
  KEY `index_form_templdate` (`form_template`) USING BTREE,
  KEY `index_templdate_mobile` (`form_template_mobile`) USING BTREE,
  KEY `index_onlineform_table_version` (`table_version`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `onl_cgform_head`
--

LOCK TABLES `onl_cgform_head` WRITE;
/*!40000 ALTER TABLE `onl_cgform_head` DISABLE KEYS */;
INSERT INTO `onl_cgform_head` VALUES ('05a3a30dada7411c9109306aa4117068','test_note',1,10,'测试请假单','Y','Y','Y','N',NULL,'UUID','single',NULL,NULL,NULL,NULL,NULL,NULL,'temp','1',NULL,1,NULL,0,NULL,'admin','2020-05-12 22:39:41','admin','2020-05-06 11:34:31','normal'),('09fd28e4b7184c1a9668496a5c496450','ces_order_customer',3,5,'订单客户','Y','Y','Y','N',NULL,'UUID','single',1,'ces_order_customer',3,NULL,NULL,NULL,'temp','1',NULL,1,NULL,0,NULL,'admin','2020-05-14 21:19:21','admin','2020-05-08 23:51:49','normal'),('11c83901545e454192a300d427e7ad2c','iost_receivinglist',3,32,'入仓列表','Y','Y','Y','N',NULL,'UUID','single',0,NULL,1,NULL,NULL,NULL,'temp','1',NULL,1,NULL,0,NULL,'admin','2020-12-18 15:39:16','admin','2020-11-09 15:52:10','normal'),('133b01634f4a411593a94007dca75300','iost_summary_sheet_list',3,13,'汇总明细','Y','Y','Y','N',NULL,'UUID','single',0,NULL,1,NULL,NULL,NULL,'temp','1',NULL,1,NULL,0,NULL,'admin','2020-12-21 19:00:00','admin','2020-11-13 16:09:31','normal'),('18f064d1ef424c93ba7a16148851664f','ces_field_kongj',1,14,'online表单控件','Y','Y','Y','N',NULL,'UUID','single',NULL,NULL,NULL,NULL,NULL,NULL,'temp','2',NULL,1,NULL,0,NULL,'admin','2020-09-11 14:35:44','admin','2020-05-12 20:26:01','normal'),('1952937614c54c54a3653d97c4765cf3','iost_delivery_note_list',3,6,'delivery_note_list','Y','Y','Y','N',NULL,'UUID','single',0,NULL,1,NULL,NULL,NULL,'temp','1',NULL,1,NULL,0,NULL,'admin','2020-12-24 17:26:38','admin','2020-11-16 15:53:19','normal'),('2f03eb34ce95467e8a7f1388d49c18c8','iost_delivery_record',2,14,'出库记录','Y','Y','Y','N',NULL,'UUID','single',NULL,'iost_delivery_record_list',NULL,NULL,NULL,NULL,'temp','2',NULL,1,NULL,0,NULL,'admin','2021-01-07 21:29:54','admin','2020-11-10 09:00:36','normal'),('38b8d95658a74899b7dc02e63e199af6','iost_storage',1,5,'仓库管理','Y','Y','Y','N',NULL,'UUID','single',NULL,NULL,NULL,NULL,NULL,NULL,'temp','1',NULL,1,NULL,0,NULL,'admin','2020-12-14 14:53:53','admin','2020-11-09 14:23:45','normal'),('3d447fa919b64f6883a834036c14aa67','test_enhance_select',1,5,'js增强实现下拉联动效果','N','Y','Y','N',NULL,'UUID','single',NULL,NULL,NULL,NULL,NULL,NULL,'bdfl_include','1',NULL,0,NULL,0,NULL,'admin','2020-02-21 17:58:46','admin','2020-02-20 16:19:00','normal'),('402880e570a5d7000170a5d700f50000','test_order_product$1',1,11,'订单产品明细','N','N','Y','N',NULL,'UUID','single',NULL,NULL,NULL,NULL,NULL,NULL,'bdfl_include','1',NULL,0,1,1,'deea5a8ec619460c9245ba85dbc59e80',NULL,NULL,'admin','2020-03-04 21:58:16',NULL),('402880e5721355dd01721355dd390000','ces_order_goods$1',1,1,'订单商品','Y','N','Y','N',NULL,'UUID','single',NULL,NULL,NULL,NULL,NULL,NULL,'temp','1',NULL,1,1,1,'86bf17839a904636b7ed96201b2fa6ea',NULL,NULL,'admin','2020-05-14 21:18:14','normal'),('402880eb71d61d3d0171d61d3de30000','demo_field_def_val_sub$1',1,2,'示例：控件默认值（子表）','Y','N','Y','N',NULL,'UUID','single',NULL,NULL,NULL,NULL,NULL,NULL,'demo','1',NULL,1,1,1,'4fb8e12a697f4d5bbe9b9fb1e9009486','admin','2020-05-03 00:54:16','admin','2020-05-02 23:59:33','normal'),('47a79ec9f7f64c21aa55634bf619406d','iost_insurance_policy',2,1,'保险单','Y','Y','Y','N',NULL,'UUID','single',NULL,'iost_insurance_policy_list',NULL,NULL,NULL,NULL,'temp','2',NULL,1,NULL,0,NULL,'admin','2020-11-16 15:27:24','admin','2020-11-16 15:21:22','normal'),('4adec929a6594108bef5b35ee9966e9f','demo_field_def_val_main',2,1,'示例：控件默认值（主表）','Y','Y','Y','N',NULL,'UUID','single',NULL,'demo_field_def_val_sub',NULL,NULL,NULL,NULL,'demo','1',NULL,1,NULL,0,NULL,'admin','2020-05-02 19:37:57','admin','2020-04-10 19:35:57','normal'),('4fb8e12a697f4d5bbe9b9fb1e9009486','demo_field_def_val_sub',3,1,'示例：控件默认值（子表）','Y','Y','Y','N',NULL,'UUID','single',0,NULL,1,NULL,NULL,NULL,'demo','1',NULL,1,NULL,0,NULL,'admin','2020-05-02 19:37:54','admin','2020-04-10 19:47:01','normal'),('506c10297a174bf39f4658da3462213b','iost_deliverstatus',2,4,'更新物流状态','Y','Y','Y','N',NULL,'UUID','single',NULL,'iost_deliverstatus_list',NULL,NULL,NULL,NULL,'temp','2',NULL,1,NULL,0,NULL,'admin','2021-01-01 22:30:07','admin','2020-11-12 17:16:04','normal'),('53a3e82b54b946c2b904f605875a275c','ces_shop_goods',1,7,'商品','Y','Y','Y','N',NULL,'UUID','single',NULL,NULL,NULL,NULL,NULL,NULL,'temp','1',NULL,1,NULL,0,NULL,'admin','2020-05-08 23:42:51','admin','2020-05-07 22:49:47','normal'),('56870166aba54ebfacb20ba6c770bd73','test_order_main',2,14,'测试订单主表','N','Y','Y','N',NULL,'UUID','single',NULL,'test_order_product',NULL,NULL,NULL,NULL,'bdfl_include','2',NULL,0,NULL,0,NULL,'admin','2020-11-26 17:31:49','admin','2019-04-20 11:38:39','innerTable'),('56efb74326e74064b60933f6f8af30ea','ces_order_main',2,9,'商城订单表','Y','Y','Y','N',NULL,'UUID','single',NULL,'ces_order_goods,ces_order_customer',NULL,NULL,NULL,NULL,'temp','1',NULL,1,NULL,0,NULL,'admin','2020-07-10 16:53:27','admin','2020-05-08 23:45:32','normal'),('5c58150ab99a4487bc5b4666f762962a','iost_delivery_management',1,4,'送货管理','Y','Y','Y','N',NULL,'UUID','single',NULL,NULL,NULL,NULL,NULL,NULL,'temp','1',NULL,1,NULL,0,NULL,'admin','2020-12-21 14:14:31','admin','2020-11-13 15:35:09','normal'),('61328d3127024a9b99298eded991106c','iost_inventory_record',2,10,'库存记录','Y','Y','Y','N',NULL,'UUID','single',NULL,'iost_inventory_record_list',NULL,NULL,NULL,NULL,'temp','2',NULL,1,NULL,0,NULL,'admin','2020-12-26 18:13:56','admin','2020-11-10 08:19:09','normal'),('618957ffac7940ffa8db258799585671','iost_delivery_note',2,9,'delivery note','Y','Y','Y','N',NULL,'UUID','single',NULL,'iost_delivery_note_list',NULL,NULL,NULL,NULL,'temp','2',NULL,1,NULL,0,NULL,'admin','2021-01-07 20:02:14','admin','2020-11-16 15:43:36','normal'),('6a56622058424a0e8bcc8b402ffc949d','iost_customer',2,4,'客户管理','Y','Y','Y','N',NULL,'UUID','single',NULL,'iost_customerlist',NULL,NULL,NULL,NULL,'temp','2',NULL,1,NULL,0,NULL,'admin','2020-12-14 14:58:40','admin','2020-11-09 14:35:45','normal'),('6bf0dccd4a2d4dd4b2e0be9ea32a3630','iost_deliverstatus_list',3,5,'物流信息','Y','Y','Y','N',NULL,'UUID','single',0,NULL,1,NULL,NULL,NULL,'temp','1',NULL,1,NULL,0,NULL,'admin','2021-01-01 22:29:39','admin','2020-11-12 17:18:41','normal'),('86bf17839a904636b7ed96201b2fa6ea','ces_order_goods',3,2,'订单商品','Y','Y','Y','N',NULL,'UUID','single',0,NULL,2,NULL,NULL,NULL,'temp','1',NULL,1,NULL,0,NULL,'admin','2020-05-14 21:18:49','admin','2020-05-08 23:48:31','normal'),('8a75e88b8e554ee6942b114ccea6d5d9','test',1,1,'测试数据权限','Y','Y','Y','N',NULL,'UUID','single',NULL,NULL,NULL,NULL,NULL,NULL,'temp','1',NULL,1,NULL,0,NULL,'admin','2020-11-26 17:31:54','admin','2020-11-26 17:31:49','normal'),('8d66ea41c7cc4ef9ab3aab9055657fc9','ces_shop_type',1,1,'商品分类','Y','Y','Y','Y',NULL,'UUID','single',NULL,NULL,NULL,'pid','has_child','name','temp','1',NULL,1,NULL,0,NULL,'admin','2020-05-07 22:46:40','admin','2020-05-07 22:46:31','normal'),('997ee931515a4620bc30a9c1246429a9','test_shoptype_tree',1,2,'商品分类','Y','Y','Y','Y',NULL,'UUID','single',NULL,NULL,NULL,'pid','has_child','type_name','temp','1',NULL,1,NULL,0,NULL,'admin','2020-05-03 00:57:47','admin','2020-05-03 00:56:56','normal'),('9d0da12274fb494f922b6135b998721f','iost_price',1,8,'价格维护','Y','Y','Y','N',NULL,'UUID','single',NULL,NULL,NULL,NULL,NULL,NULL,'temp','1',NULL,1,NULL,0,NULL,'admin','2020-12-14 15:11:36','admin','2020-11-09 15:17:57','normal'),('a3c6f1140f7e447eb5bdb26898181fba','iost_message',1,4,'消息通知','Y','Y','Y','N',NULL,'UUID','single',NULL,NULL,NULL,NULL,NULL,NULL,'bdfl_include','1',NULL,1,NULL,0,NULL,'admin','2020-11-26 16:35:41','admin','2020-11-26 16:17:55','normal'),('a3e23181b97e42a0a576df37ef7c68fc','iost_receiving_copy',2,1,'入仓单(副本）','Y','Y','Y','N',NULL,'UUID','single',NULL,'iost_receivinglist_copy',NULL,NULL,NULL,NULL,'temp','3',NULL,1,NULL,0,NULL,'admin','2020-12-30 15:42:31','admin','2020-12-16 19:31:34','normal'),('ca4136acdc61484c94913ba54c2ecaa8','iost_insurance_policy_list',3,3,'保险明细','Y','Y','Y','N',NULL,'UUID','single',0,NULL,1,NULL,NULL,NULL,'temp','1',NULL,1,NULL,0,NULL,'admin','2020-11-16 15:27:29','admin','2020-11-16 15:24:54','normal'),('caa8de52a4dd4c2e909582709619fa7d','iost_kind',1,2,'商品类别','Y','Y','Y','N',NULL,'UUID','single',NULL,NULL,NULL,NULL,NULL,NULL,'temp','1',NULL,1,NULL,0,NULL,'admin','2020-12-14 15:02:32','admin','2020-11-09 15:04:12','normal'),('d31c1fde7b9e41e7bec8a108381b5874','iost_summary_sheet',2,7,'汇总单','Y','Y','Y','N',NULL,'UUID','single',NULL,'iost_summary_sheet_list',NULL,NULL,NULL,NULL,'temp','2',NULL,1,NULL,0,NULL,'admin','2020-12-30 14:52:11','admin','2020-11-13 16:06:56','normal'),('d35109c3632c4952a19ecc094943dd71','test_demo',1,22,'测试用户表','Y','Y','Y','N',NULL,'UUID','single',NULL,NULL,NULL,NULL,NULL,NULL,'bdfl_include','1',NULL,0,NULL,0,NULL,'admin','2020-07-17 15:22:04','admin','2019-03-15 14:24:35','normal'),('d7b42c2262774ded8de4ab7dea6463a9','iost_receiving_note',2,7,'收费单','Y','Y','Y','N',NULL,'UUID','single',NULL,'iost_receiving_note_list',NULL,NULL,NULL,NULL,'temp','2',NULL,1,NULL,0,NULL,'admin','2020-12-30 15:42:31','admin','2020-11-16 10:35:13','normal'),('dac35da086cb46c29161ea8bb5e07109','iost_customerlist',3,2,'送货地址','Y','Y','Y','N',NULL,'UUID','single',0,NULL,1,NULL,NULL,NULL,'temp','1',NULL,1,NULL,0,NULL,'admin','2020-11-09 15:00:30','admin','2020-11-09 14:59:29','normal'),('dd396a66386745c4993dc5c941c07a2e','iost_receiving',2,25,'入仓单','Y','Y','Y','N',NULL,'UUID','single',NULL,'iost_receivinglist',NULL,NULL,NULL,NULL,'temp','3',NULL,1,NULL,0,NULL,'admin','2020-12-30 15:42:31','admin','2020-11-09 15:35:06','normal'),('deea5a8ec619460c9245ba85dbc59e80','test_order_product',3,12,'订单产品明细','N','Y','Y','N',NULL,'UUID','single',0,NULL,1,NULL,NULL,NULL,'bdfl_include','1',NULL,0,NULL,0,NULL,'admin','2020-05-03 01:01:18','admin','2019-04-20 11:41:19','normal'),('e033c8909649408ea5bb53e74f7fec7b','iost_inventory_record_list',3,14,'库存记录表','Y','Y','Y','N',NULL,'UUID','single',0,NULL,1,NULL,NULL,NULL,'temp','1',NULL,1,NULL,0,NULL,'admin','2020-12-14 17:44:02','admin','2020-11-10 08:36:39','normal'),('e96d84a719654f6e9cc1d73c315b0ccc','iost_delivery_record_list',3,30,'出库记录表','Y','Y','Y','N',NULL,'UUID','single',0,NULL,1,NULL,NULL,NULL,'temp','1',NULL,1,NULL,0,NULL,'admin','2020-12-16 19:19:10','admin','2020-11-10 09:18:44','normal'),('f3071ca217274b6892238c4b60e1f177','iost_receiving_note_list',3,7,'收费明细','Y','Y','Y','N',NULL,'UUID','single',0,NULL,1,NULL,NULL,NULL,'temp','1',NULL,1,NULL,0,NULL,'admin','2020-12-21 14:49:28','admin','2020-11-16 10:39:30','normal'),('f70eb6fe0df74c5eb04552f5c1a4b7b3','iost_receivinglist_copy',3,4,'入仓列表(副本）','Y','Y','Y','N',NULL,'UUID','single',0,NULL,1,NULL,NULL,NULL,'temp','1',NULL,1,NULL,0,NULL,'admin','2020-12-16 20:11:33','admin','2020-12-16 19:34:19','normal'),('f79dbb25b30c4357a334db84a0e24a55','iost_delivery_record_pic',1,2,'上传收费单','Y','Y','Y','N',NULL,'UUID','single',NULL,NULL,NULL,NULL,NULL,NULL,'temp','1',NULL,1,NULL,0,NULL,'admin','2021-01-08 11:48:06','admin','2021-01-08 11:15:19','normal');
/*!40000 ALTER TABLE `onl_cgform_head` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `onl_cgform_index`
--

DROP TABLE IF EXISTS `onl_cgform_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `onl_cgform_index` (
  `id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键',
  `cgform_head_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '主表id',
  `index_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '索引名称',
  `index_field` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '索引栏位',
  `index_type` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '索引类型',
  `create_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人登录名称',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '更新人登录名称',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `is_db_synch` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT 'N' COMMENT '是否同步数据库 N未同步 Y已同步',
  `del_flag` int DEFAULT '0' COMMENT '是否删除 0未删除 1删除',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `index_table_id` (`cgform_head_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `onl_cgform_index`
--

LOCK TABLES `onl_cgform_index` WRITE;
/*!40000 ALTER TABLE `onl_cgform_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `onl_cgform_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `onl_cgreport_head`
--

DROP TABLE IF EXISTS `onl_cgreport_head`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `onl_cgreport_head` (
  `id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '报表编码',
  `name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '报表名字',
  `cgr_sql` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '报表SQL',
  `return_val_field` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '返回值字段',
  `return_txt_field` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '返回文本字段',
  `return_type` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '1' COMMENT '返回类型，单选或多选',
  `db_source` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '动态数据源',
  `content` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '描述',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改人id',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人id',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `index_onlinereport_code` (`code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `onl_cgreport_head`
--

LOCK TABLES `onl_cgreport_head` WRITE;
/*!40000 ALTER TABLE `onl_cgreport_head` DISABLE KEYS */;
INSERT INTO `onl_cgreport_head` VALUES ('1256627801873821698','report002','统计登录每日登录次数','select DATE_FORMAT(create_time,  \'%Y-%m-%d\') as date,count(*) as num from sys_log group by DATE_FORMAT(create_time, \'%Y-%m-%d\')',NULL,NULL,'1',NULL,NULL,'2020-09-11 14:50:45','admin','2020-05-03 00:53:10','admin'),('1260179852088135681','tj_user_report','统一有效系统用户','select * from sys_user',NULL,NULL,'1',NULL,NULL,'2020-09-11 14:07:38','admin','2020-05-12 20:07:44','admin'),('1326825388158644225','customer_delivery','客户出货报表','select  b.customer_name,b.receiving_no,b.deliver_status,sum(b.volume) as \'总体积\',sum(b.packages) as \'总装箱数\',sum(b.weight) as \'总重量\',DATE(a.loading_date)  as \'日期\'  from iost_summary_sheet a,iost_summary_sheet_list b  WHERE a.id = b.summary_id   \nGROUP BY b.customer_name,b.receiving_no,b.deliver_status,DATE(a.loading_date) ',NULL,NULL,'1',NULL,NULL,'2020-12-27 11:32:55','admin','2020-11-12 17:53:18','admin'),('1326829653178609666','store_goods_into','仓库货物报表（入库）','SELECT   a.receiving_no, a.customer_name, c.name , sum(b.cases) as \'总件数\'  ,  sum(b.volume_total) as \'总体积\', sum(b.weight_total) as \'总重量\' ,sum(b.money) as \'总金额\' ,DATE(a.date)   as \'日期\' FROM iost_receiving a  LEFT JOIN iost_storage as c   on\nc.id=a.warehouse_name, iost_receivinglist b\nWHERE a.id = b.receiving_id   \ngroup by   a.receiving_no, customer_name,c.name,DATE(a.date) ',NULL,NULL,'1','',NULL,'2021-01-05 18:08:50','admin','2020-11-12 18:10:15','admin'),('1326830479955619841','store_goods_in','仓库货物报表（在库）','select receiving_no,customer_name,sum(IFNULL(cases,0)-IFNULL(ref_cases,0)) as \'总件数\',sum(volume_total) as \'总体积\',sum(weight_total) as \'总重量\' \nfrom  iost_receiving a,iost_receivinglist b   \nwhere a.id=b.receiving_id and IFNULL(cases,0)-IFNULL(ref_cases,0) > 0    \nGROUP BY receiving_no,customer_name',NULL,NULL,'1','',NULL,'2021-01-05 18:19:31','admin','2020-11-12 18:13:32','admin'),('1326832190489260034','store_goods_out','仓库货物报表（出库）','select c.name  as  \'仓库名称\', b.customer_name,sum(b.cases_actual) as \'总件数\',sum(b.packages_total) as \'总装箱数\', sum(b.volume_total) as \'总体积\', sum(b.weight_total) as \'总重量\' ,  DATE_FORMAT(a.loading_date,\"%Y年%m月\")  as \'日期\'  from iost_delivery_record a LEFT JOIN iost_storage as c   on\nc.id=a.warehouse_name , iost_delivery_record_list b\nWHERE a.id=b.delivery_record_id\nGROUP BY   c.name , b.customer_name ,DATE_FORMAT(a.loading_date,\"%Y年%m月\") ',NULL,NULL,'1','',NULL,'2021-01-05 18:24:56','admin','2020-11-12 18:20:20','admin'),('1327141575685992449','custome_list','客户列表','select *  from iost_customer',NULL,NULL,'1','',NULL,'2020-11-13 15:00:27','admin','2020-11-13 14:49:43','admin'),('1330347973618143233','price_list','单价维护','select * from iost_price',NULL,NULL,'1',NULL,NULL,NULL,NULL,'2020-11-22 11:10:48','admin'),('1335198095083835393','iost_delivery_record','出库列表','select a.id source_id,b.id source_entry_id,receiving_no,customer_name,name_chs,name_eng,kind,picture,note,unit, IFNULL(cases,0)-IFNULL(ref_cases,0) cases,packages,packages_total,length,width,height,volume,volume_total,weight,weight_total,material,price,money  from  iost_receiving a,iost_receivinglist b   where a.id=b.receiving_id and IFNULL(cases,0)-IFNULL(ref_cases,0) > 0   ORDER BY receiving_no',NULL,NULL,'1',NULL,NULL,'2020-12-19 16:32:12','admin','2020-12-05 20:23:27','admin'),('6c7f59741c814347905a938f06ee003c','report_user','统计在线用户','select * from sys_user',NULL,NULL,'1','',NULL,'2020-05-03 02:35:28','admin','2019-03-25 11:20:45','admin'),('87b55a515d3441b6b98e48e5b35474a6','demo','Report Demo','select * from demo',NULL,NULL,'1','',NULL,'2020-05-03 01:14:35','admin','2019-03-12 11:25:16','admin');
/*!40000 ALTER TABLE `onl_cgreport_head` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `onl_cgreport_item`
--

DROP TABLE IF EXISTS `onl_cgreport_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `onl_cgreport_item` (
  `id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `cgrhead_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '报表ID',
  `field_name` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '字段名字',
  `field_txt` varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '字段文本',
  `field_width` int DEFAULT NULL,
  `field_type` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '字段类型',
  `search_mode` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '查询模式',
  `is_order` int DEFAULT '0' COMMENT '是否排序  0否,1是',
  `is_search` int DEFAULT '0' COMMENT '是否查询  0否,1是',
  `dict_code` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '字典CODE',
  `field_href` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '字段跳转URL',
  `is_show` int DEFAULT '1' COMMENT '是否显示  0否,1显示',
  `order_num` int DEFAULT NULL COMMENT '排序',
  `replace_val` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '取值表达式',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `index_CGRHEAD_ID` (`cgrhead_id`) USING BTREE,
  KEY `index_isshow` (`is_show`) USING BTREE,
  KEY `index_order_num` (`order_num`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `onl_cgreport_item`
--

LOCK TABLES `onl_cgreport_item` WRITE;
/*!40000 ALTER TABLE `onl_cgreport_item` DISABLE KEYS */;
INSERT INTO `onl_cgreport_item` VALUES ('1256627802020622337','1256627801873821698','date','日期',NULL,'String',NULL,0,0,'','',1,1,'','admin','2020-09-11 14:50:45',NULL,NULL),('1256627802075148289','1256627801873821698','num','登录次数',NULL,'String',NULL,0,0,'','',1,2,'','admin','2020-09-11 14:50:45',NULL,NULL),('1260179881129496577','1260179852088135681','id','ID',NULL,'String',NULL,0,0,'','',0,1,'','admin','2020-09-11 14:07:38',NULL,NULL),('1260179881129496578','1260179852088135681','username','账号',NULL,'String',NULL,0,0,'','',1,2,'','admin','2020-09-11 14:07:38',NULL,NULL),('1260179881129496579','1260179852088135681','realname','用户名字',NULL,'String',NULL,0,0,'','',1,3,'','admin','2020-09-11 14:07:38',NULL,NULL),('1260179881129496584','1260179852088135681','sex','性别',NULL,'String',NULL,0,1,'sex','',1,4,'','admin','2020-09-11 14:07:38',NULL,NULL),('1260179881129496585','1260179852088135681','email','邮箱',NULL,'String','single',0,1,'','',1,5,'','admin','2020-09-11 14:07:38',NULL,NULL),('1260179881129496586','1260179852088135681','phone','电话',NULL,'String',NULL,0,0,'','',1,6,'','admin','2020-09-11 14:07:38',NULL,NULL),('1326825388284473345','1326825388158644225','customer_name','客户姓名',NULL,'String',NULL,0,1,'','',1,1,'','admin','2020-12-27 11:32:55',NULL,NULL),('1326825388297056258','1326825388158644225','receiving_no','入仓号',NULL,'String',NULL,0,0,'','',1,2,'','admin','2020-12-27 11:32:55',NULL,NULL),('1326829653258301443','1326829653178609666','customer_name','客户名称',NULL,'String',NULL,0,0,'','',1,2,'','admin','2021-01-05 18:08:50',NULL,NULL),('1327141575765684225','1327141575685992449','name_chs','客户中文名称',NULL,'String',NULL,0,0,'','',1,1,'','admin','2020-11-13 15:00:27',NULL,NULL),('1327141575765684226','1327141575685992449','name_eng','客户英文名称',NULL,'String',NULL,0,0,'','',1,2,'','admin','2020-11-13 15:00:27',NULL,NULL),('1327141575765684227','1327141575685992449','company','公司名称',NULL,'String',NULL,0,0,'','',1,3,'','admin','2020-11-13 15:00:27',NULL,NULL),('1327141575765684228','1327141575685992449','code','客户编码',NULL,'String',NULL,0,0,'','',1,4,'','admin','2020-11-13 15:00:27',NULL,NULL),('1330347973727195137','1330347973618143233','name_chs','商品中文名称',NULL,'String',NULL,0,0,'','',1,1,'','admin','2020-11-22 11:10:48',NULL,NULL),('1330347973727195138','1330347973618143233','kind','商品类别',NULL,'String',NULL,0,0,'','',1,2,'','admin','2020-11-22 11:10:48',NULL,NULL),('1330347973727195139','1330347973618143233','name_eng','商品英文名称',NULL,'String',NULL,0,0,'','',1,3,'','admin','2020-11-22 11:10:48',NULL,NULL),('1330347973727195140','1330347973618143233','price','单价',NULL,'Integer',NULL,0,0,'','',1,4,'','admin','2020-11-22 11:10:48',NULL,NULL),('1330347973727195141','1330347973618143233','description','描述',NULL,'String',NULL,0,0,'','',1,5,'','admin','2020-11-22 11:10:48',NULL,NULL),('1335198962801446913','1335198095083835393','receiving_no','入仓号',NULL,'String',NULL,0,0,'','',1,3,'','admin','2020-12-19 16:32:12',NULL,NULL),('1335198962801446914','1335198095083835393','customer_name','客户名称',NULL,'String',NULL,0,0,'','',1,4,'','admin','2020-12-19 16:32:12',NULL,NULL),('1335198962801446915','1335198095083835393','name_chs','商品中文名称',NULL,'String',NULL,0,0,'','',1,5,'','admin','2020-12-19 16:32:12',NULL,NULL),('1335198962801446916','1335198095083835393','name_eng','商品英文名称',NULL,'String',NULL,0,0,'','',1,6,'','admin','2020-12-19 16:32:12',NULL,NULL),('1335198962801446917','1335198095083835393','kind','商品类别',NULL,'String',NULL,0,0,'','',1,7,'','admin','2020-12-19 16:32:12',NULL,NULL),('1335198962801446918','1335198095083835393','picture','图片',NULL,'String',NULL,0,0,'','',0,8,'','admin','2020-12-19 16:32:12',NULL,NULL),('1335232421590732808','1335198095083835393','unit','单位',NULL,'String',NULL,0,0,'','',1,10,'','admin','2020-12-19 16:32:12',NULL,NULL),('1335232421590732809','1335198095083835393','cases','件数',NULL,'String',NULL,0,0,'','',1,11,'','admin','2020-12-19 16:32:12',NULL,NULL),('1335232421590732810','1335198095083835393','packages','装箱数',NULL,'String',NULL,0,0,'','',1,12,'','admin','2020-12-19 16:32:12',NULL,NULL),('1335232421590732811','1335198095083835393','packages_total','总装箱数',NULL,'String',NULL,0,0,'','',1,13,'','admin','2020-12-19 16:32:12',NULL,NULL),('1335232421590732812','1335198095083835393','length','长',NULL,'String',NULL,0,0,'','',1,14,'','admin','2020-12-19 16:32:12',NULL,NULL),('1335232421590732813','1335198095083835393','width','宽',NULL,'String',NULL,0,0,'','',1,15,'','admin','2020-12-19 16:32:12',NULL,NULL),('1335232421590732814','1335198095083835393','height','高',NULL,'String',NULL,0,0,'','',1,16,'','admin','2020-12-19 16:32:12',NULL,NULL),('1335232421590732815','1335198095083835393','volume','单件体积',NULL,'String',NULL,0,0,'','',1,17,'','admin','2020-12-19 16:32:12',NULL,NULL),('1335232421590732816','1335198095083835393','volume_total','总体积',NULL,'String',NULL,0,0,'','',1,18,'','admin','2020-12-19 16:32:12',NULL,NULL),('1335232421590732817','1335198095083835393','weight','箱重',NULL,'String',NULL,0,0,'','',1,19,'','admin','2020-12-19 16:32:12',NULL,NULL),('1335232421590732818','1335198095083835393','weight_total','总重量',NULL,'String',NULL,0,0,'','',1,20,'','admin','2020-12-19 16:32:12',NULL,NULL),('1335232421590732819','1335198095083835393','material','材质',NULL,'String',NULL,0,0,'','',1,21,'','admin','2020-12-19 16:32:12',NULL,NULL),('1335232421590732820','1335198095083835393','price','单价',NULL,'String',NULL,0,0,'','',1,22,'','admin','2020-12-19 16:32:12',NULL,NULL),('1335232421590732821','1335198095083835393','money','金额',NULL,'String',NULL,0,0,'','',1,23,'','admin','2020-12-19 16:32:12',NULL,NULL),('1335235181744754694','1326829653178609666','总体积','总体积',NULL,'String',NULL,0,0,'','',1,5,'','admin','2021-01-05 18:08:50',NULL,NULL),('1335235181744754695','1326829653178609666','总重量','总重量',NULL,'String',NULL,0,0,'','',1,6,'','admin','2021-01-05 18:08:50',NULL,NULL),('1335500717342855171','1326829653178609666','name','仓库名称',NULL,'String',NULL,0,1,'','',1,3,'','admin','2021-01-05 18:08:50',NULL,NULL),('1335861197592993793','1335198095083835393','source_id','源单ID',NULL,'String',NULL,0,0,'','',0,1,'','admin','2020-12-19 16:32:12',NULL,NULL),('1335861197592993794','1335198095083835393','source_entry_id','源单单据体ID',NULL,'String',NULL,0,0,'','',0,2,'','admin','2020-12-19 16:32:12',NULL,NULL),('1336202987323789316','1326825388158644225','总体积','总体积',NULL,'String',NULL,0,0,'','',1,3,'','admin','2020-12-27 11:32:55',NULL,NULL),('1336202987323789317','1326825388158644225','总装箱数','总装箱数',NULL,'String',NULL,0,0,'','',1,4,'','admin','2020-12-27 11:32:55',NULL,NULL),('1336202987323789318','1326825388158644225','总重量','总重量',NULL,'String',NULL,0,0,'','',1,5,'','admin','2020-12-27 11:32:55',NULL,NULL),('1338782963499798536','1326829653178609666','总金额','总金额',NULL,'String',NULL,0,0,'','',1,7,'','admin','2021-01-05 18:08:50',NULL,NULL),('1338786264597401604','1326829653178609666','总件数','总件数',NULL,'String',NULL,0,0,'','',1,4,'','admin','2021-01-05 18:08:50',NULL,NULL),('1342766040039297031','1326829653178609666','日期','日期',NULL,'Date','group',0,1,'','',0,8,'','admin','2021-01-05 18:08:50',NULL,NULL),('1343021622977630209','1326829653178609666','receiving_no','入仓号',NULL,'String',NULL,0,0,'','',1,1,'','admin','2021-01-05 18:08:50',NULL,NULL),('1343036231713296392','1326825388158644225','日期','日期',NULL,'Date','group',0,1,'','',1,6,'','admin','2020-12-27 11:32:55',NULL,NULL),('1344914121149124611','1326832190489260034','customer_name','客户名称',NULL,'String',NULL,0,0,'','',1,2,'','admin','2021-01-05 18:24:56',NULL,NULL),('1344914121149124612','1326832190489260034','总件数','总件数',NULL,'String',NULL,0,0,'','',1,3,'','admin','2021-01-05 18:24:56',NULL,NULL),('1344914121149124613','1326832190489260034','总装箱数','总装箱数',NULL,'String',NULL,0,0,'','',1,4,'','admin','2021-01-05 18:24:56',NULL,NULL),('1344914121149124614','1326832190489260034','总体积','总体积',NULL,'String',NULL,0,0,'','',1,5,'','admin','2021-01-05 18:24:56',NULL,NULL),('1344914121149124615','1326832190489260034','总重量','总重量',NULL,'String',NULL,0,0,'','',1,6,'','admin','2021-01-05 18:24:56',NULL,NULL),('1344914121149124616','1326832190489260034','日期','日期',NULL,'Date','group',0,1,'','',1,7,'','admin','2021-01-05 18:24:56',NULL,NULL),('1344915594956247042','1326832190489260034','仓库名称','仓库名称',NULL,'String',NULL,0,0,'','',1,1,'','admin','2021-01-05 18:24:56',NULL,NULL),('1346400060836941828','1326830479955619841','总件数','总件数',NULL,'String',NULL,0,0,'','',1,3,'','admin','2021-01-05 18:19:31',NULL,NULL),('1346400060836941829','1326830479955619841','总体积','总体积',NULL,'String',NULL,0,0,'','',1,4,'','admin','2021-01-05 18:19:31',NULL,NULL),('1346400060836941830','1326830479955619841','总重量','总重量',NULL,'String',NULL,0,0,'','',1,5,'','admin','2021-01-05 18:19:31',NULL,NULL),('15884396588465896672','87b55a515d3441b6b98e48e5b35474a6','id','ID',NULL,'String',NULL,0,0,'','',0,1,'','admin','2020-05-03 01:14:35',NULL,NULL),('15892858611256977947','1260179852088135681','birthday','生日',NULL,'Date',NULL,0,0,'','',1,7,'','admin','2020-09-11 14:07:38',NULL,NULL),('16051749311126779258','1326825388158644225','deliver_status','送货状态',NULL,'String',NULL,0,1,'','',1,7,'','admin','2020-12-27 11:32:55',NULL,NULL),('16051760335021732515','1326830479955619841','receiving_no','入仓号',NULL,'String',NULL,0,0,'','',1,1,'','admin','2021-01-05 18:19:31',NULL,NULL),('16051760433042895495','1326830479955619841','customer_name','客户名称',NULL,'String',NULL,0,0,'','',1,2,'','admin','2021-01-05 18:19:31',NULL,NULL),('160811601199522362509','1335198095083835393','note','备注',NULL,'String',NULL,0,0,'','',1,9,'','admin','2020-12-19 16:32:12',NULL,NULL),('1740bb02519db90c44cb2cba8b755136','6c7f59741c814347905a938f06ee003c','realname','用户名称',NULL,'String',NULL,0,0,'','https://www.baidu.com',1,1,'','admin','2020-05-03 02:35:28',NULL,NULL),('1b181e6d2813bcb263adc39737f9df46','87b55a515d3441b6b98e48e5b35474a6','name','用户名',NULL,'String','single',0,1,'','',1,2,'','admin','2020-05-03 01:14:35',NULL,NULL),('61ef5b323134938fdd07ad5e3ea16cd3','87b55a515d3441b6b98e48e5b35474a6','key_word','关键词',NULL,'String','single',0,1,'','',1,3,'','admin','2020-05-03 01:14:35',NULL,NULL),('627768efd9ba2c41e905579048f21000','6c7f59741c814347905a938f06ee003c','username','用户账号',NULL,'String','single',0,1,'','',1,2,'','admin','2020-05-03 02:35:28',NULL,NULL),('8bb087a9aa2000bcae17a1b3f5768435','6c7f59741c814347905a938f06ee003c','sex','性别',NULL,'String','single',0,1,'sex','',1,3,'','admin','2020-05-03 02:35:28',NULL,NULL),('90d4fa57d301801abb26a9b86b6b94c4','6c7f59741c814347905a938f06ee003c','birthday','生日',NULL,'Date','single',0,0,'','',1,4,'','admin','2020-05-03 02:35:28',NULL,NULL),('a4ac355f07a05218854e5f23e2930163','6c7f59741c814347905a938f06ee003c','avatar','头像',NULL,'String',NULL,0,0,'','',0,5,'','admin','2020-05-03 02:35:28',NULL,NULL),('d6e86b5ffd096ddcc445c0f320a45004','6c7f59741c814347905a938f06ee003c','phone','手机号',NULL,'String',NULL,0,0,'','',1,6,'','admin','2020-05-03 02:35:28',NULL,NULL),('df365cd357699eea96c29763d1dd7f9d','6c7f59741c814347905a938f06ee003c','email','邮箱',NULL,'String',NULL,0,0,'','',1,7,'','admin','2020-05-03 02:35:28',NULL,NULL),('edf9932912b81ad01dd557d3d593a559','87b55a515d3441b6b98e48e5b35474a6','age','年龄',NULL,'String',NULL,0,0,'','',1,4,'','admin','2020-05-03 01:14:35',NULL,NULL),('f985883e509a6faaaf62ca07fd24a73c','87b55a515d3441b6b98e48e5b35474a6','birthday','生日',NULL,'Date','single',0,1,'','',1,5,'','admin','2020-05-03 01:14:35',NULL,NULL),('fce83e4258de3e2f114ab3116397670c','87b55a515d3441b6b98e48e5b35474a6','punch_time','发布时间',NULL,'String',NULL,0,0,'','',1,6,'','admin','2020-05-03 01:14:35',NULL,NULL);
/*!40000 ALTER TABLE `onl_cgreport_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `onl_cgreport_param`
--

DROP TABLE IF EXISTS `onl_cgreport_param`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `onl_cgreport_param` (
  `id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `cgrhead_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '动态报表ID',
  `param_name` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '参数字段',
  `param_txt` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '参数文本',
  `param_value` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '参数默认值',
  `order_num` int DEFAULT NULL COMMENT '排序',
  `create_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人登录名称',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '更新人登录名称',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_cgrheadid` (`cgrhead_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `onl_cgreport_param`
--

LOCK TABLES `onl_cgreport_param` WRITE;
/*!40000 ALTER TABLE `onl_cgreport_param` DISABLE KEYS */;
/*!40000 ALTER TABLE `onl_cgreport_param` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oss_file`
--

DROP TABLE IF EXISTS `oss_file`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oss_file` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键id',
  `file_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '文件名称',
  `url` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '文件地址',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人登录名称',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '更新人登录名称',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='Oss File';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oss_file`
--

LOCK TABLES `oss_file` WRITE;
/*!40000 ALTER TABLE `oss_file` DISABLE KEYS */;
/*!40000 ALTER TABLE `oss_file` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `qrtz_blob_triggers`
--

DROP TABLE IF EXISTS `qrtz_blob_triggers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `qrtz_blob_triggers` (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `TRIGGER_NAME` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `BLOB_DATA` blob,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_blob_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='InnoDB free: 504832 kB; (`SCHED_NAME` `TRIGGER_NAME` `TRIGGE';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `qrtz_blob_triggers`
--

LOCK TABLES `qrtz_blob_triggers` WRITE;
/*!40000 ALTER TABLE `qrtz_blob_triggers` DISABLE KEYS */;
/*!40000 ALTER TABLE `qrtz_blob_triggers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `qrtz_calendars`
--

DROP TABLE IF EXISTS `qrtz_calendars`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `qrtz_calendars` (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CALENDAR_NAME` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CALENDAR` blob NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`CALENDAR_NAME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `qrtz_calendars`
--

LOCK TABLES `qrtz_calendars` WRITE;
/*!40000 ALTER TABLE `qrtz_calendars` DISABLE KEYS */;
/*!40000 ALTER TABLE `qrtz_calendars` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `qrtz_cron_triggers`
--

DROP TABLE IF EXISTS `qrtz_cron_triggers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `qrtz_cron_triggers` (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `TRIGGER_NAME` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `CRON_EXPRESSION` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `TIME_ZONE_ID` varchar(80) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_cron_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='InnoDB free: 504832 kB; (`SCHED_NAME` `TRIGGER_NAME` `TRIGGE';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `qrtz_cron_triggers`
--

LOCK TABLES `qrtz_cron_triggers` WRITE;
/*!40000 ALTER TABLE `qrtz_cron_triggers` DISABLE KEYS */;
INSERT INTO `qrtz_cron_triggers` VALUES ('MyScheduler','org.jeecg.modules.message.job.SendMsgJob','DEFAULT','0/50 * * * * ? *','Asia/Shanghai'),('MyScheduler','org.jeecg.modules.quartz.job.SampleJob','DEFAULT','0/1 * * * * ?','Asia/Shanghai'),('MyScheduler','org.jeecg.modules.quartz.job.SampleParamJob','DEFAULT','0/1 * * * * ?','Asia/Shanghai');
/*!40000 ALTER TABLE `qrtz_cron_triggers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `qrtz_fired_triggers`
--

DROP TABLE IF EXISTS `qrtz_fired_triggers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `qrtz_fired_triggers` (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `ENTRY_ID` varchar(95) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `TRIGGER_NAME` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `INSTANCE_NAME` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `FIRED_TIME` bigint NOT NULL,
  `SCHED_TIME` bigint NOT NULL,
  `PRIORITY` int NOT NULL,
  `STATE` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `JOB_NAME` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `JOB_GROUP` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `IS_NONCONCURRENT` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `REQUESTS_RECOVERY` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`,`ENTRY_ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `qrtz_fired_triggers`
--

LOCK TABLES `qrtz_fired_triggers` WRITE;
/*!40000 ALTER TABLE `qrtz_fired_triggers` DISABLE KEYS */;
/*!40000 ALTER TABLE `qrtz_fired_triggers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `qrtz_job_details`
--

DROP TABLE IF EXISTS `qrtz_job_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `qrtz_job_details` (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `JOB_NAME` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `JOB_GROUP` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `DESCRIPTION` varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `JOB_CLASS_NAME` varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `IS_DURABLE` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `IS_NONCONCURRENT` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `IS_UPDATE_DATA` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `REQUESTS_RECOVERY` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `JOB_DATA` blob,
  PRIMARY KEY (`SCHED_NAME`,`JOB_NAME`,`JOB_GROUP`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `qrtz_job_details`
--

LOCK TABLES `qrtz_job_details` WRITE;
/*!40000 ALTER TABLE `qrtz_job_details` DISABLE KEYS */;
INSERT INTO `qrtz_job_details` VALUES ('MyScheduler','org.jeecg.modules.message.job.SendMsgJob','DEFAULT',NULL,'org.jeecg.modules.message.job.SendMsgJob','0','0','0','0',_binary '?\?0sr\0org.quartz.JobDataMap???迩?\?\0\0xr\0&org.quartz.utils.StringKeyDirtyFlagMap?\??\?(\0Z\0allowsTransientDataxr\0org.quartz.utils.DirtyFlagMap\??(v\n\?\0Z\0dirtyL\0mapt\0Ljava/util/Map;xpsr\0java.util.HashMap\?\?`\?\0F\0\nloadFactorI\0	thresholdxp?@\0\0\0\0\0w\0\0\0\0\0\0t\0	parameterpx\0'),('MyScheduler','org.jeecg.modules.quartz.job.SampleJob','DEFAULT',NULL,'org.jeecg.modules.quartz.job.SampleJob','0','0','0','0',_binary '?\?0sr\0org.quartz.JobDataMap???迩?\?\0\0xr\0&org.quartz.utils.StringKeyDirtyFlagMap?\??\?(\0Z\0allowsTransientDataxr\0org.quartz.utils.DirtyFlagMap\??(v\n\?\0Z\0dirtyL\0mapt\0Ljava/util/Map;xpsr\0java.util.HashMap\?\?`\?\0F\0\nloadFactorI\0	thresholdxp?@\0\0\0\0\0w\0\0\0\0\0\0t\0	parameterpx\0'),('MyScheduler','org.jeecg.modules.quartz.job.SampleParamJob','DEFAULT',NULL,'org.jeecg.modules.quartz.job.SampleParamJob','0','0','0','0',_binary '?\?0sr\0org.quartz.JobDataMap???迩?\?\0\0xr\0&org.quartz.utils.StringKeyDirtyFlagMap?\??\?(\0Z\0allowsTransientDataxr\0org.quartz.utils.DirtyFlagMap\??(v\n\?\0Z\0dirtyL\0mapt\0Ljava/util/Map;xpsr\0java.util.HashMap\?\?`\?\0F\0\nloadFactorI\0	thresholdxp?@\0\0\0\0\0w\0\0\0\0\0\0t\0	parametert\0scottx\0');
/*!40000 ALTER TABLE `qrtz_job_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `qrtz_locks`
--

DROP TABLE IF EXISTS `qrtz_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `qrtz_locks` (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `LOCK_NAME` varchar(40) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`LOCK_NAME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `qrtz_locks`
--

LOCK TABLES `qrtz_locks` WRITE;
/*!40000 ALTER TABLE `qrtz_locks` DISABLE KEYS */;
INSERT INTO `qrtz_locks` VALUES ('MyScheduler','STATE_ACCESS'),('MyScheduler','TRIGGER_ACCESS'),('quartzScheduler','TRIGGER_ACCESS');
/*!40000 ALTER TABLE `qrtz_locks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `qrtz_paused_trigger_grps`
--

DROP TABLE IF EXISTS `qrtz_paused_trigger_grps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `qrtz_paused_trigger_grps` (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_GROUP`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `qrtz_paused_trigger_grps`
--

LOCK TABLES `qrtz_paused_trigger_grps` WRITE;
/*!40000 ALTER TABLE `qrtz_paused_trigger_grps` DISABLE KEYS */;
/*!40000 ALTER TABLE `qrtz_paused_trigger_grps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `qrtz_scheduler_state`
--

DROP TABLE IF EXISTS `qrtz_scheduler_state`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `qrtz_scheduler_state` (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `INSTANCE_NAME` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `LAST_CHECKIN_TIME` bigint NOT NULL,
  `CHECKIN_INTERVAL` bigint NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`INSTANCE_NAME`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `qrtz_scheduler_state`
--

LOCK TABLES `qrtz_scheduler_state` WRITE;
/*!40000 ALTER TABLE `qrtz_scheduler_state` DISABLE KEYS */;
INSERT INTO `qrtz_scheduler_state` VALUES ('MyScheduler','df102f3ef3131610123217860',1610202735907,10000);
/*!40000 ALTER TABLE `qrtz_scheduler_state` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `qrtz_simple_triggers`
--

DROP TABLE IF EXISTS `qrtz_simple_triggers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `qrtz_simple_triggers` (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `TRIGGER_NAME` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `REPEAT_COUNT` bigint NOT NULL,
  `REPEAT_INTERVAL` bigint NOT NULL,
  `TIMES_TRIGGERED` bigint NOT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_simple_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='InnoDB free: 504832 kB; (`SCHED_NAME` `TRIGGER_NAME` `TRIGGE';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `qrtz_simple_triggers`
--

LOCK TABLES `qrtz_simple_triggers` WRITE;
/*!40000 ALTER TABLE `qrtz_simple_triggers` DISABLE KEYS */;
/*!40000 ALTER TABLE `qrtz_simple_triggers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `qrtz_simprop_triggers`
--

DROP TABLE IF EXISTS `qrtz_simprop_triggers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `qrtz_simprop_triggers` (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `TRIGGER_NAME` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `STR_PROP_1` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `STR_PROP_2` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `STR_PROP_3` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `INT_PROP_1` int DEFAULT NULL,
  `INT_PROP_2` int DEFAULT NULL,
  `LONG_PROP_1` bigint DEFAULT NULL,
  `LONG_PROP_2` bigint DEFAULT NULL,
  `DEC_PROP_1` decimal(13,4) DEFAULT NULL,
  `DEC_PROP_2` decimal(13,4) DEFAULT NULL,
  `BOOL_PROP_1` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `BOOL_PROP_2` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_simprop_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) REFERENCES `qrtz_triggers` (`SCHED_NAME`, `TRIGGER_NAME`, `TRIGGER_GROUP`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='InnoDB free: 504832 kB; (`SCHED_NAME` `TRIGGER_NAME` `TRIGGE';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `qrtz_simprop_triggers`
--

LOCK TABLES `qrtz_simprop_triggers` WRITE;
/*!40000 ALTER TABLE `qrtz_simprop_triggers` DISABLE KEYS */;
/*!40000 ALTER TABLE `qrtz_simprop_triggers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `qrtz_triggers`
--

DROP TABLE IF EXISTS `qrtz_triggers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `qrtz_triggers` (
  `SCHED_NAME` varchar(120) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `TRIGGER_NAME` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `TRIGGER_GROUP` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `JOB_NAME` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `JOB_GROUP` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `DESCRIPTION` varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `NEXT_FIRE_TIME` bigint DEFAULT NULL,
  `PREV_FIRE_TIME` bigint DEFAULT NULL,
  `PRIORITY` int DEFAULT NULL,
  `TRIGGER_STATE` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `TRIGGER_TYPE` varchar(8) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `START_TIME` bigint NOT NULL,
  `END_TIME` bigint DEFAULT NULL,
  `CALENDAR_NAME` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `MISFIRE_INSTR` smallint DEFAULT NULL,
  `JOB_DATA` blob,
  PRIMARY KEY (`SCHED_NAME`,`TRIGGER_NAME`,`TRIGGER_GROUP`) USING BTREE,
  KEY `SCHED_NAME` (`SCHED_NAME`,`JOB_NAME`,`JOB_GROUP`) USING BTREE,
  CONSTRAINT `qrtz_triggers_ibfk_1` FOREIGN KEY (`SCHED_NAME`, `JOB_NAME`, `JOB_GROUP`) REFERENCES `qrtz_job_details` (`SCHED_NAME`, `JOB_NAME`, `JOB_GROUP`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='InnoDB free: 504832 kB; (`SCHED_NAME` `JOB_NAME` `JOB_GROUP`';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `qrtz_triggers`
--

LOCK TABLES `qrtz_triggers` WRITE;
/*!40000 ALTER TABLE `qrtz_triggers` DISABLE KEYS */;
INSERT INTO `qrtz_triggers` VALUES ('MyScheduler','org.jeecg.modules.message.job.SendMsgJob','DEFAULT','org.jeecg.modules.message.job.SendMsgJob','DEFAULT',NULL,1588405730000,1588405680000,5,'PAUSED','CRON',1588405284000,0,NULL,0,''),('MyScheduler','org.jeecg.modules.quartz.job.SampleJob','DEFAULT','org.jeecg.modules.quartz.job.SampleJob','DEFAULT',NULL,1588405730000,1588405729000,5,'PAUSED','CRON',1588405237000,0,NULL,0,''),('MyScheduler','org.jeecg.modules.quartz.job.SampleParamJob','DEFAULT','org.jeecg.modules.quartz.job.SampleParamJob','DEFAULT',NULL,1588405236000,1588405235000,5,'PAUSED','CRON',1588405221000,0,NULL,0,'');
/*!40000 ALTER TABLE `qrtz_triggers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_announcement`
--

DROP TABLE IF EXISTS `sys_announcement`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_announcement` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `titile` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '标题',
  `msg_content` text CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '内容',
  `start_time` datetime DEFAULT NULL COMMENT '开始时间',
  `end_time` datetime DEFAULT NULL COMMENT '结束时间',
  `sender` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '发布人',
  `priority` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '优先级（L低，M中，H高）',
  `msg_category` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '2' COMMENT '消息类型1:通知公告2:系统消息',
  `msg_type` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '通告对象类型（USER:指定用户，ALL:全体用户）',
  `send_status` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '发布状态（0未发布，1已发布，2已撤销）',
  `send_time` datetime DEFAULT NULL COMMENT '发布时间',
  `cancel_time` datetime DEFAULT NULL COMMENT '撤销时间',
  `del_flag` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '删除状态（0，正常，1已删除）',
  `bus_type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '业务类型(email:邮件 bpm:流程)',
  `bus_id` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '业务id',
  `open_type` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '打开方式(组件：component 路由：url)',
  `open_page` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '组件/路由 地址',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `user_ids` text CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '指定用户',
  `msg_abstract` text CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '摘要',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='系统通告表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_announcement`
--

LOCK TABLES `sys_announcement` WRITE;
/*!40000 ALTER TABLE `sys_announcement` DISABLE KEYS */;
INSERT INTO `sys_announcement` VALUES ('1256486502931722242','JeecgBoot 2.2.0版本发布','<h5 id=\"h5_5\" style=\"box-sizing: inherit; font-family: \'PingFang SC\', \'Helvetica Neue\', \'Microsoft YaHei UI\', \'Microsoft YaHei\', \'Noto Sans CJK SC\', Sathu, EucrosiaUPC, Arial, Helvetica, sans-serif; line-height: 1.8; margin: 22px 0px 16px; padding: 0px; font-size: 18px; border: none; color: #333333; background-color: #ffffff;\">升级不兼容</h5>\n<ul style=\"box-sizing: inherit; margin: 0px 0px 20px; padding: 0px 0px 0px 20px; color: #333333; font-family: -apple-system, BlinkMacSystemFont, \'Apple Color Emoji\', \'Segoe UI Emoji\', \'Segoe UI Symbol\', \'Segoe UI\', \'PingFang SC\', \'Hiragino Sans GB\', \'Microsoft YaHei\', \'Helvetica Neue\', Helvetica, Arial, sans-serif; font-size: 16px; background-color: #ffffff;\">\n<li style=\"box-sizing: inherit; line-height: 1.875em; margin-top: 0px;\">1、升级 ant-design-vue 到最新版本 1.5.2，会导致使用disabled的组件不可用（需要全局替换disabled 为readOnly；另外原来readOnly不允许全小写）</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">2、JSearchSelectTag.vue行编辑的popup传参做了修改，需要全局替换 orgFieldse 为 orgFields</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">3、 项目删除了sass，全部换成 less，其中涉及/deep/语法得改造</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em; margin-bottom: 0px;\">4、 Online表单的填值规则用法修改了&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" href=\"http://doc.jeecg.com/1630378\">文档</a></li>\n</ul>\n<h5 id=\"h5_6\" style=\"box-sizing: inherit; font-family: \'PingFang SC\', \'Helvetica Neue\', \'Microsoft YaHei UI\', \'Microsoft YaHei\', \'Noto Sans CJK SC\', Sathu, EucrosiaUPC, Arial, Helvetica, sans-serif; line-height: 1.8; margin: 22px 0px 16px; padding: 0px; font-size: 18px; border: none; color: #333333; background-color: #ffffff;\">较大改造</h5>\n<ul style=\"box-sizing: inherit; margin: 0px 0px 20px; padding: 0px 0px 0px 20px; color: #333333; font-family: -apple-system, BlinkMacSystemFont, \'Apple Color Emoji\', \'Segoe UI Emoji\', \'Segoe UI Symbol\', \'Segoe UI\', \'PingFang SC\', \'Hiragino Sans GB\', \'Microsoft YaHei\', \'Helvetica Neue\', Helvetica, Arial, sans-serif; font-size: 16px; background-color: #ffffff;\">\n<li style=\"box-sizing: inherit; line-height: 1.875em; margin-top: 0px;\">登录的时候一次性加载系统字典，进行前端缓存，减少ajax重复请求</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">修改定时任务quartz配置</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">logback-spring.xml配置不按照日期和大小生成新日志文件问题修复</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">vue-cli3 编译打包进行zip压缩优化</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">根据index.html页面window._CONFIG[\'domianURL\']，指定 axios的 baseURL（所以vue的代理没有用了）</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">JEditableTable重构，新增获取值时应该把临时id去掉、行编辑修改不直接更改数据源的ID</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em; margin-bottom: 0px;\">Online模块重点优化升级、Online代码生成器重点优化升级</li>\n</ul>\n<h5 id=\"h5_7\" style=\"box-sizing: inherit; font-family: \'PingFang SC\', \'Helvetica Neue\', \'Microsoft YaHei UI\', \'Microsoft YaHei\', \'Noto Sans CJK SC\', Sathu, EucrosiaUPC, Arial, Helvetica, sans-serif; line-height: 1.8; margin: 22px 0px 16px; padding: 0px; font-size: 18px; border: none; color: #333333; background-color: #ffffff;\">ONLINE升级</h5>\n<ul style=\"box-sizing: inherit; margin: 0px 0px 20px; padding: 0px 0px 0px 20px; color: #333333; font-family: -apple-system, BlinkMacSystemFont, \'Apple Color Emoji\', \'Segoe UI Emoji\', \'Segoe UI Symbol\', \'Segoe UI\', \'PingFang SC\', \'Hiragino Sans GB\', \'Microsoft YaHei\', \'Helvetica Neue\', Helvetica, Arial, sans-serif; font-size: 16px; background-color: #ffffff;\">\n<li style=\"box-sizing: inherit; line-height: 1.875em; margin-top: 0px;\">Online访问权限控制实现，如果online表单配置了菜单，则用户需要授权才能访问此表单</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online表单新增组件： 省市区地域组件、开关组件、三级联动(级联下拉)组件、markdown组件</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online表单弹窗宽度，根据不同的列数显示不同的宽度，实现更好的效果</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online 树表单功能一系列优化，比如数据列新增添加下级按钮功能、添加下级不自动展开列表等问题</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online JS增强编辑器支持放大，同时JS代码变更，增加版本记忆功能，方便追踪历史</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online JS增强支持lodash工具</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online控件 默认值表达式功能&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" href=\"http://doc.jeecg.com/1630378\">文档</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online 增加Excel导入导出转换器配置，针对各种控件的导入导出做了统一处理</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online 列表字段排序支持配置</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online同步数据库，数据库兼容性优化（mysql、oracle11g、SqlServer2017）</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online功能列表，高级查询优化，丰富控件的支持（新增：用户选择、部门选择、时间等）</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online表单配置，类型Text、date、Blob的字段长度默认设置为0</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online自定义button，支持位置自定义（支持右侧和下方）</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online表单列表，列表显示那些字段，支持用户个性化设置</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online表单删除和移除逻辑优化，防止未同步情况下删除报错</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online上传逻辑重构，针对单表、一对多行操作，都支持图片和文件上传，同时支持三种模式（minio、阿里云、本地存储）</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online上传逻辑重构， 行编辑模式，支持图片顺序修改</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online上传逻辑重构，在列表页面支持图片和文件的展示</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online表单索引同步逻辑重构，同时支持选择多个字段，组合索引设置</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online表单 excel导出实现数据权限逻辑</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online表单列表强制列不换行，自动出现超出滚定条，支持移动端自适应（单表、树和ERP等模型都已修改）</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online表单管理列表，回车查询和列表左右拖动移动自适应问题</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online表单附表序号必填</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online表名加校验不能全是数字，自动trim空格</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online 一对多tab必填校验不通过，添加友好提醒</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online表单控件默认值示例</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online一对多内嵌子表风格，高级查询不好用，过滤不了数据处理</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online表单 自定义校验规则正则，录入不成功问题处理</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online表单设置不分页，排序后又分页了问题处理</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online表单，下拉搜索组件，表字典配置加条件，下拉值出不来问题处理</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online表单，一对一子表，下拉选择、时间等组件被遮挡问题处理</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online表单树模型和一对多ERP模板支持href</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online 报表支持上下文变量表达式</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online 报表实现数据权限逻辑</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online 报表新增拖动字段顺序</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online 报表列表，sql过长截取显示</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">Online 报表，popup回车查询</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em; margin-bottom: 0px;\">Online表单auto页面弹窗改成JModule；online表单移动自适应；</li>\n</ul>\n<h5 id=\"h5_8\" style=\"box-sizing: inherit; font-family: \'PingFang SC\', \'Helvetica Neue\', \'Microsoft YaHei UI\', \'Microsoft YaHei\', \'Noto Sans CJK SC\', Sathu, EucrosiaUPC, Arial, Helvetica, sans-serif; line-height: 1.8; margin: 22px 0px 16px; padding: 0px; font-size: 18px; border: none; color: #333333; background-color: #ffffff;\">Online代码生成器升级</h5>\n<blockquote style=\"box-sizing: inherit; position: relative; margin: 0px 0px 20px; padding: 20px; background-color: #f6f6f6; border-left: 6px solid #e6e6e6; word-break: break-word; color: #333333; font-family: -apple-system, BlinkMacSystemFont, \'Apple Color Emoji\', \'Segoe UI Emoji\', \'Segoe UI Symbol\', \'Segoe UI\', \'PingFang SC\', \'Hiragino Sans GB\', \'Microsoft YaHei\', \'Helvetica Neue\', Helvetica, Arial, sans-serif; font-size: 16px;\">\n<p style=\"box-sizing: inherit; margin: 0px; line-height: inherit;\">后期重点维护ONLINE模式的代码生成器，GUI模式逐步弃用。</p>\n</blockquote>\n<ul style=\"box-sizing: inherit; margin: 0px 0px 20px; padding: 0px 0px 0px 20px; color: #333333; font-family: -apple-system, BlinkMacSystemFont, \'Apple Color Emoji\', \'Segoe UI Emoji\', \'Segoe UI Symbol\', \'Segoe UI\', \'PingFang SC\', \'Hiragino Sans GB\', \'Microsoft YaHei\', \'Helvetica Neue\', Helvetica, Arial, sans-serif; font-size: 16px; background-color: #ffffff;\">\n<li style=\"box-sizing: inherit; line-height: 1.875em; margin-top: 0px;\">新增内嵌Table代码生成器模板</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">升级代码生成器依赖，支持返回生成结果&amp;支持服务器端生成代码config</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">代码生成器列表，列表自适应优化，支持移动效果（强制列不换行，不过有弊端，<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" href=\"http://doc.jeecg.com/1607183\">见文档</a>）</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">实体生成，自动带着swagger 注解（支持单表、一对多等模型）</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">代码生成器，列表移动自适应样式修改</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">生成后的代码导入导出bug修复</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">online树代码生成器模板，直接删除一级分类会导致列表乱</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">ERP代码生成器模板升级，子表支持导入导出</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">ERP风格代码生成器模板问题（导入导入路径错误、swagger注解问题）</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">代码生成器，校验为空的话不生成，简化生成的代码</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">代码生成器，支持子表校验生成</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">树形列表代码生成器优化，添加子节点</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">修复bug： online字典未配置，代码生成器报错问题</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">生成的实体字段excel注解，针对系统标准字段，创建人、创建时间等字段不生成</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">生成的表单弹窗统一更换为j-modal，支持放大缩小全屏</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">代码生成，popup参数大小写 驼峰问题修复</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">生成的表单控件类型更丰富，新支持控件：markdown、省市区地域、密码、下拉搜索</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em; margin-bottom: 0px;\">生成的列表查询区域，控件支持加强，新支持控件：省市区地域、下拉搜索、popup、选择用户、选择部门</li>\n</ul>\n<h5 id=\"h5_9\" style=\"box-sizing: inherit; font-family: \'PingFang SC\', \'Helvetica Neue\', \'Microsoft YaHei UI\', \'Microsoft YaHei\', \'Noto Sans CJK SC\', Sathu, EucrosiaUPC, Arial, Helvetica, sans-serif; line-height: 1.8; margin: 22px 0px 16px; padding: 0px; font-size: 18px; border: none; color: #333333; background-color: #ffffff;\">平台基础升级</h5>\n<ul style=\"box-sizing: inherit; margin: 0px 0px 20px; padding: 0px 0px 0px 20px; color: #333333; font-family: -apple-system, BlinkMacSystemFont, \'Apple Color Emoji\', \'Segoe UI Emoji\', \'Segoe UI Symbol\', \'Segoe UI\', \'PingFang SC\', \'Hiragino Sans GB\', \'Microsoft YaHei\', \'Helvetica Neue\', Helvetica, Arial, sans-serif; font-size: 16px; background-color: #ffffff;\">\n<li style=\"box-sizing: inherit; line-height: 1.875em; margin-top: 0px;\">针对auto隐藏路由菜单，实现自动授权，简化online菜单的授权</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">IDE中找不到sun.misc.BASE64Encoder jar包问题</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">删掉作废获取所有用户角色列表接口，接口有性能问题</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">在我的消息里点击已读以后，首页上面的通知红点并没有同步更改问题修复</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">用户与部门取消关联删除关联关系bug修改</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">部门导入未刷新redis缓存</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">修复SysPermissionMapper.xml 的SQL语句不兼容SQLServer的问题</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">在线动态数据源代码重构</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">【二级管理员】部门修改、删除权限时关联删除部门角色数据</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">【二级管理员】我的部门，选中部门只能看当前部门下的角色</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">我的消息支持模糊查询</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">常用示例-对象存储文件上传优化</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">用户相关功能，sql写法不兼容其他数据库问题修复</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">图片上传组件修改</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">导入功能优化，提示准确导入成功失败信息，涉及功能 用户、角色、部门、字典、定时任务等</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">增加生产环境禁用swagger-ui配置</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">第三方登录代码集成</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">系统公告优化</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">MockController 返回json数据，utf-8格式化，防止中文乱码</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">部门删除后删除部门角色等关联</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em; margin-bottom: 0px;\">分类字典支持选择数据，添加下级分类</li>\n</ul>\n<h5 id=\"h5_10\" style=\"box-sizing: inherit; font-family: \'PingFang SC\', \'Helvetica Neue\', \'Microsoft YaHei UI\', \'Microsoft YaHei\', \'Noto Sans CJK SC\', Sathu, EucrosiaUPC, Arial, Helvetica, sans-serif; line-height: 1.8; margin: 22px 0px 16px; padding: 0px; font-size: 18px; border: none; color: #333333; background-color: #ffffff;\">UI组件升级</h5>\n<ul style=\"box-sizing: inherit; margin: 0px 0px 20px; padding: 0px 0px 0px 20px; color: #333333; font-family: -apple-system, BlinkMacSystemFont, \'Apple Color Emoji\', \'Segoe UI Emoji\', \'Segoe UI Symbol\', \'Segoe UI\', \'PingFang SC\', \'Hiragino Sans GB\', \'Microsoft YaHei\', \'Helvetica Neue\', Helvetica, Arial, sans-serif; font-size: 16px; background-color: #ffffff;\">\n<li style=\"box-sizing: inherit; line-height: 1.875em; margin-top: 0px;\">升级 ant-design-vue 为最新版本 1.5.2</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">登录验证码获取失败的时候，不显示空白</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">升级 ant-design-vue，JModal切换全屏按钮因ant升级错位问题修复</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">简化 j-modal 的相关代码</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">封装常用组件示例；JInput新增当 type 变化的时候重新计算值</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">markdown集成</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">富文本支持minio上传</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">选择用户组件列表样式错位；Ellipsis.vue 优化</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">JModal移动端全屏效果</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">高级查询只有在 in 模式下才能多选</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">自定义选择用户组件JSelectMultiUser的宽度和截取显示长度</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">行编辑 JEditableTable移动自适应效果；</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">JEditableTable重构 行编辑新增合计功能</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">JEditableTable重构 行编辑Popup请求数量过多（加缓存机制）</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">JEditableTable重构,行编辑InputNumber扩展支持输入小数和负数</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">JEditableTable.vue disable模式禁用添加删除按钮</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">JEditableTable行编辑， popup返回值，时间赋值有问题</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">JEditableTable行编辑，日期控件显示错位问题</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">高级查询移动自适应效果；</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">高级查询保存的同时也要保存匹配方式（支持and or）</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">高级查询混入统一修改</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">高级查询选择用户组件时，点开用户弹框不选择用户，直接关掉用户弹框，再次点击弹框时，无法点开问题</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">高级查询组件支持，新支持组件，选择人、选择部门、popup、时间等</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">JPopup支持多选</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">JPopup返回值null问题</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">JPopup列表数据不刷新问题</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">JSearchSelectTag.vue匹配不上数字值问题</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">JSelectUserByDep 根据部门选择人组件bug</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">JTreeDict.vue 分类字典组件 清空不了问题</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">常用示例，新增搜索下拉 JSearchSelectTag.vue例子</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">常用示例，新增如何关闭当前页面例子</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">常用示例，省市区三级联动的例子</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">常用示例，增加字典下拉多选组件示例</li>\n<li style=\"box-sizing: inherit; line-height: 1.875em; margin-bottom: 0px;\">示例demo，关于图片的做统一优化</li>\n</ul>\n<h5 id=\"h5_11\" style=\"box-sizing: inherit; font-family: \'PingFang SC\', \'Helvetica Neue\', \'Microsoft YaHei UI\', \'Microsoft YaHei\', \'Noto Sans CJK SC\', Sathu, EucrosiaUPC, Arial, Helvetica, sans-serif; line-height: 1.8; margin: 22px 0px 16px; padding: 0px; font-size: 18px; border: none; color: #333333; background-color: #ffffff;\">Issues处理</h5>\n<ul style=\"box-sizing: inherit; margin: 0px 0px 20px; padding: 0px 0px 0px 20px; color: #333333; font-family: -apple-system, BlinkMacSystemFont, \'Apple Color Emoji\', \'Segoe UI Emoji\', \'Segoe UI Symbol\', \'Segoe UI\', \'PingFang SC\', \'Hiragino Sans GB\', \'Microsoft YaHei\', \'Helvetica Neue\', Helvetica, Arial, sans-serif; font-size: 16px; background-color: #ffffff;\">\n<li style=\"box-sizing: inherit; line-height: 1.875em; margin-top: 0px;\">online form表单项能否支持配置有级联关系的内容&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#948\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/948\">#948</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">全局拦截异常错误的提醒文字&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#768\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/768\">#768</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">建议：城市级联选择组件&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#905\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/905\">#905</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">表单配置中检验字段配置href，报表中该配置字段无法看到链接&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#961\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/961\">#961</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">SysUserMapper.xml查询脚本数据兼容问题&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#962\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/962\">#962</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">在线表单 提示 ButtonExpHandler is not defined&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#957\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/957\">#957</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">online表单中添加自定义按钮无法显示&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#973\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/973\">#973</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">online报表不支持按照登录用户过滤数据&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#934\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/934\">#934</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">点击新增或者编辑按钮弹框宽度的设置问题&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#974\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/974\">#974</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">online报表配置中使用系统参数，报错&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"I1AWNM\" href=\"https://gitee.com/jeecg/jeecg-boot/issues/I1AWNM\">I1AWNM</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">online增强SQL变量取数为null,#{sys.sys_date} 还有#{sys.sys_time}&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#999\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/999\">#999</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">一个主表，多个付表。1对多。保存后，某些从表行项目内容保存成功，单重新打开数据表现丢失。&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#997\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/997\">#997</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">/online/cgform/api/exportXls/{code}接口问题&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#1012\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/1012\">#1012</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">打成jar包，访问不到代码生成器模板&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#1010\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/1010\">#1010</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">online表单开发，打包后模板找不到&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#865\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/865\">#865</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">已生成的代码，子表最下下行添加合计行底部固定问题&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#936\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/936\">#936</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">下拉搜索框在编辑时下拉name无法带过来&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#971\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/971\">#971</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">建议autoPoi升级，优化数据返回List Map格式下的复合表头导出excel的体验&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#873\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/873\">#873</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">配置 Href 跳转，并没有显示为超链接&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#1020\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/1020\">#1020</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">首次打开一对多表单，JEditableTable的addDefaultRowNum属性不生效&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#1003\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/1003\">#1003</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">autopoi 双表头问题&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#862\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/862\">#862</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">应该是权限管理bug&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#110\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/110\">#110</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">在线 的online报表报错&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#1029\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/1029\">#1029</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">online代码生成器树形表单父节点字段名称问题&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"issues/I1ABGV \" href=\"https://gitee.com/jeecg/jeecg-boot/issues/I1ABGV\">issues/I1ABGV</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">点击j-popup,里面有数据，如果选择同名的数据，文本框为空&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#1044\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/1044\">#1044</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">关于table列宽可拖动问题&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#1054\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/1054\">#1054</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">单表数据导出多表头 auto 的Excel注解 groupName属性<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\" #1053\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/1053\">&nbsp;#1053</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">在线报表和在线online的问题&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#1030\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/1030\">#1030</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">J-pop组件&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#1043\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/1043\">#1043</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">2.1.4 日志管理---没有记录查询接口参数&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#1070\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/1070\">#1070</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">服务器日志超过设置的MaxFileSize时&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#1130\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/1130\">#1130</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">online 表单中，在 附表中存在上传图片组件，点击上传图片并提交，显示提交失败&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#1074\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/1074\">#1074</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">online表单js增强修改从表控件值问题&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#1051\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/1051\">#1051</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">重复代理问题&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#994\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/994\">#994</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">系统使用的日志包有问题&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#887\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/887\">#887</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">使用sqlserver数据库,用户管理查询出错&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#1140\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/1140\">#1140</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">主表和从表 一对一关系表单 TypeError: Cannot read property \'getAll\' of undefined&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"#1129\" href=\"https://github.com/zhangdaiscott/jeecg-boot/issues/1129\">#1129</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">ERP表单附表数据编辑后消失&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"issues/I1DN3B\" href=\"https://gitee.com/jeecg/jeecg-boot/issues/I1DN3B\">issues/I1DN3B</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">多表的erp模式生成的子表，表单没有导入导出功能&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"issues/I1BB2U\" href=\"https://gitee.com/jeecg/jeecg-boot/issues/I1BB2U\">issues/I1BB2U</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">用edge打开首页，整个页面动不了，控制台console打出很多错误&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"issues/I189B5\" href=\"https://gitee.com/jeecg/jeecg-boot/issues/I189B5\">issues/I189B5</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">官方的快速开发平台主子表对IE11不兼容&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"issues/I17LEE\" href=\"https://gitee.com/jeecg/jeecg-boot/issues/I17LEE\">issues/I17LEE</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em;\">360兼容模式 修改为你说的js之后；单表的数据兼容可以；主子表的不加载；错误如下&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"issues/I17H8L\" href=\"https://gitee.com/jeecg/jeecg-boot/issues/I17H8L\">issues/I17H8L</a></li>\n<li style=\"box-sizing: inherit; line-height: 1.875em; margin-bottom: 0px;\">Online表单开发，点击&ldquo;新增&rdquo;按钮，是否树：选择是，页面控制台报错&nbsp;<a style=\"box-sizing: inherit; background-color: transparent; color: #4183c4; text-decoration-line: none;\" title=\"issues/I1BHXG\" href=\"https://gitee.com/jeecg/jeecg-boot/issues/I1BHXG\">issues/I1BHXG</a></li>\n</ul>','2020-05-01 15:30:56','2020-05-30 15:31:00','admin','H','1','ALL','1','2020-05-02 15:31:44',NULL,'0',NULL,NULL,NULL,NULL,'admin','2020-05-02 15:31:41','admin','2020-05-02 15:31:44',NULL,'重磅版本发布'),('1256486817286418434','放假通知','<p>放假通知</p>','2020-05-02 15:32:38','2020-05-30 15:32:40','admin','M','1','USER','1','2020-05-02 15:32:59',NULL,'0',NULL,NULL,NULL,NULL,'admin','2020-05-02 15:32:56','admin','2020-05-02 15:32:59','e9ca23d68d884d4ebb19d07889727dae,a75d45a015c44384a04449ee80dc3503,','放假通知'),('1256529336858685441','1','<p>22</p>','2020-05-02 18:21:41','2020-05-30 18:21:44','admin','M','1','ALL','2','2020-05-02 18:21:57','2020-05-02 18:22:07','0',NULL,NULL,NULL,NULL,'admin','2020-05-02 18:21:54','admin','2020-05-02 18:22:07',NULL,'22'),('1330867217151279105','aaggbb','aaggbb',NULL,NULL,'admin','M','2','USER','1','2020-11-23 21:34:06',NULL,'0',NULL,NULL,NULL,NULL,'admin','2020-11-23 21:34:06',NULL,NULL,NULL,NULL),('1330871775264964610','aaggbb009','aaggbb009',NULL,NULL,'admin','M','2','USER','1','2020-11-23 21:52:12',NULL,'0',NULL,NULL,NULL,NULL,'HectorLi','2020-11-23 21:52:12',NULL,NULL,NULL,NULL),('1330871938901540866','aaggbb009','aaggbb009',NULL,NULL,'admin','M','2','USER','1','2020-11-23 21:52:51',NULL,'0',NULL,NULL,NULL,NULL,'admin','2020-11-23 21:52:51',NULL,NULL,NULL,NULL),('1330914317142487041','aaggbb009','aaggbb009',NULL,NULL,'admin','M','2','USER','1','2020-11-24 00:41:15',NULL,'0',NULL,NULL,NULL,NULL,'HectorLi','2020-11-24 00:41:15',NULL,NULL,NULL,NULL),('1331066484947947522','aaggbb','aaggbb',NULL,NULL,'admin','M','2','USER','1','2020-11-24 10:45:55',NULL,'0',NULL,NULL,NULL,NULL,'yuchengxi','2020-11-24 10:45:55',NULL,NULL,NULL,NULL),('1331814582909407233','aaggbb009','aaggbb009',NULL,NULL,'admin','M','2','USER','1','2020-11-26 12:18:35',NULL,'0',NULL,NULL,NULL,NULL,'yuchengxi','2020-11-26 12:18:35',NULL,NULL,NULL,NULL),('1331814751675617282','aaggbb','aaggbb',NULL,NULL,'admin','M','2','USER','1','2020-11-26 12:19:15',NULL,'0',NULL,NULL,NULL,NULL,'yuchengxi','2020-11-26 12:19:15',NULL,NULL,NULL,NULL),('1331865003204022273','aaggbb','aaggbb',NULL,NULL,'admin','M','2','USER','1','2020-11-26 15:38:56',NULL,'0',NULL,NULL,NULL,NULL,'jww','2020-11-26 15:38:56',NULL,NULL,NULL,NULL),('1331865651765055490','aaggbb009','aaggbb009',NULL,NULL,'admin','M','2','USER','1','2020-11-26 15:41:31',NULL,'0',NULL,NULL,NULL,NULL,'jww','2020-11-26 15:41:31',NULL,NULL,NULL,NULL),('1331865968741191682','aaggbb009','aaggbb009',NULL,NULL,'admin','M','2','USER','1','2020-11-26 15:42:46',NULL,'0',NULL,NULL,NULL,NULL,'jww','2020-11-26 15:42:46',NULL,NULL,NULL,NULL),('1331990321508286465','wewe','wewewe',NULL,NULL,'admin','M','2','USER','1','2020-11-26 23:56:54',NULL,'0',NULL,NULL,NULL,NULL,'admin','2020-11-26 23:56:54',NULL,NULL,NULL,NULL),('1331990695736672258','dfd','fdfdf',NULL,NULL,'admin','M','2','USER','1','2020-11-26 23:58:24',NULL,'0',NULL,NULL,NULL,NULL,'admin','2020-11-26 23:58:24',NULL,NULL,NULL,NULL),('1331990792977416193','dfd','dfdf',NULL,NULL,'admin','M','2','USER','1','2020-11-26 23:58:47',NULL,'0',NULL,NULL,NULL,NULL,'admin','2020-11-26 23:58:47',NULL,NULL,NULL,NULL),('1331991062914433025','jjrriuii','jjrriuii',NULL,NULL,'admin','M','2','USER','1','2020-11-26 23:59:51',NULL,'0',NULL,NULL,NULL,NULL,'admin','2020-11-26 23:59:51',NULL,NULL,NULL,NULL),('1331991090152243202','jjrriuii','jjrriuii',NULL,NULL,'admin','M','2','USER','1','2020-11-26 23:59:58',NULL,'0',NULL,NULL,NULL,NULL,'admin','2020-11-26 23:59:58',NULL,NULL,NULL,NULL),('1331991714910691330','uuoopp','uuoopp',NULL,NULL,'HectorLi','M','2','USER','1','2020-11-27 00:02:27',NULL,'0',NULL,NULL,NULL,NULL,'HectorLi','2020-11-27 00:02:27',NULL,NULL,NULL,NULL),('1332006790639915009','534343','34343',NULL,NULL,'admin','M','2','USER','1','2020-11-27 01:02:21',NULL,'0',NULL,NULL,NULL,NULL,'admin','2020-11-27 01:02:21',NULL,NULL,NULL,NULL),('1332135683229224962','请维护好单价','商品*****没有维护好单价',NULL,NULL,'yuchengxi','M','2','USER','1','2020-11-27 09:34:31',NULL,'0',NULL,NULL,NULL,NULL,'yuchengxi','2020-11-27 09:34:31',NULL,NULL,NULL,NULL),('1332136878987546625','请维护单价','请维护商品***单价',NULL,NULL,'jww','M','2','USER','1','2020-11-27 09:39:17',NULL,'0',NULL,NULL,NULL,NULL,'jww','2020-11-27 09:39:17',NULL,NULL,NULL,NULL),('1332140052741885953','请维护好单价','请维护好商品单价',NULL,NULL,'admin','M','2','USER','1','2020-11-27 09:51:53',NULL,'0',NULL,NULL,NULL,NULL,'admin','2020-11-27 09:51:53',NULL,NULL,NULL,NULL),('1332256795233619969','请维护好单价','请维护好单价',NULL,NULL,'yuchengxi','M','2','USER','1','2020-11-27 17:35:47',NULL,'0',NULL,NULL,NULL,NULL,'yuchengxi','2020-11-27 17:35:47',NULL,NULL,NULL,NULL),('1337603082078392321','请维护单价','请维护单价',NULL,NULL,'yuchengxi','M','2','USER','1','2020-12-12 11:40:01',NULL,'0',NULL,NULL,NULL,NULL,'yuchengxi','2020-12-12 11:40:01',NULL,NULL,NULL,NULL),('1337739731227643906','123','123',NULL,NULL,'yuchengxi','M','2','USER','1','2020-12-12 20:43:01',NULL,'0',NULL,NULL,NULL,NULL,'yuchengxi','2020-12-12 20:43:01',NULL,NULL,NULL,NULL),('1b714f8ebc3cc33f8b4f906103b6a18d','5467567',NULL,NULL,NULL,'admin',NULL,'2',NULL,'1','2019-03-30 12:40:38',NULL,'1',NULL,NULL,NULL,NULL,'admin','2019-02-26 17:23:26','admin','2020-05-02 15:30:42',NULL,NULL),('3d11237ccdf62450d20bb8abdb331178','111222',NULL,NULL,NULL,NULL,NULL,'2',NULL,'0',NULL,NULL,'1',NULL,NULL,NULL,NULL,'admin','2019-03-29 17:19:47','admin','2019-03-29 17:19:50',NULL,NULL),('7ef04e95f8de030b1d5f7a9144090dc6','111',NULL,'2019-02-06 17:28:10','2019-03-08 17:28:11',NULL,NULL,'2',NULL,'0',NULL,NULL,'1',NULL,NULL,NULL,NULL,'admin','2019-02-26 17:28:17','admin','2019-03-26 19:59:49',NULL,NULL),('93a9060a1c20e4bf98b3f768a02c2ff9','111','111','2019-02-06 17:20:17','2019-02-21 17:20:20','admin','M','2','ALL','1','2019-02-26 17:24:29',NULL,'1',NULL,NULL,NULL,NULL,'admin','2019-02-26 17:16:26','admin','2020-05-02 15:30:42',NULL,NULL),('de1dc57f31037079e1e55c8347fe6ef7','222','2222','2019-02-06 17:28:26','2019-02-23 17:28:28','admin','M','2','ALL','1','2019-03-29 17:19:56',NULL,'1',NULL,NULL,NULL,NULL,'admin','2019-02-26 17:28:36','admin','2019-02-26 17:28:40',NULL,NULL),('e52f3eb6215f139cb2224c52517af3bd','334','334',NULL,NULL,NULL,NULL,'2',NULL,'0',NULL,NULL,'1',NULL,NULL,NULL,NULL,'admin','2019-03-30 12:40:28','admin','2019-03-30 12:40:32',NULL,NULL);
/*!40000 ALTER TABLE `sys_announcement` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_announcement_send`
--

DROP TABLE IF EXISTS `sys_announcement_send`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_announcement_send` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `annt_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '通告ID',
  `user_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '用户id',
  `read_flag` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '阅读状态（0未读，1已读）',
  `read_time` datetime DEFAULT NULL COMMENT '阅读时间',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='用户通告阅读标记表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_announcement_send`
--

LOCK TABLES `sys_announcement_send` WRITE;
/*!40000 ALTER TABLE `sys_announcement_send` DISABLE KEYS */;
INSERT INTO `sys_announcement_send` VALUES ('646c0c405ec643d4dc4160db2446f8ff','93a9060a1c20e4bf98b3f768a02c2ff9','e9ca23d68d884d4ebb19d07889727dae','1','2019-11-21 16:30:01','admin','2019-05-17 11:50:56','admin','2019-11-21 16:30:01'),('1197434450981543938','93a9060a1c20e4bf98b3f768a02c2ff9','a75d45a015c44384a04449ee80dc3503','0',NULL,'jeecg','2019-11-21 16:39:55',NULL,NULL),('1256486817319972866','1256486817286418434','e9ca23d68d884d4ebb19d07889727dae','1','2020-11-10 18:07:39','admin','2020-05-02 15:32:56','admin','2020-11-10 18:07:39'),('1256486817349332993','1256486817286418434','a75d45a015c44384a04449ee80dc3503','0','2020-05-02 15:32:56','admin','2020-05-02 15:32:56',NULL,NULL),('1256527099214278657','1256486502931722242','e9ca23d68d884d4ebb19d07889727dae','1','2020-11-10 18:06:04','admin','2020-05-02 18:12:59','admin','2020-11-10 18:06:04'),('1260927781673484290','1256486502931722242','a75d45a015c44384a04449ee80dc3503','0',NULL,'jeecg','2020-05-14 21:39:45',NULL,NULL),('1330867217373577217','1330867217151279105','e9ca23d68d884d4ebb19d07889727dae','1','2020-11-23 21:34:39','admin','2020-11-23 21:34:06','admin','2020-11-23 21:34:39'),('1330871775474679810','1330871775264964610','1330867917981728770','1','2020-11-23 21:52:18','HectorLi','2020-11-23 21:52:12','HectorLi','2020-11-23 21:52:18'),('1330871939169976322','1330871938901540866','1330867917981728770','1','2020-11-23 21:54:31','admin','2020-11-23 21:52:51','HectorLi','2020-11-23 21:54:31'),('1330914317322842113','1330914317142487041','1330867917981728770','1','2020-11-24 10:47:40','HectorLi','2020-11-24 00:41:15','HectorLi','2020-11-24 10:47:40'),('1331066485287686146','1331066484947947522','e9ca23d68d884d4ebb19d07889727dae','1','2020-11-24 11:08:47','yuchengxi','2020-11-24 10:45:55','admin','2020-11-24 11:08:47'),('1331814583085568001','1331814582909407233','1330867917981728770','1','2020-11-26 12:29:57','yuchengxi','2020-11-26 12:18:35','HectorLi','2020-11-26 12:29:57'),('1331814751738531841','1331814751675617282','e9ca23d68d884d4ebb19d07889727dae','1','2020-12-05 17:16:26','yuchengxi','2020-11-26 12:19:15','admin','2020-12-05 17:16:26'),('1331865003321462785','1331865003204022273','e9ca23d68d884d4ebb19d07889727dae','1','2020-12-05 17:16:25','jww','2020-11-26 15:38:56','admin','2020-12-05 17:16:25'),('1331865651840552962','1331865651765055490','1330867917981728770','0',NULL,'jww','2020-11-26 15:41:31',NULL,NULL),('1331865968908963842','1331865968741191682','1330867917981728770','0',NULL,'jww','2020-11-26 15:42:47',NULL,NULL),('1331990322393284610','1331990321508286465','f0019fdebedb443c98dcb17d88222c38','0',NULL,'admin','2020-11-26 23:56:55',NULL,NULL),('1331990323064373249','1331990321508286465','1331909887347363842','0',NULL,'admin','2020-11-26 23:56:55',NULL,NULL),('1331990695992524802','1331990695736672258','e9ca23d68d884d4ebb19d07889727dae','1','2020-12-05 17:16:23','admin','2020-11-26 23:58:24','admin','2020-12-05 17:16:23'),('1331990793300377602','1331990792977416193','e9ca23d68d884d4ebb19d07889727dae','1','2020-12-05 17:16:18','admin','2020-11-26 23:58:47','admin','2020-12-05 17:16:18'),('1331990793648504834','1331990792977416193','f0019fdebedb443c98dcb17d88222c38','0',NULL,'admin','2020-11-26 23:58:47',NULL,NULL),('1331991063245783041','1331991062914433025','e9ca23d68d884d4ebb19d07889727dae','1','2020-12-05 17:16:12','admin','2020-11-26 23:59:51','admin','2020-12-05 17:16:12'),('1331991063484858369','1331991062914433025','1330867917981728770','0',NULL,'admin','2020-11-26 23:59:51',NULL,NULL),('1331991090366152706','1331991090152243202','e9ca23d68d884d4ebb19d07889727dae','1','2020-11-27 09:57:43','admin','2020-11-26 23:59:58','admin','2020-11-27 09:57:43'),('1331991090605228034','1331991090152243202','1330867917981728770','0',NULL,'admin','2020-11-26 23:59:58',NULL,NULL),('1331991715191709697','1331991714910691330','e9ca23d68d884d4ebb19d07889727dae','1','2020-11-27 09:50:20','HectorLi','2020-11-27 00:02:27','admin','2020-11-27 09:50:20'),('1331991715497893890','1331991714910691330','f0019fdebedb443c98dcb17d88222c38','0',NULL,'HectorLi','2020-11-27 00:02:27',NULL,NULL),('1331991715736969217','1331991714910691330','1330867917981728770','1','2020-11-27 00:02:45','HectorLi','2020-11-27 00:02:27','HectorLi','2020-11-27 00:02:45'),('1332006791239700482','1332006790639915009','e9ca23d68d884d4ebb19d07889727dae','1','2020-11-27 09:50:14','admin','2020-11-27 01:02:21','admin','2020-11-27 09:50:14'),('1332006792179224578','1332006790639915009','f0019fdebedb443c98dcb17d88222c38','0',NULL,'admin','2020-11-27 01:02:21',NULL,NULL),('1332006792468631554','1332006790639915009','1331909887347363842','0',NULL,'admin','2020-11-27 01:02:21',NULL,NULL),('1332006792779010050','1332006790639915009','1331535606880899073','0',NULL,'admin','2020-11-27 01:02:22',NULL,NULL),('1332006793089388546','1332006790639915009','1330867917981728770','0',NULL,'admin','2020-11-27 01:02:22',NULL,NULL),('1332006793592705026','1332006790639915009','1326330537878491137','1','2020-11-27 10:11:06','admin','2020-11-27 01:02:22','yuchengxi','2020-11-27 10:11:06'),('1332006793873723393','1332006790639915009','3d464b4ea0d2491aab8a7bde74c57e95','0',NULL,'admin','2020-11-27 01:02:22',NULL,NULL),('1332006794142158849','1332006790639915009','a75d45a015c44384a04449ee80dc3503','0',NULL,'admin','2020-11-27 01:02:22',NULL,NULL),('1332135683493466114','1332135683229224962','1331909887347363842','1','2020-11-27 09:35:03','yuchengxi','2020-11-27 09:34:31','jww1','2020-11-27 09:35:03'),('1332135683686404098','1332135683229224962','1330867917981728770','1','2020-11-27 09:35:59','yuchengxi','2020-11-27 09:34:32','HectorLi','2020-11-27 09:35:59'),('1332136879054655490','1332136878987546625','1330867917981728770','0',NULL,'jww','2020-11-27 09:39:17',NULL,NULL),('1332140052892880897','1332140052741885953','1326330537878491137','1','2020-11-27 10:12:20','admin','2020-11-27 09:51:53','yuchengxi','2020-11-27 10:12:20'),('1332256795384614913','1332256795233619969','1326330537878491137','1','2020-12-07 09:09:28','yuchengxi','2020-11-27 17:35:47','yuchengxi','2020-12-07 09:09:28'),('1337603082208415746','1337603082078392321','1326330537878491137','1','2020-12-12 12:45:56','yuchengxi','2020-12-12 11:40:01','yuchengxi','2020-12-12 12:45:56'),('1337739731294752770','1337739731227643906','1326330537878491137','1','2020-12-12 20:51:30','yuchengxi','2020-12-12 20:43:01','yuchengxi','2020-12-12 20:51:30');
/*!40000 ALTER TABLE `sys_announcement_send` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_category`
--

DROP TABLE IF EXISTS `sys_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_category` (
  `id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `pid` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '父级节点',
  `name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '类型名称',
  `code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '类型编码',
  `create_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '所属部门',
  `has_child` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '是否有子节点',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `index_code` (`code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_category`
--

LOCK TABLES `sys_category` WRITE;
/*!40000 ALTER TABLE `sys_category` DISABLE KEYS */;
INSERT INTO `sys_category` VALUES ('1183693424827564034','0','物料树','B02','admin','2019-10-14 18:37:59','admin','2019-10-14 18:38:15','A01','1'),('1183693491043041282','1183693424827564034','上衣','B02A01','admin','2019-10-14 18:38:15','admin','2019-10-14 18:38:43','A01','1'),('1183693534173069314','1183693424827564034','裤子','B02A02','admin','2019-10-14 18:38:25',NULL,NULL,'A01',NULL),('1183693610534567937','1183693491043041282','秋衣','B02A01A01','admin','2019-10-14 18:38:43',NULL,NULL,'A01',NULL),('1183693700254924802','1183693491043041282','兵装','B02A01A02','admin','2019-10-14 18:39:05',NULL,NULL,'A01',NULL),('1183693773974011906','1183693491043041282','女装','B02A01A03','admin','2019-10-14 18:39:22',NULL,NULL,'A01',NULL),('1185039122143719425','0','电脑产品','A01','admin','2019-10-18 11:45:18','admin','2019-10-18 11:45:31','A01','1'),('1185039176799694850','1185039122143719425','thinkpad','A01A01','admin','2019-10-18 11:45:31',NULL,NULL,'A01',NULL),('1185039255115739138','1185039122143719425','mackbook','A01A02','admin','2019-10-18 11:45:50',NULL,NULL,'A01',NULL),('1185039299051073537','1185039122143719425','华为电脑','A01A03','admin','2019-10-18 11:46:01',NULL,NULL,'A01',NULL),('1230769196661510146','0','省',NULL,'admin','2020-02-21 16:20:16','admin','2020-02-21 16:20:31','A01A03','1'),('1230769253267836929','1230769196661510146','安徽省',NULL,'admin','2020-02-21 16:20:31','admin','2020-02-21 16:20:53','A01A03','1'),('1230769290609725441','1230769196661510146','山东省',NULL,'admin','2020-02-21 16:20:40','admin','2020-02-21 16:21:23','A01A03','1'),('1230769347157331969','1230769253267836929','合肥市',NULL,'admin','2020-02-21 16:20:53','admin','2020-02-21 16:21:08','A01A03','1'),('1230769407907631106','1230769347157331969','包河区',NULL,'admin','2020-02-21 16:21:08',NULL,NULL,'A01A03',NULL),('1230769470889299970','1230769290609725441','济南市',NULL,'admin','2020-02-21 16:21:23','admin','2020-02-21 16:21:41','A01A03','1'),('1230769547519234050','1230769470889299970','A区',NULL,'admin','2020-02-21 16:21:41',NULL,NULL,'A01A03',NULL),('1230769620021972993','1230769470889299970','B区',NULL,'admin','2020-02-21 16:21:58',NULL,NULL,'A01A03',NULL),('1230769769930592257','1230769253267836929','淮南市',NULL,'admin','2020-02-21 16:22:34','admin','2020-02-21 16:22:54','A01A03','1'),('1230769855347593217','1230769769930592257','C区',NULL,'admin','2020-02-21 16:22:54',NULL,NULL,'A01A03',NULL),('22a50b413c5e1ef661fb8aea9469cf52','e9ded10fd33e5753face506f4f1564b5','MacBook','B01-2-1','admin','2019-06-10 15:43:13',NULL,NULL,'A01',NULL),('5c8f68845e57f68ab93a2c8d82d26ae1','0','笔记本','B01','admin','2019-06-10 15:34:11','admin','2019-06-10 15:34:24','A01','1'),('937fd2e9aa13b8bab1da1ca36d3fd344','e9ded10fd33e5753face506f4f1564b5','台式机','B02-2-2','admin','2019-06-10 15:43:32','admin','2019-08-21 12:01:59','A01',NULL),('e9ded10fd33e5753face506f4f1564b5','5c8f68845e57f68ab93a2c8d82d26ae1','苹果电脑','B01-2','admin','2019-06-10 15:41:14','admin','2019-06-10 15:43:13','A01','1'),('f39a06bf9f390ba4a53d11bc4e0018d7','5c8f68845e57f68ab93a2c8d82d26ae1','华为','B01-1','admin','2019-06-10 15:34:24','admin','2019-08-21 12:01:56','A01',NULL);
/*!40000 ALTER TABLE `sys_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_check_rule`
--

DROP TABLE IF EXISTS `sys_check_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_check_rule` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键id',
  `rule_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '规则名称',
  `rule_code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '规则Code',
  `rule_json` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '规则JSON',
  `rule_description` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '规则描述',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uni_sys_check_rule_code` (`rule_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_check_rule`
--

LOCK TABLES `sys_check_rule` WRITE;
/*!40000 ALTER TABLE `sys_check_rule` DISABLE KEYS */;
INSERT INTO `sys_check_rule` VALUES ('1224980593992388610','通用编码规则','common','[{\"digits\":\"1\",\"pattern\":\"^[a-z|A-Z]$\",\"message\":\"第一位只能是字母\"},{\"digits\":\"*\",\"pattern\":\"^[0-9|a-z|A-Z|_]{0,}$\",\"message\":\"只能填写数字、大小写字母、下划线\"},{\"digits\":\"*\",\"pattern\":\"^.{3,}$\",\"message\":\"最少输入3位数\"},{\"digits\":\"*\",\"pattern\":\"^.{3,12}$\",\"message\":\"最多输入12位数\"}]','规则：1、首位只能是字母；2、只能填写数字、大小写字母、下划线；3、最少3位数，最多12位数。','admin','2020-02-07 11:25:48','admin','2020-02-05 16:58:27'),('1225001845524004866','负责的功能测试','test','[{\"digits\":\"*\",\"pattern\":\"^.{3,12}$\",\"message\":\"只能输入3-12位字符\"},{\"digits\":\"3\",\"pattern\":\"^\\\\d{3}$\",\"message\":\"前3位必须是数字\"},{\"digits\":\"*\",\"pattern\":\"^[^pP]*$\",\"message\":\"不能输入P\"},{\"digits\":\"4\",\"pattern\":\"^@{4}$\",\"message\":\"第4-7位必须都为 @\"},{\"digits\":\"2\",\"pattern\":\"^#=$\",\"message\":\"第8-9位必须是 #=\"},{\"digits\":\"1\",\"pattern\":\"^O$\",\"message\":\"第10位必须为大写的O\"},{\"digits\":\"*\",\"pattern\":\"^.*。$\",\"message\":\"必须以。结尾\"}]','包含长度校验、特殊字符校验等','admin','2020-02-07 11:57:31','admin','2020-02-05 18:22:54');
/*!40000 ALTER TABLE `sys_check_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_data_log`
--

DROP TABLE IF EXISTS `sys_data_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_data_log` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'id',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人登录名称',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '更新人登录名称',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `data_table` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '表名',
  `data_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '数据ID',
  `data_content` text CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '数据内容',
  `data_version` int DEFAULT NULL COMMENT '版本号',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `sindex` (`data_table`,`data_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_data_log`
--

LOCK TABLES `sys_data_log` WRITE;
/*!40000 ALTER TABLE `sys_data_log` DISABLE KEYS */;
INSERT INTO `sys_data_log` VALUES ('402880f05ab0d198015ab12274bf0006','admin','2017-03-09 11:35:09',NULL,NULL,'jeecg_demo','4028ef81550c1a7901550c1cd6e70001','{\"mobilePhone\":\"\",\"officePhone\":\"\",\"email\":\"\",\"createDate\":\"Jun 23, 2016 12:00:00 PM\",\"sex\":\"1\",\"depId\":\"402880e447e99cf10147e9a03b320003\",\"userName\":\"9001\",\"status\":\"1\",\"content\":\"111\",\"id\":\"4028ef81550c1a7901550c1cd6e70001\"}',3),('402880f05ab6d12b015ab700bead0009','admin','2017-03-10 14:56:03',NULL,NULL,'jeecg_demo','402880f05ab6d12b015ab700be8d0008','{\"mobilePhone\":\"\",\"officePhone\":\"\",\"email\":\"\",\"createDate\":\"Mar 10, 2017 2:56:03 PM\",\"sex\":\"0\",\"depId\":\"402880e447e99cf10147e9a03b320003\",\"userName\":\"111\",\"status\":\"0\",\"id\":\"402880f05ab6d12b015ab700be8d0008\"}',1),('402880f05ab6d12b015ab705a23f000d','admin','2017-03-10 15:01:24',NULL,NULL,'jeecg_demo','402880f05ab6d12b015ab705a233000c','{\"mobilePhone\":\"\",\"officePhone\":\"11\",\"email\":\"\",\"createDate\":\"Mar 10, 2017 3:01:24 PM\",\"sex\":\"0\",\"depId\":\"402880e447e99cf10147e9a03b320003\",\"userName\":\"11\",\"status\":\"0\",\"id\":\"402880f05ab6d12b015ab705a233000c\"}',1),('402880f05ab6d12b015ab712a6420013','admin','2017-03-10 15:15:37',NULL,NULL,'jeecg_demo','402880f05ab6d12b015ab712a6360012','{\"mobilePhone\":\"\",\"officePhone\":\"\",\"email\":\"\",\"createDate\":\"Mar 10, 2017 3:15:37 PM\",\"sex\":\"0\",\"depId\":\"402880e447e99cf10147e9a03b320003\",\"userName\":\"小王\",\"status\":\"0\",\"id\":\"402880f05ab6d12b015ab712a6360012\"}',1),('402880f05ab6d12b015ab712d0510015','admin','2017-03-10 15:15:47',NULL,NULL,'jeecg_demo','402880f05ab6d12b015ab712a6360012','{\"mobilePhone\":\"18611788525\",\"officePhone\":\"\",\"email\":\"\",\"createDate\":\"Mar 10, 2017 3:15:37 AM\",\"sex\":\"0\",\"depId\":\"402880e447e99cf10147e9a03b320003\",\"userName\":\"小王\",\"status\":\"0\",\"id\":\"402880f05ab6d12b015ab712a6360012\"}',2),('402880f05ab6d12b015ab71308240018','admin','2017-03-10 15:16:02',NULL,NULL,'jeecg_demo','8a8ab0b246dc81120146dc81860f016f','{\"mobilePhone\":\"13111111111\",\"officePhone\":\"66666666\",\"email\":\"demo@jeecg.com\",\"age\":12,\"salary\":10.00,\"birthday\":\"Feb 14, 2014 12:00:00 AM\",\"sex\":\"1\",\"depId\":\"402880e447e99cf10147e9a03b320003\",\"userName\":\"小明\",\"status\":\"\",\"content\":\"\",\"id\":\"8a8ab0b246dc81120146dc81860f016f\"}',1),('402880f05ab6d12b015ab72806c3001b','admin','2017-03-10 15:38:58',NULL,NULL,'jeecg_demo','8a8ab0b246dc81120146dc81860f016f','{\"mobilePhone\":\"18611788888\",\"officePhone\":\"66666666\",\"email\":\"demo@jeecg.com\",\"age\":12,\"salary\":10.00,\"birthday\":\"Feb 14, 2014 12:00:00 AM\",\"sex\":\"1\",\"depId\":\"402880e447e99cf10147e9a03b320003\",\"userName\":\"小明\",\"status\":\"\",\"content\":\"\",\"id\":\"8a8ab0b246dc81120146dc81860f016f\"}',2),('4028ef815318148a0153181567690001','admin','2016-02-25 18:59:29',NULL,NULL,'jeecg_demo','4028ef815318148a0153181566270000','{\"mobilePhone\":\"13423423423\",\"officePhone\":\"1\",\"email\":\"\",\"age\":1,\"salary\":1,\"birthday\":\"Feb 25, 2016 12:00:00 AM\",\"createDate\":\"Feb 25, 2016 6:59:24 PM\",\"depId\":\"402880e447e9a9570147e9b6a3be0005\",\"userName\":\"1\",\"status\":\"0\",\"id\":\"4028ef815318148a0153181566270000\"}',1),('4028ef815318148a01531815ec5c0003','admin','2016-02-25 19:00:03',NULL,NULL,'jeecg_demo','4028ef815318148a0153181566270000','{\"mobilePhone\":\"13426498659\",\"officePhone\":\"1\",\"email\":\"\",\"age\":1,\"salary\":1.00,\"birthday\":\"Feb 25, 2016 12:00:00 AM\",\"createDate\":\"Feb 25, 2016 6:59:24 AM\",\"depId\":\"402880e447e9a9570147e9b6a3be0005\",\"userName\":\"1\",\"status\":\"0\",\"id\":\"4028ef815318148a0153181566270000\"}',2),('4028ef8153c028db0153c0502e6b0003','admin','2016-03-29 10:59:53',NULL,NULL,'jeecg_demo','4028ef8153c028db0153c0502d420002','{\"mobilePhone\":\"18455477548\",\"officePhone\":\"123\",\"email\":\"\",\"createDate\":\"Mar 29, 2016 10:59:53 AM\",\"depId\":\"402880e447e99cf10147e9a03b320003\",\"userName\":\"123\",\"status\":\"0\",\"id\":\"4028ef8153c028db0153c0502d420002\"}',1),('4028ef8153c028db0153c0509aa40006','admin','2016-03-29 11:00:21',NULL,NULL,'jeecg_demo','4028ef8153c028db0153c0509a3e0005','{\"mobilePhone\":\"13565486458\",\"officePhone\":\"\",\"email\":\"\",\"createDate\":\"Mar 29, 2016 11:00:21 AM\",\"depId\":\"402880e447e99cf10147e9a03b320003\",\"userName\":\"22\",\"status\":\"0\",\"id\":\"4028ef8153c028db0153c0509a3e0005\"}',1),('4028ef8153c028db0153c051c4a70008','admin','2016-03-29 11:01:37',NULL,NULL,'jeecg_demo','4028ef8153c028db0153c0509a3e0005','{\"mobilePhone\":\"13565486458\",\"officePhone\":\"\",\"email\":\"\",\"createDate\":\"Mar 29, 2016 11:00:21 AM\",\"depId\":\"402880e447e99cf10147e9a03b320003\",\"userName\":\"22\",\"status\":\"0\",\"id\":\"4028ef8153c028db0153c0509a3e0005\"}',2),('4028ef8153c028db0153c051d4b5000a','admin','2016-03-29 11:01:41',NULL,NULL,'jeecg_demo','4028ef8153c028db0153c0502d420002','{\"mobilePhone\":\"13565486458\",\"officePhone\":\"123\",\"email\":\"\",\"createDate\":\"Mar 29, 2016 10:59:53 AM\",\"depId\":\"402880e447e99cf10147e9a03b320003\",\"userName\":\"123\",\"status\":\"0\",\"id\":\"4028ef8153c028db0153c0502d420002\"}',2),('4028ef8153c028db0153c07033d8000d','admin','2016-03-29 11:34:52',NULL,NULL,'jeecg_demo','4028ef8153c028db0153c0502d420002','{\"mobilePhone\":\"13565486458\",\"officePhone\":\"123\",\"email\":\"\",\"age\":23,\"createDate\":\"Mar 29, 2016 10:59:53 AM\",\"depId\":\"402880e447e99cf10147e9a03b320003\",\"userName\":\"123\",\"status\":\"0\",\"id\":\"4028ef8153c028db0153c0502d420002\"}',3),('4028ef8153c028db0153c070492e000f','admin','2016-03-29 11:34:57',NULL,NULL,'jeecg_demo','4028ef8153c028db0153c0509a3e0005','{\"mobilePhone\":\"13565486458\",\"officePhone\":\"\",\"email\":\"\",\"age\":22,\"createDate\":\"Mar 29, 2016 11:00:21 AM\",\"depId\":\"402880e447e99cf10147e9a03b320003\",\"userName\":\"22\",\"status\":\"0\",\"id\":\"4028ef8153c028db0153c0509a3e0005\"}',3),('4028ef81550c1a7901550c1cd7850002','admin','2016-06-01 21:17:44',NULL,NULL,'jeecg_demo','4028ef81550c1a7901550c1cd6e70001','{\"mobilePhone\":\"\",\"officePhone\":\"\",\"email\":\"\",\"createDate\":\"Jun 1, 2016 9:17:44 PM\",\"sex\":\"1\",\"depId\":\"402880e447e99cf10147e9a03b320003\",\"userName\":\"121221\",\"status\":\"0\",\"id\":\"4028ef81550c1a7901550c1cd6e70001\"}',1),('4028ef81568c31ec01568c3307080004','admin','2016-08-15 11:16:09',NULL,NULL,'jeecg_demo','4028ef81550c1a7901550c1cd6e70001','{\"mobilePhone\":\"\",\"officePhone\":\"\",\"email\":\"\",\"createDate\":\"Jun 23, 2016 12:00:00 PM\",\"sex\":\"1\",\"depId\":\"402880e447e99cf10147e9a03b320003\",\"userName\":\"9001\",\"status\":\"1\",\"content\":\"111\",\"id\":\"4028ef81550c1a7901550c1cd6e70001\"}',2);
/*!40000 ALTER TABLE `sys_data_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_data_source`
--

DROP TABLE IF EXISTS `sys_data_source`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_data_source` (
  `id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '数据源编码',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '数据源名称',
  `remark` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '备注',
  `db_type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '数据库类型',
  `db_driver` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '驱动类',
  `db_url` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '数据源地址',
  `db_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '数据库名称',
  `db_username` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '用户名',
  `db_password` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '密码',
  `create_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '所属部门',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `sys_data_source_code_uni` (`code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_data_source`
--

LOCK TABLES `sys_data_source` WRITE;
/*!40000 ALTER TABLE `sys_data_source` DISABLE KEYS */;
INSERT INTO `sys_data_source` VALUES ('1209779538310004737','local_mysql','MySQL5.7','本地数据库MySQL5.7','1','com.mysql.jdbc.Driver','jdbc:mysql://127.0.0.1:3306/jeecg-boot?characterEncoding=UTF-8&useUnicode=true&useSSL=false','jeecg-boot','root','root','admin','2019-12-25 18:14:53','admin','2020-07-10 16:54:42','A01');
/*!40000 ALTER TABLE `sys_data_source` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_depart`
--

DROP TABLE IF EXISTS `sys_depart`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_depart` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ID',
  `parent_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '父机构ID',
  `depart_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '机构/部门名称',
  `depart_name_en` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '英文名',
  `depart_name_abbr` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '缩写',
  `depart_order` int DEFAULT '0' COMMENT '排序',
  `description` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '描述',
  `org_category` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '1' COMMENT '机构类别 1组织机构，2岗位',
  `org_type` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '机构类型 1一级部门 2子部门',
  `org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '机构编码',
  `mobile` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '手机号',
  `fax` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '传真',
  `address` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '地址',
  `memo` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '备注',
  `status` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '状态（1启用，0不启用）',
  `del_flag` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '删除状态（0，正常，1已删除）',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uniq_depart_org_code` (`org_code`) USING BTREE,
  KEY `index_depart_parent_id` (`parent_id`) USING BTREE,
  KEY `index_depart_depart_order` (`depart_order`) USING BTREE,
  KEY `index_depart_org_code` (`org_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='组织机构表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_depart`
--

LOCK TABLES `sys_depart` WRITE;
/*!40000 ALTER TABLE `sys_depart` DISABLE KEYS */;
INSERT INTO `sys_depart` VALUES ('4f1765520d6346f9bd9c79e2479e5b12','c6d7cb4deeac411cb3384b1b31278596','市场部',NULL,NULL,0,NULL,'1','2','A01A03',NULL,NULL,NULL,NULL,NULL,'0','admin','2019-02-20 17:15:34','admin','2019-02-26 16:36:18'),('5159cde220114246b045e574adceafe9','6d35e179cd814e3299bd588ea7daed3f','研发部',NULL,NULL,0,NULL,'1','2','A02A02',NULL,NULL,NULL,NULL,NULL,'0','admin','2019-02-26 16:44:38','admin','2019-03-07 09:36:53'),('57197590443c44f083d42ae24ef26a2c','c6d7cb4deeac411cb3384b1b31278596','研发部',NULL,NULL,0,NULL,'1','2','A01A05',NULL,NULL,NULL,NULL,NULL,'0','admin','2019-02-21 16:14:41','admin','2019-03-27 19:05:49'),('63775228b7b041a99825f79760590b7d','57197590443c44f083d42ae24ef26a2c','研发经理',NULL,NULL,0,NULL,'3','3','A01A05A01',NULL,NULL,NULL,NULL,NULL,'0','admin','2020-05-02 15:29:09',NULL,NULL),('67fc001af12a4f9b8458005d3f19934a','c6d7cb4deeac411cb3384b1b31278596','财务部',NULL,NULL,0,NULL,'1','2','A01A04',NULL,NULL,NULL,NULL,NULL,'0','admin','2019-02-21 16:14:35','admin','2019-02-25 12:49:41'),('6d35e179cd814e3299bd588ea7daed3f','','北京卓尔互动',NULL,NULL,0,NULL,'1','1','A02',NULL,NULL,NULL,NULL,NULL,'0','admin','2019-02-26 16:36:39','admin','2020-05-02 18:21:22'),('743ba9dbdc114af8953a11022ef3096a','f28c6f53abd841ac87ead43afc483433','财务部',NULL,NULL,0,NULL,'1','2','A03A01',NULL,NULL,NULL,NULL,NULL,'0','admin','2019-03-22 16:45:43',NULL,NULL),('a7d7e77e06c84325a40932163adcdaa6','6d35e179cd814e3299bd588ea7daed3f','财务部',NULL,NULL,0,NULL,'1','2','A02A01',NULL,NULL,NULL,NULL,NULL,'0','admin','2019-02-26 16:36:47','admin','2019-02-26 16:37:25'),('c6d7cb4deeac411cb3384b1b31278596','','北京国炬软件',NULL,NULL,0,NULL,'1','1','A01',NULL,NULL,NULL,NULL,NULL,'0','admin','2019-02-11 14:21:51','admin','2020-05-02 18:21:27');
/*!40000 ALTER TABLE `sys_depart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_depart_permission`
--

DROP TABLE IF EXISTS `sys_depart_permission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_depart_permission` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `depart_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '部门id',
  `permission_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '权限id',
  `data_rule_ids` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '数据规则id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='部门权限表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_depart_permission`
--

LOCK TABLES `sys_depart_permission` WRITE;
/*!40000 ALTER TABLE `sys_depart_permission` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_depart_permission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_depart_role`
--

DROP TABLE IF EXISTS `sys_depart_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_depart_role` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `depart_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '部门id',
  `role_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '部门角色名称',
  `role_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '部门角色编码',
  `description` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '描述',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='部门角色表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_depart_role`
--

LOCK TABLES `sys_depart_role` WRITE;
/*!40000 ALTER TABLE `sys_depart_role` DISABLE KEYS */;
INSERT INTO `sys_depart_role` VALUES ('1260925293226479618','6d35e179cd814e3299bd588ea7daed3f','roless','ssss',NULL,'admin','2020-05-14 21:29:51',NULL,NULL);
/*!40000 ALTER TABLE `sys_depart_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_depart_role_permission`
--

DROP TABLE IF EXISTS `sys_depart_role_permission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_depart_role_permission` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `depart_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '部门id',
  `role_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '角色id',
  `permission_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '权限id',
  `data_rule_ids` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '数据权限ids',
  `operate_date` datetime DEFAULT NULL COMMENT '操作时间',
  `operate_ip` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '操作ip',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `index_group_role_per_id` (`role_id`,`permission_id`) USING BTREE,
  KEY `index_group_role_id` (`role_id`) USING BTREE,
  KEY `index_group_per_id` (`permission_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='部门角色权限表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_depart_role_permission`
--

LOCK TABLES `sys_depart_role_permission` WRITE;
/*!40000 ALTER TABLE `sys_depart_role_permission` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_depart_role_permission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_depart_role_user`
--

DROP TABLE IF EXISTS `sys_depart_role_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_depart_role_user` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键id',
  `user_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '用户id',
  `drole_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '角色id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='部门角色用户表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_depart_role_user`
--

LOCK TABLES `sys_depart_role_user` WRITE;
/*!40000 ALTER TABLE `sys_depart_role_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_depart_role_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_dict`
--

DROP TABLE IF EXISTS `sys_dict`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_dict` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `dict_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '字典名称',
  `dict_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '字典编码',
  `description` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '描述',
  `del_flag` int DEFAULT NULL COMMENT '删除状态',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `type` int(1) unsigned zerofill DEFAULT '0' COMMENT '字典类型0为string,1为number',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `indextable_dict_code` (`dict_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_dict`
--

LOCK TABLES `sys_dict` WRITE;
/*!40000 ALTER TABLE `sys_dict` DISABLE KEYS */;
INSERT INTO `sys_dict` VALUES ('0b5d19e1fce4b2e6647e6b4a17760c14','通告类型','msg_category','消息类型1:通知公告2:系统消息',0,'admin','2019-04-22 18:01:35',NULL,NULL,0),('1174509082208395266','职务职级','position_rank','职务表职级字典',0,'admin','2019-09-19 10:22:41',NULL,NULL,0),('1174511106530525185','机构类型','org_category','机构类型 1公司，2部门 3岗位',0,'admin','2019-09-19 10:30:43',NULL,NULL,0),('1178295274528845826','表单权限策略','form_perms_type','',0,'admin','2019-09-29 21:07:39','admin','2019-09-29 21:08:26',NULL),('1199517671259906049','紧急程度','urgent_level','日程计划紧急程度',0,'admin','2019-11-27 10:37:53',NULL,NULL,0),('1199518099888414722','日程计划类型','eoa_plan_type','',0,'admin','2019-11-27 10:39:36',NULL,NULL,0),('1199520177767587841','分类栏目类型','eoa_cms_menu_type','',0,'admin','2019-11-27 10:47:51','admin','2019-11-27 10:49:35',0),('1199525215290306561','日程计划状态','eoa_plan_status','',0,'admin','2019-11-27 11:07:52','admin','2019-11-27 11:10:11',0),('1209733563293962241','数据库类型','database_type','',0,'admin','2019-12-25 15:12:12',NULL,NULL,0),('1232913193820581889','Online表单业务分类','ol_form_biz_type','',0,'admin','2020-02-27 14:19:46','admin','2020-02-27 14:20:23',0),('1250687930947620866','定时任务状态','quartz_status','',0,'admin','2020-04-16 15:30:14','',NULL,NULL),('1280401766745718786','租户状态','tenant_status','租户状态',0,'admin','2020-07-07 15:22:25',NULL,NULL,0),('1340946117507944450','送货状态','delivery_status','',0,'admin','2020-12-21 17:04:03','admin','2020-12-22 16:56:16',0),('236e8a4baff0db8c62c00dd95632834f','同步工作流引擎','activiti_sync','同步工作流引擎',0,'admin','2019-05-15 15:27:33',NULL,NULL,0),('2e02df51611a4b9632828ab7e5338f00','权限策略','perms_type','权限策略',0,'admin','2019-04-26 18:26:55',NULL,NULL,0),('2f0320997ade5dd147c90130f7218c3e','推送类别','msg_type','',0,'admin','2019-03-17 21:21:32','admin','2019-03-26 19:57:45',0),('3486f32803bb953e7155dab3513dc68b','删除状态','del_flag',NULL,0,'admin','2019-01-18 21:46:26','admin','2019-03-30 11:17:11',0),('3d9a351be3436fbefb1307d4cfb49bf2','性别','sex',NULL,0,NULL,'2019-01-04 14:56:32','admin','2019-03-30 11:28:27',1),('4274efc2292239b6f000b153f50823ff','全局权限策略','global_perms_type','全局权限策略',0,'admin','2019-05-10 17:54:05',NULL,NULL,0),('4c03fca6bf1f0299c381213961566349','Online图表展示模板','online_graph_display_template','Online图表展示模板',0,'admin','2019-04-12 17:28:50',NULL,NULL,0),('4c753b5293304e7a445fd2741b46529d','字典状态','dict_item_status',NULL,0,'admin','2020-06-18 23:18:42','admin','2019-03-30 19:33:52',1),('4d7fec1a7799a436d26d02325eff295e','优先级','priority','优先级',0,'admin','2019-03-16 17:03:34','admin','2019-04-16 17:39:23',0),('4e4602b3e3686f0911384e188dc7efb4','条件规则','rule_conditions','',0,'admin','2019-04-01 10:15:03','admin','2019-04-01 10:30:47',0),('4f69be5f507accea8d5df5f11346181a','发送消息类型','msgType',NULL,0,'admin','2019-04-11 14:27:09',NULL,NULL,0),('68168534ff5065a152bfab275c2136f8','有效无效状态','valid_status','有效无效状态',0,'admin','2020-09-26 19:21:14','admin','2019-04-26 19:21:23',0),('6b78e3f59faec1a4750acff08030a79b','用户类型','user_type',NULL,0,NULL,'2019-01-04 14:59:01','admin','2019-03-18 23:28:18',0),('72cce0989df68887546746d8f09811aa','Online表单类型','cgform_table_type','',0,'admin','2019-01-27 10:13:02','admin','2019-03-30 11:37:36',0),('78bda155fe380b1b3f175f1e88c284c6','流程状态','bpm_status','流程状态',0,'admin','2019-05-09 16:31:52',NULL,NULL,0),('83bfb33147013cc81640d5fd9eda030c','日志类型','log_type',NULL,0,'admin','2019-03-18 23:22:19',NULL,NULL,1),('845da5006c97754728bf48b6a10f79cc','状态','status',NULL,0,'admin','2019-03-18 21:45:25','admin','2019-03-18 21:58:25',0),('880a895c98afeca9d9ac39f29e67c13e','操作类型','operate_type','操作类型',0,'admin','2019-07-22 10:54:29',NULL,NULL,0),('8dfe32e2d29ea9430a988b3b558bf233','发布状态','send_status','发布状态',0,'admin','2019-04-16 17:40:42',NULL,NULL,0),('a7adbcd86c37f7dbc9b66945c82ef9e6','1是0否','yn','',0,'admin','2019-05-22 19:29:29',NULL,NULL,0),('a9d9942bd0eccb6e89de92d130ec4c4a','消息发送状态','msgSendStatus',NULL,0,'admin','2019-04-12 18:18:17',NULL,NULL,0),('ac2f7c0c5c5775fcea7e2387bcb22f01','菜单类型','menu_type',NULL,0,'admin','2020-12-18 23:24:32','admin','2019-04-01 15:27:06',1),('ad7c65ba97c20a6805d5dcdf13cdaf36','onlineT类型','ceshi_online',NULL,0,'admin','2019-03-22 16:31:49','admin','2019-03-22 16:34:16',0),('bd1b8bc28e65d6feefefb6f3c79f42fd','Online图表数据类型','online_graph_data_type','Online图表数据类型',0,'admin','2019-04-12 17:24:24','admin','2019-04-12 17:24:57',0),('c36169beb12de8a71c8683ee7c28a503','部门状态','depart_status',NULL,0,'admin','2019-03-18 21:59:51',NULL,NULL,0),('c5a14c75172783d72cbee6ee7f5df5d1','Online图表类型','online_graph_type','Online图表类型',0,'admin','2019-04-12 17:04:06',NULL,NULL,0),('d6e1152968b02d69ff358c75b48a6ee1','流程类型','bpm_process_type',NULL,0,'admin','2021-02-22 19:26:54','admin','2019-03-30 18:14:44',0),('fc6cd58fde2e8481db10d3a1e68ce70c','用户状态','user_status',NULL,0,'admin','2019-03-18 21:57:25','admin','2019-03-18 23:11:58',1);
/*!40000 ALTER TABLE `sys_dict` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_dict_item`
--

DROP TABLE IF EXISTS `sys_dict_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_dict_item` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `dict_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '字典id',
  `item_text` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '字典项文本',
  `item_value` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '字典项值',
  `description` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '描述',
  `sort_order` int DEFAULT NULL COMMENT '排序',
  `status` int DEFAULT NULL COMMENT '状态（1启用 0不启用）',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `index_table_dict_id` (`dict_id`) USING BTREE,
  KEY `index_table_sort_order` (`sort_order`) USING BTREE,
  KEY `index_table_dict_status` (`status`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_dict_item`
--

LOCK TABLES `sys_dict_item` WRITE;
/*!40000 ALTER TABLE `sys_dict_item` DISABLE KEYS */;
INSERT INTO `sys_dict_item` VALUES ('0072d115e07c875d76c9b022e2179128','4d7fec1a7799a436d26d02325eff295e','低','L','低',3,1,'admin','2019-04-16 17:04:59',NULL,NULL),('05a2e732ce7b00aa52141ecc3e330b4e','3486f32803bb953e7155dab3513dc68b','已删除','1',NULL,NULL,1,'admin','2025-10-18 21:46:56','admin','2019-03-28 22:23:20'),('096c2e758d823def3855f6376bc736fb','bd1b8bc28e65d6feefefb6f3c79f42fd','SQL','sql',NULL,1,1,'admin','2019-04-12 17:26:26',NULL,NULL),('0c9532916f5cd722017b46bc4d953e41','2f0320997ade5dd147c90130f7218c3e','指定用户','USER',NULL,NULL,1,'admin','2019-03-17 21:22:19','admin','2019-03-17 21:22:28'),('0ca4beba9efc4f9dd54af0911a946d5c','72cce0989df68887546746d8f09811aa','附表','3',NULL,3,1,'admin','2019-03-27 10:13:43',NULL,NULL),('1030a2652608f5eac3b49d70458b8532','2e02df51611a4b9632828ab7e5338f00','禁用','2','禁用',2,1,'admin','2021-03-26 18:27:28','admin','2019-04-26 18:39:11'),('1174509082208395266','1174511106530525185','岗位','3','岗位',1,1,'admin','2019-09-19 10:31:16','',NULL),('1174509601047994369','1174509082208395266','员级','1','',1,1,'admin','2019-09-19 10:24:45','admin','2019-09-23 11:46:39'),('1174509667297026049','1174509082208395266','助级','2','',2,1,'admin','2019-09-19 10:25:01','admin','2019-09-23 11:46:47'),('1174509713568587777','1174509082208395266','中级','3','',3,1,'admin','2019-09-19 10:25:12','admin','2019-09-23 11:46:56'),('1174509788361416705','1174509082208395266','副高级','4','',4,1,'admin','2019-09-19 10:25:30','admin','2019-09-23 11:47:06'),('1174509835803189250','1174509082208395266','正高级','5','',5,1,'admin','2019-09-19 10:25:41','admin','2019-09-23 11:47:12'),('1174511197735665665','1174511106530525185','公司','1','公司',1,1,'admin','2019-09-19 10:31:05',NULL,NULL),('1174511244036587521','1174511106530525185','部门','2','部门',1,1,'admin','2019-09-19 10:31:16',NULL,NULL),('1178295553450061826','1178295274528845826','可编辑(未授权禁用)','2','',2,1,'admin','2019-09-29 21:08:46','admin','2019-09-29 21:09:18'),('1178295639554928641','1178295274528845826','可见(未授权不可见)','1','',1,1,'admin','2019-09-29 21:09:06','admin','2019-09-29 21:09:24'),('1199517884758368257','1199517671259906049','一般','1','',1,1,'admin','2019-11-27 10:38:44',NULL,NULL),('1199517914017832962','1199517671259906049','重要','2','',1,1,'admin','2019-11-27 10:38:51',NULL,NULL),('1199517941339529217','1199517671259906049','紧急','3','',1,1,'admin','2019-11-27 10:38:58',NULL,NULL),('1199518186144276482','1199518099888414722','日常记录','1','',1,1,'admin','2019-11-27 10:39:56',NULL,NULL),('1199518214858481666','1199518099888414722','本周工作','2','',1,1,'admin','2019-11-27 10:40:03',NULL,NULL),('1199518235943247874','1199518099888414722','下周计划','3','',1,1,'admin','2019-11-27 10:40:08',NULL,NULL),('1199520817285701634','1199520177767587841','列表','1','',1,1,'admin','2019-11-27 10:50:24',NULL,NULL),('1199520835035996161','1199520177767587841','链接','2','',1,1,'admin','2019-11-27 10:50:28',NULL,NULL),('1199525468672405505','1199525215290306561','未开始','0','',1,1,'admin','2019-11-27 11:08:52',NULL,NULL),('1199525490575060993','1199525215290306561','进行中','1','',1,1,'admin','2019-11-27 11:08:58',NULL,NULL),('1199525506429530114','1199525215290306561','已完成','2','',1,1,'admin','2019-11-27 11:09:02','admin','2019-11-27 11:10:02'),('1199607547704647681','4f69be5f507accea8d5df5f11346181a','系统','4','',1,1,'admin','2019-11-27 16:35:02','admin','2019-11-27 19:37:46'),('1209733775114702850','1209733563293962241','MySQL','1','',1,1,'admin','2019-12-25 15:13:02',NULL,NULL),('1209733839933476865','1209733563293962241','Oracle','2','',1,1,'admin','2019-12-25 15:13:18',NULL,NULL),('1209733903020003330','1209733563293962241','SQLServer','3','',1,1,'admin','2019-12-25 15:13:33',NULL,NULL),('1232913424813486081','1232913193820581889','官方示例','demo','',1,1,'admin','2020-02-27 14:20:42','admin','2020-02-27 14:21:37'),('1232913493717512194','1232913193820581889','流程表单','bpm','',2,1,'admin','2020-02-27 14:20:58','admin','2020-02-27 14:22:20'),('1232913605382467585','1232913193820581889','测试表单','temp','',4,1,'admin','2020-02-27 14:21:25','admin','2020-02-27 14:22:16'),('1232914232372195330','1232913193820581889','导入表单','bdfl_include','',5,1,'admin','2020-02-27 14:23:54',NULL,NULL),('1234371726545010689','4e4602b3e3686f0911384e188dc7efb4','左模糊','LEFT_LIKE','左模糊',7,1,'admin','2020-03-02 14:55:27',NULL,NULL),('1234371809495760898','4e4602b3e3686f0911384e188dc7efb4','右模糊','RIGHT_LIKE','右模糊',7,1,'admin','2020-03-02 14:55:47',NULL,NULL),('1250688147579228161','1250687930947620866','正常','0','',1,1,'admin','2020-04-16 15:31:05','',NULL),('1250688201064992770','1250687930947620866','停止','-1','',1,1,'admin','2020-04-16 15:31:18','',NULL),('1280401815068295170','1280401766745718786','正常','1','',1,1,'admin','2020-07-07 15:22:36',NULL,NULL),('1280401847607705602','1280401766745718786','冻结','0','',1,1,'admin','2020-07-07 15:22:44',NULL,NULL),('1340947297340493825','1340946117507944450','待配送','1','',1,1,'admin','2020-12-21 17:08:44','admin','2020-12-21 17:11:06'),('1340947354580160514','1340946117507944450','已配送','2','',1,1,'admin','2020-12-21 17:08:58','admin','2020-12-21 17:11:20'),('147c48ff4b51545032a9119d13f3222a','d6e1152968b02d69ff358c75b48a6ee1','测试流程','test',NULL,1,1,'admin','2019-03-22 19:27:05',NULL,NULL),('1543fe7e5e26fb97cdafe4981bedc0c8','4c03fca6bf1f0299c381213961566349','单排布局','single',NULL,2,1,'admin','2022-07-12 17:43:39','admin','2019-04-12 17:43:57'),('1ce390c52453891f93514c1bd2795d44','ad7c65ba97c20a6805d5dcdf13cdaf36','000','00',NULL,1,1,'admin','2019-03-22 16:34:34',NULL,NULL),('1db531bcff19649fa82a644c8a939dc4','4c03fca6bf1f0299c381213961566349','组合布局','combination','',4,1,'admin','2019-05-11 16:07:08',NULL,NULL),('222705e11ef0264d4214affff1fb4ff9','4f69be5f507accea8d5df5f11346181a','短信','1','',1,1,'admin','2023-02-28 10:50:36','admin','2019-04-28 10:58:11'),('23a5bb76004ed0e39414e928c4cde155','4e4602b3e3686f0911384e188dc7efb4','不等于','!=','不等于',3,1,'admin','2019-04-01 16:46:15','admin','2019-04-01 17:48:40'),('25847e9cb661a7c711f9998452dc09e6','4e4602b3e3686f0911384e188dc7efb4','小于等于','<=','小于等于',6,1,'admin','2019-04-01 16:44:34','admin','2019-04-01 17:49:10'),('2d51376643f220afdeb6d216a8ac2c01','68168534ff5065a152bfab275c2136f8','有效','1','有效',2,1,'admin','2019-04-26 19:22:01',NULL,NULL),('308c8aadf0c37ecdde188b97ca9833f5','8dfe32e2d29ea9430a988b3b558bf233','已发布','1','已发布',2,1,'admin','2019-04-16 17:41:24',NULL,NULL),('333e6b2196e01ef9a5f76d74e86a6e33','8dfe32e2d29ea9430a988b3b558bf233','未发布','0','未发布',1,1,'admin','2019-04-16 17:41:12',NULL,NULL),('337ea1e401bda7233f6258c284ce4f50','bd1b8bc28e65d6feefefb6f3c79f42fd','JSON','json',NULL,1,1,'admin','2019-04-12 17:26:33',NULL,NULL),('33bc9d9f753cf7dc40e70461e50fdc54','a9d9942bd0eccb6e89de92d130ec4c4a','发送失败','2',NULL,3,1,'admin','2019-04-12 18:20:02',NULL,NULL),('3fbc03d6c994ae06d083751248037c0e','78bda155fe380b1b3f175f1e88c284c6','已完成','3','已完成',3,1,'admin','2019-05-09 16:33:25',NULL,NULL),('41d7aaa40c9b61756ffb1f28da5ead8e','0b5d19e1fce4b2e6647e6b4a17760c14','通知公告','1',NULL,1,1,'admin','2019-04-22 18:01:57',NULL,NULL),('41fa1e9571505d643aea87aeb83d4d76','4e4602b3e3686f0911384e188dc7efb4','等于','=','等于',4,1,'admin','2019-04-01 16:45:24','admin','2019-04-01 17:49:00'),('43d2295b8610adce9510ff196a49c6e9','845da5006c97754728bf48b6a10f79cc','正常','1',NULL,NULL,1,'admin','2019-03-18 21:45:51',NULL,NULL),('4f05fb5376f4c61502c5105f52e4dd2b','83bfb33147013cc81640d5fd9eda030c','操作日志','2',NULL,NULL,1,'admin','2019-03-18 23:22:49',NULL,NULL),('50223341bfb5ba30bf6319789d8d17fe','d6e1152968b02d69ff358c75b48a6ee1','业务办理','business',NULL,3,1,'admin','2023-04-22 19:28:05','admin','2019-03-22 23:24:39'),('51222413e5906cdaf160bb5c86fb827c','a7adbcd86c37f7dbc9b66945c82ef9e6','是','1','',1,1,'admin','2019-05-22 19:29:45',NULL,NULL),('538fca35afe004972c5f3947c039e766','2e02df51611a4b9632828ab7e5338f00','显示','1','显示',1,1,'admin','2025-03-26 18:27:13','admin','2019-04-26 18:39:07'),('5584c21993bde231bbde2b966f2633ac','4e4602b3e3686f0911384e188dc7efb4','自定义SQL表达式','USE_SQL_RULES','自定义SQL表达式',9,1,'admin','2019-04-01 10:45:24','admin','2019-04-01 17:49:27'),('58b73b344305c99b9d8db0fc056bbc0a','72cce0989df68887546746d8f09811aa','主表','2',NULL,2,1,'admin','2019-03-27 10:13:36',NULL,NULL),('5b65a88f076b32e8e69d19bbaadb52d5','2f0320997ade5dd147c90130f7218c3e','全体用户','ALL',NULL,NULL,1,'admin','2020-10-17 21:22:43','admin','2019-03-28 22:17:09'),('5d833f69296f691843ccdd0c91212b6b','880a895c98afeca9d9ac39f29e67c13e','修改','3','',3,1,'admin','2019-07-22 10:55:07','admin','2019-07-22 10:55:41'),('5d84a8634c8fdfe96275385075b105c9','3d9a351be3436fbefb1307d4cfb49bf2','女','2',NULL,2,1,NULL,'2019-01-04 14:56:56',NULL,'2019-01-04 17:38:12'),('66c952ae2c3701a993e7db58f3baf55e','4e4602b3e3686f0911384e188dc7efb4','大于','>','大于',1,1,'admin','2019-04-01 10:45:46','admin','2019-04-01 17:48:29'),('6937c5dde8f92e9a00d4e2ded9198694','ad7c65ba97c20a6805d5dcdf13cdaf36','easyui','3',NULL,1,1,'admin','2019-03-22 16:32:15',NULL,NULL),('69cacf64e244100289ddd4aa9fa3b915','a9d9942bd0eccb6e89de92d130ec4c4a','未发送','0',NULL,1,1,'admin','2019-04-12 18:19:23',NULL,NULL),('6a7a9e1403a7943aba69e54ebeff9762','4f69be5f507accea8d5df5f11346181a','邮件','2','',2,1,'admin','2031-02-28 10:50:44','admin','2019-04-28 10:59:03'),('6c682d78ddf1715baf79a1d52d2aa8c2','72cce0989df68887546746d8f09811aa','单表','1',NULL,1,1,'admin','2019-03-27 10:13:29',NULL,NULL),('6d404fd2d82311fbc87722cd302a28bc','4e4602b3e3686f0911384e188dc7efb4','模糊','LIKE','模糊',7,1,'admin','2019-04-01 16:46:02','admin','2019-04-01 17:49:20'),('6d4e26e78e1a09699182e08516c49fc4','4d7fec1a7799a436d26d02325eff295e','高','H','高',1,1,'admin','2019-04-16 17:04:24',NULL,NULL),('700e9f030654f3f90e9ba76ab0713551','6b78e3f59faec1a4750acff08030a79b','333','333',NULL,NULL,1,'admin','2019-02-21 19:59:47',NULL,NULL),('7050c1522702bac3be40e3b7d2e1dfd8','c5a14c75172783d72cbee6ee7f5df5d1','柱状图','bar',NULL,1,1,'admin','2019-04-12 17:05:17',NULL,NULL),('71b924faa93805c5c1579f12e001c809','d6e1152968b02d69ff358c75b48a6ee1','OA办公','oa',NULL,2,1,'admin','2021-03-22 19:27:17','admin','2019-03-22 23:24:36'),('75b260d7db45a39fc7f21badeabdb0ed','c36169beb12de8a71c8683ee7c28a503','不启用','0',NULL,NULL,1,'admin','2019-03-18 23:29:41','admin','2019-03-18 23:29:54'),('7688469db4a3eba61e6e35578dc7c2e5','c36169beb12de8a71c8683ee7c28a503','启用','1',NULL,NULL,1,'admin','2019-03-18 23:29:28',NULL,NULL),('78ea6cadac457967a4b1c4eb7aaa418c','fc6cd58fde2e8481db10d3a1e68ce70c','正常','1',NULL,NULL,1,'admin','2019-03-18 23:30:28',NULL,NULL),('7ccf7b80c70ee002eceb3116854b75cb','ac2f7c0c5c5775fcea7e2387bcb22f01','按钮权限','2',NULL,NULL,1,'admin','2019-03-18 23:25:40',NULL,NULL),('81fb2bb0e838dc68b43f96cc309f8257','fc6cd58fde2e8481db10d3a1e68ce70c','冻结','2',NULL,NULL,1,'admin','2019-03-18 23:30:37',NULL,NULL),('83250269359855501ec4e9c0b7e21596','4274efc2292239b6f000b153f50823ff','可见/可访问(授权后可见/可访问)','1','',1,1,'admin','2019-05-10 17:54:51',NULL,NULL),('84778d7e928bc843ad4756db1322301f','4e4602b3e3686f0911384e188dc7efb4','大于等于','>=','大于等于',5,1,'admin','2019-04-01 10:46:02','admin','2019-04-01 17:49:05'),('848d4da35ebd93782029c57b103e5b36','c5a14c75172783d72cbee6ee7f5df5d1','饼图','pie',NULL,3,1,'admin','2019-04-12 17:05:49',NULL,NULL),('84dfc178dd61b95a72900fcdd624c471','78bda155fe380b1b3f175f1e88c284c6','处理中','2','处理中',2,1,'admin','2019-05-09 16:33:01',NULL,NULL),('86f19c7e0a73a0bae451021ac05b99dd','ac2f7c0c5c5775fcea7e2387bcb22f01','子菜单','1',NULL,NULL,1,'admin','2019-03-18 23:25:27',NULL,NULL),('8bccb963e1cd9e8d42482c54cc609ca2','4f69be5f507accea8d5df5f11346181a','微信','3',NULL,3,1,'admin','2021-05-11 14:29:12','admin','2019-04-11 14:29:31'),('8c618902365ca681ebbbe1e28f11a548','4c753b5293304e7a445fd2741b46529d','启用','1','',0,1,'admin','2020-07-18 23:19:27','admin','2019-05-17 14:51:18'),('8cdf08045056671efd10677b8456c999','4274efc2292239b6f000b153f50823ff','可编辑(未授权时禁用)','2','',2,1,'admin','2019-05-10 17:55:38',NULL,NULL),('8ff48e657a7c5090d4f2a59b37d1b878','4d7fec1a7799a436d26d02325eff295e','中','M','中',2,1,'admin','2019-04-16 17:04:40',NULL,NULL),('948923658baa330319e59b2213cda97c','880a895c98afeca9d9ac39f29e67c13e','添加','2','',2,1,'admin','2019-07-22 10:54:59','admin','2019-07-22 10:55:36'),('9a96c4a4e4c5c9b4e4d0cbf6eb3243cc','4c753b5293304e7a445fd2741b46529d','不启用','0',NULL,1,1,'admin','2019-03-18 23:19:53',NULL,NULL),('a1e7d1ca507cff4a480c8caba7c1339e','880a895c98afeca9d9ac39f29e67c13e','导出','6','',6,1,'admin','2019-07-22 12:06:50',NULL,NULL),('a2be752dd4ec980afaec1efd1fb589af','8dfe32e2d29ea9430a988b3b558bf233','已撤销','2','已撤销',3,1,'admin','2019-04-16 17:41:39',NULL,NULL),('aa0d8a8042a18715a17f0a888d360aa4','ac2f7c0c5c5775fcea7e2387bcb22f01','一级菜单','0',NULL,NULL,1,'admin','2019-03-18 23:24:52',NULL,NULL),('adcf2a1fe93bb99a84833043f475fe0b','4e4602b3e3686f0911384e188dc7efb4','包含','IN','包含',8,1,'admin','2019-04-01 16:45:47','admin','2019-04-01 17:49:24'),('b029a41a851465332ee4ee69dcf0a4c2','0b5d19e1fce4b2e6647e6b4a17760c14','系统消息','2',NULL,1,1,'admin','2019-02-22 18:02:08','admin','2019-04-22 18:02:13'),('b2a8b4bb2c8e66c2c4b1bb086337f393','3486f32803bb953e7155dab3513dc68b','正常','0',NULL,NULL,1,'admin','2022-10-18 21:46:48','admin','2019-03-28 22:22:20'),('b57f98b88363188daf38d42f25991956','6b78e3f59faec1a4750acff08030a79b','22','222',NULL,NULL,0,'admin','2019-02-21 19:59:43','admin','2019-03-11 21:23:27'),('b5f3bd5f66bb9a83fecd89228c0d93d1','68168534ff5065a152bfab275c2136f8','无效','0','无效',1,1,'admin','2019-04-26 19:21:49',NULL,NULL),('b9fbe2a3602d4a27b45c100ac5328484','78bda155fe380b1b3f175f1e88c284c6','待提交','1','待提交',1,1,'admin','2019-05-09 16:32:35',NULL,NULL),('ba27737829c6e0e582e334832703d75e','236e8a4baff0db8c62c00dd95632834f','同步','1','同步',1,1,'admin','2019-05-15 15:28:15',NULL,NULL),('bcec04526b04307e24a005d6dcd27fd6','880a895c98afeca9d9ac39f29e67c13e','导入','5','',5,1,'admin','2019-07-22 12:06:41',NULL,NULL),('c53da022b9912e0aed691bbec3c78473','880a895c98afeca9d9ac39f29e67c13e','查询','1','',1,1,'admin','2019-07-22 10:54:51',NULL,NULL),('c5700a71ad08994d18ad1dacc37a71a9','a7adbcd86c37f7dbc9b66945c82ef9e6','否','0','',1,1,'admin','2019-05-22 19:29:55',NULL,NULL),('cbfcc5b88fc3a90975df23ffc8cbe29c','c5a14c75172783d72cbee6ee7f5df5d1','曲线图','line',NULL,2,1,'admin','2019-05-12 17:05:30','admin','2019-04-12 17:06:06'),('d217592908ea3e00ff986ce97f24fb98','c5a14c75172783d72cbee6ee7f5df5d1','数据列表','table',NULL,4,1,'admin','2019-04-12 17:05:56',NULL,NULL),('df168368dcef46cade2aadd80100d8aa','3d9a351be3436fbefb1307d4cfb49bf2','男','1',NULL,1,1,NULL,'2027-08-04 14:56:49','admin','2019-03-23 22:44:44'),('e6329e3a66a003819e2eb830b0ca2ea0','4e4602b3e3686f0911384e188dc7efb4','小于','<','小于',2,1,'admin','2019-04-01 16:44:15','admin','2019-04-01 17:48:34'),('e94eb7af89f1dbfa0d823580a7a6e66a','236e8a4baff0db8c62c00dd95632834f','不同步','0','不同步',2,1,'admin','2019-05-15 15:28:28',NULL,NULL),('f0162f4cc572c9273f3e26b2b4d8c082','ad7c65ba97c20a6805d5dcdf13cdaf36','booostrap','1',NULL,1,1,'admin','2021-08-22 16:32:04','admin','2019-03-22 16:33:57'),('f16c5706f3ae05c57a53850c64ce7c45','a9d9942bd0eccb6e89de92d130ec4c4a','发送成功','1',NULL,2,1,'admin','2019-04-12 18:19:43',NULL,NULL),('f2a7920421f3335afdf6ad2b342f6b5d','845da5006c97754728bf48b6a10f79cc','冻结','2',NULL,NULL,1,'admin','2019-03-18 21:46:02',NULL,NULL),('f37f90c496ec9841c4c326b065e00bb2','83bfb33147013cc81640d5fd9eda030c','登录日志','1',NULL,NULL,1,'admin','2019-03-18 23:22:37',NULL,NULL),('f753aff60ff3931c0ecb4812d8b5e643','4c03fca6bf1f0299c381213961566349','双排布局','double',NULL,3,1,'admin','2019-04-12 17:43:51',NULL,NULL),('f80a8f6838215753b05e1a5ba3346d22','880a895c98afeca9d9ac39f29e67c13e','删除','4','',4,1,'admin','2019-07-22 10:55:14','admin','2019-07-22 10:55:30'),('fcec03570f68a175e1964808dc3f1c91','4c03fca6bf1f0299c381213961566349','Tab风格','tab',NULL,1,1,'admin','2019-04-12 17:43:31',NULL,NULL),('fe50b23ae5e68434def76f67cef35d2d','78bda155fe380b1b3f175f1e88c284c6','已作废','4','已作废',4,1,'admin','2021-09-09 16:33:43','admin','2019-05-09 16:34:40');
/*!40000 ALTER TABLE `sys_dict_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_fill_rule`
--

DROP TABLE IF EXISTS `sys_fill_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_fill_rule` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键ID',
  `rule_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '规则名称',
  `rule_code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '规则Code',
  `rule_class` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '规则实现类',
  `rule_params` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '规则参数',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uni_sys_fill_rule_code` (`rule_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_fill_rule`
--

LOCK TABLES `sys_fill_rule` WRITE;
/*!40000 ALTER TABLE `sys_fill_rule` DISABLE KEYS */;
INSERT INTO `sys_fill_rule` VALUES ('1202551334738382850','机构编码生成','org_num_role','org.jeecg.modules.system.rule.OrgCodeRule','{\"parentId\":\"c6d7cb4deeac411cb3384b1b31278596\"}','admin','2019-12-09 10:37:06','admin','2019-12-05 19:32:35'),('1202787623203065858','分类字典编码生成','category_code_rule','org.jeecg.modules.system.rule.CategoryCodeRule','{\"pid\":\"\"}','admin','2019-12-09 10:36:54','admin','2019-12-06 11:11:31'),('1260134137920090113','商城订单流水号','shop_order_num','org.jeecg.modules.system.rule.OrderNumberRule','{}','admin','2020-07-11 11:35:00','admin','2020-05-12 17:06:05'),('1343836631182024705','收费单编码规则','receiving_note_rule','org.jeecg.modules.system.rule.ReceivingNoteRule','{}',NULL,NULL,'admin','2020-12-29 16:29:55');
/*!40000 ALTER TABLE `sys_fill_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_gateway_route`
--

DROP TABLE IF EXISTS `sys_gateway_route`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_gateway_route` (
  `id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `name` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '服务名',
  `uri` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '服务地址',
  `predicates` text CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '断言',
  `filters` text CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '过滤器',
  `retryable` int DEFAULT NULL COMMENT '是否重试:0-否 1-是',
  `strip_prefix` int DEFAULT NULL COMMENT '是否忽略前缀0-否 1-是',
  `persist` int DEFAULT NULL COMMENT '是否为保留数据:0-否 1-是',
  `show_api` int DEFAULT NULL COMMENT '是否在接口文档中展示:0-否 1-是',
  `status` int DEFAULT NULL COMMENT '状态:0-无效 1-有效',
  `create_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建日期',
  `update_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新日期',
  `sys_org_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '所属部门',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_gateway_route`
--

LOCK TABLES `sys_gateway_route` WRITE;
/*!40000 ALTER TABLE `sys_gateway_route` DISABLE KEYS */;
/*!40000 ALTER TABLE `sys_gateway_route` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sys_log`
--

DROP TABLE IF EXISTS `sys_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sys_log` (
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `log_type` int DEFAULT NULL COMMENT '日志类型（1登录日志，2操作日志）',
  `log_content` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '日志内容',
  `operate_type` int DEFAULT NULL COMMENT '操作类型',
  `userid` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '操作用户账号',
  `username` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '操作用户名称',
  `ip` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'IP',
  `method` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '请求java方法',
  `request_url` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '请求路径',
  `request_param` longtext CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '请求参数',
  `request_type` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '请求类型',
  `cost_time` bigint DEFAULT NULL COMMENT '耗时',
  `create_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '更新人',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `index_table_userid` (`userid`) USING BTREE,
  KEY `index_logt_ype` (`log_type`) USING BTREE,
  KEY `index_operate_type` (`operate_type`) USING BTREE,
  KEY `index_log_type` (`log_type`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='系统日志表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sys_log`
--

LOCK TABLES `sys_log` WRITE;
/*!40000 ALTER TABLE `sys_log` DISABLE KEYS */;
INSERT INTO `sys_log` VALUES ('b09ccd219a1ce5c7270bb659748b8330',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-19 15:34:38',NULL,NULL),('a22ddd4b5b0b84bd7794edd24b25fc64',2,'添加测试DEMO',NULL,'admin','管理员','127.0.0.1','org.jeecg.modules.demo.test.controller.JeecgDemoController.add()',NULL,'[{\"createBy\":\"admin\",\"createTime\":1547883299809,\"email\":\"zhangdaiscott@163.com\",\"id\":\"7eac655877842eb39dc2f0469f3964ec\",\"name\":\"zhang daihao\"}]',NULL,25,'admin','2019-01-19 15:34:59',NULL,NULL),('07a0b3f8b4140a7a586305c2f40a2310',2,'删除测试DEMO',NULL,'admin','管理员','127.0.0.1','org.jeecg.modules.demo.test.controller.JeecgDemoController.delete()',NULL,'[\"7eac655877842eb39dc2f0469f3964ec\"]',NULL,14,'admin','2019-01-19 15:38:11',NULL,NULL),('d7902eeab2c34611fad046a79bff1c1b',2,'添加测试DEMO',NULL,'admin','管理员','127.0.0.1','org.jeecg.modules.demo.test.controller.JeecgDemoController.add()',NULL,'[{\"createBy\":\"admin\",\"createTime\":1547883544104,\"email\":\"zhangdaiscott@163.com\",\"id\":\"4436302a0de50bb83025286bc414d6a9\",\"name\":\"zhang daihao\"}]',NULL,1682,'admin','2019-01-19 15:39:05',NULL,NULL),('a68160f37cace166fedd299c4ca0be10',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-19 15:40:00',NULL,NULL),('c6c0316b6989bf1eea0a3803f593bf69',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-19 15:47:19',NULL,NULL),('4b1341863a8fffeccda8bbe413bd815f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-19 15:59:52',NULL,NULL),('ed50b1fbc80c3b953f4551081b10335e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-19 16:19:06',NULL,NULL),('dabdcb8e15ea9215a1af22f7567ff73d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-19 16:48:13',NULL,NULL),('446724ea6dd41f4a03111c42e00d80cd',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-19 16:56:36',NULL,NULL),('0e41fe3a34d5715bf4c88e220663583a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-19 17:04:06',NULL,NULL),('9f2db1ffaf89518a25cc6701da0c5858',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-19 17:05:07',NULL,NULL),('954f1ccb8b230d2d7d4858eec3aba0a4',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-19 17:08:37',NULL,NULL),('7374f3a2ccb20216cf8eecb26037ce0a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-19 18:08:51',NULL,NULL),('130de55edac71aab730786307cc65936',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-19 20:22:57',NULL,NULL),('0bc44e2d682c9f28525d203589a90b43',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-19 20:31:08',NULL,NULL),('122edcafd54dd06e12838f41123d9d5d',2,'添加测试DEMO',NULL,'admin','管理员','127.0.0.1','org.jeecg.modules.demo.test.controller.JeecgDemoController.add()',NULL,'[{\"age\":28,\"birthday\":1546617600000,\"createBy\":\"admin\",\"createTime\":1547901234989,\"id\":\"42c08b1a2e5b2a96ffa4cc88383d4b11\",\"name\":\"秦500\",\"punchTime\":1546691611000}]',NULL,21387,'admin','2019-01-19 20:34:11',NULL,NULL),('1a570aac0c30ac2955b59e2dc7a6204c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-19 20:58:26',NULL,NULL),('c18db091677ec01d55e913662b9028a9',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-19 21:19:07',NULL,NULL),('88d8b4b50bdab58c52fe25fa711fbbef',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-19 21:21:39',NULL,NULL),('6b876be6e384337b36ad28a4a5868be8',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-19 21:22:12',NULL,NULL),('cb6b52fbbdd4c5698c17edaf9960e11e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-19 21:22:23',NULL,NULL),('fea8e1e2d229557185be0d9a10ebce17',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-19 21:55:55',NULL,NULL),('c1842fc83cdf0b0cc0264bf093e9c55d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-19 21:56:15',NULL,NULL),('543970eba4d1c522e3cb597b0fd4ad13',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-19 22:53:18',NULL,NULL),('e9ce2b3f7ac1fa3f5f7fd247207ca5c0',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-19 22:53:35',NULL,NULL),('0e365a21c60e4460813bdc4e3cb320a3',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-19 23:01:34',NULL,NULL),('d3df1a4057b6d7fb4dab073a727ba21f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-19 23:14:02',NULL,NULL),('8f616500d666a5a67bc98e7ccd73c2e2',2,'添加测试DEMO',NULL,'admin','管理员','127.0.0.1','org.jeecg.modules.demo.test.controller.JeecgDemoController.add()',NULL,'[{\"createBy\":\"admin\",\"createTime\":1547912194199,\"id\":\"ffa9da1ad40632dfcabac51d766865bd\",\"name\":\"秦999\"}]',NULL,386,'admin','2019-01-19 23:36:34',NULL,NULL),('055cf35c8865761b479c7f289dc36616',2,'添加测试DEMO',NULL,'admin','管理员','127.0.0.1','org.jeecg.modules.demo.test.controller.JeecgDemoController.add()',NULL,'[{\"createBy\":\"admin\",\"createTime\":1547912238787,\"email\":\"zhangdaiscott@163.com\",\"id\":\"c2c0d49e3c01913067cf8d1fb3c971d2\",\"name\":\"zhang daihao\"}]',NULL,16,'admin','2019-01-19 23:37:18',NULL,NULL),('69e3164d007be2b9834e4fb398186f39',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-19 23:38:17',NULL,NULL),('92e514fee917a1a459c4ffdb0ca42516',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 10:20:52',NULL,NULL),('d3f08843a9b2b3284711e376fb785beb',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 10:58:03',NULL,NULL),('76bea561f662ec0ccf05bc370f1ffe35',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 11:08:55',NULL,NULL),('273081678d85acebaa6615973bff31db',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 15:02:50',NULL,NULL),('b26369680b41d581649cf865e88331e9',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 15:03:07',NULL,NULL),('7313b43ff53015d79a58b4dc7c660721',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 15:03:07',NULL,NULL),('f99912c5ff252594f14d31b768f8ad15',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 15:03:10',NULL,NULL),('dcec1957987abbe6658f1f2c96980366',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 15:05:21',NULL,NULL),('c7b6156c4f42b70c562b507766f4546c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 15:14:08',NULL,NULL),('52673feae24ea5bc3ca111f19c9a85d4',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 15:16:46',NULL,NULL),('507b55d3b5ddc487fb40ca1f716a1253',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 15:43:02',NULL,NULL),('7351132f4f5f65e5bf157dd7ad5344a4',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 15:51:36',NULL,NULL),('961992e05772bc7ad2ca927cf7649440',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 15:55:10',NULL,NULL),('3b07fda32423a5696b2097e1c23c00d4',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 16:04:32',NULL,NULL),('8447099784da63b3b2cd2fbbc5eabcea',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 16:04:49',NULL,NULL),('b20ff98a10af3c25c1991741fd59ea64',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 16:07:48',NULL,NULL),('9acebd2d37c9078f9568125fb9696976',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 16:07:59',NULL,NULL),('d70c2847d8d0936a2a761f745a84aa48',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 16:39:34',NULL,NULL),('279e519d647f1a4e1f85f9b90ab370b9',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 17:01:30',NULL,NULL),('b605a83a9b5f3cdaaa1b3f4f41a5f12d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 17:04:20',NULL,NULL),('0a24b1f04f79a2bcb83c4cd12d077cbc',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 17:34:37',NULL,NULL),('661c4792f00b0814e486c3d623d7259f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 18:06:11',NULL,NULL),('d1746c5c937fcb650bd835ff74dabdff',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 18:06:32',NULL,NULL),('8ec3a287a37d155047e80a80769d5226',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 18:37:14',NULL,NULL),('6cbd2a9257fae1cb7ff7bc2eb264b3ab',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 19:08:14',NULL,NULL),('f06e8fa83b408be905b4dc7caeaf9a80',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 19:40:33',NULL,NULL),('f84e86c9a21149134b1f2599a424164b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-21 20:12:27',NULL,NULL),('88bfc5b77b4be0d6d0f7c8661cf24853',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-22 10:25:53',NULL,NULL),('b9bf472a12fc25a9d4b500421b08b025',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-22 10:53:54',NULL,NULL),('dbbcfb7f59311637a613ec9a6c63f04a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-22 10:53:57',NULL,NULL),('69ea2322f72b41bcdc7f235889132703',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-22 10:54:43',NULL,NULL),('62d197757e2cb40f9e8cb57fa6a207f7',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-22 10:54:54',NULL,NULL),('ccad29843623a6c3ca59548b1d533b15',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-22 10:56:33',NULL,NULL),('4d9299e2daac1f49eac0cec75a90c32e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-22 11:28:39',NULL,NULL),('43848099c1e70910ba1572868ee40415',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-22 11:28:48',NULL,NULL),('6fb7db45b11bc22347b234fda07700c8',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-22 12:00:22',NULL,NULL),('e8cde8dcd6253b249d67a05aaf10f968',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-22 12:30:28',NULL,NULL),('6a4231540c73ad67128d5a24e6a877ff',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-22 12:54:30',NULL,NULL),('2b3be3da6ba9d1ee49f378d729d69c50',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-22 13:24:41',NULL,NULL),('78f519b618f82a39adad391fbf6b9c7a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-22 13:49:58',NULL,NULL),('1487d69ff97888f3a899e2ababb5ae48',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-22 14:21:17',NULL,NULL),('cc7fa5567e7833a3475b29b7441a2976',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-22 14:21:31',NULL,NULL),('52e36d72cd04bea2604747e006b038ec',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-22 19:47:17',NULL,NULL),('523a54948d5edaf421566014b66f9465',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-22 19:50:27',NULL,NULL),('48e4e10ac7e583050fd85734f0676a7c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-22 19:58:08',NULL,NULL),('dee4d42c439b51b228ab5db5d0723fc0',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-22 20:02:56',NULL,NULL),('965c74ffe09d8a06bb817efa6d62254b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-23 10:01:35',NULL,NULL),('059bac84373e9dae94363ea18802d70f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-23 10:06:56',NULL,NULL),('9ef3f1ed07003e3abec3445920b062f1',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-23 11:17:05',NULL,NULL),('0169622dcd4e89b177a0917778ac7f9c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-23 11:17:18',NULL,NULL),('f8960d64e93606fa52220cc9c4ae35a2',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-23 11:21:02',NULL,NULL),('4261867172d0fd5c04c993638661ac0b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-23 11:24:47',NULL,NULL),('32464c6f7f772ddda0a963b19ad2fd70',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-23 11:30:20',NULL,NULL),('d29cf7aae44523bf2f3d187e91356fe8',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-23 12:20:35',NULL,NULL),('0e9c0d0d26ddc652a7277912e0784d11',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-23 12:27:41',NULL,NULL),('25f8b1b345b1c8a070fe81d715540c85',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-23 15:39:46',NULL,NULL),('8327cced60486bad4009276e14403502',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-24 09:56:29',NULL,NULL),('515c28df59f07478339b61ca5b1b54a8',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-24 10:34:51',NULL,NULL),('fa0612372b332b6c3ce787d9ca6dd2cc',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-24 11:48:21',NULL,NULL),('8300e85a2c2f16c2358d31e8b364edf7',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-24 11:55:39',NULL,NULL),('3d9874f248a984608ca98c36c21c5a7a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-24 13:05:56',NULL,NULL),('cc8ab347f332c55570830c5fc39bbf9f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-24 13:08:38',NULL,NULL),('8742a458bf166fd5f134ac65fa8903f9',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-24 13:09:10',NULL,NULL),('bbe2e637bafa0d7f465dc9e1266cff3d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-25 11:16:50',NULL,NULL),('b3474fc5aad9ec2f36ccbbf7bf864a69',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-25 11:17:24',NULL,NULL),('260bb025d91b59d0135d635ef85eeb82',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-25 11:40:13',NULL,NULL),('1a5b71c9458c17f9bcb19a5747fd47dd',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-25 11:56:48',NULL,NULL),('e720278084b0d4316448ec59d4e3399d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-25 15:52:45',NULL,NULL),('f6646950c8465da1d1219b7a7a209fc2',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-25 19:14:07',NULL,NULL),('36358cacfc5eb3ba7e85cfe156218b71',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-25 19:14:17',NULL,NULL),('ee2bb63c47c868d59a45503b3d2f34ea',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-25 19:16:14',NULL,NULL),('b0d11dfec52e02f504c63e2f8224b00d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-25 19:27:44',NULL,NULL),('4acfbc327681d89dab861c77401f8992',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-28 10:54:36',NULL,NULL),('96ada57ac17c4477f4e4c8d596d4cc1a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-28 10:54:44',NULL,NULL),('e4e40e21437b23b74324e0402cceb71a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-28 11:34:40',NULL,NULL),('d92d9e003666c6b020f079eaee721f9f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-28 12:08:43',NULL,NULL),('68f7394ca53c59438b2b41e7bb9f3094',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-28 14:09:34',NULL,NULL),('a9b34565c6460dc9cede00ad150393f9',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-28 14:17:53',NULL,NULL),('fa427f74dc6bd9cca3db478b5842f7f7',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-28 14:19:07',NULL,NULL),('8b66ec251e3107765768dbd0590eeb29',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-28 14:25:48',NULL,NULL),('e42a38382fce916909d6d09f66147006',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-28 14:28:44',NULL,NULL),('ed0bbe9047a7471ae1cdc1c2941eccb1',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-29 17:52:38',NULL,NULL),('36fd54ce8bc1ee4aac9e3ea4bfdcd5a8',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-29 18:49:34',NULL,NULL),('40b3a9bee45b23548250936310b273f4',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-30 14:42:03',NULL,NULL),('c9be887c9292153e39861c91243b7432',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-30 15:12:15',NULL,NULL),('e40823376fa8c0e74a4e760de695e824',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-30 15:36:38',NULL,NULL),('993010965223b8e3a7a784409f7e377e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-30 15:50:41',NULL,NULL),('aa47c8cf2a4f2de16f415b9d9d3dbf05',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-30 16:14:36',NULL,NULL),('4a0020835a71fc6dcaefd01968d21f81',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-30 18:46:37',NULL,NULL),('fa9cebbb6af23d2830584b3aacd51e46',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-31 13:59:17',NULL,NULL),('60a975067f02cf05e74fa7b71e8e862a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-31 14:31:58',NULL,NULL),('fbb8834e9736bdd4b6d3baee895c4ca4',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-01-31 18:05:03',NULL,NULL),('623e4bc7c098f368abcc368227235caf',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-01 09:48:57',NULL,NULL),('9f31eedbe3f3c5c431b490d5fec0094c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-01 09:56:36',NULL,NULL),('b945fe8b63e0fc26d02c85466f36ebd9',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-01 09:57:34',NULL,NULL),('968d434c45aae64c9ad0e86d18238065',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-01 10:02:22',NULL,NULL),('732a1015057fde25d81ee12a7fbf66b2',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-01 10:05:08',NULL,NULL),('d9a0bb9fe6d2c675aa84f9441c0bd8bb',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-11 10:56:23',NULL,NULL),('9c64406daa2b6e7ad1f6776789d61e43',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-11 10:56:46',NULL,NULL),('1912a44dd4a6ffa1636d2dde9c2f1ab7',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-11 11:01:03',NULL,NULL),('d19b6e77ab1b6d6aa58996a93918754c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-11 11:33:06',NULL,NULL),('81f7a606359aff9f97f95c15ce8e7c69',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-11 11:33:42',NULL,NULL),('7da063020a42db99e0f3bb9500498828',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-11 13:45:36',NULL,NULL),('b6ee157afd006ceddc8c7558c251192e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-11 14:20:56',NULL,NULL),('65ace1ae98891f48ab4121d9258e4f1e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-12 10:45:20',NULL,NULL),('e2af7674bb716a7c0b703c7c7e20b906',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-12 11:38:55',NULL,NULL),('60d4f59974170c67826e64480533d793',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-12 13:25:40',NULL,NULL),('775e987a2ca37edc4f21e022b265a84a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-12 13:36:13',NULL,NULL),('dd6fbb9b6224c927c0923c16b9285525',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-12 13:37:01',NULL,NULL),('f3d371d6f71409ea2fe52405b725db4a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-12 13:38:15',NULL,NULL),('c33b4e0bbf998330e44fad65e9d0029e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-12 15:54:56',NULL,NULL),('189842bf681338dc99dfa66d366a0e6f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-12 15:55:01',NULL,NULL),('e14cd21cf5eaad9ea3689730a824a50c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-12 16:12:32',NULL,NULL),('5cf2431447eab30fd3623e831033eea0',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-12 19:17:29',NULL,NULL),('9bfe7312f2951503082a28c2cc966ce4',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-13 10:24:02',NULL,NULL),('da9a15efcf4e1e4f24647db7e2143238',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-13 11:19:54',NULL,NULL),('8317a81bce60a10afeb44af6ef6c807a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-13 11:27:58',NULL,NULL),('0a6eb1fa998b749012216542a2447ae7',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-13 11:29:30',NULL,NULL),('e5a9b045449136719d4c19c429c2dd56',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-13 13:08:05',NULL,NULL),('aaf10eab9c2b6ed6af1d7a9ce844d146',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-13 13:08:10',NULL,NULL),('b4ccdfc1280e73439eb1ad183076675b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-13 14:10:45',NULL,NULL),('018fe8d3f049a32fb8b541c893058713',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-13 15:17:42',NULL,NULL),('f3aab8f9dff7bf705aa29c6dcce49011',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-13 15:18:27',NULL,NULL),('efa591832b375b4609a5890b0c6f3250',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-13 16:00:13',NULL,NULL),('2c6822927334eb0810b71465fd9c4945',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-13 16:02:47',NULL,NULL),('7289cf420ac87ea0538bde81435b1aaa',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-13 16:03:51',NULL,NULL),('db8adca4aa7972fdc283be96d877efe0',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-13 16:04:28',NULL,NULL),('c5e541648bab341230c93377b4d4e262',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-13 16:05:09',NULL,NULL),('e261674e2640fe6d0a3cd86df631537d',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-13 16:05:51',NULL,NULL),('406e79995e3340d052d85a74a5d40d1b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-13 16:23:16',NULL,NULL),('4de1ed55165f7086f1a425a26a2f56ec',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-13 16:26:27',NULL,NULL),('d8eed69045aae6cedbff402b4e35f495',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-13 18:22:52',NULL,NULL),('bbf4fb593d6918cc767bb50c9b6c16c5',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-14 10:44:20',NULL,NULL),('506ce2d73a038b6e491a35a6c74a7343',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-14 13:44:04',NULL,NULL),('4303dbb3e502f11a3c4078f899bb3070',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-14 17:28:44',NULL,NULL),('2de252a92b59ebfbf16860cc563e3865',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-14 22:04:17',NULL,NULL),('e4c330b381e2fbfde49f1d4dd43e68b7',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-14 22:22:01',NULL,NULL),('22735c059b01949a87cb918f5ef3be76',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-14 22:41:28',NULL,NULL),('c5954beca75d6a0c014e2de3b621275a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-14 22:41:31',NULL,NULL),('db8c89112bf4706fb558664dd741aa46',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-15 09:33:23',NULL,NULL),('fa0ce422c12a565461eca56006052891',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-15 10:13:21',NULL,NULL),('a34ed4c6fef2b9f07a20e54ef4501b99',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-15 10:48:00',NULL,NULL),('b55cc05e8dd4279c0fa145833db19ba8',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-15 11:37:40',NULL,NULL),('5c675eeb69795180eee2c1069efc114b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-15 12:59:43',NULL,NULL),('5dee273feb8dd12989b40c2c92ce8c4a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-15 13:42:58',NULL,NULL),('994efef0ebca19292e14a39b385b0e21',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-15 16:22:24',NULL,NULL),('fc22aaf9660e66558689a58dfa443074',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-15 16:30:55',NULL,NULL),('2c6ede513b83fbc23aaedb89dbfa868a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-15 18:03:00',NULL,NULL),('13c1e763e9d624a69727a38b85411352',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-15 18:39:00',NULL,NULL),('fadb32d678346ee4bab02997988ff3bc',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-15 22:55:16',NULL,NULL),('0aa792eadeae39a1ed2a98ea5d2f6d27',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-16 09:11:39',NULL,NULL),('0aa9272c0581e1d7f62b1293375b4574',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-16 17:26:36',NULL,NULL),('81c9056ac38e6f881d60f3d41df1845e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-17 11:44:47',NULL,NULL),('eb4536aa50a58985baf0a763a1ce2ebf',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-17 19:48:49',NULL,NULL),('f9062582881b42f6b139c313d8ab0463',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-17 20:47:26',NULL,NULL),('22d8a2fbd53eafb21f6f62ae073c0fc1',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-17 22:28:52',NULL,NULL),('7bc7b1ff923dbb19fb0ecd800cd690bd',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-18 09:34:59',NULL,NULL),('faea0dbfb7f86b571fed0dd270623831',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-18 14:12:14',NULL,NULL),('063baad688535096d2ed906ae6f3a128',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-18 22:09:21',NULL,NULL),('528baecc596a66eaadc8887bff911f55',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-19 10:08:48',NULL,NULL),('e540ca989819c54baefffbc3d05e8b58',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-19 10:10:54',NULL,NULL),('0643f3ad4394de9fb3c491080c6a7a03',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-19 10:18:42',NULL,NULL),('eb0b8a7cdf77df133566d7bd5a5f1fc0',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-19 11:02:55',NULL,NULL),('0913bb0e92715892c470cf538726dfbc',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-19 16:17:09',NULL,NULL),('5034aec34f0b79da510e66008dbf2fcc',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-19 16:18:29',NULL,NULL),('e4afd66ac249dde9c3bd9da50f9c2469',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-19 17:41:54',NULL,NULL),('07132c1228b1c165f62ea35f4ff1cbe9',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-19 18:15:44',NULL,NULL),('4f7f587bec68ed5bf9f68b0ccd76d62b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-19 21:01:47',NULL,NULL),('12709e62742056aa4a57fa8c2c82d84a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-20 09:13:10',NULL,NULL),('680b3e6e4768d80d6ea0ce8ba71bdd0e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-20 09:14:03',NULL,NULL),('a6e323785535592ee208aa7e53554644',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-20 09:15:27',NULL,NULL),('3a4a0e27d77aa8b624180e5fd5e4004e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-20 09:51:58',NULL,NULL),('b98b7ac9e890657aa86a900763afbe2a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-20 11:49:44',NULL,NULL),('d1eb2a8ebed28d34199c5fc4a1579c4c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-20 12:55:09',NULL,NULL),('85949de2d54078e6b8f3df0a3c79c43d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-20 17:08:44',NULL,NULL),('77579d78a903635cc4942882f568e9e5',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-20 17:13:33',NULL,NULL),('679e12ba247575749e03aa8f67347ac6',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-20 17:14:42',NULL,NULL),('5c35117cbeb39428fcc2ddd90ce96a2b',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-20 17:18:51',NULL,NULL),('7225200c3cec4789af4f1da2c46b129d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-20 17:19:23',NULL,NULL),('22ad9f87788506456c774801389d6a01',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-20 17:20:10',NULL,NULL),('81c95e1c8805fa191753fc99ba54c3e9',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-20 18:01:21',NULL,NULL),('7285730e2644f49def0937dc99bfbe3d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-20 18:07:01',NULL,NULL),('4922f2f1173a1edc11dfd11cb2a100ae',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-20 18:08:27',NULL,NULL),('e37cce529d0c98c47b4977d7ddf963c0',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-20 18:17:54',NULL,NULL),('66493cd0347eeb6ee2ef5ee923604683',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-20 18:29:47',NULL,NULL),('f04910792a74c563d057c4fcb345f963',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-20 18:30:00',NULL,NULL),('210a01dcb34302eaed0d1e95820655d0',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-20 18:30:15',NULL,NULL),('48929ec94226d9ccff9fae4ff48e95e3',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-20 18:32:55',NULL,NULL),('d2ac19a709ea08f7259286df28efd635',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-20 18:35:37',NULL,NULL),('d8fd478e6ceb03a575719e1a54342333',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-20 18:43:43',NULL,NULL),('a35a476c303983701045507c9af3fa03',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-20 18:44:58',NULL,NULL),('7e41208e29d412d586fc39375628b0d0',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-21 15:34:35',NULL,NULL),('1f33d11e1833ae497e3ef65a3f02dd5b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-21 19:51:12',NULL,NULL),('dae0658783324c81fa6909b6e4a25a65',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-22 11:46:41',NULL,NULL),('a77d29673cfe97c9e03cfb879b934f62',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-22 12:41:15',NULL,NULL),('baaf37e5937f938ac92856bc74cc2b86',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-22 13:48:53',NULL,NULL),('3f47afcdce94596494746ac34eebf13b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-22 13:59:10',NULL,NULL),('b99fc7c53d4e3edc0c618edc11d3a073',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-22 15:58:43',NULL,NULL),('024a4c5ba78538d05373dac650b227d1',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-22 15:59:50',NULL,NULL),('873f425879ef9ca7ced982acda19ea58',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-22 16:35:59',NULL,NULL),('1b05434820cbcb038028da9f5cda31bb',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-22 17:45:16',NULL,NULL),('5f314fc45492d7f90b74d1ca74d1d392',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-22 17:45:48',NULL,NULL),('20751803c1e5b2d758b981ba22f61fcd',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-22 18:11:05',NULL,NULL),('50e8de3e6b45f8625b8fd5590c9fd834',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-22 18:23:18',NULL,NULL),('6737424e01b38f2273e9728bf39f3e37',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-22 19:43:37',NULL,NULL),('0473dedf4aa653b253b008dacff2937c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-24 13:04:44',NULL,NULL),('a95192071de908f37f4998af4c269bcb',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-24 14:26:53',NULL,NULL),('3569ada5c43a4022d3d13ac801aff40e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-24 14:50:55',NULL,NULL),('562092eb81561ee0f63be5dd9367d298',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-24 22:20:59',NULL,NULL),('131ccd390401b6e3894a37e4d1d195d3',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-24 22:26:52',NULL,NULL),('c12e3d7655a5a8b192bb9964a2a66946',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-24 22:35:45',NULL,NULL),('6bc98b7dc91a3924f794202867367aca',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-24 22:50:34',NULL,NULL),('002b7112a147edeb6149a891494577d0',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-24 22:52:15',NULL,NULL),('202344b08b69ad70754e6adaa777eae0',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-24 22:54:22',NULL,NULL),('eeb1f2e2c1b480e0bb62533848cbb176',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-24 22:55:46',NULL,NULL),('94fe4465d779e0438cfe6f0cb1a1aa7e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-24 22:57:42',NULL,NULL),('d03aaee882d13b796db860cb95f27724',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-24 22:59:54',NULL,NULL),('1db82f78233c120c6ec7648ca1177986',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-24 23:07:39',NULL,NULL),('7dc448f04edf4b9655362ad1a1c58753',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-24 23:10:17',NULL,NULL),('fce1553149aea9bfd93e089f387199c8',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-24 23:11:35',NULL,NULL),('e713a89e753cbecf1e10247b2112c3f8',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-24 23:14:36',NULL,NULL),('0a634ed086442afa7a5fc9aa000b898a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 10:10:39',NULL,NULL),('bfa0766f53dbd3a0fe4043f57bd9bbee',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 10:35:33',NULL,NULL),('e3b531fa12e47ac19a2ab0c883dee595',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 10:40:13',NULL,NULL),('18eafaeec588403245269a41732d1a74',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 10:45:14',NULL,NULL),('99357d793f2507cfb7b270677b4fe56c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 10:46:42',NULL,NULL),('b38f42f4e15ee72e494bdf6f6feb0ae7',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 10:49:58',NULL,NULL),('bfe758860662ae07a15598396a12cfaa',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 10:50:00',NULL,NULL),('69a7a5b960d6aedda5c4bd8b877be0a8',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 10:50:48',NULL,NULL),('4084f184160940a96e47d7be1fab4ea3',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 10:51:11',NULL,NULL),('1241cf8e9fd0e28478a07bf755f528c5',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 10:51:12',NULL,NULL),('e0da357be27d66de1c9e9b8ecb22f9f9',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 10:51:13',NULL,NULL),('9f4960f89a10d7fdcf22d1ea46143fff',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 10:51:13',NULL,NULL),('ab8a71b7565d356d12e12c6730b0ceb0',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 10:51:13',NULL,NULL),('35fdedc363d9fe514b44095da40f170b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 10:51:30',NULL,NULL),('7126b35521cd0dba932e6f04b0dac88f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 10:52:22',NULL,NULL),('9bd6e11c5a2f0bb70215cfa097a4b29c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 10:57:52',NULL,NULL),('7e2edea80050d2e46aa2e8faef8e29ce',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 11:01:38',NULL,NULL),('190eb7b4d493eb01b13c5b97916eeb13',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 11:09:05',NULL,NULL),('ea268ad02db29012b2f1bd3d4aea1419',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 11:10:22',NULL,NULL),('7dc498b45fbf25c59686d9dda0d3eb66',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 11:12:38',NULL,NULL),('583d3aa445d408f4ecd19ee0a85514af',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 11:18:04',NULL,NULL),('9cea908c7a78dc77fdaed975819983bd',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 11:20:15',NULL,NULL),('d70329497664391dabc25effe7406c50',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 11:25:12',NULL,NULL),('0b9940fc5487026a3f16cade73efead5',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 11:28:28',NULL,NULL),('f21f9f700bf4f5bd9edda7a16ed338f8',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 11:30:05',NULL,NULL),('f5c08b45885d248c422a5d406cd5f223',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 11:41:54',NULL,NULL),('e9a31bfc128b3f5ae01656916c605ddb',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 11:44:56',NULL,NULL),('6baccd034e970c6f109791cff43bc327',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 11:46:12',NULL,NULL),('d2b516c5d834bd0fca91cda416fe499e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 11:46:42',NULL,NULL),('f9abb524e0dc3571571dc6e50ec6db75',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 11:47:13',NULL,NULL),('d1111594fef195980370c5f91ccf9212',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 11:48:09',NULL,NULL),('9174fe77fe8ba69243f72d5577b391d3',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 11:48:38',NULL,NULL),('2ab9cf95ac35fdbb8fe976e13c404c41',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 11:49:05',NULL,NULL),('9be945480d69038865279f02df5cee45',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 11:49:47',NULL,NULL),('c2bfe3b92e6bfb7016cc82e95419a602',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 11:54:05',NULL,NULL),('7c310b99a84411798a2aaf4074a28e7e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 12:42:57',NULL,NULL),('b23293288a84ba965509f466ed0e7e2f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 12:43:11',NULL,NULL),('cf590576a5f6a42b347e6b5bf5ebf5bd',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 12:43:31',NULL,NULL),('b5df1807f08af5db640da11affec24d3',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 12:49:25',NULL,NULL),('2746af3dd0309cdeeff7d27999fbcda1',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 12:52:55',NULL,NULL),('2a383edf5445dc8493f5240144ca72f5',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 12:56:05',NULL,NULL),('d2910961a0ff046cc3ef6cf8d33a8094',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 15:38:47',NULL,NULL),('00f763e007e5a6bddf4cb8e562a53005',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 15:41:31',NULL,NULL),('8ab131214232450ca202103ef81f0a2d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 15:46:29',NULL,NULL),('606cb4f81f9bb412e2b2bdaa0f3e5dda',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 16:27:23',NULL,NULL),('7b85fba62bc001773fff1a54e1609aef',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 16:28:20',NULL,NULL),('b3127e34f395e1f1790450da5689a4a1',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 16:28:35',NULL,NULL),('fb2871cda1421b766f8e68cb36a22bf3',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 17:35:01',NULL,NULL),('29fb5d4297748af3cd1c7f2611b7a2d6',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 17:38:05',NULL,NULL),('580256f7c7ea658786dba919009451b6',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 17:39:43',NULL,NULL),('8802209912ca66d56f2ea241ffd0cc13',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 17:52:34',NULL,NULL),('4778fe2992fd5efd65f86cb0e00e338e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 17:53:11',NULL,NULL),('d68957c067fb27e80a23babebdb1591f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 17:55:06',NULL,NULL),('472c34745b8f86a46efa28f408465a63',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 17:56:31',NULL,NULL),('26975f09c66025d1c8d87a6894a3c262',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 18:29:08',NULL,NULL),('e4a166fcd0fc4037cb26e35cc1fb87b2',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 18:32:41',NULL,NULL),('286af82485388bfcd3bb9821ff1a4727',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 18:34:37',NULL,NULL),('eaf74cd1489b02d39c470eed131fc918',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 18:37:39',NULL,NULL),('e48a6bd82c92a8005c80c5ef36746117',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 19:32:26',NULL,NULL),('10922e0d030960e6b026c67c6179247b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-25 20:07:59',NULL,NULL),('b53c9e8ce1e129a09a3cda8c01fe644c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 11:38:49',NULL,NULL),('65be8e015c9f2c493bd0a4e405dd8221',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 11:40:20',NULL,NULL),('8ff27392165c8c707ee10ec0010c7bb8',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 11:44:07',NULL,NULL),('337b647a4085e48f61c7832e6527517d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 11:45:16',NULL,NULL),('caee69e55ec929f7ba904280cac971e6',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 11:49:15',NULL,NULL),('bdeae62057ae9858b6a546c1bdb6efc7',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 11:49:29',NULL,NULL),('ea66ed22fde49640cee5d73c6ef69718',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 11:50:04',NULL,NULL),('47c5a5b799e10255c96ccd65286541ef',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 11:50:35',NULL,NULL),('cfba34db2d7fbb15a2971212f09b59ec',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 11:51:43',NULL,NULL),('faad055dd212ed9506b444f8f1a920b9',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 12:00:38',NULL,NULL),('ef7219725c4b84cc71f56f97a8eab01a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 12:08:00',NULL,NULL),('2811e224e4e8d70f2946c815988b9b7c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 12:08:14',NULL,NULL),('7feae2fb5001ca0095c05a8b08270317',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 12:17:31',NULL,NULL),('b4c3c7af9899b9af3f42f730cfabc9b2',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 12:17:58',NULL,NULL),('28e8a7ed786eaced3182c70f68c7ea78',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 12:18:33',NULL,NULL),('3a76114e431912ff9a19a4b6eb795112',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 12:19:41',NULL,NULL),('557b3c346d9bc8f7a83fac9f5b12dc1b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 12:20:28',NULL,NULL),('e92544c6102243e7908e0cbb217f5198',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 12:48:28',NULL,NULL),('61445cc950f5d04d91339089b18edef9',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 14:13:22',NULL,NULL),('776c2e546c9ab0375d97590b048b8a9d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 14:13:51',NULL,NULL),('ef7669ac0350730d198f59b8411b19d1',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 14:28:43',NULL,NULL),('b3cceb535fa5577cc21b12502535ad29',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 14:29:01',NULL,NULL),('18a51a5f04eeaad6530665f6b0883f0c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 14:34:11',NULL,NULL),('8a13971104d70e35111d10dd99de392e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 14:34:25',NULL,NULL),('6d93d5667245ef8e5d6eafdbc9113f51',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 14:34:42',NULL,NULL),('7ba3df5d2612ac3dd724e07a55411386',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 14:35:03',NULL,NULL),('7148b3d58f121ef04bcbea5dd2e5fe3b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 14:35:23',NULL,NULL),('709b0f2bf8cb8f785f883509e54ace28',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 14:37:37',NULL,NULL),('4114145795da30b34545e9e39b7822d9',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 14:39:33',NULL,NULL),('f543c25bdd741055aeb4f77c5b5acf58',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 14:40:58',NULL,NULL),('bc594b8921a0bcdb26d4a93916316092',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 14:42:58',NULL,NULL),('11f511eeeb2e91af86b9d5e05132fc89',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 15:13:43',NULL,NULL),('810deb9fd39fa2f0a8e30e3db42f7c2b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 18:51:00',NULL,NULL),('d5b9e5d9bfbbd8e6d651087ead76d9f7',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 20:17:41',NULL,NULL),('016510fc662d9bb24d0186c5478df268',1,'用户名: admin,登录成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-02-26 20:27:18',NULL,NULL),('eb6f5196de91dd2e8316696bddd61345',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 22:26:36',NULL,NULL),('d762a1cba3dc23068f352323d98909e0',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-02-26 22:26:49',NULL,NULL),('69fc2407b46abad64fa44482c0dca59f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-01 12:04:25',NULL,NULL),('0d6cd835072c83f46d1d2a3cf13225d3',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-01 12:04:44',NULL,NULL),('e78f8832d61c1603c17767ee2b78ef07',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-01 19:50:03',NULL,NULL),('0475b4445d5f58f29212258c1644f339',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-01 20:20:23',NULL,NULL),('2b5a76869a7d1900487cd220de378dba',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-05 16:32:00',NULL,NULL),('21b8493a05050584d9bb06cfc2a05a6b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-05 17:29:52',NULL,NULL),('a61d9db83888d42b0d24621de48a880d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-05 22:49:48',NULL,NULL),('097be3e8fdf77a245f5c85884e97b88c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-05 22:52:45',NULL,NULL),('7b2b322a47e1ce131d71c50b46d7d29e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-06 15:55:20',NULL,NULL),('cedf399271592c27dcb6f6ce3312e77d',2,'删除测试DEMO',NULL,'admin','管理员','127.0.0.1','org.jeecg.modules.demo.test.controller.JeecgDemoController.delete()',NULL,'[\"7501\"]',NULL,24,'admin','2019-03-06 16:03:13',NULL,NULL),('efe77038e00cfff98d6931c3e7a4c3d6',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-06 16:20:19',NULL,NULL),('ffac84fff3c65bb17aa1bda3a0d2029e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-06 20:10:50',NULL,NULL),('45819fe1b96af820575a12e9f973014e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-07 09:19:22',NULL,NULL),('87885bc889d23c7c208614da8e021fb0',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-07 10:23:22',NULL,NULL),('54c2bad38dafd9e636ce992aa93b26af',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-07 11:57:14',NULL,NULL),('d3c4f120d8a23b62ec9e24b431a58496',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-07 14:17:24',NULL,NULL),('d01d658731dac4b580a879d986b03456',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-07 15:00:37',NULL,NULL),('ab550d09101a88bc999ea57cbb05aa5a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-07 17:59:59',NULL,NULL),('aeb738ab880c262772453d35fc98f2f2',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-07 18:50:30',NULL,NULL),('375aadb2833e57a0d5a2ce0546a65ca4',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-07 20:38:52',NULL,NULL),('96d7fe922f46123e0497e22dedf89328',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-07 23:10:48',NULL,NULL),('636d37d423199e15b4030f35c60859fe',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-08 10:07:21',NULL,NULL),('a7d1f4a774eb8644e2b1d37ca5f93641',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-08 10:16:03',NULL,NULL),('017e9596f489951f1cc7d978085adc00',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-08 10:58:00',NULL,NULL),('0b42292a532c796495a34d8d9c633afa',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-08 12:58:03',NULL,NULL),('b428718441be738cf8b5ce92109068c3',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-08 16:21:37',NULL,NULL),('89d2bc84e056f327291c53821d421034',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-08 16:57:46',NULL,NULL),('e09bb0a74c268a9aaf1f94edcc2eb65a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-08 18:26:14',NULL,NULL),('0dc22e52c9173e4e880728bc7734ff65',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-09 11:14:47',NULL,NULL),('5358b182eab53a79eec236a9cee1e0fc',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-09 13:01:21',NULL,NULL),('23176e4b29c3d2f3abadd99ebeffa347',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-09 16:37:50',NULL,NULL),('703fbcb7e198e8e64978ec0518971420',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-09 17:53:55',NULL,NULL),('9e9d01c430b72703ce3a94589be54bbe',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-09 18:26:06',NULL,NULL),('ef54197116da89bf091c0ed58321eea4',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-09 19:22:06',NULL,NULL),('111156480d4d18ebf40427083f25830f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'192.168.1.104',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-09 19:48:58',NULL,NULL),('a9bd713f975bfbff87638432a104b715',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'192.168.1.104',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-09 20:04:44',NULL,NULL),('06fbb85b34f518cd211b948552de72f8',1,'登录失败，用户名:null不存在！',NULL,NULL,NULL,'192.168.1.104',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-09 20:08:38',NULL,NULL),('9b568a868e57f24c5ba146848061613f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'192.168.1.104',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-09 20:09:15',NULL,NULL),('02026841bf8a9204db2c500c86a4a9be',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'192.168.1.104',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-09 20:44:58',NULL,NULL),('c1a68605bee6b3d1264390c1cfe7a9fa',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-09 20:49:55',NULL,NULL),('cbd720f20fc090c7350a98be0738816a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'192.168.1.104',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-09 20:55:19',NULL,NULL),('2676be4ffc66f83221fd95e23d494827',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'192.168.1.104',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-09 21:31:28',NULL,NULL),('e9d3202c14f7f2812346fb4c2b781c67',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'192.168.1.104',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-09 21:38:36',NULL,NULL),('d9e0150666b69cced93eb4defb19788b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-09 23:11:12',NULL,NULL),('1f0b36f7e021aa5d059ffb0a74ef6de4',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-09 23:11:25',NULL,NULL),('326b2df4ab05a8dbb03a0a0087e82a25',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-10 11:53:20',NULL,NULL),('7ae9cad197aee3d50e93bc3a242d68ec',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-10 13:12:26',NULL,NULL),('78caf9e97aedfb8c7feef0fc8fdb4fb5',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-10 17:04:46',NULL,NULL),('d00964eee24c6f9a8609a42eeebef957',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-10 17:04:48',NULL,NULL),('04f97d7f906c1e97384a94f3728606a4',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-11 12:08:51',NULL,NULL),('2b433e88db411bef115bc9357ba6a78b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'192.168.1.105',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-11 12:09:36',NULL,NULL),('63ccf8dda5d9bf825ecdbfb9ff9f456c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'192.168.1.105',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-11 12:14:08',NULL,NULL),('404d5fb6cce1001c3553a69089a618c8',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-11 12:29:12',NULL,NULL),('9ed114408a130e69c0de4c91b2d6bf7e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-11 13:03:40',NULL,NULL),('2eb964935df6f3a4d2f3af6ac5f2ded1',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'192.168.1.200',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-11 13:27:18',NULL,NULL),('e864c0007983211026d6987bd0cd4dc8',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'192.168.1.114',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-11 13:37:08',NULL,NULL),('8b2ad448021fbb5509ea04c9a780b165',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'192.168.1.104',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-11 14:35:25',NULL,NULL),('69a9dfb2fb02e4537b86c9c5c05184ae',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'192.168.1.104',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-11 15:22:14',NULL,NULL),('98b7fc431e4654f403e27ec9af845c7b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-11 17:31:38',NULL,NULL),('42bf42af90d4df949ad0a6cd1b39805e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'192.168.1.200',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-11 17:39:01',NULL,NULL),('e234abc35a52f0dd2512b0ce2ea0e4f2',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-11 20:05:26',NULL,NULL),('69baa4f883fe881f401ea063ddfd0079',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-12 20:51:03',NULL,NULL),('a867c282a8d97f7758235f881804bb48',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-13 18:28:20',NULL,NULL),('1aa593c64062f0137c0691eabac07521',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-14 10:45:10',NULL,NULL),('de978382f59685babf3684d1c090d136',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-14 12:55:55',NULL,NULL),('75c7fa1a7d3639be1b112e263561e43a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-14 17:07:59',NULL,NULL),('7a9d307d22fb2301d6a9396094afc82f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-14 18:45:04',NULL,NULL),('28dbc8d16f98fb4b1f481462fcaba48b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-14 20:56:57',NULL,NULL),('f1186792c6584729a0f6da4432d951f9',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-14 21:45:52',NULL,NULL),('4f31f3ebaf5d1a159d2bb11dd9984909',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-15 11:14:15',NULL,NULL),('9a5c1fbf3543880af6461182e24b75db',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-15 13:51:27',NULL,NULL),('b86958d773b2c2bd79baa2e8c3c84050',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-15 16:49:36',NULL,NULL),('a052befb699ee69b3197b139fd9263f0',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-15 17:34:58',NULL,NULL),('6836a652dc96246c028577e510695c6f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-15 20:47:02',NULL,NULL),('8fe913a5b037943c6667ee4908f88bea',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-16 11:18:48',NULL,NULL),('9410b7974fbc9df415867095b210e572',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-16 11:18:58',NULL,NULL),('98d4b573769af6d9c10cd5c509bfb7af',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-16 11:21:25',NULL,NULL),('18b16a451fec0fe7bf491ab348c65e30',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-16 11:55:45',NULL,NULL),('0d85728028ed67da696137c0e82ab2f6',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-16 12:58:43',NULL,NULL),('4aa770f37a7de0039ba0f720c5246486',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-17 17:26:12',NULL,NULL),('2fecb508d344c5b3a40f471d7b110f14',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-17 17:36:53',NULL,NULL),('61aac4cfe67ec6437cd901f95fbd6f45',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-17 17:40:21',NULL,NULL),('62e208389a400e37250cfa51c204bdc8',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-17 17:44:49',NULL,NULL),('eb9a522fd947c7a706c5a106ca32b8c9',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-17 17:50:17',NULL,NULL),('bd9167a87aee4574a30d67825acaad0a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-17 17:51:03',NULL,NULL),('49f1ec54eb16af2001ff6809a089e940',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-17 17:59:10',NULL,NULL),('bdfd95b4d4c271d7d8d38f89f4a55da9',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-17 17:59:12',NULL,NULL),('95063e0bdfa5c9817cc0f66e96baad93',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-17 17:59:16',NULL,NULL),('30da94dd068a5a57f3cece2ca5ac1a25',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-17 18:01:43',NULL,NULL),('8fde5f89e8ad30cf3811b8683a9a77b1',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-17 18:02:41',NULL,NULL),('2ebe7f0432f01788d69d39bc6df04a1a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-17 18:05:09',NULL,NULL),('beb9ef68b586f05bd7cf43058e01ad4a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-17 22:29:02',NULL,NULL),('befbcf5a27ef8d2ca8e6234077f9413d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-18 16:01:33',NULL,NULL),('378b44af9c1042c1438450b11c707fcf',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-18 16:07:39',NULL,NULL),('0571e5730ee624d0dd1b095ad7101738',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-18 16:10:50',NULL,NULL),('3ec2023daa4a7d6a542bf28b11acf586',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-18 16:18:20',NULL,NULL),('64c00f27ddc93fda22f91b38d2b828b5',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-18 17:34:45',NULL,NULL),('21bad1470a40da8336294ca7330f443d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-18 17:35:32',NULL,NULL),('72ee87d0637fb3365fdff9ccbf286c4a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-18 17:36:44',NULL,NULL),('d8c43edd685431ab3ef7b867efc29214',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-18 17:37:18',NULL,NULL),('0ad51ba59da2c8763a4e6ed6e0a292b2',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-18 17:37:53',NULL,NULL),('d916bd1d956418e569549ee1c7220576',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-18 19:18:42',NULL,NULL),('917dbb5db85d1a6f142135827e259bbf',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-18 20:21:03',NULL,NULL),('db2b518e7086a0561f936d327a0ab522',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-18 22:39:23',NULL,NULL),('61d2d2fd3e9e23f67c23b893a1ae1e72',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-18 22:44:56',NULL,NULL),('671a44fd91bf267549d407e0c2a680ee',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-18 22:45:16',NULL,NULL),('586e8244eff6d6761077ef15ab9a82d9',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-18 23:03:51',NULL,NULL),('2b4d33d9be98e1e4cdd408a55f731050',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-19 10:32:00',NULL,NULL),('3267222d9387284b864792531b450bfe',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-19 10:33:23',NULL,NULL),('a28de45f52c027a3348a557efab6f430',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-19 10:34:26',NULL,NULL),('9db7e7d214dbe9fe8fff5ff20634e282',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-19 11:19:34',NULL,NULL),('74209dfc97285eb7919868545fc2c649',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-19 11:23:08',NULL,NULL),('49d48fda33126595f6936a5d64e47af0',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-19 13:17:51',NULL,NULL),('fe0dc06eaef69047131f39052fcce5c4',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-19 13:56:05',NULL,NULL),('f540eff3f6e86c1e0beccd300efd357f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-19 15:15:26',NULL,NULL),('3fd0d771bbdd34fae8b48690ddd57799',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-19 17:17:22',NULL,NULL),('27e8812c9a16889f14935eecacf188eb',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-19 18:52:19',NULL,NULL),('88bab180edf685549c7344ec8db7d954',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-19 19:07:06',NULL,NULL),('ed9b4ffc8afab10732aac2d0f84c567b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-19 19:10:52',NULL,NULL),('ad97829fe7fefcd38c80d1eb1328e40f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-20 09:28:18',NULL,NULL),('3d25a4cdd75b9c4c137394ce68e67154',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-20 09:59:31',NULL,NULL),('5c7e834e089ef86555d8c2627b1b29b5',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-20 11:25:26',NULL,NULL),('b3adf055f54878657611ef430f85803e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-20 11:33:57',NULL,NULL),('8d105ea6c89691bc8ee7d4fd568aa690',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-20 11:39:33',NULL,NULL),('445436e800d306ec1d7763c0fe28ad38',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-20 11:43:00',NULL,NULL),('7f9c3d539030049a39756208670be394',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-20 11:44:40',NULL,NULL),('feaf7c377abc5824c1757d280dd3c164',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-20 11:58:54',NULL,NULL),('c72bb25acd132303788699834ae039b4',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-20 12:06:06',NULL,NULL),('e4c06405615399d6b1ebea45c8112b4d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-20 12:07:26',NULL,NULL),('f95d517f43ba2229c80c14c1883a4ee9',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-20 12:11:59',NULL,NULL),('d18bff297a5c2fa54d708f25a7d790d6',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-20 12:13:05',NULL,NULL),('b5f6636c6e24e559ddf1feb3e1a77fd5',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-20 12:14:05',NULL,NULL),('aeca30df24ce26f008a7e2101f7c513c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-20 12:27:53',NULL,NULL),('cd7a7c49e02ca9613b6879fda4e563cf',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-20 12:29:08',NULL,NULL),('a7ee4b4c236bc0e8f56db5fdf1e5ac38',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-20 13:21:36',NULL,NULL),('6d45672f99bbfd01d6385153e9c3ad91',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-20 13:49:20',NULL,NULL),('905d2cf4308f70a3a2121a3476e38ed0',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-20 14:00:30',NULL,NULL),('27d23027dc320175d22391d06f50082f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-20 15:50:06',NULL,NULL),('52fde989fb8bb78d03fb9c14242f5613',1,'用户名: admin,登录成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-03-20 17:04:09',NULL,NULL),('952947331f8f3379494c4742be797fc3',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-20 18:42:11',NULL,NULL),('39caf3d5d308001aeb0a18e15ae480b9',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 10:31:07',NULL,NULL),('772f238d46531a75fff31bae5841057c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 11:31:16',NULL,NULL),('f79af48e6aeb150432640483f3bb7f2a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 13:09:11',NULL,NULL),('20fc3263762c80ab9268ddd3d4b06500',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 13:36:44',NULL,NULL),('e8b37ad67ef15925352a4ac3342cef07',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 13:38:10',NULL,NULL),('d6aaf0f8e2428bf3c957becbf4bcedb4',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 13:38:14',NULL,NULL),('3bc73699a9fd3245b87336787422729b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 13:41:07',NULL,NULL),('862aa0e6e101a794715174eef96f7847',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 13:41:09',NULL,NULL),('a6209166e1e9b224cca09de1e9ea1ed7',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 13:41:10',NULL,NULL),('b954f7c34dfbe9f6a1fc12244e0a7d59',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 13:41:10',NULL,NULL),('64711edfb8c4eb24517d86baca005c96',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 13:41:11',NULL,NULL),('0efc9df0d52c65ec318e7b46db21655f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 13:42:47',NULL,NULL),('c03985d6e038b5d8ebdeec27fce249ba',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 13:43:24',NULL,NULL),('69e6fd7891d4b42b0cccdc0874a43752',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 13:45:58',NULL,NULL),('9b23981621d5265a55681883ec19fa91',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 13:46:05',NULL,NULL),('37ca8ff7098b9d118adb0a586bdc0d13',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 13:46:07',NULL,NULL),('ea5f9191b0f593a1d6cb585538caa815',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 13:46:08',NULL,NULL),('8e03def9e0283005161d062d4c0a5a80',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 13:46:09',NULL,NULL),('f78e24f5e841acac2a720f46f6c554bc',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 13:47:17',NULL,NULL),('f93279c6899dc5e6cec975906f8bf811',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 13:47:20',NULL,NULL),('cd5af66a87bb40026c72a748155b47e8',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 13:47:26',NULL,NULL),('5902fb4ba61ccf7ff4d2dd97072b7e5b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 13:48:30',NULL,NULL),('e1d1fc464cf48ec26b7412585bdded1a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 13:49:15',NULL,NULL),('5ea258e1f478d27e0879e2f4bcb89ecd',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 14:01:59',NULL,NULL),('2e44c368eda5a7f7a23305b61d82cddb',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 18:14:23',NULL,NULL),('34a6b86424857a63159f0e8254e238c2',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 18:22:08',NULL,NULL),('ffc6178ffa099bb90b9a4d0a64dae42b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 18:28:32',NULL,NULL),('3612f8d40add5a7754ea3d54de0b5f20',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 19:59:59',NULL,NULL),('7a511b225189342b778647db3db385cd',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 20:50:10',NULL,NULL),('b7085f003b4336af4d4ba18147f8e5ae',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 22:29:37',NULL,NULL),('c66e22782dd3916d1361c76b0cc4ec8a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-21 22:44:06',NULL,NULL),('c6cbe54fcb194d025a081e5f91a7e3f0',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-22 10:26:38',NULL,NULL),('1ab7c74d217152081f4fa59e4a56cc7b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-22 12:03:39',NULL,NULL),('5f00b5514a11cd2fe240c131e9ddd136',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-22 16:30:52',NULL,NULL),('82cee1c403025fc1db514c60fc7d8d29',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-22 16:41:50',NULL,NULL),('af5869701738a6f4c2c58fe8dfe02726',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-22 16:42:40',NULL,NULL),('233e39d8b7aa90459ebef23587c25448',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-22 17:38:36',NULL,NULL),('b0cebd174565a88bb850a2475ce14625',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-22 18:19:39',NULL,NULL),('26529d5753ceebbd0d774542ec83a43e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-22 20:17:41',NULL,NULL),('f3e1f7fb81004ccd64df12d94ef1e695',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-22 21:30:37',NULL,NULL),('a2e0435673b17f4fb848eecdf8ecacd6',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-22 21:32:37',NULL,NULL),('5323f848cddbb80ba4f0d19c0580eba9',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-22 22:58:40',NULL,NULL),('5858f2f8436460a94a517904c0bfcacb',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-22 23:42:21',NULL,NULL),('8d9ce65020320d46882be43b22b12a62',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-23 10:56:43',NULL,NULL),('11802c7a3644af411bc4e085553cfd4f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-23 14:46:35',NULL,NULL),('fc69a1640a4772c8edf2548d053fa6de',1,'用户名: admin,登录成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-03-23 14:55:33',NULL,NULL),('e3031f999984909f9048d8ec15543ad0',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-23 18:43:02',NULL,NULL),('f43e38800d779422c75075448af738d1',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-23 18:47:11',NULL,NULL),('dcfe23b155d5c6fa9a302c063b19451e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-23 18:47:21',NULL,NULL),('802cec0efbe9d862b7cea29fefc5448b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-23 18:58:50',NULL,NULL),('f58e160e97d13a851f59b70bf54e0d06',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-23 20:11:58',NULL,NULL),('b8bd2a9de3fb917dfb6b435e58389901',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-23 20:13:31',NULL,NULL),('e01ed1516e8ae3a2180acbd4e4508fa5',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-23 20:28:12',NULL,NULL),('b7f33b5a514045878447fc64636ac3e6',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-23 22:00:34',NULL,NULL),('d0ce9bfc790a573d48d49d3bbbf1a1cb',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-23 22:09:06',NULL,NULL),('74c991568d8bcb2049a0dbff53f72875',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-23 22:12:15',NULL,NULL),('0251bbee51c28f83459f4a57eeb61777',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-23 22:14:27',NULL,NULL),('a5848ab4e8d0fb6ecf71ee1d99165468',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-23 22:14:50',NULL,NULL),('79a1737fcc199c8262f344e48afb000d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-23 23:25:25',NULL,NULL),('6cfeaf6a6be5bb993b9578667999c354',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-24 11:43:34',NULL,NULL),('c5d4597b38275dcb890c6568a7c113f2',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-24 12:18:46',NULL,NULL),('0f173ec7e8819358819aa14aafc724c0',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 11:15:58',NULL,NULL),('ce9893f4d0dd163e900fcd537f2c292d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 11:55:55',NULL,NULL),('90711ddb861e28bd8774631c98f3edb9',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 11:57:42',NULL,NULL),('fb73d58bf6503270025972f99e50335d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 11:57:56',NULL,NULL),('3a290289b4b30a1caaac2d03ad3161cd',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 11:58:13',NULL,NULL),('716f9f5f066a6f75a58b7b05f2f7f861',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 11:59:01',NULL,NULL),('151a9f1b01e4e749124d274313cd138c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 11:59:17',NULL,NULL),('0ef3e7ae8c073a7e3bdd736068f86c84',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 12:02:27',NULL,NULL),('d7e7cb4c21372e48b8e0ec7e679466e3',1,'用户名: null,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 12:02:34',NULL,NULL),('15b9599cb02b49a62fb4a1a71ccebc18',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 12:02:50',NULL,NULL),('ecfee5b948602a274093b8890e5e7f3f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 12:05:11',NULL,NULL),('cbf83d11486a8d57814ae38c9822b022',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 12:05:39',NULL,NULL),('f2ce8024e62740f63c134c3cfb3cae23',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 12:07:41',NULL,NULL),('c665d704539483630cc9ed5715ed57a8',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 12:10:12',NULL,NULL),('e93f1a170e3cd33f90dd132540c7a39b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 12:12:43',NULL,NULL),('fded8eb5d78d13791baec769019fee54',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 12:15:07',NULL,NULL),('03ec66b6b6d17c007ec2f918efe5b898',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 12:16:03',NULL,NULL),('5e8bac7831de49146d568c9a8477ddad',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 12:16:37',NULL,NULL),('cd064a2f6cb6c640cb97a74aaa6041d7',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 12:17:10',NULL,NULL),('a521d9f2a0087daa37923fa704dea85b',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-03-25 12:45:52',NULL,NULL),('4816854636129e31c2a5f9d38af842ef',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-03-25 12:45:54',NULL,NULL),('90b4bad7939233a1e0d7935f079ea0fa',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-03-25 12:45:54',NULL,NULL),('aec0817ecc0063bde76c1f6b6889d117',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 12:47:06',NULL,NULL),('e169938510c9320cb1495ddb9aabb9d1',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 12:47:40',NULL,NULL),('b7478d917ab6f663e03d458f0bb022a3',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 12:50:55',NULL,NULL),('642e48f2e5ac8fe64f1bfacf4d234dc8',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-03-25 12:51:21',NULL,NULL),('ed2740de487c684be9fa3cf72113ae30',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 12:51:43',NULL,NULL),('b1e9797721dbfcc51bbe7182142cbdcd',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-03-25 12:52:25',NULL,NULL),('6a67bf2ff924548dee04aa97e1d64d38',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 12:52:41',NULL,NULL),('a56661bbc72b8586778513c71f4764f5',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 12:53:09',NULL,NULL),('ae61be664d2f30d4f2248347c5998a45',1,'用户名: jeecg,退出成功！',NULL,'jeecg','jeecg','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-03-25 12:53:17',NULL,NULL),('4ab79469ba556fa890258a532623d1dc',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 12:54:20',NULL,NULL),('3a0330033a8d3b51ffbfb2e0a7db9bba',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 12:54:27',NULL,NULL),('b972484d206b36420efac466fae1c53f',1,'用户名: jeecg,退出成功！',NULL,'jeecg','jeecg','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-03-25 12:54:38',NULL,NULL),('7e92abdc0c1f54596df499a5a2d11683',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 12:59:34',NULL,NULL),('fa9b4d7d42bc9d1ba058455b4afedbfb',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-03-25 12:59:46',NULL,NULL),('1d970c0e396ffc869e3a723d51f88b46',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 13:01:17',NULL,NULL),('88d7136ed5c7630057451816dbaff183',1,'用户名: jeecg,退出成功！',NULL,'jeecg','jeecg','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-03-25 13:01:24',NULL,NULL),('48eac0dd1c11fe8f0cb49f1bd14529c2',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 13:01:31',NULL,NULL),('a8c7ba2d11315b171940def2cbeb0e8f',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-03-25 13:01:40',NULL,NULL),('20fea778f4e1ac5c01b5a5a58e3805be',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 19:01:49',NULL,NULL),('48e5faf2d21ead650422dc2eaf1bb6c5',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 22:08:09',NULL,NULL),('f74f759b43afa639fd1c4f215c984ae0',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-25 22:08:18',NULL,NULL),('d82b170459d99fc05eb8aa1774e1a1c9',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-26 18:45:14',NULL,NULL),('e088a2607864d3e6aadf239874d51756',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-26 18:46:56',NULL,NULL),('95d906e6f048c3e71ddbcc0c9448cf49',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-26 19:23:30',NULL,NULL),('3767186b722b7fefd465e147d3170ad1',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-26 21:57:19',NULL,NULL),('f21e30d73c337ea913849ed65808525c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-27 10:23:22',NULL,NULL),('189e3428e35e27dfe92ece2848b10ba8',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-27 15:52:21',NULL,NULL),('e2b6d0e751f130d35c0c3b8c6bd2a77e',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-03-27 16:18:40',NULL,NULL),('586002e1fb4e60902735070bab48afe3',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-27 16:18:52',NULL,NULL),('611fa74c70bd5a7a8af376464a2133e8',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-27 17:48:13',NULL,NULL),('90555a39c0b02180df74752e4d33f253',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-27 18:26:25',NULL,NULL),('217aa2f713b0903e6be699136e374012',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-27 20:07:32',NULL,NULL),('5554869b3475770046602061775e0e57',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-28 14:38:05',NULL,NULL),('bfec8c8c88868391041667d924e3af7f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-28 14:38:27',NULL,NULL),('675153568c479d8b7c6fe63327066c9f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-28 15:29:42',NULL,NULL),('4930e32672465979adbc592e116226a6',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-28 16:53:28',NULL,NULL),('9a1456ef58a2b1fb63cdc54b723f2539',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-28 17:26:39',NULL,NULL),('484cdb8db40e3f76ef686552f57d8099',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-28 18:14:49',NULL,NULL),('02d4447c9d97ac4fc1c3a9a4c789c2a8',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-03-28 18:24:18',NULL,NULL),('59558082e1b1d754fa3def125ed4db3c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-28 18:24:19',NULL,NULL),('c434dc5172dc993ee7cd96187ca58653',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-03-28 19:46:08',NULL,NULL),('a6261bbbf8e964324935722ea1384a5d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-28 19:46:27',NULL,NULL),('f0748a25728348591c7b73a66f273457',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-03-28 19:46:27',NULL,NULL),('14f447d9b60725cc86b3100a5cb20b75',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-28 19:46:30',NULL,NULL),('7c88e9cf6018a1b97b420b8cb6122815',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-03-28 19:46:30',NULL,NULL),('cb7c6178101ef049d3f1820ee41df539',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-28 19:59:19',NULL,NULL),('21fed0f2d080e04cf0901436721a77a6',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-28 21:53:31',NULL,NULL),('4ba055970859a6f1afcc01227cb82a2d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-29 09:43:56',NULL,NULL),('3ba1e54aa9aa760b59dfe1d1259459bc',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-29 09:44:07',NULL,NULL),('7b44138c1b80b67da13b89db756a22b0',2,'添加测试DEMO',NULL,NULL,NULL,'127.0.0.1','org.jeecg.modules.demo.test.controller.JeecgDemoController.add()',NULL,'[{\"createBy\":\"jeecg-boot\",\"createTime\":1553824172062,\"id\":\"5fce01cb7f0457746c97d8ca05628f81\",\"name\":\"1212\"}]',NULL,25,'jeecg-boot','2019-03-29 09:49:32',NULL,NULL),('d7e8a7f14967c70d68f5569cb4d11d0a',2,'删除测试DEMO',NULL,NULL,NULL,'127.0.0.1','org.jeecg.modules.demo.test.controller.JeecgDemoController.delete()',NULL,'[\"5fce01cb7f0457746c97d8ca05628f81\"]',NULL,9,'jeecg-boot','2019-03-29 09:49:39',NULL,NULL),('e7f2b0a7493e7858c5db1f1595fa54b1',2,'添加测试DEMO',NULL,NULL,NULL,'127.0.0.1','org.jeecg.modules.demo.test.controller.JeecgDemoController.add()',NULL,'[{\"createBy\":\"jeecg-boot\",\"createTime\":1553824376817,\"id\":\"e771211b77cd3b326d3e61edfd9a5a19\",\"keyWord\":\"222\",\"name\":\"222\"}]',NULL,7,'jeecg-boot','2019-03-29 09:52:56',NULL,NULL),('997bb4cb1ad24439b6f7656222af0710',2,'添加测试DEMO',NULL,NULL,NULL,'127.0.0.1','org.jeecg.modules.demo.test.controller.JeecgDemoController.add()',NULL,'[{\"createBy\":\"jeecg-boot\",\"createTime\":1553824768819,\"id\":\"ee84471f0dff5ae88c45e852bfa0280f\",\"keyWord\":\"22\",\"name\":\"222\"}]',NULL,5,'jeecg-boot','2019-03-29 09:59:28',NULL,NULL),('a6c3b28530416dace21371abe8cae00b',2,'删除测试DEMO',NULL,NULL,NULL,'127.0.0.1','org.jeecg.modules.demo.test.controller.JeecgDemoController.delete()',NULL,'[\"ee84471f0dff5ae88c45e852bfa0280f\"]',NULL,9,'jeecg-boot','2019-03-29 09:59:48',NULL,NULL),('d2fe98d661f1651b639bf74499f124db',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-29 10:16:29',NULL,NULL),('2186244ae450e83d1487aa01fbeae664',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-29 14:47:43',NULL,NULL),('a5daa58b078cb8b3653af869aeecebd0',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-29 17:14:31',NULL,NULL),('f29f3b7b7e14b1389a0c53d263c0b26b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-29 17:44:25',NULL,NULL),('2659c59136fb1a284ab0642361b10cdd',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-29 18:40:22',NULL,NULL),('a42e5cd05566ea226c2e2fc201860f2c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-30 11:15:50',NULL,NULL),('f06048c147c5bcdbed672e32b2c86b1c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-30 14:07:28',NULL,NULL),('13c83c56a0de8a702aeb2aa0c330e42c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-30 14:53:52',NULL,NULL),('ab1d707bbfdf44aa17307d30ca872403',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-30 15:50:42',NULL,NULL),('5d8ed15778aa7d99224ee62c606589fb',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-03-30 15:51:02',NULL,NULL),('42aef93749cc6222d5debe3fb31ba41b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-30 15:51:04',NULL,NULL),('5c04e3d9429e3bcff4d55f6205c4aa83',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-30 18:14:29',NULL,NULL),('af8fe96a9f0b325e4833fc0d9c4721bf',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-03-30 18:14:56',NULL,NULL),('21910e350c9083e107d39ff4278f51d6',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-30 18:14:59',NULL,NULL),('636309eec5e750bc94ce06fb98526fb2',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-03-30 18:15:03',NULL,NULL),('9d0416e09fae7aeeeefc8511a61650c2',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-30 18:15:05',NULL,NULL),('2e63fd1b3b6a6145bc04b2a1df18d2f5',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-30 19:01:33',NULL,NULL),('2966ed2bdf67c9f3306b058d13bef301',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-30 21:25:10',NULL,NULL),('3683743d1936d06f3aaa03d6470e5178',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-30 22:40:12',NULL,NULL),('0ba24c5f61ff53f93134cf932dd486db',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-31 21:06:05',NULL,NULL),('bbd3e1f27e025502a67cf54945b0b269',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-03-31 22:13:16',NULL,NULL),('1f8f46118336b2cacf854c1abf8ae144',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-01 11:02:59',NULL,NULL),('ac8cf22c2f10a38c7a631fc590551c40',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-01 12:04:16',NULL,NULL),('7d11535270734de80bd52ec0daa4fc1f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'192.168.1.105',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-01 12:20:14',NULL,NULL),('6b4cdd499885ccba43b40f10abf64a78',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-01 13:04:43',NULL,NULL),('77a329e5eb85754075165b06b7d877fd',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-01 13:25:17',NULL,NULL),('0e754ee377033067f7b2f10b56b8784c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-01 17:17:45',NULL,NULL),('9b7a830914668881335da1b0ce2274b1',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-01 17:19:02',NULL,NULL),('a1b870eee811cfa4960f577b667b0973',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-01 18:23:44',NULL,NULL),('85b3106d757d136b48172a9ab1f35bb6',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-01 18:34:34',NULL,NULL),('7f31435ca2f5a4ef998a4152b2433dec',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-01 18:36:40',NULL,NULL),('f20cf3fe228ba6196a48015b98d0d354',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-01 19:25:22',NULL,NULL),('65771bce3f5786dfb4d84570df61a47a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-01 22:07:57',NULL,NULL),('c98a6367b152cf5311d0eec98fab390c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-01 22:13:34',NULL,NULL),('93b4d26f60d7fb45a60524760bf053e4',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-01 22:20:06',NULL,NULL),('3087ac4988a961fa1ec0b4713615c719',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-01 22:54:24',NULL,NULL),('a69f4ff4e48754de96ae6fa4fabc1579',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 09:18:48',NULL,NULL),('a63147887c6ca54ce31f6c9e6279a714',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 09:19:07',NULL,NULL),('a2950ae3b86f786a6a6c1ce996823b53',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-04-02 09:47:11',NULL,NULL),('615625178b01fc20c60184cd28e64a70',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 09:47:13',NULL,NULL),('89fbc93e77defb34c609c84a7fe83039',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-04-02 09:47:14',NULL,NULL),('432067d777447423f1ce3db11a273f6f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 09:47:17',NULL,NULL),('7d8539ff876aad698fba235a1c467fb8',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-04-02 09:47:18',NULL,NULL),('689b8f2110f99c52e18268cbaf05bbb6',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 09:58:44',NULL,NULL),('2919d2f18db064978a619707bde4d613',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-04-02 09:58:45',NULL,NULL),('0dc6d04b99e76ad400eef1ded2d3d97c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 09:59:45',NULL,NULL),('45f0309632984f5f7c70b3d40dbafe8b',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-04-02 09:59:46',NULL,NULL),('d869534109332e770c70fad65ef37998',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 10:02:30',NULL,NULL),('c21422fa08f8480a53367fda7ddddf12',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-04-02 10:02:30',NULL,NULL),('1e4533a02fb9c739a3555fa7be6e7899',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 10:04:56',NULL,NULL),('03c0ab177bd7d840b778713b37daf86f',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-04-02 10:04:57',NULL,NULL),('60886d5de8a18935824faf8b0bed489e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 10:11:35',NULL,NULL),('4218b30015501ee966548c139c14f43f',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-04-02 10:11:35',NULL,NULL),('de938485a45097d1bf3fa311d0216ed4',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 10:15:22',NULL,NULL),('e1d0b1fd3be59e465b740e32346e85b0',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-04-02 10:16:37',NULL,NULL),('4234117751af62ac87343cbf8a6f1e0f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 10:17:17',NULL,NULL),('845f732f6a0f0d575debc4103e92bea2',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-04-02 10:17:18',NULL,NULL),('cc39057ae0a8a996fb0b3a8ad5b8f341',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 10:20:05',NULL,NULL),('155d2991204d541388d837d1457e56ab',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 11:32:57',NULL,NULL),('2312c2693d6b50ca06799fee0ad2554a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 12:11:32',NULL,NULL),('d98115c02c0ac478a16d6c35de35053d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 12:50:09',NULL,NULL),('55e906361eeabb6ec16d66c7196a06f0',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 12:50:20',NULL,NULL),('3836dc3f91d072e838092bc8d3143906',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 12:50:32',NULL,NULL),('add13f513772a63f8ca8bf85634bb72c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 13:09:03',NULL,NULL),('a6971e63e3d9158020e0186cda81467d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 14:59:23',NULL,NULL),('2eb75cb6ca5bc60241e01fa7471c0ccf',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 18:34:04',NULL,NULL),('3e69108be63179550afe424330a8a9e4',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-04-02 18:38:05',NULL,NULL),('6c558d70dc5794f9f473d8826485727a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 18:38:44',NULL,NULL),('687810e7fea7e480962c58db515a5e1c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 18:42:30',NULL,NULL),('d23e6766cecf911fb2e593eeee354e18',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 18:42:35',NULL,NULL),('0819ea9729ddf70f64ace59370a62cf1',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 18:59:43',NULL,NULL),('939b3ff4733247a47efe1352157b1f27',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 19:01:06',NULL,NULL),('6cf638853ef5384bf81ed84572a6445d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-02 19:25:24',NULL,NULL),('bc28d4275c7c7fcd067e1aef40ec1dd4',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-03 10:53:03',NULL,NULL),('43536edd8aa99f9b120872e2c768206c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-03 10:53:26',NULL,NULL),('7268539fbe77c5cc572fb46d71d838f1',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-03 13:22:48',NULL,NULL),('f0409312093beb563ac4016f2b2c6dfd',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-03 13:24:59',NULL,NULL),('a710ed2de7e31fd72b1efb1b54ba5a87',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-03 15:30:43',NULL,NULL),('b01c3f89bcfd263de7cb1a9b0210a7af',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-03 17:53:55',NULL,NULL),('e1fa52ecbcc0970622cc5a0c06de9317',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-04-03 18:33:04',NULL,NULL),('790b722fa99a8f3a0bc38f61e13c1cf4',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-03 18:34:07',NULL,NULL),('20e5887d0c9c7981159fe91a51961141',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-03 20:12:07',NULL,NULL),('ce6aa822166b97a78b0bbea62366f8e0',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-03 20:14:29',NULL,NULL),('3e6116220fa8d4808175738c6de51b12',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-03 21:04:46',NULL,NULL),('10a434c326e39b1d046defddc8c57f4a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-03 21:18:29',NULL,NULL),('317e3ae1b6ccdfb5db6940789e12d300',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-04-03 21:44:31',NULL,NULL),('2b801129457c05d23653ecaca88f1711',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-03 21:44:34',NULL,NULL),('7a99cf653439ca82ac3b0d189ddaad4a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-04 10:41:34',NULL,NULL),('68e90e08a866de748e9901e923406959',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-04 12:37:06',NULL,NULL),('2942a12521ac8e3d441429e6c4b04207',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-04 14:12:10',NULL,NULL),('dfacaa7c01ccf0bade680044cced3f11',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-04 15:25:10',NULL,NULL),('f3cafb545e5693e446f641fa0b5ac8cd',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-04 17:07:56',NULL,NULL),('060d541a9571ca2b0d24790a98d170a6',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-04 19:28:04',NULL,NULL),('9df97c1b3213aa64eda81c6bf818b02b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-04 22:42:48',NULL,NULL),('43079866b75ee6a031835795bb681e16',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-04-04 22:44:16',NULL,NULL),('55d649432efa7eaecd750b4b6b883f83',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-04 22:44:19',NULL,NULL),('ca737885d9034f71f70c4ae7986fafa8',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-04 22:47:28',NULL,NULL),('1534f0c50e67c5682e91af5160a67a80',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-04 22:47:28',NULL,NULL),('93bb98ba996dacebfb4f61503067352e',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-04 22:47:28',NULL,NULL),('5c48703e3a2d4f81ee5227f0e2245990',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-04-04 23:12:04',NULL,NULL),('70849167f54fd50d8906647176d90fdf',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-04 23:12:29',NULL,NULL),('310bb368795f4985ed4eada030a435a0',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-04 23:22:20',NULL,NULL),('477592ab95cd219a2ccad79de2f69f51',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-05 10:38:24',NULL,NULL),('e39f051ba6fdb7447f975421f3b090a7',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-05 12:49:18',NULL,NULL),('4d1be4b4991a5c2d4d17d0275e4209cf',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-05 20:47:21',NULL,NULL),('9eb3fb6d9d45e3847a88f65ed47da935',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'192.168.3.22',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-05 20:52:47',NULL,NULL),('6664dc299f547f6702f93e2358810cc1',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'192.168.3.22',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-05 21:04:14',NULL,NULL),('9c32ec437d8f8d407b1bd1165fc0305d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-08 15:01:25',NULL,NULL),('68df65639e82cc6a889282fbef53afbb',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-08 15:01:37',NULL,NULL),('79e76353faffd0beb0544c0aede8564f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-08 17:28:14',NULL,NULL),('da3fda67aea2e565574ec2bcfab5b750',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-08 22:36:20',NULL,NULL),('de37620b6921abcfe642606a0358d30f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-09 15:42:46',NULL,NULL),('b0e6b3a0ec5d8c73166fb8129d21a834',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-09 16:56:16',NULL,NULL),('01075aa535274735e0df0a8bc44f62f9',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-04-09 16:56:46',NULL,NULL),('01ebe1cbeae916a9228770f63130fdac',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-09 16:56:50',NULL,NULL),('baa53d6a534e669f6150ea47565fa5b9',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-09 17:27:24',NULL,NULL),('e232f89df26cc9e5eced10476c4e4a2b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-10 10:05:11',NULL,NULL),('335956cbad23d1974138752199bf1d84',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-10 10:05:36',NULL,NULL),('bd6d7d720b9dd803f8ad26e2d40870f3',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-10 11:04:06',NULL,NULL),('ff3f7dbda20cd2734b1238fa5ba17fcf',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-04-10 11:26:43',NULL,NULL),('672b527c49dc349689288ebf2c43ed4d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-10 11:26:47',NULL,NULL),('21510ebaa4eca640852420ed6f6cbe01',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-10 11:41:26',NULL,NULL),('3e2574b7b723fbc9c712b8e200ea0c84',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-10 14:24:34',NULL,NULL),('0d4582c6b7719b0bfc0260939d97274f',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-10 21:48:47',NULL,NULL),('3e64011b4bea7cdb76953bfbf57135ce',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-10 23:09:32',NULL,NULL),('a83e37b55a07fe48272b0005a193dee6',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-11 09:17:59',NULL,NULL),('30ec2dc50347240f131c1004ee9b3a40',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-11 10:19:05',NULL,NULL),('7ce1934fb542a406e92867aec5b7254d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-11 14:53:23',NULL,NULL),('5ee6d5fe1e6adcc4ad441b230fae802d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-11 15:56:33',NULL,NULL),('d4ef00700436645680657f72445d38db',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-11 18:05:29',NULL,NULL),('aa49341b29865b45588ad2f9b89c47ea',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-04-11 19:42:42',NULL,NULL),('d3b54be0510db6a6da27bf30becb5335',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-11 19:42:46',NULL,NULL),('dd4e1ab492e59719173d8ae0f5dbc9a2',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-04-11 19:47:12',NULL,NULL),('056dd4466f4ed51de26c535fd9864828',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-11 19:47:15',NULL,NULL),('89bfd8b9d6fa57a8e7017a2345ec1534',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-12 09:27:32',NULL,NULL),('51aeabed335ab4e238640a4d17dd51a3',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg-boot','2019-04-12 10:12:41',NULL,NULL),('67181c36b55b06047a16a031fd1262c1',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-05-17 13:55:22',NULL,NULL),('2d5af41d2df82b316ba31fcdf6168d6a',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-05-17 14:43:58',NULL,NULL),('e2f703771f64b1bcd709204669ae3d93',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-05-17 14:48:39',NULL,NULL),('8143ce0b35bfe6e7b8113e1ecc066acd',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-05-17 14:48:48',NULL,NULL),('2bca2d6666c1f6630225252c7b31326c',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-05-17 18:30:48',NULL,NULL),('11695a9dcf44859cda97a4226bebe21b',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-05-17 18:30:57',NULL,NULL),('40209016cadff6b571a8150c6218cfa8',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-05-18 11:33:28',NULL,NULL),('23a314588249752842447e4f98783be4',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-05-19 18:28:48',NULL,NULL),('5f0a5e85efbe9c79645ffc0c15fcee1a',2,'添加测试DEMO',NULL,'admin','管理员','127.0.0.1','org.jeecg.modules.demo.test.controller.JeecgDemoController.add()',NULL,'[{\"createBy\":\"admin\",\"createTime\":1558261833637,\"id\":\"94f78b1c9753dfb1202d731f540666e1\",\"keyWord\":\"1\",\"name\":\"1\",\"sysOrgCode\":\"A01\"}]',NULL,30,'admin','2019-05-19 18:30:33',NULL,NULL),('57264fff74c4f857bddf5d766951f3c9',2,'添加测试DEMO',NULL,'admin','管理员','127.0.0.1','org.jeecg.modules.demo.test.controller.JeecgDemoController.add()',NULL,'[{\"createBy\":\"admin\",\"createTime\":1558262155067,\"id\":\"dcb45a2fc661e5cdc341b806e5914873\",\"name\":\"111\",\"sysOrgCode\":\"A01\"}]',NULL,5,'admin','2019-05-19 18:35:55',NULL,NULL),('eef5b90eea8e7394193443cfd7476529',2,'删除测试DEMO',NULL,'admin','管理员','127.0.0.1','org.jeecg.modules.demo.test.controller.JeecgDemoController.delete()',NULL,'[\"dcb45a2fc661e5cdc341b806e5914873\"]',NULL,9,'admin','2019-05-19 18:36:02',NULL,NULL),('488fc8f3d040fa75c6802898ea88f7d6',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-05-20 11:38:38',NULL,NULL),('6c99cfe2774c15ad030b83723f81d70d',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-05-20 14:07:25',NULL,NULL),('1bf5c5603b79f749d4ee75965b3698db',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-05-20 14:54:39',NULL,NULL),('5bca377b50c362009738d612cac82006',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-05-20 14:54:38',NULL,NULL),('2255d6f5e2a3d0839b8b9cfc67816c5c',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-05-20 15:01:51',NULL,NULL),('c7384ed6a6b09ff6704a6b1c1e378cee',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-07-05 14:45:30',NULL,NULL),('63c998d68b4d0d1529d86b4c0628e072',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-07-05 14:45:40',NULL,NULL),('b096a9e76395f1a52d8c260c4eb811fd',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-08-23 18:51:24',NULL,NULL),('da7d2236f6f9e0f61897e5ea9b968d4d',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-08-23 20:02:07',NULL,NULL),('6ee846271a3d4b9e576b5a0749c49d12',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-08-23 20:02:16',NULL,NULL),('f6b0f562257bf02c983b9e3998ff864e',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-08-23 22:43:40',NULL,NULL),('9e1da5d8758f2681543971ee43ee14e2',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-08-23 22:43:48',NULL,NULL),('dd9b2cfffb798a22d90dada4fdbbbc61',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-08-23 23:39:56',NULL,NULL),('b99f5b6975350d86db4c5dd91de9f608',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-08-23 23:40:05',NULL,NULL),('1185035214331654145',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-10-18 11:29:46',NULL,NULL),('1185035238713143298',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-10-18 11:29:52',NULL,NULL),('1185035239463923713',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-10-18 11:29:53',NULL,NULL),('1185037047527714817',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-10-18 11:37:04',NULL,NULL),('1185037216109375490',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,133,'admin','2019-10-18 11:37:44',NULL,NULL),('1185037734533738497',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,24,'admin','2019-10-18 11:39:48',NULL,NULL),('1185037756142792705',2,'编辑用户，id： e9ca23d68d884d4ebb19d07889727dae',2,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-10-18 11:39:53',NULL,NULL),('1185037829144653825',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,12,'admin','2019-10-18 11:40:10',NULL,NULL),('1185039907581669377',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,6,'admin','2019-10-18 11:48:26',NULL,NULL),('1185039947956039681',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,5,'admin','2019-10-18 11:48:35',NULL,NULL),('1185040064834514945',2,'职务表-添加',2,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.add()',NULL,'[{\"code\":\"devleader\",\"createBy\":\"admin\",\"createTime\":1571370543072,\"id\":\"1185040064792571906\",\"name\":\"研发部经理\",\"rank\":\"3\",\"sysOrgCode\":\"A01\"}]',NULL,22,'admin','2019-10-18 11:49:03',NULL,NULL),('1185040066562568193',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,26,'admin','2019-10-18 11:49:04',NULL,NULL),('1185129808478158850',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-10-18 17:45:39',NULL,NULL),('1185452151318528001',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-10-19 15:06:32',NULL,NULL),('1185452231589117953',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-10-19 15:06:51',NULL,NULL),('1197430985244905474',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-11-21 16:26:08',NULL,NULL),('1197431068325679105',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-11-21 16:26:29',NULL,NULL),('1197431850395602945',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,NULL,NULL,41,'admin','2019-11-21 16:29:35',NULL,NULL),('1197431872520556545',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,65,'admin','2019-11-21 16:29:40',NULL,NULL),('1197431893076840450',2,'职务表-编辑',3,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.edit()',NULL,'[{\"code\":\"devleader\",\"createBy\":\"admin\",\"createTime\":1571370543000,\"id\":\"1185040064792571906\",\"name\":\"研发部经理\",\"postRank\":\"2\",\"sysOrgCode\":\"A01\",\"updateBy\":\"admin\",\"updateTime\":1574324985161}]',NULL,19,'admin','2019-11-21 16:29:45',NULL,NULL),('1197431893756317697',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,42,'admin','2019-11-21 16:29:45',NULL,NULL),('1197433172830294018',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,22,'admin','2019-11-21 16:34:50',NULL,NULL),('1197433546278539266',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,16,'admin','2019-11-21 16:36:19',NULL,NULL),('1197433566151151618',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-11-21 16:36:24',NULL,NULL),('1197434320656130049',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-11-21 16:39:24',NULL,NULL),('1197434360204222466',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,240,'admin','2019-11-21 16:39:33',NULL,NULL),('1197434364826345474',2,'编辑用户，id： e9ca23d68d884d4ebb19d07889727dae',2,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2019-11-21 16:39:34',NULL,NULL),('1197434403829178369',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-11-21 16:39:44',NULL,NULL),('1197434443708620802',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-11-21 16:39:53',NULL,NULL),('1197434470036267009',2,'职务表-分页列表查询',1,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,45,'jeecg','2019-11-21 16:40:00',NULL,NULL),('1197434579583098881',2,'职务表-分页列表查询',1,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,46,'jeecg','2019-11-21 16:40:26',NULL,NULL),('1197448449475338242',1,'用户名: jeecg,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-11-21 17:35:33',NULL,NULL),('1197448475219976193',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-11-21 17:35:39',NULL,NULL),('1197448491221245953',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,NULL,NULL,98,'admin','2019-11-21 17:35:42',NULL,NULL),('1197449269478547458',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,NULL,NULL,43,'admin','2019-11-21 17:38:48',NULL,NULL),('1197450304582443009',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,NULL,NULL,27,'admin','2019-11-21 17:42:55',NULL,NULL),('1197453216322797569',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,NULL,NULL,526,'admin','2019-11-21 17:54:29',NULL,NULL),('1197454357987155969',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,NULL,NULL,329,'admin','2019-11-21 17:59:01',NULL,NULL),('1197792320302452738',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-11-22 16:21:57',NULL,NULL),('1197792369866543106',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,'jeecg','2019-11-22 16:22:10',NULL,NULL),('1197793164787802113',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,NULL,NULL,381,'admin','2019-11-22 16:25:19',NULL,NULL),('1209402348671193089',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2019-12-24 17:16:04',NULL,NULL),('1209402408473579521',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2019-12-24 17:16:18',NULL,NULL),('1209402471128092673',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,NULL,NULL,472,'admin','2019-12-24 17:16:33',NULL,NULL),('1209417003212853250',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,NULL,NULL,42,'admin','2019-12-24 18:14:18',NULL,NULL),('1209646296664756226',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2019-12-25 09:25:26',NULL,NULL),('1209646643298816001',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2019-12-25 09:26:49',NULL,NULL),('1209648067323744257',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,NULL,NULL,28,'admin','2019-12-25 09:32:28',NULL,NULL),('1209648217823760385',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,NULL,NULL,21,'admin','2019-12-25 09:33:04',NULL,NULL),('1209648344894394369',2,'填值规则-批量删除',4,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.deleteBatch()',NULL,'[\"1192350056519323649,1192349918153428994,\"]',NULL,23,'admin','2019-12-25 09:33:34',NULL,NULL),('1209648345854889985',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,NULL,NULL,17,'admin','2019-12-25 09:33:34',NULL,NULL),('1209648456588709890',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,122,'admin','2019-12-25 09:34:01',NULL,NULL),('1209648997351936002',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,24,'admin','2019-12-25 09:36:10',NULL,NULL),('1209649005795069954',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,25,'admin','2019-12-25 09:36:12',NULL,NULL),('1209649012203966466',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,17,'admin','2019-12-25 09:36:13',NULL,NULL),('1209653324963500034',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,NULL,NULL,19,'admin','2019-12-25 09:53:22',NULL,NULL),('1209653453917376513',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,NULL,NULL,15,'admin','2019-12-25 09:53:52',NULL,NULL),('1209660332378755073',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,NULL,NULL,126,'admin','2019-12-25 10:21:12',NULL,NULL),('1209660342411530241',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,NULL,NULL,26,'admin','2019-12-25 10:21:15',NULL,NULL),('1209672160353783810',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,170,'admin','2019-12-25 11:08:12',NULL,NULL),('1209672431796555778',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,42,'admin','2019-12-25 11:09:17',NULL,NULL),('1209847153045913602',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2019-12-25 22:43:34',NULL,NULL),('1231582569151074306',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-23 22:12:20',NULL,NULL),('1231582603032662018',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-23 22:12:29',NULL,NULL),('1231582605322752002',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-23 22:12:29',NULL,NULL),('1231586195961556994',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-23 22:26:45',NULL,NULL),('1231586370448797697',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,540,'admin','2020-02-23 22:27:27',NULL,NULL),('1231589034586804226',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,37,'admin','2020-02-23 22:38:02',NULL,NULL),('1231589059643576321',2,'编辑用户，id： e9ca23d68d884d4ebb19d07889727dae',2,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2020-02-23 22:38:08',NULL,NULL),('1231590342991548417',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,NULL,NULL,26,'admin','2020-02-23 22:43:14',NULL,NULL),('1231590348280565761',2,'编码校验规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysCheckRuleController.queryPageList()',NULL,NULL,NULL,27,'admin','2020-02-23 22:43:16',NULL,NULL),('1231590455747022850',2,'部门角色-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDepartRoleController.queryPageList()',NULL,NULL,NULL,6,'admin','2020-02-23 22:43:41',NULL,NULL),('1231590510293946370',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,15,'admin','2020-02-23 22:43:54',NULL,NULL),('1231590533404561410',2,'编辑用户，id： e9ca23d68d884d4ebb19d07889727dae',2,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2020-02-23 22:44:00',NULL,NULL),('1231590588148617218',2,'部门角色-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDepartRoleController.queryPageList()',NULL,NULL,NULL,45,'admin','2020-02-23 22:44:13',NULL,NULL),('1231590598588239874',2,'部门角色-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDepartRoleController.queryPageList()',NULL,NULL,NULL,8,'admin','2020-02-23 22:44:15',NULL,NULL),('1231590600106577921',2,'部门角色-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDepartRoleController.queryPageList()',NULL,NULL,NULL,11,'admin','2020-02-23 22:44:16',NULL,NULL),('1231590978101448705',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,17,'admin','2020-02-23 22:45:46',NULL,NULL),('1231591017582432257',2,'多数据源管理-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDataSourceController.queryPageList()',NULL,NULL,NULL,41,'admin','2020-02-23 22:45:55',NULL,NULL),('1231593459988566017',2,'部门角色-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDepartRoleController.queryPageList()',NULL,NULL,NULL,22,'admin','2020-02-23 22:55:37',NULL,NULL),('1231593466594594817',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,13,'admin','2020-02-23 22:55:39',NULL,NULL),('1231593479697600513',2,'职务表-编辑',3,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.edit()',NULL,'[{\"code\":\"devleader\",\"createBy\":\"admin\",\"createTime\":1571370543000,\"id\":\"1185040064792571906\",\"name\":\"研发部经理\",\"postRank\":\"2\",\"sysOrgCode\":\"A01\",\"updateBy\":\"admin\",\"updateTime\":1582469742105}]',NULL,16,'admin','2020-02-23 22:55:42',NULL,NULL),('1231593480725204994',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,16,'admin','2020-02-23 22:55:42',NULL,NULL),('1231596465543032834',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-23 23:07:33',NULL,NULL),('1231596468936224769',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-23 23:07:35',NULL,NULL),('1231596595327381506',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-23 23:08:05',NULL,NULL),('1231596596799582209',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-23 23:08:05',NULL,NULL),('1231596742199324674',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-23 23:08:40',NULL,NULL),('1231596743692496897',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-23 23:08:40',NULL,NULL),('1231597287962157057',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-23 23:10:49',NULL,NULL),('1231597290327744513',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-23 23:10:51',NULL,NULL),('1231598580457857025',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-23 23:15:57',NULL,NULL),('1231599446049009666',2,'部门角色-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDepartRoleController.queryPageList()',NULL,NULL,NULL,62,'admin','2020-02-23 23:19:24',NULL,NULL),('1231599453611339778',2,'部门角色-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDepartRoleController.queryPageList()',NULL,NULL,NULL,17,'admin','2020-02-23 23:19:26',NULL,NULL),('1231599534171336706',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,25,'admin','2020-02-23 23:19:46',NULL,NULL),('1231599542991958018',2,'部门角色-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDepartRoleController.queryPageList()',NULL,NULL,NULL,23,'admin','2020-02-23 23:19:48',NULL,NULL),('1231615277050998786',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-24 00:22:19',NULL,NULL),('1231615300820119553',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-24 00:22:25',NULL,NULL),('1231645918777962498',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-24 02:24:04',NULL,NULL),('1231660660535951362',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-24 03:22:39',NULL,NULL),('1231772559046967297',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-24 10:47:18',NULL,NULL),('1231772634972258306',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-24 10:47:36',NULL,NULL),('1231872139147202561',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,NULL,NULL,294,'admin','2020-02-24 17:23:00',NULL,NULL),('1231872145841311746',2,'编码校验规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysCheckRuleController.queryPageList()',NULL,NULL,NULL,98,'admin','2020-02-24 17:23:01',NULL,NULL),('1231872154540298242',2,'多数据源管理-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDataSourceController.queryPageList()',NULL,NULL,NULL,334,'admin','2020-02-24 17:23:03',NULL,NULL),('1231888100260655106',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-24 18:26:24',NULL,NULL),('1232120592192311297',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-25 09:50:15',NULL,NULL),('1232121930921873409',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-25 09:55:35',NULL,NULL),('1232123986592206850',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,NULL,NULL,48,'admin','2020-02-25 10:03:45',NULL,NULL),('1232124039033589761',2,'编辑用户，id： a75d45a015c44384a04449ee80dc3503',2,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2020-02-25 10:03:57',NULL,NULL),('1232124050710532098',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-25 10:04:00',NULL,NULL),('1232124114992435202',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-25 10:04:15',NULL,NULL),('1232124523609919489',1,'用户名: jeecg,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-25 10:05:53',NULL,NULL),('1232124588416110593',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-25 10:06:08',NULL,NULL),('1232125009155133442',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-25 10:07:49',NULL,NULL),('1232125087760584706',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-25 10:08:07',NULL,NULL),('1232125284058206209',1,'用户名: jeecg,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-25 10:08:54',NULL,NULL),('1232125346289094658',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-25 10:09:09',NULL,NULL),('1232125555614224385',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-25 10:09:59',NULL,NULL),('1232125615475331073',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-25 10:10:13',NULL,NULL),('1232125831045779457',1,'用户名: jeecg,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-25 10:11:05',NULL,NULL),('1232230001392308226',1,'用户名: jeecg测试,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-25 17:05:00',NULL,NULL),('1232230077393096705',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-25 17:05:19',NULL,NULL),('1232231182843883522',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-25 17:09:42',NULL,NULL),('1232231223797067777',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-02-25 17:09:52',NULL,NULL),('1235143593301209090',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-03-04 18:02:34',NULL,NULL),('1235170990046130178',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-03-04 19:51:26',NULL,NULL),('1235202803376402433',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-03-04 21:57:52',NULL,NULL),('1235202873094123522',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-03-04 21:58:09',NULL,NULL),('1256482167137071106',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 15:14:27',NULL,NULL),('1256483667833794561',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 15:20:25',NULL,NULL),('1256484419314659330',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@38dd4fee',NULL,55,'admin','2020-05-02 15:23:25',NULL,NULL),('1256484434414153729',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 99999  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@1edaf52d',NULL,25,'admin','2020-05-02 15:23:28',NULL,NULL),('1256485080102170625',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@20123ff4',NULL,53,'admin','2020-05-02 15:26:01',NULL,NULL),('1256485085294718978',2,'编辑用户，id： e9ca23d68d884d4ebb19d07889727dae',2,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2020-05-02 15:26:03',NULL,NULL),('1256485469157421057',2,'编辑用户，id： e9ca23d68d884d4ebb19d07889727dae',2,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2020-05-02 15:27:35',NULL,NULL),('1256485494486822914',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@3773cfae',NULL,25,'admin','2020-05-02 15:27:41',NULL,NULL),('1256485574329593858',2,'职务表-添加',2,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.add()',NULL,'[{\"code\":\"总经理\",\"createBy\":\"admin\",\"createTime\":1588404479920,\"id\":\"1256485574212153345\",\"name\":\"laozong\",\"postRank\":\"5\",\"sysOrgCode\":\"北京国炬公司\"}]',NULL,12,'admin','2020-05-02 15:28:00',NULL,NULL),('1256485574790967298',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@4df33d14',NULL,59,'admin','2020-05-02 15:28:00',NULL,NULL),('1256485587097055234',2,'职务表-编辑',3,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.edit()',NULL,'[{\"code\":\"总经理\",\"createBy\":\"admin\",\"createTime\":1588404480000,\"id\":\"1256485574212153345\",\"name\":\"laozong\",\"postRank\":\"5\",\"sysOrgCode\":\"北京国炬公司\",\"updateBy\":\"admin\",\"updateTime\":1588404482983}]',NULL,17,'admin','2020-05-02 15:28:03',NULL,NULL),('1256485587436793858',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@34437d6a',NULL,20,'admin','2020-05-02 15:28:03',NULL,NULL),('1256485616851447809',2,'职务表-添加',2,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.add()',NULL,'[{\"code\":\"1\",\"createBy\":\"admin\",\"createTime\":1588404490080,\"id\":\"1256485616817893378\",\"name\":\"1\",\"postRank\":\"1\",\"sysOrgCode\":\"北京国炬公司\"}]',NULL,8,'admin','2020-05-02 15:28:10',NULL,NULL),('1256485617317015554',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@65ab758f',NULL,34,'admin','2020-05-02 15:28:10',NULL,NULL),('1256485628339646465',2,'职务表-通过id删除',4,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.delete()',NULL,'  id: 1256485616817893378',NULL,8,'admin','2020-05-02 15:28:13',NULL,NULL),('1256485628721328129',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@63ed8b8',NULL,19,'admin','2020-05-02 15:28:13',NULL,NULL),('1256485878894784514',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@5eee71e7',NULL,25,'admin','2020-05-02 15:29:13',NULL,NULL),('1256485915808854017',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@55d170fd',NULL,21,'admin','2020-05-02 15:29:21',NULL,NULL),('1256487060673490946',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 99999  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@70eaa8bc',NULL,20,'admin','2020-05-02 15:33:54',NULL,NULL),('1256487125404184577',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@3bc7b343',NULL,14,'admin','2020-05-02 15:34:10',NULL,NULL),('1256487161898823682',2,'编辑用户，id： a75d45a015c44384a04449ee80dc3503',2,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2020-05-02 15:34:18',NULL,NULL),('1256487210473058305',2,'编辑用户，id： a75d45a015c44384a04449ee80dc3503',2,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2020-05-02 15:34:30',NULL,NULL),('1256487242727256066',2,'删除用户，id： 42d153bffeea74f72a9c1697874fa4a7',3,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2020-05-02 15:34:38',NULL,NULL),('1256487299895619585',2,'编辑用户，id： f0019fdebedb443c98dcb17d88222c38',2,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2020-05-02 15:34:51',NULL,NULL),('1256488477320638466',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@7a60531e',NULL,25,'admin','2020-05-02 15:39:32',NULL,NULL),('1256488490658525186',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@2d83211b',NULL,17,'admin','2020-05-02 15:39:35',NULL,NULL),('1256489011385561089',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@4c2899e6',NULL,13,'admin','2020-05-02 15:41:39',NULL,NULL),('1256489680158945281',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@e1ab519',NULL,24,'admin','2020-05-02 15:44:19',NULL,NULL),('1256489882299232258',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@4694c325',NULL,13,'admin','2020-05-02 15:45:07',NULL,NULL),('1256490012620451841',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@612705a8',NULL,16,'admin','2020-05-02 15:45:38',NULL,NULL),('1256490056123772929',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@57f572e8',NULL,14,'admin','2020-05-02 15:45:48',NULL,NULL),('1256490157718204417',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@534d6ebf',NULL,16,'admin','2020-05-02 15:46:13',NULL,NULL),('1256490172926750722',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@351222f2',NULL,19,'admin','2020-05-02 15:46:16',NULL,NULL),('1256490193340428289',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@52a9a2e6',NULL,20,'admin','2020-05-02 15:46:21',NULL,NULL),('1256490829935112194',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@6d54e7ee',NULL,12,'admin','2020-05-02 15:48:53',NULL,NULL),('1256490944309587970',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@62629cc6',NULL,16,'admin','2020-05-02 15:49:20',NULL,NULL),('1256490967088852994',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@8c9d2b1',NULL,11,'admin','2020-05-02 15:49:26',NULL,NULL),('1256491122944995330',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@3732988a',NULL,15,'admin','2020-05-02 15:50:03',NULL,NULL),('1256491834928099329',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@431d17a8',NULL,13,'admin','2020-05-02 15:52:53',NULL,NULL),('1256491996039704578',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@5f5721f1',NULL,12,'admin','2020-05-02 15:53:31',NULL,NULL),('1256492339301543938',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@2dd65164',NULL,22,'admin','2020-05-02 15:54:53',NULL,NULL),('1256492360629579778',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@739b8264',NULL,25,'admin','2020-05-02 15:54:58',NULL,NULL),('1256492389415088130',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@16b523ad',NULL,18,'admin','2020-05-02 15:55:05',NULL,NULL),('1256493213293834242',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@4467f24e',NULL,15,'admin','2020-05-02 15:58:21',NULL,NULL),('1256493329329254401',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@e0ddd58',NULL,18,'admin','2020-05-02 15:58:49',NULL,NULL),('1256493354331500545',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@441b74f0',NULL,15,'admin','2020-05-02 15:58:55',NULL,NULL),('1256493373541412866',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@57c50dd7',NULL,12,'admin','2020-05-02 15:58:59',NULL,NULL),('1256527132428972033',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@7e667652',NULL,541,'admin','2020-05-02 18:13:08',NULL,NULL),('1256527391850868737',2,'编辑DEMO',3,'admin','管理员','127.0.0.1','org.jeecg.modules.demo.test.controller.JeecgDemoController.edit()',NULL,'[{\"createBy\":\"jeecg-boot\",\"createTime\":1553768199000,\"id\":\"73bc58611012617ca446d8999379e4ac\",\"keyWord\":\"777\",\"name\":\"郭靖\",\"punchTime\":1544112000000,\"updateBy\":\"admin\",\"updateTime\":1588414449977}]',NULL,11,'admin','2020-05-02 18:14:10',NULL,NULL),('1256527408170905601',2,'编辑DEMO',3,'admin','管理员','127.0.0.1','org.jeecg.modules.demo.test.controller.JeecgDemoController.edit()',NULL,'[{\"createBy\":\"jeecg-boot\",\"createTime\":1553768199000,\"id\":\"73bc58611012617ca446d8999379e4ac\",\"keyWord\":\"777\",\"name\":\"郭靖\",\"punchTime\":1544112000000,\"sex\":\"1\",\"updateBy\":\"admin\",\"updateTime\":1588414453907}]',NULL,7,'admin','2020-05-02 18:14:14',NULL,NULL),('1256527447572197378',2,'删除测试DEMO',4,'admin','管理员','127.0.0.1','org.jeecg.modules.demo.test.controller.JeecgDemoController.delete()',NULL,'  id: c0b7c3de7c62a295ab715943de8a315d',NULL,7,'admin','2020-05-02 18:14:23',NULL,NULL),('1256527487334199297',2,'编辑DEMO',3,'admin','管理员','127.0.0.1','org.jeecg.modules.demo.test.controller.JeecgDemoController.edit()',NULL,'[{\"createBy\":\"scott\",\"createTime\":1547873698000,\"id\":\"94420c5d8fc4420dde1e7196154b3a24\",\"name\":\"秦风\",\"sex\":\"2\",\"updateBy\":\"admin\",\"updateTime\":1588414472782}]',NULL,6,'admin','2020-05-02 18:14:33',NULL,NULL),('1256528708895879170',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 99999  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@3ec5357c',NULL,24,'admin','2020-05-02 18:19:24',NULL,NULL),('1256528740931973122',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@20a782a2',NULL,16,'admin','2020-05-02 18:19:32',NULL,NULL),('1256528778097700866',2,'编辑用户，id： e9ca23d68d884d4ebb19d07889727dae',2,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2020-05-02 18:19:41',NULL,NULL),('1256529143853592577',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 99999  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@53b67601',NULL,15,'admin','2020-05-02 18:21:08',NULL,NULL),('1256529179186409473',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 99999  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@4034ff3d',NULL,14,'admin','2020-05-02 18:21:16',NULL,NULL),('1256529242847555585',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@300c18c2',NULL,15,'admin','2020-05-02 18:21:31',NULL,NULL),('1256529251169054721',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 99999  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@5cbc1ed0',NULL,14,'admin','2020-05-02 18:21:33',NULL,NULL),('1256538346588590082',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 18:57:41',NULL,NULL),('1256538366448619522',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 18:57:47',NULL,NULL),('1256538504642547713',2,'多数据源管理-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDataSourceController.queryPageList()',NULL,'  sysDataSource: SysDataSource(id=null, code=null, name=null, remark=null, dbType=null, dbDriver=null, dbUrl=null, dbName=null, dbUsername=null, dbPassword=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@6e768567',NULL,73,'admin','2020-05-02 18:58:20',NULL,NULL),('1256538902770077698',2,'多数据源管理-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDataSourceController.queryPageList()',NULL,'  sysDataSource: SysDataSource(id=null, code=null, name=null, remark=null, dbType=null, dbDriver=null, dbUrl=null, dbName=null, dbUsername=null, dbPassword=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@74d2b870',NULL,17,'admin','2020-05-02 18:59:54',NULL,NULL),('1256548329908609025',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@5e32c585',NULL,181,'admin','2020-05-02 19:37:21',NULL,NULL),('1256548333775757314',2,'编码校验规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysCheckRuleController.queryPageList()',NULL,'  sysCheckRule: SysCheckRule(id=null, ruleName=null, ruleCode=null, ruleJson=null, ruleDescription=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  request: org.apache.shiro.web.servlet.ShiroHttpServletRequest@4f008a7d',NULL,41,'admin','2020-05-02 19:37:23',NULL,NULL),('1256548338318188545',2,'多数据源管理-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDataSourceController.queryPageList()',NULL,'  sysDataSource: SysDataSource(id=null, code=null, name=null, remark=null, dbType=null, dbDriver=null, dbUrl=null, dbName=null, dbUsername=null, dbPassword=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@7827b492',NULL,31,'admin','2020-05-02 19:37:24',NULL,NULL),('1256548342671876097',2,'编码校验规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysCheckRuleController.queryPageList()',NULL,'  sysCheckRule: SysCheckRule(id=null, ruleName=null, ruleCode=null, ruleJson=null, ruleDescription=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  request: org.apache.shiro.web.servlet.ShiroHttpServletRequest@25cfa316',NULL,27,'admin','2020-05-02 19:37:25',NULL,NULL),('1256548345805021186',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@39541cd2',NULL,26,'admin','2020-05-02 19:37:26',NULL,NULL),('1256548524465594370',2,'多数据源管理-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDataSourceController.queryPageList()',NULL,'  sysDataSource: SysDataSource(id=null, code=null, name=null, remark=null, dbType=null, dbDriver=null, dbUrl=null, dbName=null, dbUsername=null, dbPassword=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@51a7dbe',NULL,15,'admin','2020-05-02 19:38:08',NULL,NULL),('1256550098638217218',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 19:44:24',NULL,NULL),('1256572017869594626',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 21:11:30',NULL,NULL),('1256572334438883329',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 21:12:45',NULL,NULL),('1256572347516723201',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 21:12:48',NULL,NULL),('1256572526244405249',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 21:13:31',NULL,NULL),('1256599302815461378',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 22:59:54',NULL,NULL),('1256600609391489025',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 23:05:06',NULL,NULL),('1256600722662862849',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 23:05:33',NULL,NULL),('1256600723023572993',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 23:05:34',NULL,NULL),('1256601173458268161',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 23:07:21',NULL,NULL),('1256601320892248066',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@6703cc80',NULL,44,'admin','2020-05-02 23:07:56',NULL,NULL),('1256604650926354434',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 23:21:10',NULL,NULL),('1256604684468203522',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 23:21:18',NULL,NULL),('1256604684845690882',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 23:21:18',NULL,NULL),('1256604994200776706',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 23:22:32',NULL,NULL),('1256604994595041282',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 23:22:32',NULL,NULL),('1256605284085903361',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 23:23:41',NULL,NULL),('1256609868795719682',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 23:41:54',NULL,NULL),('1256610665751228417',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 23:45:04',NULL,NULL),('1256611419610263553',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 23:48:04',NULL,NULL),('1256611628176224257',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 23:48:54',NULL,NULL),('1256611628545323010',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 23:48:54',NULL,NULL),('1256611717628145666',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-02 23:49:15',NULL,NULL),('1256627765207216130',2,'Online报表，sql解析：select DATE_FORMAT(create_time,  \'%Y-%m-%d\') as date,count(*) as num from sys_log group by DATE_FORMAT(create_time, \'%Y-%m-%d\')',2,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2020-05-03 00:53:01',NULL,NULL),('1256628324886753282',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@51bbe048',NULL,17,'admin','2020-05-03 00:55:14',NULL,NULL),('1256628328594518018',2,'编码校验规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysCheckRuleController.queryPageList()',NULL,'  sysCheckRule: SysCheckRule(id=null, ruleName=null, ruleCode=null, ruleJson=null, ruleDescription=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  request: org.apache.shiro.web.servlet.ShiroHttpServletRequest@13b6b967',NULL,59,'admin','2020-05-03 00:55:15',NULL,NULL),('1256628331551502337',2,'多数据源管理-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDataSourceController.queryPageList()',NULL,'  sysDataSource: SysDataSource(id=null, code=null, name=null, remark=null, dbType=null, dbDriver=null, dbUrl=null, dbName=null, dbUsername=null, dbPassword=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@478b2fb3',NULL,12,'admin','2020-05-03 00:55:16',NULL,NULL),('1256630123769212929',2,'多数据源管理-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDataSourceController.queryPageList()',NULL,'  sysDataSource: SysDataSource(id=null, code=null, name=null, remark=null, dbType=null, dbDriver=null, dbUrl=null, dbName=null, dbUsername=null, dbPassword=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@7fc037db',NULL,25,'admin','2020-05-03 01:02:23',NULL,NULL),('1256630125769895938',2,'编码校验规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysCheckRuleController.queryPageList()',NULL,'  sysCheckRule: SysCheckRule(id=null, ruleName=null, ruleCode=null, ruleJson=null, ruleDescription=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  request: org.apache.shiro.web.servlet.ShiroHttpServletRequest@67b1d09a',NULL,10,'admin','2020-05-03 01:02:24',NULL,NULL),('1256630127565058049',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@7e3105cb',NULL,11,'admin','2020-05-03 01:02:24',NULL,NULL),('1256630191603691522',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@406d0b25',NULL,12,'admin','2020-05-03 01:02:39',NULL,NULL),('1256630197496688641',2,'编码校验规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysCheckRuleController.queryPageList()',NULL,'  sysCheckRule: SysCheckRule(id=null, ruleName=null, ruleCode=null, ruleJson=null, ruleDescription=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  request: org.apache.shiro.web.servlet.ShiroHttpServletRequest@5d746f1c',NULL,9,'admin','2020-05-03 01:02:41',NULL,NULL),('1256630200965378050',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@771a0535',NULL,9,'admin','2020-05-03 01:02:42',NULL,NULL),('1256631022684057602',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@552e978f',NULL,177,'admin','2020-05-03 01:05:58',NULL,NULL),('1256631095019024385',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@7b8d5eda',NULL,25,'admin','2020-05-03 01:06:15',NULL,NULL),('1256631629037809666',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@719fa12f',NULL,14,'admin','2020-05-03 01:08:22',NULL,NULL),('1256631703578980354',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@22c83dfe',NULL,17,'admin','2020-05-03 01:08:40',NULL,NULL),('1256631875029544961',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@73bbad53',NULL,18,'admin','2020-05-03 01:09:21',NULL,NULL),('1256632739672731649',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@36f7e6ea',NULL,15,'admin','2020-05-03 01:12:47',NULL,NULL),('1256632995709825025',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@668f45b1',NULL,63,'admin','2020-05-03 01:13:48',NULL,NULL),('1256633330130071553',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@735e4fde',NULL,24,'admin','2020-05-03 01:15:08',NULL,NULL),('1256633509134577666',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@6c495862',NULL,17,'admin','2020-05-03 01:15:50',NULL,NULL),('1256633551425744897',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@6908d196',NULL,13,'admin','2020-05-03 01:16:00',NULL,NULL),('1256633599651852289',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@5bfb2ada',NULL,14,'admin','2020-05-03 01:16:12',NULL,NULL),('1256633656652443650',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@549ef5f1',NULL,15,'admin','2020-05-03 01:16:26',NULL,NULL),('1256636582515027970',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@4264deb1',NULL,10,'admin','2020-05-03 01:28:03',NULL,NULL),('1256644151597969409',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@2218706b',NULL,9,'admin','2020-05-03 01:58:08',NULL,NULL),('1256644154894692354',2,'编码校验规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysCheckRuleController.queryPageList()',NULL,'  sysCheckRule: SysCheckRule(id=null, ruleName=null, ruleCode=null, ruleJson=null, ruleDescription=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  request: org.apache.shiro.web.servlet.ShiroHttpServletRequest@5b4819a1',NULL,15,'admin','2020-05-03 01:58:09',NULL,NULL),('1256644156803100673',2,'多数据源管理-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDataSourceController.queryPageList()',NULL,'  sysDataSource: SysDataSource(id=null, code=null, name=null, remark=null, dbType=null, dbDriver=null, dbUrl=null, dbName=null, dbUsername=null, dbPassword=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@115ba167',NULL,9,'admin','2020-05-03 01:58:09',NULL,NULL),('1256650558405681153',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-03 02:23:35',NULL,NULL),('1256650629201338370',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-03 02:23:52',NULL,NULL),('1256850951899271170',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-03 15:39:52',NULL,NULL),('1256851006488137730',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-03 15:40:06',NULL,NULL),('1256851131646169089',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@7ddaff5a',NULL,31,'admin','2020-05-03 15:40:36',NULL,NULL),('1256851193189191682',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@3a38dd17',NULL,62,'admin','2020-05-03 15:40:50',NULL,NULL),('1256851237241966594',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@1db9a865',NULL,26,'admin','2020-05-03 15:41:01',NULL,NULL),('1256954649484783618',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-03 22:31:55',NULL,NULL),('1256954712244154370',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@7167fb28',NULL,139,'admin','2020-05-03 22:32:11',NULL,NULL),('1256954715616374785',2,'编码校验规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysCheckRuleController.queryPageList()',NULL,'  sysCheckRule: SysCheckRule(id=null, ruleName=null, ruleCode=null, ruleJson=null, ruleDescription=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  request: org.apache.shiro.web.servlet.ShiroHttpServletRequest@30987eb8',NULL,44,'admin','2020-05-03 22:32:12',NULL,NULL),('1256963818271121409',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-03 23:08:21',NULL,NULL),('1256963898537517057',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-03 23:08:41',NULL,NULL),('1256963981236609026',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-03 23:09:01',NULL,NULL),('1257318577708576770',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-04 22:38:03',NULL,NULL),('1257318617923563522',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-04 22:38:13',NULL,NULL),('1257318643861139458',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@5880023d',NULL,158,'admin','2020-05-04 22:38:19',NULL,NULL),('1257318651620601857',2,'编码校验规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysCheckRuleController.queryPageList()',NULL,'  sysCheckRule: SysCheckRule(id=null, ruleName=null, ruleCode=null, ruleJson=null, ruleDescription=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  request: org.apache.shiro.web.servlet.ShiroHttpServletRequest@2944d5ae',NULL,45,'admin','2020-05-04 22:38:21',NULL,NULL),('1257318654309150721',2,'多数据源管理-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDataSourceController.queryPageList()',NULL,'  sysDataSource: SysDataSource(id=null, code=null, name=null, remark=null, dbType=null, dbDriver=null, dbUrl=null, dbName=null, dbUsername=null, dbPassword=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@44651e7c',NULL,60,'admin','2020-05-04 22:38:22',NULL,NULL),('1257318671023452161',2,'多数据源管理-编辑',3,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDataSourceController.edit()',NULL,'[{\"createBy\":\"admin\",\"createTime\":1577268893000,\"dbDriver\":\"com.mysql.jdbc.Driver\",\"dbName\":\"jeecg-boot\",\"dbPassword\":\"root\",\"dbType\":\"1\",\"dbUrl\":\"jdbc:mysql://127.0.0.1:3306/jeecg-boot?characterEncoding=UTF-8&useUnicode=true&useSSL=false\",\"dbUsername\":\"root\",\"id\":\"1209779538310004737\",\"name\":\"MySQL5.7\",\"remark\":\"本地数据库MySQL5.7\",\"sysOrgCode\":\"A01\",\"updateBy\":\"admin\",\"updateTime\":1588603105614}]',NULL,34,'admin','2020-05-04 22:38:26',NULL,NULL),('1257318671723900930',2,'多数据源管理-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDataSourceController.queryPageList()',NULL,'  sysDataSource: SysDataSource(id=null, code=null, name=null, remark=null, dbType=null, dbDriver=null, dbUrl=null, dbName=null, dbUsername=null, dbPassword=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@915482d',NULL,16,'admin','2020-05-04 22:38:26',NULL,NULL),('1257875756186411010',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-06 11:32:04',NULL,NULL),('1257875844212269057',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-06 11:32:26',NULL,NULL),('1257938142477946882',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-06 15:39:58',NULL,NULL),('1257938291824529410',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-06 15:40:35',NULL,NULL),('1258208763409596417',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-07 09:35:20',NULL,NULL),('1258212272427237377',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-07 09:49:17',NULL,NULL),('1258212331801804802',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@43287270',NULL,50,'admin','2020-05-07 09:49:31',NULL,NULL),('1258214389946843137',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@30a633b3',NULL,307,'admin','2020-05-07 09:57:41',NULL,NULL),('1258214526047813634',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@718b221e',NULL,23,'admin','2020-05-07 09:58:14',NULL,NULL),('1258404623636557825',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-07 22:33:36',NULL,NULL),('1258407358662504450',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-07 22:44:29',NULL,NULL),('1260128353211510785',2,'填值规则-分页列表查询',1,'admin','管理员5555','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@599b461e',NULL,249,'admin','2020-05-12 16:43:04',NULL,NULL),('1260133438385680385',2,'填值规则-分页列表查询',1,'admin','管理员5555','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@18824c76',NULL,25,'admin','2020-05-12 17:03:19',NULL,NULL),('1260134029069512706',2,'填值规则-分页列表查询',1,'admin','管理员5555','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@1c05f633',NULL,15,'admin','2020-05-12 17:05:39',NULL,NULL),('1260134137966227458',2,'填值规则-添加',2,'admin','管理员5555','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.add()',NULL,'[{\"createBy\":\"admin\",\"createTime\":1589274365295,\"id\":\"1260134137920090113\",\"ruleClass\":\"111\",\"ruleCode\":\"shop_order_num\",\"ruleName\":\"商城订单流水号\",\"ruleParams\":\"{}\"}]',NULL,13,'admin','2020-05-12 17:06:05',NULL,NULL),('1260134138352103426',2,'填值规则-分页列表查询',1,'admin','管理员5555','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@2b0e5b57',NULL,17,'admin','2020-05-12 17:06:05',NULL,NULL),('1260134973303812097',2,'填值规则-编辑',3,'admin','管理员5555','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.edit()',NULL,'[{\"createBy\":\"admin\",\"createTime\":1589274365000,\"id\":\"1260134137920090113\",\"ruleClass\":\"org.jeecg.modules.system.rule.ShopOrderNumberRule\",\"ruleCode\":\"shop_order_num\",\"ruleName\":\"商城订单流水号\",\"ruleParams\":\"{}\",\"updateBy\":\"admin\",\"updateTime\":1589274564451}]',NULL,14,'admin','2020-05-12 17:09:24',NULL,NULL),('1260134974104924162',2,'填值规则-分页列表查询',1,'admin','管理员5555','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@5a6e3f1e',NULL,26,'admin','2020-05-12 17:09:25',NULL,NULL),('1260176104158744577',1,'用户名: 管理员5555,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-12 19:52:49',NULL,NULL),('1260176137037893633',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-12 19:52:59',NULL,NULL),('1260179881074970625',2,'Online报表，sql解析：select * from sys_user',2,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2020-05-12 20:07:51',NULL,NULL),('1260182306150240257',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=总经理,, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 1  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@323563d5',NULL,84,'admin','2020-05-12 20:17:29',NULL,NULL),('1260182306187988994',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@203796',NULL,93,'admin','2020-05-12 20:17:30',NULL,NULL),('1260204301495652353',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-12 21:44:54',NULL,NULL),('1260208581728382977',2,'OA请假单-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.bpmbiz.controller.TestNoteController.queryPageList()',NULL,'  testNote: TestNote(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, name=null, age=null, sex=null, birthday=null, contents=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@3932c070',NULL,43,'admin','2020-05-12 22:01:54',NULL,NULL),('1260208600535642114',2,'OA请假单-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.bpmbiz.controller.TestNoteController.queryPageList()',NULL,'  testNote: TestNote(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, name=null, age=null, sex=null, birthday=null, contents=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@497c4e7',NULL,31,'admin','2020-05-12 22:01:59',NULL,NULL),('1260208702692110337',2,'OA请假单-添加',2,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.bpmbiz.controller.TestNoteController.add()',NULL,'[{\"age\":222,\"birthday\":1589212800000,\"contents\":\"sss\",\"createBy\":\"admin\",\"createTime\":1589292142877,\"id\":\"1260208702503366657\",\"name\":\"jeecg\",\"sex\":\"1\",\"sysOrgCode\":\"A01\"}]',NULL,8,'admin','2020-05-12 22:02:23',NULL,NULL),('1260208703333838849',2,'OA请假单-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.bpmbiz.controller.TestNoteController.queryPageList()',NULL,'  testNote: TestNote(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, name=null, age=null, sex=null, birthday=null, contents=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@527b2951',NULL,30,'admin','2020-05-12 22:02:23',NULL,NULL),('1260208730487762946',2,'OA请假单-编辑',3,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.bpmbiz.controller.TestNoteController.edit()',NULL,'[{\"age\":22233,\"birthday\":1589212800000,\"contents\":\"sss\",\"createBy\":\"admin\",\"createTime\":1589292143000,\"id\":\"1260208702503366657\",\"name\":\"jeecg\",\"sex\":\"2\",\"sysOrgCode\":\"A01\",\"updateBy\":\"admin\",\"updateTime\":1589292149543}]',NULL,9,'admin','2020-05-12 22:02:30',NULL,NULL),('1260208731171434498',2,'OA请假单-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.bpmbiz.controller.TestNoteController.queryPageList()',NULL,'  testNote: TestNote(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, name=null, age=null, sex=null, birthday=null, contents=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@4493c410',NULL,26,'admin','2020-05-12 22:02:30',NULL,NULL),('1260209236593455105',2,'OA请假单-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.bpmbiz.controller.TestNoteController.queryPageList()',NULL,'  testNote: TestNote(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, name=null, age=null, sex=null, birthday=null, contents=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@59f11e3c',NULL,30,'admin','2020-05-12 22:04:30',NULL,NULL),('1260213921761009665',2,'商品分类-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.tree.controller.TreeCesShopTypeController.queryPageList()',NULL,'  treeCesShopType: TreeCesShopType(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, name=null, content=null, pics=null, pid=null, hasChild=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@2af56c61',NULL,389,'admin','2020-05-12 22:23:06',NULL,NULL),('1260214009073836033',2,'Erp商城订单表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.ErpCesOrderMainController.queryPageList()',NULL,'  erpCesOrderMain: ErpCesOrderMain(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, orderCode=null, xdDate=null, money=null, remark=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@f0ec00b',NULL,71,'admin','2020-05-12 22:23:28',NULL,NULL),('1260214016074129410',2,'Erp订单商品-通过主表ID查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.ErpCesOrderMainController.listErpCesOrderGoodsByMainId()',NULL,'  erpCesOrderGoods: ErpCesOrderGoods(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, goodName=null, price=null, num=null, zongPrice=null, orderMainId=1260135645520654338)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@17b89f30',NULL,43,'admin','2020-05-12 22:23:30',NULL,NULL),('1260214016208347138',2,'Erp订单客户-通过主表ID查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.ErpCesOrderMainController.listErpCesOrderCustomerByMainId()',NULL,'  erpCesOrderCustomer: ErpCesOrderCustomer(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, name=null, sex=null, birthday=null, age=null, address=null, orderMainId=1260135645520654338)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@2cae5b0f',NULL,75,'admin','2020-05-12 22:23:30',NULL,NULL),('1260214028015312897',2,'Erp订单商品-通过主表ID查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.ErpCesOrderMainController.listErpCesOrderGoodsByMainId()',NULL,'  erpCesOrderGoods: ErpCesOrderGoods(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, goodName=null, price=null, num=null, zongPrice=null, orderMainId=1260133243631562754)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@1c3f5fb3',NULL,59,'admin','2020-05-12 22:23:33',NULL,NULL),('1260214028183085058',2,'Erp订单客户-通过主表ID查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.ErpCesOrderMainController.listErpCesOrderCustomerByMainId()',NULL,'  erpCesOrderCustomer: ErpCesOrderCustomer(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, name=null, sex=null, birthday=null, age=null, address=null, orderMainId=1260133243631562754)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@d08718d',NULL,71,'admin','2020-05-12 22:23:33',NULL,NULL),('1260214054716252161',2,'Nei商城订单表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.NeiCesOrderMainController.queryPageList()',NULL,'  neiCesOrderMain: NeiCesOrderMain(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, orderCode=null, xdDate=null, money=null, remark=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@53cb7593',NULL,36,'admin','2020-05-12 22:23:39',NULL,NULL),('1260214059946549249',2,'Nei订单商品-通过主表ID查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.NeiCesOrderMainController.queryNeiCesOrderGoodsListByMainId()',NULL,'  id: 1260133243631562754',NULL,24,'admin','2020-05-12 22:23:40',NULL,NULL),('1260214059971715074',2,'Nei订单客户-通过主表ID查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.NeiCesOrderMainController.queryNeiCesOrderCustomerListByMainId()',NULL,'  id: 1260133243631562754',NULL,33,'admin','2020-05-12 22:23:40',NULL,NULL),('1260214061351641089',2,'Nei订单商品-通过主表ID查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.NeiCesOrderMainController.queryNeiCesOrderGoodsListByMainId()',NULL,'  id: 1260135645520654338',NULL,8,'admin','2020-05-12 22:23:41',NULL,NULL),('1260214061460692994',2,'Nei订单客户-通过主表ID查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.NeiCesOrderMainController.queryNeiCesOrderCustomerListByMainId()',NULL,'  id: 1260135645520654338',NULL,31,'admin','2020-05-12 22:23:41',NULL,NULL),('1260214073515122690',2,'Nei订单商品-通过主表ID查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.NeiCesOrderMainController.queryNeiCesOrderGoodsListByMainId()',NULL,'  id: 1260135645520654338',NULL,8,'admin','2020-05-12 22:23:43',NULL,NULL),('1260214073603203073',2,'Nei订单客户-通过主表ID查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.NeiCesOrderMainController.queryNeiCesOrderCustomerListByMainId()',NULL,'  id: 1260135645520654338',NULL,29,'admin','2020-05-12 22:23:43',NULL,NULL),('1260214096332136450',2,'Nei订单商品-通过主表ID查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.NeiCesOrderMainController.queryNeiCesOrderGoodsListByMainId()',NULL,'  id: 1260135645520654338',NULL,5,'admin','2020-05-12 22:23:49',NULL,NULL),('1260214096407633921',2,'Nei订单客户-通过主表ID查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.NeiCesOrderMainController.queryNeiCesOrderCustomerListByMainId()',NULL,'  id: 1260135645520654338',NULL,22,'admin','2020-05-12 22:23:49',NULL,NULL),('1260214101705039874',2,'Nei商城订单表-编辑',3,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.NeiCesOrderMainController.edit()',NULL,'[{\"createBy\":\"admin\",\"createTime\":1589274724000,\"id\":\"1260135645520654338\",\"neiCesOrderCustomerList\":[{\"address\":\"\",\"birthday\":1549641600000,\"createBy\":\"admin\",\"createTime\":1589293430012,\"id\":\"15892747207990547016\",\"name\":\"23232\",\"orderMainId\":\"1260135645520654338\",\"sex\":\"1\",\"sysOrgCode\":\"A01\"},{\"address\":\"\",\"birthday\":1543939200000,\"createBy\":\"admin\",\"createTime\":1589293430032,\"id\":\"15892859831531205492\",\"name\":\"管理员\",\"orderMainId\":\"1260135645520654338\",\"sysOrgCode\":\"A01\"},{\"address\":\"\",\"birthday\":1589212800000,\"createBy\":\"admin\",\"createTime\":1589293430039,\"id\":\"15892859955132352429\",\"name\":\"张小红\",\"orderMainId\":\"1260135645520654338\",\"sex\":\"1\",\"sysOrgCode\":\"A01\"},{\"address\":\"\",\"birthday\":1549641600000,\"createBy\":\"admin\",\"createTime\":1589293430044,\"id\":\"15892860112563612499\",\"name\":\"23232\",\"orderMainId\":\"1260135645520654338\",\"sysOrgCode\":\"A01\"}],\"neiCesOrderGoodsList\":[{\"createBy\":\"admin\",\"createTime\":1589293429992,\"goodName\":\"11\",\"id\":\"15892747180850346324\",\"orderMainId\":\"1260135645520654338\",\"price\":11.0,\"sysOrgCode\":\"A01\"}],\"orderCode\":\"JDFX2020051217115656\",\"sysOrgCode\":\"A01\",\"updateBy\":\"admin\",\"updateTime\":1589286019000}]',NULL,134,'admin','2020-05-12 22:23:50',NULL,NULL),('1260214102422265857',2,'Nei商城订单表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.NeiCesOrderMainController.queryPageList()',NULL,'  neiCesOrderMain: NeiCesOrderMain(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, orderCode=null, xdDate=null, money=null, remark=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@449ed1df',NULL,13,'admin','2020-05-12 22:23:50',NULL,NULL),('1260214103319846914',2,'Nei订单商品-通过主表ID查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.NeiCesOrderMainController.queryNeiCesOrderGoodsListByMainId()',NULL,'  id: 1260133243631562754',NULL,9,'admin','2020-05-12 22:23:51',NULL,NULL),('1260214103345012737',2,'Nei订单商品-通过主表ID查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.NeiCesOrderMainController.queryNeiCesOrderGoodsListByMainId()',NULL,'  id: 1260135645520654338',NULL,17,'admin','2020-05-12 22:23:51',NULL,NULL),('1260214103361789953',2,'Nei订单客户-通过主表ID查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.NeiCesOrderMainController.queryNeiCesOrderCustomerListByMainId()',NULL,'  id: 1260133243631562754',NULL,21,'admin','2020-05-12 22:23:51',NULL,NULL),('1260214103395344385',2,'Nei订单客户-通过主表ID查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.NeiCesOrderMainController.queryNeiCesOrderCustomerListByMainId()',NULL,'  id: 1260135645520654338',NULL,28,'admin','2020-05-12 22:23:51',NULL,NULL),('1260214167018741761',2,'Nei商城订单表-添加',2,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.NeiCesOrderMainController.add()',NULL,'[{\"money\":11.0,\"neiCesOrderCustomerList\":[{\"address\":\"\",\"createBy\":\"admin\",\"createTime\":1589293445703,\"id\":\"15892934319910270427\",\"name\":\"jeecg\",\"orderMainId\":\"1260214166825803778\",\"sysOrgCode\":\"A01\"},{\"address\":\"\",\"birthday\":1543939200000,\"createBy\":\"admin\",\"createTime\":1589293445710,\"id\":\"15892934399261429301\",\"name\":\"管理员\",\"orderMainId\":\"1260214166825803778\",\"sysOrgCode\":\"A01\"}],\"neiCesOrderGoodsList\":[{\"createBy\":\"admin\",\"createTime\":1589293445684,\"goodName\":\"11\",\"id\":\"15892934319760656799\",\"orderMainId\":\"1260214166825803778\",\"sysOrgCode\":\"A01\"},{\"createBy\":\"admin\",\"createTime\":1589293445694,\"goodName\":\"11\",\"id\":\"15892934330741505462\",\"orderMainId\":\"1260214166825803778\",\"price\":11.0,\"sysOrgCode\":\"A01\"}],\"orderCode\":\"11\",\"xdDate\":1589293423000}]',NULL,52,'admin','2020-05-12 22:24:06',NULL,NULL),('1260214167920517122',2,'Nei商城订单表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.NeiCesOrderMainController.queryPageList()',NULL,'  neiCesOrderMain: NeiCesOrderMain(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, orderCode=null, xdDate=null, money=null, remark=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@2e911ba',NULL,23,'admin','2020-05-12 22:24:06',NULL,NULL),('1260214169191391233',2,'Nei订单商品-通过主表ID查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.NeiCesOrderMainController.queryNeiCesOrderGoodsListByMainId()',NULL,'  id: 1260133243631562754',NULL,14,'admin','2020-05-12 22:24:06',NULL,NULL),('1260214169199779842',2,'Nei订单商品-通过主表ID查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.NeiCesOrderMainController.queryNeiCesOrderGoodsListByMainId()',NULL,'  id: 1260135645520654338',NULL,18,'admin','2020-05-12 22:24:06',NULL,NULL),('1260214169220751361',2,'Nei订单客户-通过主表ID查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.NeiCesOrderMainController.queryNeiCesOrderCustomerListByMainId()',NULL,'  id: 1260135645520654338',NULL,24,'admin','2020-05-12 22:24:06',NULL,NULL),('1260214169220751362',2,'Nei订单客户-通过主表ID查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.NeiCesOrderMainController.queryNeiCesOrderCustomerListByMainId()',NULL,'  id: 1260133243631562754',NULL,25,'admin','2020-05-12 22:24:06',NULL,NULL),('1260214201449783298',2,'商城订单表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.CesOrderMainController.queryPageList()',NULL,'  cesOrderMain: CesOrderMain(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, orderCode=null, xdDate=null, money=null, remark=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@10d34a8e',NULL,25,'admin','2020-05-12 22:24:14',NULL,NULL),('1260214210438176769',2,'订单商品通过主表ID查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.CesOrderMainController.queryCesOrderGoodsListByMainId()',NULL,'  id: 1260135645520654338',NULL,14,'admin','2020-05-12 22:24:16',NULL,NULL),('1260214210513674242',2,'订单客户通过主表ID查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.CesOrderMainController.queryCesOrderCustomerListByMainId()',NULL,'  id: 1260135645520654338',NULL,24,'admin','2020-05-12 22:24:16',NULL,NULL),('1260214235960516610',2,'商城订单表-编辑',3,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.CesOrderMainController.edit()',NULL,'[{\"cesOrderCustomerList\":[{\"address\":\"\",\"birthday\":1549641600000,\"createBy\":\"admin\",\"createTime\":1589293462116,\"id\":\"15892747207990547016\",\"name\":\"23232\",\"orderMainId\":\"1260135645520654338\",\"sex\":\"1\",\"sysOrgCode\":\"A01\"},{\"address\":\"\",\"birthday\":1543939200000,\"createBy\":\"admin\",\"createTime\":1589293462118,\"id\":\"15892859831531205492\",\"name\":\"管理员\",\"orderMainId\":\"1260135645520654338\",\"sysOrgCode\":\"A01\"},{\"address\":\"\",\"birthday\":1589212800000,\"createBy\":\"admin\",\"createTime\":1589293462122,\"id\":\"15892859955132352429\",\"name\":\"张小红\",\"orderMainId\":\"1260135645520654338\",\"sex\":\"1\",\"sysOrgCode\":\"A01\"},{\"address\":\"\",\"birthday\":1549641600000,\"createBy\":\"admin\",\"createTime\":1589293462126,\"id\":\"15892860112563612499\",\"name\":\"23232\",\"orderMainId\":\"1260135645520654338\",\"sysOrgCode\":\"A01\"},{\"address\":\"\",\"createBy\":\"admin\",\"createTime\":1589293462131,\"id\":\"15892934577934970755\",\"orderMainId\":\"1260135645520654338\",\"sysOrgCode\":\"A01\"}],\"cesOrderGoodsList\":[{\"createBy\":\"admin\",\"createTime\":1589293462106,\"goodName\":\"11\",\"id\":\"15892747180850346324\",\"orderMainId\":\"1260135645520654338\",\"price\":11.0,\"sysOrgCode\":\"A01\"},{\"createBy\":\"admin\",\"createTime\":1589293462109,\"goodName\":\"\",\"id\":\"15892934593221167669\",\"orderMainId\":\"1260135645520654338\",\"sysOrgCode\":\"A01\"},{\"createBy\":\"admin\",\"createTime\":1589293462113,\"goodName\":\"\",\"id\":\"15892934594762635052\",\"orderMainId\":\"1260135645520654338\",\"sysOrgCode\":\"A01\"}],\"createBy\":\"admin\",\"createTime\":1589274724000,\"id\":\"1260135645520654338\",\"orderCode\":\"JDFX2020051217115656\",\"sysOrgCode\":\"A01\",\"updateBy\":\"admin\",\"updateTime\":1589293430000}]',NULL,59,'admin','2020-05-12 22:24:22',NULL,NULL),('1260214236723879937',2,'商城订单表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.CesOrderMainController.queryPageList()',NULL,'  cesOrderMain: CesOrderMain(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, orderCode=null, xdDate=null, money=null, remark=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@7b7d405b',NULL,35,'admin','2020-05-12 22:24:22',NULL,NULL),('1260214242285527041',2,'订单客户通过主表ID查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.CesOrderMainController.queryCesOrderCustomerListByMainId()',NULL,'  id: 1260214166825803778',NULL,4,'admin','2020-05-12 22:24:24',NULL,NULL),('1260214242285527042',2,'订单商品通过主表ID查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.main.controller.CesOrderMainController.queryCesOrderGoodsListByMainId()',NULL,'  id: 1260214166825803778',NULL,4,'admin','2020-05-12 22:24:24',NULL,NULL),('1260214259842883586',2,'商品分类-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.tree.controller.TreeCesShopTypeController.queryPageList()',NULL,'  treeCesShopType: TreeCesShopType(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, name=null, content=null, pics=null, pid=null, hasChild=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@61c42e6',NULL,17,'admin','2020-05-12 22:24:28',NULL,NULL),('1260214266037870593',2,'商品分类-获取子数据',1,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.tree.controller.TreeCesShopTypeController.queryPageList()',NULL,'  treeCesShopType: TreeCesShopType(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, name=null, content=null, pics=null, pid=1258408044439597058, hasChild=null)  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@46fa8676',NULL,10,'admin','2020-05-12 22:24:29',NULL,NULL),('1260214291413409794',2,'商品分类-编辑',3,'admin','管理员','127.0.0.1','org.jeecg.modules.oa.tree.controller.TreeCesShopTypeController.edit()',NULL,'[{\"createBy\":\"admin\",\"createTime\":1588862847000,\"hasChild\":\"0\",\"id\":\"1258408105487691777\",\"name\":\"阿迪\",\"pics\":\"temp/20180607175028Fn1Lq7zw_1589293474710.png\",\"pid\":\"1258408044439597058\",\"sysOrgCode\":\"A01\",\"updateBy\":\"admin\",\"updateTime\":1589293475358}]',NULL,20,'admin','2020-05-12 22:24:35',NULL,NULL),('1260475513035649025',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-13 15:42:34',NULL,NULL),('1260475564281655298',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-13 15:42:48',NULL,NULL),('1260922222828179457',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 21:17:38',NULL,NULL),('1260924202157985793',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@731a5dea',NULL,122,'admin','2020-05-14 21:25:31',NULL,NULL),('1260925184577228802',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@1db75eaf',NULL,38,'admin','2020-05-14 21:29:26',NULL,NULL),('1260925184577228801',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=总经理,, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 1  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@192abfa0',NULL,33,'admin','2020-05-14 21:29:26',NULL,NULL),('1260925222376296450',2,'编辑用户，id： e9ca23d68d884d4ebb19d07889727dae',2,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2020-05-14 21:29:35',NULL,NULL),('1260925780143230978',2,'部门角色-批量删除',4,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDepartRoleController.deleteBatch()',NULL,'  ids: 1260925743396933633,',NULL,9,'admin','2020-05-14 21:31:48',NULL,NULL),('1260925839089979393',2,'部门角色-批量删除',4,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDepartRoleController.deleteBatch()',NULL,'  ids: 1260925806189858818,',NULL,9,'admin','2020-05-14 21:32:02',NULL,NULL),('1260925911680798721',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@190feffa',NULL,25,'admin','2020-05-14 21:32:19',NULL,NULL),('1260925911689187329',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=总经理,, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 1  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@78b7f293',NULL,27,'admin','2020-05-14 21:32:19',NULL,NULL),('1260925926549606401',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 21:32:22',NULL,NULL),('1260925959411978241',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 21:32:30',NULL,NULL),('1260926982906036225',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 21:36:33',NULL,NULL),('1260927020524748801',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 21:36:43',NULL,NULL),('1260927070814453761',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@7b2de828',NULL,67,'admin','2020-05-14 21:36:55',NULL,NULL),('1260927070814453762',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=总经理,, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 1  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@41231cfa',NULL,62,'admin','2020-05-14 21:36:55',NULL,NULL),('1260927093472083970',2,'编辑用户，id： e9ca23d68d884d4ebb19d07889727dae',2,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2020-05-14 21:37:01',NULL,NULL),('1260927434087317506',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 21:38:22',NULL,NULL),('1260927465343270913',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 21:38:29',NULL,NULL),('1260927505818304514',2,'批量删除用户， ids： 1260927230919426050,',3,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2020-05-14 21:38:39',NULL,NULL),('1260927511149264898',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@2cabc777',NULL,37,'admin','2020-05-14 21:38:40',NULL,NULL),('1260927686529892353',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@4ab7a24f',NULL,24,'admin','2020-05-14 21:39:22',NULL,NULL),('1260927687171620865',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=总经理,, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 1  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@69480323',NULL,97,'admin','2020-05-14 21:39:22',NULL,NULL),('1260927717332860929',2,'编辑用户，id： 3d464b4ea0d2491aab8a7bde74c57e95',2,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2020-05-14 21:39:29',NULL,NULL),('1260927736362418177',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 21:39:34',NULL,NULL),('1260927772173385730',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 21:39:42',NULL,NULL),('1260927799134371843',2,'职务表-分页列表查询',1,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@2ac4e089',NULL,19,'jeecg','2020-05-14 21:39:49',NULL,NULL),('1260927799134371842',2,'职务表-分页列表查询',1,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=总经理,, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 1  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@70185f96',NULL,19,'jeecg','2020-05-14 21:39:49',NULL,NULL),('1260927831044636674',1,'用户名: jeecg,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 21:39:56',NULL,NULL),('1260927864892669953',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 21:40:05',NULL,NULL),('1260928418456911873',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 21:42:17',NULL,NULL),('1260928448987250689',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 21:42:24',NULL,NULL),('1260928481014956033',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@2338564f',NULL,25,'admin','2020-05-14 21:42:31',NULL,NULL),('1260928555405131778',2,'删除用户，id： 1260928527571730433',3,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2020-05-14 21:42:49',NULL,NULL),('1260929134214889473',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 21:45:07',NULL,NULL),('1260929271406379009',2,'职务表-分页列表查询',1,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@70c0bdfc',NULL,28,'jeecg','2020-05-14 21:45:40',NULL,NULL),('1260929271427350530',2,'职务表-分页列表查询',1,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=总经理,, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 1  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@525bea80',NULL,32,'jeecg','2020-05-14 21:45:40',NULL,NULL),('1260929371243397122',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=devleader,, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 1  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@e5f81d',NULL,18,'admin','2020-05-14 21:46:04',NULL,NULL),('1260929371260174338',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@400b70bc',NULL,19,'admin','2020-05-14 21:46:04',NULL,NULL),('1260929762320302082',1,'用户名: jeecg,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 21:47:37',NULL,NULL),('1260929810957451265',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 21:47:49',NULL,NULL),('1260929836681117697',2,'职务表-分页列表查询',1,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@cb51343',NULL,24,'jeecg','2020-05-14 21:47:55',NULL,NULL),('1260930724300701698',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@610afa2c',NULL,21,'admin','2020-05-14 21:51:26',NULL,NULL),('1260931207094452225',2,'职务表-分页列表查询',1,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@2ace1f73',NULL,22,'jeecg','2020-05-14 21:53:21',NULL,NULL),('1260931476662370305',2,'职务表-分页列表查询',1,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=总经理,, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 1  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@7a31b732',NULL,35,'jeecg','2020-05-14 21:54:26',NULL,NULL),('1260931476674953218',2,'职务表-分页列表查询',1,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@10a5aacb',NULL,40,'jeecg','2020-05-14 21:54:26',NULL,NULL),('1260931514486603778',1,'用户名: jeecg,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 21:54:35',NULL,NULL),('1260931555641114626',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 21:54:44',NULL,NULL),('1260931582723735554',2,'职务表-分页列表查询',1,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@22cf7c0d',NULL,23,'jeecg','2020-05-14 21:54:51',NULL,NULL),('1260931582874730497',2,'职务表-分页列表查询',1,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=总经理,, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 1  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@12d7128d',NULL,46,'jeecg','2020-05-14 21:54:51',NULL,NULL),('1260931781227560962',2,'职务表-分页列表查询',1,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@498c141f',NULL,16,'jeecg','2020-05-14 21:55:38',NULL,NULL),('1260931806921867266',1,'用户名: jeecg,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 21:55:44',NULL,NULL),('1260931842166603778',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 21:55:53',NULL,NULL),('1260931866350960641',2,'职务表-分页列表查询',1,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@31490538',NULL,18,'jeecg','2020-05-14 21:55:59',NULL,NULL),('1260932190738432001',2,'职务表-分页列表查询',1,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@1d88fafd',NULL,14,'jeecg','2020-05-14 21:57:16',NULL,NULL),('1260932814867644418',2,'职务表-分页列表查询',1,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=总经理,, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 1  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@1e366b7f',NULL,16,'jeecg','2020-05-14 21:59:45',NULL,NULL),('1260932814867644419',2,'职务表-分页列表查询',1,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@45e3c142',NULL,18,'jeecg','2020-05-14 21:59:45',NULL,NULL),('1260932881045372930',2,'职务表-分页列表查询',1,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@31e69524',NULL,17,'jeecg','2020-05-14 22:00:00',NULL,NULL),('1260932881062150145',2,'职务表-分页列表查询',1,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=总经理,, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 1  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@3144a4a4',NULL,19,'jeecg','2020-05-14 22:00:01',NULL,NULL),('1260933064055439361',2,'职务表-分页列表查询',1,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=总经理,, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 1  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@553714fa',NULL,10,'jeecg','2020-05-14 22:00:44',NULL,NULL),('1260933064063827969',2,'职务表-分页列表查询',1,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@35a8516d',NULL,12,'jeecg','2020-05-14 22:00:44',NULL,NULL),('1260933576796520450',2,'职务表-分页列表查询',1,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=总经理,, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 1  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@65f9e0cd',NULL,17,'jeecg','2020-05-14 22:02:46',NULL,NULL),('1260933576830074882',2,'职务表-分页列表查询',1,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@a53f5e6',NULL,23,'jeecg','2020-05-14 22:02:46',NULL,NULL),('1260933611194007554',1,'用户名: jeecg,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 22:02:55',NULL,NULL),('1260933659902459905',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 22:03:06',NULL,NULL),('1260933693624664065',2,'职务表-分页列表查询',1,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=总经理,, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 1  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@19141940',NULL,11,'jeecg','2020-05-14 22:03:14',NULL,NULL),('1260933693641441282',2,'职务表-分页列表查询',1,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@4e9b247f',NULL,16,'jeecg','2020-05-14 22:03:14',NULL,NULL),('1260935385174884354',2,'添加测试DEMO',2,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.demo.test.controller.JeecgDemoController.add()',NULL,'[{\"createBy\":\"jeecg\",\"createTime\":1589465397495,\"id\":\"1260935385049055234\",\"keyWord\":\"111\",\"name\":\"111\",\"sysOrgCode\":\"A02A01\"}]',NULL,9,'jeecg','2020-05-14 22:09:58',NULL,NULL),('1260935402375725058',2,'添加测试DEMO',2,'jeecg','jeecg','127.0.0.1','org.jeecg.modules.demo.test.controller.JeecgDemoController.add()',NULL,'[{\"createBy\":\"jeecg\",\"createTime\":1589465401622,\"id\":\"1260935402346364930\",\"keyWord\":\"222\",\"name\":\"22\",\"sysOrgCode\":\"A02A01\"}]',NULL,8,'jeecg','2020-05-14 22:10:02',NULL,NULL),('1260935773085089793',1,'用户名: jeecg,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 22:11:30',NULL,NULL),('1260935890966003713',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 22:11:58',NULL,NULL),('1260936567268163586',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 22:14:39',NULL,NULL),('1260936615301332993',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 22:14:51',NULL,NULL),('1260937288600371202',1,'用户名: jeecg,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 22:17:31',NULL,NULL),('1260937337363349505',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-05-14 22:17:43',NULL,NULL),('1269526314186010625',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-06-07 15:07:15',NULL,NULL),('1269526344632463362',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-06-07 15:07:22',NULL,NULL),('1269526384084086785',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-06-07 15:07:31',NULL,NULL),('1269526453491429377',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-06-07 15:07:48',NULL,NULL),('1269529372324347906',2,'大屏分类列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.BigScreenCategoryController.queryPageList()',NULL,'  bigScreenCategory: BigScreenCategory(id=null, categoryKey=null, categoryValue=null, isDeleted=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@3e746bc5',NULL,248,NULL,'2020-06-07 15:19:23',NULL,NULL),('1269529477710430210',2,'大屏分类列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.BigScreenCategoryController.queryPageList()',NULL,'  bigScreenCategory: BigScreenCategory(id=null, categoryKey=null, categoryValue=null, isDeleted=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@639dd34c',NULL,5,NULL,'2020-06-07 15:19:49',NULL,NULL),('1269529479002275841',2,'大屏分类列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.BigScreenCategoryController.queryPageList()',NULL,'  bigScreenCategory: BigScreenCategory(id=null, categoryKey=null, categoryValue=null, isDeleted=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@4b7da72',NULL,5,NULL,'2020-06-07 15:19:49',NULL,NULL),('1269529505921318914',2,'大屏分类列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.BigScreenCategoryController.queryPageList()',NULL,'  bigScreenCategory: BigScreenCategory(id=null, categoryKey=null, categoryValue=null, isDeleted=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@1afa5dd1',NULL,7,NULL,'2020-06-07 15:19:56',NULL,NULL),('1269529537403764737',2,'大屏分类列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.BigScreenCategoryController.queryPageList()',NULL,'  bigScreenCategory: BigScreenCategory(id=null, categoryKey=null, categoryValue=null, isDeleted=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@2cde2b7b',NULL,6,NULL,'2020-06-07 15:20:03',NULL,NULL),('1269529540046176257',2,'大屏分类列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.BigScreenCategoryController.queryPageList()',NULL,'  bigScreenCategory: BigScreenCategory(id=null, categoryKey=null, categoryValue=null, isDeleted=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@56641abe',NULL,8,NULL,'2020-06-07 15:20:04',NULL,NULL),('1269529905445552130',2,'大屏分类列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.BigScreenCategoryController.queryPageList()',NULL,'  bigScreenCategory: BigScreenCategory(id=null, categoryKey=null, categoryValue=null, isDeleted=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@65e678fa',NULL,4,NULL,'2020-06-07 15:21:31',NULL,NULL),('1269529907685310466',2,'大屏分类列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.BigScreenCategoryController.queryPageList()',NULL,'  bigScreenCategory: BigScreenCategory(id=null, categoryKey=null, categoryValue=null, isDeleted=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@b91dcdb',NULL,6,NULL,'2020-06-07 15:21:31',NULL,NULL),('1269529910176727041',2,'地图-分页列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryPageList()',NULL,'  visualMap: VisualMap(id=null, name=null, data=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  pageNo: 1  pageSize: 100  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@2328834f',NULL,26,NULL,'2020-06-07 15:21:32',NULL,NULL),('1269529921128054785',2,'大屏分类列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.BigScreenCategoryController.queryPageList()',NULL,'  bigScreenCategory: BigScreenCategory(id=null, categoryKey=null, categoryValue=null, isDeleted=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@166f41b6',NULL,4,NULL,'2020-06-07 15:21:35',NULL,NULL),('1269529926677118978',2,'地图-分页列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryPageList()',NULL,'  visualMap: VisualMap(id=null, name=null, data=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  pageNo: 1  pageSize: 100  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@2e47359e',NULL,15,NULL,'2020-06-07 15:21:36',NULL,NULL),('1269529928140931074',2,'大屏分类列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.BigScreenCategoryController.queryPageList()',NULL,'  bigScreenCategory: BigScreenCategory(id=null, categoryKey=null, categoryValue=null, isDeleted=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@e20aecf',NULL,3,NULL,'2020-06-07 15:21:36',NULL,NULL),('1269529931215355906',2,'地图-分页列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryPageList()',NULL,'  visualMap: VisualMap(id=null, name=null, data=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  pageNo: 1  pageSize: 100  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@4a7c8e41',NULL,7,NULL,'2020-06-07 15:21:37',NULL,NULL),('1269529933291536385',2,'大屏分类列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.BigScreenCategoryController.queryPageList()',NULL,'  bigScreenCategory: BigScreenCategory(id=null, categoryKey=null, categoryValue=null, isDeleted=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@4c306be8',NULL,3,NULL,'2020-06-07 15:21:37',NULL,NULL),('1269529938567970817',2,'地图-分页列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryPageList()',NULL,'  visualMap: VisualMap(id=null, name=null, data=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  pageNo: 1  pageSize: 100  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@45d74f23',NULL,7,NULL,'2020-06-07 15:21:39',NULL,NULL),('1269529941281685506',2,'大屏分类列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.BigScreenCategoryController.queryPageList()',NULL,'  bigScreenCategory: BigScreenCategory(id=null, categoryKey=null, categoryValue=null, isDeleted=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@332b1baf',NULL,4,NULL,'2020-06-07 15:21:39',NULL,NULL),('1269529960181219329',2,'地图-分页列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryPageList()',NULL,'  visualMap: VisualMap(id=null, name=null, data=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  pageNo: 1  pageSize: 100  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@66ba2b37',NULL,12,NULL,'2020-06-07 15:21:44',NULL,NULL),('1269529962420977666',2,'地图-通过id查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryById()',NULL,'  id: 1235103352843448322  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@680c8550',NULL,82,NULL,'2020-06-07 15:21:44',NULL,NULL),('1269529962844602370',2,'地图-通过id查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryById()',NULL,'  id: 1235103352843448322  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@13dcf53d',NULL,60,NULL,'2020-06-07 15:21:45',NULL,NULL),('1269529987452583938',2,'地图-分页列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryPageList()',NULL,'  visualMap: VisualMap(id=null, name=null, data=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  pageNo: 1  pageSize: 100  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@3fe5b0c7',NULL,13,NULL,'2020-06-07 15:21:50',NULL,NULL),('1269530012907814913',2,'地图-分页列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryPageList()',NULL,'  visualMap: VisualMap(id=null, name=null, data=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  pageNo: 1  pageSize: 100  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@4fcb2fdc',NULL,6,NULL,'2020-06-07 15:21:56',NULL,NULL),('1269530255577661441',2,'大屏分类列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.BigScreenCategoryController.queryPageList()',NULL,'  bigScreenCategory: BigScreenCategory(id=null, categoryKey=null, categoryValue=null, isDeleted=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@251885bc',NULL,2,NULL,'2020-06-07 15:22:54',NULL,NULL),('1269530259541278722',2,'地图-分页列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryPageList()',NULL,'  visualMap: VisualMap(id=null, name=null, data=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  pageNo: 1  pageSize: 100  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@7690986',NULL,4,NULL,'2020-06-07 15:22:55',NULL,NULL),('1269530267229437954',2,'大屏分类列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.BigScreenCategoryController.queryPageList()',NULL,'  bigScreenCategory: BigScreenCategory(id=null, categoryKey=null, categoryValue=null, isDeleted=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@3f61745a',NULL,3,NULL,'2020-06-07 15:22:57',NULL,NULL),('1269530577163337730',2,'大屏分类列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.BigScreenCategoryController.queryPageList()',NULL,'  bigScreenCategory: BigScreenCategory(id=null, categoryKey=null, categoryValue=null, isDeleted=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@4895716',NULL,4,NULL,'2020-06-07 15:24:11',NULL,NULL),('1269530608071163905',2,'大屏分类列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.BigScreenCategoryController.queryPageList()',NULL,'  bigScreenCategory: BigScreenCategory(id=null, categoryKey=null, categoryValue=null, isDeleted=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@53c1d397',NULL,21,NULL,'2020-06-07 15:24:18',NULL,NULL),('1269530610474500098',2,'大屏分类列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.BigScreenCategoryController.queryPageList()',NULL,'  bigScreenCategory: BigScreenCategory(id=null, categoryKey=null, categoryValue=null, isDeleted=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@766cf2cd',NULL,6,NULL,'2020-06-07 15:24:19',NULL,NULL),('1269530628828774401',2,'大屏分类列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.BigScreenCategoryController.queryPageList()',NULL,'  bigScreenCategory: BigScreenCategory(id=null, categoryKey=null, categoryValue=null, isDeleted=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@5202e822',NULL,3,NULL,'2020-06-07 15:24:23',NULL,NULL),('1269530652081995777',2,'地图-分页列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryPageList()',NULL,'  visualMap: VisualMap(id=null, name=null, data=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  pageNo: 1  pageSize: 100  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@2167830',NULL,12,NULL,'2020-06-07 15:24:29',NULL,NULL),('1269530652203630594',2,'地图-分页列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryPageList()',NULL,'  visualMap: VisualMap(id=null, name=null, data=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  pageNo: 1  pageSize: 100  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@cf63a9f',NULL,7,NULL,'2020-06-07 15:24:29',NULL,NULL),('1269530652287516674',2,'地图-分页列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryPageList()',NULL,'  visualMap: VisualMap(id=null, name=null, data=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  pageNo: 1  pageSize: 100  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@1cb1f9ff',NULL,5,NULL,'2020-06-07 15:24:29',NULL,NULL),('1269530653856186370',2,'地图-分页列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryPageList()',NULL,'  visualMap: VisualMap(id=null, name=null, data=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  pageNo: 1  pageSize: 100  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@fe85c4c',NULL,12,NULL,'2020-06-07 15:24:29',NULL,NULL),('1269530657131937793',2,'地图-通过id查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryById()',NULL,'  id: 1235103352843448322  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@2ecdc439',NULL,44,NULL,'2020-06-07 15:24:30',NULL,NULL),('1269530658931294210',2,'地图-通过id查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryById()',NULL,'  id: 1235103352843448322  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@7c68d268',NULL,43,NULL,'2020-06-07 15:24:30',NULL,NULL),('1269530660491575298',2,'地图-通过id查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryById()',NULL,'  id: 1235103352843448322  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@5a5fca5',NULL,52,NULL,'2020-06-07 15:24:31',NULL,NULL),('1269530694935199746',2,'地图-分页列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryPageList()',NULL,'  visualMap: VisualMap(id=null, name=null, data=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  pageNo: 1  pageSize: 100  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@6e58e571',NULL,9,NULL,'2020-06-07 15:24:39',NULL,NULL),('1269530697749577730',2,'地图-通过id查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryById()',NULL,'  id: 1235103352843448322  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@ec412cf',NULL,54,NULL,'2020-06-07 15:24:40',NULL,NULL),('1269530943460294658',2,'地图-分页列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryPageList()',NULL,'  visualMap: VisualMap(id=null, name=null, data=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  pageNo: 1  pageSize: 100  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@28e544cf',NULL,7,NULL,'2020-06-07 15:25:38',NULL,NULL),('1269530944877969410',2,'地图-通过id查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryById()',NULL,'  id: 1235103352843448322  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@4aa6f5ef',NULL,58,NULL,'2020-06-07 15:25:39',NULL,NULL),('1269530959629336578',2,'地图-分页列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryPageList()',NULL,'  visualMap: VisualMap(id=null, name=null, data=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  pageNo: 1  pageSize: 100  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@3fa6f1af',NULL,4,NULL,'2020-06-07 15:25:42',NULL,NULL),('1269530975924207617',2,'地图-通过id查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryById()',NULL,'  id: 1235103352843448322  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@b486077',NULL,36,NULL,'2020-06-07 15:25:46',NULL,NULL),('1269531024246784001',2,'大屏分类列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.BigScreenCategoryController.queryPageList()',NULL,'  bigScreenCategory: BigScreenCategory(id=null, categoryKey=null, categoryValue=null, isDeleted=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@13a76ba5',NULL,2,NULL,'2020-06-07 15:25:58',NULL,NULL),('1269531027107299329',2,'地图-分页列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryPageList()',NULL,'  visualMap: VisualMap(id=null, name=null, data=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  pageNo: 1  pageSize: 100  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@47f0c335',NULL,5,NULL,'2020-06-07 15:25:58',NULL,NULL),('1269531029519024130',2,'大屏分类列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.BigScreenCategoryController.queryPageList()',NULL,'  bigScreenCategory: BigScreenCategory(id=null, categoryKey=null, categoryValue=null, isDeleted=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@1d966d60',NULL,3,NULL,'2020-06-07 15:25:59',NULL,NULL),('1269531101421977602',2,'地图-分页列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryPageList()',NULL,'  visualMap: VisualMap(id=null, name=null, data=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  pageNo: 1  pageSize: 100  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@61563159',NULL,4,NULL,'2020-06-07 15:26:16',NULL,NULL),('1269531108581654529',2,'大屏分类列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.BigScreenCategoryController.queryPageList()',NULL,'  bigScreenCategory: BigScreenCategory(id=null, categoryKey=null, categoryValue=null, isDeleted=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@279b08a5',NULL,2,NULL,'2020-06-07 15:26:18',NULL,NULL),('1269531129112772610',2,'地图-分页列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryPageList()',NULL,'  visualMap: VisualMap(id=null, name=null, data=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  pageNo: 1  pageSize: 100  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@daaa5bf',NULL,5,NULL,'2020-06-07 15:26:23',NULL,NULL),('1269531194757824513',2,'大屏分类列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.BigScreenCategoryController.queryPageList()',NULL,'  bigScreenCategory: BigScreenCategory(id=null, categoryKey=null, categoryValue=null, isDeleted=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@39dd3c58',NULL,2,NULL,'2020-06-07 15:26:38',NULL,NULL),('1269531217054744577',2,'地图-分页列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryPageList()',NULL,'  visualMap: VisualMap(id=null, name=null, data=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  pageNo: 1  pageSize: 100  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@2013c4a',NULL,6,NULL,'2020-06-07 15:26:44',NULL,NULL),('1269531227943157762',2,'地图-分页列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryPageList()',NULL,'  visualMap: VisualMap(id=null, name=null, data=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  pageNo: 1  pageSize: 100  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@107e22b1',NULL,6,NULL,'2020-06-07 15:26:46',NULL,NULL),('1269531236797333506',2,'地图-分页列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryPageList()',NULL,'  visualMap: VisualMap(id=null, name=null, data=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  pageNo: 1  pageSize: 100  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@23026104',NULL,6,NULL,'2020-06-07 15:26:48',NULL,NULL),('1269531248570744834',2,'地图-分页列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryPageList()',NULL,'  visualMap: VisualMap(id=null, name=null, data=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  pageNo: 1  pageSize: 100  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@3d076b55',NULL,4,NULL,'2020-06-07 15:26:51',NULL,NULL),('1269531274336354305',2,'地图-通过id查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryById()',NULL,'  id: 1235103352843448322  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@6f620f5c',NULL,36,NULL,'2020-06-07 15:26:57',NULL,NULL),('1269531289783975937',2,'地图-分页列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryPageList()',NULL,'  visualMap: VisualMap(id=null, name=null, data=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  pageNo: 1  pageSize: 100  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@42db9645',NULL,5,NULL,'2020-06-07 15:27:01',NULL,NULL),('1269531322390495233',2,'地图-分页列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.VisualMapController.queryPageList()',NULL,'  visualMap: VisualMap(id=null, name=null, data=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  pageNo: 1  pageSize: 100  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@6c6faa4d',NULL,4,NULL,'2020-06-07 15:27:09',NULL,NULL),('1269531325586554882',2,'大屏分类列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.BigScreenCategoryController.queryPageList()',NULL,'  bigScreenCategory: BigScreenCategory(id=null, categoryKey=null, categoryValue=null, isDeleted=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@178d166a',NULL,3,NULL,'2020-06-07 15:27:09',NULL,NULL),('1269531327910199298',2,'大屏分类列表查询',1,NULL,NULL,'127.0.0.1','org.jeecg.modules.jmreport.visual.controller.BigScreenCategoryController.queryPageList()',NULL,'  bigScreenCategory: BigScreenCategory(id=null, categoryKey=null, categoryValue=null, isDeleted=null, createBy=null, createTime=null, updateBy=null, updateTime=null, delFlag=null)  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@37772193',NULL,2,NULL,'2020-06-07 15:27:10',NULL,NULL),('1281463660984672257',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-10 13:42:00',NULL,NULL),('1281463692681027586',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=总经理,, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 1  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@388569c3',NULL,128,'admin','2020-07-10 13:42:07',NULL,NULL),('1281463692722970626',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@4358bb54',NULL,138,'admin','2020-07-10 13:42:07',NULL,NULL),('1281463724180250626',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@5fc7ad92',NULL,21,'admin','2020-07-10 13:42:15',NULL,NULL),('1281466185779511298',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=总经理,, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 1  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@5edfc1ec',NULL,56,'admin','2020-07-10 13:52:02',NULL,NULL),('1281466185821454338',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@297e419b',NULL,105,'admin','2020-07-10 13:52:02',NULL,NULL),('1281470275754393601',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@48b03d65',NULL,49,'admin','2020-07-10 14:08:17',NULL,NULL),('1281490121686900739',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@c2689e6',NULL,137,'admin','2020-07-10 15:27:09',NULL,NULL),('1281490121686900738',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=总经理,, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 1  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@495980d',NULL,56,'admin','2020-07-10 15:27:09',NULL,NULL),('1281490127785418753',2,'编辑用户，id： e9ca23d68d884d4ebb19d07889727dae',2,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,'admin','2020-07-10 15:27:10',NULL,NULL),('1281490460796379138',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@42664396',NULL,24,'admin','2020-07-10 15:28:29',NULL,NULL),('1281490464818716674',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 99999  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@72b8f1e4',NULL,32,'admin','2020-07-10 15:28:30',NULL,NULL),('1281494695797710850',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@1f1e744e',NULL,17,'admin','2020-07-10 15:45:19',NULL,NULL),('1281511287809978369',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@46ca6657',NULL,38,'admin','2020-07-10 16:51:15',NULL,NULL),('1281511305329586178',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@3a9bbc8f',NULL,17,'admin','2020-07-10 16:51:19',NULL,NULL),('1281511309553250306',2,'编码校验规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysCheckRuleController.queryPageList()',NULL,'  sysCheckRule: SysCheckRule(id=null, ruleName=null, ruleCode=null, ruleJson=null, ruleDescription=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  request: org.apache.shiro.web.servlet.ShiroHttpServletRequest@43bfe5e4',NULL,39,'admin','2020-07-10 16:51:20',NULL,NULL),('1281511313403621377',2,'多数据源管理-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDataSourceController.queryPageList()',NULL,'  sysDataSource: SysDataSource(id=null, code=null, name=null, remark=null, dbType=null, dbDriver=null, dbUrl=null, dbName=null, dbUsername=null, dbPassword=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@374f394a',NULL,57,'admin','2020-07-10 16:51:21',NULL,NULL),('1281511318214488065',2,'编码校验规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysCheckRuleController.queryPageList()',NULL,'  sysCheckRule: SysCheckRule(id=null, ruleName=null, ruleCode=null, ruleJson=null, ruleDescription=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  request: org.apache.shiro.web.servlet.ShiroHttpServletRequest@2053432a',NULL,15,'admin','2020-07-10 16:51:22',NULL,NULL),('1281511321653817345',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@141a2c36',NULL,16,'admin','2020-07-10 16:51:23',NULL,NULL),('1281511330424107009',2,'编码校验规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysCheckRuleController.queryPageList()',NULL,'  sysCheckRule: SysCheckRule(id=null, ruleName=null, ruleCode=null, ruleJson=null, ruleDescription=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  request: org.apache.shiro.web.servlet.ShiroHttpServletRequest@2801528a',NULL,12,'admin','2020-07-10 16:51:25',NULL,NULL),('1281512143234084865',2,'多数据源管理-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDataSourceController.queryPageList()',NULL,'  sysDataSource: SysDataSource(id=null, code=null, name=null, remark=null, dbType=null, dbDriver=null, dbUrl=null, dbName=null, dbUsername=null, dbPassword=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@e82dbcc',NULL,21,'admin','2020-07-10 16:54:39',NULL,NULL),('1281512154952970241',2,'多数据源管理-编辑',3,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDataSourceController.edit()',NULL,'[{\"createBy\":\"admin\",\"createTime\":1577268893000,\"dbDriver\":\"com.mysql.jdbc.Driver\",\"dbName\":\"jeecg-boot\",\"dbPassword\":\"root\",\"dbType\":\"1\",\"dbUrl\":\"jdbc:mysql://127.0.0.1:3306/jeecg-boot?characterEncoding=UTF-8&useUnicode=true&useSSL=false\",\"dbUsername\":\"root\",\"id\":\"1209779538310004737\",\"name\":\"MySQL5.7\",\"remark\":\"本地数据库MySQL5.7\",\"sysOrgCode\":\"A01\",\"updateBy\":\"admin\",\"updateTime\":1594371281682}]',NULL,27,'admin','2020-07-10 16:54:42',NULL,NULL),('1281512155624058882',2,'多数据源管理-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDataSourceController.queryPageList()',NULL,'  sysDataSource: SysDataSource(id=null, code=null, name=null, remark=null, dbType=null, dbDriver=null, dbUrl=null, dbName=null, dbUsername=null, dbPassword=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@469013ef',NULL,17,'admin','2020-07-10 16:54:42',NULL,NULL),('1281512163014422530',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@2d8cfe34',NULL,14,'admin','2020-07-10 16:54:44',NULL,NULL),('1281512167053537281',2,'编码校验规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysCheckRuleController.queryPageList()',NULL,'  sysCheckRule: SysCheckRule(id=null, ruleName=null, ruleCode=null, ruleJson=null, ruleDescription=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  request: org.apache.shiro.web.servlet.ShiroHttpServletRequest@350a614e',NULL,12,'admin','2020-07-10 16:54:45',NULL,NULL),('1281516925944410113',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-10 17:13:39',NULL,NULL),('1281518641905479681',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@4d73d74b',NULL,22,'admin','2020-07-10 17:20:28',NULL,NULL),('1281518645130899458',2,'编码校验规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysCheckRuleController.queryPageList()',NULL,'  sysCheckRule: SysCheckRule(id=null, ruleName=null, ruleCode=null, ruleJson=null, ruleDescription=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  request: org.apache.shiro.web.servlet.ShiroHttpServletRequest@39d7de59',NULL,17,'admin','2020-07-10 17:20:29',NULL,NULL),('1281563453585215489',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-10 20:18:32',NULL,NULL),('1281563506332782593',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-10 20:18:45',NULL,NULL),('1281634474623356929',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-11 01:00:45',NULL,NULL),('1281653329143910402',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-11 02:15:40',NULL,NULL),('1281782848886525953',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-11 10:50:20',NULL,NULL),('1281782852653010945',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-11 10:50:21',NULL,NULL),('1281782935767339010',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-11 10:50:41',NULL,NULL),('1281792846681182210',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@1790aa50',NULL,31,'admin','2020-07-11 11:30:04',NULL,NULL),('1281792861646458882',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=shop_order_num, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@34810a0f',NULL,7,'admin','2020-07-11 11:30:07',NULL,NULL),('1281792866222444546',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@68240471',NULL,17,'admin','2020-07-11 11:30:09',NULL,NULL),('1281792871658262530',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=shop_order_num, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@4ec76a80',NULL,17,'admin','2020-07-11 11:30:10',NULL,NULL),('1281793269345390594',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@20e6313d',NULL,13,'admin','2020-07-11 11:31:45',NULL,NULL),('1281793915574390785',2,'填值规则-编辑',3,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.edit()',NULL,'[{\"createBy\":\"admin\",\"createTime\":1589274365000,\"id\":\"1260134137920090113\",\"ruleClass\":\"org.jeecg.modules.rule.OrderNumberRule\",\"ruleCode\":\"shop_order_num\",\"ruleName\":\"商城订单流水号\",\"ruleParams\":\"{}\",\"updateBy\":\"admin\",\"updateTime\":1594438458695}]',NULL,12,'admin','2020-07-11 11:34:19',NULL,NULL),('1281793915922518017',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@7ceee797',NULL,12,'admin','2020-07-11 11:34:19',NULL,NULL),('1281794052098985986',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@36c48e02',NULL,17,'admin','2020-07-11 11:34:51',NULL,NULL),('1281794089126301697',2,'填值规则-编辑',3,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.edit()',NULL,'[{\"createBy\":\"admin\",\"createTime\":1589274365000,\"id\":\"1260134137920090113\",\"ruleClass\":\"org.jeecg.modules.system.rule.OrderNumberRule\",\"ruleCode\":\"shop_order_num\",\"ruleName\":\"商城订单流水号\",\"ruleParams\":\"{}\",\"updateBy\":\"admin\",\"updateTime\":1594438500079}]',NULL,8,'admin','2020-07-11 11:35:00',NULL,NULL),('1281794089512177666',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@302729ee',NULL,16,'admin','2020-07-11 11:35:00',NULL,NULL),('1281794654736564225',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@5a8c5a9a',NULL,26,'admin','2020-07-11 11:37:15',NULL,NULL),('1281794658578546689',2,'编码校验规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysCheckRuleController.queryPageList()',NULL,'  sysCheckRule: SysCheckRule(id=null, ruleName=null, ruleCode=null, ruleJson=null, ruleDescription=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  request: org.apache.shiro.web.servlet.ShiroHttpServletRequest@725088fe',NULL,32,'admin','2020-07-11 11:37:16',NULL,NULL),('1281794663301332994',2,'多数据源管理-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDataSourceController.queryPageList()',NULL,'  sysDataSource: SysDataSource(id=null, code=null, name=null, remark=null, dbType=null, dbDriver=null, dbUrl=null, dbName=null, dbUsername=null, dbPassword=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@4189e173',NULL,61,'admin','2020-07-11 11:37:17',NULL,NULL),('1281794665633366018',2,'编码校验规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysCheckRuleController.queryPageList()',NULL,'  sysCheckRule: SysCheckRule(id=null, ruleName=null, ruleCode=null, ruleJson=null, ruleDescription=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  request: org.apache.shiro.web.servlet.ShiroHttpServletRequest@fafd1bd',NULL,20,'admin','2020-07-11 11:37:18',NULL,NULL),('1281794667516608513',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@264761c3',NULL,14,'admin','2020-07-11 11:37:18',NULL,NULL),('1281794670893023234',2,'编码校验规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysCheckRuleController.queryPageList()',NULL,'  sysCheckRule: SysCheckRule(id=null, ruleName=null, ruleCode=null, ruleJson=null, ruleDescription=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  request: org.apache.shiro.web.servlet.ShiroHttpServletRequest@445cd090',NULL,12,'admin','2020-07-11 11:37:19',NULL,NULL),('1281794672625270785',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@d8473bc',NULL,16,'admin','2020-07-11 11:37:19',NULL,NULL),('1281795543228563458',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@6fda764a',NULL,15,'admin','2020-07-11 11:40:47',NULL,NULL),('1281795545476710402',2,'编码校验规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysCheckRuleController.queryPageList()',NULL,'  sysCheckRule: SysCheckRule(id=null, ruleName=null, ruleCode=null, ruleJson=null, ruleDescription=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  request: org.apache.shiro.web.servlet.ShiroHttpServletRequest@6881005e',NULL,12,'admin','2020-07-11 11:40:47',NULL,NULL),('1281795548324642817',2,'多数据源管理-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDataSourceController.queryPageList()',NULL,'  sysDataSource: SysDataSource(id=null, code=null, name=null, remark=null, dbType=null, dbDriver=null, dbUrl=null, dbName=null, dbUsername=null, dbPassword=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@59fa83d0',NULL,15,'admin','2020-07-11 11:40:48',NULL,NULL),('1281795552816742402',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@55a0b7c',NULL,14,'admin','2020-07-11 11:40:49',NULL,NULL),('1281795555513679873',2,'编码校验规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysCheckRuleController.queryPageList()',NULL,'  sysCheckRule: SysCheckRule(id=null, ruleName=null, ruleCode=null, ruleJson=null, ruleDescription=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  request: org.apache.shiro.web.servlet.ShiroHttpServletRequest@59736cc4',NULL,9,'admin','2020-07-11 11:40:50',NULL,NULL),('1281800098691514370',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-11 11:58:53',NULL,NULL),('1281800338509234177',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@78f6b224',NULL,229,'admin','2020-07-11 11:59:50',NULL,NULL),('1281801356038995969',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@73cccdb5',NULL,42,'admin','2020-07-11 12:03:53',NULL,NULL),('1281801511580565505',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@6bf19c8c',NULL,28,'admin','2020-07-11 12:04:30',NULL,NULL),('1284024845240168450',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-17 15:19:14',NULL,NULL),('1284024892098932737',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-17 15:19:25',NULL,NULL),('1284377638777974786',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-18 14:41:06',NULL,NULL),('1285106808533385218',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-20 14:58:34',NULL,NULL),('1285107423695175682',1,'用户名: jeecg,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-20 15:01:01',NULL,NULL),('1285107460613439489',1,'用户名: jeecg,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-20 15:01:09',NULL,NULL),('1285107518352228353',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-20 15:01:23',NULL,NULL),('1285138414073647105',1,'用户名: 管理员,退出成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-20 17:04:09',NULL,NULL),('1285138459669925890',1,'用户名: admin,登录成功！',NULL,NULL,NULL,'127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-07-20 17:04:20',NULL,NULL),('1303583688781516801',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-09-09 14:39:05',NULL,NULL),('1303584123403685889',1,'用户名: admin,登录成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-09-09 14:40:49',NULL,NULL),('1303584582709334018',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=总经理,, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 1  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@266f996e',NULL,88,NULL,'2020-09-09 14:42:39',NULL,NULL),('1303584582747082753',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@35d3b3fd',NULL,95,NULL,'2020-09-09 14:42:39',NULL,NULL),('1303584633527521281',2,'编辑用户，id： 3d464b4ea0d2491aab8a7bde74c57e95',2,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-09-09 14:42:51',NULL,NULL),('1303584929985122306',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@572aa945',NULL,51,NULL,'2020-09-09 14:44:01',NULL,NULL),('1303584934108123137',2,'编码校验规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysCheckRuleController.queryPageList()',NULL,'  sysCheckRule: SysCheckRule(id=null, ruleName=null, ruleCode=null, ruleJson=null, ruleDescription=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  request: org.apache.shiro.web.servlet.ShiroHttpServletRequest@64486094',NULL,48,NULL,'2020-09-09 14:44:02',NULL,NULL),('1303584937023164418',2,'多数据源管理-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDataSourceController.queryPageList()',NULL,'  sysDataSource: SysDataSource(id=null, code=null, name=null, remark=null, dbType=null, dbDriver=null, dbUrl=null, dbName=null, dbUsername=null, dbPassword=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@14ab41e3',NULL,55,NULL,'2020-09-09 14:44:03',NULL,NULL),('1303585451299360769',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@78644da8',NULL,23,NULL,'2020-09-09 14:46:06',NULL,NULL),('1303585453941772290',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 99999  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@1980d3ae',NULL,24,NULL,'2020-09-09 14:46:06',NULL,NULL),('1303612674161065986',2,'online表单加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,264,NULL,'2020-09-09 16:34:16',NULL,NULL),('1303612674161065987',2,'online列表加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,243,NULL,'2020-09-09 16:34:16',NULL,NULL),('1303612675339665409',2,'online列表数据查询,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,148,NULL,'2020-09-09 16:34:16',NULL,NULL),('1303612703399559169',2,'online表单加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,80,NULL,'2020-09-09 16:34:23',NULL,NULL),('1303612703496028161',2,'online列表加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,98,NULL,'2020-09-09 16:34:23',NULL,NULL),('1303612704506855425',2,'online列表数据查询,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,107,NULL,'2020-09-09 16:34:23',NULL,NULL),('1303612713012903938',2,'online表单加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,78,NULL,'2020-09-09 16:34:25',NULL,NULL),('1303612713138733058',2,'online列表加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,103,NULL,'2020-09-09 16:34:25',NULL,NULL),('1303612714103422978',2,'online列表数据查询,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,98,NULL,'2020-09-09 16:34:26',NULL,NULL),('1303623650910482433',1,'用户名: admin,登录成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-09-09 17:17:53',NULL,NULL),('1303623737740963842',2,'online列表加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,207,NULL,'2020-09-09 17:18:14',NULL,NULL),('1303623737728380929',2,'online表单加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,195,NULL,'2020-09-09 17:18:14',NULL,NULL),('1303623738856648706',2,'online列表数据查询,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,133,NULL,'2020-09-09 17:18:14',NULL,NULL),('1303623744451850242',2,'online表单数据查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,24,NULL,'2020-09-09 17:18:15',NULL,NULL),('1303623768380354562',2,'online修改数据,表名:ces_field_kongj,修改成功！',3,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'[\"18f064d1ef424c93ba7a16148851664f\",{\"birthday\":\"\",\"sel_mut\":\"\",\"remakr\":\"\",\"user_sel\":\"\",\"ddd\":\"\",\"fuwenb\":\"\",\"sex\":\"\",\"sel_search\":\"\",\"pic\":\"\",\"radio\":\"2\",\"update_time\":\"2020-09-09 17:18:21\",\"dep_sel\":\"\",\"checkbox\":\"\",\"name\":\"张三2\",\"files\":\"\",\"id\":\"1285112866127577089\",\"update_by\":\"admin\"}]',NULL,117,NULL,'2020-09-09 17:18:21',NULL,NULL),('1303623769382793218',2,'online列表数据查询,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,87,NULL,'2020-09-09 17:18:21',NULL,NULL),('1303623805579636738',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@e09a928',NULL,71,NULL,'2020-09-09 17:18:30',NULL,NULL),('1303623811887869954',2,'编辑用户，id： f0019fdebedb443c98dcb17d88222c38',2,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-09-09 17:18:32',NULL,NULL),('1303629650698809345',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-09-09 17:41:44',NULL,NULL),('1303629755246030850',1,'用户名: admin,登录成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-09-09 17:42:09',NULL,NULL),('1303635656849752066',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@198b7d28',NULL,218,NULL,'2020-09-09 18:05:36',NULL,NULL),('1303641687692673026',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@1b1a7342',NULL,35,NULL,'2020-09-09 18:29:33',NULL,NULL),('1303940170840666113',1,'用户名: admin,登录成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-09-10 14:15:37',NULL,NULL),('1303972940572897282',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-09-10 16:25:50',NULL,NULL),('1303972986232090626',1,'用户名: admin,登录成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-09-10 16:26:01',NULL,NULL),('1303979706157117441',1,'用户名: admin,登录成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-09-10 16:52:43',NULL,NULL),('1303986485096157185',2,'编辑DEMO',3,'admin','管理员','127.0.0.1','org.jeecg.modules.demo.test.controller.JeecgDemoController.edit()',NULL,'[{\"age\":19,\"createBy\":\"jeecg\",\"createTime\":1589465402000,\"id\":\"1260935402346364930\",\"keyWord\":\"222\",\"name\":\"22\",\"sysOrgCode\":\"A02A01\",\"updateBy\":\"admin\",\"updateTime\":1599729579362}]',NULL,34,NULL,'2020-09-10 17:19:40',NULL,NULL),('1303986503559483393',2,'编辑DEMO',3,'admin','管理员','127.0.0.1','org.jeecg.modules.demo.test.controller.JeecgDemoController.edit()',NULL,'[{\"age\":20,\"createBy\":\"jeecg\",\"createTime\":1589465397000,\"id\":\"1260935385049055234\",\"keyWord\":\"111\",\"name\":\"111\",\"sysOrgCode\":\"A02A01\",\"updateBy\":\"admin\",\"updateTime\":1599729583991}]',NULL,11,NULL,'2020-09-10 17:19:44',NULL,NULL),('1304300437101395970',1,'用户名: admin,登录成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-09-11 14:07:12',NULL,NULL),('1304300467673677825',2,'online表单加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,214,NULL,'2020-09-11 14:07:19',NULL,NULL),('1304300467744980993',2,'online列表加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,238,NULL,'2020-09-11 14:07:19',NULL,NULL),('1304300468831305729',2,'online列表数据查询,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,98,NULL,'2020-09-11 14:07:19',NULL,NULL),('1304300474145488898',2,'online表单数据查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,27,NULL,'2020-09-11 14:07:20',NULL,NULL),('1304300481636515842',2,'online修改数据,表名:ces_field_kongj,修改成功！',3,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'[\"18f064d1ef424c93ba7a16148851664f\",{\"birthday\":\"\",\"sel_mut\":\"\",\"remakr\":\"\",\"user_sel\":\"\",\"ddd\":\"\",\"fuwenb\":\"\",\"sex\":\"\",\"sel_search\":\"\",\"pic\":\"\",\"radio\":\"2\",\"update_time\":\"2020-09-11 14:07:22\",\"dep_sel\":\"\",\"checkbox\":\"\",\"name\":\"张三2\",\"files\":\"\",\"id\":\"1285112866127577089\",\"update_by\":\"admin\"}]',NULL,76,NULL,'2020-09-11 14:07:22',NULL,NULL),('1304300482647343105',2,'online列表数据查询,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,51,NULL,'2020-09-11 14:07:22',NULL,NULL),('1304300552046297090',2,'填值规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysFillRuleController.queryPageList()',NULL,'  sysFillRule: SysFillRule(id=null, ruleName=null, ruleCode=null, ruleClass=null, ruleParams=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@f562013',NULL,31,NULL,'2020-09-11 14:07:39',NULL,NULL),('1304300683625807874',2,'编码校验规则-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysCheckRuleController.queryPageList()',NULL,'  sysCheckRule: SysCheckRule(id=null, ruleName=null, ruleCode=null, ruleJson=null, ruleDescription=null, updateBy=null, updateTime=null, createBy=null, createTime=null)  pageNo: 1  pageSize: 10  request: org.apache.shiro.web.servlet.ShiroHttpServletRequest@5fee2100',NULL,35,NULL,'2020-09-11 14:08:10',NULL,NULL),('1304300686897364994',2,'多数据源管理-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysDataSourceController.queryPageList()',NULL,'  sysDataSource: SysDataSource(id=null, code=null, name=null, remark=null, dbType=null, dbDriver=null, dbUrl=null, dbName=null, dbUsername=null, dbPassword=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@507f3d79',NULL,38,NULL,'2020-09-11 14:08:11',NULL,NULL),('1304301024350093313',2,'online列表加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,82,NULL,'2020-09-11 14:09:32',NULL,NULL),('1304301024366870530',2,'online表单加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,70,NULL,'2020-09-11 14:09:32',NULL,NULL),('1304301025348337665',2,'online列表数据查询,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,54,NULL,'2020-09-11 14:09:32',NULL,NULL),('1304301343381438466',2,'online表单加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,49,NULL,'2020-09-11 14:10:48',NULL,NULL),('1304301343394021377',2,'online列表加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,68,NULL,'2020-09-11 14:10:48',NULL,NULL),('1304301344367099906',2,'online列表数据查询,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,70,NULL,'2020-09-11 14:10:48',NULL,NULL),('1304301368681480194',2,'online表单加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,43,NULL,'2020-09-11 14:10:54',NULL,NULL),('1304301368731811842',2,'online列表加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,55,NULL,'2020-09-11 14:10:54',NULL,NULL),('1304301379687333890',2,'online列表数据查询,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,55,NULL,'2020-09-11 14:10:56',NULL,NULL),('1304301393297850369',2,'online表单加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,36,NULL,'2020-09-11 14:11:00',NULL,NULL),('1304301393373347841',2,'online列表加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,52,NULL,'2020-09-11 14:11:00',NULL,NULL),('1304301395285950466',2,'online列表数据查询,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,71,NULL,'2020-09-11 14:11:00',NULL,NULL),('1304307438242066434',1,'用户名: admin,登录成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-09-11 14:35:01',NULL,NULL),('1304307486547865602',2,'online表单加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,168,NULL,'2020-09-11 14:35:12',NULL,NULL),('1304307486573031426',2,'online列表加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,187,NULL,'2020-09-11 14:35:12',NULL,NULL),('1304307487785185281',2,'online列表数据查询,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,97,NULL,'2020-09-11 14:35:13',NULL,NULL),('1304307637521838081',2,'online表单加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,61,NULL,'2020-09-11 14:35:48',NULL,NULL),('1304307637593141249',2,'online列表加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,78,NULL,'2020-09-11 14:35:48',NULL,NULL),('1304307638536859650',2,'online列表数据查询,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,54,NULL,'2020-09-11 14:35:49',NULL,NULL),('1304309349380878338',2,'online表单加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,39,NULL,'2020-09-11 14:42:36',NULL,NULL),('1304309349477347330',2,'online列表加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,56,NULL,'2020-09-11 14:42:36',NULL,NULL),('1304309350190379009',2,'online列表数据查询,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,60,NULL,'2020-09-11 14:42:37',NULL,NULL),('1304309384843718658',2,'online表单加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,52,NULL,'2020-09-11 14:42:45',NULL,NULL),('1304309384902438914',2,'online列表加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,64,NULL,'2020-09-11 14:42:45',NULL,NULL),('1304309385657413633',2,'online列表数据查询,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,56,NULL,'2020-09-11 14:42:45',NULL,NULL),('1304309821428822018',2,'online列表加载,表名:test_note,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,29,NULL,'2020-09-11 14:44:29',NULL,NULL),('1304309821428822019',2,'online表单加载,表名:test_note,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,32,NULL,'2020-09-11 14:44:29',NULL,NULL),('1304309822292848641',2,'online列表数据查询,表名:test_note,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,58,NULL,'2020-09-11 14:44:29',NULL,NULL),('1304309860846891009',2,'online新增数据,表名:test_note,操作成功！',2,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'[\"05a3a30dada7411c9109306aa4117068\",{\"birthday\":\"2020-09-11\",\"create_by\":\"admin\",\"sys_org_code\":\"A01\",\"create_time\":\"2020-09-11 14:44:38\",\"contents\":\"222\",\"sex\":\"1\",\"name\":\"zhangsan\",\"id\":\"1304309860578455553\",\"age\":222},null]',NULL,49,NULL,'2020-09-11 14:44:38',NULL,NULL),('1304309861371179010',2,'online列表数据查询,表名:test_note,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,44,NULL,'2020-09-11 14:44:39',NULL,NULL),('1304315837088362497',2,'online表单加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,50,NULL,'2020-09-11 15:08:23',NULL,NULL),('1304315837243551746',2,'online列表加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,89,NULL,'2020-09-11 15:08:23',NULL,NULL),('1304315838115966978',2,'online列表数据查询,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,63,NULL,'2020-09-11 15:08:23',NULL,NULL),('1304344410935336962',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-09-11 17:01:56',NULL,NULL),('1304344457320144898',1,'用户名: admin,登录成功！',NULL,'admin','管理员','127.0.0.1',NULL,NULL,NULL,NULL,NULL,NULL,'2020-09-11 17:02:07',NULL,NULL),('1304344520830296065',2,'online表单加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,187,NULL,'2020-09-11 17:02:22',NULL,NULL),('1304344520838684674',2,'online列表加载,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,194,NULL,'2020-09-11 17:02:22',NULL,NULL),('1304344521925009410',2,'online列表数据查询,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,85,NULL,'2020-09-11 17:02:22',NULL,NULL),('1304344529269235714',2,'online表单数据查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,21,NULL,'2020-09-11 17:02:24',NULL,NULL),('1304344558134435842',2,'online修改数据,表名:ces_field_kongj,修改成功！',3,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'[\"18f064d1ef424c93ba7a16148851664f\",{\"birthday\":\"\",\"sel_mut\":\"\",\"remakr\":\"\",\"user_sel\":\"zhagnxiao\",\"ddd\":\"\",\"fuwenb\":\"\",\"sex\":\"2\",\"sel_search\":\"\",\"pic\":\"\",\"radio\":\"2\",\"update_time\":\"2020-09-11 17:02:30\",\"dep_sel\":\"A01\",\"checkbox\":\"1,2\",\"name\":\"A011\",\"files\":\"\",\"id\":\"1260185893546840066\",\"update_by\":\"admin\"}]',NULL,64,NULL,'2020-09-11 17:02:31',NULL,NULL),('1304344558771970049',2,'online列表数据查询,表名:ces_field_kongj,操作成功！',1,'admin','管理员','127.0.0.1','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,52,NULL,'2020-09-11 17:02:31',NULL,NULL),('1304344622290509825',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@64d4432',NULL,88,NULL,'2020-09-11 17:02:46',NULL,NULL),('1304344842973814786',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@13264596',NULL,53,NULL,'2020-09-11 17:03:39',NULL,NULL),('1304345125841870849',2,'职务表-分页列表查询',1,'admin','管理员','127.0.0.1','org.jeecg.modules.system.controller.SysPositionController.queryPageList()',NULL,'  sysPosition: SysPosition(id=null, code=null, name=null, postRank=null, companyId=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null)  pageNo: 1  pageSize: 5  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@b95b5eb',NULL,61,NULL,'2020-09-11 17:04:46',NULL,NULL),('1325641252056231938',1,'用户名: admin,登录成功！',NULL,'admin','管理员','27.38.252.216',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-09 11:27:58',NULL,NULL),('1325653520013750274',1,'用户名: admin,登录成功！',NULL,'admin','管理员','220.115.53.100',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-09 12:16:43',NULL,NULL),('1325681871403249666',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','220.115.53.100',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-09 14:09:23',NULL,NULL),('1325681926810005506',1,'用户名: admin,登录成功！',NULL,'admin','管理员','220.115.53.100',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-09 14:09:36',NULL,NULL),('1325685880767803393',2,'online列表加载,表名:iost_storage,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,398,NULL,'2020-11-09 14:25:19',NULL,NULL),('1325685881019461634',2,'online表单加载,表名:iost_storage,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,153,NULL,'2020-11-09 14:25:19',NULL,NULL),('1325685882231615490',2,'online列表数据查询,表名:iost_storage,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,101,NULL,'2020-11-09 14:25:19',NULL,NULL),('1325685968529420289',2,'online列表加载,表名:iost_storage,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,28,NULL,'2020-11-09 14:25:40',NULL,NULL),('1325685968529420290',2,'online表单加载,表名:iost_storage,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,22,NULL,'2020-11-09 14:25:40',NULL,NULL),('1325685970102284290',2,'online列表数据查询,表名:iost_storage,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,107,NULL,'2020-11-09 14:25:40',NULL,NULL),('1325686077031870466',2,'online新增数据,表名:iost_storage,操作成功！',2,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'[\"38b8d95658a74899b7dc02e63e199af6\",{\"create_by\":\"admin\",\"address\":\"中国义乌\",\"create_time\":\"2020-11-09 14:26:05\",\"sys_org_code\":\"A01\",\"name\":\"义乌仓库\",\"id\":\"1325686076402724866\"},null]',NULL,106,NULL,'2020-11-09 14:26:06',NULL,NULL),('1325686077963005953',2,'online列表数据查询,表名:iost_storage,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,63,NULL,'2020-11-09 14:26:06',NULL,NULL),('1325686117754368002',2,'online表单数据查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,22,NULL,'2020-11-09 14:26:15',NULL,NULL),('1325686149681410050',2,'online修改数据,表名:iost_storage,修改成功！',3,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'[\"38b8d95658a74899b7dc02e63e199af6\",{\"update_time\":\"2020-11-09 14:26:22\",\"address\":\"中国浙江义乌\",\"name\":\"义乌仓库\",\"id\":\"1325686076402724866\",\"update_by\":\"admin\"}]',NULL,32,NULL,'2020-11-09 14:26:23',NULL,NULL),('1325686150771929090',2,'online列表数据查询,表名:iost_storage,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,159,NULL,'2020-11-09 14:26:23',NULL,NULL),('1325686175589625857',2,'online列表数据查询,表名:iost_storage,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,38,NULL,'2020-11-09 14:26:29',NULL,NULL),('1325686198469554178',2,'online列表数据查询,表名:iost_storage,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,36,NULL,'2020-11-09 14:26:34',NULL,NULL),('1325688605983272961',2,'online表单加载,表名:iost_customer,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,110,NULL,'2020-11-09 14:36:09',NULL,NULL),('1325688606394314753',2,'online列表加载,表名:iost_customer,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,127,NULL,'2020-11-09 14:36:09',NULL,NULL),('1325688607556136961',2,'online列表数据查询,表名:iost_customer,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,47,NULL,'2020-11-09 14:36:09',NULL,NULL),('1325688643333550081',2,'online新增数据,保存失败，Field \'name_chs\' doesn\'t have a default value',2,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'[\"6a56622058424a0e8bcc8b402ffc949d\",{\"create_by\":\"admin\",\"create_time\":\"2020-11-09 14:36:17\",\"sys_org_code\":\"A01\",\"id\":\"1325688642528243714\"},null]',NULL,193,NULL,'2020-11-09 14:36:17',NULL,NULL),('1325688661977231362',2,'online新增数据,保存失败，Field \'name_chs\' doesn\'t have a default value',2,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'[\"6a56622058424a0e8bcc8b402ffc949d\",{\"create_by\":\"admin\",\"create_time\":\"2020-11-09 14:36:21\",\"sys_org_code\":\"A01\",\"id\":\"1325688661822042113\"},null]',NULL,38,NULL,'2020-11-09 14:36:22',NULL,NULL),('1325688681401053185',2,'online新增数据,保存失败，Field \'name_eng\' doesn\'t have a default value',2,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'[\"6a56622058424a0e8bcc8b402ffc949d\",{\"create_by\":\"admin\",\"name_chs\":\"sfdsf\",\"create_time\":\"2020-11-09 14:36:26\",\"sys_org_code\":\"A01\",\"id\":\"1325688681296195586\"},null]',NULL,29,NULL,'2020-11-09 14:36:26',NULL,NULL),('1325688700308975618',2,'online新增数据,保存失败，Field \'code\' doesn\'t have a default value',2,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'[\"6a56622058424a0e8bcc8b402ffc949d\",{\"create_by\":\"admin\",\"name_chs\":\"sfdsf\",\"name_eng\":\"sdfsd\",\"create_time\":\"2020-11-09 14:36:30\",\"sys_org_code\":\"A01\",\"id\":\"1325688700187340802\"},null]',NULL,30,NULL,'2020-11-09 14:36:31',NULL,NULL),('1325688718399008769',2,'online新增数据,保存失败，Field \'telephone\' doesn\'t have a default value',2,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'[\"6a56622058424a0e8bcc8b402ffc949d\",{\"create_by\":\"admin\",\"name_chs\":\"sfdsf\",\"name_eng\":\"sdfsd\",\"code\":\"sdfsdf\",\"create_time\":\"2020-11-09 14:36:35\",\"sys_org_code\":\"A01\",\"id\":\"1325688718281568258\"},null]',NULL,30,NULL,'2020-11-09 14:36:35',NULL,NULL),('1325688739353751554',2,'online新增数据,表名:iost_customer,操作成功！',2,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'[\"6a56622058424a0e8bcc8b402ffc949d\",{\"create_by\":\"admin\",\"name_chs\":\"sfdsf\",\"name_eng\":\"sdfsd\",\"code\":\"sdfsdf\",\"create_time\":\"2020-11-09 14:36:40\",\"sys_org_code\":\"A01\",\"telephone\":\"234234234\",\"id\":\"1325688738967875586\"},null]',NULL,91,NULL,'2020-11-09 14:36:40',NULL,NULL),('1325688740708511746',2,'online列表数据查询,表名:iost_customer,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,188,NULL,'2020-11-09 14:36:41',NULL,NULL),('1325688750154084353',2,'online表单数据查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,25,NULL,'2020-11-09 14:36:43',NULL,NULL),('1325688763965927426',2,'online修改数据,表名:iost_customer,修改成功！',3,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'[\"6a56622058424a0e8bcc8b402ffc949d\",{\"update_time\":\"2020-11-09 14:36:46\",\"name_chs\":\"sfdsf\",\"address\":\"\",\"name_eng\":\"sdfsd\",\"code\":\"sdfsdf\",\"vat\":\"\",\"company\":\"\",\"telephone\":\"sfsfsd\",\"id\":\"1325688738967875586\",\"imex_no\":\"\",\"update_by\":\"admin\",\"email\":\"\"}]',NULL,31,NULL,'2020-11-09 14:36:46',NULL,NULL),('1325688765253578753',2,'online列表数据查询,表名:iost_customer,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,64,NULL,'2020-11-09 14:36:46',NULL,NULL),('1325688937173905409',2,'online列表加载,表名:iost_customer,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,31,NULL,'2020-11-09 14:37:27',NULL,NULL),('1325688937341677570',2,'online表单加载,表名:iost_customer,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,33,NULL,'2020-11-09 14:37:27',NULL,NULL),('1325688938616745985',2,'online列表数据查询,表名:iost_customer,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,88,NULL,'2020-11-09 14:37:28',NULL,NULL),('1325688983139282946',2,'online列表数据查询,表名:iost_customer,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,36,NULL,'2020-11-09 14:37:38',NULL,NULL),('1325691484111900674',1,'用户名: admin,登录成功！',NULL,'admin','管理员','27.38.252.215',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-09 14:47:35',NULL,NULL),('1325694529363931137',2,'online列表加载,表名:iost_customer,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,30,NULL,'2020-11-09 14:59:41',NULL,NULL),('1325694529523314689',2,'online表单加载,表名:iost_customer,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,32,NULL,'2020-11-09 14:59:41',NULL,NULL),('1325694531222007809',2,'online列表数据查询,表名:iost_customer,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,118,NULL,'2020-11-09 14:59:41',NULL,NULL),('1325694572586233858',2,'online新增数据,保存失败，Field \'name_chs\' doesn\'t have a default value',2,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'[\"6a56622058424a0e8bcc8b402ffc949d\",{\"create_by\":\"admin\",\"create_time\":\"2020-11-09 14:59:50\",\"sys_org_code\":\"A01\",\"iost_customerlist\":[{\"id\":\"16049051813730472195\",\"address\":\"\",\"customer_id\":\"1325694572229718018\",\"address_default\":\"\",\"create_by\":\"admin\",\"create_time\":\"2020-11-09 14:59:50\",\"sys_org_code\":\"A01\"}],\"id\":\"1325694572229718018\"},null]',NULL,61,NULL,'2020-11-09 14:59:51',NULL,NULL),('1325694750756073474',2,'online列表加载,表名:iost_customer,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,33,NULL,'2020-11-09 15:00:33',NULL,NULL),('1325694750881902594',2,'online表单加载,表名:iost_customer,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,42,NULL,'2020-11-09 15:00:33',NULL,NULL),('1325694752228274178',2,'online列表数据查询,表名:iost_customer,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,78,NULL,'2020-11-09 15:00:34',NULL,NULL),('1325694796008419329',2,'online新增数据,保存失败，Field \'name_chs\' doesn\'t have a default value',2,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'[\"6a56622058424a0e8bcc8b402ffc949d\",{\"create_by\":\"admin\",\"create_time\":\"2020-11-09 15:00:44\",\"sys_org_code\":\"A01\",\"iost_customerlist\":[{\"id\":\"16049052327220996357\",\"address\":\"\",\"address_default\":\"N\",\"customer_id\":\"1325694795685457922\",\"create_by\":\"admin\",\"create_time\":\"2020-11-09 15:00:44\",\"sys_org_code\":\"A01\"}],\"id\":\"1325694795685457922\"},null]',NULL,80,NULL,'2020-11-09 15:00:44',NULL,NULL),('1325694847829045250',2,'online新增数据,表名:iost_customer,操作成功！',2,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'[\"6a56622058424a0e8bcc8b402ffc949d\",{\"create_by\":\"admin\",\"name_chs\":\"werw\",\"name_eng\":\"werew\",\"code\":\"werwer\",\"create_time\":\"2020-11-09 15:00:56\",\"sys_org_code\":\"A01\",\"telephone\":\"wer\",\"iost_customerlist\":[{\"id\":\"16049052476790977295\",\"address\":\"werwrwerwer\",\"address_default\":\"Y\",\"customer_id\":\"1325694847640301569\",\"create_by\":\"admin\",\"create_time\":\"2020-11-09 15:00:56\",\"sys_org_code\":\"A01\"}],\"id\":\"1325694847640301569\"},null]',NULL,46,NULL,'2020-11-09 15:00:57',NULL,NULL),('1325694849221554177',2,'online列表数据查询,表名:iost_customer,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,93,NULL,'2020-11-09 15:00:57',NULL,NULL),('1325694857652105218',2,'online表单数据查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,22,NULL,'2020-11-09 15:00:59',NULL,NULL),('1325695699163705346',2,'online列表加载,表名:iost_kind,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,25,NULL,'2020-11-09 15:04:20',NULL,NULL),('1325695699235008513',2,'online表单加载,表名:iost_kind,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,16,NULL,'2020-11-09 15:04:20',NULL,NULL),('1325695700744957953',2,'online列表数据查询,表名:iost_kind,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,94,NULL,'2020-11-09 15:04:20',NULL,NULL),('1325695747461115906',2,'online新增数据,表名:iost_kind,操作成功！',2,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'[\"caa8de52a4dd4c2e909582709619fa7d\",{\"create_by\":\"admin\",\"code\":\"001\",\"create_time\":\"2020-11-09 15:04:31\",\"sys_org_code\":\"A01\",\"name\":\"家电类\",\"id\":\"1325695747326898178\"},null]',NULL,32,NULL,'2020-11-09 15:04:31',NULL,NULL),('1325695748639715330',2,'online列表数据查询,表名:iost_kind,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,125,NULL,'2020-11-09 15:04:31',NULL,NULL),('1325695767576997890',2,'online表单数据查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,15,NULL,'2020-11-09 15:04:36',NULL,NULL),('1325695797234921473',2,'online删除数据,表名:iost_kind,删除成功!',4,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.f()',NULL,'',NULL,31,NULL,'2020-11-09 15:04:43',NULL,NULL),('1325695798086365186',2,'online列表数据查询,表名:iost_kind,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,31,NULL,'2020-11-09 15:04:43',NULL,NULL),('1325695844492144642',2,'online新增数据,表名:iost_kind,操作成功！',2,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'[\"caa8de52a4dd4c2e909582709619fa7d\",{\"create_by\":\"admin\",\"code\":\"001\",\"create_time\":\"2020-11-09 15:04:54\",\"sys_org_code\":\"A01\",\"name\":\"家电类\",\"id\":\"1325695844362121218\"},null]',NULL,31,NULL,'2020-11-09 15:04:54',NULL,NULL),('1325695845540720642',2,'online列表数据查询,表名:iost_kind,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,47,NULL,'2020-11-09 15:04:54',NULL,NULL),('1325698054106017793',2,'online列表加载,表名:iost_kind,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,34,NULL,'2020-11-09 15:13:41',NULL,NULL),('1325698054173126657',2,'online表单加载,表名:iost_kind,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,15,NULL,'2020-11-09 15:13:41',NULL,NULL),('1325698055418834945',2,'online列表数据查询,表名:iost_kind,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,109,NULL,'2020-11-09 15:13:41',NULL,NULL),('1325699169740550146',2,'online列表加载,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,29,NULL,'2020-11-09 15:18:07',NULL,NULL),('1325699169870573570',2,'online表单加载,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,109,NULL,'2020-11-09 15:18:07',NULL,NULL),('1325699171183390722',2,'online列表数据查询,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,94,NULL,'2020-11-09 15:18:07',NULL,NULL),('1325699345066651650',2,'online列表加载,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,15,NULL,'2020-11-09 15:18:49',NULL,NULL),('1325699345196675073',2,'online表单加载,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,15,NULL,'2020-11-09 15:18:49',NULL,NULL),('1325699346375274498',2,'online列表数据查询,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,78,NULL,'2020-11-09 15:18:49',NULL,NULL),('1325699386913222658',2,'online新增数据,表名:iost_price,操作成功！',2,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'[\"9d0da12274fb494f922b6135b998721f\",{\"create_by\":\"admin\",\"name_chs\":\"45645\",\"name_eng\":\"456456\",\"sys_org_code\":\"A01\",\"create_time\":\"2020-11-09 15:18:58\",\"kind\":\"001\",\"price\":56.6767,\"id\":\"1325699386779004930\"},null]',NULL,32,NULL,'2020-11-09 15:18:59',NULL,NULL),('1325699388288954370',2,'online列表数据查询,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,47,NULL,'2020-11-09 15:18:59',NULL,NULL),('1325699700663939074',2,'online表单加载,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,30,NULL,'2020-11-09 15:20:14',NULL,NULL),('1325699700663939075',2,'online列表加载,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,14,NULL,'2020-11-09 15:20:14',NULL,NULL),('1325699702236803073',2,'online列表数据查询,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,110,NULL,'2020-11-09 15:20:14',NULL,NULL),('1325699726056255490',2,'online列表数据查询,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,93,NULL,'2020-11-09 15:20:20',NULL,NULL),('1325699729860489218',2,'online列表数据查询,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,94,NULL,'2020-11-09 15:20:21',NULL,NULL),('1325699892758867969',2,'online列表加载,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,16,NULL,'2020-11-09 15:20:59',NULL,NULL),('1325699893136355329',2,'online表单加载,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,15,NULL,'2020-11-09 15:20:59',NULL,NULL),('1325699894646304770',2,'online列表数据查询,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,63,NULL,'2020-11-09 15:21:00',NULL,NULL),('1325700053157441538',2,'online列表加载,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,10,NULL,'2020-11-09 15:21:38',NULL,NULL),('1325700053224550401',2,'online表单加载,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,16,NULL,'2020-11-09 15:21:38',NULL,NULL),('1325700054990352385',2,'online列表数据查询,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,156,NULL,'2020-11-09 15:21:38',NULL,NULL),('1325700166772748290',2,'online表单加载,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,30,NULL,'2020-11-09 15:22:05',NULL,NULL),('1325700166772748291',2,'online列表加载,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,18,NULL,'2020-11-09 15:22:05',NULL,NULL),('1325700168542744578',2,'online列表数据查询,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,141,NULL,'2020-11-09 15:22:05',NULL,NULL),('1325703321757577218',2,'online列表加载,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,21,NULL,'2020-11-09 15:34:37',NULL,NULL),('1325703321824686082',2,'online表单加载,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,18,NULL,'2020-11-09 15:34:37',NULL,NULL),('1325703323682762754',2,'online列表数据查询,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,157,NULL,'2020-11-09 15:34:37',NULL,NULL),('1325703856309039106',2,'online列表加载,表名:iost_receiving,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,18,NULL,'2020-11-09 15:36:44',NULL,NULL),('1325703856413896705',2,'online表单加载,表名:iost_receiving,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,23,NULL,'2020-11-09 15:36:44',NULL,NULL),('1325703857718325249',2,'online列表数据查询,表名:iost_receiving,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,101,NULL,'2020-11-09 15:36:45',NULL,NULL),('1325703958784274434',2,'online表单加载,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,31,NULL,'2020-11-09 15:37:09',NULL,NULL),('1325703958826217473',2,'online列表加载,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,19,NULL,'2020-11-09 15:37:09',NULL,NULL),('1325703960273252353',2,'online列表数据查询,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,51,NULL,'2020-11-09 15:37:09',NULL,NULL),('1325705515890274306',2,'online列表加载,表名:iost_receiving,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,27,NULL,'2020-11-09 15:43:20',NULL,NULL),('1325705515969966082',2,'online表单加载,表名:iost_receiving,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,89,NULL,'2020-11-09 15:43:20',NULL,NULL),('1325705516968210434',2,'online列表数据查询,表名:iost_receiving,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,42,NULL,'2020-11-09 15:43:20',NULL,NULL),('1325708091272622082',2,'online列表加载,表名:iost_receiving,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,27,NULL,'2020-11-09 15:53:34',NULL,NULL),('1325708091381673986',2,'online表单加载,表名:iost_receiving,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,31,NULL,'2020-11-09 15:53:34',NULL,NULL),('1325708092178591745',2,'online列表数据查询,表名:iost_receiving,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,33,NULL,'2020-11-09 15:53:34',NULL,NULL),('1325708197065551873',2,'online列表加载,表名:iost_receiving,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,15,NULL,'2020-11-09 15:53:59',NULL,NULL),('1325708197120077825',2,'online表单加载,表名:iost_receiving,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,46,NULL,'2020-11-09 15:53:59',NULL,NULL),('1325708198474838018',2,'online列表数据查询,表名:iost_receiving,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,29,NULL,'2020-11-09 15:54:00',NULL,NULL),('1325708327797813250',2,'online新增数据,表名:iost_receiving,操作成功！',2,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'[\"dd396a66386745c4993dc5c941c07a2e\",{\"create_by\":\"admin\",\"iost_receivinglist\":[{\"id\":\"16049084450250139810\",\"name_chs\":\"\",\"name_eng\":\"\",\"unit\":\"\",\"packages\":\"\",\"packages_total\":\"\",\"length\":\"\",\"width\":\"\",\"height\":\"\",\"volume\":\"\",\"volume_total\":\"\",\"weight\":\"\",\"weight_total\":\"\",\"material\":\"\",\"price\":\"\",\"money\":\"\",\"kind\":\"\",\"picture\":\"上传失败！\",\"receiving_id\":\"1325708327592292353\",\"create_time\":\"2020-11-09 15:54:30\",\"create_by\":\"admin\",\"sys_org_code\":\"A01\"}],\"sys_org_code\":\"A01\",\"create_time\":\"2020-11-09 15:54:30\",\"id\":\"1325708327592292353\"},null]',NULL,75,NULL,'2020-11-09 15:54:31',NULL,NULL),('1325708328536010753',2,'online列表数据查询,表名:iost_receiving,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,109,NULL,'2020-11-09 15:54:31',NULL,NULL),('1325709559056723970',2,'online列表加载,表名:iost_receiving,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,15,NULL,'2020-11-09 15:59:24',NULL,NULL),('1325709559081889793',2,'online表单加载,表名:iost_receiving,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,58,NULL,'2020-11-09 15:59:24',NULL,NULL),('1325709560713474049',2,'online列表数据查询,表名:iost_receiving,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,104,NULL,'2020-11-09 15:59:24',NULL,NULL),('1325710867876704257',2,'online列表加载,表名:iost_storage,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,30,NULL,'2020-11-09 16:04:36',NULL,NULL),('1325710867943813122',2,'online表单加载,表名:iost_storage,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,16,NULL,'2020-11-09 16:04:36',NULL,NULL),('1325710869189521409',2,'online列表数据查询,表名:iost_storage,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,94,NULL,'2020-11-09 16:04:36',NULL,NULL),('1325711079852634114',2,'online表单加载,表名:iost_customer,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,47,NULL,'2020-11-09 16:05:27',NULL,NULL),('1325711080511139841',2,'online列表加载,表名:iost_customer,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,6,NULL,'2020-11-09 16:05:27',NULL,NULL),('1325711081953980418',2,'online列表数据查询,表名:iost_customer,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,94,NULL,'2020-11-09 16:05:27',NULL,NULL),('1325711236006572034',2,'online列表加载,表名:iost_kind,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,23,NULL,'2020-11-09 16:06:04',NULL,NULL),('1325711236006572035',2,'online表单加载,表名:iost_kind,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,2,NULL,'2020-11-09 16:06:04',NULL,NULL),('1325711237969506306',2,'online列表数据查询,表名:iost_kind,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,109,NULL,'2020-11-09 16:06:04',NULL,NULL),('1325711455972651010',2,'online列表加载,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,31,NULL,'2020-11-09 16:06:56',NULL,NULL),('1325711455981039617',2,'online表单加载,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,33,NULL,'2020-11-09 16:06:56',NULL,NULL),('1325711457683927042',2,'online列表数据查询,表名:iost_price,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,62,NULL,'2020-11-09 16:06:57',NULL,NULL),('1325718491615621122',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','27.38.244.216',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-09 16:34:54',NULL,NULL),('1325718572364361730',1,'用户名: admin,登录成功！',NULL,'admin','管理员','27.38.244.216',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-09 16:35:13',NULL,NULL),('1325725815228338177',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','27.38.244.216',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-09 17:04:00',NULL,NULL),('1325725892000878594',1,'用户名: admin,登录成功！',NULL,'admin','管理员','27.38.244.216',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-09 17:04:18',NULL,NULL),('1325727890493042689',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','220.115.53.100',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-09 17:12:15',NULL,NULL),('1325727954565230593',1,'用户名: admin,登录成功！',NULL,'admin','管理员','220.115.53.100',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-09 17:12:30',NULL,NULL),('1325727955481006081',2,'入仓单-分页列表查询',1,'admin','管理员','27.38.244.216','org.jeecg.modules.iost.basedata.controller.IostReceivingController.queryPageList()',NULL,'  iostReceiving: IostReceiving(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, receivingNo=null, deliveryFactory=null, warehouseName=null, customerName=null, deliveryMan=null, packagesTotal=null, customerCode=null, telephone=null, date=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@13253bc3',NULL,198,NULL,'2020-11-09 17:12:30',NULL,NULL),('1325727977715011585',2,'入仓列表通过主表ID查询',1,'admin','管理员','27.38.244.216','org.jeecg.modules.iost.basedata.controller.IostReceivingController.queryIostReceivinglistListByMainId()',NULL,'  id: 1325708327592292353',NULL,70,NULL,'2020-11-09 17:12:35',NULL,NULL),('1325728075941416962',2,'入仓单-编辑',3,'admin','管理员','27.38.244.216','org.jeecg.modules.iost.basedata.controller.IostReceivingController.edit()',NULL,'[{\"createBy\":\"admin\",\"createTime\":1604908470000,\"deliveryFactory\":\"sdsd\",\"id\":\"1325708327592292353\",\"iostReceivinglistList\":[{\"createBy\":\"admin\",\"createTime\":1604913178475,\"id\":\"16049084450250139810\",\"kind\":\"001\",\"material\":\"\",\"nameChs\":\"dssd\",\"nameEng\":\"sdsdsd\",\"picture\":\"ä¸\\u008Aä¼ å¤±è´¥ï¼\\u0081\",\"receivingId\":\"1325708327592292353\",\"sysOrgCode\":\"A01\",\"unit\":\"\"}],\"receivingNo\":\"sdsd\",\"sysOrgCode\":\"A01\"}]',NULL,249,NULL,'2020-11-09 17:12:59',NULL,NULL),('1325728076931272705',2,'入仓单-分页列表查询',1,'admin','管理员','27.38.244.216','org.jeecg.modules.iost.basedata.controller.IostReceivingController.queryPageList()',NULL,'  iostReceiving: IostReceiving(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, receivingNo=null, deliveryFactory=null, warehouseName=null, customerName=null, deliveryMan=null, packagesTotal=null, customerCode=null, telephone=null, date=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@3de4746',NULL,86,NULL,'2020-11-09 17:12:59',NULL,NULL),('1325728088004235266',2,'仓库管理-分页列表查询',1,'admin','管理员','27.38.244.216','org.jeecg.modules.iost.basedata.controller.IostStorageController.queryPageList()',NULL,'  iostStorage: IostStorage(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, name=null, address=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@1ade370d',NULL,135,NULL,'2020-11-09 17:13:02',NULL,NULL),('1325728101228875777',2,'客户管理-分页列表查询',1,'admin','管理员','27.38.244.216','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryPageList()',NULL,'  iostCustomer: IostCustomer(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, nameChs=null, nameEng=null, company=null, code=null, address=null, telephone=null, email=null, vat=null, imexNo=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@48089a33',NULL,167,NULL,'2020-11-09 17:13:05',NULL,NULL),('1325728109114167297',2,'商品类别-分页列表查询',1,'admin','管理员','27.38.244.216','org.jeecg.modules.iost.basedata.controller.IostKindController.queryPageList()',NULL,'  iostKind: IostKind(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, code=null, name=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@73911bb9',NULL,112,NULL,'2020-11-09 17:13:07',NULL,NULL),('1325728114453516289',2,'价格维护-分页列表查询',1,'admin','管理员','27.38.244.216','org.jeecg.modules.iost.basedata.controller.IostPriceController.queryPageList()',NULL,'  iostPrice: IostPrice(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, kind=null, nameChs=null, nameEng=null, price=null, description=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@753b7dad',NULL,146,NULL,'2020-11-09 17:13:08',NULL,NULL),('1325728262504058881',2,'商品类别-分页列表查询',1,'admin','管理员','27.38.244.216','org.jeecg.modules.iost.basedata.controller.IostKindController.queryPageList()',NULL,'  iostKind: IostKind(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, code=null, name=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@1db1a892',NULL,81,NULL,'2020-11-09 17:13:43',NULL,NULL),('1325728282703826945',2,'客户管理-分页列表查询',1,'admin','管理员','27.38.244.216','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryPageList()',NULL,'  iostCustomer: IostCustomer(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, nameChs=null, nameEng=null, company=null, code=null, address=null, telephone=null, email=null, vat=null, imexNo=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@623c8b75',NULL,62,NULL,'2020-11-09 17:13:48',NULL,NULL),('1325728294435295234',2,'送货地址通过主表ID查询',1,'admin','管理员','27.38.244.216','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryIostCustomerlistListByMainId()',NULL,'  id: 1325694847640301569',NULL,53,NULL,'2020-11-09 17:13:51',NULL,NULL),('1325728922284855298',1,'用户登录失败，用户不存在！',NULL,NULL,NULL,'220.115.53.100',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-09 17:16:21',NULL,NULL),('1325728963057684482',1,'用户名: admin,登录成功！',NULL,'admin','管理员','220.115.53.100',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-09 17:16:30',NULL,NULL),('1325729005780865026',2,'价格维护-分页列表查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostPriceController.queryPageList()',NULL,'  iostPrice: IostPrice(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, kind=null, nameChs=null, nameEng=null, price=null, description=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@4395e8ce',NULL,102,NULL,'2020-11-09 17:16:40',NULL,NULL),('1325729054233464833',2,'仓库管理-分页列表查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostStorageController.queryPageList()',NULL,'  iostStorage: IostStorage(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, name=null, address=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@78632bef',NULL,59,NULL,'2020-11-09 17:16:52',NULL,NULL),('1325729105236201474',2,'仓库管理-添加',2,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostStorageController.add()',NULL,'[{\"createBy\":\"admin\",\"createTime\":1604913424143,\"id\":\"1325729105001320450\",\"name\":\"深圳仓库\",\"sysOrgCode\":\"A01\"}]',NULL,22,NULL,'2020-11-09 17:17:04',NULL,NULL),('1325729106679042050',2,'仓库管理-分页列表查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostStorageController.queryPageList()',NULL,'  iostStorage: IostStorage(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, name=null, address=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@748bae3e',NULL,69,NULL,'2020-11-09 17:17:05',NULL,NULL),('1325729119878516737',2,'价格维护-分页列表查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostPriceController.queryPageList()',NULL,'  iostPrice: IostPrice(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, kind=null, nameChs=null, nameEng=null, price=null, description=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@7a9de015',NULL,71,NULL,'2020-11-09 17:17:08',NULL,NULL),('1325729124785852418',2,'客户管理-分页列表查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryPageList()',NULL,'  iostCustomer: IostCustomer(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, nameChs=null, nameEng=null, company=null, code=null, address=null, telephone=null, email=null, vat=null, imexNo=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@267435c4',NULL,74,NULL,'2020-11-09 17:17:09',NULL,NULL),('1325729155098087426',2,'送货地址通过主表ID查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryIostCustomerlistListByMainId()',NULL,'  id: 1325694847640301569',NULL,10,NULL,'2020-11-09 17:17:16',NULL,NULL),('1325729193052344322',2,'客户管理-编辑',3,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.edit()',NULL,'[{\"address\":\"adfafaf\",\"code\":\"werwer\",\"company\":\"werwer\",\"createBy\":\"admin\",\"createTime\":1604905256000,\"email\":\"234\",\"id\":\"1325694847640301569\",\"imexNo\":\"234234\",\"iostCustomerlistList\":[{\"address\":\"werwrwerwer\",\"addressDefault\":\"Y\",\"createBy\":\"admin\",\"createTime\":1604913445047,\"customerId\":\"1325694847640301569\",\"id\":\"16049052476790977295\",\"sysOrgCode\":\"A01\"}],\"nameChs\":\"werw\",\"nameEng\":\"werew\",\"sysOrgCode\":\"A01\",\"telephone\":\"wer\",\"vat\":\"24234\"}]',NULL,89,NULL,'2020-11-09 17:17:25',NULL,NULL),('1325729195300491266',2,'客户管理-分页列表查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryPageList()',NULL,'  iostCustomer: IostCustomer(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, nameChs=null, nameEng=null, company=null, code=null, address=null, telephone=null, email=null, vat=null, imexNo=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@70099125',NULL,106,NULL,'2020-11-09 17:17:26',NULL,NULL),('1325729203269668866',2,'送货地址通过主表ID查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryIostCustomerlistListByMainId()',NULL,'  id: 1325694847640301569',NULL,10,NULL,'2020-11-09 17:17:28',NULL,NULL),('1325729231082098689',2,'客户管理-编辑',3,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.edit()',NULL,'[{\"address\":\"adfafaf\",\"code\":\"werwer\",\"company\":\"werwer\",\"createBy\":\"admin\",\"createTime\":1604905256000,\"email\":\"234\",\"id\":\"1325694847640301569\",\"imexNo\":\"234234\",\"iostCustomerlistList\":[{\"address\":\"werwrwerwer\",\"addressDefault\":\"Y\",\"createBy\":\"admin\",\"createTime\":1604913454173,\"customerId\":\"1325694847640301569\",\"id\":\"16049052476790977295\",\"sysOrgCode\":\"A01\"},{\"address\":\"dfsdfsdfds\",\"addressDefault\":\"false\",\"createBy\":\"admin\",\"createTime\":1604913454179,\"customerId\":\"1325694847640301569\",\"id\":\"16049134439381966900\",\"sysOrgCode\":\"A01\"}],\"nameChs\":\"werw\",\"nameEng\":\"werew\",\"sysOrgCode\":\"A01\",\"telephone\":\"wer\",\"updateBy\":\"admin\",\"updateTime\":1604913445000,\"vat\":\"24234\"}]',NULL,58,NULL,'2020-11-09 17:17:34',NULL,NULL),('1325729231962902530',2,'客户管理-分页列表查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryPageList()',NULL,'  iostCustomer: IostCustomer(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, nameChs=null, nameEng=null, company=null, code=null, address=null, telephone=null, email=null, vat=null, imexNo=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@70e792c8',NULL,53,NULL,'2020-11-09 17:17:34',NULL,NULL),('1325729238409547778',2,'送货地址通过主表ID查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryIostCustomerlistListByMainId()',NULL,'  id: 1325694847640301569',NULL,14,NULL,'2020-11-09 17:17:36',NULL,NULL),('1325729251940372482',2,'客户管理-编辑',3,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.edit()',NULL,'[{\"address\":\"adfafaf\",\"code\":\"werwer\",\"company\":\"werwer\",\"createBy\":\"admin\",\"createTime\":1604905256000,\"email\":\"234\",\"id\":\"1325694847640301569\",\"imexNo\":\"234234\",\"iostCustomerlistList\":[{\"address\":\"werwrwerwer\",\"addressDefault\":\"Y\",\"createBy\":\"admin\",\"createTime\":1604913459163,\"customerId\":\"1325694847640301569\",\"id\":\"16049052476790977295\",\"sysOrgCode\":\"A01\"},{\"address\":\"dfsdfsdfds\",\"addressDefault\":\"false\",\"createBy\":\"admin\",\"createTime\":1604913459171,\"customerId\":\"1325694847640301569\",\"id\":\"16049134439381966900\",\"sysOrgCode\":\"A01\"}],\"nameChs\":\"werw\",\"nameEng\":\"werew\",\"sysOrgCode\":\"A01\",\"telephone\":\"wer\",\"updateBy\":\"admin\",\"updateTime\":1604913454000,\"vat\":\"24234\"}]',NULL,69,NULL,'2020-11-09 17:17:39',NULL,NULL),('1325729253026697217',2,'客户管理-分页列表查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryPageList()',NULL,'  iostCustomer: IostCustomer(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, nameChs=null, nameEng=null, company=null, code=null, address=null, telephone=null, email=null, vat=null, imexNo=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@609801f7',NULL,77,NULL,'2020-11-09 17:17:39',NULL,NULL),('1325729259192324098',2,'送货地址通过主表ID查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryIostCustomerlistListByMainId()',NULL,'  id: 1325694847640301569',NULL,7,NULL,'2020-11-09 17:17:41',NULL,NULL),('1325729270286258178',2,'客户管理-编辑',3,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.edit()',NULL,'[{\"address\":\"adfafaf\",\"code\":\"werwer\",\"company\":\"werwer\",\"createBy\":\"admin\",\"createTime\":1604905256000,\"email\":\"234\",\"id\":\"1325694847640301569\",\"imexNo\":\"234234\",\"iostCustomerlistList\":[{\"address\":\"werwrwerwer\",\"addressDefault\":\"Y\",\"createBy\":\"admin\",\"createTime\":1604913463530,\"customerId\":\"1325694847640301569\",\"id\":\"16049052476790977295\",\"sysOrgCode\":\"A01\"},{\"address\":\"dfsdfsdfds\",\"addressDefault\":\"false\",\"createBy\":\"admin\",\"createTime\":1604913463543,\"customerId\":\"1325694847640301569\",\"id\":\"16049134439381966900\",\"sysOrgCode\":\"A01\"}],\"nameChs\":\"werw\",\"nameEng\":\"werew\",\"sysOrgCode\":\"A01\",\"telephone\":\"wer\",\"updateBy\":\"admin\",\"updateTime\":1604913459000,\"vat\":\"24234\"}]',NULL,59,NULL,'2020-11-09 17:17:44',NULL,NULL),('1325729271137701890',2,'客户管理-分页列表查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryPageList()',NULL,'  iostCustomer: IostCustomer(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, nameChs=null, nameEng=null, company=null, code=null, address=null, telephone=null, email=null, vat=null, imexNo=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@425acb1b',NULL,56,NULL,'2020-11-09 17:17:44',NULL,NULL),('1325729276393164802',2,'送货地址通过主表ID查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryIostCustomerlistListByMainId()',NULL,'  id: 1325694847640301569',NULL,13,NULL,'2020-11-09 17:17:45',NULL,NULL),('1325729288644726785',2,'客户管理-编辑',3,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.edit()',NULL,'[{\"address\":\"adfafaf\",\"code\":\"werwer\",\"company\":\"werwer\",\"createBy\":\"admin\",\"createTime\":1604905256000,\"email\":\"234\",\"id\":\"1325694847640301569\",\"imexNo\":\"234234\",\"iostCustomerlistList\":[{\"address\":\"werwrwerwer\",\"addressDefault\":\"Y\",\"createBy\":\"admin\",\"createTime\":1604913467921,\"customerId\":\"1325694847640301569\",\"id\":\"16049052476790977295\",\"sysOrgCode\":\"A01\"},{\"address\":\"dfsdfsdfds\",\"addressDefault\":\"false\",\"createBy\":\"admin\",\"createTime\":1604913467923,\"customerId\":\"1325694847640301569\",\"id\":\"16049134439381966900\",\"sysOrgCode\":\"A01\"}],\"nameChs\":\"werw\",\"nameEng\":\"werew\",\"sysOrgCode\":\"A01\",\"telephone\":\"wer\",\"updateBy\":\"admin\",\"updateTime\":1604913464000,\"vat\":\"24234\"}]',NULL,20,NULL,'2020-11-09 17:17:48',NULL,NULL),('1325729289647165441',2,'客户管理-分页列表查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryPageList()',NULL,'  iostCustomer: IostCustomer(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, nameChs=null, nameEng=null, company=null, code=null, address=null, telephone=null, email=null, vat=null, imexNo=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@121efa80',NULL,45,NULL,'2020-11-09 17:17:48',NULL,NULL),('1325729295720517634',2,'送货地址通过主表ID查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryIostCustomerlistListByMainId()',NULL,'  id: 1325694847640301569',NULL,8,NULL,'2020-11-09 17:17:50',NULL,NULL),('1325729439727751169',2,'送货地址通过主表ID查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryIostCustomerlistListByMainId()',NULL,'  id: 1325694847640301569',NULL,14,NULL,'2020-11-09 17:18:24',NULL,NULL),('1325729453329879041',2,'客户管理-编辑',3,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.edit()',NULL,'[{\"address\":\"adfafaf\",\"code\":\"werwer\",\"company\":\"werwer\",\"createBy\":\"admin\",\"createTime\":1604905256000,\"email\":\"234\",\"id\":\"1325694847640301569\",\"imexNo\":\"234234\",\"iostCustomerlistList\":[{\"address\":\"werwrwerwer\",\"addressDefault\":\"Y\",\"createBy\":\"admin\",\"createTime\":1604913507186,\"customerId\":\"1325694847640301569\",\"id\":\"16049052476790977295\",\"sysOrgCode\":\"A01\"},{\"address\":\"dfsdfsdfds\",\"addressDefault\":\"false\",\"createBy\":\"admin\",\"createTime\":1604913507188,\"customerId\":\"1325694847640301569\",\"id\":\"16049134439381966900\",\"sysOrgCode\":\"A01\"}],\"nameChs\":\"werw\",\"nameEng\":\"werew\",\"sysOrgCode\":\"A01\",\"telephone\":\"wer\",\"updateBy\":\"admin\",\"updateTime\":1604913468000,\"vat\":\"24234\"}]',NULL,29,NULL,'2020-11-09 17:18:27',NULL,NULL),('1325729455414448130',2,'客户管理-分页列表查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryPageList()',NULL,'  iostCustomer: IostCustomer(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, nameChs=null, nameEng=null, company=null, code=null, address=null, telephone=null, email=null, vat=null, imexNo=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@fedf793',NULL,77,NULL,'2020-11-09 17:18:28',NULL,NULL),('1325729462511210498',2,'送货地址通过主表ID查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryIostCustomerlistListByMainId()',NULL,'  id: 1325694847640301569',NULL,7,NULL,'2020-11-09 17:18:29',NULL,NULL),('1325729478009163777',2,'商品类别-分页列表查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostKindController.queryPageList()',NULL,'  iostKind: IostKind(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, code=null, name=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@713ffaf8',NULL,56,NULL,'2020-11-09 17:18:33',NULL,NULL),('1325729539547992065',2,'商品类别-添加',2,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostKindController.add()',NULL,'[{\"code\":\"002\",\"createBy\":\"admin\",\"createTime\":1604913527714,\"id\":\"1325729539405385730\",\"name\":\"装修类\",\"sysOrgCode\":\"A01\"}]',NULL,16,NULL,'2020-11-09 17:18:48',NULL,NULL),('1325729540646899714',2,'商品类别-分页列表查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostKindController.queryPageList()',NULL,'  iostKind: IostKind(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, code=null, name=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@15fe9d21',NULL,57,NULL,'2020-11-09 17:18:48',NULL,NULL),('1325729697094438913',2,'送货地址通过主表ID查询',1,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryIostCustomerlistListByMainId()',NULL,'  id: 1325694847640301569',NULL,14,NULL,'2020-11-09 17:19:25',NULL,NULL),('1325729711984218114',2,'客户管理-编辑',3,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostCustomerController.edit()',NULL,'[{\"code\":\"werwer\",\"createBy\":\"admin\",\"createTime\":1604905256000,\"id\":\"1325694847640301569\",\"iostCustomerlistList\":[{\"address\":\"werwrwerwer\",\"addressDefault\":\"false\",\"createBy\":\"admin\",\"createTime\":1604913568837,\"customerId\":\"1325694847640301569\",\"id\":\"16049052476790977295\",\"sysOrgCode\":\"A01\"},{\"address\":\"dfsdfsdfds\",\"addressDefault\":\"false\",\"createBy\":\"admin\",\"createTime\":1604913568846,\"customerId\":\"1325694847640301569\",\"id\":\"16049134439381966900\",\"sysOrgCode\":\"A01\"}],\"nameChs\":\"werw\",\"nameEng\":\"werew\",\"sysOrgCode\":\"A01\",\"telephone\":\"wer\"}]',NULL,62,NULL,'2020-11-09 17:19:29',NULL,NULL),('1325729712856633345',2,'客户管理-分页列表查询',1,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryPageList()',NULL,'  iostCustomer: IostCustomer(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, nameChs=null, nameEng=null, company=null, code=null, address=null, telephone=null, email=null, vat=null, imexNo=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@5c0c095b',NULL,60,NULL,'2020-11-09 17:19:29',NULL,NULL),('1325729718913208321',2,'送货地址通过主表ID查询',1,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryIostCustomerlistListByMainId()',NULL,'  id: 1325694847640301569',NULL,14,NULL,'2020-11-09 17:19:31',NULL,NULL),('1325729732930572289',2,'客户管理-编辑',3,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostCustomerController.edit()',NULL,'[{\"address\":\"adfafaf\",\"code\":\"werwer\",\"company\":\"werwer\",\"createBy\":\"admin\",\"createTime\":1604905256000,\"email\":\"234\",\"id\":\"1325694847640301569\",\"imexNo\":\"234234\",\"iostCustomerlistList\":[{\"address\":\"werwrwerwer\",\"addressDefault\":\"false\",\"createBy\":\"admin\",\"createTime\":1604913573847,\"customerId\":\"1325694847640301569\",\"id\":\"16049052476790977295\",\"sysOrgCode\":\"A01\"},{\"address\":\"dfsdfsdfds\",\"addressDefault\":\"false\",\"createBy\":\"admin\",\"createTime\":1604913573851,\"customerId\":\"1325694847640301569\",\"id\":\"16049134439381966900\",\"sysOrgCode\":\"A01\"}],\"nameChs\":\"werw\",\"nameEng\":\"werew\",\"sysOrgCode\":\"A01\",\"telephone\":\"wer\",\"updateBy\":\"admin\",\"updateTime\":1604913569000,\"vat\":\"24234\"}]',NULL,31,NULL,'2020-11-09 17:19:34',NULL,NULL),('1325729733723295746',2,'客户管理-分页列表查询',1,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryPageList()',NULL,'  iostCustomer: IostCustomer(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, nameChs=null, nameEng=null, company=null, code=null, address=null, telephone=null, email=null, vat=null, imexNo=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@1bbf6536',NULL,41,NULL,'2020-11-09 17:19:34',NULL,NULL),('1325729740673257473',2,'送货地址通过主表ID查询',1,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryIostCustomerlistListByMainId()',NULL,'  id: 1325694847640301569',NULL,12,NULL,'2020-11-09 17:19:36',NULL,NULL),('1325729786928041986',2,'客户管理-编辑',3,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostCustomerController.edit()',NULL,'[{\"address\":\"adfafaf\",\"code\":\"werwer\",\"company\":\"werwer\",\"createBy\":\"admin\",\"createTime\":1604905256000,\"email\":\"234\",\"id\":\"1325694847640301569\",\"imexNo\":\"234234\",\"nameChs\":\"werw\",\"nameEng\":\"werew\",\"sysOrgCode\":\"A01\",\"telephone\":\"wer\",\"updateBy\":\"admin\",\"updateTime\":1604913574000,\"vat\":\"24234\"}]',NULL,49,NULL,'2020-11-09 17:19:47',NULL,NULL),('1325729787687211009',2,'客户管理-分页列表查询',1,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryPageList()',NULL,'  iostCustomer: IostCustomer(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, nameChs=null, nameEng=null, company=null, code=null, address=null, telephone=null, email=null, vat=null, imexNo=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@3139f477',NULL,51,NULL,'2020-11-09 17:19:47',NULL,NULL),('1325729794830110722',2,'送货地址通过主表ID查询',1,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryIostCustomerlistListByMainId()',NULL,'  id: 1325694847640301569',NULL,8,NULL,'2020-11-09 17:19:49',NULL,NULL),('1325729800337231874',2,'价格维护-分页列表查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostPriceController.queryPageList()',NULL,'  iostPrice: IostPrice(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, kind=null, nameChs=null, nameEng=null, price=null, description=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@2ef42549',NULL,80,NULL,'2020-11-09 17:19:50',NULL,NULL),('1325730176906039297',2,'价格维护-添加',2,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostPriceController.add()',NULL,'[{\"createBy\":\"admin\",\"createTime\":1604913679581,\"description\":\"asdfafdadfaf\",\"id\":\"1325730176381751298\",\"kind\":\"002\",\"nameChs\":\"装修\",\"nameEng\":\"sjfksa\",\"price\":34.988,\"sysOrgCode\":\"A01\"}]',NULL,17,NULL,'2020-11-09 17:21:20',NULL,NULL),('1325730178562789377',2,'价格维护-分页列表查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostPriceController.queryPageList()',NULL,'  iostPrice: IostPrice(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, kind=null, nameChs=null, nameEng=null, price=null, description=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@195bbb5d',NULL,83,NULL,'2020-11-09 17:21:20',NULL,NULL),('1325730222498123777',2,'价格维护-编辑',3,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostPriceController.edit()',NULL,'[{\"createBy\":\"admin\",\"createTime\":1604913680000,\"description\":\"asdfafdadfaf\",\"id\":\"1325730176381751298\",\"kind\":\"002\",\"nameChs\":\"装修\",\"nameEng\":\"sjfksa\",\"price\":34.988,\"sysOrgCode\":\"A01\",\"updateBy\":\"admin\",\"updateTime\":1604913690556}]',NULL,21,NULL,'2020-11-09 17:21:31',NULL,NULL),('1325730223953547265',2,'价格维护-分页列表查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostPriceController.queryPageList()',NULL,'  iostPrice: IostPrice(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, kind=null, nameChs=null, nameEng=null, price=null, description=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@3d3935bb',NULL,58,NULL,'2020-11-09 17:21:31',NULL,NULL),('1325730304320606210',2,'送货地址通过主表ID查询',1,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryIostCustomerlistListByMainId()',NULL,'  id: 1325694847640301569',NULL,6,NULL,'2020-11-09 17:21:50',NULL,NULL),('1325743962847866882',1,'用户名: admin,登录成功！',NULL,'admin','管理员','220.115.53.100',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-09 18:16:07',NULL,NULL),('1325771664960524289',1,'用户名: admin,登录成功！',NULL,'admin','管理员','27.38.244.217',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-09 20:06:11',NULL,NULL),('1325772624931852289',2,'入仓单-分页列表查询',1,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostReceivingController.queryPageList()',NULL,'  iostReceiving: IostReceiving(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, receivingNo=null, deliveryFactory=null, warehouseName=null, customerName=null, deliveryMan=null, packagesTotal=null, customerCode=null, telephone=null, date=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@7af9b4ec',NULL,133,NULL,'2020-11-09 20:10:00',NULL,NULL),('1325845538627284994',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','27.38.244.216',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-10 00:59:44',NULL,NULL),('1325846250983682050',1,'用户名: admin,登录成功！',NULL,'admin','管理员','27.38.244.217',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-10 01:02:34',NULL,NULL),('1325950946670964737',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','220.115.53.100',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-10 07:58:35',NULL,NULL),('1325950994817380353',1,'用户名: admin,登录成功！',NULL,'admin','管理员','220.115.53.100',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-10 07:58:47',NULL,NULL),('1325956157883969538',2,'online表单加载,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,30,NULL,'2020-11-10 08:19:18',NULL,NULL),('1325956157951078401',2,'online列表加载,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,46,NULL,'2020-11-10 08:19:18',NULL,NULL),('1325956159523942401',2,'online列表数据查询,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,94,NULL,'2020-11-10 08:19:18',NULL,NULL),('1325956374486216706',2,'online列表加载,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,39,NULL,'2020-11-10 08:20:09',NULL,NULL),('1325956374486216707',2,'online表单加载,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,40,NULL,'2020-11-10 08:20:09',NULL,NULL),('1325956376126189569',2,'online列表数据查询,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,36,NULL,'2020-11-10 08:20:10',NULL,NULL),('1325956526986915841',2,'online列表加载,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,31,NULL,'2020-11-10 08:20:46',NULL,NULL),('1325956527020470274',2,'online表单加载,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,23,NULL,'2020-11-10 08:20:46',NULL,NULL),('1325956528190681090',2,'online列表数据查询,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,67,NULL,'2020-11-10 08:20:46',NULL,NULL),('1325956698336817154',2,'online表单加载,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,30,NULL,'2020-11-10 08:21:27',NULL,NULL),('1325956698366177282',2,'online列表加载,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,18,NULL,'2020-11-10 08:21:27',NULL,NULL),('1325956699439919105',2,'online列表数据查询,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,74,NULL,'2020-11-10 08:21:27',NULL,NULL),('1325956794751283202',2,'online表单加载,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,27,NULL,'2020-11-10 08:21:50',NULL,NULL),('1325956794860335106',2,'online列表加载,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,29,NULL,'2020-11-10 08:21:50',NULL,NULL),('1325956796185735169',2,'online列表数据查询,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,30,NULL,'2020-11-10 08:21:50',NULL,NULL),('1325956875311280130',2,'online列表加载,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,31,NULL,'2020-11-10 08:22:09',NULL,NULL),('1325956875403554818',2,'online表单加载,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,28,NULL,'2020-11-10 08:22:09',NULL,NULL),('1325956876552794114',2,'online列表数据查询,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,28,NULL,'2020-11-10 08:22:09',NULL,NULL),('1325957003111723010',2,'online表单加载,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,19,NULL,'2020-11-10 08:22:39',NULL,NULL),('1325957003111723011',2,'online列表加载,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,24,NULL,'2020-11-10 08:22:39',NULL,NULL),('1325957004890107905',2,'online列表数据查询,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,123,NULL,'2020-11-10 08:22:40',NULL,NULL),('1325961945629224962',2,'online列表加载,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,45,NULL,'2020-11-10 08:42:18',NULL,NULL),('1325961945826357250',2,'online表单加载,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,64,NULL,'2020-11-10 08:42:18',NULL,NULL),('1325961948519100417',2,'online列表数据查询,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,46,NULL,'2020-11-10 08:42:18',NULL,NULL),('1325962124168163330',2,'online新增数据,表名:iost_inventory_record,操作成功！',2,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'[\"61328d3127024a9b99298eded991106c\",{\"create_by\":\"admin\",\"create_time\":\"2020-11-10 08:43:00\",\"sys_org_code\":\"A01\",\"iost_inventory_record_list\":[{\"id\":\"16049689359140283211\",\"name_chs\":\"dfsd\",\"name_eng\":\"sdfsdf\",\"unit\":\"fsdf\",\"packages\":\"34.78\",\"packages_total\":\"677.78\",\"length\":\"6778\",\"width\":\"5657.676\",\"height\":\"65756\",\"volume\":\"57656.67\",\"volume_total\":\"56566.565\",\"weight\":\"456.76546\",\"weight_total\":\"456456.7465\",\"material\":\"\",\"receiving_no\":\"\",\"customer_name\":\"\",\"record_id\":\"1325962123690012673\",\"create_time\":\"2020-11-10 08:43:00\",\"sys_org_code\":\"A01\",\"create_by\":\"admin\"}],\"id\":\"1325962123690012673\"},null]',NULL,114,NULL,'2020-11-10 08:43:00',NULL,NULL),('1325962125178990593',2,'online列表数据查询,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,112,NULL,'2020-11-10 08:43:00',NULL,NULL),('1325962136528777218',2,'online表单数据查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,21,NULL,'2020-11-10 08:43:03',NULL,NULL),('1325962177964306433',2,'online修改数据,表名:iost_inventory_record,修改成功！',3,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'[\"61328d3127024a9b99298eded991106c\",{\"update_time\":\"2020-11-10 08:43:12\",\"warehouse_name\":\"1325686076402724866\",\"packages_total\":\"\",\"iost_inventory_record_list\":[{\"id\":\"16049689359140283211\",\"name_chs\":\"dfsd\",\"name_eng\":\"sdfsdf\",\"unit\":\"fsdf\",\"packages\":\"34.78\",\"packages_total\":\"677.78\",\"length\":\"6778\",\"width\":\"5657.676\",\"height\":\"65756\",\"volume\":\"57656.67\",\"volume_total\":\"56566.565\",\"weight\":\"456.76546\",\"weight_total\":\"456456.7465\",\"material\":\"eyte\",\"receiving_no\":\"etye\",\"customer_name\":\"ertyey\",\"record_id\":\"1325962123690012673\",\"create_time\":\"2020-11-10 08:43:13\",\"sys_org_code\":\"A01\",\"create_by\":\"admin\"}],\"id\":\"1325962123690012673\",\"update_by\":\"admin\"}]',NULL,95,NULL,'2020-11-10 08:43:13',NULL,NULL),('1325962179084185601',2,'online列表数据查询,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,104,NULL,'2020-11-10 08:43:13',NULL,NULL),('1325963304243982338',2,'online列表加载,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,27,NULL,'2020-11-10 08:47:42',NULL,NULL),('1325963304302702594',2,'online表单加载,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,64,NULL,'2020-11-10 08:47:42',NULL,NULL),('1325963305560993794',2,'online列表数据查询,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,133,NULL,'2020-11-10 08:47:42',NULL,NULL),('1325963563670073346',2,'online列表加载,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,39,NULL,'2020-11-10 08:48:43',NULL,NULL),('1325963563749765122',2,'online表单加载,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,39,NULL,'2020-11-10 08:48:43',NULL,NULL),('1325963565335212033',2,'online列表数据查询,表名:iost_inventory_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,150,NULL,'2020-11-10 08:48:44',NULL,NULL),('1325966608671862786',2,'online列表加载,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,27,NULL,'2020-11-10 09:00:49',NULL,NULL),('1325966608705417217',2,'online表单加载,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,20,NULL,'2020-11-10 09:00:49',NULL,NULL),('1325966609561055233',2,'online列表数据查询,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,37,NULL,'2020-11-10 09:00:50',NULL,NULL),('1325966732269613057',2,'online新增数据,表名:iost_delivery_record,操作成功！',2,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'[\"2f03eb34ce95467e8a7f1388d49c18c8\",{\"create_by\":\"admin\",\"loading_date\":\"2020-11-10\",\"bulk_no\":\"sdfsdf\",\"warehouse_name\":\"1325729105001320450\",\"create_time\":\"2020-11-10 09:01:18\",\"sys_org_code\":\"A01\",\"container_no\":\"werwer\",\"id\":\"1325966732139589634\"},null]',NULL,31,NULL,'2020-11-10 09:01:19',NULL,NULL),('1325966733318189058',2,'online列表数据查询,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,47,NULL,'2020-11-10 09:01:19',NULL,NULL),('1325966838448418817',2,'online列表加载,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,34,NULL,'2020-11-10 09:01:44',NULL,NULL),('1325966838448418818',2,'online表单加载,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,18,NULL,'2020-11-10 09:01:44',NULL,NULL),('1325966839891259394',2,'online列表数据查询,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,94,NULL,'2020-11-10 09:01:45',NULL,NULL),('1325966909818695682',2,'online列表数据查询,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,34,NULL,'2020-11-10 09:02:01',NULL,NULL),('1325966923475349506',2,'online列表数据查询,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,31,NULL,'2020-11-10 09:02:04',NULL,NULL),('1325974691582210049',2,'online列表加载,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,82,NULL,'2020-11-10 09:32:57',NULL,NULL),('1325974691842256898',2,'online表单加载,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,78,NULL,'2020-11-10 09:32:57',NULL,NULL),('1325974693217988609',2,'online列表数据查询,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,109,NULL,'2020-11-10 09:32:57',NULL,NULL),('1325974746397569025',2,'online列表加载,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,31,NULL,'2020-11-10 09:33:10',NULL,NULL),('1325974746464677890',2,'online表单加载,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,17,NULL,'2020-11-10 09:33:10',NULL,NULL),('1325974748100456450',2,'online列表数据查询,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,110,NULL,'2020-11-10 09:33:10',NULL,NULL),('1325974776189710337',2,'online表单数据查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,23,NULL,'2020-11-10 09:33:17',NULL,NULL),('1325974813762285569',2,'online表单加载,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,30,NULL,'2020-11-10 09:33:26',NULL,NULL),('1325974813825200130',2,'online列表加载,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,16,NULL,'2020-11-10 09:33:26',NULL,NULL),('1325974815792328706',2,'online列表数据查询,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,172,NULL,'2020-11-10 09:33:26',NULL,NULL),('1325974822859730945',2,'online表单数据查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,30,NULL,'2020-11-10 09:33:28',NULL,NULL),('1325974834448592898',2,'online表单数据查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,15,NULL,'2020-11-10 09:33:31',NULL,NULL),('1325975139202527234',2,'online列表加载,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,24,NULL,'2020-11-10 09:34:43',NULL,NULL),('1325975139596791809',2,'online表单加载,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,109,NULL,'2020-11-10 09:34:43',NULL,NULL),('1325975140578258946',2,'online列表数据查询,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,94,NULL,'2020-11-10 09:34:44',NULL,NULL),('1325975149050753025',2,'online表单数据查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,20,NULL,'2020-11-10 09:34:46',NULL,NULL),('1325975424855601153',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','27.38.244.216',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-10 09:35:51',NULL,NULL),('1325975644477747202',1,'用户名: admin,登录成功！',NULL,'admin','管理员','27.38.244.216',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-10 09:36:44',NULL,NULL),('1325975683958730753',2,'online列表加载,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,18,NULL,'2020-11-10 09:36:53',NULL,NULL),('1325975683992285185',2,'online表单加载,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,33,NULL,'2020-11-10 09:36:53',NULL,NULL),('1325975685154107394',2,'online列表数据查询,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,60,NULL,'2020-11-10 09:36:53',NULL,NULL),('1325975699397963778',2,'online表单数据查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,35,NULL,'2020-11-10 09:36:57',NULL,NULL),('1325975857141542913',2,'online列表加载,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,52,NULL,'2020-11-10 09:37:34',NULL,NULL),('1325975857233817602',2,'online表单加载,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,40,NULL,'2020-11-10 09:37:34',NULL,NULL),('1325975858739572737',2,'online列表数据查询,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,109,NULL,'2020-11-10 09:37:35',NULL,NULL),('1325975884433879041',2,'online表单数据查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,17,NULL,'2020-11-10 09:37:41',NULL,NULL),('1325975927798788097',2,'online列表加载,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,27,NULL,'2020-11-10 09:37:51',NULL,NULL),('1325975927861702657',2,'online表单加载,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,15,NULL,'2020-11-10 09:37:51',NULL,NULL),('1325975929371652098',2,'online列表数据查询,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,109,NULL,'2020-11-10 09:37:52',NULL,NULL),('1325975938729144322',2,'online表单数据查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,28,NULL,'2020-11-10 09:37:54',NULL,NULL),('1325980818038484994',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','27.38.244.216',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-10 09:57:17',NULL,NULL),('1325980992202764289',2,'online列表加载,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,35,NULL,'2020-11-10 09:57:59',NULL,NULL),('1325980992290844673',2,'online表单加载,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,51,NULL,'2020-11-10 09:57:59',NULL,NULL),('1325980993893068801',2,'online列表数据查询,表名:iost_delivery_record,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,161,NULL,'2020-11-10 09:57:59',NULL,NULL),('1325995678177955842',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','27.38.244.216',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-10 10:56:20',NULL,NULL),('1325995755042770945',1,'用户名: admin,登录成功！',NULL,'admin','管理员','27.38.244.216',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-10 10:56:38',NULL,NULL),('1325997079029354497',2,'仓库管理-分页列表查询',1,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostStorageController.queryPageList()',NULL,'  iostStorage: IostStorage(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, name=null, address=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@349dc193',NULL,167,NULL,'2020-11-10 11:01:54',NULL,NULL),('1325997114093735937',2,'客户管理-分页列表查询',1,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryPageList()',NULL,'  iostCustomer: IostCustomer(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, nameChs=null, nameEng=null, company=null, code=null, address=null, telephone=null, email=null, vat=null, imexNo=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@54595325',NULL,81,NULL,'2020-11-10 11:02:02',NULL,NULL),('1325997123723857921',2,'送货地址通过主表ID查询',1,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryIostCustomerlistListByMainId()',NULL,'  id: 1325694847640301569',NULL,24,NULL,'2020-11-10 11:02:05',NULL,NULL),('1325997140090032130',2,'客户管理-编辑',3,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostCustomerController.edit()',NULL,'[{\"address\":\"adfafaf\",\"code\":\"werwer\",\"company\":\"werwer\",\"createBy\":\"admin\",\"createTime\":1604905256000,\"email\":\"234\",\"id\":\"1325694847640301569\",\"imexNo\":\"234234\",\"nameChs\":\"werw\",\"nameEng\":\"werew\",\"sysOrgCode\":\"A01\",\"telephone\":\"wer\",\"updateBy\":\"admin\",\"updateTime\":1604913587000,\"vat\":\"24234\"}]',NULL,54,NULL,'2020-11-10 11:02:09',NULL,NULL),('1325997140962447361',2,'客户管理-分页列表查询',1,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryPageList()',NULL,'  iostCustomer: IostCustomer(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, nameChs=null, nameEng=null, company=null, code=null, address=null, telephone=null, email=null, vat=null, imexNo=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@d0f5b79',NULL,55,NULL,'2020-11-10 11:02:09',NULL,NULL),('1325997146691866626',2,'送货地址通过主表ID查询',1,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryIostCustomerlistListByMainId()',NULL,'  id: 1325694847640301569',NULL,2,NULL,'2020-11-10 11:02:10',NULL,NULL),('1325998536554188801',2,'送货地址通过主表ID查询',1,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryIostCustomerlistListByMainId()',NULL,'  id: 1325694847640301569',NULL,9,NULL,'2020-11-10 11:07:42',NULL,NULL),('1325998557047558145',2,'客户管理-编辑',3,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostCustomerController.edit()',NULL,'[{\"address\":\"adfafaf\",\"code\":\"werwer\",\"company\":\"werwer\",\"createBy\":\"admin\",\"createTime\":1604905256000,\"email\":\"234\",\"id\":\"1325694847640301569\",\"imexNo\":\"234234\",\"nameChs\":\"werw\",\"nameEng\":\"werew\",\"sysOrgCode\":\"A01\",\"telephone\":\"wer\",\"updateBy\":\"admin\",\"updateTime\":1604977329000,\"vat\":\"24234\"}]',NULL,48,NULL,'2020-11-10 11:07:47',NULL,NULL),('1325998558045802498',2,'客户管理-分页列表查询',1,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryPageList()',NULL,'  iostCustomer: IostCustomer(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, nameChs=null, nameEng=null, company=null, code=null, address=null, telephone=null, email=null, vat=null, imexNo=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@1f40c3c8',NULL,52,NULL,'2020-11-10 11:07:47',NULL,NULL),('1325998567197773826',2,'送货地址通过主表ID查询',1,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryIostCustomerlistListByMainId()',NULL,'  id: 1325694847640301569',NULL,7,NULL,'2020-11-10 11:07:49',NULL,NULL),('1325998886606606338',2,'送货地址通过主表ID查询',1,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryIostCustomerlistListByMainId()',NULL,'  id: 1325694847640301569',NULL,7,NULL,'2020-11-10 11:09:05',NULL,NULL),('1325998911277502465',2,'仓库管理-分页列表查询',1,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostStorageController.queryPageList()',NULL,'  iostStorage: IostStorage(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, name=null, address=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@38a3c163',NULL,78,NULL,'2020-11-10 11:09:11',NULL,NULL),('1325998932152553474',2,'商品类别-分页列表查询',1,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostKindController.queryPageList()',NULL,'  iostKind: IostKind(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, code=null, name=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@7f6e97f9',NULL,42,NULL,'2020-11-10 11:09:16',NULL,NULL),('1325998951115001857',2,'价格维护-分页列表查询',1,'admin','管理员','27.38.244.217','org.jeecg.modules.iost.basedata.controller.IostPriceController.queryPageList()',NULL,'  iostPrice: IostPrice(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, kind=null, nameChs=null, nameEng=null, price=null, description=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@6ec69ae0',NULL,168,NULL,'2020-11-10 11:09:20',NULL,NULL),('1325999644995489794',2,'online列表加载,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,652,NULL,'2020-11-10 11:12:06',NULL,NULL),('1325999645708521474',2,'online表单加载,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,833,NULL,'2020-11-10 11:12:06',NULL,NULL),('1325999647793090561',2,'online列表数据查询,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,197,NULL,'2020-11-10 11:12:07',NULL,NULL),('1325999665216229378',2,'online表单数据查询',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,183,NULL,'2020-11-10 11:12:11',NULL,NULL),('1325999808560762881',2,'online列表加载,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,96,NULL,'2020-11-10 11:12:45',NULL,NULL),('1325999808778866689',2,'online表单加载,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,171,NULL,'2020-11-10 11:12:45',NULL,NULL),('1325999810485948417',2,'online列表数据查询,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,112,NULL,'2020-11-10 11:12:45',NULL,NULL),('1325999828915720194',2,'online表单数据查询',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,79,NULL,'2020-11-10 11:12:50',NULL,NULL),('1325999934784147457',2,'价格维护-分页列表查询',1,'admin','管理员','27.38.244.216','org.jeecg.modules.iost.basedata.controller.IostPriceController.queryPageList()',NULL,'  iostPrice: IostPrice(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, kind=null, nameChs=null, nameEng=null, price=null, description=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@1c98346a',NULL,144,NULL,'2020-11-10 11:13:15',NULL,NULL),('1325999941411147778',2,'商品类别-分页列表查询',1,'admin','管理员','27.38.244.216','org.jeecg.modules.iost.basedata.controller.IostKindController.queryPageList()',NULL,'  iostKind: IostKind(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, code=null, name=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@1f610fd8',NULL,45,NULL,'2020-11-10 11:13:17',NULL,NULL),('1325999947484499969',2,'客户管理-分页列表查询',1,'admin','管理员','27.38.244.216','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryPageList()',NULL,'  iostCustomer: IostCustomer(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, nameChs=null, nameEng=null, company=null, code=null, address=null, telephone=null, email=null, vat=null, imexNo=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@7366d312',NULL,56,NULL,'2020-11-10 11:13:18',NULL,NULL),('1325999962294587394',2,'online列表加载,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,93,NULL,'2020-11-10 11:13:22',NULL,NULL),('1325999962525274113',2,'online表单加载,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,153,NULL,'2020-11-10 11:13:22',NULL,NULL),('1325999964383350785',2,'online列表数据查询,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,140,NULL,'2020-11-10 11:13:22',NULL,NULL),('1326000071694618626',2,'online列表加载,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,62,NULL,'2020-11-10 11:13:48',NULL,NULL),('1326000072109854722',2,'online表单加载,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,142,NULL,'2020-11-10 11:13:48',NULL,NULL),('1326000073519140865',2,'online列表数据查询,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,108,NULL,'2020-11-10 11:13:48',NULL,NULL),('1326000109955059713',2,'online列表加载,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,122,NULL,'2020-11-10 11:13:57',NULL,NULL),('1326000110374490113',2,'online表单加载,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,234,NULL,'2020-11-10 11:13:57',NULL,NULL),('1326000111855079425',2,'online列表数据查询,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,88,NULL,'2020-11-10 11:13:57',NULL,NULL),('1326000205073485826',2,'online列表加载,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,105,NULL,'2020-11-10 11:14:19',NULL,NULL),('1326000205459361793',2,'online表单加载,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,190,NULL,'2020-11-10 11:14:20',NULL,NULL),('1326000206847676417',2,'online列表数据查询,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,119,NULL,'2020-11-10 11:14:20',NULL,NULL),('1326000881170124802',2,'online列表加载,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,89,NULL,'2020-11-10 11:17:01',NULL,NULL),('1326000881425977345',2,'online表单加载,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,135,NULL,'2020-11-10 11:17:01',NULL,NULL),('1326000882759766017',2,'online列表数据查询,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,74,NULL,'2020-11-10 11:17:01',NULL,NULL),('1326001333135740930',2,'online列表加载,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,72,NULL,'2020-11-10 11:18:48',NULL,NULL),('1326001333475479553',2,'online表单加载,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,133,NULL,'2020-11-10 11:18:48',NULL,NULL),('1326001334784102402',2,'online列表数据查询,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,82,NULL,'2020-11-10 11:18:49',NULL,NULL),('1326001345882230785',2,'online表单数据查询',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,70,NULL,'2020-11-10 11:18:51',NULL,NULL),('1326001519362838530',2,'online修改数据,表名:iost_receiving,修改成功！',3,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.a()',NULL,'[\"dd396a66386745c4993dc5c941c07a2e\",{\"date\":\"\",\"delivery_factory\":\"sdsd\",\"receiving_no\":\"sdsd\",\"delivery_man\":\"\",\"telephone\":\"\",\"cases_total\":\"\",\"update_time\":\"2020-11-10 11:19:32\",\"warehouse_name\":\"\",\"iost_receivinglist\":[{\"id\":\"16049084450250139810\",\"name_chs\":\"dssd\",\"name_eng\":\"sdsdsd\",\"unit\":\"\",\"cases\":\"\",\"packages\":\"\",\"packages_total\":\"\",\"length\":\"\",\"width\":\"\",\"height\":\"\",\"volume\":\"\",\"volume_total\":\"\",\"weight\":\"\",\"weight_total\":\"\",\"material\":\"\",\"price\":\"\",\"money\":\"\",\"kind\":\"001\",\"picture\":\"temp/Autumn_in_Kanas_by_Wang_Jinyu_1604978345151.jpg\",\"receiving_id\":\"1325708327592292353\",\"create_time\":\"2020-11-10 11:19:32\",\"create_by\":\"admin\",\"sys_org_code\":\"A01\"}],\"customer_name\":\"\",\"id\":\"1325708327592292353\",\"update_by\":\"admin\",\"customer_code\":\"\"}]',NULL,225,NULL,'2020-11-10 11:19:33',NULL,NULL),('1326001520503689218',2,'online列表数据查询,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,86,NULL,'2020-11-10 11:19:33',NULL,NULL),('1326001529529831425',2,'online表单数据查询',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,67,NULL,'2020-11-10 11:19:35',NULL,NULL),('1326001585091776514',2,'online表单数据查询',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,53,NULL,'2020-11-10 11:19:48',NULL,NULL),('1326003202914521089',1,'用户名: admin,登录成功！',NULL,'admin','管理员','27.38.244.216',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-10 11:26:14',NULL,NULL),('1326003287391997954',2,'online列表加载,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.217','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,81,NULL,'2020-11-10 11:26:34',NULL,NULL),('1326003287589130242',2,'online表单加载,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,185,NULL,'2020-11-10 11:26:34',NULL,NULL),('1326003289375903746',2,'online列表数据查询,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.217','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,114,NULL,'2020-11-10 11:26:35',NULL,NULL),('1326003298255245313',2,'online表单数据查询',1,'admin','管理员','27.38.244.217','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,65,NULL,'2020-11-10 11:26:37',NULL,NULL),('1326003425183272962',2,'online修改数据,表名:iost_receiving,修改成功！',3,'admin','管理员','27.38.244.217','org.jeecg.modules.online.cgform.b.a.a()',NULL,'[\"dd396a66386745c4993dc5c941c07a2e\",{\"date\":\"\",\"delivery_factory\":\"sdsd\",\"receiving_no\":\"sdsd\",\"delivery_man\":\"\",\"telephone\":\"\",\"cases_total\":\"\",\"update_time\":\"2020-11-10 11:27:07\",\"warehouse_name\":\"\",\"iost_receivinglist\":[{\"id\":\"16049084450250139810\",\"name_chs\":\"dssd\",\"name_eng\":\"sdsdsd\",\"unit\":\"\",\"cases\":\"\",\"packages\":\"\",\"packages_total\":\"\",\"length\":\"\",\"width\":\"\",\"height\":\"\",\"volume\":\"\",\"volume_total\":\"\",\"weight\":\"\",\"weight_total\":\"\",\"material\":\"\",\"price\":\"\",\"money\":\"\",\"kind\":\"001\",\"picture\":\"Balloon_by_Matt_Benson_1604978808510.jpg\",\"receiving_id\":\"1325708327592292353\",\"create_time\":\"2020-11-10 11:27:07\",\"create_by\":\"admin\",\"sys_org_code\":\"A01\"}],\"customer_name\":\"\",\"id\":\"1325708327592292353\",\"update_by\":\"admin\",\"customer_code\":\"\"}]',NULL,79,NULL,'2020-11-10 11:27:07',NULL,NULL),('1326003426965852162',2,'online列表数据查询,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.217','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,75,NULL,'2020-11-10 11:27:08',NULL,NULL),('1326003435828416513',2,'online表单数据查询',1,'admin','管理员','27.38.244.217','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,64,NULL,'2020-11-10 11:27:10',NULL,NULL),('1326015681428877314',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','220.115.53.100',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-10 12:15:49',NULL,NULL),('1326015721065050113',1,'用户名: admin,登录成功！',NULL,'admin','管理员','220.115.53.100',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-10 12:15:59',NULL,NULL),('1326015774567591938',2,'online列表加载,表名:iost_receiving,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,25,NULL,'2020-11-10 12:16:11',NULL,NULL),('1326015774643089410',2,'online表单加载,表名:iost_receiving,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,109,NULL,'2020-11-10 12:16:12',NULL,NULL),('1326015775888797697',2,'online列表数据查询,表名:iost_receiving,操作成功！',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,158,NULL,'2020-11-10 12:16:12',NULL,NULL),('1326015810378559489',2,'online表单数据查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,16,NULL,'2020-11-10 12:16:20',NULL,NULL),('1326015841634512897',2,'online表单数据查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,16,NULL,'2020-11-10 12:16:27',NULL,NULL),('1326018890337095682',2,'online列表加载,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,55,NULL,'2020-11-10 12:28:34',NULL,NULL),('1326018890639085569',2,'online表单加载,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.217','org.jeecg.modules.online.cgform.b.a.b()',NULL,'',NULL,137,NULL,'2020-11-10 12:28:34',NULL,NULL),('1326018892153229313',2,'online列表数据查询,表名:iost_receiving,操作成功！',1,'admin','管理员','27.38.244.216','org.jeecg.modules.online.cgform.b.a.a()',NULL,'',NULL,88,NULL,'2020-11-10 12:28:35',NULL,NULL),('1326045924073410562',1,'用户名: admin,登录成功！',NULL,'admin','管理员','220.115.53.100',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-10 14:16:00',NULL,NULL),('1326046310589689858',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','220.115.53.100',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-10 14:17:32',NULL,NULL),('1326046360673873921',1,'用户名: admin,登录成功！',NULL,'admin','管理员','220.115.53.100',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-10 14:17:44',NULL,NULL),('1326047421163114498',2,'仓库管理-分页列表查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostStorageController.queryPageList()',NULL,'  iostStorage: IostStorage(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, name=null, address=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@47f4efe',NULL,94,NULL,'2020-11-10 14:21:57',NULL,NULL),('1326047474351083521',2,'客户管理-分页列表查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryPageList()',NULL,'  iostCustomer: IostCustomer(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, nameChs=null, nameEng=null, company=null, code=null, address=null, telephone=null, email=null, vat=null, imexNo=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@44046027',NULL,121,NULL,'2020-11-10 14:22:09',NULL,NULL),('1326047648427282433',2,'送货地址通过主表ID查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryIostCustomerlistListByMainId()',NULL,'  id: 1325694847640301569',NULL,16,NULL,'2020-11-10 14:22:51',NULL,NULL),('1326047666907385857',2,'客户管理-编辑',3,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.edit()',NULL,'[{\"address\":\"adfafaf\",\"code\":\"werwer\",\"company\":\"werwer\",\"createBy\":\"admin\",\"createTime\":1604905256000,\"email\":\"234\",\"id\":\"1325694847640301569\",\"imexNo\":\"234234\",\"nameChs\":\"werw\",\"nameEng\":\"werew\",\"sysOrgCode\":\"A01\",\"telephone\":\"wer\",\"updateBy\":\"admin\",\"updateTime\":1604977666000,\"vat\":\"24234\"}]',NULL,74,NULL,'2020-11-10 14:22:55',NULL,NULL),('1326047668249563138',2,'客户管理-分页列表查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryPageList()',NULL,'  iostCustomer: IostCustomer(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, nameChs=null, nameEng=null, company=null, code=null, address=null, telephone=null, email=null, vat=null, imexNo=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@2239c65a',NULL,65,NULL,'2020-11-10 14:22:56',NULL,NULL),('1326047674796871681',2,'送货地址通过主表ID查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryIostCustomerlistListByMainId()',NULL,'  id: 1325694847640301569',NULL,6,NULL,'2020-11-10 14:22:57',NULL,NULL),('1326047711534780417',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','220.115.53.100',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-10 14:23:06',NULL,NULL),('1326047742450995202',1,'用户名: admin,登录成功！',NULL,'admin','管理员','220.115.53.100',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-10 14:23:13',NULL,NULL),('1326047801276108801',2,'客户管理-分页列表查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryPageList()',NULL,'  iostCustomer: IostCustomer(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, nameChs=null, nameEng=null, company=null, code=null, address=null, telephone=null, email=null, vat=null, imexNo=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@42a744be',NULL,46,NULL,'2020-11-10 14:23:27',NULL,NULL),('1326047859044257793',2,'客户管理-添加',2,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.add()',NULL,'[{\"code\":\"wrwer\",\"iostCustomerlistList\":[{\"address\":\"wrwer\",\"addressDefault\":\"true\",\"createBy\":\"admin\",\"createTime\":1604989421025,\"customerId\":\"1326047858893262850\",\"id\":\"16049894103520754968\",\"sysOrgCode\":\"A01\"}],\"nameChs\":\"wrewer\",\"nameEng\":\"werwe\",\"telephone\":\"wrwr\"}]',NULL,64,NULL,'2020-11-10 14:23:41',NULL,NULL),('1326047860189302786',2,'客户管理-分页列表查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryPageList()',NULL,'  iostCustomer: IostCustomer(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, nameChs=null, nameEng=null, company=null, code=null, address=null, telephone=null, email=null, vat=null, imexNo=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@26e7c7ff',NULL,65,NULL,'2020-11-10 14:23:41',NULL,NULL),('1326047866430427137',2,'送货地址通过主表ID查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryIostCustomerlistListByMainId()',NULL,'  id: 1326047858893262850',NULL,4,NULL,'2020-11-10 14:23:43',NULL,NULL),('1326047878820401153',2,'客户管理-编辑',3,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.edit()',NULL,'[{\"code\":\"wrwer\",\"createBy\":\"admin\",\"createTime\":1604989421000,\"id\":\"1326047858893262850\",\"iostCustomerlistList\":[{\"address\":\"wrwer\",\"addressDefault\":\"false\",\"createBy\":\"admin\",\"createTime\":1604989425735,\"customerId\":\"1326047858893262850\",\"id\":\"16049894103520754968\",\"sysOrgCode\":\"A01\"}],\"nameChs\":\"wrewer\",\"nameEng\":\"werwe\",\"sysOrgCode\":\"A01\",\"telephone\":\"wrwr\"}]',NULL,20,NULL,'2020-11-10 14:23:46',NULL,NULL),('1326047879839617025',2,'客户管理-分页列表查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryPageList()',NULL,'  iostCustomer: IostCustomer(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, nameChs=null, nameEng=null, company=null, code=null, address=null, telephone=null, email=null, vat=null, imexNo=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@4312376c',NULL,36,NULL,'2020-11-10 14:23:46',NULL,NULL),('1326047886131073026',2,'送货地址通过主表ID查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryIostCustomerlistListByMainId()',NULL,'  id: 1326047858893262850',NULL,9,NULL,'2020-11-10 14:23:47',NULL,NULL),('1326047906821574658',1,'用户名: 管理员,退出成功！',NULL,'admin','管理员','27.38.244.217',NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-10 14:23:52',NULL,NULL),('1326048071208931330',2,'客户管理-编辑',3,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.edit()',NULL,'[{\"code\":\"wrwer\",\"createBy\":\"admin\",\"createTime\":1604989421000,\"id\":\"1326047858893262850\",\"iostCustomerlistList\":[{\"address\":\"wrwer\",\"addressDefault\":\"false\",\"createBy\":\"admin\",\"createTime\":1604989471604,\"customerId\":\"1326047858893262850\",\"id\":\"16049894103520754968\",\"sysOrgCode\":\"A01\"}],\"nameChs\":\"wrewer\",\"nameEng\":\"werwe\",\"sysOrgCode\":\"A01\",\"telephone\":\"wrwr\",\"updateBy\":\"admin\",\"updateTime\":1604989426000}]',NULL,20,NULL,'2020-11-10 14:24:32',NULL,NULL),('1326048072240730114',2,'客户管理-分页列表查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryPageList()',NULL,'  iostCustomer: IostCustomer(id=null, createBy=null, createTime=null, updateBy=null, updateTime=null, sysOrgCode=null, nameChs=null, nameEng=null, company=null, code=null, address=null, telephone=null, email=null, vat=null, imexNo=null)  pageNo: 1  pageSize: 10  req: org.apache.shiro.web.servlet.ShiroHttpServletRequest@7efbecbb',NULL,44,NULL,'2020-11-10 14:24:32',NULL,NULL),('1326048092994146305',2,'送货地址通过主表ID查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.queryIostCustomerlistListByMainId()',NULL,'  id: 1326047858893262850',NULL,10,NULL,'2020-11-10 14:24:37',NULL,NULL),('1326048107942645762',2,'客户管理-编辑',3,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.edit()',NULL,'[{\"code\":\"wrwer\",\"createBy\":\"admin\",\"createTime\":1604989421000,\"id\":\"1326047858893262850\",\"iostCustomerlistList\":[{\"address\":\"wrwer\",\"addressDefault\":\"false\",\"createBy\":\"admin\",\"createTime\":1604989480368,\"customerId\":\"1326047858893262850\",\"id\":\"16049894103520754968\",\"sysOrgCode\":\"A01\"}],\"nameChs\":\"wrewer\",\"nameEng\":\"werwe\",\"sysOrgCode\":\"A01\",\"telephone\":\"wrwr\",\"updateBy\":\"admin\",\"updateTime\":1604989472000}]',NULL,26,NULL,'2020-11-10 14:24:40',NULL,NULL),('1326048109049942017',2,'客户管理-分页列表查询',1,'admin','管理员','220.115.53.100','org.jeecg.modules.iost.basedata.controller.IostCustomerController.que