package org.jeecg.common.exception;

import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.AutoLogAspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

@ControllerAdvice
public class GlobalExceptionHandler {
    @Autowired
    AutoLogAspect autoLogAspect;
    /*金蝶云操作异常*/
    @ResponseBody
    @ExceptionHandler(kingdeeException.class)
    public Result kingdeeException(HttpServletRequest req, kingdeeException e)
    {
   /*     Result r=new Result();
        r.setResult(e.getResult());*/
        return Result.fail(e.getMessage(),e.getResult(),e.getCode());
    }
    /*金蝶云重复异常*/
    @ResponseBody
    @ExceptionHandler(KingdeeRepeatException.class)
    public Result KingdeeRepeatException(HttpServletRequest req, KingdeeRepeatException e)
    {
   /*     Result r=new Result();
        r.setResult(e.getResult());*/
        return Result.fail(e.getMessage(),e.getResult(),e.getCode());
    }
    /*金蝶云连接异常*/
    @ResponseBody
    @ExceptionHandler(KingdeeConnectException.class)
    public Result KingdeeConnectHandler(HttpServletRequest req, KingdeeConnectException e)
    {

        Result r=new Result();
        r.setResult(e.getResult());
        return r.error500(e.getMessage());
    }

    /*ims连接异常*/
    @ResponseBody
    @ExceptionHandler(imsConnectException.class)
    public Result imsConnectHandler(HttpServletRequest req, imsConnectException e)
    {
        Result r=new Result();
        r.setResult(e.getResult());
        return r.error500(e.getMessage());
    }

    /*金蝶云修改异常*/
    @ResponseBody
    @ExceptionHandler(KingdeeChangeException.class)
    public Result KingdeeChangeHandler(HttpServletRequest req, KingdeeChangeException e)
    {
        Result r=new Result();
        r.setResult(e.getResult());
        return r.error500(e.getMessage());
    }

    /*金蝶云下推异常*/
    @ResponseBody
    @ExceptionHandler(KingdeePushException.class)
    public Result KingdeePushHandler(HttpServletRequest req, KingdeePushException e)
    {
        Result r=new Result();
        r.setResult(e.getResult());
        return r.error500(e.getMessage());
    }
    /*金蝶云查询异常*/
    @ResponseBody
    @ExceptionHandler(KingdeeSelectException.class)
    public Result KingdeeSelectHandler(HttpServletRequest req, KingdeeSelectException e)
    {
   /*     Result r=new Result();
        r.setResult(e.getResult());*/
        return Result.fail(e.getMessage(),e.getResult(),e.getCode());
    }
    /*数据重复异常*/
    @ResponseBody
    @ExceptionHandler(DataRepeatException.class)
    public Result DataRepeatHandler(HttpServletRequest req, DataRepeatException e)
    {
   /*     Result r=new Result();
        r.setResult(e.getResult());*/
        return Result.fail(e.getMessage(),e.getResult(),e.getCode());
    }
}
