package org.jeecg.modules.iost.ims.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 委外ERP工单
 * @Author: jeecg-boot
 * @Date:   2021-10-05
 * @Version: V1.0
 */
@Data
@TableName("ims_wplan_outs")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="ims_wplan_outs对象", description="委外ERP工单")
public class ImsWplanOuts implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private java.lang.String id;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private java.lang.String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private java.util.Date createTime;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private java.lang.String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;
	/**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private java.lang.String sysOrgCode;
	/**ERP工单编码*/
	@Excel(name = "ERP工单编码", width = 15)
    @ApiModelProperty(value = "ERP工单编码")
    private java.lang.String erpMo;
	/**成品编码*/
	@Excel(name = "成品编码", width = 15)
    @ApiModelProperty(value = "成品编码")
    private java.lang.String prodId;
	/**计划数量*/
	@Excel(name = "计划数量", width = 15)
    @ApiModelProperty(value = "计划数量")
    private java.lang.String pqty;
	/**计划开始时间*/
	@Excel(name = "计划开始时间", width = 15)
    @ApiModelProperty(value = "计划开始时间")
    private java.lang.String pbDate;
	/**计划结束时间*/
	@Excel(name = "计划结束时间", width = 15)
    @ApiModelProperty(value = "计划结束时间")
    private java.lang.String peDate;
	/**是否IMS工单（Y是N否）默认Y*/
	@Excel(name = "是否IMS工单（Y是N否）默认Y", width = 15)
    @ApiModelProperty(value = "是否IMS工单（Y是N否）默认Y")
    private java.lang.String isImsMo;
	/**销售订单号*/
	@Excel(name = "销售订单号", width = 15)
    @ApiModelProperty(value = "销售订单号")
    private java.lang.String soId;
	/**销售订单行号*/
	@Excel(name = "销售订单行号", width = 15)
    @ApiModelProperty(value = "销售订单行号")
    private java.lang.String soSeq;
	/**客户编码*/
	@Excel(name = "客户编码", width = 15)
    @ApiModelProperty(value = "客户编码")
    private java.lang.String custId;
	/**是否委外工单（Y是N否）*/
	@Excel(name = "是否委外工单（Y是N否）", width = 15)
    @ApiModelProperty(value = "是否委外工单（Y是N否）")
    private java.lang.String isOuts;
	/**生产组织编码*/
	@Excel(name = "生产组织编码", width = 15)
    @ApiModelProperty(value = "生产组织编码")
    private java.lang.String orgId;
	/**工单序号*/
	@Excel(name = "工单序号", width = 15)
    @ApiModelProperty(value = "工单序号")
    private java.lang.String erpMoSeq;
	/**车间编码--按车间编码区分工艺段*/
	@Excel(name = "车间编码--按车间编码区分工艺段", width = 15)
    @ApiModelProperty(value = "车间编码--按车间编码区分工艺段")
    private java.lang.String ptId;
	/**主键ID*/
	@Excel(name = "主键ID", width = 15)
    @ApiModelProperty(value = "主键ID")
    private java.lang.String fid;
}
