package org.jeecg.modules.iost.ims.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import java.util.List;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: ims金蝶日志
 * @Author: jeecg-boot
 * @Date:   2021-09-03
 * @Version: V1.0
 */
@Data
@TableName("kingdeelog")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="kingdeelog对象", description="ims金蝶日志")
public class Kingdeelog implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private java.lang.String id;
	/**业务名字*/
	@Excel(name = "业务名字", width = 15)
    @ApiModelProperty(value = "业务名字")
    private java.lang.String name;
    /**金蝶请求信息*/
    @Excel(name = "金蝶请求信息", width = 15)
    @ApiModelProperty(value = "金蝶请求信息")
    private java.lang.String request;
	/**金蝶响应信息*/
	@Excel(name = "金蝶响应信息", width = 15)
    @ApiModelProperty(value = "金蝶响应信息")
    private java.lang.String response;
    /*失败原因*/
    @Excel(name = "失败原因", width = 15)
    @ApiModelProperty(value = "失败原因")
    private String failReason;
    /**创建人*/
    @ApiModelProperty(value = "创建人")
    private java.lang.String createBy;
    /**数据创建日期*/
    @Excel(name = "数据创建日期", width = 15)
    @ApiModelProperty(value = "数据创建日期")
    private java.lang.String createtime;
    /**更新人*/
    @ApiModelProperty(value = "更新人")
    private java.lang.String updateBy;
    /**更新日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;
    /**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private java.lang.String sysOrgCode;
	/**数据同步:失败:0,成功:1*/
	@Excel(name = "数据同步:失败:0,成功:1", width = 15)
    @ApiModelProperty(value = "数据同步:失败:0,成功:1")
    private java.lang.String synchronization;
    /**
     * 耗时
     */
    private Long costTime;
}
