package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.util.*;

/**
 * 查询金蝶云ERP库存查询接口
 */
@Component
public class XclKingdeeApi implements web_api {
    /**操作的单据体名称*/
    private String sFormId = "STK_Inventory";//即时库存
    @Autowired
    private CategoryDao categoryDao;
    private Map<String,String> key = new LinkedHashMap<>();
    public XclKingdeeApi(){
        /*查询字段*/
        key.put("FID","FID");//单据头实体主键
        key.put("FMaterialId.FNumber","FMaterialId.FNumber");//物料编码
        key.put("FStockId.FNumber","FStockId.FNumber");//仓库编码
        key.put("FBaseQty","FBaseQty");//库存量-基本单位
    }
    @Override
    public String add(Map<String, Object> maps) {
        return null;
    }


    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        return null;
    }

    /**
     * 分页查询
     * @param map
     * @param where
     * @return
     * @throws ParseException
     */

    public List<Map<String, String>> queryList(Map<String, String> map, String where,String name,Integer pageNo,Integer pageSize) throws ParseException {
        List<List<Object>> list = categoryDao.queryList(sFormId, key,map,name,pageNo,pageSize);
        return Xcl(list);
    }
    /**
     * 获取金蝶云数据
     *
     * @param map
     * @param where
     * @return
     * @throws ParseException
     */
    public List<Map<String, String>> selectAndLog(Map<String, String> map, String where,String name) throws ParseException {
        List<List<Object>> list = categoryDao.selectAndLog(sFormId, key,map,name);
        return Xcl(list);
    }
    /**
     * 将查询到的数据封装成本地字段
     *
     * @return
     */
    private List<Map<String, String>> Xcl(List<List<Object>> list) {
        List<Map<String, String>> salesorderlist = new ArrayList<>();
        if (!list.isEmpty()) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                for (List<Object> list1 : list) {
                    Map<String, String> salesordermap = new HashMap<>();
                    salesordermap.put("fid", list1.get(0).toString());
                    salesordermap.put("MTRL_ID", list1.get(1).toString());
                    salesordermap.put("STORE_ID", list1.get(2).toString());
                    salesordermap.put("BL_QTY", list1.get(3).toString());
                    salesorderlist.add(salesordermap);
                }
            }else {
                //如果有错误信息则返回
                Map<String,Object> o = (Map<String, Object>) list.get(0).get(0);
                Object errors = o.get("Errors");
                List parse3 = (List) JSON.parse(errors.toString());
                Map parse4 = (Map) JSON.parse(parse3.get(0).toString());
                Object message = parse4.get("Message");
                Map<String, String> salesordermap = new HashMap<>();
                salesordermap.put("false", message.toString());
                salesorderlist.add(salesordermap);
            }
        }
        return salesorderlist;
    }
    @Override
    public String update(Object object) {
        return null;
    }
}
