package org.jeecg.modules.iost.ims.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.entity.Syn;
import org.jeecg.modules.iost.ims.entity.Vo.ConnectParmVo;
import org.jeecg.modules.iost.ims.kingdeeapi.SynKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.SynMapper;
import org.jeecg.modules.iost.ims.service.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

@Service
public class ISynServiceImpl extends ServiceImpl<SynMapper, Syn> implements ISynService {
    @Autowired
    SynKingdeeApi kingdeeApi;
    @Autowired
    IImsMtrlService iImsMtrlService;
    @Autowired
    IImsStoreService iImsStoreService;
    @Autowired
    IImsCustomerService iImsCustomerService;
    @Autowired
    IImsDeptService iImsDeptService;
    @Autowired
    IImsSupplierService iImsSupplierService;
    @Autowired
    IImsWplanService iImsWplanService;
    @Autowired
    IImsDnService iImsDnService;
    @Autowired
    IImsAuditService iImsAuditService;
    @Autowired
    CategoryDao categoryDao;
    @Autowired
    IMSApi imsApi;

    /**
     * 查询新更新的记录
     * @param connectParmVo
     * @return
     * @throws ParseException
     */
    @Override
    public Boolean synchronization(ConnectParmVo connectParmVo) throws ParseException {
/*        if(!ObjectUtils.isEmpty(connectParmVo)) {
            //设置金蝶云手动同步的连接参数
            categoryDao.setK3CloudURL(connectParmVo.getKingdeeConnectParm().getK3CloudURL());
            categoryDao.setDbId(connectParmVo.getKingdeeConnectParm().getDbId());
            categoryDao.setUid(connectParmVo.getKingdeeConnectParm().getUid());
            categoryDao.setPwd(connectParmVo.getKingdeeConnectParm().getPwd());
            categoryDao.setLang(connectParmVo.getKingdeeConnectParm().getLang());
            categoryDao.setClient(new K3CloudApiClient(connectParmVo.getKingdeeConnectParm().getK3CloudURL()));
            categoryDao.setIsAutoSubmit(connectParmVo.getKingdeeConnectParm().getIsAutoSubmit().equals("是")?true:false);
            //设置ims手动同步的连接参数
            imsApi.setUrl(connectParmVo.getImsConParm().getUrl());
        }*/
        List<Map<String, String>> maps = kingdeeApi.select(null, null);
        Boolean success=true;
        List<Map<String,Object>> list=new ArrayList<>();
        LoginUser sysUser = null;
        for (Map<String, String> data:maps) {
            if(!data.get("formid").equals("LQKJ_IMSSync")) {
                Syn syn = new Syn();
                //主键
                syn.setFid(data.get("fid"));
                //表单名
                syn.setFormid(data.get("formid"));
                //表单对应的主键
                syn.setDataid(data.get("dataid"));
                syn.setCreatetime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                //把字符串转换成布尔类型
                syn.setSynchronization("同步成功");
                this.save(syn);
                //每次同步一个数据
                //物料成品信息
                if (data.get("formid").equals("BD_MATERIAL")) {
                    success = iImsMtrlService.synchronization(data.get("dataid"),sysUser);
                    //库存管理
                }else if (data.get("formid").equals("BD_STOCK")) {
                    success=iImsStoreService.synchronization(data.get("dataid"),sysUser);
                    //客户
                }else if (data.get("formid").equals("BD_Customer")) {
                    success=iImsCustomerService.synchronization(data.get("dataid"),sysUser);
                    //部门
                }else if(data.get("formid").equals("BD_Department")) {
                    success=iImsDeptService.synchronization(data.get("dataid"),sysUser);
                    //供应商
                }else if (data.get("formid").equals("BD_Supplier")) {
                    success= iImsSupplierService.synchronization(data.get("dataid"),sysUser);
                    //生产订单
                }else if(data.get("formid").equals("PRD_MO")) {
                    success= iImsWplanService.synchronization(data.get("dataid"),sysUser);
                    //发货通知单
                }else if(data.get("formid").equals("SAL_DELIVERYNOTICE")) {
                    success= iImsDnService.synchronization(data.get("dataid"),sysUser);
                    //出库申请单
                }else if(data.get("formid").equals("STK_OutStockApply")) {
                    success=iImsAuditService.synchronization(data.get("dataid"),sysUser);
                }
                //将金蝶云的数据同步该成1
                Map<String, Object> result = new HashMap<>();
                result.put("FID", data.get("fid"));
                result.put("F_LQKJ_SyncCheck", "1");
                result.put("F_LQKJ_SyndDatetime",new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                list.add(result);
            }
            //批量保存
            String add = kingdeeApi.batchAdd(list);
        }

        return success;
    }

    /**
     * 手动同步查询新更新的记录
     * @param sysUser
     * @return
     * @throws ParseException
     */
    @Override
    public Boolean Manualsynchronization(LoginUser sysUser) throws ParseException {

        List<Map<String, String>> maps = kingdeeApi.select(null, null);
        Boolean success=true;
        List<Map<String,Object>> list=new ArrayList<>();
        for (Map<String, String> data:maps) {
            if(!data.get("formid").equals("LQKJ_IMSSync")) {
                Syn syn = new Syn();
                //主键
                syn.setFid(data.get("fid"));
                //表单名
                syn.setFormid(data.get("formid"));
                //表单对应的主键
                syn.setDataid(data.get("dataid"));
                syn.setCreatetime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                //把字符串转换成布尔类型
                syn.setSynchronization("同步成功");
                this.save(syn);
                //每次同步一个数据
                //物料成品信息
                if (data.get("formid").equals("BD_MATERIAL")) {
                    success = iImsMtrlService.synchronization(data.get("dataid"),sysUser);
                    //库存管理
                }else if (data.get("formid").equals("BD_STOCK")) {
                    success=iImsStoreService.synchronization(data.get("dataid"),sysUser);
                    //客户
                }else if (data.get("formid").equals("BD_Customer")) {
                    success=iImsCustomerService.synchronization(data.get("dataid"),sysUser);
                    //部门
                }else if(data.get("formid").equals("BD_Department")) {
                    success=iImsDeptService.synchronization(data.get("dataid"),sysUser);
                    //供应商
                }else if (data.get("formid").equals("BD_Supplier")) {
                    success= iImsSupplierService.synchronization(data.get("dataid"),sysUser);
                    //生产订单
                }else if(data.get("formid").equals("PRD_MO")) {
                    success= iImsWplanService.synchronization(data.get("dataid"),sysUser);
                    //发货通知单
                }else if(data.get("formid").equals("SAL_DELIVERYNOTICE")) {
                    success= iImsDnService.synchronization(data.get("dataid"),sysUser);
                    //出库申请单
                }else if(data.get("formid").equals("STK_OutStockApply")) {
                    success=iImsAuditService.synchronization(data.get("dataid"),sysUser);
                }
                //将金蝶云的数据同步该成1
                Map<String, Object> result = new HashMap<>();
                result.put("FID", data.get("fid"));
                result.put("F_LQKJ_SyncCheck", "1");
                result.put("F_LQKJ_SyndDatetime",new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                list.add(result);
            }
            //批量保存
            String add = kingdeeApi.batchAdd(list);
        }

        return success;
    }
}
