package org.jeecg.modules.iost.ims.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.ImsUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.KingdeeLogUtil;
import org.jeecg.modules.iost.ims.entity.ImsAudit;
import org.jeecg.modules.iost.ims.entity.ImsCustomer;
import org.jeecg.modules.iost.ims.kingdeeapi.AuditKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsAuditMapper;
import org.jeecg.modules.iost.ims.service.IImsAuditService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
/**
 * @Description: ims其他出库单
 * @Author: jeecg-boot
 * @Date:   2021-09-06
 * @Version: V1.0
 */
@Service
public class ImsAuditServiceImpl extends ServiceImpl<ImsAuditMapper, ImsAudit> implements IImsAuditService {
    @Autowired
    AuditKingdeeApi kingdeeApi;
    @Autowired
    IMSApi imsApi;
    @Autowired
    ImsAuditMapper mapper;
    /**
     * 从金蝶云同步出库申请单信息
     * @param object
     * @return
     * @throws ParseException
     */
    @Override
    public Boolean synchronization(Object object, LoginUser sysUser) throws ParseException {
        ImsLogUtil imsLogUtil=new ImsLogUtil();
        List<ImsAudit> pojolist=new ArrayList<>();
        List<Map<String, String>> list=new ArrayList<>();
        Boolean success = false;
        Map<String,String> idmap=new HashMap<>();

        //设置需要同步的主键
        idmap.put("FID",object.toString());
        //将对应信息请求金蝶云
        list=kingdeeApi.selectAndLog(idmap,null,"其他出库单");

        //遍历集合拿到所有的MAP
        for (Map<String, String> data : list) {
            //判断是否有错误
            if(data.containsKey("false")){
                return success;
            }
            //将实体信息记录下来
            ImsAudit pojo = new ImsAudit();
            pojo.setFid(data.get("fid"));
            pojo.setAuditId(data.get("AUDIT_ID"));
            pojo.setAuditType(data.get("AUDIT_TYPE"));
            pojo.setErpMo(data.get("ERP_MO"));
            pojo.setMtrlId(data.get("MTRL_ID"));
            pojo.setQuantity(data.get("QUANTITY"));
            pojo.setRemark(data.get("REMARK"));
            pojo.setMtrlSeq(data.get("MTRL_SEQ"));
            pojo.setErpMoSeq(data.get("ERP_MO_SEQ"));
            pojo.setCreateTime(new Date());
            pojo.setFBusinessEnd(data.get("fBusinessEnd"));
            if(sysUser!=null){
                pojo.setCreateBy(sysUser.getUsername());
                pojo.setSysOrgCode(sysUser.getOrgCode());
            }
            pojolist.add(pojo);
        }
        //将数据包装成IMS格式
        Map<String,String> map=new HashMap<>();
        map.put("success","true");
        map.put("message","操作成功");
        map.put("result", JsonUtil.Listjson(list));
        String mapjson = JsonUtil.Mapjson(map);
        String body = ImsUtil.getIms("TB_MM_AUDIT",mapjson);
        //IMS同步
        String result = imsApi.add(body);
        //记录IMS日志
        Boolean flag = imsLogUtil.ImsLog(body,result, "其他出库单信息","TB_MM_AUDIT");
        //将数据信息 存放到数据库
        this.saveBatch(pojolist);
        //设置同步成功状态
                success=flag;
//        success=true;
        return success;
    }
}
