package org.jeecg.modules.iost.ims.ExternalInterface;

import lombok.Data;
import org.jeecg.modules.iost.ims.ExternalInterface.Interface.API;
import org.jeecg.modules.iost.ims.Util.HttpUtil;
import org.jeecg.modules.iost.ims.entity.ImsInitConnectParm;
import org.jeecg.modules.iost.ims.service.IImsInitConnectParmService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.jeecg.common.exception.imsConnectException;

import javax.annotation.PostConstruct;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @Description: IMS连接
 */
@Service
@Data
public class IMSApi implements API {
    /*private String url = "http://192.168.2.237:8899/soap/IWebService";*/
    private String url;
    private ImsInitConnectParm imsInitConnectParm;
    private List<Map<String, Object>> lists = new ArrayList<Map<String,Object>>();
@Autowired
IImsInitConnectParmService iImsInitConnectParmService;
    @PostConstruct
    public void init() {
        imsInitConnectParm = iImsInitConnectParmService.getBaseMapper().selectById("1");
        url=imsInitConnectParm.getUrl();
    }

    public String add(String InputDTOXml) {
        String result = null;

        try {
           result = HttpUtil.postXml(this.url,InputDTOXml);
        } catch (IOException e) {
                throw new imsConnectException("ims连接失败,请检查ims参数");
        }

        return result;
    }

    @Override
    public String add(Map<String, String> map) {
        return null;
    }

    @Override
    public String select() {
        return null;
    }
}
