package org.jeecg.modules.iost.ims.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.iost.ims.entity.ImsDept;
import org.jeecg.modules.iost.ims.entity.ImsDn;
import org.jeecg.modules.iost.ims.service.IImsDnService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * @Description: ims发货通知单
 * @Author: jeecg-boot
 * @Date:   2021-09-13
 * @Version: V1.0
 */
@Api(tags="发货通知单基本信息")
@RestController
@RequestMapping("/imsDn")
@Slf4j
public class ImsDnController extends JeecgController<ImsDn, IImsDnService> {
    @Autowired
    IImsDnService iImsDnService;

    /**
     * 分页列表查询
     *
     * @param imsDept
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "ims发货通知单基本信息-分页列表查询")
    @ApiOperation(value="ims发货通知单基本信息-分页列表查询", notes="ims发货通知单基本信息-分页列表查询")
    @GetMapping(value = "/list")
    public Result<?> queryPageList(ImsDn imsDept,
                                   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
                                   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
                                   HttpServletRequest req,String date) {
        QueryWrapper<ImsDn> queryWrapper = QueryGenerator.initQueryWrapper(imsDept, req.getParameterMap()).orderByDesc("create_time");
        Page<ImsDn> page = new Page<ImsDn>(pageNo, pageSize);
        if(!"null".equals(date)){
            SimpleDateFormat sdf1 =new SimpleDateFormat("yyyy-MM-dd" );
            Date parse = null;
            try {
                parse = sdf1.parse(date);
            } catch (ParseException e) {
                e.printStackTrace();
            }
            //根据查询日期拿到明天
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(parse);
            calendar.add(Calendar.DATE,1);
            String parse1=sdf1.format(calendar.getTime());
            queryWrapper.gt("create_time",parse);
            queryWrapper.lt("create_time",parse1);
        }
        IPage<ImsDn> pageList = iImsDnService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    /**
     * 同步
     *
     * @return
     * @throws ParseException
     */
    @AutoLog(value = "IMS发货通知单基本信息-同步")
    @ApiOperation(value = "IMS发货通知单基本信息-同步", notes = "IMS发货通知单基本信息-同步")
    @PostMapping(value = "/synchronization")
    public Result<?> synchronization(@RequestBody String id) throws ParseException {
        LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        Boolean flag=iImsDnService.synchronization(id,sysUser);
        if(flag){
            return Result.OK("同步成功");
        }
        return Result.error("同步失败");
    }
}
