package org.jeecg.modules.iost.ims.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.util.RedisLock;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.common.exception.ConnectConstant.KingDeeConstant;
import org.jeecg.common.exception.KingdeeConnectException;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.client.KingdeeK3CloudApiClient;
import org.jeecg.modules.iost.ims.entity.ImsInitConnectParm;
import org.jeecg.modules.iost.ims.entity.Vo.*;
import org.jeecg.modules.iost.ims.service.*;
import org.jeecg.modules.iost.ims.vo.ImsRequest;
import org.jeecg.modules.quartz.entity.QuartzJob;
import org.jeecg.modules.quartz.service.IQuartzJobService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;

import java.text.ParseException;
import java.util.*;

/**
 * @Description: ims采购订单表
 * @Author: jeecg-boot
 * @Date: 2021-09-24
 * @Version: V1.0
 */
@Api(tags = "ims通用接口")
@RestController
@RequestMapping("/WebService")
@Slf4j
public class WebService {

    @Autowired
    IImsPoService iImsPoService;
    @Autowired
    IImsWplanService iImsWplanService;
    @Autowired
    IImsTkwbgService iImsTkwbgService;
    @Autowired
    IImsSalesStoreService iImsSalesStoreService;
    @Autowired
    IImsOutPickingService iImsOutPickingService;
    @Autowired
    IImsSupplyPickingService iImsSupplyPickingService;
    @Autowired
    IImsOutSupplyPickingService iImsOutSupplyPickingService;
    @Autowired
    IImsProduceInstockService iImsProduceInstockService;
    @Autowired
    IImsWplanMnService iImsWplanMnService;
    @Autowired
    IImsOutInstockService iImsOutInstockService;
    @Autowired
    IImsWplanOutsService iImsWplanOutsService;
    @Autowired
    IImsWplanMnOutsService iImsWplanMnOutsService;
    @Autowired
    IImsBomService iImsBomService;
    @Autowired
    IImsXclService iImsXclService;
    @Autowired
    IImsProductionRejectService iImsProductionRejectService;
    @Autowired
    IImsProductionOutRejectService iImsProductionOutRejectService;
    @Autowired
    IImsMtrlXxService iImsMtrlXxService;
    @Autowired
    IImsPurchaseService iImsPurchaseService;
    @Autowired
    IImsOtherOutstockService iImsOtherOutstockService;
    @Autowired
    IImsGainService iImsGainService;
    @Autowired
    IImsLossService iImsLossService;
    @Autowired
    IImsMtrlRejectService iImsMtrlRejectService;
    @Autowired
    IImsSalesreturnService iImsSalesreturnService;
    @Autowired
    IImsProductionpickingService iImsProductionpickingService;
    @Autowired
    IImsOtherGodownentryService iImsOtherGodownentryService;
    @Autowired
    ThreadPoolTaskScheduler threadPoolTaskSched;
    @Autowired
    IImsInitConnectParmService iImsInitConnectParmService;
    @Autowired
    IImsPoReceivingService iImsPoReceivingService;
    @Autowired
    IImsPoRejectionService iImsPoRejectionService;
    @Autowired
    IImsMtrlService iImsMtrlService;
    @Autowired
    IImsStoreService iImsStoreService;
    @Autowired
    IImsCustomerService iImsCustomerService;
    @Autowired
    IImsDeptService iImsDeptService;
    @Autowired
    IImsSupplierService iImsSupplierService;

    /**
     * 传入数据到金蝶云
     *
     * @return
     * @throws ParseException
     */

    @AutoLog(value = "IMS通用接口")
    @ApiOperation(value = "IMS通用接口", notes = "IMS通用接口")
    @PostMapping(value = "/GetData")
    public Result<?> GetData(@RequestBody ImsRequest request) throws ParseException {
        Map<String, Object> data = null;
        //根据识别码调用响应的业务
        //采购订单
            if (request.getCode().equals("PO")) {
                data = iImsPoService.getData(request.getData());
                //ERP工单
            } else if (request.getCode().equals("WPLAN")) {
                data = iImsWplanService.getData(request.getData());
                //ERP委外订单
            } else if (request.getCode().equals("WPLAN_OUTS")) {
                data = iImsWplanOutsService.getData(request.getData());
                //ERP委外工单物料需求单
            } else if (request.getCode().equals("WPLAN_MN_OUTS")) {
                data = iImsWplanMnOutsService.getData(request.getData());
                //ERP工单物料需求信息
            } else if (request.getCode().equals("WPLAN_MN")) {
                data = iImsWplanMnService.getData(request.getData());
                //ERP BOM
            } else if (request.getCode().equals("TB_PM_BOM_HD")) {
                data = iImsBomService.getData(request.getData());
                //ERP库存查询接口
            } else if (request.getCode().equals("XCL")) {
                data = iImsXclService.getData(request.getData());
                //如果最后还是没有数据则返回错误
            } else {
                return Result.fail("操作失败!", "该code类型不存在!", request.getCode());
            }

            if (data.containsKey("false")) {
                return Result.fail("操作失败", data.get("false"), request.getCode());
            }
            return Result.OK(data.get("true"), request.getCode());
    }


    /**
     * 修改添加数据到金蝶云通用接口
     *
     * @return
     * @throws ParseException
     */
    @Autowired
    RedisLock redisLock;

    @AutoLog(value = "IMS通用接口-SetData")
    @ApiOperation(value = "IMS通用接口-SetData", notes = "IMS通用接口-SetData")
    @PostMapping(value = "/SetData")
    public Result<?> SetData(@RequestBody ImsRequestVo request) throws ParseException {
        String token = redisLock.tryLock(request.getCode()+request.getData().get(0).get("QUEUE_ID").toString(), 1000 * 60*2);
        if(token==null)
        {
            return Result.fail("操作失败","请勿提交相同数据!",request.getCode());
        }
        Map<String,String> map=ThreadLocalConfig.get();
        if(map==null)
        {
           map=new HashMap<>();
        }
        map.put("key",request.getCode()+request.getData().get(0).get("QUEUE_ID").toString());
        map.put("token",token);
        ThreadLocalConfig.set(map);
        String result = new String();
       /* if (request.getData().size() == 1) {
            if (request.getCode().equals("TKWBG")) {
                result = iImsTkwbgService.synchronization(request.getData().get(0));
            } else if (request.getCode().equals("R106")) {
                result = iImsProduceInstockService.synchronization(request.getData().get(0));
            } else if (request.getCode().equals("R104")) {
                result = iImsSalesStoreService.synchronization(request.getData().get(0));
            } else if (request.getCode().equals("R014-1")) {
                result = iImsOutPickingService.synchronization(request.getData().get(0));
            } else if (request.getCode().equals("R062")) {
                result = iImsSupplyPickingService.synchronization(request.getData().get(0));
            } else if (request.getCode().equals("R102")) {
                result = iImsProduceInstockService.synchronization(request.getData().get(0));
            } else if (request.getCode().equals("R177C")) {
                result = iImsOutInstockService.synchronization(request.getData().get(0));
            } else if (request.getCode().equals("R019")) {
                result = iImsProductionRejectService.synchronization(request.getData().get(0));
            } else if (request.getCode().equals("R019-1")) {
                result = iImsProductionOutRejectService.synchronization(request.getData().get(0));
            } else if (request.getCode().equals("R010")) {
                result = iImsMtrlXxService.synchronization(request.getData());
            }else if (request.getCode().equals("R170")) {
                result = iImsPurchaseService.setData(request.getData());
            }else if (request.getCode().equals("R062-1")) {
                result = iImsOutSupplyPickingService.synchronization(request.getData().get(0));
            }else if (request.getCode().equals("R100")) {
                result = iImsOutSupplyPickingService.synchronization(request.getData().get(0));
            }
        } else {*/
       try {
           if (request.getCode().equals("TKWBG")) {
               result = iImsTkwbgService.synchronization(request.getData(), request.getCode());
           } else if (request.getCode().equals("R106")) {
               result = iImsProduceInstockService.synchronization(request.getData(), request.getCode());
           } else if (request.getCode().equals("R019")) {
               result = iImsProductionRejectService.synchronization(request.getData(), request.getCode());
           } else if (request.getCode().equals("R104")) {
               result = iImsSalesStoreService.synchronization(request.getData(), request.getCode());
           } else if (request.getCode().equals("R014-1")) {
               result = iImsOutPickingService.synchronization(request.getData(), request.getCode());
           } else if (request.getCode().equals("R062")) {
               result = iImsSupplyPickingService.synchronization(request.getData(), request.getCode());
           } else if (request.getCode().equals("R102")) {
               result = iImsProduceInstockService.synchronization(request.getData(), request.getCode());
           } else if (request.getCode().equals("R177C")) {
               result = iImsOutInstockService.synchronization(request.getData(), request.getCode());
           } else if (request.getCode().equals("R019-1")) {
               result = iImsProductionOutRejectService.synchronization(request.getData(), request.getCode());
           } else if (request.getCode().equals("R010")) {
               result = iImsMtrlXxService.synchronization(request.getData(), request.getCode());
               //采购入库订单
           } else if (request.getCode().equals("R170C")) {
               result = iImsPurchaseService.setData(request.getData(), request.getCode());
           } else if (request.getCode().equals("R062-1")) {
               result = iImsOutSupplyPickingService.synchronization(request.getData(), request.getCode());
           } else if (request.getCode().equals("R100")) {
               if(!ObjectUtils.isEmpty(request.getData().get(0).get("AUDIT_ID")))
               {
                   iImsOtherOutstockService.synchronizationPush(request.getData(), request.getCode());
               }
               result = iImsOtherOutstockService.synchronization(request.getData(), request.getCode());
           } else if (request.getCode().equals("R023")) {
               result = iImsGainService.synchronization(request.getData(), request.getCode());
           } else if (request.getCode().equals("R024")) {
               result = iImsLossService.synchronization(request.getData(), request.getCode());
           } else if (request.getCode().equals("R006")) {
               result = iImsMtrlRejectService.synchronization(request.getData(), request.getCode());
               //其他收料
           } else if (request.getCode().equals("R175C")) {
               result = iImsOtherGodownentryService.setData(request.getData(), request.getCode());
               //销售退货
           } else if (request.getCode().equals("R180C")) {
               result = iImsSalesreturnService.setData(request.getData(), request.getCode());
               //生产领料
           } else if (request.getCode().equals("R014")) {
               result = iImsProductionpickingService.setData(request.getData(), request.getCode());
               //收料通知
           } else if (request.getCode().equals("R170")) {
               result = iImsPoReceivingService.setData(request.getData(), request.getCode());
               //采购拒收
           } else if (request.getCode().equals("R400")) {
               result = iImsPoRejectionService.setData(request.getData(), request.getCode());
           } else {
               return Result.fail("操作失败!", "该code类型不存在!", request.getCode());
           }
        /*  }*/
        result = result.replace("\n", "");
        result = result.replace("\t", "");
        result = result.replace("\r", "");
        result = result.replace(" ", "");
           ThreadLocalConfig.remove();
        return Result.OK(result, request.getCode());
       }finally {
               redisLock.unlock(request.getCode()+request.getData().get(0).get("QUEUE_ID").toString(), token);
       }
    }
    /**
     * 金蝶云分页查询
     *
     * @return
     * @throws ParseException
     */

    @AutoLog(value = "IMS分页查询")
    @ApiOperation(value = "IMS分页查询", notes = "IMS分页查询")
    @PostMapping(value = "/queryList")
    public Result<?> queryList(@RequestBody PageSize pageSize) throws ParseException {
        List<Map<String, String>> list = null;
        //根据识别码调用响应的业务
        //部门信息
        if (pageSize.getCode().equals("BD_Department")) {
            list = iImsDeptService.queryList(pageSize.getPageNo(), pageSize.getPageSize());
            //部门信息
        }else if (pageSize.getCode().equals("TB_PM_BOM_HD")){
            list = iImsBomService.queryList(pageSize.getPageNo(), pageSize.getPageSize());
        }else if (pageSize.getCode().equals("BD_Customer")){
            list = iImsCustomerService.queryList(pageSize.getPageNo(), pageSize.getPageSize());
        }else if (pageSize.getCode().equals("BD_MATERIAL")){
            list = iImsMtrlService.queryList(pageSize.getPageNo(), pageSize.getPageSize());
        }else if (pageSize.getCode().equals("BD_STOCK")){
            list = iImsStoreService.queryList(pageSize.getPageNo(), pageSize.getPageSize());
        }else if (pageSize.getCode().equals("BD_Supplier")){
            list = iImsSupplierService.queryList(pageSize.getPageNo(), pageSize.getPageSize());
        } else {
            return Result.fail("操作失败!","该code类型不存在!",pageSize.getCode());
        }
        return Result.OK(list, pageSize.getCode());
    }
    /*List<Map<String,Object>>转换Map<String,Object>*/
    public Map<String, Object> change(List<Map<String, Object>> data) {
        Map<String, Object> maps = new HashMap<>();
        for (Map<String, Object> datum : data) {
            for (String s : datum.keySet()) {
                maps.put(s, datum.get(s));
            }
        }
        return maps;
    }

    @Autowired
    ISynService synService;

    private Boolean IsOpenSyn = false;
    @Autowired
    private IQuartzJobService quartzJobService;

    /*启动自动同步功能*/
    @AutoLog(value = "IMS通用接口-启动同步功能")
    @ApiOperation(value = "IMS通用接口-启动同步功能", notes = "IMS通用接口-启动同步功能")
    @PostMapping(value = "/ManualSyn")
    public Result ManualSyn() {
        Kingdeelogin();
        if (!IsOpenSyn) {
            QuartzJob job = null;
            job = quartzJobService.getOne(new LambdaQueryWrapper<QuartzJob>().eq(QuartzJob::getJobClassName, "org.jeecg.modules.quartz.job.imsSymJob"));
            quartzJobService.resumeJob(job);
            IsOpenSyn = true;
            return Result.OK("启动自动同步成功");
        }
        Result r = new Result();
        r.setResult("已经启动过，请勿重复启动！");
        return r.error500("已经启动过，请勿重复启动！");
    }

    /*关闭自动同步的定时任务*/
    @PostMapping("/ManualSynStop")
    @AutoLog(value = "IMS通用接口-关闭自动同步的定时任务")
    @ApiOperation(value = "IMS通用接口-关闭自动同步的定时任务", notes = "IMS通用接口-关闭自动同步的定时任务")
    public Result ManualSynStop() {
        Kingdeelogin();
        if (IsOpenSyn) {
            QuartzJob job = null;
            job = quartzJobService.getOne(new LambdaQueryWrapper<QuartzJob>().eq(QuartzJob::getJobClassName, "org.jeecg.modules.quartz.job.imsSymJob"));
            quartzJobService.pause(job);
            IsOpenSyn = false;
            return Result.OK("关闭自动同步成功");
        } else {
            Result r = new Result();
            r.setResult("已经关闭，请勿重复关闭！");
            return r.error500("已经关闭，请勿重复关闭！");
        }

    }

    @Autowired
    CategoryDao categoryDao;
    @Autowired
    IMSApi imsApi;

    /*保存修改连接参数功能*/
    @PostMapping("/ManualSave")
    @AutoLog(value = "IMS通用接口-保存修改连接参数功能")
    @ApiOperation(value = "IMS通用接口-保存修改连接参数功能", notes = "IMS通用接口-保存修改连接参数功能")
    public Result ManualSave(@RequestBody ConnectParmVo connectParmVo) {
        ImsInitConnectParm imsInitConnectParm = iImsInitConnectParmService.getBaseMapper().selectById("1");
        imsInitConnectParm.setK3CloudUrl(connectParmVo.getKingdeeConnectParm().getK3CloudURL());
        imsInitConnectParm.setDbid(connectParmVo.getKingdeeConnectParm().getDbId());
        imsInitConnectParm.setUid(connectParmVo.getKingdeeConnectParm().getUid());
        imsInitConnectParm.setPwd(connectParmVo.getKingdeeConnectParm().getPwd());
        imsInitConnectParm.setLang(connectParmVo.getKingdeeConnectParm().getLang());
        /*  imsInitConnectParm.setIsAutoSubmit(Integer.valueOf(connectParmVo.getKingdeeConnectParm().getIsAutoSubmit()));*/
        imsInitConnectParm.setUrl(connectParmVo.getImsConParm().getUrl());
        iImsInitConnectParmService.getBaseMapper().updateById(imsInitConnectParm);
        //改变单例categoryDao值
        categoryDao.setK3CloudURL(connectParmVo.getKingdeeConnectParm().getK3CloudURL());
        categoryDao.setDbId(connectParmVo.getKingdeeConnectParm().getDbId());
        categoryDao.setUid(connectParmVo.getKingdeeConnectParm().getUid());
        categoryDao.setPwd(connectParmVo.getKingdeeConnectParm().getPwd());
        categoryDao.setLang(connectParmVo.getKingdeeConnectParm().getLang());
        /*  categoryDao.setIsAutoSubmit(Integer.valueOf(connectParmVo.getKingdeeConnectParm().getIsAutoSubmit()));*/
        imsApi.setUrl(connectParmVo.getImsConParm().getUrl());
        KingdeeK3CloudApiClient client = categoryDao.getClient();
        client = new KingdeeK3CloudApiClient(connectParmVo.getKingdeeConnectParm().getK3CloudURL());
        categoryDao.setClient2(new KingdeeK3CloudApiClient(connectParmVo.getKingdeeConnectParm().getK3CloudURL()));
        categoryDao.setClient3(new KingdeeK3CloudApiClient(connectParmVo.getKingdeeConnectParm().getK3CloudURL()));
        categoryDao.setClient(client);
        AfterKingdeelogin();
        return Result.OK("保存成功");
    }

    /*检验连接参数功能*/
    @PostMapping("/ManualCheck")
    @AutoLog(value = "IMS通用接口-检验连接参数功能")
    @ApiOperation(value = "IMS通用接口-检验连接参数功能", notes = "IMS通用接口-检验连接参数功能")
    public Result ManualCheck(@RequestBody ConnectParmVo connectParmVo) {
        Boolean result = false;
        KingdeeK3CloudApiClient client = new KingdeeK3CloudApiClient(connectParmVo.getKingdeeConnectParm().getK3CloudURL());
        String k3CloudURL = connectParmVo.getKingdeeConnectParm().getK3CloudURL();
        String dbId = connectParmVo.getKingdeeConnectParm().getDbId();
        String uid = connectParmVo.getKingdeeConnectParm().getUid();
        String pwd = connectParmVo.getKingdeeConnectParm().getPwd();
        int lang = connectParmVo.getKingdeeConnectParm().getLang();
        String loginResult = new String();
        Object[] loginInfo = new Object[]{dbId, uid, pwd, lang};
        try {
            loginResult = client.execute("Kingdee.BOS.WebApi.ServicesStub.AuthService.ValidateUser", loginInfo, String.class);
        } catch (Exception e) {
            throw new KingdeeConnectException(KingDeeConstant.URL);
        }
        com.alibaba.fastjson.JSONObject jsonObject = new JSONObject();
        try {
            jsonObject = JSON.parseObject(loginResult);
        } catch (Exception e) {
            throw new KingdeeConnectException(KingDeeConstant.PORT);
        }
        if (!ObjectUtils.isEmpty(jsonObject)) {
            if (KingDeeConstant.LoginValue.equals(jsonObject.get("Message"))) {
                throw new KingdeeConnectException(KingDeeConstant.LoginValue);
            } else if (KingDeeConstant.DBID.equals(jsonObject.get("Message"))) {
                throw new KingdeeConnectException(KingDeeConstant.DBID);
            }
            return Result.OK("参数正确,金蝶云连接成功");
        }
        return Result.OK("参数正确,金蝶云连接成功");
    }

    @Autowired
    IQuartzJobService iQuartzJobService;

    /*页面获取保存参数功能*/
    @GetMapping("/GetSaveParm")
    @AutoLog(value = "IMS通用接口-页面获取保存参数功能")
    @ApiOperation(value = "IMS通用接口-页面获取保存参数功能", notes = "IMS通用接口-页面获取保存参数功能")
    public Result GetSaveParm() {
        ConnectParmVo connectParmVo = new ConnectParmVo();
        ImsInitConnectParm imsInitConnectParm = iImsInitConnectParmService.getBaseMapper().selectById("1");
        String k3CloudUrl = imsInitConnectParm.getK3CloudUrl();
        kingdeeConnectParm kingdeeConnectParm = new kingdeeConnectParm();
        kingdeeConnectParm.setK3CloudURL(k3CloudUrl);
        kingdeeConnectParm.setDbId(imsInitConnectParm.getDbid());
        kingdeeConnectParm.setUid(imsInitConnectParm.getUid());
        kingdeeConnectParm.setPwd(imsInitConnectParm.getPwd());
        kingdeeConnectParm.setLang(imsInitConnectParm.getLang());
        imsConnectParm imsConParm = new imsConnectParm();
        imsConParm.setUrl(imsInitConnectParm.getUrl());
        connectParmVo.setKingdeeConnectParm(kingdeeConnectParm);
        connectParmVo.setImsConParm(imsConParm);
        QuartzJob quartzJob = iQuartzJobService.getBaseMapper().selectById("999");
        connectParmVo.setIsSynchronize(quartzJob.getStatus().equals(-1) ? false : true);
        return Result.OK(connectParmVo);
    }

    /*test*/
    @GetMapping("/test")
    @AutoLog(value = "IMS通用接口-test")
    @ApiOperation(value = "IMS通用接口-test", notes = "IMS通用接口-test")
    public Result test(String test) {
        Map<String,String> key =new HashMap<>();
        Map<String,String> where =new HashMap<>();
        key.put("FStaffNumber","FStaffNumber");
        where.put("FNumber",test);
        List<List<Object>> bd_newstaff = categoryDao.select("BD_NEWSTAFF", key, where);
        String FNumber  = bd_newstaff.get(0).get(0).toString();
       return Result.OK(FNumber);
    }

    //金蝶云登录公用方法
    public void Kingdeelogin() {
        KingdeeK3CloudApiClient client = categoryDao.getClient();
        Boolean result = categoryDao.getResult();
        String dbId = categoryDao.getDbId();
        String uid = categoryDao.getUid();
        String pwd = categoryDao.getPwd();
        int lang = categoryDao.getLang();
        String loginResult = new String();
        Object[] loginInfo = new Object[]{dbId, uid, pwd, lang};
        try {
            loginResult = client.execute("Kingdee.BOS.WebApi.ServicesStub.AuthService.ValidateUser", loginInfo, String.class);
        } catch (Exception e) {
            result = false;
            categoryDao.setLoginResult(KingDeeConstant.URL);
            throw new KingdeeConnectException(KingDeeConstant.URL);
        }

        com.alibaba.fastjson.JSONObject jsonObject = new JSONObject();
        try {
            jsonObject = JSON.parseObject(loginResult);
        } catch (Exception e) {
            result = false;
            categoryDao.setLoginResult(KingDeeConstant.PORT);
            throw new KingdeeConnectException(KingDeeConstant.PORT);
        }
        if (!ObjectUtils.isEmpty(jsonObject)) {
            if (KingDeeConstant.LoginValue.equals(jsonObject.get("Message"))) {
                result = false;
                categoryDao.setLoginResult(KingDeeConstant.LoginValue);
                throw new KingdeeConnectException(KingDeeConstant.LoginValue);
            } else if (KingDeeConstant.DBID.equals(jsonObject.get("Message"))) {
                result = false;
                categoryDao.setLoginResult(KingDeeConstant.DBID);
                throw new KingdeeConnectException(KingDeeConstant.DBID);
            } else {
                result = true;
            }

        }
        try {
            result = client.login(dbId, uid, pwd, lang);
        } catch (Exception e) {
            e.printStackTrace();
        }
        categoryDao.setClient(client);
        categoryDao.setResult(result);
    }

    //金蝶云保存后检验登录参数
    public void AfterKingdeelogin() {
        KingdeeK3CloudApiClient client = categoryDao.getClient();
        Boolean result = categoryDao.getResult();
        String dbId = categoryDao.getDbId();
        String uid = categoryDao.getUid();
        String pwd = categoryDao.getPwd();
        int lang = categoryDao.getLang();
        String loginResult = new String();
        Object[] loginInfo = new Object[]{dbId, uid, pwd, lang};
        try {
            loginResult = client.execute("Kingdee.BOS.WebApi.ServicesStub.AuthService.ValidateUser", loginInfo, String.class);
        } catch (Exception e) {
            log.error(KingDeeConstant.URL);
            result = false;
            categoryDao.setLoginResult(KingDeeConstant.URL);
        }

        com.alibaba.fastjson.JSONObject jsonObject = new JSONObject();
        try {
            jsonObject = JSON.parseObject(loginResult);
        } catch (Exception e) {
            log.error(KingDeeConstant.PORT);
            result = false;
            categoryDao.setLoginResult(KingDeeConstant.PORT);
        }
        if (!ObjectUtils.isEmpty(jsonObject)) {
            if (KingDeeConstant.LoginValue.equals(jsonObject.get("Message"))) {
                log.error(KingDeeConstant.LoginValue);
                result = false;
                categoryDao.setLoginResult(KingDeeConstant.LoginValue);
            } else if (KingDeeConstant.DBID.equals(jsonObject.get("Message"))) {
                log.error(KingDeeConstant.DBID);
                result = false;
                categoryDao.setLoginResult(KingDeeConstant.DBID);
            } else {
                result = true;
            }

        }
        try {
            result = client.login(dbId, uid, pwd, lang);
        } catch (Exception e) {
            e.printStackTrace();
        }
        categoryDao.setClient(client);
        categoryDao.setResult(result);
    }
}
