package org.jeecg.modules.iost.ims.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 物料、成品基本信息
 * @Author: jeecg-boot
 * @Date:   2021-09-07
 * @Version: V1.0
 */
@Data
@TableName("ims_mtrl")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="ims_mtrl对象", description="物料、成品基本信息")
public class ImsMtrl implements Serializable {
    private static final long serialVersionUID = 1L;

    /**主键*/
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private java.lang.String id;
    /**物料编码*/
    @Excel(name = "物料编码", width = 15)
    @ApiModelProperty(value = "物料编码")
    private java.lang.String mtrlId;
    /**物料名称*/
    @Excel(name = "物料名称", width = 15)
    @ApiModelProperty(value = "物料名称")
    private java.lang.String mtrlName;
    /**物料规格*/
    @Excel(name = "物料规格", width = 15)
    @ApiModelProperty(value = "物料规格")
    private java.lang.String mtrlDesc;
    /**生产分类（1原材料--外购件2成品--自制、委外加工、虚拟件）*/
    @Excel(name = "生产分类（1原材料--外购件2成品--自制、委外加工、虚拟件）", width = 15)
    @ApiModelProperty(value = "生产分类（1原材料--外购件2成品--自制、委外加工、虚拟件）")
    private java.lang.Integer prodMtype;
    /**最小包装数量 默认1*/
    @Excel(name = "最小包装数量 默认1", width = 15)
    @ApiModelProperty(value = "最小包装数量 默认1")
    private java.lang.Integer packQty;
    /**单位编码*/
    @Excel(name = "单位编码", width = 15)
    @ApiModelProperty(value = "单位编码")
    private java.lang.String munit;
    /**ABC分类 默认2*/
    @Excel(name = "ABC分类 默认2", width = 15)
    @ApiModelProperty(value = "ABC分类 默认2")
    private java.lang.Integer mtrlLev;
    /**禁用 Y- N*/
    @Excel(name = "禁用 Y- N", width = 15)
    @ApiModelProperty(value = "禁用 Y- N")
    private java.lang.String disable;
    /**是否免检(Y是N否) 默认 N*/
    @Excel(name = "是否免检(Y是N否) 默认 N", width = 15)
    @ApiModelProperty(value = "是否免检(Y是N否) 默认 N")
    private java.lang.String isSts;
    /**使用组织编码*/
    @Excel(name = "使用组织编码", width = 15)
    @ApiModelProperty(value = "使用组织编码")
    private java.lang.String orgId;
    /**物料分组（电子，）*/
    @Excel(name = "物料分组（电子，）", width = 15)
    @ApiModelProperty(value = "物料分组（电子，）")
    private java.lang.String mtrlGroup;
    /**默认仓库*/
    @Excel(name = "默认仓库", width = 15)
    @ApiModelProperty(value = "默认仓库")
    private java.lang.String storeId;
    /**承认状态（0--未承认 1—已承认）*/
    @Excel(name = "承认状态（0--未承认 1—已承认）", width = 15)
    @ApiModelProperty(value = "承认状态（0--未承认 1—已承认）")
    private java.lang.String isAdmit;
    /**实体主键*/
    @Excel(name = "实体主键", width = 15)
    @ApiModelProperty(value = "实体主键")
    private java.lang.String fid;
    /**创建人*/
    @ApiModelProperty(value = "创建人")
    private java.lang.String createBy;
    /**创建日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private java.util.Date createTime;
    /**更新人*/
    @ApiModelProperty(value = "更新人")
    private java.lang.String updateBy;
    /**更新日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;
    /**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private java.lang.String sysOrgCode;
}
