package org.jeecg.modules.iost.ims.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: ims采购订单表
 * @Author: jeecg-boot
 * @Date:   2021-10-19
 * @Version: V1.0
 */
@Data
@TableName("ims_po")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="ims_po对象", description="ims采购订单表")
public class ImsPo implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private java.lang.String id;
	/**采购单编码*/
	@Excel(name = "采购单编码", width = 15)
    @ApiModelProperty(value = "采购单编码")
    private java.lang.String poId;
	/**采购单行号*/
	@Excel(name = "采购单行号", width = 15)
    @ApiModelProperty(value = "采购单行号")
    private java.lang.String poLine;
	/**物料编码*/
	@Excel(name = "物料编码", width = 15)
    @ApiModelProperty(value = "物料编码")
    private java.lang.String mtrlId;
	/**物料数量*/
	@Excel(name = "物料数量", width = 15)
    @ApiModelProperty(value = "物料数量")
    private java.lang.String mqty;
	/**已接收数量 --收料通知单数量*/
	@Excel(name = "已接收数量 --收料通知单数量", width = 15)
    @ApiModelProperty(value = "已接收数量 --收料通知单数量")
    private java.lang.String rmQty;
	/**已入库数量*/
	@Excel(name = "已入库数量", width = 15)
    @ApiModelProperty(value = "已入库数量")
    private java.lang.String smQty;
	/**供应商编码*/
	@Excel(name = "供应商编码", width = 15)
    @ApiModelProperty(value = "供应商编码")
    private java.lang.String supId;
	/**仓库编码 默认空*/
	@Excel(name = "仓库编码 默认空", width = 15)
    @ApiModelProperty(value = "仓库编码 默认空")
    private java.lang.String storeId;
	/**是否委外 （Y是N否）单据类型（标准委外和标准采购区分）*/
	@Excel(name = "是否委外 （Y是N否）单据类型（标准委外和标准采购区分）", width = 15)
    @ApiModelProperty(value = "是否委外 （Y是N否）单据类型（标准委外和标准采购区分）")
    private java.lang.String isOuts;
	/**物料采购交期*/
	@Excel(name = "物料采购交期", width = 15)
    @ApiModelProperty(value = "物料采购交期")
    private java.lang.String pdhDate;
	/**采购组织*/
	@Excel(name = "采购组织", width = 15)
    @ApiModelProperty(value = "采购组织")
    private java.lang.String poOrgId;
	/**收料组织*/
	@Excel(name = "收料组织", width = 15)
    @ApiModelProperty(value = "收料组织")
    private java.lang.String orgId;
	/**创建时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
    private java.util.Date createTime;
	/**主键ID*/
	@Excel(name = "主键ID", width = 15)
    @ApiModelProperty(value = "主键ID")
    private java.lang.String fid;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private java.lang.String createBy;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private java.lang.String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;
	/**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private java.lang.String sysOrgCode;
    /**结算方*/
    @ApiModelProperty(value = "结算方")
    private java.lang.String settleSup;
}
