package org.jeecg.modules.iost.ims.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 采购订单收料
 * @Author: jeecg-boot
 * @Date:   2021-12-08
 * @Version: V1.0
 */
@Data
@TableName("ims_po_receiving")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="ims_po_receiving对象", description="采购订单收料")
public class ImsPoReceiving implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private java.lang.String id;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private java.lang.String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private java.util.Date createTime;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private java.lang.String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;
	/**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private java.lang.String sysOrgCode;
	/**唯一序号*/
	@Excel(name = "唯一序号", width = 15)
    @ApiModelProperty(value = "唯一序号")
    private java.lang.String queueId;
	/**交易时间*/
	@Excel(name = "交易时间", width = 15)
    @ApiModelProperty(value = "交易时间")
    private java.lang.String trxDate;
	/**仓库编码*/
	@Excel(name = "仓库编码", width = 15)
    @ApiModelProperty(value = "仓库编码")
    private java.lang.String storeId;
	/**供应商编码*/
	@Excel(name = "供应商编码", width = 15)
    @ApiModelProperty(value = "供应商编码")
    private java.lang.String supId;
	/**采购单号*/
	@Excel(name = "采购单号", width = 15)
    @ApiModelProperty(value = "采购单号")
    private java.lang.String poId;
	/**采购单行号*/
	@Excel(name = "采购单行号", width = 15)
    @ApiModelProperty(value = "采购单行号")
    private java.lang.String poSeq;
	/**物料编码*/
	@Excel(name = "物料编码", width = 15)
    @ApiModelProperty(value = "物料编码")
    private java.lang.String mtrlId;
	/**数量*/
	@Excel(name = "数量", width = 15)
    @ApiModelProperty(value = "数量")
    private java.lang.String quantity;
	/**备注*/
	@Excel(name = "备注", width = 15)
    @ApiModelProperty(value = "备注")
    private java.lang.String remark;
	/**收料组织*/
	@Excel(name = "收料组织", width = 15)
    @ApiModelProperty(value = "收料组织")
    private java.lang.String orgId;
	/**采购组织*/
	@Excel(name = "采购组织", width = 15)
    @ApiModelProperty(value = "采购组织")
    private java.lang.String poOrgId;
	/**基本信息主键ID*/
	@Excel(name = "基本信息主键ID", width = 15)
    @ApiModelProperty(value = "基本信息主键ID")
    private java.lang.String fid;
	/**单据编码*/
	@Excel(name = "单据编码", width = 15)
    @ApiModelProperty(value = "单据编码")
    private java.lang.String fbillno;
	/**明细信息主键ID*/
	@Excel(name = "明细信息主键ID", width = 15)
    @ApiModelProperty(value = "明细信息主键ID")
    private java.lang.String fentryId;
	/**单据行号*/
	@Excel(name = "单据行号", width = 15)
    @ApiModelProperty(value = "单据行号")
    private java.lang.String fseq;
    /**父单据明细序号*/
    @Excel(name = "父单据明细序号", width = 15)
    @ApiModelProperty(value = "父单据明细序号")
    private java.lang.String ffentryId;
    /**结算方*/
    @Excel(name = "结算方", width = 15)
    @ApiModelProperty(value = "结算方")
    private java.lang.String settleSup;
}
