package org.jeecg.modules.iost.ims.service.impl;

import com.alibaba.fastjson.JSON;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.KingdeeLogUtil;
import org.jeecg.modules.iost.ims.entity.ImsBom;
import org.jeecg.modules.iost.ims.entity.ImsWplanMnOuts;
import org.jeecg.modules.iost.ims.kingdeeapi.BomKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsBomMapper;
import org.jeecg.modules.iost.ims.service.IImsBomService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description: imsbom
 * @Author: jeecg-boot
 * @Date:   2021-10-04
 * @Version: V1.0
 */
@Service
public class ImsBomServiceImpl extends ServiceImpl<ImsBomMapper, ImsBom> implements IImsBomService {
    @Autowired
    BomKingdeeApi bomKingdeeApi;
    /**
     * 手动获取金蝶云物料清单
     * @param mapjson
     * @return
     */
    @Override
    public Map<String,Object> getData(List<Map<String,Object>> mapjson) {
        List<Map<String, String>> list=new ArrayList<>();
        List<Map<String, String>> list1=new ArrayList<>();
        Map<String,Object> map=new HashMap<>();
        ImsLogUtil imsLogUtil=new ImsLogUtil();
        List<ImsBom> pojolist=new ArrayList<>();
        //记录IMS日志
        imsLogUtil.ImsRequestLog(JsonUtil.Listjson(mapjson), "ERP BOM","TB_PM_BOM_HD");
        for(Map<String,Object> maps:mapjson){
            //将数据取出来
            //获取用料订单编码
            String poId=maps.get("PROD_ID").toString();
            Map<String,String> idmap=new HashMap<>();
            //将对应的参数设置成金蝶云的查询条件
            //根据主键ID去查
            idmap.put("FMATERIALID.Fnumber",poId);
            //从金蝶云获取对应数据
            list1 = bomKingdeeApi.selectAndLog(idmap, null,"ERP BOM");
            //将每次获取的数据添加到集合一起返回
            list.addAll(list1);
            for (Map<String, String> data : list1) {
                //将实体信息记录下来
                //判断是否有错误
                if(data.containsKey("false")){
                    map.put("false",data.get("false"));
                    return map;
                }
                ImsBom pojo = new ImsBom();
                pojo.setFid(data.get("fid"));
                //将物料编码设置进实体
                pojo.setProdId(poId);
                pojo.setMtrlId(data.get("MTRL_ID"));
                pojo.setMainId(data.get("MAIN_ID"));
                pojo.setPointStr(data.get("POINT_STR"));
                pojo.setIsMain(data.get("IS_MAIN"));
                pojo.setDosage(data.get("DOSAGE"));
                pojo.setCreateTime(new Date());
                pojolist.add(pojo);
            }
        }
        //将数据信息 存放到数据库
        this.saveBatch(pojolist);
        //将查询结果封装成JSON
        String listjson = JsonUtil.Listjson(list);
        //将结果返回
        map.put("true",list);
        return map;
    }

    @Override
    public List<Map<String, String>> queryList(Integer pageNo, Integer pageSize) throws ParseException {
        List<Map<String, String>> list = bomKingdeeApi.queryList(null, null, "物料清单分页查询", pageNo, pageSize);
        return list;
    }

}
