package org.jeecg.modules.iost.ims.service.impl;
import org.jeecg.common.exception.KingdeeRepeatException;
import org.jeecg.common.exception.kingdeeException;
import org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.ErrorsInside;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsMtrlRejectApi;
import org.springframework.stereotype.Service;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.MapUtils;
import org.jeecg.modules.iost.ims.entity.ImsMtrlReject;
import org.jeecg.modules.iost.ims.mapper.ImsMtrlRejectMapper;
import org.jeecg.modules.iost.ims.service.IImsMtrlRejectService;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.*;
/**
 * @Description: ims_mtrl_reject
 * @Author: jeecg-boot
 * @Date:   2021-10-07
 * @Version: V1.0
 */
@Service
public class ImsMtrlRejectServiceImpl extends ServiceImpl<ImsMtrlRejectMapper, ImsMtrlReject> implements IImsMtrlRejectService {
    @Autowired
    ImsMtrlRejectApi ImsMtrlRejectApi;
    private String imsLogName;
    private String DocType;
    private String SEQ;
    private String wipOrde;
    public ImsMtrlRejectServiceImpl() {
        this.imsLogName="材料退供应商";  //ims日志-name
        this.DocType="R006";  //调用者传入的标识
        this.SEQ="PO_SEQ";  //父单据行号，一般默认是这个字符串(有些单据是PO_SEQ)
        this.wipOrde="PO_ID";  //父亲单据工单编号或者行内码
    }

    public String synchronization(List<Map<String,Object>> needLists,String code) {
        List<ImsMtrlReject> ImsMtrlRejects=new ArrayList<>();
        //查询父单据失败的lists
        List<Map<String,Object>> SelectFatherFentryIdFailLists=new ArrayList();
        //查询父单据失败的返回结果
        List<String> SelectFatherFentryIdFailResult=new ArrayList<>();
        //拼接唯一序号重复的返回结果
        List<String> queue_idRepeatResult=new ArrayList<>();
        //请求参数的inputDTOXml里面json格式的参数传入ims同步日志(imslog)
        ImsLogUtil imsLogUtil = new ImsLogUtil();
        imsLogUtil.ImsRequestLog(JSON.toJSONString(needLists), imsLogName, DocType);
        List<String> qidList = new ArrayList<>();
        for (Map<String, Object> maps : needLists) {
            qidList.add(maps.get("QUEUE_ID").toString());
        }
        QueryWrapper<ImsMtrlReject> qw=new QueryWrapper();
        qw.in("queue_id",qidList);
        StringBuilder builder=new StringBuilder();
        int length=qidList.size();
        for (int i=0;i<length;i++) {
            if(i==0)
            {
                builder.append(qidList.get(i));
            }
            else
            {
                builder.append(",").append(qidList.get(i));
            }
        }
        qw.orderByAsc("FIELD(queue_id,"+builder.toString()+")");
        List<ImsMtrlReject> repeatLists = this.getBaseMapper().selectList(qw);
        if (!CollectionUtils.isEmpty(repeatLists)) {
            queue_idRepeatResult=ResultSplitOne(repeatLists);
        }
        if(!CollectionUtils.isEmpty(queue_idRepeatResult)) {
            throw new KingdeeRepeatException("操作失败!", queue_idRepeatResult.get(0),code);
        }
        //判断需要修改的needLists里面有没有元素，有元素说明有东西未修改过，没有说明添加进来的数据都已经修改过了
        List<String> Father_FEntryIDs=new ArrayList<>();
        if(!ObjectUtils.isEmpty(needLists)) {
            Father_FEntryIDs = ImsMtrlRejectApi.queryFatherFEntryIDs(needLists, SelectFatherFentryIdFailLists);
            SelectFatherFentryIdFailResult=ResultSplitTwo(SelectFatherFentryIdFailLists);
        }
        if(!CollectionUtils.isEmpty(SelectFatherFentryIdFailResult)) {
            throw new kingdeeException("操作失败!", SelectFatherFentryIdFailResult,code);
        }
        //下推失败返回结果
        List<String> pushResultLists=new ArrayList<>();
        List<String> AddResultLists=new ArrayList();
        org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result AddResult=new org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result();
        if(!ObjectUtils.isEmpty(needLists)) {
            org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result result=ImsMtrlRejectApi.push(needLists,Father_FEntryIDs);
            pushResultLists = ResultSplitThree(result);
            if(!CollectionUtils.isEmpty(pushResultLists)) {
                throw new kingdeeException("操作失败!下推失败!", pushResultLists,code);
            }
            //查询子单据行内码
            for (Map<String, Object> needmap : needLists) {
                String Son_FEntry_ID = ImsMtrlRejectApi.querySonFEntryID(needmap.get(needmap.get("PO_ID").toString()+needmap.get("PO_SEQ").toString()).toString(),needmap.get(SEQ).toString(), result.getResponseStatus().getSuccessEntitys().get(0).getId());
                needmap.put("FID", result.getResponseStatus().getSuccessEntitys().get(0).getId());
                needmap.put("FEntry_ID",Son_FEntry_ID);

            }
            //修改成功下推后needPushLists的数据
            AddResult=ImsMtrlRejectApi.addTwo(needLists);
            if(AddResult.getResponseStatus().getIsSuccess())
            {
                for (Map<String, Object> needmap : needLists) {
                    needmap.put("FBILL_NO",AddResult.getNumber());
                    //Map传入参数大写字段转化为实体类字段
                    Map<String, Object> map = MapUtils.mapsChange(needmap);
                    ImsMtrlReject ImsMtrlReject = JSON.parseObject(JSON.toJSONString(map), ImsMtrlReject.class);//map转为实体类对象
                    ImsMtrlRejects.add(ImsMtrlReject);
                }
            }
            AddResultLists = ResultSplitFour(AddResult);
            if(!CollectionUtils.isEmpty(AddResultLists)) {
                throw new kingdeeException("操作失败!修改失败!", AddResultLists,code); }
        }
        //保存实体类
        this.saveBatch(ImsMtrlRejects);
        return ImsMtrlRejects.get(0).getFbillNo();
    }

    public List<String> ResultSplitFour(org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result AddResult)
    {
        String result=new String();
        List<String> rustList=new ArrayList<>();
        Boolean isSuccess = AddResult.getResponseStatus().getIsSuccess();
        if(!isSuccess)
        {
            List<ErrorsInside> errors = AddResult.getResponseStatus().getErrors();
            for (ErrorsInside error : errors) {
                rustList.add(error.getMessage());
            }
        }
        return rustList;
    }

    public List<String> ResultSplitThree(org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result pushResult)
    {
        String result=new String();
        List<String> rustList=new ArrayList<>();
        Boolean isSuccess = pushResult.getResponseStatus().getIsSuccess();
        if(!isSuccess)
        {
            List<ErrorsInside> errors = pushResult.getResponseStatus().getErrors();
            for (ErrorsInside error : errors) {
                rustList.add(error.getMessage());
            }
        }
        return rustList;
    }

    public List<String> ResultSplitTwo(List<Map<String,Object>> SelectFatherFentryIdFailLists)
    {
        String result=new String();
        List<String> rustList=new ArrayList<>();
        List<String> rustListAfter=new ArrayList<>();
        for (Map<String, Object> queue_idRepeatResultMap : SelectFatherFentryIdFailLists) {
            if(!ObjectUtils.isEmpty(queue_idRepeatResultMap.get("notExitFbillNo"))&&Boolean.valueOf(queue_idRepeatResultMap.get("notExitFbillNo").toString())==true)
            {
                String queue_id = queue_idRepeatResultMap.get("QUEUE_ID").toString();
                result="采购单编码"+queue_idRepeatResultMap.get(wipOrde)+"不存在，无法进行下推修改!";
                rustList.add(result);
            }
            else
            {
                String queue_id = queue_idRepeatResultMap.get("QUEUE_ID").toString();
                result="唯一序号为("+queue_id+")且行号为("+queue_idRepeatResultMap.get(SEQ)+")的数据不存在，无法进行下推修改!";
                rustList.add(result);
            }
        }
        HashSet<String> set=new LinkedHashSet();
        for (String s : rustList) {
            set.add(s);
        }
        for (String s : set) {
            rustListAfter.add(s);
        }
        return rustListAfter;
    }

    public List<String> ResultSplitOne(List<ImsMtrlReject> repeatLists)
    {
        String result=new String();
        LinkedHashSet<String> hashset=new LinkedHashSet<>();
        for (ImsMtrlReject ImsMtrlReject : repeatLists) {
            String queue_id = String.valueOf(ImsMtrlReject.getQueueId());
            result="QUEUE_ID为("+queue_id+")的数据已经提交过!";
            hashset.add(result);
        }
        List<String> rustList=new ArrayList<>();
        String result2=new String();
        for (String s : hashset) {
            rustList.add(s);
        }
        return rustList;
    }

}
