package org.jeecg.modules.iost.ims.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import net.sf.json.JSONObject;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.ImsUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.KingdeeLogUtil;
import org.jeecg.modules.iost.ims.entity.ImsMtrl;
import org.jeecg.modules.iost.ims.entity.ImsStore;
import org.jeecg.modules.iost.ims.kingdeeapi.MtrlKingdeeApi;
import org.jeecg.modules.iost.ims.kingdeeapi.StoreKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsStoreMapper;
import org.jeecg.modules.iost.ims.service.IImsStoreService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description: ims仓库基本信息
 * @Author: jeecg-boot
 * @Date:   2021-09-10
 * @Version: V1.0
 */
@Service
public class ImsStoreServiceImpl extends ServiceImpl<ImsStoreMapper, ImsStore> implements IImsStoreService {
    @Autowired
    StoreKingdeeApi kingdeeApi;
    @Autowired
    IMSApi imsApi;
    @Override
    public JSONObject add(Map<String, String> map) {
        return null;
    }

    @Override
    public JSONObject select(Map<String, String> map) {
        return null;
    }


    /**
     * 从金蝶云同步仓库信息
     * @param id
     * @return
     * @throws ParseException
     */
    @Override
    public Boolean synchronization(String id, LoginUser sysUser) throws ParseException {
        KingdeeLogUtil kingdeeLogUtil =new KingdeeLogUtil();
        List<ImsStore> pojolist=new ArrayList<>();
        ImsLogUtil imsLogUtil=new ImsLogUtil();
        List<Map<String, String>> list=new ArrayList<>();
        Boolean success = false;
        Map<String,String> idmap=new HashMap<>();
        //设置需要同步的主键
        idmap.put("FStockId",id);
        //将对应信息请求金蝶云
        list = kingdeeApi.selectAndLog(idmap, null,"仓库信息");
            //遍历集合拿到所有的MAP
            for (Map<String, String> data : list) {
                //判断是否有错误
                if(data.containsKey("false")){
                    return success;
                }
                //将实体信息记录下来
                ImsStore pojo = new ImsStore();
                pojo.setFid(data.get("fid"));
                pojo.setStoreId(data.get("STORE_ID"));
                pojo.setErpStoreId(data.get("ERP_STORE_ID"));
                pojo.setDisable(data.get("DISABLE"));
                pojo.setOrgId(data.get("ORG_ID"));
                pojo.setStoreName(data.get("STORE_NAME"));
                pojo.setStoreType(data.get("STORE_TYPE"));
                pojo.setCreateTime(new Date());
                if(sysUser!=null){
                    pojo.setCreateBy(sysUser.getUsername());
                    pojo.setSysOrgCode(sysUser.getOrgCode());
                }
                pojolist.add(pojo);
            }
                //将数据信息 存放到数据库
                this.saveBatch(pojolist);
                //将数据包装成IMS格式
                Map<String,Object> map=new HashMap<>();
                map.put("success","true");
                map.put("message","操作成功");
                map.put("result", list);
                String mapjson = JsonUtil.Mapjson(map);
                String request=JsonUtil.Listjson(list);
                String body = ImsUtil.getIms("TB_BS_STORE",mapjson);
                //IMS同步
                String result = imsApi.add(body);
                //记录IMS日志
                Boolean flag = imsLogUtil.ImsLog(body,result, "仓库信息","TB_BS_STORE");
                //设置同步成功状态
                success=flag;
//                success=true;
        return success;
    }

    @Override
    public Boolean grid(Map<String, String> stringStringMap) throws ParseException {
        return null;
    }

    @Override
    public List<Map<String, String>> queryList(Integer pageNo, Integer pageSize) throws ParseException {
        List<Map<String, String>> list = kingdeeApi.queryList(null, null, "仓库信息分页查询", pageNo, pageSize);
        return list;
    }
}
