package org.jeecg.modules.iost.ims.service.impl;



import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import net.sf.json.JSONObject;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.ImsUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.KingdeeLogUtil;
import org.jeecg.modules.iost.ims.entity.ImsSupplier;
import org.jeecg.modules.iost.ims.entity.Kingdeelog;
import org.jeecg.modules.iost.ims.kingdeeapi.SupplierKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsSupplierMapper;
import org.jeecg.modules.iost.ims.service.IImsSupplierService;

import org.jeecg.modules.iost.ims.service.IKingdeelogService;
import org.jeecg.modules.iost.ims.vo.Request;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Description: 供应商基础信息
 * @Author: jeecg-boot
 * @Date:   2021-08-31
 * @Version: V1.0
 */
@Service
public class ImsSupplierServiceImpl extends ServiceImpl<ImsSupplierMapper, ImsSupplier> implements IImsSupplierService {

    @Autowired
    SupplierKingdeeApi supplierKingdeeApi;
    @Autowired
    ImsSupplierMapper supplierMapper;
    @Autowired
    IMSApi imsApi;
    @Override
    public JSONObject add(Map<String, String> map) {
        return null;
    }

    @Override
    public JSONObject select(Map<String, String> map) {
        return null;
    }

    /**
     * 从金蝶云同步供应商信息
     * @param object
     * @return
     * @throws ParseException
     */
    @Override
    public Boolean synchronization(Object object, LoginUser sysUser) throws ParseException {
        KingdeeLogUtil kingdeeLogUtil =new KingdeeLogUtil();
        List<ImsSupplier> pojolist=new ArrayList<>();
        ImsLogUtil imsLogUtil=new ImsLogUtil();
        List<Map<String, String>> list=new ArrayList<>();
        Boolean success = false;
        Map<String,String> idmap=new HashMap<>();

        //设置需要同步的主键
        idmap.put("FSupplierId",object.toString());
        //将对应信息请求金蝶云
        list=supplierKingdeeApi.selectAndLog(idmap,null,"供应商信息");
        //如果集合非空
            //遍历集合拿到所有的MAP
            for (Map<String, String> data : list) {
                //判断是否有错误
                if(data.containsKey("false")){
                    return success;
                }
                //将实体信息记录下来
                ImsSupplier pojo = new ImsSupplier();
                pojo.setFid(data.get("fid"));
                pojo.setDisable(data.get("DISABLE"));
                pojo.setErpSupId(data.get("SUP_ID"));
                pojo.setOrgId(data.get("ORG_ID"));
                pojo.setSupId(data.get("SUP_ID"));
                pojo.setSupName(data.get("SUP_NAME"));
                pojo.setCreateTime(new Date());
                if(sysUser!=null){
                    pojo.setCreateBy(sysUser.getUsername());
                    pojo.setSysOrgCode(sysUser.getOrgCode());
                }
                pojolist.add(pojo);
            }
                //将数据信息 存放到数据库
                this.saveBatch(pojolist);
                //将数据包装成IMS格式
                Map<String,Object> map=new HashMap<>();
                map.put("success","true");
                map.put("message","操作成功");
                map.put("result", list);
                String mapjson = JsonUtil.Mapjson(map);
        String request=JsonUtil.Listjson(list);
                String body = ImsUtil.getIms("TB_BS_SUP",mapjson);
                //IMS同步
                String result = imsApi.add(body);
                //记录IMS日志
                Boolean flag = imsLogUtil.ImsLog(body,result, "供应商信息","TB_BS_SUP");
                //设置同步成功状态
                success=flag;
//                success=true;

        return success;
    }

    @Override
    public Boolean grid(Map<String, String> stringStringMap) throws ParseException {
        return null;
    }

    @Override
    public List<Map<String, String>> queryList(Integer pageNo, Integer pageSize) throws ParseException {
        List<Map<String, String>> list = supplierKingdeeApi.queryList(null, null, "供应商信息分页查询", pageNo, pageSize);
        return list;
    }

}
